/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.InventoryItem;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="InventoryReport", profile="http://hl7.org/fhir/StructureDefinition/InventoryReport")
public class InventoryReport
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier for the report", formalDefinition="Business identifier for the InventoryReport.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | requested | active | entered-in-error", formalDefinition="The status of the inventory check or notification - whether this is draft (e.g. the report is still pending some updates) or active.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/inventoryreport-status")
    protected Enumeration<InventoryReportStatus> status;
    @Child(name="countType", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="snapshot | difference", formalDefinition="Whether the report is about the current inventory count (snapshot) or a differential change in inventory (change).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/inventoryreport-counttype")
    protected Enumeration<InventoryCountType> countType;
    @Child(name="operationType", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="addition | subtraction", formalDefinition="What type of operation is being performed - addition or subtraction.")
    protected CodeableConcept operationType;
    @Child(name="operationTypeReason", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The reason for this count - regular count, ad-hoc count, new arrivals, etc", formalDefinition="The reason for this count - regular count, ad-hoc count, new arrivals, etc.")
    protected CodeableConcept operationTypeReason;
    @Child(name="reportedDateTime", type={DateTimeType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the report has been submitted", formalDefinition="When the report has been submitted.")
    protected DateTimeType reportedDateTime;
    @Child(name="reporter", type={Practitioner.class, Patient.class, RelatedPerson.class, Device.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who submits the report", formalDefinition="Who submits the report.")
    protected Reference reporter;
    @Child(name="reportingPeriod", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The period the report refers to", formalDefinition="The period the report refers to.")
    protected Period reportingPeriod;
    @Child(name="inventoryListing", type={}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An inventory listing section (grouped by any of the attributes)", formalDefinition="An inventory listing section (grouped by any of the attributes).")
    protected List<InventoryReportInventoryListingComponent> inventoryListing;
    @Child(name="note", type={Annotation.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A note associated with the InventoryReport", formalDefinition="A note associated with the InventoryReport.")
    protected List<Annotation> note;
    private static final long serialVersionUID = 539262671L;
    @SearchParamDefinition(name="identifier", path="InventoryReport.identifier", description="Search by identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="item-reference", path="InventoryReport.inventoryListing.item.item.reference", description="Search by items in inventory report", type="reference", target={BiologicallyDerivedProduct.class, Device.class, InventoryItem.class, Medication.class, NutritionProduct.class})
    public static final String SP_ITEM_REFERENCE = "item-reference";
    public static final ReferenceClientParam ITEM_REFERENCE = new ReferenceClientParam("item-reference");
    public static final Include INCLUDE_ITEM_REFERENCE = new Include("InventoryReport:item-reference").toLocked();
    @SearchParamDefinition(name="item", path="InventoryReport.inventoryListing.item.item.concept", description="Search by items in inventory report", type="token")
    public static final String SP_ITEM = "item";
    public static final TokenClientParam ITEM = new TokenClientParam("item");
    @SearchParamDefinition(name="status", path="InventoryReport.status", description="Search by status", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public InventoryReport() {
    }

    public InventoryReport(InventoryReportStatus status, InventoryCountType countType, Date reportedDateTime) {
        this.setStatus(status);
        this.setCountType(countType);
        this.setReportedDateTime(reportedDateTime);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public InventoryReport setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public InventoryReport addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<InventoryReportStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<InventoryReportStatus>(new InventoryReportStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public InventoryReport setStatusElement(Enumeration<InventoryReportStatus> value) {
        this.status = value;
        return this;
    }

    public InventoryReportStatus getStatus() {
        return this.status == null ? null : (InventoryReportStatus)((Object)this.status.getValue());
    }

    public InventoryReport setStatus(InventoryReportStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<InventoryReportStatus>(new InventoryReportStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<InventoryCountType> getCountTypeElement() {
        if (this.countType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.countType");
            }
            if (Configuration.doAutoCreate()) {
                this.countType = new Enumeration<InventoryCountType>(new InventoryCountTypeEnumFactory());
            }
        }
        return this.countType;
    }

    public boolean hasCountTypeElement() {
        return this.countType != null && !this.countType.isEmpty();
    }

    public boolean hasCountType() {
        return this.countType != null && !this.countType.isEmpty();
    }

    public InventoryReport setCountTypeElement(Enumeration<InventoryCountType> value) {
        this.countType = value;
        return this;
    }

    public InventoryCountType getCountType() {
        return this.countType == null ? null : (InventoryCountType)((Object)this.countType.getValue());
    }

    public InventoryReport setCountType(InventoryCountType value) {
        if (this.countType == null) {
            this.countType = new Enumeration<InventoryCountType>(new InventoryCountTypeEnumFactory());
        }
        this.countType.setValue((Object)value);
        return this;
    }

    public CodeableConcept getOperationType() {
        if (this.operationType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.operationType");
            }
            if (Configuration.doAutoCreate()) {
                this.operationType = new CodeableConcept();
            }
        }
        return this.operationType;
    }

    public boolean hasOperationType() {
        return this.operationType != null && !this.operationType.isEmpty();
    }

    public InventoryReport setOperationType(CodeableConcept value) {
        this.operationType = value;
        return this;
    }

    public CodeableConcept getOperationTypeReason() {
        if (this.operationTypeReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.operationTypeReason");
            }
            if (Configuration.doAutoCreate()) {
                this.operationTypeReason = new CodeableConcept();
            }
        }
        return this.operationTypeReason;
    }

    public boolean hasOperationTypeReason() {
        return this.operationTypeReason != null && !this.operationTypeReason.isEmpty();
    }

    public InventoryReport setOperationTypeReason(CodeableConcept value) {
        this.operationTypeReason = value;
        return this;
    }

    public DateTimeType getReportedDateTimeElement() {
        if (this.reportedDateTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.reportedDateTime");
            }
            if (Configuration.doAutoCreate()) {
                this.reportedDateTime = new DateTimeType();
            }
        }
        return this.reportedDateTime;
    }

    public boolean hasReportedDateTimeElement() {
        return this.reportedDateTime != null && !this.reportedDateTime.isEmpty();
    }

    public boolean hasReportedDateTime() {
        return this.reportedDateTime != null && !this.reportedDateTime.isEmpty();
    }

    public InventoryReport setReportedDateTimeElement(DateTimeType value) {
        this.reportedDateTime = value;
        return this;
    }

    public Date getReportedDateTime() {
        return this.reportedDateTime == null ? null : (Date)this.reportedDateTime.getValue();
    }

    public InventoryReport setReportedDateTime(Date value) {
        if (this.reportedDateTime == null) {
            this.reportedDateTime = new DateTimeType();
        }
        this.reportedDateTime.setValue(value);
        return this;
    }

    public Reference getReporter() {
        if (this.reporter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.reporter");
            }
            if (Configuration.doAutoCreate()) {
                this.reporter = new Reference();
            }
        }
        return this.reporter;
    }

    public boolean hasReporter() {
        return this.reporter != null && !this.reporter.isEmpty();
    }

    public InventoryReport setReporter(Reference value) {
        this.reporter = value;
        return this;
    }

    public Period getReportingPeriod() {
        if (this.reportingPeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create InventoryReport.reportingPeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.reportingPeriod = new Period();
            }
        }
        return this.reportingPeriod;
    }

    public boolean hasReportingPeriod() {
        return this.reportingPeriod != null && !this.reportingPeriod.isEmpty();
    }

    public InventoryReport setReportingPeriod(Period value) {
        this.reportingPeriod = value;
        return this;
    }

    public List<InventoryReportInventoryListingComponent> getInventoryListing() {
        if (this.inventoryListing == null) {
            this.inventoryListing = new ArrayList<InventoryReportInventoryListingComponent>();
        }
        return this.inventoryListing;
    }

    public InventoryReport setInventoryListing(List<InventoryReportInventoryListingComponent> theInventoryListing) {
        this.inventoryListing = theInventoryListing;
        return this;
    }

    public boolean hasInventoryListing() {
        if (this.inventoryListing == null) {
            return false;
        }
        for (InventoryReportInventoryListingComponent item : this.inventoryListing) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public InventoryReportInventoryListingComponent addInventoryListing() {
        InventoryReportInventoryListingComponent t = new InventoryReportInventoryListingComponent();
        if (this.inventoryListing == null) {
            this.inventoryListing = new ArrayList<InventoryReportInventoryListingComponent>();
        }
        this.inventoryListing.add(t);
        return t;
    }

    public InventoryReport addInventoryListing(InventoryReportInventoryListingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.inventoryListing == null) {
            this.inventoryListing = new ArrayList<InventoryReportInventoryListingComponent>();
        }
        this.inventoryListing.add(t);
        return this;
    }

    public InventoryReportInventoryListingComponent getInventoryListingFirstRep() {
        if (this.getInventoryListing().isEmpty()) {
            this.addInventoryListing();
        }
        return this.getInventoryListing().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public InventoryReport setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public InventoryReport addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifier for the InventoryReport.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The status of the inventory check or notification - whether this is draft (e.g. the report is still pending some updates) or active.", 0, 1, this.status));
        children.add(new Property("countType", "code", "Whether the report is about the current inventory count (snapshot) or a differential change in inventory (change).", 0, 1, this.countType));
        children.add(new Property("operationType", "CodeableConcept", "What type of operation is being performed - addition or subtraction.", 0, 1, this.operationType));
        children.add(new Property("operationTypeReason", "CodeableConcept", "The reason for this count - regular count, ad-hoc count, new arrivals, etc.", 0, 1, this.operationTypeReason));
        children.add(new Property("reportedDateTime", "dateTime", "When the report has been submitted.", 0, 1, this.reportedDateTime));
        children.add(new Property("reporter", "Reference(Practitioner|Patient|RelatedPerson|Device)", "Who submits the report.", 0, 1, this.reporter));
        children.add(new Property("reportingPeriod", "Period", "The period the report refers to.", 0, 1, this.reportingPeriod));
        children.add(new Property("inventoryListing", "", "An inventory listing section (grouped by any of the attributes).", 0, Integer.MAX_VALUE, this.inventoryListing));
        children.add(new Property("note", "Annotation", "A note associated with the InventoryReport.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifier for the InventoryReport.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the inventory check or notification - whether this is draft (e.g. the report is still pending some updates) or active.", 0, 1, this.status);
            }
            case 1351759081: {
                return new Property("countType", "code", "Whether the report is about the current inventory count (snapshot) or a differential change in inventory (change).", 0, 1, this.countType);
            }
            case 91999553: {
                return new Property("operationType", "CodeableConcept", "What type of operation is being performed - addition or subtraction.", 0, 1, this.operationType);
            }
            case 449681125: {
                return new Property("operationTypeReason", "CodeableConcept", "The reason for this count - regular count, ad-hoc count, new arrivals, etc.", 0, 1, this.operationTypeReason);
            }
            case -1048250994: {
                return new Property("reportedDateTime", "dateTime", "When the report has been submitted.", 0, 1, this.reportedDateTime);
            }
            case -427039519: {
                return new Property("reporter", "Reference(Practitioner|Patient|RelatedPerson|Device)", "Who submits the report.", 0, 1, this.reporter);
            }
            case 409685391: {
                return new Property("reportingPeriod", "Period", "The period the report refers to.", 0, 1, this.reportingPeriod);
            }
            case -1764804216: {
                return new Property("inventoryListing", "", "An inventory listing section (grouped by any of the attributes).", 0, Integer.MAX_VALUE, this.inventoryListing);
            }
            case 3387378: {
                return new Property("note", "Annotation", "A note associated with the InventoryReport.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1351759081: {
                Base[] baseArray;
                if (this.countType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.countType;
                }
                return baseArray;
            }
            case 91999553: {
                Base[] baseArray;
                if (this.operationType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.operationType;
                }
                return baseArray;
            }
            case 449681125: {
                Base[] baseArray;
                if (this.operationTypeReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.operationTypeReason;
                }
                return baseArray;
            }
            case -1048250994: {
                Base[] baseArray;
                if (this.reportedDateTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.reportedDateTime;
                }
                return baseArray;
            }
            case -427039519: {
                Base[] baseArray;
                if (this.reporter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.reporter;
                }
                return baseArray;
            }
            case 409685391: {
                Base[] baseArray;
                if (this.reportingPeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.reportingPeriod;
                }
                return baseArray;
            }
            case -1764804216: {
                return this.inventoryListing == null ? new Base[]{} : this.inventoryListing.toArray(new Base[this.inventoryListing.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new InventoryReportStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 1351759081: {
                value = new InventoryCountTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.countType = value;
                return value;
            }
            case 91999553: {
                this.operationType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 449681125: {
                this.operationTypeReason = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1048250994: {
                this.reportedDateTime = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -427039519: {
                this.reporter = TypeConvertor.castToReference(value);
                return value;
            }
            case 409685391: {
                this.reportingPeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -1764804216: {
                this.getInventoryListing().add((InventoryReportInventoryListingComponent)((Object)value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new InventoryReportStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("countType")) {
            value = new InventoryCountTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.countType = value;
        } else if (name.equals("operationType")) {
            this.operationType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("operationTypeReason")) {
            this.operationTypeReason = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("reportedDateTime")) {
            this.reportedDateTime = TypeConvertor.castToDateTime(value);
        } else if (name.equals("reporter")) {
            this.reporter = TypeConvertor.castToReference(value);
        } else if (name.equals("reportingPeriod")) {
            this.reportingPeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("inventoryListing")) {
            this.getInventoryListing().add((InventoryReportInventoryListingComponent)((Object)value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_STATUS)) {
            value = new InventoryReportStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("countType")) {
            value = new InventoryCountTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.countType = value;
        } else if (name.equals("operationType")) {
            this.operationType = null;
        } else if (name.equals("operationTypeReason")) {
            this.operationTypeReason = null;
        } else if (name.equals("reportedDateTime")) {
            this.reportedDateTime = null;
        } else if (name.equals("reporter")) {
            this.reporter = null;
        } else if (name.equals("reportingPeriod")) {
            this.reportingPeriod = null;
        } else if (name.equals("inventoryListing")) {
            this.getInventoryListing().remove((InventoryReportInventoryListingComponent)((Object)value));
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1351759081: {
                return this.getCountTypeElement();
            }
            case 91999553: {
                return this.getOperationType();
            }
            case 449681125: {
                return this.getOperationTypeReason();
            }
            case -1048250994: {
                return this.getReportedDateTimeElement();
            }
            case -427039519: {
                return this.getReporter();
            }
            case 409685391: {
                return this.getReportingPeriod();
            }
            case -1764804216: {
                return this.addInventoryListing();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1351759081: {
                return new String[]{"code"};
            }
            case 91999553: {
                return new String[]{"CodeableConcept"};
            }
            case 449681125: {
                return new String[]{"CodeableConcept"};
            }
            case -1048250994: {
                return new String[]{"dateTime"};
            }
            case -427039519: {
                return new String[]{"Reference"};
            }
            case 409685391: {
                return new String[]{"Period"};
            }
            case -1764804216: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property InventoryReport.status");
        }
        if (name.equals("countType")) {
            throw new FHIRException("Cannot call addChild on a singleton property InventoryReport.countType");
        }
        if (name.equals("operationType")) {
            this.operationType = new CodeableConcept();
            return this.operationType;
        }
        if (name.equals("operationTypeReason")) {
            this.operationTypeReason = new CodeableConcept();
            return this.operationTypeReason;
        }
        if (name.equals("reportedDateTime")) {
            throw new FHIRException("Cannot call addChild on a singleton property InventoryReport.reportedDateTime");
        }
        if (name.equals("reporter")) {
            this.reporter = new Reference();
            return this.reporter;
        }
        if (name.equals("reportingPeriod")) {
            this.reportingPeriod = new Period();
            return this.reportingPeriod;
        }
        if (name.equals("inventoryListing")) {
            return this.addInventoryListing();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "InventoryReport";
    }

    @Override
    public InventoryReport copy() {
        InventoryReport dst = new InventoryReport();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(InventoryReport dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.countType = this.countType == null ? null : this.countType.copy();
        dst.operationType = this.operationType == null ? null : this.operationType.copy();
        dst.operationTypeReason = this.operationTypeReason == null ? null : this.operationTypeReason.copy();
        dst.reportedDateTime = this.reportedDateTime == null ? null : this.reportedDateTime.copy();
        dst.reporter = this.reporter == null ? null : this.reporter.copy();
        Period period = dst.reportingPeriod = this.reportingPeriod == null ? null : this.reportingPeriod.copy();
        if (this.inventoryListing != null) {
            dst.inventoryListing = new ArrayList<InventoryReportInventoryListingComponent>();
            for (InventoryReportInventoryListingComponent inventoryReportInventoryListingComponent : this.inventoryListing) {
                dst.inventoryListing.add(inventoryReportInventoryListingComponent.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
    }

    protected InventoryReport typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof InventoryReport)) {
            return false;
        }
        InventoryReport o = (InventoryReport)other_;
        return InventoryReport.compareDeep(this.identifier, o.identifier, true) && InventoryReport.compareDeep(this.status, o.status, true) && InventoryReport.compareDeep(this.countType, o.countType, true) && InventoryReport.compareDeep(this.operationType, o.operationType, true) && InventoryReport.compareDeep(this.operationTypeReason, o.operationTypeReason, true) && InventoryReport.compareDeep(this.reportedDateTime, o.reportedDateTime, true) && InventoryReport.compareDeep(this.reporter, o.reporter, true) && InventoryReport.compareDeep(this.reportingPeriod, o.reportingPeriod, true) && InventoryReport.compareDeep(this.inventoryListing, o.inventoryListing, true) && InventoryReport.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof InventoryReport)) {
            return false;
        }
        InventoryReport o = (InventoryReport)other_;
        return InventoryReport.compareValues(this.status, o.status, true) && InventoryReport.compareValues(this.countType, o.countType, true) && InventoryReport.compareValues(this.reportedDateTime, o.reportedDateTime, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.countType, this.operationType, this.operationTypeReason, this.reportedDateTime, this.reporter, this.reportingPeriod, this.inventoryListing, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.InventoryReport;
    }

    @Block
    public static class InventoryReportInventoryListingItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="category", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The inventory category or classification of the items being reported", formalDefinition="The inventory category or classification of the items being reported. This is meant not for defining the product, but for inventory categories e.g. 'pending recount' or 'damaged'.")
        protected CodeableConcept category;
        @Child(name="quantity", type={Quantity.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The quantity of the item or items being reported", formalDefinition="The quantity of the item or items being reported.")
        protected Quantity quantity;
        @Child(name="item", type={CodeableReference.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The code or reference to the item type", formalDefinition="The code or reference to the item type.")
        protected CodeableReference item;
        private static final long serialVersionUID = 566223460L;

        public InventoryReportInventoryListingItemComponent() {
        }

        public InventoryReportInventoryListingItemComponent(Quantity quantity, CodeableReference item) {
            this.setQuantity(quantity);
            this.setItem(item);
        }

        public CodeableConcept getCategory() {
            if (this.category == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingItemComponent.category");
                }
                if (Configuration.doAutoCreate()) {
                    this.category = new CodeableConcept();
                }
            }
            return this.category;
        }

        public boolean hasCategory() {
            return this.category != null && !this.category.isEmpty();
        }

        public InventoryReportInventoryListingItemComponent setCategory(CodeableConcept value) {
            this.category = value;
            return this;
        }

        public Quantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new Quantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public InventoryReportInventoryListingItemComponent setQuantity(Quantity value) {
            this.quantity = value;
            return this;
        }

        public CodeableReference getItem() {
            if (this.item == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingItemComponent.item");
                }
                if (Configuration.doAutoCreate()) {
                    this.item = new CodeableReference();
                }
            }
            return this.item;
        }

        public boolean hasItem() {
            return this.item != null && !this.item.isEmpty();
        }

        public InventoryReportInventoryListingItemComponent setItem(CodeableReference value) {
            this.item = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("category", "CodeableConcept", "The inventory category or classification of the items being reported. This is meant not for defining the product, but for inventory categories e.g. 'pending recount' or 'damaged'.", 0, 1, this.category));
            children.add(new Property("quantity", "Quantity", "The quantity of the item or items being reported.", 0, 1, this.quantity));
            children.add(new Property(InventoryReport.SP_ITEM, "CodeableReference(Medication|Device|Medication|NutritionProduct|InventoryItem|BiologicallyDerivedProduct|InventoryItem)", "The code or reference to the item type.", 0, 1, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 50511102: {
                    return new Property("category", "CodeableConcept", "The inventory category or classification of the items being reported. This is meant not for defining the product, but for inventory categories e.g. 'pending recount' or 'damaged'.", 0, 1, this.category);
                }
                case -1285004149: {
                    return new Property("quantity", "Quantity", "The quantity of the item or items being reported.", 0, 1, this.quantity);
                }
                case 3242771: {
                    return new Property(InventoryReport.SP_ITEM, "CodeableReference(Medication|Device|Medication|NutritionProduct|InventoryItem|BiologicallyDerivedProduct|InventoryItem)", "The code or reference to the item type.", 0, 1, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    Base[] baseArray;
                    if (this.category == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.category;
                    }
                    return baseArray;
                }
                case -1285004149: {
                    Base[] baseArray;
                    if (this.quantity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.quantity;
                    }
                    return baseArray;
                }
                case 3242771: {
                    Base[] baseArray;
                    if (this.item == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.item;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    this.category = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1285004149: {
                    this.quantity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case 3242771: {
                    this.item = TypeConvertor.castToCodeableReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("quantity")) {
                this.quantity = TypeConvertor.castToQuantity(value);
            } else if (name.equals(InventoryReport.SP_ITEM)) {
                this.item = TypeConvertor.castToCodeableReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("category")) {
                this.category = null;
            } else if (name.equals("quantity")) {
                this.quantity = null;
            } else if (name.equals(InventoryReport.SP_ITEM)) {
                this.item = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return this.getCategory();
                }
                case -1285004149: {
                    return this.getQuantity();
                }
                case 3242771: {
                    return this.getItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 50511102: {
                    return new String[]{"CodeableConcept"};
                }
                case -1285004149: {
                    return new String[]{"Quantity"};
                }
                case 3242771: {
                    return new String[]{"CodeableReference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("category")) {
                this.category = new CodeableConcept();
                return this.category;
            }
            if (name.equals("quantity")) {
                this.quantity = new Quantity();
                return this.quantity;
            }
            if (name.equals(InventoryReport.SP_ITEM)) {
                this.item = new CodeableReference();
                return this.item;
            }
            return super.addChild(name);
        }

        @Override
        public InventoryReportInventoryListingItemComponent copy() {
            InventoryReportInventoryListingItemComponent dst = new InventoryReportInventoryListingItemComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InventoryReportInventoryListingItemComponent dst) {
            super.copyValues(dst);
            dst.category = this.category == null ? null : this.category.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.item = this.item == null ? null : this.item.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryReportInventoryListingItemComponent)) {
                return false;
            }
            InventoryReportInventoryListingItemComponent o = (InventoryReportInventoryListingItemComponent)other_;
            return InventoryReportInventoryListingItemComponent.compareDeep(this.category, o.category, true) && InventoryReportInventoryListingItemComponent.compareDeep(this.quantity, o.quantity, true) && InventoryReportInventoryListingItemComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryReportInventoryListingItemComponent)) {
                return false;
            }
            InventoryReportInventoryListingItemComponent o = (InventoryReportInventoryListingItemComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.category, this.quantity, this.item});
        }

        @Override
        public String fhirType() {
            return "InventoryReport.inventoryListing.item";
        }
    }

    @Block
    public static class InventoryReportInventoryListingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="location", type={Location.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location of the inventory items", formalDefinition="Location of the inventory items.")
        protected Reference location;
        @Child(name="itemStatus", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of the items that are being reported", formalDefinition="The status of the items.")
        protected CodeableConcept itemStatus;
        @Child(name="countingDateTime", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The date and time when the items were counted", formalDefinition="The date and time when the items were counted.")
        protected DateTimeType countingDateTime;
        @Child(name="item", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The item or items in this listing", formalDefinition="The item or items in this listing.")
        protected List<InventoryReportInventoryListingItemComponent> item;
        private static final long serialVersionUID = 1766136476L;

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public InventoryReportInventoryListingComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public CodeableConcept getItemStatus() {
            if (this.itemStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingComponent.itemStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.itemStatus = new CodeableConcept();
                }
            }
            return this.itemStatus;
        }

        public boolean hasItemStatus() {
            return this.itemStatus != null && !this.itemStatus.isEmpty();
        }

        public InventoryReportInventoryListingComponent setItemStatus(CodeableConcept value) {
            this.itemStatus = value;
            return this;
        }

        public DateTimeType getCountingDateTimeElement() {
            if (this.countingDateTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create InventoryReportInventoryListingComponent.countingDateTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.countingDateTime = new DateTimeType();
                }
            }
            return this.countingDateTime;
        }

        public boolean hasCountingDateTimeElement() {
            return this.countingDateTime != null && !this.countingDateTime.isEmpty();
        }

        public boolean hasCountingDateTime() {
            return this.countingDateTime != null && !this.countingDateTime.isEmpty();
        }

        public InventoryReportInventoryListingComponent setCountingDateTimeElement(DateTimeType value) {
            this.countingDateTime = value;
            return this;
        }

        public Date getCountingDateTime() {
            return this.countingDateTime == null ? null : (Date)this.countingDateTime.getValue();
        }

        public InventoryReportInventoryListingComponent setCountingDateTime(Date value) {
            if (value == null) {
                this.countingDateTime = null;
            } else {
                if (this.countingDateTime == null) {
                    this.countingDateTime = new DateTimeType();
                }
                this.countingDateTime.setValue(value);
            }
            return this;
        }

        public List<InventoryReportInventoryListingItemComponent> getItem() {
            if (this.item == null) {
                this.item = new ArrayList<InventoryReportInventoryListingItemComponent>();
            }
            return this.item;
        }

        public InventoryReportInventoryListingComponent setItem(List<InventoryReportInventoryListingItemComponent> theItem) {
            this.item = theItem;
            return this;
        }

        public boolean hasItem() {
            if (this.item == null) {
                return false;
            }
            for (InventoryReportInventoryListingItemComponent item : this.item) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public InventoryReportInventoryListingItemComponent addItem() {
            InventoryReportInventoryListingItemComponent t = new InventoryReportInventoryListingItemComponent();
            if (this.item == null) {
                this.item = new ArrayList<InventoryReportInventoryListingItemComponent>();
            }
            this.item.add(t);
            return t;
        }

        public InventoryReportInventoryListingComponent addItem(InventoryReportInventoryListingItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.item == null) {
                this.item = new ArrayList<InventoryReportInventoryListingItemComponent>();
            }
            this.item.add(t);
            return this;
        }

        public InventoryReportInventoryListingItemComponent getItemFirstRep() {
            if (this.getItem().isEmpty()) {
                this.addItem();
            }
            return this.getItem().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("location", "Reference(Location)", "Location of the inventory items.", 0, 1, this.location));
            children.add(new Property("itemStatus", "CodeableConcept", "The status of the items.", 0, 1, this.itemStatus));
            children.add(new Property("countingDateTime", "dateTime", "The date and time when the items were counted.", 0, 1, this.countingDateTime));
            children.add(new Property(InventoryReport.SP_ITEM, "", "The item or items in this listing.", 0, Integer.MAX_VALUE, this.item));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1901043637: {
                    return new Property("location", "Reference(Location)", "Location of the inventory items.", 0, 1, this.location);
                }
                case 1999789285: {
                    return new Property("itemStatus", "CodeableConcept", "The status of the items.", 0, 1, this.itemStatus);
                }
                case -2075203282: {
                    return new Property("countingDateTime", "dateTime", "The date and time when the items were counted.", 0, 1, this.countingDateTime);
                }
                case 3242771: {
                    return new Property(InventoryReport.SP_ITEM, "", "The item or items in this listing.", 0, Integer.MAX_VALUE, this.item);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.location;
                    }
                    return baseArray;
                }
                case 1999789285: {
                    Base[] baseArray;
                    if (this.itemStatus == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.itemStatus;
                    }
                    return baseArray;
                }
                case -2075203282: {
                    Base[] baseArray;
                    if (this.countingDateTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.countingDateTime;
                    }
                    return baseArray;
                }
                case 3242771: {
                    return this.item == null ? new Base[]{} : this.item.toArray(new Base[this.item.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    this.location = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1999789285: {
                    this.itemStatus = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -2075203282: {
                    this.countingDateTime = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 3242771: {
                    this.getItem().add((InventoryReportInventoryListingItemComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("location")) {
                this.location = TypeConvertor.castToReference(value);
            } else if (name.equals("itemStatus")) {
                this.itemStatus = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("countingDateTime")) {
                this.countingDateTime = TypeConvertor.castToDateTime(value);
            } else if (name.equals(InventoryReport.SP_ITEM)) {
                this.getItem().add((InventoryReportInventoryListingItemComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("location")) {
                this.location = null;
            } else if (name.equals("itemStatus")) {
                this.itemStatus = null;
            } else if (name.equals("countingDateTime")) {
                this.countingDateTime = null;
            } else if (name.equals(InventoryReport.SP_ITEM)) {
                this.getItem().remove((InventoryReportInventoryListingItemComponent)value);
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return this.getLocation();
                }
                case 1999789285: {
                    return this.getItemStatus();
                }
                case -2075203282: {
                    return this.getCountingDateTimeElement();
                }
                case 3242771: {
                    return this.addItem();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return new String[]{"Reference"};
                }
                case 1999789285: {
                    return new String[]{"CodeableConcept"};
                }
                case -2075203282: {
                    return new String[]{"dateTime"};
                }
                case 3242771: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("location")) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals("itemStatus")) {
                this.itemStatus = new CodeableConcept();
                return this.itemStatus;
            }
            if (name.equals("countingDateTime")) {
                throw new FHIRException("Cannot call addChild on a singleton property InventoryReport.inventoryListing.countingDateTime");
            }
            if (name.equals(InventoryReport.SP_ITEM)) {
                return this.addItem();
            }
            return super.addChild(name);
        }

        @Override
        public InventoryReportInventoryListingComponent copy() {
            InventoryReportInventoryListingComponent dst = new InventoryReportInventoryListingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(InventoryReportInventoryListingComponent dst) {
            super.copyValues(dst);
            dst.location = this.location == null ? null : this.location.copy();
            dst.itemStatus = this.itemStatus == null ? null : this.itemStatus.copy();
            DateTimeType dateTimeType = dst.countingDateTime = this.countingDateTime == null ? null : this.countingDateTime.copy();
            if (this.item != null) {
                dst.item = new ArrayList<InventoryReportInventoryListingItemComponent>();
                for (InventoryReportInventoryListingItemComponent i : this.item) {
                    dst.item.add(i.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryReportInventoryListingComponent)) {
                return false;
            }
            InventoryReportInventoryListingComponent o = (InventoryReportInventoryListingComponent)other_;
            return InventoryReportInventoryListingComponent.compareDeep(this.location, o.location, true) && InventoryReportInventoryListingComponent.compareDeep(this.itemStatus, o.itemStatus, true) && InventoryReportInventoryListingComponent.compareDeep(this.countingDateTime, o.countingDateTime, true) && InventoryReportInventoryListingComponent.compareDeep(this.item, o.item, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof InventoryReportInventoryListingComponent)) {
                return false;
            }
            InventoryReportInventoryListingComponent o = (InventoryReportInventoryListingComponent)other_;
            return InventoryReportInventoryListingComponent.compareValues(this.countingDateTime, o.countingDateTime, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.location, this.itemStatus, this.countingDateTime, this.item});
        }

        @Override
        public String fhirType() {
            return "InventoryReport.inventoryListing";
        }
    }

    public static class InventoryReportStatusEnumFactory
    implements EnumFactory<InventoryReportStatus> {
        @Override
        public InventoryReportStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return InventoryReportStatus.DRAFT;
            }
            if ("requested".equals(codeString)) {
                return InventoryReportStatus.REQUESTED;
            }
            if ("active".equals(codeString)) {
                return InventoryReportStatus.ACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return InventoryReportStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown InventoryReportStatus code '" + codeString + "'");
        }

        public Enumeration<InventoryReportStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<InventoryReportStatus>(this, InventoryReportStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<InventoryReportStatus>(this, InventoryReportStatus.NULL, code);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<InventoryReportStatus>(this, InventoryReportStatus.DRAFT, code);
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<InventoryReportStatus>(this, InventoryReportStatus.REQUESTED, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<InventoryReportStatus>(this, InventoryReportStatus.ACTIVE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<InventoryReportStatus>(this, InventoryReportStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown InventoryReportStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(InventoryReportStatus code) {
            if (code == InventoryReportStatus.DRAFT) {
                return "draft";
            }
            if (code == InventoryReportStatus.REQUESTED) {
                return "requested";
            }
            if (code == InventoryReportStatus.ACTIVE) {
                return "active";
            }
            if (code == InventoryReportStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(InventoryReportStatus code) {
            return code.getSystem();
        }
    }

    public static enum InventoryReportStatus {
        DRAFT,
        REQUESTED,
        ACTIVE,
        ENTEREDINERROR,
        NULL;


        public static InventoryReportStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown InventoryReportStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case REQUESTED: {
                    return "requested";
                }
                case ACTIVE: {
                    return "active";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/inventoryreport-status";
                }
                case REQUESTED: {
                    return "http://hl7.org/fhir/inventoryreport-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/inventoryreport-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/inventoryreport-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The existence of the report is registered, but it is still without content or only some preliminary content.";
                }
                case REQUESTED: {
                    return "The inventory report has been requested but there is no data available.";
                }
                case ACTIVE: {
                    return "This report is submitted as current.";
                }
                case ENTEREDINERROR: {
                    return "The report has been withdrawn following a previous final release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case REQUESTED: {
                    return "Requested";
                }
                case ACTIVE: {
                    return "Active";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class InventoryCountTypeEnumFactory
    implements EnumFactory<InventoryCountType> {
        @Override
        public InventoryCountType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("snapshot".equals(codeString)) {
                return InventoryCountType.SNAPSHOT;
            }
            if ("difference".equals(codeString)) {
                return InventoryCountType.DIFFERENCE;
            }
            throw new IllegalArgumentException("Unknown InventoryCountType code '" + codeString + "'");
        }

        public Enumeration<InventoryCountType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<InventoryCountType>(this, InventoryCountType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<InventoryCountType>(this, InventoryCountType.NULL, code);
            }
            if ("snapshot".equals(codeString)) {
                return new Enumeration<InventoryCountType>(this, InventoryCountType.SNAPSHOT, code);
            }
            if ("difference".equals(codeString)) {
                return new Enumeration<InventoryCountType>(this, InventoryCountType.DIFFERENCE, code);
            }
            throw new FHIRException("Unknown InventoryCountType code '" + codeString + "'");
        }

        @Override
        public String toCode(InventoryCountType code) {
            if (code == InventoryCountType.SNAPSHOT) {
                return "snapshot";
            }
            if (code == InventoryCountType.DIFFERENCE) {
                return "difference";
            }
            return "?";
        }

        @Override
        public String toSystem(InventoryCountType code) {
            return code.getSystem();
        }
    }

    public static enum InventoryCountType {
        SNAPSHOT,
        DIFFERENCE,
        NULL;


        public static InventoryCountType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("snapshot".equals(codeString)) {
                return SNAPSHOT;
            }
            if ("difference".equals(codeString)) {
                return DIFFERENCE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown InventoryCountType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SNAPSHOT: {
                    return "snapshot";
                }
                case DIFFERENCE: {
                    return "difference";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SNAPSHOT: {
                    return "http://hl7.org/fhir/inventoryreport-counttype";
                }
                case DIFFERENCE: {
                    return "http://hl7.org/fhir/inventoryreport-counttype";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SNAPSHOT: {
                    return "The inventory report is a current absolute snapshot, i.e. it represents the quantities at hand.";
                }
                case DIFFERENCE: {
                    return "The inventory report is about the difference between a previous count and a current count, i.e. it represents the items that have been added/subtracted from inventory.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SNAPSHOT: {
                    return "Snapshot";
                }
                case DIFFERENCE: {
                    return "Difference";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

