/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.VisionPrescription;

@ResourceDef(name="GuidanceResponse", profile="http://hl7.org/fhir/StructureDefinition/GuidanceResponse")
public class GuidanceResponse
extends DomainResource {
    @Child(name="requestIdentifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The identifier of the request associated with this response, if any", formalDefinition="The identifier of the request associated with this response. If an identifier was given as part of the request, it will be reproduced here to enable the requester to more easily identify the response in a multi-request scenario.")
    protected Identifier requestIdentifier;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="Allows a service to provide  unique, business identifiers for the response.")
    protected List<Identifier> identifier;
    @Child(name="module", type={UriType.class, CanonicalType.class, CodeableConcept.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What guidance was requested", formalDefinition="An identifier, CodeableConcept or canonical reference to the guidance that was requested.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/guidance-module-code")
    protected DataType module;
    @Child(name="status", type={CodeType.class}, order=3, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="success | data-requested | data-required | in-progress | failure | entered-in-error", formalDefinition="The status of the response. If the evaluation is completed successfully, the status will indicate success. However, in order to complete the evaluation, the engine may require more information. In this case, the status will be data-required, and the response will contain a description of the additional required information. If the evaluation completed successfully, but the engine determines that a potentially more accurate response could be provided if more data was available, the status will be data-requested, and the response will contain a description of the additional requested information.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/guidance-response-status")
    protected Enumeration<GuidanceResponseStatus> status;
    @Child(name="subject", type={Patient.class, Group.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Patient the request was performed for", formalDefinition="The patient for which the request was processed.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Encounter during which the response was returned", formalDefinition="The encounter during which this response was created or to which the creation of this record is tightly associated.")
    protected Reference encounter;
    @Child(name="occurrenceDateTime", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When the guidance response was processed", formalDefinition="Indicates when the guidance response was processed.")
    protected DateTimeType occurrenceDateTime;
    @Child(name="performer", type={Device.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Device returning the guidance", formalDefinition="Provides a reference to the device that performed the guidance.")
    protected Reference performer;
    @Child(name="reason", type={CodeableReference.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Why guidance is needed", formalDefinition="Describes the reason for the guidance response in coded or textual form, or Indicates the reason the request was initiated. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.")
    protected List<CodeableReference> reason;
    @Child(name="note", type={Annotation.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional notes about the response", formalDefinition="Provides a mechanism to communicate additional information about the response.")
    protected List<Annotation> note;
    @Child(name="evaluationMessage", type={OperationOutcome.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Messages resulting from the evaluation of the artifact or artifacts", formalDefinition="Messages resulting from the evaluation of the artifact or artifacts. As part of evaluating the request, the engine may produce informational or warning messages. These messages will be provided by this element.")
    protected Reference evaluationMessage;
    @Child(name="outputParameters", type={Parameters.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The output parameters of the evaluation, if any", formalDefinition="The output parameters of the evaluation, if any. Many modules will result in the return of specific resources such as procedure or communication requests that are returned as part of the operation result. However, modules may define specific outputs that would be returned as the result of the evaluation, and these would be returned in this element.")
    protected Reference outputParameters;
    @Child(name="result", type={Appointment.class, AppointmentResponse.class, CarePlan.class, Claim.class, CommunicationRequest.class, Contract.class, CoverageEligibilityRequest.class, DeviceRequest.class, EnrollmentRequest.class, ImmunizationRecommendation.class, MedicationRequest.class, NutritionOrder.class, RequestOrchestration.class, ServiceRequest.class, SupplyRequest.class, Task.class, VisionPrescription.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Proposed actions, if any", formalDefinition="The actions, if any, produced by the evaluation of the artifact.")
    protected List<Reference> result;
    @Child(name="dataRequirement", type={DataRequirement.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional required data", formalDefinition="If the evaluation could not be completed due to lack of information, or additional information would potentially result in a more accurate response, this element will a description of the data required in order to proceed with the evaluation. A subsequent request to the service should include this data.")
    protected List<DataRequirement> dataRequirement;
    private static final long serialVersionUID = 1439061923L;
    @SearchParamDefinition(name="request", path="GuidanceResponse.requestIdentifier", description="The identifier of the request associated with the response", type="token")
    public static final String SP_REQUEST = "request";
    public static final TokenClientParam REQUEST = new TokenClientParam("request");
    @SearchParamDefinition(name="status", path="GuidanceResponse.status", description="The status of the guidance response", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="GuidanceResponse.subject", description="The subject that the guidance response is about", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("GuidanceResponse:subject").toLocked();
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("GuidanceResponse:patient").toLocked();

    public GuidanceResponse() {
    }

    public GuidanceResponse(DataType module, GuidanceResponseStatus status) {
        this.setModule(module);
        this.setStatus(status);
    }

    public Identifier getRequestIdentifier() {
        if (this.requestIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.requestIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.requestIdentifier = new Identifier();
            }
        }
        return this.requestIdentifier;
    }

    public boolean hasRequestIdentifier() {
        return this.requestIdentifier != null && !this.requestIdentifier.isEmpty();
    }

    public GuidanceResponse setRequestIdentifier(Identifier value) {
        this.requestIdentifier = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public GuidanceResponse setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public GuidanceResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public DataType getModule() {
        return this.module;
    }

    public UriType getModuleUriType() throws FHIRException {
        if (this.module == null) {
            this.module = new UriType();
        }
        if (!(this.module instanceof UriType)) {
            throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.module.getClass().getName() + " was encountered");
        }
        return (UriType)this.module;
    }

    public boolean hasModuleUriType() {
        return this != null && this.module instanceof UriType;
    }

    public CanonicalType getModuleCanonicalType() throws FHIRException {
        if (this.module == null) {
            this.module = new CanonicalType();
        }
        if (!(this.module instanceof CanonicalType)) {
            throw new FHIRException("Type mismatch: the type CanonicalType was expected, but " + this.module.getClass().getName() + " was encountered");
        }
        return (CanonicalType)this.module;
    }

    public boolean hasModuleCanonicalType() {
        return this != null && this.module instanceof CanonicalType;
    }

    public CodeableConcept getModuleCodeableConcept() throws FHIRException {
        if (this.module == null) {
            this.module = new CodeableConcept();
        }
        if (!(this.module instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.module.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.module;
    }

    public boolean hasModuleCodeableConcept() {
        return this != null && this.module instanceof CodeableConcept;
    }

    public boolean hasModule() {
        return this.module != null && !this.module.isEmpty();
    }

    public GuidanceResponse setModule(DataType value) {
        if (!(value == null || value instanceof UriType || value instanceof CanonicalType || value instanceof CodeableConcept)) {
            throw new FHIRException("Not the right type for GuidanceResponse.module[x]: " + value.fhirType());
        }
        this.module = value;
        return this;
    }

    public Enumeration<GuidanceResponseStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<GuidanceResponseStatus>(new GuidanceResponseStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public GuidanceResponse setStatusElement(Enumeration<GuidanceResponseStatus> value) {
        this.status = value;
        return this;
    }

    public GuidanceResponseStatus getStatus() {
        return this.status == null ? null : (GuidanceResponseStatus)((Object)this.status.getValue());
    }

    public GuidanceResponse setStatus(GuidanceResponseStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<GuidanceResponseStatus>(new GuidanceResponseStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public GuidanceResponse setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public GuidanceResponse setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DateTimeType getOccurrenceDateTimeElement() {
        if (this.occurrenceDateTime == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.occurrenceDateTime");
            }
            if (Configuration.doAutoCreate()) {
                this.occurrenceDateTime = new DateTimeType();
            }
        }
        return this.occurrenceDateTime;
    }

    public boolean hasOccurrenceDateTimeElement() {
        return this.occurrenceDateTime != null && !this.occurrenceDateTime.isEmpty();
    }

    public boolean hasOccurrenceDateTime() {
        return this.occurrenceDateTime != null && !this.occurrenceDateTime.isEmpty();
    }

    public GuidanceResponse setOccurrenceDateTimeElement(DateTimeType value) {
        this.occurrenceDateTime = value;
        return this;
    }

    public Date getOccurrenceDateTime() {
        return this.occurrenceDateTime == null ? null : (Date)this.occurrenceDateTime.getValue();
    }

    public GuidanceResponse setOccurrenceDateTime(Date value) {
        if (value == null) {
            this.occurrenceDateTime = null;
        } else {
            if (this.occurrenceDateTime == null) {
                this.occurrenceDateTime = new DateTimeType();
            }
            this.occurrenceDateTime.setValue(value);
        }
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public GuidanceResponse setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public GuidanceResponse setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public GuidanceResponse addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public GuidanceResponse setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public GuidanceResponse addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public Reference getEvaluationMessage() {
        if (this.evaluationMessage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.evaluationMessage");
            }
            if (Configuration.doAutoCreate()) {
                this.evaluationMessage = new Reference();
            }
        }
        return this.evaluationMessage;
    }

    public boolean hasEvaluationMessage() {
        return this.evaluationMessage != null && !this.evaluationMessage.isEmpty();
    }

    public GuidanceResponse setEvaluationMessage(Reference value) {
        this.evaluationMessage = value;
        return this;
    }

    public Reference getOutputParameters() {
        if (this.outputParameters == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GuidanceResponse.outputParameters");
            }
            if (Configuration.doAutoCreate()) {
                this.outputParameters = new Reference();
            }
        }
        return this.outputParameters;
    }

    public boolean hasOutputParameters() {
        return this.outputParameters != null && !this.outputParameters.isEmpty();
    }

    public GuidanceResponse setOutputParameters(Reference value) {
        this.outputParameters = value;
        return this;
    }

    public List<Reference> getResult() {
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        return this.result;
    }

    public GuidanceResponse setResult(List<Reference> theResult) {
        this.result = theResult;
        return this;
    }

    public boolean hasResult() {
        if (this.result == null) {
            return false;
        }
        for (Reference item : this.result) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addResult() {
        Reference t = new Reference();
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        this.result.add(t);
        return t;
    }

    public GuidanceResponse addResult(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        this.result.add(t);
        return this;
    }

    public Reference getResultFirstRep() {
        if (this.getResult().isEmpty()) {
            this.addResult();
        }
        return this.getResult().get(0);
    }

    public List<DataRequirement> getDataRequirement() {
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        return this.dataRequirement;
    }

    public GuidanceResponse setDataRequirement(List<DataRequirement> theDataRequirement) {
        this.dataRequirement = theDataRequirement;
        return this;
    }

    public boolean hasDataRequirement() {
        if (this.dataRequirement == null) {
            return false;
        }
        for (DataRequirement item : this.dataRequirement) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DataRequirement addDataRequirement() {
        DataRequirement t = new DataRequirement();
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        this.dataRequirement.add(t);
        return t;
    }

    public GuidanceResponse addDataRequirement(DataRequirement t) {
        if (t == null) {
            return this;
        }
        if (this.dataRequirement == null) {
            this.dataRequirement = new ArrayList<DataRequirement>();
        }
        this.dataRequirement.add(t);
        return this;
    }

    public DataRequirement getDataRequirementFirstRep() {
        if (this.getDataRequirement().isEmpty()) {
            this.addDataRequirement();
        }
        return this.getDataRequirement().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("requestIdentifier", "Identifier", "The identifier of the request associated with this response. If an identifier was given as part of the request, it will be reproduced here to enable the requester to more easily identify the response in a multi-request scenario.", 0, 1, this.requestIdentifier));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Allows a service to provide  unique, business identifiers for the response.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("module[x]", "uri|canonical|CodeableConcept", "An identifier, CodeableConcept or canonical reference to the guidance that was requested.", 0, 1, this.module));
        children.add(new Property(SP_STATUS, "code", "The status of the response. If the evaluation is completed successfully, the status will indicate success. However, in order to complete the evaluation, the engine may require more information. In this case, the status will be data-required, and the response will contain a description of the additional required information. If the evaluation completed successfully, but the engine determines that a potentially more accurate response could be provided if more data was available, the status will be data-requested, and the response will contain a description of the additional requested information.", 0, 1, this.status));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient for which the request was processed.", 0, 1, this.subject));
        children.add(new Property("encounter", "Reference(Encounter)", "The encounter during which this response was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter));
        children.add(new Property("occurrenceDateTime", "dateTime", "Indicates when the guidance response was processed.", 0, 1, this.occurrenceDateTime));
        children.add(new Property("performer", "Reference(Device)", "Provides a reference to the device that performed the guidance.", 0, 1, this.performer));
        children.add(new Property("reason", "CodeableReference", "Describes the reason for the guidance response in coded or textual form, or Indicates the reason the request was initiated. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("note", "Annotation", "Provides a mechanism to communicate additional information about the response.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("evaluationMessage", "Reference(OperationOutcome)", "Messages resulting from the evaluation of the artifact or artifacts. As part of evaluating the request, the engine may produce informational or warning messages. These messages will be provided by this element.", 0, 1, this.evaluationMessage));
        children.add(new Property("outputParameters", "Reference(Parameters)", "The output parameters of the evaluation, if any. Many modules will result in the return of specific resources such as procedure or communication requests that are returned as part of the operation result. However, modules may define specific outputs that would be returned as the result of the evaluation, and these would be returned in this element.", 0, 1, this.outputParameters));
        children.add(new Property("result", "Reference(Appointment|AppointmentResponse|CarePlan|Claim|CommunicationRequest|Contract|CoverageEligibilityRequest|DeviceRequest|EnrollmentRequest|ImmunizationRecommendation|MedicationRequest|NutritionOrder|RequestOrchestration|ServiceRequest|SupplyRequest|Task|VisionPrescription)", "The actions, if any, produced by the evaluation of the artifact.", 0, Integer.MAX_VALUE, this.result));
        children.add(new Property("dataRequirement", "DataRequirement", "If the evaluation could not be completed due to lack of information, or additional information would potentially result in a more accurate response, this element will a description of the data required in order to proceed with the evaluation. A subsequent request to the service should include this data.", 0, Integer.MAX_VALUE, this.dataRequirement));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -354233192: {
                return new Property("requestIdentifier", "Identifier", "The identifier of the request associated with this response. If an identifier was given as part of the request, it will be reproduced here to enable the requester to more easily identify the response in a multi-request scenario.", 0, 1, this.requestIdentifier);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Allows a service to provide  unique, business identifiers for the response.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1552083308: {
                return new Property("module[x]", "uri|canonical|CodeableConcept", "An identifier, CodeableConcept or canonical reference to the guidance that was requested.", 0, 1, this.module);
            }
            case -1068784020: {
                return new Property("module[x]", "uri|canonical|CodeableConcept", "An identifier, CodeableConcept or canonical reference to the guidance that was requested.", 0, 1, this.module);
            }
            case -1552089248: {
                return new Property("module[x]", "uri", "An identifier, CodeableConcept or canonical reference to the guidance that was requested.", 0, 1, this.module);
            }
            case -1153656856: {
                return new Property("module[x]", "canonical", "An identifier, CodeableConcept or canonical reference to the guidance that was requested.", 0, 1, this.module);
            }
            case -1157899371: {
                return new Property("module[x]", "CodeableConcept", "An identifier, CodeableConcept or canonical reference to the guidance that was requested.", 0, 1, this.module);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the response. If the evaluation is completed successfully, the status will indicate success. However, in order to complete the evaluation, the engine may require more information. In this case, the status will be data-required, and the response will contain a description of the additional required information. If the evaluation completed successfully, but the engine determines that a potentially more accurate response could be provided if more data was available, the status will be data-requested, and the response will contain a description of the additional requested information.", 0, 1, this.status);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient for which the request was processed.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property("encounter", "Reference(Encounter)", "The encounter during which this response was created or to which the creation of this record is tightly associated.", 0, 1, this.encounter);
            }
            case -298443636: {
                return new Property("occurrenceDateTime", "dateTime", "Indicates when the guidance response was processed.", 0, 1, this.occurrenceDateTime);
            }
            case 481140686: {
                return new Property("performer", "Reference(Device)", "Provides a reference to the device that performed the guidance.", 0, 1, this.performer);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference", "Describes the reason for the guidance response in coded or textual form, or Indicates the reason the request was initiated. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Provides a mechanism to communicate additional information about the response.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1081619755: {
                return new Property("evaluationMessage", "Reference(OperationOutcome)", "Messages resulting from the evaluation of the artifact or artifacts. As part of evaluating the request, the engine may produce informational or warning messages. These messages will be provided by this element.", 0, 1, this.evaluationMessage);
            }
            case 525609419: {
                return new Property("outputParameters", "Reference(Parameters)", "The output parameters of the evaluation, if any. Many modules will result in the return of specific resources such as procedure or communication requests that are returned as part of the operation result. However, modules may define specific outputs that would be returned as the result of the evaluation, and these would be returned in this element.", 0, 1, this.outputParameters);
            }
            case -934426595: {
                return new Property("result", "Reference(Appointment|AppointmentResponse|CarePlan|Claim|CommunicationRequest|Contract|CoverageEligibilityRequest|DeviceRequest|EnrollmentRequest|ImmunizationRecommendation|MedicationRequest|NutritionOrder|RequestOrchestration|ServiceRequest|SupplyRequest|Task|VisionPrescription)", "The actions, if any, produced by the evaluation of the artifact.", 0, Integer.MAX_VALUE, this.result);
            }
            case 629147193: {
                return new Property("dataRequirement", "DataRequirement", "If the evaluation could not be completed due to lack of information, or additional information would potentially result in a more accurate response, this element will a description of the data required in order to proceed with the evaluation. A subsequent request to the service should include this data.", 0, Integer.MAX_VALUE, this.dataRequirement);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -354233192: {
                Base[] baseArray;
                if (this.requestIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.requestIdentifier;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1068784020: {
                Base[] baseArray;
                if (this.module == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.module;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.encounter;
                }
                return baseArray;
            }
            case -298443636: {
                Base[] baseArray;
                if (this.occurrenceDateTime == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.occurrenceDateTime;
                }
                return baseArray;
            }
            case 481140686: {
                Base[] baseArray;
                if (this.performer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.performer;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1081619755: {
                Base[] baseArray;
                if (this.evaluationMessage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.evaluationMessage;
                }
                return baseArray;
            }
            case 525609419: {
                Base[] baseArray;
                if (this.outputParameters == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.outputParameters;
                }
                return baseArray;
            }
            case -934426595: {
                return this.result == null ? new Base[]{} : this.result.toArray(new Base[this.result.size()]);
            }
            case 629147193: {
                return this.dataRequirement == null ? new Base[]{} : this.dataRequirement.toArray(new Base[this.dataRequirement.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -354233192: {
                this.requestIdentifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1068784020: {
                this.module = TypeConvertor.castToType(value);
                return value;
            }
            case -892481550: {
                value = new GuidanceResponseStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -298443636: {
                this.occurrenceDateTime = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 481140686: {
                this.performer = TypeConvertor.castToReference(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case 1081619755: {
                this.evaluationMessage = TypeConvertor.castToReference(value);
                return value;
            }
            case 525609419: {
                this.outputParameters = TypeConvertor.castToReference(value);
                return value;
            }
            case -934426595: {
                this.getResult().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 629147193: {
                this.getDataRequirement().add(TypeConvertor.castToDataRequirement(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("requestIdentifier")) {
            this.requestIdentifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("module[x]")) {
            this.module = TypeConvertor.castToType(value);
        } else if (name.equals(SP_STATUS)) {
            value = new GuidanceResponseStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("encounter")) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals("occurrenceDateTime")) {
            this.occurrenceDateTime = TypeConvertor.castToDateTime(value);
        } else if (name.equals("performer")) {
            this.performer = TypeConvertor.castToReference(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("evaluationMessage")) {
            this.evaluationMessage = TypeConvertor.castToReference(value);
        } else if (name.equals("outputParameters")) {
            this.outputParameters = TypeConvertor.castToReference(value);
        } else if (name.equals("result")) {
            this.getResult().add(TypeConvertor.castToReference(value));
        } else if (name.equals("dataRequirement")) {
            this.getDataRequirement().add(TypeConvertor.castToDataRequirement(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals("requestIdentifier")) {
            this.requestIdentifier = null;
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals("module[x]")) {
            this.module = null;
        } else if (name.equals(SP_STATUS)) {
            value = new GuidanceResponseStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = null;
        } else if (name.equals("encounter")) {
            this.encounter = null;
        } else if (name.equals("occurrenceDateTime")) {
            this.occurrenceDateTime = null;
        } else if (name.equals("performer")) {
            this.performer = null;
        } else if (name.equals("reason")) {
            this.getReason().remove(value);
        } else if (name.equals("note")) {
            this.getNote().remove(value);
        } else if (name.equals("evaluationMessage")) {
            this.evaluationMessage = null;
        } else if (name.equals("outputParameters")) {
            this.outputParameters = null;
        } else if (name.equals("result")) {
            this.getResult().remove(value);
        } else if (name.equals("dataRequirement")) {
            this.getDataRequirement().remove(value);
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -354233192: {
                return this.getRequestIdentifier();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1552083308: {
                return this.getModule();
            }
            case -1068784020: {
                return this.getModule();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -298443636: {
                return this.getOccurrenceDateTimeElement();
            }
            case 481140686: {
                return this.getPerformer();
            }
            case -934964668: {
                return this.addReason();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1081619755: {
                return this.getEvaluationMessage();
            }
            case 525609419: {
                return this.getOutputParameters();
            }
            case -934426595: {
                return this.addResult();
            }
            case 629147193: {
                return this.addDataRequirement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -354233192: {
                return new String[]{"Identifier"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1068784020: {
                return new String[]{"uri", "canonical", "CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -298443636: {
                return new String[]{"dateTime"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1081619755: {
                return new String[]{"Reference"};
            }
            case 525609419: {
                return new String[]{"Reference"};
            }
            case -934426595: {
                return new String[]{"Reference"};
            }
            case 629147193: {
                return new String[]{"DataRequirement"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("requestIdentifier")) {
            this.requestIdentifier = new Identifier();
            return this.requestIdentifier;
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("moduleUri")) {
            this.module = new UriType();
            return this.module;
        }
        if (name.equals("moduleCanonical")) {
            this.module = new CanonicalType();
            return this.module;
        }
        if (name.equals("moduleCodeableConcept")) {
            this.module = new CodeableConcept();
            return this.module;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property GuidanceResponse.status");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("encounter")) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("occurrenceDateTime")) {
            throw new FHIRException("Cannot call addChild on a singleton property GuidanceResponse.occurrenceDateTime");
        }
        if (name.equals("performer")) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("evaluationMessage")) {
            this.evaluationMessage = new Reference();
            return this.evaluationMessage;
        }
        if (name.equals("outputParameters")) {
            this.outputParameters = new Reference();
            return this.outputParameters;
        }
        if (name.equals("result")) {
            return this.addResult();
        }
        if (name.equals("dataRequirement")) {
            return this.addDataRequirement();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "GuidanceResponse";
    }

    @Override
    public GuidanceResponse copy() {
        GuidanceResponse dst = new GuidanceResponse();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(GuidanceResponse dst) {
        super.copyValues(dst);
        Identifier identifier = dst.requestIdentifier = this.requestIdentifier == null ? null : this.requestIdentifier.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier2 : this.identifier) {
                dst.identifier.add(identifier2.copy());
            }
        }
        dst.module = this.module == null ? null : this.module.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.occurrenceDateTime = this.occurrenceDateTime == null ? null : this.occurrenceDateTime.copy();
        Reference reference = dst.performer = this.performer == null ? null : this.performer.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        dst.evaluationMessage = this.evaluationMessage == null ? null : this.evaluationMessage.copy();
        Reference reference2 = dst.outputParameters = this.outputParameters == null ? null : this.outputParameters.copy();
        if (this.result != null) {
            dst.result = new ArrayList<Reference>();
            for (Reference reference3 : this.result) {
                dst.result.add(reference3.copy());
            }
        }
        if (this.dataRequirement != null) {
            dst.dataRequirement = new ArrayList<DataRequirement>();
            for (DataRequirement dataRequirement : this.dataRequirement) {
                dst.dataRequirement.add(dataRequirement.copy());
            }
        }
    }

    protected GuidanceResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof GuidanceResponse)) {
            return false;
        }
        GuidanceResponse o = (GuidanceResponse)other_;
        return GuidanceResponse.compareDeep(this.requestIdentifier, o.requestIdentifier, true) && GuidanceResponse.compareDeep(this.identifier, o.identifier, true) && GuidanceResponse.compareDeep(this.module, o.module, true) && GuidanceResponse.compareDeep(this.status, o.status, true) && GuidanceResponse.compareDeep(this.subject, o.subject, true) && GuidanceResponse.compareDeep(this.encounter, o.encounter, true) && GuidanceResponse.compareDeep(this.occurrenceDateTime, o.occurrenceDateTime, true) && GuidanceResponse.compareDeep(this.performer, o.performer, true) && GuidanceResponse.compareDeep(this.reason, o.reason, true) && GuidanceResponse.compareDeep(this.note, o.note, true) && GuidanceResponse.compareDeep(this.evaluationMessage, o.evaluationMessage, true) && GuidanceResponse.compareDeep(this.outputParameters, o.outputParameters, true) && GuidanceResponse.compareDeep(this.result, o.result, true) && GuidanceResponse.compareDeep(this.dataRequirement, o.dataRequirement, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof GuidanceResponse)) {
            return false;
        }
        GuidanceResponse o = (GuidanceResponse)other_;
        return GuidanceResponse.compareValues(this.status, o.status, true) && GuidanceResponse.compareValues(this.occurrenceDateTime, o.occurrenceDateTime, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.requestIdentifier, this.identifier, this.module, this.status, this.subject, this.encounter, this.occurrenceDateTime, this.performer, this.reason, this.note, this.evaluationMessage, this.outputParameters, this.result, this.dataRequirement});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.GuidanceResponse;
    }

    public static class GuidanceResponseStatusEnumFactory
    implements EnumFactory<GuidanceResponseStatus> {
        @Override
        public GuidanceResponseStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("success".equals(codeString)) {
                return GuidanceResponseStatus.SUCCESS;
            }
            if ("data-requested".equals(codeString)) {
                return GuidanceResponseStatus.DATAREQUESTED;
            }
            if ("data-required".equals(codeString)) {
                return GuidanceResponseStatus.DATAREQUIRED;
            }
            if ("in-progress".equals(codeString)) {
                return GuidanceResponseStatus.INPROGRESS;
            }
            if ("failure".equals(codeString)) {
                return GuidanceResponseStatus.FAILURE;
            }
            if ("entered-in-error".equals(codeString)) {
                return GuidanceResponseStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown GuidanceResponseStatus code '" + codeString + "'");
        }

        public Enumeration<GuidanceResponseStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.NULL, code);
            }
            if ("success".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.SUCCESS, code);
            }
            if ("data-requested".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.DATAREQUESTED, code);
            }
            if ("data-required".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.DATAREQUIRED, code);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.INPROGRESS, code);
            }
            if ("failure".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.FAILURE, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<GuidanceResponseStatus>(this, GuidanceResponseStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown GuidanceResponseStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(GuidanceResponseStatus code) {
            if (code == GuidanceResponseStatus.SUCCESS) {
                return "success";
            }
            if (code == GuidanceResponseStatus.DATAREQUESTED) {
                return "data-requested";
            }
            if (code == GuidanceResponseStatus.DATAREQUIRED) {
                return "data-required";
            }
            if (code == GuidanceResponseStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == GuidanceResponseStatus.FAILURE) {
                return "failure";
            }
            if (code == GuidanceResponseStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(GuidanceResponseStatus code) {
            return code.getSystem();
        }
    }

    public static enum GuidanceResponseStatus {
        SUCCESS,
        DATAREQUESTED,
        DATAREQUIRED,
        INPROGRESS,
        FAILURE,
        ENTEREDINERROR,
        NULL;


        public static GuidanceResponseStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("success".equals(codeString)) {
                return SUCCESS;
            }
            if ("data-requested".equals(codeString)) {
                return DATAREQUESTED;
            }
            if ("data-required".equals(codeString)) {
                return DATAREQUIRED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("failure".equals(codeString)) {
                return FAILURE;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GuidanceResponseStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SUCCESS: {
                    return "success";
                }
                case DATAREQUESTED: {
                    return "data-requested";
                }
                case DATAREQUIRED: {
                    return "data-required";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case FAILURE: {
                    return "failure";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SUCCESS: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case DATAREQUESTED: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case DATAREQUIRED: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case FAILURE: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/guidance-response-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SUCCESS: {
                    return "The request was processed successfully.";
                }
                case DATAREQUESTED: {
                    return "The request was processed successfully, but more data may result in a more complete evaluation.";
                }
                case DATAREQUIRED: {
                    return "The request was processed, but more data is required to complete the evaluation.";
                }
                case INPROGRESS: {
                    return "The request is currently being processed.";
                }
                case FAILURE: {
                    return "The request was not processed successfully.";
                }
                case ENTEREDINERROR: {
                    return "The response was entered in error.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SUCCESS: {
                    return "Success";
                }
                case DATAREQUESTED: {
                    return "Data Requested";
                }
                case DATAREQUIRED: {
                    return "Data Required";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case FAILURE: {
                    return "Failure";
                }
                case ENTEREDINERROR: {
                    return "Entered In Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

