/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.extensions;

import java.math.BigDecimal;
import java.util.List;
import org.hl7.fhir.r5.extensions.ExtensionsUtils;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.Availability;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.Distance;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.ExtendedContactDetail;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationStatement;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VisionPrescription;

public class Extensions {
    public static Extension makeCapabilities(String value) {
        return new Extension("http://fhir-registry.smarthealthit.org/StructureDefinition/capabilities").setValue(new CodeType(value));
    }

    public static Extension makeObjectClass(Coding value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/11179-objectClass").setValue(value);
    }

    public static ElementDefinition.ElementDefinitionMappingComponent setObjectClass(ElementDefinition.ElementDefinitionMappingComponent context, Coding value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/11179-objectClass", value);
        return context;
    }

    public static Coding getObjectClass(ElementDefinition.ElementDefinitionMappingComponent context) {
        return ExtensionsUtils.getExtension(Coding.class, context, "http://hl7.org/fhir/StructureDefinition/11179-objectClass");
    }

    public static Extension makeObjectClassProperty(Coding value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/11179-objectClassProperty").setValue(value);
    }

    public static ElementDefinition.ElementDefinitionMappingComponent setObjectClassProperty(ElementDefinition.ElementDefinitionMappingComponent context, Coding value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/11179-objectClassProperty", value);
        return context;
    }

    public static Coding getObjectClassProperty(ElementDefinition.ElementDefinitionMappingComponent context) {
        return ExtensionsUtils.getExtension(Coding.class, context, "http://hl7.org/fhir/StructureDefinition/11179-objectClassProperty");
    }

    public static Extension makePermittedValueConceptmap(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-conceptmap").setValue(new CanonicalType(value));
    }

    public static Extension makePermittedValueValueset(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-valueset").setValue(new CanonicalType(value));
    }

    public static Extension makeDatatype(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/_datatype").setValue(new StringType(value));
    }

    public static Base setDatatype(Base context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/_datatype", new StringType(value));
        return context;
    }

    public static String getDatatype(Base context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/_datatype");
    }

    public static Extension makeAdditionalIdentifier(Identifier value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/additionalIdentifier").setValue(value);
    }

    public static Reference addAdditionalIdentifier(Reference context, Identifier value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/additionalIdentifier", value);
        return context;
    }

    public static List<Identifier> getAdditionalIdentifierList(Reference context) {
        return ExtensionsUtils.getExtensionList(Identifier.class, context, "http://hl7.org/fhir/StructureDefinition/additionalIdentifier");
    }

    public static Extension makeAbatementDateTime(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement").setValue(new DateTimeType(value));
    }

    public static Extension makeAbatement(Age value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement").setValue(value);
    }

    public static Extension makeAbatement(Period value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement").setValue(value);
    }

    public static Extension makeAbatement(Range value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement").setValue(value);
    }

    public static Extension makeAbatementString(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement").setValue(new StringType(value));
    }

    public static AllergyIntolerance setAbatementDateTime(AllergyIntolerance context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement", new DateTimeType(value));
        return context;
    }

    public static String getAbatementString(AllergyIntolerance context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement");
    }

    public static AllergyIntolerance setAbatement(AllergyIntolerance context, Age value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement", value);
        return context;
    }

    public static Age getAbatementAge(AllergyIntolerance context) {
        return ExtensionsUtils.getExtension(Age.class, context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement");
    }

    public static AllergyIntolerance setAbatement(AllergyIntolerance context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement", value);
        return context;
    }

    public static Period getAbatementPeriod(AllergyIntolerance context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement");
    }

    public static AllergyIntolerance setAbatement(AllergyIntolerance context, Range value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement", value);
        return context;
    }

    public static Range getAbatementRange(AllergyIntolerance context) {
        return ExtensionsUtils.getExtension(Range.class, context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement");
    }

    public static AllergyIntolerance setAbatementString(AllergyIntolerance context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-abatement", new StringType(value));
        return context;
    }

    public static Extension makeAIAssertedDate(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/allergyintolerance-assertedDate").setValue(new DateTimeType(value));
    }

    public static AllergyIntolerance setAIAssertedDate(AllergyIntolerance context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-assertedDate", new DateTimeType(value));
        return context;
    }

    public static String getAIAssertedDate(AllergyIntolerance context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-assertedDate");
    }

    public static Extension makeAICertainty(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/allergyintolerance-certainty").setValue(value);
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent setAICertainty(AllergyIntolerance.AllergyIntoleranceReactionComponent context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-certainty", value);
        return context;
    }

    public static CodeableConcept getAICertainty(AllergyIntolerance.AllergyIntoleranceReactionComponent context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-certainty");
    }

    public static Extension makeAIDuration(Duration value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/allergyintolerance-duration").setValue(value);
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent setAIDuration(AllergyIntolerance.AllergyIntoleranceReactionComponent context, Duration value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-duration", value);
        return context;
    }

    public static Duration getAIDuration(AllergyIntolerance.AllergyIntoleranceReactionComponent context) {
        return ExtensionsUtils.getExtension(Duration.class, context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-duration");
    }

    public static Extension makeAIReasonRefuted(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/allergyintolerance-reasonRefuted").setValue(value);
    }

    public static AllergyIntolerance setAIReasonRefuted(AllergyIntolerance context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-reasonRefuted", value);
        return context;
    }

    public static CodeableConcept getAIReasonRefuted(AllergyIntolerance context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-reasonRefuted");
    }

    public static Extension makeAIResolutionAge(Age value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/allergyintolerance-resolutionAge").setValue(value);
    }

    public static AllergyIntolerance setAIResolutionAge(AllergyIntolerance context, Age value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-resolutionAge", value);
        return context;
    }

    public static Age getAIResolutionAge(AllergyIntolerance context) {
        return ExtensionsUtils.getExtension(Age.class, context, "http://hl7.org/fhir/StructureDefinition/allergyintolerance-resolutionAge");
    }

    public static Extension makeAlternateCanonical(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/alternate-canonical").setValue(new CanonicalType(value));
    }

    public static CanonicalType setAlternateCanonical(CanonicalType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/alternate-canonical", new CanonicalType(value));
        return context;
    }

    public static String getAlternateCanonical(CanonicalType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/alternate-canonical");
    }

    public static Extension makeAlternateCodes(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/alternate-codes").setValue(value);
    }

    public static CodeType addAlternateCodes(CodeType context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/alternate-codes", value);
        return context;
    }

    public static List<CodeableConcept> getAlternateCodesList(CodeType context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/alternate-codes");
    }

    public static Extension makeAlternateReference(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/alternate-reference").setValue(value);
    }

    public static Reference setAlternateReference(Reference context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/alternate-reference", value);
        return context;
    }

    public static Reference getAlternateReference(Reference context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/alternate-reference");
    }

    public static Extension makeArtifactAuthor(ContactDetail value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-author").setValue(value);
    }

    public static DomainResource addArtifactAuthor(DomainResource context, ContactDetail value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-author", value);
        return context;
    }

    public static List<ContactDetail> getArtifactAuthorList(DomainResource context) {
        return ExtensionsUtils.getExtensionList(ContactDetail.class, context, "http://hl7.org/fhir/StructureDefinition/artifact-author");
    }

    public static Extension makeArtifactContact(ContactDetail value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-contact").setValue(value);
    }

    public static Element addArtifactContact(Element context, ContactDetail value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-contact", value);
        return context;
    }

    public static List<ContactDetail> getArtifactContactList(Element context) {
        return ExtensionsUtils.getExtensionList(ContactDetail.class, context, "http://hl7.org/fhir/StructureDefinition/artifact-contact");
    }

    public static Extension makeContactDetailReference(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-contactDetailReference").setValue(value);
    }

    public static ContactDetail setContactDetailReference(ContactDetail context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-contactDetailReference", value);
        return context;
    }

    public static Reference getContactDetailReference(ContactDetail context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/artifact-contactDetailReference");
    }

    public static Extension makeArtifactCopyright(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-copyright").setValue(new MarkdownType(value));
    }

    public static Element setArtifactCopyright(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-copyright", new MarkdownType(value));
        return context;
    }

    public static String getArtifactCopyright(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/artifact-copyright");
    }

    public static Extension makeArtifactCopyrightLabel(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-copyrightLabel").setValue(new StringType(value));
    }

    public static Element setArtifactCopyrightLabel(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-copyrightLabel", new StringType(value));
        return context;
    }

    public static String getArtifactCopyrightLabel(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/artifact-copyrightLabel");
    }

    public static Extension makeArtifactDate(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-date").setValue(new DateTimeType(value));
    }

    public static Element setArtifactDate(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-date", new DateTimeType(value));
        return context;
    }

    public static String getArtifactDate(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/artifact-date");
    }

    public static Extension makeArtifactDescription(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-description").setValue(new MarkdownType(value));
    }

    public static Element setArtifactDescription(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-description", new MarkdownType(value));
        return context;
    }

    public static String getArtifactDescription(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/artifact-description");
    }

    public static Extension makeArtifactEditor(ContactDetail value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-editor").setValue(value);
    }

    public static Element addArtifactEditor(Element context, ContactDetail value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-editor", value);
        return context;
    }

    public static List<ContactDetail> getArtifactEditorList(Element context) {
        return ExtensionsUtils.getExtensionList(ContactDetail.class, context, "http://hl7.org/fhir/StructureDefinition/artifact-editor");
    }

    public static Extension makeArtifactEndorser(ContactDetail value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-endorser").setValue(value);
    }

    public static Element addArtifactEndorser(Element context, ContactDetail value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-endorser", value);
        return context;
    }

    public static List<ContactDetail> getArtifactEndorserList(Element context) {
        return ExtensionsUtils.getExtensionList(ContactDetail.class, context, "http://hl7.org/fhir/StructureDefinition/artifact-endorser");
    }

    public static Extension makeArtifactExperimental(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-experimental").setValue(new BooleanType(value));
    }

    public static Element setArtifactExperimental(Element context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-experimental", new BooleanType(value));
        return context;
    }

    public static Boolean getArtifactExperimental(Element context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/artifact-experimental");
    }

    public static Extension makeArtifactIdentifier(Identifier value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-identifier").setValue(value);
    }

    public static Element addArtifactIdentifier(Element context, Identifier value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-identifier", value);
        return context;
    }

    public static List<Identifier> getArtifactIdentifierList(Element context) {
        return ExtensionsUtils.getExtensionList(Identifier.class, context, "http://hl7.org/fhir/StructureDefinition/artifact-identifier");
    }

    public static Extension makeArtifactJurisdiction(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-jurisdiction").setValue(value);
    }

    public static Element addArtifactJurisdiction(Element context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-jurisdiction", value);
        return context;
    }

    public static List<CodeableConcept> getArtifactJurisdictionList(Element context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/artifact-jurisdiction");
    }

    public static Extension makeKnowledgeCapability(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-knowledgeCapability").setValue(new CodeType(value));
    }

    public static Element addKnowledgeCapability(Element context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-knowledgeCapability", new CodeType(value));
        return context;
    }

    public static List<String> getKnowledgeCapabilityList(Element context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/artifact-knowledgeCapability");
    }

    public static Extension makeKnowledgeRepresentationLevel(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-knowledgeRepresentationLevel").setValue(new CodeType(value));
    }

    public static Element addKnowledgeRepresentationLevel(Element context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-knowledgeRepresentationLevel", new CodeType(value));
        return context;
    }

    public static List<String> getKnowledgeRepresentationLevelList(Element context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/artifact-knowledgeRepresentationLevel");
    }

    public static Extension makeArtifactName(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-name").setValue(new StringType(value));
    }

    public static Element setArtifactName(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-name", new StringType(value));
        return context;
    }

    public static String getArtifactName(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/artifact-name");
    }

    public static Extension makePeriodDuration(Duration value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-periodDuration").setValue(value);
    }

    public static Period setPeriodDuration(Period context, Duration value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-periodDuration", value);
        return context;
    }

    public static Duration getPeriodDuration(Period context) {
        return ExtensionsUtils.getExtension(Duration.class, context, "http://hl7.org/fhir/StructureDefinition/artifact-periodDuration");
    }

    public static Extension makeArtifactPublisher(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-publisher").setValue(new StringType(value));
    }

    public static Element setArtifactPublisher(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-publisher", new StringType(value));
        return context;
    }

    public static String getArtifactPublisher(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/artifact-publisher");
    }

    public static Extension makeArtifactPurpose(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-purpose").setValue(new MarkdownType(value));
    }

    public static Element setArtifactPurpose(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-purpose", new MarkdownType(value));
        return context;
    }

    public static String getArtifactPurpose(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/artifact-purpose");
    }

    public static Extension makeArtifactRelatedArtifact(RelatedArtifact value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-relatedArtifact").setValue(value);
    }

    public static Element addArtifactRelatedArtifact(Element context, RelatedArtifact value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-relatedArtifact", value);
        return context;
    }

    public static List<RelatedArtifact> getArtifactRelatedArtifactList(Element context) {
        return ExtensionsUtils.getExtensionList(RelatedArtifact.class, context, "http://hl7.org/fhir/StructureDefinition/artifact-relatedArtifact");
    }

    public static Extension makeArtifactReviewer(ContactDetail value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-reviewer").setValue(value);
    }

    public static Element addArtifactReviewer(Element context, ContactDetail value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-reviewer", value);
        return context;
    }

    public static List<ContactDetail> getArtifactReviewerList(Element context) {
        return ExtensionsUtils.getExtensionList(ContactDetail.class, context, "http://hl7.org/fhir/StructureDefinition/artifact-reviewer");
    }

    public static Extension makeArtifactStatus(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-status").setValue(new CodeType(value));
    }

    public static Element setArtifactStatus(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-status", new CodeType(value));
        return context;
    }

    public static String getArtifactStatus(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/artifact-status");
    }

    public static Extension makeArtifactTitle(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-title").setValue(new StringType(value));
    }

    public static Element setArtifactTitle(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-title", new StringType(value));
        return context;
    }

    public static String getArtifactTitle(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/artifact-title");
    }

    public static Extension makeArtifactTopic(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-topic").setValue(value);
    }

    public static Element addArtifactTopic(Element context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-topic", value);
        return context;
    }

    public static List<CodeableConcept> getArtifactTopicList(Element context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/artifact-topic");
    }

    public static Extension makeArtifactUrl(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-url").setValue(new UriType(value));
    }

    public static Element setArtifactUrl(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-url", new UriType(value));
        return context;
    }

    public static String getArtifactUrl(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/artifact-url");
    }

    public static Extension makeArtifactUseContext(UsageContext value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-useContext").setValue(value);
    }

    public static Element addArtifactUseContext(Element context, UsageContext value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-useContext", value);
        return context;
    }

    public static List<UsageContext> getArtifactUseContextList(Element context) {
        return ExtensionsUtils.getExtensionList(UsageContext.class, context, "http://hl7.org/fhir/StructureDefinition/artifact-useContext");
    }

    public static Extension makeArtifactVersion(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-version").setValue(new StringType(value));
    }

    public static Element setArtifactVersion(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-version", new StringType(value));
        return context;
    }

    public static String getArtifactVersion(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/artifact-version");
    }

    public static Extension makeArtifactVersionAlgorithm(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/artifact-versionAlgorithm").setValue(new StringType(value));
    }

    public static Element setArtifactVersionAlgorithm(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/artifact-versionAlgorithm", new StringType(value));
        return context;
    }

    public static String getArtifactVersionAlgorithm(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/artifact-versionAlgorithm");
    }

    public static Extension makeAEAccession(Identifier value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/auditevent-Accession").setValue(value);
    }

    public static AuditEvent.AuditEventEntityComponent addAEAccession(AuditEvent.AuditEventEntityComponent context, Identifier value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/auditevent-Accession", value);
        return context;
    }

    public static List<Identifier> getAEAccessionList(AuditEvent.AuditEventEntityComponent context) {
        return ExtensionsUtils.getExtensionList(Identifier.class, context, "http://hl7.org/fhir/StructureDefinition/auditevent-Accession");
    }

    public static Extension makeAEAlternativeUserID(Identifier value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/auditevent-AlternativeUserID").setValue(value);
    }

    public static AuditEvent.AuditEventAgentComponent addAEAlternativeUserID(AuditEvent.AuditEventAgentComponent context, Identifier value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/auditevent-AlternativeUserID", value);
        return context;
    }

    public static List<Identifier> getAEAlternativeUserIDList(AuditEvent.AuditEventAgentComponent context) {
        return ExtensionsUtils.getExtensionList(Identifier.class, context, "http://hl7.org/fhir/StructureDefinition/auditevent-AlternativeUserID");
    }

    public static Extension makeAEAnonymized(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/auditevent-Anonymized").setValue(new BooleanType(value));
    }

    public static AuditEvent.AuditEventEntityComponent setAEAnonymized(AuditEvent.AuditEventEntityComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/auditevent-Anonymized", new BooleanType(value));
        return context;
    }

    public static Boolean getAEAnonymized(AuditEvent.AuditEventEntityComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/auditevent-Anonymized");
    }

    public static Extension makeAEEncrypted(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/auditevent-Encrypted").setValue(new BooleanType(value));
    }

    public static AuditEvent.AuditEventEntityComponent setAEEncrypted(AuditEvent.AuditEventEntityComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/auditevent-Encrypted", new BooleanType(value));
        return context;
    }

    public static Boolean getAEEncrypted(AuditEvent.AuditEventEntityComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/auditevent-Encrypted");
    }

    public static Extension makeAEInstance(Identifier value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/auditevent-Instance").setValue(value);
    }

    public static AuditEvent.AuditEventEntityComponent addAEInstance(AuditEvent.AuditEventEntityComponent context, Identifier value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/auditevent-Instance", value);
        return context;
    }

    public static List<Identifier> getAEInstanceList(AuditEvent.AuditEventEntityComponent context) {
        return ExtensionsUtils.getExtensionList(Identifier.class, context, "http://hl7.org/fhir/StructureDefinition/auditevent-Instance");
    }

    public static Extension makeAELifecycle(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/auditevent-Lifecycle").setValue(value);
    }

    public static AuditEvent.AuditEventEntityComponent addAELifecycle(AuditEvent.AuditEventEntityComponent context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/auditevent-Lifecycle", value);
        return context;
    }

    public static List<CodeableConcept> getAELifecycleList(AuditEvent.AuditEventEntityComponent context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/auditevent-Lifecycle");
    }

    public static Extension makeAEMPPS(Identifier value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/auditevent-MPPS").setValue(value);
    }

    public static AuditEvent.AuditEventEntityComponent addAEMPPS(AuditEvent.AuditEventEntityComponent context, Identifier value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/auditevent-MPPS", value);
        return context;
    }

    public static List<Identifier> getAEMPPSList(AuditEvent.AuditEventEntityComponent context) {
        return ExtensionsUtils.getExtensionList(Identifier.class, context, "http://hl7.org/fhir/StructureDefinition/auditevent-MPPS");
    }

    public static Extension makeAENumberOfInstances(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/auditevent-NumberOfInstances").setValue(new IntegerType(value));
    }

    public static AuditEvent.AuditEventEntityComponent setAENumberOfInstances(AuditEvent.AuditEventEntityComponent context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/auditevent-NumberOfInstances", new IntegerType(value));
        return context;
    }

    public static Integer getAENumberOfInstances(AuditEvent.AuditEventEntityComponent context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/auditevent-NumberOfInstances");
    }

    public static Extension makeAEParticipantObjectContainsStudy(Identifier value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/auditevent-ParticipantObjectContainsStudy").setValue(value);
    }

    public static AuditEvent.AuditEventEntityComponent setAEParticipantObjectContainsStudy(AuditEvent.AuditEventEntityComponent context, Identifier value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/auditevent-ParticipantObjectContainsStudy", value);
        return context;
    }

    public static Identifier getAEParticipantObjectContainsStudy(AuditEvent.AuditEventEntityComponent context) {
        return ExtensionsUtils.getExtension(Identifier.class, context, "http://hl7.org/fhir/StructureDefinition/auditevent-ParticipantObjectContainsStudy");
    }

    public static Extension makeAESOPClass(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/auditevent-SOPClass").setValue(value);
    }

    public static AuditEvent.AuditEventEntityComponent addAESOPClass(AuditEvent.AuditEventEntityComponent context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/auditevent-SOPClass", value);
        return context;
    }

    public static List<Reference> getAESOPClassList(AuditEvent.AuditEventEntityComponent context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/auditevent-SOPClass");
    }

    public static Extension makeBDPCollectionProcedure(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/biologicallyderivedproduct-collection-procedure").setValue(value);
    }

    public static BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent addBDPCollectionProcedure(BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/biologicallyderivedproduct-collection-procedure", value);
        return context;
    }

    public static List<Reference> getBDPCollectionProcedureList(BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/biologicallyderivedproduct-collection-procedure");
    }

    public static Extension makeBDPManipulation(DataType value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/biologicallyderivedproduct-manipulation").setValue(value);
    }

    public static BiologicallyDerivedProduct setBDPManipulation(BiologicallyDerivedProduct context, DataType value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/biologicallyderivedproduct-manipulation", value);
        return context;
    }

    public static DataType getBDPManipulation(BiologicallyDerivedProduct context) {
        return ExtensionsUtils.getExtension(DataType.class, context, "http://hl7.org/fhir/StructureDefinition/biologicallyderivedproduct-manipulation");
    }

    public static Extension makeBDPProcessing(DataType value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/biologicallyderivedproduct-processing").setValue(value);
    }

    public static BiologicallyDerivedProduct addBDPProcessing(BiologicallyDerivedProduct context, DataType value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/biologicallyderivedproduct-processing", value);
        return context;
    }

    public static List<DataType> getBDPProcessingList(BiologicallyDerivedProduct context) {
        return ExtensionsUtils.getExtensionList(DataType.class, context, "http://hl7.org/fhir/StructureDefinition/biologicallyderivedproduct-processing");
    }

    public static Extension makeBodyStructureReference(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/bodySite").setValue(value);
    }

    public static Element setBodyStructureReference(Element context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/bodySite", value);
        return context;
    }

    public static Reference getBodyStructureReference(Element context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/bodySite");
    }

    public static Extension makeCRShortDescription(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/canonicalresource-short-description").setValue(new StringType(value));
    }

    public static CanonicalResource addCRShortDescription(CanonicalResource context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/canonicalresource-short-description", new StringType(value));
        return context;
    }

    public static List<String> getCRShortDescriptionList(CanonicalResource context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/canonicalresource-short-description");
    }

    public static Extension makeCSDeclaredProfile(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-declared-profile").setValue(new CanonicalType(value));
    }

    public static Extension makeCSExpectation(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation").setValue(new CodeType(value));
    }

    public static CanonicalType setCSExpectation(CanonicalType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation", new CodeType(value));
        return context;
    }

    public static String getCSExpectation(CanonicalType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation");
    }

    public static CodeType setCSExpectation(CodeType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation", new CodeType(value));
        return context;
    }

    public static String getCSExpectation(CodeType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation");
    }

    public static Extension setCSExpectation(Extension context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation", new CodeType(value));
        return context;
    }

    public static String getCSExpectation(Extension context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation");
    }

    public static CapabilityStatement.CapabilityStatementDocumentComponent setCSExpectation(CapabilityStatement.CapabilityStatementDocumentComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation", new CodeType(value));
        return context;
    }

    public static String getCSExpectation(CapabilityStatement.CapabilityStatementDocumentComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation");
    }

    public static Extension makeCSProhibited(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-prohibited").setValue(new BooleanType(value));
    }

    public static CapabilityStatement.CapabilityStatementDocumentComponent setCSProhibited(CapabilityStatement.CapabilityStatementDocumentComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-prohibited", new BooleanType(value));
        return context;
    }

    public static Boolean getCSProhibited(CapabilityStatement.CapabilityStatementDocumentComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-prohibited");
    }

    public static Extension makeCSSearchMode(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-search-mode").setValue(new CodeType(value));
    }

    public static Extension makeCSSupportedSystem(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-supported-system").setValue(new UriType(value));
    }

    public static CapabilityStatement addCSSupportedSystem(CapabilityStatement context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-supported-system", new UriType(value));
        return context;
    }

    public static List<String> getCSSupportedSystemList(CapabilityStatement context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-supported-system");
    }

    public static Extension makeCSWebsocket(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/capabilitystatement-websocket").setValue(new UriType(value));
    }

    public static CapabilityStatement.CapabilityStatementRestComponent setCSWebsocket(CapabilityStatement.CapabilityStatementRestComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-websocket", new UriType(value));
        return context;
    }

    public static String getCSWebsocket(CapabilityStatement.CapabilityStatementRestComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/capabilitystatement-websocket");
    }

    public static Extension makeCPActivityTitle(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/careplan-activity-title").setValue(new StringType(value));
    }

    public static CarePlan.CarePlanActivityComponent setCPActivityTitle(CarePlan.CarePlanActivityComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/careplan-activity-title", new StringType(value));
        return context;
    }

    public static String getCPActivityTitle(CarePlan.CarePlanActivityComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/careplan-activity-title");
    }

    public static Extension makeCTAlias(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/careteam-alias").setValue(new StringType(value));
    }

    public static CareTeam addCTAlias(CareTeam context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/careteam-alias", new StringType(value));
        return context;
    }

    public static List<String> getCTAliasList(CareTeam context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/careteam-alias");
    }

    public static Extension makeCharacteristicExpression(Expression value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/characteristicExpression").setValue(value);
    }

    public static Group setCharacteristicExpression(Group context, Expression value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/characteristicExpression", value);
        return context;
    }

    public static Expression getCharacteristicExpression(Group context) {
        return ExtensionsUtils.getExtension(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/characteristicExpression");
    }

    public static Extension makeCSAuthoritativeSource(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-authoritativeSource").setValue(new UriType(value));
    }

    public static CodeSystem setCSAuthoritativeSource(CodeSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-authoritativeSource", new UriType(value));
        return context;
    }

    public static String getCSAuthoritativeSource(CodeSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/codesystem-authoritativeSource");
    }

    public static Extension makeCSConceptComments(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-concept-comments").setValue(new StringType(value));
    }

    public static CodeSystem.ConceptDefinitionComponent setCSConceptComments(CodeSystem.ConceptDefinitionComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-concept-comments", new StringType(value));
        return context;
    }

    public static String getCSConceptComments(CodeSystem.ConceptDefinitionComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/codesystem-concept-comments");
    }

    public static Extension makeCSConceptOrder(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-conceptOrder").setValue(new IntegerType(value));
    }

    public static CodeSystem.ConceptDefinitionComponent setCSConceptOrder(CodeSystem.ConceptDefinitionComponent context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-conceptOrder", new IntegerType(value));
        return context;
    }

    public static Integer getCSConceptOrder(CodeSystem.ConceptDefinitionComponent context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/codesystem-conceptOrder");
    }

    public static Extension makeCSKeyWord(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-keyWord").setValue(new StringType(value));
    }

    public static CodeSystem addCSKeyWord(CodeSystem context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-keyWord", new StringType(value));
        return context;
    }

    public static List<String> getCSKeyWordList(CodeSystem context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/codesystem-keyWord");
    }

    public static Extension makeCSLabel(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-label").setValue(new StringType(value));
    }

    public static CodeSystem.ConceptDefinitionComponent setCSLabel(CodeSystem.ConceptDefinitionComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-label", new StringType(value));
        return context;
    }

    public static String getCSLabel(CodeSystem.ConceptDefinitionComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/codesystem-label");
    }

    public static Extension makeCSMap(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-map").setValue(new CanonicalType(value));
    }

    public static CodeSystem setCSMap(CodeSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-map", new CanonicalType(value));
        return context;
    }

    public static String getCSMap(CodeSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/codesystem-map");
    }

    public static Extension makeCSPropertiesMode(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-properties-mode").setValue(new CodeType(value));
    }

    public static CodeSystem setCSPropertiesMode(CodeSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-properties-mode", new CodeType(value));
        return context;
    }

    public static String getCSPropertiesMode(CodeSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/codesystem-properties-mode");
    }

    public static Extension makeCSReplacedby(Coding value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-replacedby").setValue(value);
    }

    public static CodeSystem.ConceptDefinitionComponent setCSReplacedby(CodeSystem.ConceptDefinitionComponent context, Coding value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-replacedby", value);
        return context;
    }

    public static Coding getCSReplacedby(CodeSystem.ConceptDefinitionComponent context) {
        return ExtensionsUtils.getExtension(Coding.class, context, "http://hl7.org/fhir/StructureDefinition/codesystem-replacedby");
    }

    public static Extension makeCSSourceReference(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-sourceReference").setValue(new UriType(value));
    }

    public static CodeSystem setCSSourceReference(CodeSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-sourceReference", new UriType(value));
        return context;
    }

    public static String getCSSourceReference(CodeSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/codesystem-sourceReference");
    }

    public static Extension makeCSTrustedExpansion(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-trusted-expansion").setValue(new UriType(value));
    }

    public static CodeSystem addCSTrustedExpansion(CodeSystem context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-trusted-expansion", new UriType(value));
        return context;
    }

    public static List<String> getCSTrustedExpansionList(CodeSystem context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/codesystem-trusted-expansion");
    }

    public static Extension makeCSUseMarkdown(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-use-markdown").setValue(new BooleanType(value));
    }

    public static CodeSystem setCSUseMarkdown(CodeSystem context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-use-markdown", new BooleanType(value));
        return context;
    }

    public static Boolean getCSUseMarkdown(CodeSystem context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/codesystem-use-markdown");
    }

    public static Extension makeCSWarning(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-warning").setValue(new MarkdownType(value));
    }

    public static CodeSystem setCSWarning(CodeSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-warning", new MarkdownType(value));
        return context;
    }

    public static String getCSWarning(CodeSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/codesystem-warning");
    }

    public static Extension makeCSWorkflowStatus(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/codesystem-workflowStatus").setValue(new StringType(value));
    }

    public static CodeSystem setCSWorkflowStatus(CodeSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/codesystem-workflowStatus", new StringType(value));
        return context;
    }

    public static String getCSWorkflowStatus(CodeSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/codesystem-workflowStatus");
    }

    public static Extension makeCodingConformance(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/coding-conformance").setValue(new CanonicalType(value));
    }

    public static Coding addCodingConformance(Coding context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/coding-conformance", new CanonicalType(value));
        return context;
    }

    public static List<String> getCodingConformanceList(Coding context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/coding-conformance");
    }

    public static Extension makeCodingPurpose(Coding value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/coding-purpose").setValue(value);
    }

    public static Coding addCodingPurpose(Coding context, Coding value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/coding-purpose", value);
        return context;
    }

    public static List<Coding> getCodingPurposeList(Coding context) {
        return ExtensionsUtils.getExtensionList(Coding.class, context, "http://hl7.org/fhir/StructureDefinition/coding-purpose");
    }

    public static Extension makeSctdescid(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/coding-sctdescid").setValue(new IdType(value));
    }

    public static Coding setSctdescid(Coding context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/coding-sctdescid", new IdType(value));
        return context;
    }

    public static String getSctdescid(Coding context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/coding-sctdescid");
    }

    public static Extension makeCMedia(Attachment value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/communication-media").setValue(value);
    }

    public static Communication addCMedia(Communication context, Attachment value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/communication-media", value);
        return context;
    }

    public static List<Attachment> getCMediaList(Communication context) {
        return ExtensionsUtils.getExtensionList(Attachment.class, context, "http://hl7.org/fhir/StructureDefinition/communication-media");
    }

    public static Extension makeCRInitiatingLocation(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/communicationrequest-initiatingLocation").setValue(value);
    }

    public static CommunicationRequest setCRInitiatingLocation(CommunicationRequest context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/communicationrequest-initiatingLocation", value);
        return context;
    }

    public static Reference getCRInitiatingLocation(CommunicationRequest context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/communicationrequest-initiatingLocation");
    }

    public static Extension makeCOtherConfidentiality(Coding value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/composition-clinicaldocument-otherConfidentiality").setValue(value);
    }

    public static Composition addCOtherConfidentiality(Composition context, Coding value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/composition-clinicaldocument-otherConfidentiality", value);
        return context;
    }

    public static List<Coding> getCOtherConfidentialityList(Composition context) {
        return ExtensionsUtils.getExtensionList(Coding.class, context, "http://hl7.org/fhir/StructureDefinition/composition-clinicaldocument-otherConfidentiality");
    }

    public static Extension makeCDVersionNumber(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/composition-clinicaldocument-versionNumber").setValue(new StringType(value));
    }

    public static Composition setCDVersionNumber(Composition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/composition-clinicaldocument-versionNumber", new StringType(value));
        return context;
    }

    public static String getCDVersionNumber(Composition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/composition-clinicaldocument-versionNumber");
    }

    public static Extension makeCSectionSubject(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/composition-section-subject").setValue(new StringType(value));
    }

    public static Composition.SectionComponent setCSectionSubject(Composition.SectionComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/composition-section-subject", new StringType(value));
        return context;
    }

    public static String getCSectionSubject(Composition.SectionComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/composition-section-subject");
    }

    public static Extension makeCMBidirectional(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/concept-bidirectional").setValue(new BooleanType(value));
    }

    public static ConceptMap setCMBidirectional(ConceptMap context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/concept-bidirectional", new BooleanType(value));
        return context;
    }

    public static Boolean getCMBidirectional(ConceptMap context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/concept-bidirectional");
    }

    public static Extension makeConditionAssertedDate(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/condition-assertedDate").setValue(new DateTimeType(value));
    }

    public static Condition setConditionAssertedDate(Condition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/condition-assertedDate", new DateTimeType(value));
        return context;
    }

    public static String getConditionAssertedDate(Condition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/condition-assertedDate");
    }

    public static Extension makeConditionDiseaseCourse(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/condition-diseaseCourse").setValue(value);
    }

    public static Condition setConditionDiseaseCourse(Condition context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/condition-diseaseCourse", value);
        return context;
    }

    public static CodeableConcept getConditionDiseaseCourse(Condition context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/condition-diseaseCourse");
    }

    public static Extension makeConditionDueTo(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/condition-dueTo").setValue(value);
    }

    public static Extension makeConditionDueTo(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/condition-dueTo").setValue(value);
    }

    public static Condition addConditionDueTo(Condition context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/condition-dueTo", value);
        return context;
    }

    public static List<CodeableConcept> getConditionDueToCodeableConceptList(Condition context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/condition-dueTo");
    }

    public static Condition addConditionDueTo(Condition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/condition-dueTo", value);
        return context;
    }

    public static List<Reference> getConditionDueToReferenceList(Condition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/condition-dueTo");
    }

    public static Extension makeConditionOccurredFollowing(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/condition-occurredFollowing").setValue(value);
    }

    public static Extension makeConditionOccurredFollowing(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/condition-occurredFollowing").setValue(value);
    }

    public static Condition addConditionOccurredFollowing(Condition context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/condition-occurredFollowing", value);
        return context;
    }

    public static List<CodeableConcept> getConditionOccurredFollowingCodeableConceptList(Condition context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/condition-occurredFollowing");
    }

    public static Condition addConditionOccurredFollowing(Condition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/condition-occurredFollowing", value);
        return context;
    }

    public static List<Reference> getConditionOccurredFollowingReferenceList(Condition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/condition-occurredFollowing");
    }

    public static Extension makeConditionOutcome(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/condition-outcome").setValue(value);
    }

    public static Condition setConditionOutcome(Condition context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/condition-outcome", value);
        return context;
    }

    public static CodeableConcept getConditionOutcome(Condition context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/condition-outcome");
    }

    public static Extension makeConditionRelated(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/condition-related").setValue(value);
    }

    public static Condition addConditionRelated(Condition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/condition-related", value);
        return context;
    }

    public static List<Reference> getConditionRelatedList(Condition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/condition-related");
    }

    public static Extension makeConditionReviewed(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/condition-reviewed").setValue(new DateTimeType(value));
    }

    public static Condition setConditionReviewed(Condition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/condition-reviewed", new DateTimeType(value));
        return context;
    }

    public static String getConditionReviewed(Condition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/condition-reviewed");
    }

    public static Extension makeConditionRuledOut(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/condition-ruledOut").setValue(value);
    }

    public static Condition addConditionRuledOut(Condition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/condition-ruledOut", value);
        return context;
    }

    public static List<Reference> getConditionRuledOutList(Condition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/condition-ruledOut");
    }

    public static Extension makeConsentNotificationEndpoint(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/consent-NotificationEndpoint").setValue(new UriType(value));
    }

    public static Consent setConsentNotificationEndpoint(Consent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/consent-NotificationEndpoint", new UriType(value));
        return context;
    }

    public static String getConsentNotificationEndpoint(Consent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/consent-NotificationEndpoint");
    }

    public static Extension makeConsentResearchStudyContext(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/consent-ResearchStudyContext").setValue(value);
    }

    public static Consent.ProvisionComponent setConsentResearchStudyContext(Consent.ProvisionComponent context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/consent-ResearchStudyContext", value);
        return context;
    }

    public static Reference getConsentResearchStudyContext(Consent.ProvisionComponent context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/consent-ResearchStudyContext");
    }

    public static Extension makeConsentTranscriber(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/consent-Transcriber").setValue(value);
    }

    public static Consent setConsentTranscriber(Consent context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/consent-Transcriber", value);
        return context;
    }

    public static Reference getConsentTranscriber(Consent context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/consent-Transcriber");
    }

    public static Extension makeConsentWitness(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/consent-Witness").setValue(value);
    }

    public static Consent setConsentWitness(Consent context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/consent-Witness", value);
        return context;
    }

    public static Reference getConsentWitness(Consent context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/consent-Witness");
    }

    public static Extension makeConsentLocation(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/consent-location").setValue(value);
    }

    public static Consent.ProvisionComponent addConsentLocation(Consent.ProvisionComponent context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/consent-location", value);
        return context;
    }

    public static List<Reference> getConsentLocationList(Consent.ProvisionComponent context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/consent-location");
    }

    public static Extension makeContactPointArea(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/contactpoint-area").setValue(new StringType(value));
    }

    public static ContactPoint setContactPointArea(ContactPoint context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/contactpoint-area", new StringType(value));
        return context;
    }

    public static String getContactPointArea(ContactPoint context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/contactpoint-area");
    }

    public static Extension makeContactPointComment(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/contactpoint-comment").setValue(new StringType(value));
    }

    public static ContactPoint setContactPointComment(ContactPoint context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/contactpoint-comment", new StringType(value));
        return context;
    }

    public static String getContactPointComment(ContactPoint context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/contactpoint-comment");
    }

    public static ExtendedContactDetail setContactPointComment(ExtendedContactDetail context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/contactpoint-comment", new StringType(value));
        return context;
    }

    public static String getContactPointComment(ExtendedContactDetail context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/contactpoint-comment");
    }

    public static Extension makeContactPointCountry(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/contactpoint-country").setValue(new StringType(value));
    }

    public static ContactPoint setContactPointCountry(ContactPoint context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/contactpoint-country", new StringType(value));
        return context;
    }

    public static String getContactPointCountry(ContactPoint context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/contactpoint-country");
    }

    public static Extension makeContactPointExtension(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/contactpoint-extension").setValue(new StringType(value));
    }

    public static ContactPoint setContactPointExtension(ContactPoint context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/contactpoint-extension", new StringType(value));
        return context;
    }

    public static String getContactPointExtension(ContactPoint context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/contactpoint-extension");
    }

    public static Extension makeContactPointLocal(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/contactpoint-local").setValue(new StringType(value));
    }

    public static ContactPoint setContactPointLocal(ContactPoint context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/contactpoint-local", new StringType(value));
        return context;
    }

    public static String getContactPointLocal(ContactPoint context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/contactpoint-local");
    }

    public static Extension makeAlternativeExpression(Expression value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-alternativeExpression").setValue(value);
    }

    public static Expression setAlternativeExpression(Expression context, Expression value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-alternativeExpression", value);
        return context;
    }

    public static Expression getAlternativeExpression(Expression context) {
        return ExtensionsUtils.getExtension(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-alternativeExpression");
    }

    public static Extension makeCalculatedValue(Expression value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-calculatedValue").setValue(value);
    }

    public static Element addCalculatedValue(Element context, Expression value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-calculatedValue", value);
        return context;
    }

    public static List<Expression> getCalculatedValueList(Element context) {
        return ExtensionsUtils.getExtensionList(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-calculatedValue");
    }

    public static Extension makeCdsHooksEndpoint(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-cdsHooksEndpoint").setValue(new UriType(value));
    }

    public static PlanDefinition setCdsHooksEndpoint(PlanDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-cdsHooksEndpoint", new UriType(value));
        return context;
    }

    public static String getCdsHooksEndpoint(PlanDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/cqf-cdsHooksEndpoint");
    }

    public static Extension makeCQFCitation(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-citation").setValue(new StringType(value));
    }

    public static Element setCQFCitation(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-citation", new StringType(value));
        return context;
    }

    public static String getCQFCitation(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/cqf-citation");
    }

    public static Extension makeContactAddress(Address value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-contactAddress").setValue(value);
    }

    public static ContactDetail setContactAddress(ContactDetail context, Address value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-contactAddress", value);
        return context;
    }

    public static Address getContactAddress(ContactDetail context) {
        return ExtensionsUtils.getExtension(Address.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-contactAddress");
    }

    public static Extension makeContactReference(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-contactReference").setValue(value);
    }

    public static ContactDetail setContactReference(ContactDetail context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-contactReference", value);
        return context;
    }

    public static Reference getContactReference(ContactDetail context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-contactReference");
    }

    public static Extension makeContributionTime(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-contributionTime").setValue(new DateTimeType(value));
    }

    public static ContactDetail setContributionTime(ContactDetail context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-contributionTime", new DateTimeType(value));
        return context;
    }

    public static String getContributionTime(ContactDetail context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/cqf-contributionTime");
    }

    public static Extension makeCQFCQLOptions(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-cqlOptions").setValue(value);
    }

    public static Library setCQFCQLOptions(Library context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-cqlOptions", value);
        return context;
    }

    public static Reference getCQFCQLOptions(Library context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-cqlOptions");
    }

    public static Extension makeDirectReferenceCode(Coding value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode").setValue(value);
    }

    public static Element addDirectReferenceCode(Element context, Coding value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode", value);
        return context;
    }

    public static List<Coding> getDirectReferenceCodeList(Element context) {
        return ExtensionsUtils.getExtensionList(Coding.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-directReferenceCode");
    }

    public static Extension makeEncounterClass(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-encounterClass").setValue(value);
    }

    public static Basic setEncounterClass(Basic context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-encounterClass", value);
        return context;
    }

    public static CodeableConcept getEncounterClass(Basic context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-encounterClass");
    }

    public static Extension makeEncounterType(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-encounterType").setValue(value);
    }

    public static Basic setEncounterType(Basic context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-encounterType", value);
        return context;
    }

    public static CodeableConcept getEncounterType(Basic context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-encounterType");
    }

    public static Extension makeCQFExpression(Expression value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-expression").setValue(value);
    }

    public static Element setCQFExpression(Element context, Expression value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-expression", value);
        return context;
    }

    public static Expression getCQFExpression(Element context) {
        return ExtensionsUtils.getExtension(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-expression");
    }

    public static Extension makeInitialValue(Expression value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-initialValue").setValue(value);
    }

    public static Element addInitialValue(Element context, Expression value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-initialValue", value);
        return context;
    }

    public static List<Expression> getInitialValueList(Element context) {
        return ExtensionsUtils.getExtensionList(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-initialValue");
    }

    public static Extension makeInitiatingOrganization(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-initiatingOrganization").setValue(value);
    }

    public static Basic setInitiatingOrganization(Basic context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-initiatingOrganization", value);
        return context;
    }

    public static Reference getInitiatingOrganization(Basic context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-initiatingOrganization");
    }

    public static Extension makeInitiatingPerson(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-initiatingPerson").setValue(value);
    }

    public static Basic setInitiatingPerson(Basic context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-initiatingPerson", value);
        return context;
    }

    public static Reference getInitiatingPerson(Basic context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-initiatingPerson");
    }

    public static Extension makeInputParameters(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-inputParameters").setValue(value);
    }

    public static Element setInputParameters(Element context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-inputParameters", value);
        return context;
    }

    public static Reference getInputParameters(Element context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-inputParameters");
    }

    public static Extension makeIsPrefetchToken(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-isPrefetchToken").setValue(new BooleanType(value));
    }

    public static ParameterDefinition setIsPrefetchToken(ParameterDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-isPrefetchToken", new BooleanType(value));
        return context;
    }

    public static Boolean getIsPrefetchToken(ParameterDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/cqf-isPrefetchToken");
    }

    public static Extension makeCQFKnowledgeCapability(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-knowledgeCapability").setValue(new CodeType(value));
    }

    public static Element addCQFKnowledgeCapability(Element context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-knowledgeCapability", new CodeType(value));
        return context;
    }

    public static List<String> getCQFKnowledgeCapabilityList(Element context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/cqf-knowledgeCapability");
    }

    public static Extension makeCQFKnowledgeRepresentationLevel(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-knowledgeRepresentationLevel").setValue(new CodeType(value));
    }

    public static Element addCQFKnowledgeRepresentationLevel(Element context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-knowledgeRepresentationLevel", new CodeType(value));
        return context;
    }

    public static List<String> getCQFKnowledgeRepresentationLevelList(Element context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/cqf-knowledgeRepresentationLevel");
    }

    public static Extension makeCQFLibrary(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-library").setValue(new CanonicalType(value));
    }

    public static Element addCQFLibrary(Element context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-library", new CanonicalType(value));
        return context;
    }

    public static List<String> getCQFLibraryList(Element context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/cqf-library");
    }

    public static Extension makeParameterDefinition(ParameterDefinition value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-parameterDefinition").setValue(value);
    }

    public static TriggerDefinition addParameterDefinition(TriggerDefinition context, ParameterDefinition value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-parameterDefinition", value);
        return context;
    }

    public static List<ParameterDefinition> getParameterDefinitionList(TriggerDefinition context) {
        return ExtensionsUtils.getExtensionList(ParameterDefinition.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-parameterDefinition");
    }

    public static Extension makeQualityOfEvidence(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-qualityOfEvidence").setValue(value);
    }

    public static Element setQualityOfEvidence(Element context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-qualityOfEvidence", value);
        return context;
    }

    public static CodeableConcept getQualityOfEvidence(Element context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-qualityOfEvidence");
    }

    public static Extension makeReceivingOrganization(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-receivingOrganization").setValue(value);
    }

    public static Basic setReceivingOrganization(Basic context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-receivingOrganization", value);
        return context;
    }

    public static Reference getReceivingOrganization(Basic context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-receivingOrganization");
    }

    public static Extension makeReceivingPerson(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-receivingPerson").setValue(value);
    }

    public static Basic setReceivingPerson(Basic context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-receivingPerson", value);
        return context;
    }

    public static Reference getReceivingPerson(Basic context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-receivingPerson");
    }

    public static Extension makeRecipientLanguage(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-recipientLanguage").setValue(value);
    }

    public static Basic setRecipientLanguage(Basic context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-recipientLanguage", value);
        return context;
    }

    public static CodeableConcept getRecipientLanguage(Basic context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-recipientLanguage");
    }

    public static Extension makeRecipientType(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-recipientType").setValue(value);
    }

    public static Basic setRecipientType(Basic context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-recipientType", value);
        return context;
    }

    public static CodeableConcept getRecipientType(Basic context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-recipientType");
    }

    public static Extension makeStrengthOfRecommendation(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-strengthOfRecommendation").setValue(value);
    }

    public static Element setStrengthOfRecommendation(Element context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-strengthOfRecommendation", value);
        return context;
    }

    public static CodeableConcept getStrengthOfRecommendation(Element context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-strengthOfRecommendation");
    }

    public static Extension makeSupportedCqlVersion(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-supportedCqlVersion").setValue(new StringType(value));
    }

    public static CapabilityStatement.CapabilityStatementRestComponent addSupportedCqlVersion(CapabilityStatement.CapabilityStatementRestComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-supportedCqlVersion", new StringType(value));
        return context;
    }

    public static List<String> getSupportedCqlVersionList(CapabilityStatement.CapabilityStatementRestComponent context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/cqf-supportedCqlVersion");
    }

    public static Extension makeSystemUserLanguage(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-systemUserLanguage").setValue(value);
    }

    public static Basic setSystemUserLanguage(Basic context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-systemUserLanguage", value);
        return context;
    }

    public static CodeableConcept getSystemUserLanguage(Basic context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-systemUserLanguage");
    }

    public static Extension makeSystemUserTaskContext(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-systemUserTaskContext").setValue(value);
    }

    public static Basic setSystemUserTaskContext(Basic context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-systemUserTaskContext", value);
        return context;
    }

    public static CodeableConcept getSystemUserTaskContext(Basic context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-systemUserTaskContext");
    }

    public static Extension makeSystemUserType(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqf-systemUserType").setValue(value);
    }

    public static Basic setSystemUserType(Basic context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqf-systemUserType", value);
        return context;
    }

    public static CodeableConcept getSystemUserType(Basic context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/cqf-systemUserType");
    }

    public static Extension makeCValidityPeriod(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/cqm-ValidityPeriod").setValue(new DateTimeType(value));
    }

    public static Composition setCValidityPeriod(Composition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/cqm-ValidityPeriod", new DateTimeType(value));
        return context;
    }

    public static String getCValidityPeriod(Composition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/cqm-ValidityPeriod");
    }

    public static Extension makeDataAbsentReason(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/data-absent-reason").setValue(new CodeType(value));
    }

    public static Element setDataAbsentReason(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/data-absent-reason", new CodeType(value));
        return context;
    }

    public static String getDataAbsentReason(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/data-absent-reason");
    }

    public static Extension makeDesignNote(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/designNote").setValue(new MarkdownType(value));
    }

    public static ElementDefinition setDesignNote(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/designNote", new MarkdownType(value));
        return context;
    }

    public static String getDesignNote(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/designNote");
    }

    public static Questionnaire setDesignNote(Questionnaire context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/designNote", new MarkdownType(value));
        return context;
    }

    public static String getDesignNote(Questionnaire context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/designNote");
    }

    public static Questionnaire.QuestionnaireItemComponent setDesignNote(Questionnaire.QuestionnaireItemComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/designNote", new MarkdownType(value));
        return context;
    }

    public static String getDesignNote(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/designNote");
    }

    public static Extension makeDevCommercialBrand(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/device-commercialBrand").setValue(new StringType(value));
    }

    public static Device setDevCommercialBrand(Device context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/device-commercialBrand", new StringType(value));
        return context;
    }

    public static String getDevCommercialBrand(Device context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/device-commercialBrand");
    }

    public static DeviceDefinition setDevCommercialBrand(DeviceDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/device-commercialBrand", new StringType(value));
        return context;
    }

    public static String getDevCommercialBrand(DeviceDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/device-commercialBrand");
    }

    public static Extension makeDevImplantStatus(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/device-implantStatus").setValue(new CodeType(value));
    }

    public static Device setDevImplantStatus(Device context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/device-implantStatus", new CodeType(value));
        return context;
    }

    public static String getDevImplantStatus(Device context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/device-implantStatus");
    }

    public static Extension makeDRAddendumOf(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/diagnosticReport-addendumOf").setValue(value);
    }

    public static DiagnosticReport setDRAddendumOf(DiagnosticReport context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-addendumOf", value);
        return context;
    }

    public static Reference getDRAddendumOf(DiagnosticReport context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-addendumOf");
    }

    public static Extension makeDRExtends(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/diagnosticReport-extends").setValue(value);
    }

    public static DiagnosticReport setDRExtends(DiagnosticReport context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-extends", value);
        return context;
    }

    public static Reference getDRExtends(DiagnosticReport context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-extends");
    }

    public static Extension makeDRFocus(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/diagnosticReport-focus").setValue(value);
    }

    public static DiagnosticReport addDRFocus(DiagnosticReport context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-focus", value);
        return context;
    }

    public static List<Reference> getDRFocusList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-focus");
    }

    public static Extension makeDRLocationPerformed(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/diagnosticReport-locationPerformed").setValue(value);
    }

    public static DiagnosticReport setDRLocationPerformed(DiagnosticReport context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-locationPerformed", value);
        return context;
    }

    public static Reference getDRLocationPerformed(DiagnosticReport context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-locationPerformed");
    }

    public static Extension makeDRReplaces(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/diagnosticReport-replaces").setValue(value);
    }

    public static DiagnosticReport setDRReplaces(DiagnosticReport context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-replaces", value);
        return context;
    }

    public static Reference getDRReplaces(DiagnosticReport context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-replaces");
    }

    public static Extension makeDRRisk(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/diagnosticReport-risk").setValue(value);
    }

    public static DiagnosticReport addDRRisk(DiagnosticReport context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-risk", value);
        return context;
    }

    public static List<Reference> getDRRiskList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-risk");
    }

    public static Observation addDRRisk(Observation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-risk", value);
        return context;
    }

    public static List<Reference> getDRRiskList(Observation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-risk");
    }

    public static Extension makeDRSummaryOf(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/diagnosticReport-summaryOf").setValue(value);
    }

    public static DiagnosticReport setDRSummaryOf(DiagnosticReport context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-summaryOf", value);
        return context;
    }

    public static Reference getDRSummaryOf(DiagnosticReport context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/diagnosticReport-summaryOf");
    }

    public static Extension makeDisplayName(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/display").setValue(new StringType(value));
    }

    public static CanonicalType setDisplayName(CanonicalType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/display", new StringType(value));
        return context;
    }

    public static String getDisplayName(CanonicalType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/display");
    }

    public static Extension makeDRSourcepatient(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/documentreference-sourcepatient").setValue(value);
    }

    public static DocumentReference setDRSourcepatient(DocumentReference context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/documentreference-sourcepatient", value);
        return context;
    }

    public static Reference getDRSourcepatient(DocumentReference context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/documentreference-sourcepatient");
    }

    public static Extension makeDRThumbnail(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/documentreference-thumbnail").setValue(new BooleanType(value));
    }

    public static DocumentReference.DocumentReferenceContentComponent setDRThumbnail(DocumentReference.DocumentReferenceContentComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/documentreference-thumbnail", new BooleanType(value));
        return context;
    }

    public static Boolean getDRThumbnail(DocumentReference.DocumentReferenceContentComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/documentreference-thumbnail");
    }

    public static Extension makeAllowedUnits(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits").setValue(value);
    }

    public static Extension makeAllowedUnits(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits").setValue(new CanonicalType(value));
    }

    public static ElementDefinition setAllowedUnits(ElementDefinition context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits", value);
        return context;
    }

    public static CodeableConcept getAllowedUnitsCodeableConcept(ElementDefinition context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits");
    }

    public static ElementDefinition setAllowedUnits(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits", new CanonicalType(value));
        return context;
    }

    public static String getAllowedUnitsString(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits");
    }

    public static Extension makeBestPractice(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice").setValue(new BooleanType(value));
    }

    public static Extension makeBestPractice(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice").setValue(value);
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent setBestPractice(ElementDefinition.ElementDefinitionConstraintComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice", new BooleanType(value));
        return context;
    }

    public static Boolean getBestPracticeBoolean(ElementDefinition.ElementDefinitionConstraintComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice");
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent setBestPractice(ElementDefinition.ElementDefinitionConstraintComponent context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice", value);
        return context;
    }

    public static CodeableConcept getBestPracticeCodeableConcept(ElementDefinition.ElementDefinitionConstraintComponent context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice");
    }

    public static Extension makeBestPracticeExplanation(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice-explanation").setValue(new MarkdownType(value));
    }

    public static ElementDefinition.ElementDefinitionConstraintComponent setBestPracticeExplanation(ElementDefinition.ElementDefinitionConstraintComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice-explanation", new MarkdownType(value));
        return context;
    }

    public static String getBestPracticeExplanation(ElementDefinition.ElementDefinitionConstraintComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice-explanation");
    }

    public static Extension makeBindingName(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName").setValue(new StringType(value));
    }

    public static ElementDefinition.ElementDefinitionBindingComponent setBindingName(ElementDefinition.ElementDefinitionBindingComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName", new StringType(value));
        return context;
    }

    public static String getBindingName(ElementDefinition.ElementDefinitionBindingComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName");
    }

    public static Extension makeConceptmap(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-conceptmap").setValue(new CanonicalType(value));
    }

    public static Extension makeDefaultType(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype").setValue(new CanonicalType(value));
    }

    public static ElementDefinition setDefaultType(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype", new CanonicalType(value));
        return context;
    }

    public static String getDefaultType(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype");
    }

    public static Extension makeEquivalence(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-equivalence").setValue(new CodeType(value));
    }

    public static ElementDefinition.ElementDefinitionMappingComponent setEquivalence(ElementDefinition.ElementDefinitionMappingComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-equivalence", new CodeType(value));
        return context;
    }

    public static String getEquivalence(ElementDefinition.ElementDefinitionMappingComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-equivalence");
    }

    public static Extension makeGraphConstraint(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-graphConstraint").setValue(new CanonicalType(value));
    }

    public static Extension makeIdentifier(Identifier value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-identifier").setValue(value);
    }

    public static ElementDefinition addIdentifier(ElementDefinition context, Identifier value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-identifier", value);
        return context;
    }

    public static List<Identifier> getIdentifierList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionList(Identifier.class, context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-identifier");
    }

    public static Extension makeInheritedExtensibleValueSetUri(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-inheritedExtensibleValueSet").setValue(new UriType(value));
    }

    public static Extension makeInheritedExtensibleValueSetCanonical(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-inheritedExtensibleValueSet").setValue(new CanonicalType(value));
    }

    public static ElementDefinition.ElementDefinitionBindingComponent addInheritedExtensibleValueSetUri(ElementDefinition.ElementDefinitionBindingComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-inheritedExtensibleValueSet", new UriType(value));
        return context;
    }

    public static List<String> getInheritedExtensibleValueSetStringList(ElementDefinition.ElementDefinitionBindingComponent context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-inheritedExtensibleValueSet");
    }

    public static ElementDefinition.ElementDefinitionBindingComponent addInheritedExtensibleValueSetCanonical(ElementDefinition.ElementDefinitionBindingComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-inheritedExtensibleValueSet", new CanonicalType(value));
        return context;
    }

    public static Extension makeIsCommonBinding(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding").setValue(new BooleanType(value));
    }

    public static ElementDefinition.ElementDefinitionBindingComponent setIsCommonBinding(ElementDefinition.ElementDefinitionBindingComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding", new BooleanType(value));
        return context;
    }

    public static Boolean getIsCommonBinding(ElementDefinition.ElementDefinitionBindingComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding");
    }

    public static Extension makeMaxValueSetUri(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet").setValue(new UriType(value));
    }

    public static Extension makeMaxValueSetCanonical(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet").setValue(new CanonicalType(value));
    }

    public static ElementDefinition.ElementDefinitionBindingComponent setMaxValueSetUri(ElementDefinition.ElementDefinitionBindingComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet", new UriType(value));
        return context;
    }

    public static String getMaxValueSetString(ElementDefinition.ElementDefinitionBindingComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet");
    }

    public static ElementDefinition.ElementDefinitionBindingComponent setMaxValueSetCanonical(ElementDefinition.ElementDefinitionBindingComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet", new CanonicalType(value));
        return context;
    }

    public static Extension makeMinValueSetUri(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet").setValue(new UriType(value));
    }

    public static Extension makeMinValueSetCanonical(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet").setValue(new CanonicalType(value));
    }

    public static ElementDefinition.ElementDefinitionBindingComponent setMinValueSetUri(ElementDefinition.ElementDefinitionBindingComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet", new UriType(value));
        return context;
    }

    public static String getMinValueSetString(ElementDefinition.ElementDefinitionBindingComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet");
    }

    public static ElementDefinition.ElementDefinitionBindingComponent setMinValueSetCanonical(ElementDefinition.ElementDefinitionBindingComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet", new CanonicalType(value));
        return context;
    }

    public static Extension makeNamespace(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace").setValue(new UriType(value));
    }

    public static ElementDefinition setNamespace(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace", new UriType(value));
        return context;
    }

    public static String getNamespace(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
    }

    public static StructureDefinition setNamespace(StructureDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace", new UriType(value));
        return context;
    }

    public static String getNamespace(StructureDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
    }

    public static Extension makePattern(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-pattern").setValue(new CanonicalType(value));
    }

    public static ElementDefinition.TypeRefComponent setPattern(ElementDefinition.TypeRefComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-pattern", new CanonicalType(value));
        return context;
    }

    public static String getPattern(ElementDefinition.TypeRefComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-pattern");
    }

    public static Extension makeProfileElement(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element").setValue(new StringType(value));
    }

    public static Extension makeQuestion(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-question").setValue(new StringType(value));
    }

    public static ElementDefinition addQuestion(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-question", new StringType(value));
        return context;
    }

    public static List<String> getQuestionList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-question");
    }

    public static Extension makeSelector(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-selector").setValue(new StringType(value));
    }

    public static ElementDefinition setSelector(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-selector", new StringType(value));
        return context;
    }

    public static String getSelector(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-selector");
    }

    public static Extension makeSuppress(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress").setValue(new BooleanType(value));
    }

    public static Coding setSuppress(Coding context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress", new BooleanType(value));
        return context;
    }

    public static Boolean getSuppress(Coding context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress");
    }

    public static MarkdownType setSuppress(MarkdownType context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress", new BooleanType(value));
        return context;
    }

    public static Boolean getSuppress(MarkdownType context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress");
    }

    public static StringType setSuppress(StringType context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress", new BooleanType(value));
        return context;
    }

    public static Boolean getSuppress(StringType context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress");
    }

    public static ElementDefinition.ElementDefinitionExampleComponent setSuppress(ElementDefinition.ElementDefinitionExampleComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress", new BooleanType(value));
        return context;
    }

    public static Boolean getSuppress(ElementDefinition.ElementDefinitionExampleComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress");
    }

    public static ElementDefinition.ElementDefinitionMappingComponent setSuppress(ElementDefinition.ElementDefinitionMappingComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress", new BooleanType(value));
        return context;
    }

    public static Boolean getSuppress(ElementDefinition.ElementDefinitionMappingComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-suppress");
    }

    public static Extension makeTranslatable(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-translatable").setValue(new BooleanType(value));
    }

    public static ElementDefinition setTranslatable(ElementDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-translatable", new BooleanType(value));
        return context;
    }

    public static Boolean getTranslatable(ElementDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-translatable");
    }

    public static Extension makeTypeMustSupport(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support").setValue(new BooleanType(value));
    }

    public static ElementDefinition.TypeRefComponent setTypeMustSupport(ElementDefinition.TypeRefComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support", new BooleanType(value));
        return context;
    }

    public static Boolean getTypeMustSupport(ElementDefinition.TypeRefComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support");
    }

    public static Extension makeEncAssociatedEncounter(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/encounter-associatedEncounter").setValue(value);
    }

    public static Encounter setEncAssociatedEncounter(Encounter context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/encounter-associatedEncounter", value);
        return context;
    }

    public static Reference getEncAssociatedEncounter(Encounter context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/encounter-associatedEncounter");
    }

    public static Extension makeEncModeOfArrival(Coding value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/encounter-modeOfArrival").setValue(value);
    }

    public static Encounter setEncModeOfArrival(Encounter context, Coding value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/encounter-modeOfArrival", value);
        return context;
    }

    public static Coding getEncModeOfArrival(Encounter context) {
        return ExtensionsUtils.getExtension(Coding.class, context, "http://hl7.org/fhir/StructureDefinition/encounter-modeOfArrival");
    }

    public static Extension makeEncReasonCancelled(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/encounter-reasonCancelled").setValue(value);
    }

    public static Encounter setEncReasonCancelled(Encounter context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/encounter-reasonCancelled", value);
        return context;
    }

    public static CodeableConcept getEncReasonCancelled(Encounter context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/encounter-reasonCancelled");
    }

    public static Extension makeEntryFormat(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/entryFormat").setValue(new StringType(value));
    }

    public static ElementDefinition setEntryFormat(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/entryFormat", new StringType(value));
        return context;
    }

    public static String getEntryFormat(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/entryFormat");
    }

    public static Questionnaire.QuestionnaireItemComponent setEntryFormat(Questionnaire.QuestionnaireItemComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/entryFormat", new StringType(value));
        return context;
    }

    public static String getEntryFormat(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/entryFormat");
    }

    public static Extension makeBasedOn(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/event-basedOn").setValue(value);
    }

    public static ChargeItem addBasedOn(ChargeItem context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(ChargeItem context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static ClinicalImpression addBasedOn(ClinicalImpression context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(ClinicalImpression context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static Composition addBasedOn(Composition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(Composition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static Condition addBasedOn(Condition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(Condition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static Consent addBasedOn(Consent context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(Consent context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static Coverage addBasedOn(Coverage context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(Coverage context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static DetectedIssue addBasedOn(DetectedIssue context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(DetectedIssue context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static EpisodeOfCare addBasedOn(EpisodeOfCare context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(EpisodeOfCare context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static ExplanationOfBenefit addBasedOn(ExplanationOfBenefit context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(ExplanationOfBenefit context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static FamilyMemberHistory addBasedOn(FamilyMemberHistory context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(FamilyMemberHistory context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static ImmunizationEvaluation addBasedOn(ImmunizationEvaluation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(ImmunizationEvaluation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static InventoryReport addBasedOn(InventoryReport context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(InventoryReport context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static MedicationStatement addBasedOn(MedicationStatement context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(MedicationStatement context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static PaymentNotice addBasedOn(PaymentNotice context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(PaymentNotice context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static PaymentReconciliation addBasedOn(PaymentReconciliation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-basedOn", value);
        return context;
    }

    public static List<Reference> getBasedOnList(PaymentReconciliation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-basedOn");
    }

    public static Extension makeEventHistory(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/event-eventHistory").setValue(value);
    }

    public static DeviceUsage addEventHistory(DeviceUsage context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-eventHistory", value);
        return context;
    }

    public static List<Reference> getEventHistoryList(DeviceUsage context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-eventHistory");
    }

    public static DiagnosticReport addEventHistory(DiagnosticReport context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-eventHistory", value);
        return context;
    }

    public static List<Reference> getEventHistoryList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-eventHistory");
    }

    public static Observation addEventHistory(Observation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-eventHistory", value);
        return context;
    }

    public static List<Reference> getEventHistoryList(Observation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-eventHistory");
    }

    public static SupplyDelivery addEventHistory(SupplyDelivery context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-eventHistory", value);
        return context;
    }

    public static List<Reference> getEventHistoryList(SupplyDelivery context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-eventHistory");
    }

    public static Task addEventHistory(Task context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-eventHistory", value);
        return context;
    }

    public static List<Reference> getEventHistoryList(Task context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-eventHistory");
    }

    public static Extension makeEventLocation(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/event-location").setValue(value);
    }

    public static DiagnosticReport setEventLocation(DiagnosticReport context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/event-location", value);
        return context;
    }

    public static Reference getEventLocation(DiagnosticReport context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-location");
    }

    public static DocumentReference setEventLocation(DocumentReference context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/event-location", value);
        return context;
    }

    public static Reference getEventLocation(DocumentReference context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-location");
    }

    public static Observation setEventLocation(Observation context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/event-location", value);
        return context;
    }

    public static Reference getEventLocation(Observation context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-location");
    }

    public static SupplyDelivery setEventLocation(SupplyDelivery context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/event-location", value);
        return context;
    }

    public static Reference getEventLocation(SupplyDelivery context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-location");
    }

    public static Extension makePartOf(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/event-partOf").setValue(value);
    }

    public static Condition addPartOf(Condition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-partOf", value);
        return context;
    }

    public static List<Reference> getPartOfList(Condition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-partOf");
    }

    public static DiagnosticReport addPartOf(DiagnosticReport context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/event-partOf", value);
        return context;
    }

    public static List<Reference> getPartOfList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/event-partOf");
    }

    public static Extension makePerformerFunction(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/event-performerFunction").setValue(value);
    }

    public static Reference setPerformerFunction(Reference context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/event-performerFunction", value);
        return context;
    }

    public static CodeableConcept getPerformerFunction(Reference context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/event-performerFunction");
    }

    public static Extension makeEventStatusReason(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/event-statusReason").setValue(value);
    }

    public static DeviceUsage setEventStatusReason(DeviceUsage context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/event-statusReason", value);
        return context;
    }

    public static CodeableConcept getEventStatusReason(DeviceUsage context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/event-statusReason");
    }

    public static DiagnosticReport setEventStatusReason(DiagnosticReport context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/event-statusReason", value);
        return context;
    }

    public static CodeableConcept getEventStatusReason(DiagnosticReport context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/event-statusReason");
    }

    public static DocumentReference setEventStatusReason(DocumentReference context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/event-statusReason", value);
        return context;
    }

    public static CodeableConcept getEventStatusReason(DocumentReference context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/event-statusReason");
    }

    public static Observation setEventStatusReason(Observation context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/event-statusReason", value);
        return context;
    }

    public static CodeableConcept getEventStatusReason(Observation context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/event-statusReason");
    }

    public static SupplyDelivery setEventStatusReason(SupplyDelivery context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/event-statusReason", value);
        return context;
    }

    public static CodeableConcept getEventStatusReason(SupplyDelivery context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/event-statusReason");
    }

    public static Extension makeExtendedContactAvailability(Availability value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/extended-contact-availability").setValue(value);
    }

    public static Address setExtendedContactAvailability(Address context, Availability value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/extended-contact-availability", value);
        return context;
    }

    public static Availability getExtendedContactAvailability(Address context) {
        return ExtensionsUtils.getExtension(Availability.class, context, "http://hl7.org/fhir/StructureDefinition/extended-contact-availability");
    }

    public static ContactDetail setExtendedContactAvailability(ContactDetail context, Availability value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/extended-contact-availability", value);
        return context;
    }

    public static Availability getExtendedContactAvailability(ContactDetail context) {
        return ExtensionsUtils.getExtension(Availability.class, context, "http://hl7.org/fhir/StructureDefinition/extended-contact-availability");
    }

    public static ExtendedContactDetail setExtendedContactAvailability(ExtendedContactDetail context, Availability value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/extended-contact-availability", value);
        return context;
    }

    public static Availability getExtendedContactAvailability(ExtendedContactDetail context) {
        return ExtensionsUtils.getExtension(Availability.class, context, "http://hl7.org/fhir/StructureDefinition/extended-contact-availability");
    }

    public static Extension makeQuantityTranslation(Quantity value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/extension-quantity-translation").setValue(value);
    }

    public static Quantity addQuantityTranslation(Quantity context, Quantity value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/extension-quantity-translation", value);
        return context;
    }

    public static List<Quantity> getQuantityTranslationList(Quantity context) {
        return ExtensionsUtils.getExtensionList(Quantity.class, context, "http://hl7.org/fhir/StructureDefinition/extension-quantity-translation");
    }

    public static Extension makeFMHObservation(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/family-member-history-genetics-observation").setValue(value);
    }

    public static FamilyMemberHistory addFMHObservation(FamilyMemberHistory context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/family-member-history-genetics-observation", value);
        return context;
    }

    public static List<Reference> getFMHObservationList(FamilyMemberHistory context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/family-member-history-genetics-observation");
    }

    public static Extension makeFMHAbatement(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/familymemberhistory-abatement").setValue(new DateType(value));
    }

    public static Extension makeFMHAbatement(Age value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/familymemberhistory-abatement").setValue(value);
    }

    public static Extension makeFMHAbatement(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/familymemberhistory-abatement").setValue(new BooleanType(value));
    }

    public static FamilyMemberHistory.FamilyMemberHistoryConditionComponent setFMHAbatement(FamilyMemberHistory.FamilyMemberHistoryConditionComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/familymemberhistory-abatement", new DateType(value));
        return context;
    }

    public static String getFMHAbatementString(FamilyMemberHistory.FamilyMemberHistoryConditionComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/familymemberhistory-abatement");
    }

    public static FamilyMemberHistory.FamilyMemberHistoryConditionComponent setFMHAbatement(FamilyMemberHistory.FamilyMemberHistoryConditionComponent context, Age value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/familymemberhistory-abatement", value);
        return context;
    }

    public static Age getFMHAbatementAge(FamilyMemberHistory.FamilyMemberHistoryConditionComponent context) {
        return ExtensionsUtils.getExtension(Age.class, context, "http://hl7.org/fhir/StructureDefinition/familymemberhistory-abatement");
    }

    public static FamilyMemberHistory.FamilyMemberHistoryConditionComponent setFMHAbatement(FamilyMemberHistory.FamilyMemberHistoryConditionComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/familymemberhistory-abatement", new BooleanType(value));
        return context;
    }

    public static Boolean getFMHAbatementBoolean(FamilyMemberHistory.FamilyMemberHistoryConditionComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/familymemberhistory-abatement");
    }

    public static Extension makeFMHPatientRecord(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/familymemberhistory-patient-record").setValue(value);
    }

    public static FamilyMemberHistory addFMHPatientRecord(FamilyMemberHistory context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/familymemberhistory-patient-record", value);
        return context;
    }

    public static List<Reference> getFMHPatientRecordList(FamilyMemberHistory context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/familymemberhistory-patient-record");
    }

    public static Extension makeFMHSeverity(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/familymemberhistory-severity").setValue(value);
    }

    public static FamilyMemberHistory.FamilyMemberHistoryConditionComponent setFMHSeverity(FamilyMemberHistory.FamilyMemberHistoryConditionComponent context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/familymemberhistory-severity", value);
        return context;
    }

    public static CodeableConcept getFMHSeverity(FamilyMemberHistory.FamilyMemberHistoryConditionComponent context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/familymemberhistory-severity");
    }

    public static Extension makeFMHType(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/familymemberhistory-type").setValue(value);
    }

    public static FamilyMemberHistory setFMHType(FamilyMemberHistory context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/familymemberhistory-type", value);
        return context;
    }

    public static CodeableConcept getFMHType(FamilyMemberHistory context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/familymemberhistory-type");
    }

    public static Extension makeFirstCreated(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/firstCreated").setValue(new InstantType(value));
    }

    public static Meta setFirstCreated(Meta context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/firstCreated", new InstantType(value));
        return context;
    }

    public static String getFirstCreated(Meta context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/firstCreated");
    }

    public static Extension makeFlagDetail(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/flag-detail").setValue(value);
    }

    public static Flag addFlagDetail(Flag context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/flag-detail", value);
        return context;
    }

    public static List<Reference> getFlagDetailList(Flag context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/flag-detail");
    }

    public static Extension makeFlagPriority(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/flag-priority").setValue(value);
    }

    public static Flag setFlagPriority(Flag context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/flag-priority", value);
        return context;
    }

    public static CodeableConcept getFlagPriority(Flag context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/flag-priority");
    }

    public static Extension makeGoalReasonRejected(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/goal-reasonRejected").setValue(value);
    }

    public static Goal setGoalReasonRejected(Goal context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/goal-reasonRejected", value);
        return context;
    }

    public static CodeableConcept getGoalReasonRejected(Goal context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/goal-reasonRejected");
    }

    public static Extension makeBundleHttpResponseHeader(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/http-response-header").setValue(new StringType(value));
    }

    public static Extension makeAssemblyOrder(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/humanname-assembly-order").setValue(new CodeType(value));
    }

    public static HumanName setAssemblyOrder(HumanName context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/humanname-assembly-order", new CodeType(value));
        return context;
    }

    public static String getAssemblyOrder(HumanName context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/humanname-assembly-order");
    }

    public static Extension makeFathersFamily(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/humanname-fathers-family").setValue(new StringType(value));
    }

    public static StringType addFathersFamily(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/humanname-fathers-family", new StringType(value));
        return context;
    }

    public static List<String> getFathersFamilyList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/humanname-fathers-family");
    }

    public static Extension makeMothersFamily(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/humanname-mothers-family").setValue(new StringType(value));
    }

    public static StringType addMothersFamily(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/humanname-mothers-family", new StringType(value));
        return context;
    }

    public static List<String> getMothersFamilyList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/humanname-mothers-family");
    }

    public static Extension makeOwnName(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/humanname-own-name").setValue(new StringType(value));
    }

    public static StringType setOwnName(StringType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/humanname-own-name", new StringType(value));
        return context;
    }

    public static String getOwnName(StringType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/humanname-own-name");
    }

    public static Extension makeOwnPrefix(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/humanname-own-prefix").setValue(new StringType(value));
    }

    public static StringType setOwnPrefix(StringType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/humanname-own-prefix", new StringType(value));
        return context;
    }

    public static String getOwnPrefix(StringType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/humanname-own-prefix");
    }

    public static Extension makePartnerName(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/humanname-partner-name").setValue(new StringType(value));
    }

    public static StringType setPartnerName(StringType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/humanname-partner-name", new StringType(value));
        return context;
    }

    public static String getPartnerName(StringType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/humanname-partner-name");
    }

    public static Extension makePartnerPrefix(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/humanname-partner-prefix").setValue(new StringType(value));
    }

    public static StringType setPartnerPrefix(StringType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/humanname-partner-prefix", new StringType(value));
        return context;
    }

    public static String getPartnerPrefix(StringType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/humanname-partner-prefix");
    }

    public static Extension makeIDCheckDigit(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/identifier-checkDigit").setValue(new StringType(value));
    }

    public static Identifier setIDCheckDigit(Identifier context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/identifier-checkDigit", new StringType(value));
        return context;
    }

    public static String getIDCheckDigit(Identifier context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/identifier-checkDigit");
    }

    public static Extension makeValidDate(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/identifier-validDate").setValue(new DateTimeType(value));
    }

    public static Identifier addValidDate(Identifier context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/identifier-validDate", new DateTimeType(value));
        return context;
    }

    public static List<String> getValidDateList(Identifier context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/identifier-validDate");
    }

    public static Extension makeImmProcedure(CodeableReference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/immunization-procedure").setValue(value);
    }

    public static Immunization setImmProcedure(Immunization context, CodeableReference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/immunization-procedure", value);
        return context;
    }

    public static CodeableReference getImmProcedure(Immunization context) {
        return ExtensionsUtils.getExtension(CodeableReference.class, context, "http://hl7.org/fhir/StructureDefinition/immunization-procedure");
    }

    public static Extension makeADUse(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-AD-use").setValue(new CodeType(value));
    }

    public static Address setADUse(Address context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-AD-use", new CodeType(value));
        return context;
    }

    public static String getADUse(Address context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/iso21090-AD-use");
    }

    public static Extension makeADXPAdditionalLocator(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-additionalLocator").setValue(new StringType(value));
    }

    public static StringType addADXPAdditionalLocator(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-additionalLocator", new StringType(value));
        return context;
    }

    public static List<String> getADXPAdditionalLocatorList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-additionalLocator");
    }

    public static Extension makeADXPBuildingNumberSuffix(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-buildingNumberSuffix").setValue(new StringType(value));
    }

    public static StringType addADXPBuildingNumberSuffix(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-buildingNumberSuffix", new StringType(value));
        return context;
    }

    public static List<String> getADXPBuildingNumberSuffixList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-buildingNumberSuffix");
    }

    public static Extension makeADXPCareOf(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-careOf").setValue(new StringType(value));
    }

    public static StringType addADXPCareOf(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-careOf", new StringType(value));
        return context;
    }

    public static List<String> getADXPCareOfList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-careOf");
    }

    public static Extension makeADXPCensusTract(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-censusTract").setValue(new StringType(value));
    }

    public static StringType addADXPCensusTract(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-censusTract", new StringType(value));
        return context;
    }

    public static List<String> getADXPCensusTractList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-censusTract");
    }

    public static Extension makeADXPDelimiter(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-delimiter").setValue(new StringType(value));
    }

    public static StringType addADXPDelimiter(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-delimiter", new StringType(value));
        return context;
    }

    public static List<String> getADXPDelimiterList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-delimiter");
    }

    public static Extension makeADXPDeliveryAddressLine(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryAddressLine").setValue(new StringType(value));
    }

    public static StringType addADXPDeliveryAddressLine(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryAddressLine", new StringType(value));
        return context;
    }

    public static List<String> getADXPDeliveryAddressLineList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryAddressLine");
    }

    public static Extension makeADXPDeliveryInstallationArea(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryInstallationArea").setValue(new StringType(value));
    }

    public static StringType addADXPDeliveryInstallationArea(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryInstallationArea", new StringType(value));
        return context;
    }

    public static List<String> getADXPDeliveryInstallationAreaList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryInstallationArea");
    }

    public static Extension makeADXPDeliveryInstallationQualifier(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryInstallationQualifier").setValue(new StringType(value));
    }

    public static StringType addADXPDeliveryInstallationQualifier(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryInstallationQualifier", new StringType(value));
        return context;
    }

    public static List<String> getADXPDeliveryInstallationQualifierList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryInstallationQualifier");
    }

    public static Extension makeADXPDeliveryInstallationType(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryInstallationType").setValue(new StringType(value));
    }

    public static StringType addADXPDeliveryInstallationType(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryInstallationType", new StringType(value));
        return context;
    }

    public static List<String> getADXPDeliveryInstallationTypeList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryInstallationType");
    }

    public static Extension makeADXPDeliveryMode(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryMode").setValue(new StringType(value));
    }

    public static StringType addADXPDeliveryMode(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryMode", new StringType(value));
        return context;
    }

    public static List<String> getADXPDeliveryModeList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryMode");
    }

    public static Extension makeADXPDeliveryModeIdentifier(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryModeIdentifier").setValue(new StringType(value));
    }

    public static StringType addADXPDeliveryModeIdentifier(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryModeIdentifier", new StringType(value));
        return context;
    }

    public static List<String> getADXPDeliveryModeIdentifierList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-deliveryModeIdentifier");
    }

    public static Extension makeADXPDirection(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-direction").setValue(new StringType(value));
    }

    public static StringType addADXPDirection(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-direction", new StringType(value));
        return context;
    }

    public static List<String> getADXPDirectionList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-direction");
    }

    public static Extension makeADXPHouseNumber(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber").setValue(new StringType(value));
    }

    public static StringType addADXPHouseNumber(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber", new StringType(value));
        return context;
    }

    public static List<String> getADXPHouseNumberList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber");
    }

    public static Extension makeADXPHouseNumberNumeric(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumberNumeric").setValue(new StringType(value));
    }

    public static StringType addADXPHouseNumberNumeric(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumberNumeric", new StringType(value));
        return context;
    }

    public static List<String> getADXPHouseNumberNumericList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumberNumeric");
    }

    public static Extension makeADXPPostBox(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-postBox").setValue(new StringType(value));
    }

    public static StringType addADXPPostBox(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-postBox", new StringType(value));
        return context;
    }

    public static List<String> getADXPPostBoxList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-postBox");
    }

    public static Extension makeADXPPrecinct(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-precinct").setValue(new StringType(value));
    }

    public static Address addADXPPrecinct(Address context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-precinct", new StringType(value));
        return context;
    }

    public static List<String> getADXPPrecinctList(Address context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-precinct");
    }

    public static Extension makeADXPStreetAddressLine(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetAddressLine").setValue(new StringType(value));
    }

    public static StringType addADXPStreetAddressLine(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetAddressLine", new StringType(value));
        return context;
    }

    public static List<String> getADXPStreetAddressLineList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetAddressLine");
    }

    public static Extension makeADXPStreetName(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName").setValue(new StringType(value));
    }

    public static StringType addADXPStreetName(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName", new StringType(value));
        return context;
    }

    public static List<String> getADXPStreetNameList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName");
    }

    public static Extension makeADXPStreetNameBase(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameBase").setValue(new StringType(value));
    }

    public static StringType addADXPStreetNameBase(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameBase", new StringType(value));
        return context;
    }

    public static List<String> getADXPStreetNameBaseList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameBase");
    }

    public static Extension makeADXPStreetNameType(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameType").setValue(new StringType(value));
    }

    public static StringType addADXPStreetNameType(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameType", new StringType(value));
        return context;
    }

    public static List<String> getADXPStreetNameTypeList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetNameType");
    }

    public static Extension makeADXPUnitID(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-unitID").setValue(new StringType(value));
    }

    public static StringType addADXPUnitID(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-unitID", new StringType(value));
        return context;
    }

    public static List<String> getADXPUnitIDList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-unitID");
    }

    public static Extension makeADXPUnitType(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-unitType").setValue(new StringType(value));
    }

    public static StringType addADXPUnitType(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-unitType", new StringType(value));
        return context;
    }

    public static List<String> getADXPUnitTypeList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-unitType");
    }

    public static Extension makeENQualifier(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-EN-qualifier").setValue(new CodeType(value));
    }

    public static StringType addENQualifier(StringType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-EN-qualifier", new CodeType(value));
        return context;
    }

    public static List<String> getENQualifierList(StringType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/iso21090-EN-qualifier");
    }

    public static Extension makeENRepresentation(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-EN-representation").setValue(new CodeType(value));
    }

    public static HumanName setENRepresentation(HumanName context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-EN-representation", new CodeType(value));
        return context;
    }

    public static String getENRepresentation(HumanName context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/iso21090-EN-representation");
    }

    public static Extension makeENUse(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-EN-use").setValue(new CodeType(value));
    }

    public static HumanName setENUse(HumanName context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-EN-use", new CodeType(value));
        return context;
    }

    public static String getENUse(HumanName context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/iso21090-EN-use");
    }

    public static Extension makeTELAddress(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-TEL-address").setValue(new UrlType(value));
    }

    public static ContactPoint setTELAddress(ContactPoint context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-TEL-address", new UrlType(value));
        return context;
    }

    public static String getTELAddress(ContactPoint context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/iso21090-TEL-address");
    }

    public static Extension makeCodedString(Coding value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-codedString").setValue(value);
    }

    public static StringType addCodedString(StringType context, Coding value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-codedString", value);
        return context;
    }

    public static List<Coding> getCodedStringList(StringType context) {
        return ExtensionsUtils.getExtensionList(Coding.class, context, "http://hl7.org/fhir/StructureDefinition/iso21090-codedString");
    }

    public static Extension makeNullFlavor(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-nullFlavor").setValue(new CodeType(value));
    }

    public static Element setNullFlavor(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-nullFlavor", new CodeType(value));
        return context;
    }

    public static String getNullFlavor(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/iso21090-nullFlavor");
    }

    public static Extension makePreferred(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-preferred").setValue(new BooleanType(value));
    }

    public static Address setPreferred(Address context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-preferred", new BooleanType(value));
        return context;
    }

    public static Boolean getPreferred(Address context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/iso21090-preferred");
    }

    public static ContactPoint setPreferred(ContactPoint context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-preferred", new BooleanType(value));
        return context;
    }

    public static Boolean getPreferred(ContactPoint context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/iso21090-preferred");
    }

    public static ExtendedContactDetail setPreferred(ExtendedContactDetail context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-preferred", new BooleanType(value));
        return context;
    }

    public static Boolean getPreferred(ExtendedContactDetail context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/iso21090-preferred");
    }

    public static Extension makeUncertainty(float value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-uncertainty").setValue(new DecimalType(value));
    }

    public static Quantity setUncertainty(Quantity context, float value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-uncertainty", new DecimalType(value));
        return context;
    }

    public static BigDecimal getUncertainty(Quantity context) {
        return ExtensionsUtils.getExtensionFloat(context, "http://hl7.org/fhir/StructureDefinition/iso21090-uncertainty");
    }

    public static Extension makeUncertaintyType(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/iso21090-uncertaintyType").setValue(new CodeType(value));
    }

    public static Quantity setUncertaintyType(Quantity context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/iso21090-uncertaintyType", new CodeType(value));
        return context;
    }

    public static String getUncertaintyType(Quantity context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/iso21090-uncertaintyType");
    }

    public static Extension makeItemWeight(float value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/itemWeight").setValue(new DecimalType(value));
    }

    public static Coding setItemWeight(Coding context, float value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/itemWeight", new DecimalType(value));
        return context;
    }

    public static BigDecimal getItemWeight(Coding context) {
        return ExtensionsUtils.getExtensionFloat(context, "http://hl7.org/fhir/StructureDefinition/itemWeight");
    }

    public static Extension makeHumanLanguage(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/language").setValue(new CodeType(value));
    }

    public static Address setHumanLanguage(Address context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/language", new CodeType(value));
        return context;
    }

    public static String getHumanLanguage(Address context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/language");
    }

    public static Annotation setHumanLanguage(Annotation context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/language", new CodeType(value));
        return context;
    }

    public static String getHumanLanguage(Annotation context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/language");
    }

    public static HumanName setHumanLanguage(HumanName context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/language", new CodeType(value));
        return context;
    }

    public static String getHumanLanguage(HumanName context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/language");
    }

    public static MarkdownType setHumanLanguage(MarkdownType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/language", new CodeType(value));
        return context;
    }

    public static String getHumanLanguage(MarkdownType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/language");
    }

    public static StringType setHumanLanguage(StringType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/language", new CodeType(value));
        return context;
    }

    public static String getHumanLanguage(StringType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/language");
    }

    public static Extension makeLargeValue(float value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/largeValue").setValue(new DecimalType(value));
    }

    public static IntegerType setLargeValue(IntegerType context, float value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/largeValue", new DecimalType(value));
        return context;
    }

    public static BigDecimal getLargeValue(IntegerType context) {
        return ExtensionsUtils.getExtensionFloat(context, "http://hl7.org/fhir/StructureDefinition/largeValue");
    }

    public static Extension makeLastSourceSync(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/lastSourceSync").setValue(new DateTimeType(value));
    }

    public static Meta setLastSourceSync(Meta context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/lastSourceSync", new DateTimeType(value));
        return context;
    }

    public static String getLastSourceSync(Meta context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/lastSourceSync");
    }

    public static Extension makeListCategory(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/list-category").setValue(value);
    }

    public static ListResource setListCategory(ListResource context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/list-category", value);
        return context;
    }

    public static CodeableConcept getListCategory(ListResource context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/list-category");
    }

    public static Extension makeListChangeBase(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/list-changeBase").setValue(value);
    }

    public static ListResource setListChangeBase(ListResource context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/list-changeBase", value);
        return context;
    }

    public static Reference getListChangeBase(ListResource context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/list-changeBase");
    }

    public static Extension makeListFor(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/list-for").setValue(value);
    }

    public static ListResource addListFor(ListResource context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/list-for", value);
        return context;
    }

    public static List<Reference> getListForList(ListResource context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/list-for");
    }

    public static Extension makeLocBoundaryGeojson(Attachment value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/location-boundary-geojson").setValue(value);
    }

    public static Location setLocBoundaryGeojson(Location context, Attachment value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/location-boundary-geojson", value);
        return context;
    }

    public static Attachment getLocBoundaryGeojson(Location context) {
        return ExtensionsUtils.getExtension(Attachment.class, context, "http://hl7.org/fhir/StructureDefinition/location-boundary-geojson");
    }

    public static Extension makeLocCommunication(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/location-communication").setValue(value);
    }

    public static Location setLocCommunication(Location context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/location-communication", value);
        return context;
    }

    public static CodeableConcept getLocCommunication(Location context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/location-communication");
    }

    public static Extension makeBundleLocationDistance(Distance value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/location-distance").setValue(value);
    }

    public static Extension makeBundleMatchGrade(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/match-grade").setValue(new CodeType(value));
    }

    public static Extension makeMaxDecimalPlaces(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces").setValue(new IntegerType(value));
    }

    public static ElementDefinition setMaxDecimalPlaces(ElementDefinition context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces", new IntegerType(value));
        return context;
    }

    public static Integer getMaxDecimalPlaces(ElementDefinition context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces");
    }

    public static Questionnaire.QuestionnaireItemComponent setMaxDecimalPlaces(Questionnaire.QuestionnaireItemComponent context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces", new IntegerType(value));
        return context;
    }

    public static Integer getMaxDecimalPlaces(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces");
    }

    public static Extension makeMaxSize(float value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/maxSize").setValue(new DecimalType(value));
    }

    public static ElementDefinition setMaxSize(ElementDefinition context, float value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/maxSize", new DecimalType(value));
        return context;
    }

    public static BigDecimal getMaxSize(ElementDefinition context) {
        return ExtensionsUtils.getExtensionFloat(context, "http://hl7.org/fhir/StructureDefinition/maxSize");
    }

    public static Questionnaire.QuestionnaireItemComponent setMaxSize(Questionnaire.QuestionnaireItemComponent context, float value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/maxSize", new DecimalType(value));
        return context;
    }

    public static BigDecimal getMaxSize(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionFloat(context, "http://hl7.org/fhir/StructureDefinition/maxSize");
    }

    public static Extension makeMaxValue(DataType value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/maxValue").setValue(value);
    }

    public static Questionnaire.QuestionnaireItemComponent setMaxValue(Questionnaire.QuestionnaireItemComponent context, DataType value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/maxValue", value);
        return context;
    }

    public static DataType getMaxValue(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtension(DataType.class, context, "http://hl7.org/fhir/StructureDefinition/maxValue");
    }

    public static Extension makeMedQuantityRemaining(Quantity value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/medicationdispense-quantityRemaining").setValue(value);
    }

    public static MedicationDispense setMedQuantityRemaining(MedicationDispense context, Quantity value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/medicationdispense-quantityRemaining", value);
        return context;
    }

    public static Quantity getMedQuantityRemaining(MedicationDispense context) {
        return ExtensionsUtils.getExtension(Quantity.class, context, "http://hl7.org/fhir/StructureDefinition/medicationdispense-quantityRemaining");
    }

    public static Extension makeMedRefillsRemaining(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/medicationdispense-refillsRemaining").setValue(new IntegerType(value));
    }

    public static MedicationDispense setMedRefillsRemaining(MedicationDispense context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/medicationdispense-refillsRemaining", new IntegerType(value));
        return context;
    }

    public static Integer getMedRefillsRemaining(MedicationDispense context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/medicationdispense-refillsRemaining");
    }

    public static Extension makeMsgResponseRequest(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/messageheader-response-request").setValue(new CodeType(value));
    }

    public static MessageHeader setMsgResponseRequest(MessageHeader context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/messageheader-response-request", new CodeType(value));
        return context;
    }

    public static String getMsgResponseRequest(MessageHeader context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/messageheader-response-request");
    }

    public static Extension makeMimeType(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/mimeType").setValue(new CodeType(value));
    }

    public static ElementDefinition addMimeType(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/mimeType", new CodeType(value));
        return context;
    }

    public static List<String> getMimeTypeList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/mimeType");
    }

    public static Questionnaire.QuestionnaireItemComponent addMimeType(Questionnaire.QuestionnaireItemComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/mimeType", new CodeType(value));
        return context;
    }

    public static List<String> getMimeTypeList(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/mimeType");
    }

    public static Extension makeMinLength(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/minLength").setValue(new IntegerType(value));
    }

    public static ElementDefinition setMinLength(ElementDefinition context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/minLength", new IntegerType(value));
        return context;
    }

    public static Integer getMinLength(ElementDefinition context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/minLength");
    }

    public static Questionnaire.QuestionnaireItemComponent setMinLength(Questionnaire.QuestionnaireItemComponent context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/minLength", new IntegerType(value));
        return context;
    }

    public static Integer getMinLength(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/minLength");
    }

    public static Extension makeMinValue(DataType value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/minValue").setValue(value);
    }

    public static Questionnaire.QuestionnaireItemComponent setMinValue(Questionnaire.QuestionnaireItemComponent context, DataType value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/minValue", value);
        return context;
    }

    public static DataType getMinValue(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtension(DataType.class, context, "http://hl7.org/fhir/StructureDefinition/minValue");
    }

    public static Extension makeNSCheckDigit(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/namingsystem-checkDigit").setValue(new StringType(value));
    }

    public static NamingSystem setNSCheckDigit(NamingSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/namingsystem-checkDigit", new StringType(value));
        return context;
    }

    public static String getNSCheckDigit(NamingSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/namingsystem-checkDigit");
    }

    public static Extension makeNarrativeLink(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/narrativeLink").setValue(new UrlType(value));
    }

    public static Element setNarrativeLink(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/narrativeLink", new UrlType(value));
        return context;
    }

    public static String getNarrativeLink(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/narrativeLink");
    }

    public static Extension makePatNoFixedAddress(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/no-fixed-address").setValue(new BooleanType(value));
    }

    public static Address setPatNoFixedAddress(Address context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/no-fixed-address", new BooleanType(value));
        return context;
    }

    public static Boolean getPatNoFixedAddress(Address context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/no-fixed-address");
    }

    public static Extension makeNttAdaptiveFeedingDevice(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/nutritionorder-adaptiveFeedingDevice").setValue(value);
    }

    public static NutritionOrder.NutritionOrderOralDietComponent addNttAdaptiveFeedingDevice(NutritionOrder.NutritionOrderOralDietComponent context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/nutritionorder-adaptiveFeedingDevice", value);
        return context;
    }

    public static List<CodeableConcept> getNttAdaptiveFeedingDeviceList(NutritionOrder.NutritionOrderOralDietComponent context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/nutritionorder-adaptiveFeedingDevice");
    }

    public static Extension makeObsBodyPosition(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/observation-bodyPosition").setValue(value);
    }

    public static Observation setObsBodyPosition(Observation context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-bodyPosition", value);
        return context;
    }

    public static CodeableConcept getObsBodyPosition(Observation context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/observation-bodyPosition");
    }

    public static Specimen.SpecimenCollectionComponent setObsBodyPosition(Specimen.SpecimenCollectionComponent context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-bodyPosition", value);
        return context;
    }

    public static CodeableConcept getObsBodyPosition(Specimen.SpecimenCollectionComponent context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/observation-bodyPosition");
    }

    public static Extension makeObsDelta(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/observation-delta").setValue(value);
    }

    public static Observation setObsDelta(Observation context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-delta", value);
        return context;
    }

    public static CodeableConcept getObsDelta(Observation context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/observation-delta");
    }

    public static Extension makeObsDeviceCode(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/observation-deviceCode").setValue(value);
    }

    public static Observation setObsDeviceCode(Observation context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-deviceCode", value);
        return context;
    }

    public static CodeableConcept getObsDeviceCode(Observation context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/observation-deviceCode");
    }

    public static Extension makeObsFocusCode(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/observation-focusCode").setValue(value);
    }

    public static Observation setObsFocusCode(Observation context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-focusCode", value);
        return context;
    }

    public static CodeableConcept getObsFocusCode(Observation context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/observation-focusCode");
    }

    public static Extension makeObsGatewayDevice(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/observation-gatewayDevice").setValue(value);
    }

    public static Observation setObsGatewayDevice(Observation context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-gatewayDevice", value);
        return context;
    }

    public static Reference getObsGatewayDevice(Observation context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/observation-gatewayDevice");
    }

    public static Extension makeObsPrecondition(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/observation-precondition").setValue(value);
    }

    public static Observation addObsPrecondition(Observation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-precondition", value);
        return context;
    }

    public static List<Reference> getObsPreconditionList(Observation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/observation-precondition");
    }

    public static Extension makeObsReagent(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/observation-reagent").setValue(value);
    }

    public static Observation addObsReagent(Observation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-reagent", value);
        return context;
    }

    public static List<Reference> getObsReagentList(Observation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/observation-reagent");
    }

    public static Extension makeObsReplaces(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/observation-replaces").setValue(value);
    }

    public static Observation addObsReplaces(Observation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-replaces", value);
        return context;
    }

    public static List<Reference> getObsReplacesList(Observation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/observation-replaces");
    }

    public static Extension makeObsSecondaryFinding(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/observation-secondaryFinding").setValue(value);
    }

    public static Observation setObsSecondaryFinding(Observation context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-secondaryFinding", value);
        return context;
    }

    public static CodeableConcept getObsSecondaryFinding(Observation context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/observation-secondaryFinding");
    }

    public static Extension makeObsSequelTo(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/observation-sequelTo").setValue(value);
    }

    public static Observation addObsSequelTo(Observation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-sequelTo", value);
        return context;
    }

    public static List<Reference> getObsSequelToList(Observation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/observation-sequelTo");
    }

    public static Extension makeObsSpecimenCode(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/observation-specimenCode").setValue(value);
    }

    public static Observation setObsSpecimenCode(Observation context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-specimenCode", value);
        return context;
    }

    public static CodeableConcept getObsSpecimenCode(Observation context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/observation-specimenCode");
    }

    public static Extension makeObsTimeOffset(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/observation-timeOffset").setValue(new IntegerType(value));
    }

    public static Observation.ObservationComponentComponent addObsTimeOffset(Observation.ObservationComponentComponent context, int value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/observation-timeOffset", new IntegerType(value));
        return context;
    }

    public static List<Integer> getObsTimeOffsetList(Observation.ObservationComponentComponent context) {
        return ExtensionsUtils.getExtensionIntList(context, "http://hl7.org/fhir/StructureDefinition/observation-timeOffset");
    }

    public static Extension makeAIAdministration(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/openEHR-administration").setValue(value);
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent setAIAdministration(AllergyIntolerance.AllergyIntoleranceReactionComponent context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/openEHR-administration", value);
        return context;
    }

    public static Reference getAIAdministration(AllergyIntolerance.AllergyIntoleranceReactionComponent context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/openEHR-administration");
    }

    public static Extension makeAICareplan(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/openEHR-careplan").setValue(value);
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent setAICareplan(AllergyIntolerance.AllergyIntoleranceReactionComponent context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/openEHR-careplan", value);
        return context;
    }

    public static Reference getAICareplan(AllergyIntolerance.AllergyIntoleranceReactionComponent context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/openEHR-careplan");
    }

    public static Extension makeAIExposureDate(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/openEHR-exposureDate").setValue(new DateTimeType(value));
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent setAIExposureDate(AllergyIntolerance.AllergyIntoleranceReactionComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/openEHR-exposureDate", new DateTimeType(value));
        return context;
    }

    public static String getAIExposureDate(AllergyIntolerance.AllergyIntoleranceReactionComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/openEHR-exposureDate");
    }

    public static Extension makeAIExposureDescription(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/openEHR-exposureDescription").setValue(new StringType(value));
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent setAIExposureDescription(AllergyIntolerance.AllergyIntoleranceReactionComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/openEHR-exposureDescription", new StringType(value));
        return context;
    }

    public static String getAIExposureDescription(AllergyIntolerance.AllergyIntoleranceReactionComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/openEHR-exposureDescription");
    }

    public static Extension makeAIExposureDuration(Duration value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/openEHR-exposureDuration").setValue(value);
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent setAIExposureDuration(AllergyIntolerance.AllergyIntoleranceReactionComponent context, Duration value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/openEHR-exposureDuration", value);
        return context;
    }

    public static Duration getAIExposureDuration(AllergyIntolerance.AllergyIntoleranceReactionComponent context) {
        return ExtensionsUtils.getExtension(Duration.class, context, "http://hl7.org/fhir/StructureDefinition/openEHR-exposureDuration");
    }

    public static Extension makeAILocation(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/openEHR-location").setValue(value);
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent addAILocation(AllergyIntolerance.AllergyIntoleranceReactionComponent context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/openEHR-location", value);
        return context;
    }

    public static List<CodeableConcept> getAILocationList(AllergyIntolerance.AllergyIntoleranceReactionComponent context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/openEHR-location");
    }

    public static Extension makeAIManagement(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/openEHR-management").setValue(new StringType(value));
    }

    public static AllergyIntolerance.AllergyIntoleranceReactionComponent setAIManagement(AllergyIntolerance.AllergyIntoleranceReactionComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/openEHR-management", new StringType(value));
        return context;
    }

    public static String getAIManagement(AllergyIntolerance.AllergyIntoleranceReactionComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/openEHR-management");
    }

    public static Extension makeODProfile(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/operationdefinition-profile").setValue(new UriType(value));
    }

    public static OperationDefinition.OperationDefinitionParameterComponent addODProfile(OperationDefinition.OperationDefinitionParameterComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile", new UriType(value));
        return context;
    }

    public static List<String> getODProfileList(OperationDefinition.OperationDefinitionParameterComponent context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/operationdefinition-profile");
    }

    public static Extension makeOOAuthority(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/operationoutcome-authority").setValue(new UriType(value));
    }

    public static OperationOutcome.OperationOutcomeIssueComponent setOOAuthority(OperationOutcome.OperationOutcomeIssueComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-authority", new UriType(value));
        return context;
    }

    public static String getOOAuthority(OperationOutcome.OperationOutcomeIssueComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-authority");
    }

    public static Extension makeOODetectedIssue(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/operationoutcome-detectedIssue").setValue(value);
    }

    public static OperationOutcome.OperationOutcomeIssueComponent setOODetectedIssue(OperationOutcome.OperationOutcomeIssueComponent context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-detectedIssue", value);
        return context;
    }

    public static Reference getOODetectedIssue(OperationOutcome.OperationOutcomeIssueComponent context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-detectedIssue");
    }

    public static Extension makeOOSourceFile(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/operationoutcome-file").setValue(new StringType(value));
    }

    public static OperationOutcome.OperationOutcomeIssueComponent setOOSourceFile(OperationOutcome.OperationOutcomeIssueComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-file", new StringType(value));
        return context;
    }

    public static String getOOSourceFile(OperationOutcome.OperationOutcomeIssueComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-file");
    }

    public static Extension makeOOIssueCol(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col").setValue(new StringType(value));
    }

    public static OperationOutcome.OperationOutcomeIssueComponent setOOIssueCol(OperationOutcome.OperationOutcomeIssueComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col", new StringType(value));
        return context;
    }

    public static String getOOIssueCol(OperationOutcome.OperationOutcomeIssueComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col");
    }

    public static Extension makeOOIssueline(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line").setValue(new StringType(value));
    }

    public static OperationOutcome.OperationOutcomeIssueComponent setOOIssueline(OperationOutcome.OperationOutcomeIssueComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line", new StringType(value));
        return context;
    }

    public static String getOOIssueline(OperationOutcome.OperationOutcomeIssueComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line");
    }

    public static Extension makeOOIssuesource(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source").setValue(new StringType(value));
    }

    public static OperationOutcome.OperationOutcomeIssueComponent setOOIssuesource(OperationOutcome.OperationOutcomeIssueComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source", new StringType(value));
        return context;
    }

    public static String getOOIssuesource(OperationOutcome.OperationOutcomeIssueComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
    }

    public static Extension makeOOIssueSource(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id").setValue(new StringType(value));
    }

    public static OperationOutcome.OperationOutcomeIssueComponent setOOIssueSource(OperationOutcome.OperationOutcomeIssueComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id", new StringType(value));
        return context;
    }

    public static String getOOIssueSource(OperationOutcome.OperationOutcomeIssueComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id");
    }

    public static Extension makeOrgPeriod(Period value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/organization-period").setValue(value);
    }

    public static Organization setOrgPeriod(Organization context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/organization-period", value);
        return context;
    }

    public static Period getOrgPeriod(Organization context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/organization-period");
    }

    public static Extension makeOrgPreferredContact(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/organization-preferredContact").setValue(new BooleanType(value));
    }

    public static ExtendedContactDetail setOrgPreferredContact(ExtendedContactDetail context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/organization-preferredContact", new BooleanType(value));
        return context;
    }

    public static Boolean getOrgPreferredContact(ExtendedContactDetail context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/organization-preferredContact");
    }

    public static Extension makeOrgPrimaryInd(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/organizationaffiliation-primaryInd").setValue(new BooleanType(value));
    }

    public static CodeableConcept setOrgPrimaryInd(CodeableConcept context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/organizationaffiliation-primaryInd", new BooleanType(value));
        return context;
    }

    public static Boolean getOrgPrimaryInd(CodeableConcept context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/organizationaffiliation-primaryInd");
    }

    public static Extension makeOriginalTextString(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/originalText").setValue(new StringType(value));
    }

    public static Extension makeOriginalTextUrl(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/originalText").setValue(new UrlType(value));
    }

    public static Element setOriginalTextString(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/originalText", new StringType(value));
        return context;
    }

    public static String getOriginalTextString(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/originalText");
    }

    public static Element setOriginalTextUrl(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/originalText", new UrlType(value));
        return context;
    }

    public static Extension makeParametersDefinition(ParameterDefinition value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/parameters-definition").setValue(value);
    }

    public static Parameters.ParametersParameterComponent setParametersDefinition(Parameters.ParametersParameterComponent context, ParameterDefinition value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/parameters-definition", value);
        return context;
    }

    public static ParameterDefinition getParametersDefinition(Parameters.ParametersParameterComponent context) {
        return ExtensionsUtils.getExtension(ParameterDefinition.class, context, "http://hl7.org/fhir/StructureDefinition/parameters-definition");
    }

    public static Extension makeParamFullUrl(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/parameters-fullUrl").setValue(new UriType(value));
    }

    public static Parameters.ParametersParameterComponent setParamFullUrl(Parameters.ParametersParameterComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/parameters-fullUrl", new UriType(value));
        return context;
    }

    public static String getParamFullUrl(Parameters.ParametersParameterComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/parameters-fullUrl");
    }

    public static Extension makePatAdoptionInfo(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-adoptionInfo").setValue(value);
    }

    public static Patient setPatAdoptionInfo(Patient context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/patient-adoptionInfo", value);
        return context;
    }

    public static CodeableConcept getPatAdoptionInfo(Patient context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/patient-adoptionInfo");
    }

    public static Extension makePatBirthPlace(Address value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-birthPlace").setValue(value);
    }

    public static Patient setPatBirthPlace(Patient context, Address value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/patient-birthPlace", value);
        return context;
    }

    public static Address getPatBirthPlace(Patient context) {
        return ExtensionsUtils.getExtension(Address.class, context, "http://hl7.org/fhir/StructureDefinition/patient-birthPlace");
    }

    public static Extension makePatBirthTime(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-birthTime").setValue(new DateTimeType(value));
    }

    public static DateType setPatBirthTime(DateType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/patient-birthTime", new DateTimeType(value));
        return context;
    }

    public static String getPatBirthTime(DateType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/patient-birthTime");
    }

    public static Extension makePatCadavericDonor(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-cadavericDonor").setValue(new BooleanType(value));
    }

    public static Patient setPatCadavericDonor(Patient context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/patient-cadavericDonor", new BooleanType(value));
        return context;
    }

    public static Boolean getPatCadavericDonor(Patient context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/patient-cadavericDonor");
    }

    public static Extension makePatCongregation(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-congregation").setValue(new StringType(value));
    }

    public static Patient setPatCongregation(Patient context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/patient-congregation", new StringType(value));
        return context;
    }

    public static String getPatCongregation(Patient context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/patient-congregation");
    }

    public static Extension makePatDisability(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-disability").setValue(value);
    }

    public static Patient addPatDisability(Patient context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/patient-disability", value);
        return context;
    }

    public static List<CodeableConcept> getPatDisabilityList(Patient context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/patient-disability");
    }

    public static Extension makePatImportance(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-importance").setValue(value);
    }

    public static Patient setPatImportance(Patient context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/patient-importance", value);
        return context;
    }

    public static CodeableConcept getPatImportance(Patient context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/patient-importance");
    }

    public static Extension makePatInterpreterRequired(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-interpreterRequired").setValue(new BooleanType(value));
    }

    public static Patient setPatInterpreterRequired(Patient context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/patient-interpreterRequired", new BooleanType(value));
        return context;
    }

    public static Boolean getPatInterpreterRequired(Patient context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/patient-interpreterRequired");
    }

    public static Extension makePatMothersMaidenName(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-mothersMaidenName").setValue(new StringType(value));
    }

    public static Patient setPatMothersMaidenName(Patient context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/patient-mothersMaidenName", new StringType(value));
        return context;
    }

    public static String getPatMothersMaidenName(Patient context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/patient-mothersMaidenName");
    }

    public static Extension makePatMultipleBirthTotal(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-multipleBirthTotal").setValue(new PositiveIntType(value));
    }

    public static DataType setPatMultipleBirthTotal(DataType context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/patient-multipleBirthTotal", new PositiveIntType(value));
        return context;
    }

    public static Integer getPatMultipleBirthTotal(DataType context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/patient-multipleBirthTotal");
    }

    public static Extension makePatPreferenceType(Coding value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-preferenceType").setValue(value);
    }

    public static Extension makePatRelatedPerson(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-relatedPerson").setValue(value);
    }

    public static Patient.ContactComponent addPatRelatedPerson(Patient.ContactComponent context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/patient-relatedPerson", value);
        return context;
    }

    public static List<Reference> getPatRelatedPersonList(Patient.ContactComponent context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/patient-relatedPerson");
    }

    public static Extension makePatReligion(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/patient-religion").setValue(value);
    }

    public static Patient addPatReligion(Patient context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/patient-religion", value);
        return context;
    }

    public static List<CodeableConcept> getPatReligionList(Patient context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/patient-religion");
    }

    public static Extension makePRAnimalSpecies(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/practitioner-animalSpecies").setValue(value);
    }

    public static Practitioner setPRAnimalSpecies(Practitioner context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/practitioner-animalSpecies", value);
        return context;
    }

    public static CodeableConcept getPRAnimalSpecies(Practitioner context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/practitioner-animalSpecies");
    }

    public static RelatedPerson setPRAnimalSpecies(RelatedPerson context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/practitioner-animalSpecies", value);
        return context;
    }

    public static CodeableConcept getPRAnimalSpecies(RelatedPerson context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/practitioner-animalSpecies");
    }

    public static Extension makePRJobTitle(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/practitioner-job-title").setValue(value);
    }

    public static Practitioner setPRJobTitle(Practitioner context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/practitioner-job-title", value);
        return context;
    }

    public static CodeableConcept getPRJobTitle(Practitioner context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/practitioner-job-title");
    }

    public static PractitionerRole setPRJobTitle(PractitionerRole context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/practitioner-job-title", value);
        return context;
    }

    public static CodeableConcept getPRJobTitle(PractitionerRole context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/practitioner-job-title");
    }

    public static Extension makePRPrimaryInd(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/practitionerrole-primaryInd").setValue(new BooleanType(value));
    }

    public static CodeableConcept setPRPrimaryInd(CodeableConcept context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/practitionerrole-primaryInd", new BooleanType(value));
        return context;
    }

    public static Boolean getPRPrimaryInd(CodeableConcept context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/practitionerrole-primaryInd");
    }

    public static Extension makePRApproachBodyStructure(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/procedure-approachBodyStructure").setValue(value);
    }

    public static DeviceRequest addPRApproachBodyStructure(DeviceRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-approachBodyStructure", value);
        return context;
    }

    public static List<Reference> getPRApproachBodyStructureList(DeviceRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-approachBodyStructure");
    }

    public static DeviceUsage addPRApproachBodyStructure(DeviceUsage context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-approachBodyStructure", value);
        return context;
    }

    public static List<Reference> getPRApproachBodyStructureList(DeviceUsage context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-approachBodyStructure");
    }

    public static Procedure addPRApproachBodyStructure(Procedure context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-approachBodyStructure", value);
        return context;
    }

    public static List<Reference> getPRApproachBodyStructureList(Procedure context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-approachBodyStructure");
    }

    public static ServiceRequest addPRApproachBodyStructure(ServiceRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-approachBodyStructure", value);
        return context;
    }

    public static List<Reference> getPRApproachBodyStructureList(ServiceRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-approachBodyStructure");
    }

    public static Extension makePRCausedBy(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/procedure-causedBy").setValue(value);
    }

    public static Procedure addPRCausedBy(Procedure context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-causedBy", value);
        return context;
    }

    public static List<Reference> getPRCausedByList(Procedure context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-causedBy");
    }

    public static Extension makePRDirectedBy(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/procedure-directedBy").setValue(value);
    }

    public static Extension makePRDirectedBy(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/procedure-directedBy").setValue(value);
    }

    public static Procedure setPRDirectedBy(Procedure context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-directedBy", value);
        return context;
    }

    public static CodeableConcept getPRDirectedByCodeableConcept(Procedure context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-directedBy");
    }

    public static Procedure setPRDirectedBy(Procedure context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-directedBy", value);
        return context;
    }

    public static Reference getPRDirectedByReference(Procedure context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-directedBy");
    }

    public static ServiceRequest setPRDirectedBy(ServiceRequest context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-directedBy", value);
        return context;
    }

    public static CodeableConcept getPRDirectedByCodeableConcept(ServiceRequest context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-directedBy");
    }

    public static ServiceRequest setPRDirectedBy(ServiceRequest context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-directedBy", value);
        return context;
    }

    public static Reference getPRDirectedByReference(ServiceRequest context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-directedBy");
    }

    public static Extension makePRIncisionDateTime(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/procedure-incisionDateTime").setValue(new DateTimeType(value));
    }

    public static Procedure setPRIncisionDateTime(Procedure context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-incisionDateTime", new DateTimeType(value));
        return context;
    }

    public static String getPRIncisionDateTime(Procedure context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/procedure-incisionDateTime");
    }

    public static Extension makePRMethod(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/procedure-method").setValue(value);
    }

    public static Procedure addPRMethod(Procedure context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-method", value);
        return context;
    }

    public static List<CodeableConcept> getPRMethodList(Procedure context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-method");
    }

    public static Extension makePRProgressStatus(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/procedure-progressStatus").setValue(value);
    }

    public static Procedure setPRProgressStatus(Procedure context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-progressStatus", value);
        return context;
    }

    public static CodeableConcept getPRProgressStatus(Procedure context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-progressStatus");
    }

    public static Extension makePRTargetBodyStructure(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/procedure-targetBodyStructure").setValue(value);
    }

    public static Procedure addPRTargetBodyStructure(Procedure context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-targetBodyStructure", value);
        return context;
    }

    public static List<Reference> getPRTargetBodyStructureList(Procedure context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-targetBodyStructure");
    }

    public static ServiceRequest addPRTargetBodyStructure(ServiceRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/procedure-targetBodyStructure", value);
        return context;
    }

    public static List<Reference> getPRTargetBodyStructureList(ServiceRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/procedure-targetBodyStructure");
    }

    public static Extension makePrecision(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/quantity-precision").setValue(new IntegerType(value));
    }

    public static DecimalType setPrecision(DecimalType context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/quantity-precision", new IntegerType(value));
        return context;
    }

    public static Integer getPrecision(DecimalType context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/quantity-precision");
    }

    public static Extension makeQBaseType(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-baseType").setValue(new CodeType(value));
    }

    public static ElementDefinition setQBaseType(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-baseType", new CodeType(value));
        return context;
    }

    public static String getQBaseType(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-baseType");
    }

    public static Questionnaire.QuestionnaireItemComponent setQBaseType(Questionnaire.QuestionnaireItemComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-baseType", new CodeType(value));
        return context;
    }

    public static String getQBaseType(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-baseType");
    }

    public static Extension makeQChoiceOrientation(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation").setValue(new CodeType(value));
    }

    public static ElementDefinition setQChoiceOrientation(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation", new CodeType(value));
        return context;
    }

    public static String getQChoiceOrientation(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation");
    }

    public static Questionnaire.QuestionnaireItemComponent setQChoiceOrientation(Questionnaire.QuestionnaireItemComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation", new CodeType(value));
        return context;
    }

    public static String getQChoiceOrientation(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation");
    }

    public static Extension makeQDefinitionBased(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-definitionBased").setValue(new BooleanType(value));
    }

    public static Questionnaire setQDefinitionBased(Questionnaire context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-definitionBased", new BooleanType(value));
        return context;
    }

    public static Boolean getQDefinitionBased(Questionnaire context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-definitionBased");
    }

    public static Extension makeQDisplayCategory(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory").setValue(value);
    }

    public static ElementDefinition setQDisplayCategory(ElementDefinition context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory", value);
        return context;
    }

    public static CodeableConcept getQDisplayCategory(ElementDefinition context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory");
    }

    public static Questionnaire.QuestionnaireItemComponent setQDisplayCategory(Questionnaire.QuestionnaireItemComponent context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory", value);
        return context;
    }

    public static CodeableConcept getQDisplayCategory(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory");
    }

    public static Extension makeQFhirType(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-fhirType").setValue(new StringType(value));
    }

    public static ElementDefinition setQFhirType(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-fhirType", new StringType(value));
        return context;
    }

    public static String getQFhirType(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-fhirType");
    }

    public static Questionnaire.QuestionnaireItemComponent setQFhirType(Questionnaire.QuestionnaireItemComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-fhirType", new StringType(value));
        return context;
    }

    public static String getQFhirType(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-fhirType");
    }

    public static Extension makeQHidden(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-hidden").setValue(new BooleanType(value));
    }

    public static ElementDefinition setQHidden(ElementDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden", new BooleanType(value));
        return context;
    }

    public static Boolean getQHidden(ElementDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden");
    }

    public static Questionnaire.QuestionnaireItemComponent setQHidden(Questionnaire.QuestionnaireItemComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden", new BooleanType(value));
        return context;
    }

    public static Boolean getQHidden(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden");
    }

    public static Extension makeQItemControl(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl").setValue(value);
    }

    public static ElementDefinition setQItemControl(ElementDefinition context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl", value);
        return context;
    }

    public static CodeableConcept getQItemControl(ElementDefinition context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl");
    }

    public static Questionnaire.QuestionnaireItemComponent setQItemControl(Questionnaire.QuestionnaireItemComponent context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl", value);
        return context;
    }

    public static CodeableConcept getQItemControl(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl");
    }

    public static Extension makeQMaxOccurs(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-maxOccurs").setValue(new IntegerType(value));
    }

    public static ElementDefinition setQMaxOccurs(ElementDefinition context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-maxOccurs", new IntegerType(value));
        return context;
    }

    public static Integer getQMaxOccurs(ElementDefinition context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-maxOccurs");
    }

    public static Questionnaire.QuestionnaireItemComponent setQMaxOccurs(Questionnaire.QuestionnaireItemComponent context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-maxOccurs", new IntegerType(value));
        return context;
    }

    public static Integer getQMaxOccurs(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-maxOccurs");
    }

    public static Extension makeQMinOccurs(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-minOccurs").setValue(new IntegerType(value));
    }

    public static ElementDefinition setQMinOccurs(ElementDefinition context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-minOccurs", new IntegerType(value));
        return context;
    }

    public static Integer getQMinOccurs(ElementDefinition context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-minOccurs");
    }

    public static Questionnaire.QuestionnaireItemComponent setQMinOccurs(Questionnaire.QuestionnaireItemComponent context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-minOccurs", new IntegerType(value));
        return context;
    }

    public static Integer getQMinOccurs(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-minOccurs");
    }

    public static Extension makeQOptionExclusive(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-optionExclusive").setValue(new BooleanType(value));
    }

    public static Extension makeQOptionPrefix(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-optionPrefix").setValue(new StringType(value));
    }

    public static Extension makeQOptionRestriction(DataType value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-optionRestriction").setValue(value);
    }

    public static ElementDefinition addQOptionRestriction(ElementDefinition context, DataType value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-optionRestriction", value);
        return context;
    }

    public static List<DataType> getQOptionRestrictionList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionList(DataType.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-optionRestriction");
    }

    public static Questionnaire.QuestionnaireItemComponent addQOptionRestriction(Questionnaire.QuestionnaireItemComponent context, DataType value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-optionRestriction", value);
        return context;
    }

    public static List<DataType> getQOptionRestrictionList(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionList(DataType.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-optionRestriction");
    }

    public static Extension makeReferenceFilter(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-referenceFilter").setValue(new StringType(value));
    }

    public static ElementDefinition setReferenceFilter(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceFilter", new StringType(value));
        return context;
    }

    public static String getReferenceFilter(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceFilter");
    }

    public static Questionnaire.QuestionnaireItemComponent setReferenceFilter(Questionnaire.QuestionnaireItemComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceFilter", new StringType(value));
        return context;
    }

    public static String getReferenceFilter(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceFilter");
    }

    public static Extension makeQReferenceProfile(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-referenceProfile").setValue(new CanonicalType(value));
    }

    public static ElementDefinition addQReferenceProfile(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceProfile", new CanonicalType(value));
        return context;
    }

    public static List<String> getQReferenceProfileList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceProfile");
    }

    public static Questionnaire.QuestionnaireItemComponent addQReferenceProfile(Questionnaire.QuestionnaireItemComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceProfile", new CanonicalType(value));
        return context;
    }

    public static List<String> getQReferenceProfileList(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceProfile");
    }

    public static Extension makeQReferenceResource(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-referenceResource").setValue(new CodeType(value));
    }

    public static ElementDefinition addQReferenceResource(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceResource", new CodeType(value));
        return context;
    }

    public static List<String> getQReferenceResourceList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceResource");
    }

    public static Questionnaire.QuestionnaireItemComponent addQReferenceResource(Questionnaire.QuestionnaireItemComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceResource", new CodeType(value));
        return context;
    }

    public static List<String> getQReferenceResourceList(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceResource");
    }

    public static Extension makeQSignatureRequired(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-signatureRequired").setValue(value);
    }

    public static ElementDefinition addQSignatureRequired(ElementDefinition context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-signatureRequired", value);
        return context;
    }

    public static List<CodeableConcept> getQSignatureRequiredList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-signatureRequired");
    }

    public static Questionnaire addQSignatureRequired(Questionnaire context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-signatureRequired", value);
        return context;
    }

    public static List<CodeableConcept> getQSignatureRequiredList(Questionnaire context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-signatureRequired");
    }

    public static Questionnaire.QuestionnaireItemComponent addQSignatureRequired(Questionnaire.QuestionnaireItemComponent context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-signatureRequired", value);
        return context;
    }

    public static List<CodeableConcept> getQSignatureRequiredList(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-signatureRequired");
    }

    public static Extension makeQSliderStepValue(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-sliderStepValue").setValue(new IntegerType(value));
    }

    public static ElementDefinition setQSliderStepValue(ElementDefinition context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-sliderStepValue", new IntegerType(value));
        return context;
    }

    public static Integer getQSliderStepValue(ElementDefinition context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-sliderStepValue");
    }

    public static Questionnaire.QuestionnaireItemComponent setQSliderStepValue(Questionnaire.QuestionnaireItemComponent context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-sliderStepValue", new IntegerType(value));
        return context;
    }

    public static Integer getQSliderStepValue(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-sliderStepValue");
    }

    public static Extension makeQSupportLink(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-supportLink").setValue(new UriType(value));
    }

    public static ElementDefinition addQSupportLink(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-supportLink", new UriType(value));
        return context;
    }

    public static List<String> getQSupportLinkList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-supportLink");
    }

    public static Questionnaire.QuestionnaireItemComponent addQSupportLink(Questionnaire.QuestionnaireItemComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-supportLink", new UriType(value));
        return context;
    }

    public static List<String> getQSupportLinkList(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-supportLink");
    }

    public static Extension makeQUnit(Coding value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-unit").setValue(value);
    }

    public static ElementDefinition setQUnit(ElementDefinition context, Coding value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-unit", value);
        return context;
    }

    public static Coding getQUnit(ElementDefinition context) {
        return ExtensionsUtils.getExtension(Coding.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-unit");
    }

    public static Questionnaire.QuestionnaireItemComponent setQUnit(Questionnaire.QuestionnaireItemComponent context, Coding value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-unit", value);
        return context;
    }

    public static Coding getQUnit(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtension(Coding.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-unit");
    }

    public static Extension makeQRUnitOption(Coding value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-unitOption").setValue(value);
    }

    public static ElementDefinition addQRUnitOption(ElementDefinition context, Coding value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-unitOption", value);
        return context;
    }

    public static List<Coding> getQRUnitOptionList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionList(Coding.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-unitOption");
    }

    public static Questionnaire.QuestionnaireItemComponent addQRUnitOption(Questionnaire.QuestionnaireItemComponent context, Coding value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-unitOption", value);
        return context;
    }

    public static List<Coding> getQRUnitOptionList(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionList(Coding.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaire-unitOption");
    }

    public static Extension makeQRUnitValueSet(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-unitValueSet").setValue(new CanonicalType(value));
    }

    public static ElementDefinition setQRUnitValueSet(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-unitValueSet", new CanonicalType(value));
        return context;
    }

    public static String getQRUnitValueSet(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-unitValueSet");
    }

    public static Questionnaire.QuestionnaireItemComponent setQRUnitValueSet(Questionnaire.QuestionnaireItemComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-unitValueSet", new CanonicalType(value));
        return context;
    }

    public static String getQRUnitValueSet(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-unitValueSet");
    }

    public static Extension makeQRUsageMode(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaire-usageMode").setValue(new CodeType(value));
    }

    public static ElementDefinition setQRUsageMode(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-usageMode", new CodeType(value));
        return context;
    }

    public static String getQRUsageMode(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-usageMode");
    }

    public static Questionnaire.QuestionnaireItemComponent setQRUsageMode(Questionnaire.QuestionnaireItemComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-usageMode", new CodeType(value));
        return context;
    }

    public static String getQRUsageMode(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/questionnaire-usageMode");
    }

    public static Extension makeQRAuthor(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-author").setValue(value);
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemComponent setQRAuthor(QuestionnaireResponse.QuestionnaireResponseItemComponent context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-author", value);
        return context;
    }

    public static Reference getQRAuthor(QuestionnaireResponse.QuestionnaireResponseItemComponent context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-author");
    }

    public static Extension makeQRCompletionMode(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-completionMode").setValue(value);
    }

    public static QuestionnaireResponse setQRCompletionMode(QuestionnaireResponse context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-completionMode", value);
        return context;
    }

    public static CodeableConcept getQRCompletionMode(QuestionnaireResponse context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-completionMode");
    }

    public static Extension makeQRReason(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-reason").setValue(value);
    }

    public static QuestionnaireResponse addQRReason(QuestionnaireResponse context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-reason", value);
        return context;
    }

    public static List<CodeableConcept> getQRReasonList(QuestionnaireResponse context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-reason");
    }

    public static Extension makeQRReviewer(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-reviewer").setValue(value);
    }

    public static QuestionnaireResponse setQRReviewer(QuestionnaireResponse context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-reviewer", value);
        return context;
    }

    public static Reference getQRReviewer(QuestionnaireResponse context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-reviewer");
    }

    public static Extension makeQRSignature(Signature value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/questionnaireresponse-signature").setValue(value);
    }

    public static QuestionnaireResponse addQRSignature(QuestionnaireResponse context, Signature value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-signature", value);
        return context;
    }

    public static List<Signature> getQRSignatureList(QuestionnaireResponse context) {
        return ExtensionsUtils.getExtensionList(Signature.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-signature");
    }

    public static QuestionnaireResponse.QuestionnaireResponseItemComponent addQRSignature(QuestionnaireResponse.QuestionnaireResponseItemComponent context, Signature value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-signature", value);
        return context;
    }

    public static List<Signature> getQRSignatureList(QuestionnaireResponse.QuestionnaireResponseItemComponent context) {
        return ExtensionsUtils.getExtensionList(Signature.class, context, "http://hl7.org/fhir/StructureDefinition/questionnaireresponse-signature");
    }

    public static Extension makeReferencesContained(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/referencesContained").setValue(value);
    }

    public static Expression addReferencesContained(Expression context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/referencesContained", value);
        return context;
    }

    public static List<Reference> getReferencesContainedList(Expression context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/referencesContained");
    }

    public static Extension makeRenderedValue(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/rendered-value").setValue(new StringType(value));
    }

    public static CanonicalType setRenderedValue(CanonicalType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendered-value", new StringType(value));
        return context;
    }

    public static String getRenderedValue(CanonicalType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/rendered-value");
    }

    public static CodeType setRenderedValue(CodeType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendered-value", new StringType(value));
        return context;
    }

    public static String getRenderedValue(CodeType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/rendered-value");
    }

    public static DateTimeType setRenderedValue(DateTimeType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendered-value", new StringType(value));
        return context;
    }

    public static String getRenderedValue(DateTimeType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/rendered-value");
    }

    public static DateType setRenderedValue(DateType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendered-value", new StringType(value));
        return context;
    }

    public static String getRenderedValue(DateType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/rendered-value");
    }

    public static DecimalType setRenderedValue(DecimalType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendered-value", new StringType(value));
        return context;
    }

    public static String getRenderedValue(DecimalType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/rendered-value");
    }

    public static InstantType setRenderedValue(InstantType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendered-value", new StringType(value));
        return context;
    }

    public static String getRenderedValue(InstantType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/rendered-value");
    }

    public static IntegerType setRenderedValue(IntegerType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendered-value", new StringType(value));
        return context;
    }

    public static String getRenderedValue(IntegerType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/rendered-value");
    }

    public static StringType setRenderedValue(StringType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendered-value", new StringType(value));
        return context;
    }

    public static String getRenderedValue(StringType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/rendered-value");
    }

    public static TimeType setRenderedValue(TimeType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendered-value", new StringType(value));
        return context;
    }

    public static String getRenderedValue(TimeType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/rendered-value");
    }

    public static Extension makeMarkdown(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/rendering-markdown").setValue(new MarkdownType(value));
    }

    public static StringType setMarkdown(StringType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendering-markdown", new MarkdownType(value));
        return context;
    }

    public static String getMarkdown(StringType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/rendering-markdown");
    }

    public static Extension makeRenderingStyle(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/rendering-style").setValue(new StringType(value));
    }

    public static Element setRenderingStyle(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendering-style", new StringType(value));
        return context;
    }

    public static String getRenderingStyle(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/rendering-style");
    }

    public static Extension makeStyleSensitive(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/rendering-styleSensitive").setValue(new BooleanType(value));
    }

    public static Element setStyleSensitive(Element context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendering-styleSensitive", new BooleanType(value));
        return context;
    }

    public static Boolean getStyleSensitive(Element context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/rendering-styleSensitive");
    }

    public static Extension makeXhtmlRepresentation(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/rendering-xhtml").setValue(new StringType(value));
    }

    public static StringType setXhtmlRepresentation(StringType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/rendering-xhtml", new StringType(value));
        return context;
    }

    public static String getXhtmlRepresentation(StringType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/rendering-xhtml");
    }

    public static Extension makeReplaces(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/replaces").setValue(new CanonicalType(value));
    }

    public static ActivityDefinition addReplaces(ActivityDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(ActivityDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static ActorDefinition addReplaces(ActorDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(ActorDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static CapabilityStatement addReplaces(CapabilityStatement context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(CapabilityStatement context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static ChargeItemDefinition addReplaces(ChargeItemDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(ChargeItemDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static Citation addReplaces(Citation context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(Citation context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static CodeSystem addReplaces(CodeSystem context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(CodeSystem context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static CompartmentDefinition addReplaces(CompartmentDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(CompartmentDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static ConceptMap addReplaces(ConceptMap context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(ConceptMap context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static ConditionDefinition addReplaces(ConditionDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(ConditionDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static EventDefinition addReplaces(EventDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(EventDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static Evidence addReplaces(Evidence context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(Evidence context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static EvidenceReport addReplaces(EvidenceReport context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(EvidenceReport context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static EvidenceVariable addReplaces(EvidenceVariable context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(EvidenceVariable context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static ExampleScenario addReplaces(ExampleScenario context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(ExampleScenario context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static GraphDefinition addReplaces(GraphDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(GraphDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static ImplementationGuide addReplaces(ImplementationGuide context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(ImplementationGuide context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static Library addReplaces(Library context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(Library context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static Measure addReplaces(Measure context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(Measure context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static MessageDefinition addReplaces(MessageDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(MessageDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static NamingSystem addReplaces(NamingSystem context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(NamingSystem context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static ObservationDefinition addReplaces(ObservationDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(ObservationDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static OperationDefinition addReplaces(OperationDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(OperationDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static PlanDefinition addReplaces(PlanDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(PlanDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static Questionnaire addReplaces(Questionnaire context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(Questionnaire context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static Requirements addReplaces(Requirements context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(Requirements context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static SearchParameter addReplaces(SearchParameter context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(SearchParameter context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static SpecimenDefinition addReplaces(SpecimenDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(SpecimenDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static StructureDefinition addReplaces(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static StructureMap addReplaces(StructureMap context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(StructureMap context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static SubscriptionTopic addReplaces(SubscriptionTopic context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(SubscriptionTopic context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static TerminologyCapabilities addReplaces(TerminologyCapabilities context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(TerminologyCapabilities context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static TestScript addReplaces(TestScript context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(TestScript context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static ValueSet addReplaces(ValueSet context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/replaces", new CanonicalType(value));
        return context;
    }

    public static List<String> getReplacesList(ValueSet context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/replaces");
    }

    public static Extension makeDoNotPerform(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/request-doNotPerform").setValue(new BooleanType(value));
    }

    public static NutritionOrder setDoNotPerform(NutritionOrder context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/request-doNotPerform", new BooleanType(value));
        return context;
    }

    public static Boolean getDoNotPerform(NutritionOrder context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/request-doNotPerform");
    }

    public static Extension makeRequestInsurance(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/request-insurance").setValue(value);
    }

    public static NutritionOrder addRequestInsurance(NutritionOrder context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/request-insurance", value);
        return context;
    }

    public static List<Reference> getRequestInsuranceList(NutritionOrder context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/request-insurance");
    }

    public static Extension makePerformerOrder(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/request-performerOrder").setValue(new IntegerType(value));
    }

    public static CodeableReference setPerformerOrder(CodeableReference context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/request-performerOrder", new IntegerType(value));
        return context;
    }

    public static Integer getPerformerOrder(CodeableReference context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/request-performerOrder");
    }

    public static Reference setPerformerOrder(Reference context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/request-performerOrder", new IntegerType(value));
        return context;
    }

    public static Integer getPerformerOrder(Reference context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/request-performerOrder");
    }

    public static Extension makeRelevantHistory(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/request-relevantHistory").setValue(value);
    }

    public static CarePlan addRelevantHistory(CarePlan context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/request-relevantHistory", value);
        return context;
    }

    public static List<Reference> getRelevantHistoryList(CarePlan context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/request-relevantHistory");
    }

    public static CommunicationRequest addRelevantHistory(CommunicationRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/request-relevantHistory", value);
        return context;
    }

    public static List<Reference> getRelevantHistoryList(CommunicationRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/request-relevantHistory");
    }

    public static NutritionOrder addRelevantHistory(NutritionOrder context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/request-relevantHistory", value);
        return context;
    }

    public static List<Reference> getRelevantHistoryList(NutritionOrder context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/request-relevantHistory");
    }

    public static Extension makeRequestReplaces(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/request-replaces").setValue(value);
    }

    public static NutritionOrder addRequestReplaces(NutritionOrder context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/request-replaces", value);
        return context;
    }

    public static List<Reference> getRequestReplacesList(NutritionOrder context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/request-replaces");
    }

    public static SupplyRequest addRequestReplaces(SupplyRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/request-replaces", value);
        return context;
    }

    public static List<Reference> getRequestReplacesList(SupplyRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/request-replaces");
    }

    public static Task addRequestReplaces(Task context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/request-replaces", value);
        return context;
    }

    public static List<Reference> getRequestReplacesList(Task context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/request-replaces");
    }

    public static Extension makeRequestStatusReason(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/request-statusReason").setValue(value);
    }

    public static DeviceRequest setRequestStatusReason(DeviceRequest context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/request-statusReason", value);
        return context;
    }

    public static CodeableConcept getRequestStatusReason(DeviceRequest context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/request-statusReason");
    }

    public static NutritionOrder setRequestStatusReason(NutritionOrder context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/request-statusReason", value);
        return context;
    }

    public static CodeableConcept getRequestStatusReason(NutritionOrder context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/request-statusReason");
    }

    public static ServiceRequest setRequestStatusReason(ServiceRequest context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/request-statusReason", value);
        return context;
    }

    public static CodeableConcept getRequestStatusReason(ServiceRequest context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/request-statusReason");
    }

    public static SupplyRequest setRequestStatusReason(SupplyRequest context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/request-statusReason", value);
        return context;
    }

    public static CodeableConcept getRequestStatusReason(SupplyRequest context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/request-statusReason");
    }

    public static Extension makeRSStudyRegistration(DataType value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/researchStudy-studyRegistration").setValue(value);
    }

    public static ResearchStudy addRSStudyRegistration(ResearchStudy context, DataType value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/researchStudy-studyRegistration", value);
        return context;
    }

    public static List<DataType> getRSStudyRegistrationList(ResearchStudy context) {
        return ExtensionsUtils.getExtensionList(DataType.class, context, "http://hl7.org/fhir/StructureDefinition/researchStudy-studyRegistration");
    }

    public static Extension makeResolveAsVersionSpecific(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/resolve-as-version-specific").setValue(new BooleanType(value));
    }

    public static Reference setResolveAsVersionSpecific(Reference context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resolve-as-version-specific", new BooleanType(value));
        return context;
    }

    public static Boolean getResolveAsVersionSpecific(Reference context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/resolve-as-version-specific");
    }

    public static UriType setResolveAsVersionSpecific(UriType context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resolve-as-version-specific", new BooleanType(value));
        return context;
    }

    public static Boolean getResolveAsVersionSpecific(UriType context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/resolve-as-version-specific");
    }

    public static UrlType setResolveAsVersionSpecific(UrlType context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resolve-as-version-specific", new BooleanType(value));
        return context;
    }

    public static Boolean getResolveAsVersionSpecific(UrlType context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/resolve-as-version-specific");
    }

    public static Extension makeResourceApprovalDate(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/resource-approvalDate").setValue(new DateType(value));
    }

    public static CapabilityStatement setResourceApprovalDate(CapabilityStatement context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate", new DateType(value));
        return context;
    }

    public static String getResourceApprovalDate(CapabilityStatement context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate");
    }

    public static CodeSystem setResourceApprovalDate(CodeSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate", new DateType(value));
        return context;
    }

    public static String getResourceApprovalDate(CodeSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate");
    }

    public static CompartmentDefinition setResourceApprovalDate(CompartmentDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate", new DateType(value));
        return context;
    }

    public static String getResourceApprovalDate(CompartmentDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate");
    }

    public static ConceptMap setResourceApprovalDate(ConceptMap context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate", new DateType(value));
        return context;
    }

    public static String getResourceApprovalDate(ConceptMap context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate");
    }

    public static ImplementationGuide setResourceApprovalDate(ImplementationGuide context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate", new DateType(value));
        return context;
    }

    public static String getResourceApprovalDate(ImplementationGuide context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate");
    }

    public static NamingSystem setResourceApprovalDate(NamingSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate", new DateType(value));
        return context;
    }

    public static String getResourceApprovalDate(NamingSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate");
    }

    public static OperationDefinition setResourceApprovalDate(OperationDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate", new DateType(value));
        return context;
    }

    public static String getResourceApprovalDate(OperationDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate");
    }

    public static SearchParameter setResourceApprovalDate(SearchParameter context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate", new DateType(value));
        return context;
    }

    public static String getResourceApprovalDate(SearchParameter context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate");
    }

    public static StructureDefinition setResourceApprovalDate(StructureDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate", new DateType(value));
        return context;
    }

    public static String getResourceApprovalDate(StructureDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate");
    }

    public static StructureMap setResourceApprovalDate(StructureMap context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate", new DateType(value));
        return context;
    }

    public static String getResourceApprovalDate(StructureMap context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate");
    }

    public static ValueSet setResourceApprovalDate(ValueSet context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate", new DateType(value));
        return context;
    }

    public static String getResourceApprovalDate(ValueSet context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-approvalDate");
    }

    public static Extension makeResourceEffectivePeriod(Period value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod").setValue(value);
    }

    public static CapabilityStatement setResourceEffectivePeriod(CapabilityStatement context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod", value);
        return context;
    }

    public static Period getResourceEffectivePeriod(CapabilityStatement context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod");
    }

    public static CodeSystem setResourceEffectivePeriod(CodeSystem context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod", value);
        return context;
    }

    public static Period getResourceEffectivePeriod(CodeSystem context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod");
    }

    public static CompartmentDefinition setResourceEffectivePeriod(CompartmentDefinition context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod", value);
        return context;
    }

    public static Period getResourceEffectivePeriod(CompartmentDefinition context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod");
    }

    public static ConceptMap setResourceEffectivePeriod(ConceptMap context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod", value);
        return context;
    }

    public static Period getResourceEffectivePeriod(ConceptMap context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod");
    }

    public static ImplementationGuide setResourceEffectivePeriod(ImplementationGuide context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod", value);
        return context;
    }

    public static Period getResourceEffectivePeriod(ImplementationGuide context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod");
    }

    public static NamingSystem setResourceEffectivePeriod(NamingSystem context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod", value);
        return context;
    }

    public static Period getResourceEffectivePeriod(NamingSystem context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod");
    }

    public static OperationDefinition setResourceEffectivePeriod(OperationDefinition context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod", value);
        return context;
    }

    public static Period getResourceEffectivePeriod(OperationDefinition context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod");
    }

    public static SearchParameter setResourceEffectivePeriod(SearchParameter context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod", value);
        return context;
    }

    public static Period getResourceEffectivePeriod(SearchParameter context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod");
    }

    public static StructureDefinition setResourceEffectivePeriod(StructureDefinition context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod", value);
        return context;
    }

    public static Period getResourceEffectivePeriod(StructureDefinition context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod");
    }

    public static StructureMap setResourceEffectivePeriod(StructureMap context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod", value);
        return context;
    }

    public static Period getResourceEffectivePeriod(StructureMap context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod");
    }

    public static ValueSet setResourceEffectivePeriod(ValueSet context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod", value);
        return context;
    }

    public static Period getResourceEffectivePeriod(ValueSet context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/resource-effectivePeriod");
    }

    public static Extension makeResourceInstanceDescription(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/resource-instance-description").setValue(new MarkdownType(value));
    }

    public static Resource setResourceInstanceDescription(Resource context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-instance-description", new MarkdownType(value));
        return context;
    }

    public static String getResourceInstanceDescription(Resource context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-instance-description");
    }

    public static Extension makeResourceInstanceName(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/resource-instance-name").setValue(new StringType(value));
    }

    public static Resource setResourceInstanceName(Resource context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-instance-name", new StringType(value));
        return context;
    }

    public static String getResourceInstanceName(Resource context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-instance-name");
    }

    public static Extension makeReslastReviewDate(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate").setValue(new DateType(value));
    }

    public static CapabilityStatement setReslastReviewDate(CapabilityStatement context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate", new DateType(value));
        return context;
    }

    public static String getReslastReviewDate(CapabilityStatement context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate");
    }

    public static CodeSystem setReslastReviewDate(CodeSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate", new DateType(value));
        return context;
    }

    public static String getReslastReviewDate(CodeSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate");
    }

    public static CompartmentDefinition setReslastReviewDate(CompartmentDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate", new DateType(value));
        return context;
    }

    public static String getReslastReviewDate(CompartmentDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate");
    }

    public static ConceptMap setReslastReviewDate(ConceptMap context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate", new DateType(value));
        return context;
    }

    public static String getReslastReviewDate(ConceptMap context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate");
    }

    public static ImplementationGuide setReslastReviewDate(ImplementationGuide context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate", new DateType(value));
        return context;
    }

    public static String getReslastReviewDate(ImplementationGuide context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate");
    }

    public static NamingSystem setReslastReviewDate(NamingSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate", new DateType(value));
        return context;
    }

    public static String getReslastReviewDate(NamingSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate");
    }

    public static OperationDefinition setReslastReviewDate(OperationDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate", new DateType(value));
        return context;
    }

    public static String getReslastReviewDate(OperationDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate");
    }

    public static SearchParameter setReslastReviewDate(SearchParameter context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate", new DateType(value));
        return context;
    }

    public static String getReslastReviewDate(SearchParameter context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate");
    }

    public static StructureDefinition setReslastReviewDate(StructureDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate", new DateType(value));
        return context;
    }

    public static String getReslastReviewDate(StructureDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate");
    }

    public static StructureMap setReslastReviewDate(StructureMap context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate", new DateType(value));
        return context;
    }

    public static String getReslastReviewDate(StructureMap context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate");
    }

    public static ValueSet setReslastReviewDate(ValueSet context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate", new DateType(value));
        return context;
    }

    public static String getReslastReviewDate(ValueSet context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/resource-lastReviewDate");
    }

    public static Extension makeSRPertainsToGoal(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/resource-pertainsToGoal").setValue(value);
    }

    public static Resource addSRPertainsToGoal(Resource context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/resource-pertainsToGoal", value);
        return context;
    }

    public static List<Reference> getSRPertainsToGoalList(Resource context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/resource-pertainsToGoal");
    }

    public static Extension makeSRPrecondition(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/servicerequest-precondition").setValue(value);
    }

    public static ServiceRequest addSRPrecondition(ServiceRequest context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/servicerequest-precondition", value);
        return context;
    }

    public static List<CodeableConcept> getSRPreconditionList(ServiceRequest context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/servicerequest-precondition");
    }

    public static Extension makeSRQuestionnaireRequest(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/servicerequest-questionnaireRequest").setValue(value);
    }

    public static ServiceRequest setSRQuestionnaireRequest(ServiceRequest context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/servicerequest-questionnaireRequest", value);
        return context;
    }

    public static Reference getSRQuestionnaireRequest(ServiceRequest context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/servicerequest-questionnaireRequest");
    }

    public static Extension makeSpecCollectionPriority(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/specimen-collectionPriority").setValue(value);
    }

    public static Specimen.SpecimenCollectionComponent setSpecCollectionPriority(Specimen.SpecimenCollectionComponent context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/specimen-collectionPriority", value);
        return context;
    }

    public static CodeableConcept getSpecCollectionPriority(Specimen.SpecimenCollectionComponent context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/specimen-collectionPriority");
    }

    public static Extension makeSpecIsDryWeight(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/specimen-isDryWeight").setValue(new BooleanType(value));
    }

    public static Extension makeSpecProcessingTime(Period value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/specimen-processingTime").setValue(value);
    }

    public static Extension makeSpecProcessingTime(Duration value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/specimen-processingTime").setValue(value);
    }

    public static Specimen.SpecimenProcessingComponent setSpecProcessingTime(Specimen.SpecimenProcessingComponent context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/specimen-processingTime", value);
        return context;
    }

    public static Period getSpecProcessingTimePeriod(Specimen.SpecimenProcessingComponent context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/specimen-processingTime");
    }

    public static Specimen.SpecimenProcessingComponent setSpecProcessingTime(Specimen.SpecimenProcessingComponent context, Duration value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/specimen-processingTime", value);
        return context;
    }

    public static Duration getSpecProcessingTimeDuration(Specimen.SpecimenProcessingComponent context) {
        return ExtensionsUtils.getExtension(Duration.class, context, "http://hl7.org/fhir/StructureDefinition/specimen-processingTime");
    }

    public static Extension makeSpecSequenceNumber(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/specimen-sequenceNumber").setValue(new IntegerType(value));
    }

    public static Specimen.SpecimenContainerComponent setSpecSequenceNumber(Specimen.SpecimenContainerComponent context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/specimen-sequenceNumber", new IntegerType(value));
        return context;
    }

    public static Integer getSpecSequenceNumber(Specimen.SpecimenContainerComponent context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/specimen-sequenceNumber");
    }

    public static Extension makeSpecSpecialHandling(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/specimen-specialHandling").setValue(value);
    }

    public static Specimen.SpecimenCollectionComponent addSpecSpecialHandling(Specimen.SpecimenCollectionComponent context, CodeableConcept value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/specimen-specialHandling", value);
        return context;
    }

    public static List<CodeableConcept> getSpecSpecialHandlingList(Specimen.SpecimenCollectionComponent context) {
        return ExtensionsUtils.getExtensionList(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/specimen-specialHandling");
    }

    public static Extension makeSDAncestor(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-ancestor").setValue(new UriType(value));
    }

    public static StructureDefinition addSDAncestor(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-ancestor", new UriType(value));
        return context;
    }

    public static List<String> getSDAncestorList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-ancestor");
    }

    public static Extension makeSDApplicableVersion(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-applicable-version").setValue(new CodeType(value));
    }

    public static StructureDefinition addSDApplicableVersion(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-applicable-version", new CodeType(value));
        return context;
    }

    public static List<String> getSDApplicableVersionList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-applicable-version");
    }

    public static Extension makeSDCategory(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-category").setValue(new StringType(value));
    }

    public static StructureDefinition setSDCategory(StructureDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-category", new StringType(value));
        return context;
    }

    public static String getSDCategory(StructureDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-category");
    }

    public static Extension makeSDCodegenSuper(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-codegen-super").setValue(new StringType(value));
    }

    public static CanonicalType setSDCodegenSuper(CanonicalType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-codegen-super", new StringType(value));
        return context;
    }

    public static String getSDCodegenSuper(CanonicalType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-codegen-super");
    }

    public static Extension makeSDcompliesWithProfile(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile").setValue(new CanonicalType(value));
    }

    public static StructureDefinition addSDcompliesWithProfile(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile", new CanonicalType(value));
        return context;
    }

    public static List<String> getSDcompliesWithProfileList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-compliesWithProfile");
    }

    public static Extension makeSDStatusDerivation(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom").setValue(new CanonicalType(value));
    }

    public static Element addSDStatusDerivation(Element context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom", new CanonicalType(value));
        return context;
    }

    public static List<String> getSDStatusDerivationList(Element context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom");
    }

    public static Resource addSDStatusDerivation(Resource context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom", new CanonicalType(value));
        return context;
    }

    public static List<String> getSDStatusDerivationList(Resource context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom");
    }

    public static Extension makeSDDisplayHint(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-display-hint").setValue(new StringType(value));
    }

    public static ElementDefinition setSDDisplayHint(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-display-hint", new StringType(value));
        return context;
    }

    public static String getSDDisplayHint(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-display-hint");
    }

    public static Extension makeSDExplicitTypeName(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name").setValue(new StringType(value));
    }

    public static ElementDefinition setSDExplicitTypeName(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name", new StringType(value));
        return context;
    }

    public static String getSDExplicitTypeName(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name");
    }

    public static Extension makeSDExtensionMeaning(CodeableConcept value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-extension-meaning").setValue(value);
    }

    public static Extension setSDExtensionMeaning(Extension context, CodeableConcept value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-extension-meaning", value);
        return context;
    }

    public static CodeableConcept getSDExtensionMeaning(Extension context) {
        return ExtensionsUtils.getExtension(CodeableConcept.class, context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-extension-meaning");
    }

    public static Extension makeSDFhirType(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type").setValue(new UrlType(value));
    }

    public static ElementDefinition.TypeRefComponent setSDFhirType(ElementDefinition.TypeRefComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type", new UrlType(value));
        return context;
    }

    public static String getSDFhirType(ElementDefinition.TypeRefComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type");
    }

    public static Extension makeSDFmm(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm").setValue(new IntegerType(value));
    }

    public static Element setSDFmm(Element context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm", new IntegerType(value));
        return context;
    }

    public static Integer getSDFmm(Element context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm");
    }

    public static Extension makeSDFmmNoWarnings(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-no-warnings").setValue(new IntegerType(value));
    }

    public static StructureDefinition setSDFmmNoWarnings(StructureDefinition context, int value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-no-warnings", new IntegerType(value));
        return context;
    }

    public static Integer getSDFmmNoWarnings(StructureDefinition context) {
        return ExtensionsUtils.getExtensionInt(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-no-warnings");
    }

    public static Extension makeSDFmmSupportDoco(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support").setValue(new MarkdownType(value));
    }

    public static Element setSDFmmSupportDoco(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support", new MarkdownType(value));
        return context;
    }

    public static String getSDFmmSupportDoco(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support");
    }

    public static Extension makeSDHierarchy(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy").setValue(new BooleanType(value));
    }

    public static ElementDefinition.TypeRefComponent setSDHierarchy(ElementDefinition.TypeRefComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy", new BooleanType(value));
        return context;
    }

    public static Boolean getSDHierarchy(ElementDefinition.TypeRefComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy");
    }

    public static Extension makeSDimposeProfile(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile").setValue(new CanonicalType(value));
    }

    public static StructureDefinition addSDimposeProfile(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile", new CanonicalType(value));
        return context;
    }

    public static List<String> getSDimposeProfileList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile");
    }

    public static Extension makeSDInheritanceControl(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-inheritance-control").setValue(new CodeType(value));
    }

    public static StructureDefinition setSDInheritanceControl(StructureDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-inheritance-control", new CodeType(value));
        return context;
    }

    public static String getSDInheritanceControl(StructureDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-inheritance-control");
    }

    public static Extension makeSDInterface(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-interface").setValue(new BooleanType(value));
    }

    public static StructureDefinition setSDInterface(StructureDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-interface", new BooleanType(value));
        return context;
    }

    public static Boolean getSDInterface(StructureDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-interface");
    }

    public static Extension makeSDNormativeVersion(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version").setValue(new CodeType(value));
    }

    public static CanonicalResource setSDNormativeVersion(CanonicalResource context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version", new CodeType(value));
        return context;
    }

    public static String getSDNormativeVersion(CanonicalResource context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version");
    }

    public static ElementDefinition setSDNormativeVersion(ElementDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version", new CodeType(value));
        return context;
    }

    public static String getSDNormativeVersion(ElementDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version");
    }

    public static Extension makeSDSecurityCategory(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-security-category").setValue(new CodeType(value));
    }

    public static StructureDefinition setSDSecurityCategory(StructureDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-security-category", new CodeType(value));
        return context;
    }

    public static String getSDSecurityCategory(StructureDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-security-category");
    }

    public static Extension makeSDStandardsStatus(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status").setValue(new CodeType(value));
    }

    public static Element setSDStandardsStatus(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status", new CodeType(value));
        return context;
    }

    public static String getSDStandardsStatus(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status");
    }

    public static Extension makeSDStandardsStatusReason(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status-reason").setValue(new MarkdownType(value));
    }

    public static Element setSDStandardsStatusReason(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status-reason", new MarkdownType(value));
        return context;
    }

    public static String getSDStandardsStatusReason(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status-reason");
    }

    public static Extension makeSDSummary(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-summary").setValue(new MarkdownType(value));
    }

    public static StructureDefinition setSDSummary(StructureDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-summary", new MarkdownType(value));
        return context;
    }

    public static String getSDSummary(StructureDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-summary");
    }

    public static Extension makeSDTableName(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name").setValue(new StringType(value));
    }

    public static StructureDefinition.StructureDefinitionMappingComponent setSDTableName(StructureDefinition.StructureDefinitionMappingComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name", new StringType(value));
        return context;
    }

    public static String getSDTableName(StructureDefinition.StructureDefinitionMappingComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name");
    }

    public static Extension makeSDTemplateStatus(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-template-status").setValue(new CodeType(value));
    }

    public static StructureDefinition setSDTemplateStatus(StructureDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-template-status", new CodeType(value));
        return context;
    }

    public static String getSDTemplateStatus(StructureDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-template-status");
    }

    public static Extension makeSDTypeCharacteristics(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics").setValue(new CodeType(value));
    }

    public static StructureDefinition setSDTypeCharacteristics(StructureDefinition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics", new CodeType(value));
        return context;
    }

    public static String getSDTypeCharacteristics(StructureDefinition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics");
    }

    public static Extension makeSDWorkGroup(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-wg").setValue(new CodeType(value));
    }

    public static Element setSDWorkGroup(Element context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg", new CodeType(value));
        return context;
    }

    public static String getSDWorkGroup(Element context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
    }

    public static Extension makeSDXmlHasNoOrder(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-no-order").setValue(new BooleanType(value));
    }

    public static StructureDefinition setSDXmlHasNoOrder(StructureDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-no-order", new BooleanType(value));
        return context;
    }

    public static Boolean getSDXmlHasNoOrder(StructureDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-no-order");
    }

    public static Extension makeTargetElement(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/targetElement").setValue(new UriType(value));
    }

    public static CanonicalType addTargetElement(CanonicalType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/targetElement", new UriType(value));
        return context;
    }

    public static List<String> getTargetElementList(CanonicalType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/targetElement");
    }

    public static Reference addTargetElement(Reference context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/targetElement", new UriType(value));
        return context;
    }

    public static List<String> getTargetElementList(Reference context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/targetElement");
    }

    public static Extension makeTargetPath(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/targetPath").setValue(new StringType(value));
    }

    public static CanonicalType addTargetPath(CanonicalType context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/targetPath", new StringType(value));
        return context;
    }

    public static List<String> getTargetPathList(CanonicalType context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/targetPath");
    }

    public static Reference addTargetPath(Reference context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/targetPath", new StringType(value));
        return context;
    }

    public static List<String> getTargetPathList(Reference context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/targetPath");
    }

    public static Extension makeTaskReplaces(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/task-replaces").setValue(value);
    }

    public static Task addTaskReplaces(Task context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/task-replaces", value);
        return context;
    }

    public static List<Reference> getTaskReplacesList(Task context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/task-replaces");
    }

    public static Extension makeTimezoneCode(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/timezone").setValue(new CodeType(value));
    }

    public static DateTimeType setTimezoneCode(DateTimeType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/timezone", new CodeType(value));
        return context;
    }

    public static String getTimezoneCode(DateTimeType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/timezone");
    }

    public static DateType setTimezoneCode(DateType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/timezone", new CodeType(value));
        return context;
    }

    public static String getTimezoneCode(DateType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/timezone");
    }

    public static InstantType setTimezoneCode(InstantType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/timezone", new CodeType(value));
        return context;
    }

    public static String getTimezoneCode(InstantType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/timezone");
    }

    public static Meta setTimezoneCode(Meta context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/timezone", new CodeType(value));
        return context;
    }

    public static String getTimezoneCode(Meta context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/timezone");
    }

    public static TimeType setTimezoneCode(TimeType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/timezone", new CodeType(value));
        return context;
    }

    public static String getTimezoneCode(TimeType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/timezone");
    }

    public static Extension makeTimingDayOfMonth(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/timing-dayOfMonth").setValue(new PositiveIntType(value));
    }

    public static Timing.TimingRepeatComponent addTimingDayOfMonth(Timing.TimingRepeatComponent context, int value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/timing-dayOfMonth", new PositiveIntType(value));
        return context;
    }

    public static List<Integer> getTimingDayOfMonthList(Timing.TimingRepeatComponent context) {
        return ExtensionsUtils.getExtensionIntList(context, "http://hl7.org/fhir/StructureDefinition/timing-dayOfMonth");
    }

    public static Extension makeTimingExact(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/timing-exact").setValue(new BooleanType(value));
    }

    public static Timing.TimingRepeatComponent setTimingExact(Timing.TimingRepeatComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/timing-exact", new BooleanType(value));
        return context;
    }

    public static Boolean getTimingExact(Timing.TimingRepeatComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/timing-exact");
    }

    public static Extension makeUncertainDate(Period value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/timing-uncertainDate").setValue(value);
    }

    public static DateTimeType setUncertainDate(DateTimeType context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/timing-uncertainDate", value);
        return context;
    }

    public static Period getUncertainDate(DateTimeType context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/timing-uncertainDate");
    }

    public static Extension makeTimezoneOffset(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/tz-offset").setValue(new StringType(value));
    }

    public static DateType setTimezoneOffset(DateType context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/tz-offset", new StringType(value));
        return context;
    }

    public static String getTimezoneOffset(DateType context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/tz-offset");
    }

    public static Extension makeUncertainPeriod(Period value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/uncertainPeriod").setValue(value);
    }

    public static DateTimeType setUncertainPeriod(DateTimeType context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/uncertainPeriod", value);
        return context;
    }

    public static Period getUncertainPeriod(DateTimeType context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/uncertainPeriod");
    }

    public static DateType setUncertainPeriod(DateType context, Period value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/uncertainPeriod", value);
        return context;
    }

    public static Period getUncertainPeriod(DateType context) {
        return ExtensionsUtils.getExtension(Period.class, context, "http://hl7.org/fhir/StructureDefinition/uncertainPeriod");
    }

    public static Extension makeGroup(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/usagecontext-group").setValue(new StringType(value));
    }

    public static UsageContext setGroup(UsageContext context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/usagecontext-group", new StringType(value));
        return context;
    }

    public static String getGroup(UsageContext context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/usagecontext-group");
    }

    public static Extension makeVSAuthoritativeSource(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-authoritativeSource").setValue(new UriType(value));
    }

    public static ValueSet setVSAuthoritativeSource(ValueSet context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-authoritativeSource", new UriType(value));
        return context;
    }

    public static String getVSAuthoritativeSource(ValueSet context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/valueset-authoritativeSource");
    }

    public static Extension makeVSCaseSensitive(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-caseSensitive").setValue(new BooleanType(value));
    }

    public static Extension makeVSComposeCreatedBy(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-compose-createdBy").setValue(new StringType(value));
    }

    public static ValueSet.ValueSetComposeComponent setVSComposeCreatedBy(ValueSet.ValueSetComposeComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-compose-createdBy", new StringType(value));
        return context;
    }

    public static String getVSComposeCreatedBy(ValueSet.ValueSetComposeComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/valueset-compose-createdBy");
    }

    public static Extension makeVSComposeCreationDate(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-compose-creationDate").setValue(new StringType(value));
    }

    public static ValueSet.ValueSetComposeComponent setVSComposeCreationDate(ValueSet.ValueSetComposeComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-compose-creationDate", new StringType(value));
        return context;
    }

    public static String getVSComposeCreationDate(ValueSet.ValueSetComposeComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/valueset-compose-creationDate");
    }

    public static Extension makeVSIncludeVSTitle(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-compose-include-valueSetTitle").setValue(new StringType(value));
    }

    public static Extension makeVSConceptComments(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-concept-comments").setValue(new StringType(value));
    }

    public static Extension makeVSConceptDefinition(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-concept-definition").setValue(new StringType(value));
    }

    public static Extension makeVSConceptOrder(int value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-conceptOrder").setValue(new IntegerType(value));
    }

    public static Extension makeVSDeprecated(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-deprecated").setValue(new BooleanType(value));
    }

    public static Extension makeVSExpansionSource(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-expansionSource").setValue(new UriType(value));
    }

    public static ValueSet.ValueSetExpansionComponent setVSExpansionSource(ValueSet.ValueSetExpansionComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-expansionSource", new UriType(value));
        return context;
    }

    public static String getVSExpansionSource(ValueSet.ValueSetExpansionComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/valueset-expansionSource");
    }

    public static Extension makeVSExpression(Expression value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-expression").setValue(value);
    }

    public static ValueSet setVSExpression(ValueSet context, Expression value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-expression", value);
        return context;
    }

    public static Expression getVSExpression(ValueSet context) {
        return ExtensionsUtils.getExtension(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/valueset-expression");
    }

    public static Extension makeVSExtensible(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-extensible").setValue(new BooleanType(value));
    }

    public static ValueSet setVSExtensible(ValueSet context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-extensible", new BooleanType(value));
        return context;
    }

    public static Boolean getVSExtensible(ValueSet context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/valueset-extensible");
    }

    public static Extension makeVSKeyword(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-keyWord").setValue(new StringType(value));
    }

    public static ValueSet addVSKeyword(ValueSet context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-keyWord", new StringType(value));
        return context;
    }

    public static List<String> getVSKeywordList(ValueSet context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/valueset-keyWord");
    }

    public static Extension makeVSLabel(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-label").setValue(new StringType(value));
    }

    public static Extension makeVSMap(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-map").setValue(new CanonicalType(value));
    }

    public static ValueSet setVSMap(ValueSet context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-map", new CanonicalType(value));
        return context;
    }

    public static String getVSMap(ValueSet context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/valueset-map");
    }

    public static Extension makeVSParameterSource(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-parameterSource").setValue(new CodeType(value));
    }

    public static Extension makeVSReference(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-reference").setValue(new UriType(value));
    }

    public static Coding setVSReference(Coding context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-reference", new UriType(value));
        return context;
    }

    public static String getVSReference(Coding context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/valueset-reference");
    }

    public static Extension makeVSRulesText(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-rules-text").setValue(new MarkdownType(value));
    }

    public static ValueSet setVSRulesText(ValueSet context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-rules-text", new MarkdownType(value));
        return context;
    }

    public static String getVSRulesText(ValueSet context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/valueset-rules-text");
    }

    public static Extension makeVSSourceReference(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-sourceReference").setValue(new UriType(value));
    }

    public static ValueSet setVSSourceReference(ValueSet context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-sourceReference", new UriType(value));
        return context;
    }

    public static String getVSSourceReference(ValueSet context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/valueset-sourceReference");
    }

    public static Extension makeVSSpecialStatus(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-special-status").setValue(new StringType(value));
    }

    public static CodeSystem setVSSpecialStatus(CodeSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-special-status", new StringType(value));
        return context;
    }

    public static String getVSSpecialStatus(CodeSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/valueset-special-status");
    }

    public static ValueSet setVSSpecialStatus(ValueSet context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-special-status", new StringType(value));
        return context;
    }

    public static String getVSSpecialStatus(ValueSet context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/valueset-special-status");
    }

    public static Extension makeVSSupplement(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-supplement").setValue(new CanonicalType(value));
    }

    public static ValueSet addVSSupplement(ValueSet context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-supplement", new CanonicalType(value));
        return context;
    }

    public static List<String> getVSSupplementList(ValueSet context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/valueset-supplement");
    }

    public static Extension makeVSSystem(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-system").setValue(new CanonicalType(value));
    }

    public static Extension makeVSSystemName(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-systemName").setValue(new StringType(value));
    }

    public static Extension makeVSSystemReference(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-systemRef").setValue(new UriType(value));
    }

    public static Extension makeVSSystemTitle(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-systemTitle").setValue(new StringType(value));
    }

    public static Extension makeVSToocostly(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-toocostly").setValue(new BooleanType(value));
    }

    public static ValueSet.ValueSetExpansionComponent setVSToocostly(ValueSet.ValueSetExpansionComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-toocostly", new BooleanType(value));
        return context;
    }

    public static Boolean getVSToocostly(ValueSet.ValueSetExpansionComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/valueset-toocostly");
    }

    public static Extension makeVSTrustedExpansion(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-trusted-expansion").setValue(new UrlType(value));
    }

    public static ValueSet addVSTrustedExpansion(ValueSet context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-trusted-expansion", new UrlType(value));
        return context;
    }

    public static List<String> getVSTrustedExpansionList(ValueSet context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/valueset-trusted-expansion");
    }

    public static Extension makeVSUnclosed(boolean value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-unclosed").setValue(new BooleanType(value));
    }

    public static ValueSet.ValueSetExpansionComponent setVSUnclosed(ValueSet.ValueSetExpansionComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-unclosed", new BooleanType(value));
        return context;
    }

    public static Boolean getVSUnclosed(ValueSet.ValueSetExpansionComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/StructureDefinition/valueset-unclosed");
    }

    public static Extension makeVSWarning(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-warning").setValue(new MarkdownType(value));
    }

    public static ValueSet setVSWarning(ValueSet context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-warning", new MarkdownType(value));
        return context;
    }

    public static String getVSWarning(ValueSet context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/valueset-warning");
    }

    public static Extension makeWorkflowStatusDescription(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/valueset-workflowStatusDescription").setValue(new StringType(value));
    }

    public static ValueSet setWorkflowStatusDescription(ValueSet context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/valueset-workflowStatusDescription", new StringType(value));
        return context;
    }

    public static String getWorkflowStatusDescription(ValueSet context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/valueset-workflowStatusDescription");
    }

    public static Extension makeVariable(Expression value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/variable").setValue(value);
    }

    public static ActivityDefinition addVariable(ActivityDefinition context, Expression value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/variable", value);
        return context;
    }

    public static List<Expression> getVariableList(ActivityDefinition context) {
        return ExtensionsUtils.getExtensionList(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/variable");
    }

    public static Measure addVariable(Measure context, Expression value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/variable", value);
        return context;
    }

    public static List<Expression> getVariableList(Measure context) {
        return ExtensionsUtils.getExtensionList(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/variable");
    }

    public static PlanDefinition addVariable(PlanDefinition context, Expression value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/variable", value);
        return context;
    }

    public static List<Expression> getVariableList(PlanDefinition context) {
        return ExtensionsUtils.getExtensionList(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/variable");
    }

    public static Questionnaire addVariable(Questionnaire context, Expression value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/variable", value);
        return context;
    }

    public static List<Expression> getVariableList(Questionnaire context) {
        return ExtensionsUtils.getExtensionList(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/variable");
    }

    public static RequestOrchestration addVariable(RequestOrchestration context, Expression value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/variable", value);
        return context;
    }

    public static List<Expression> getVariableList(RequestOrchestration context) {
        return ExtensionsUtils.getExtensionList(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/variable");
    }

    public static Measure.MeasureGroupComponent addVariable(Measure.MeasureGroupComponent context, Expression value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/variable", value);
        return context;
    }

    public static List<Expression> getVariableList(Measure.MeasureGroupComponent context) {
        return ExtensionsUtils.getExtensionList(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/variable");
    }

    public static PlanDefinition.PlanDefinitionActionComponent addVariable(PlanDefinition.PlanDefinitionActionComponent context, Expression value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/variable", value);
        return context;
    }

    public static List<Expression> getVariableList(PlanDefinition.PlanDefinitionActionComponent context) {
        return ExtensionsUtils.getExtensionList(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/variable");
    }

    public static Questionnaire.QuestionnaireItemComponent addVariable(Questionnaire.QuestionnaireItemComponent context, Expression value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/variable", value);
        return context;
    }

    public static List<Expression> getVariableList(Questionnaire.QuestionnaireItemComponent context) {
        return ExtensionsUtils.getExtensionList(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/variable");
    }

    public static RequestOrchestration.RequestOrchestrationActionComponent addVariable(RequestOrchestration.RequestOrchestrationActionComponent context, Expression value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/variable", value);
        return context;
    }

    public static List<Expression> getVariableList(RequestOrchestration.RequestOrchestrationActionComponent context) {
        return ExtensionsUtils.getExtensionList(Expression.class, context, "http://hl7.org/fhir/StructureDefinition/variable");
    }

    public static Extension makeAdheresToCanonical(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-adheresTo").setValue(new CanonicalType(value));
    }

    public static Extension makeAdheresTo(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-adheresTo").setValue(value);
    }

    public static Extension makeAdheresToUri(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-adheresTo").setValue(new UriType(value));
    }

    public static Communication addAdheresToCanonical(Communication context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new CanonicalType(value));
        return context;
    }

    public static List<String> getAdheresToStringList(Communication context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static Communication addAdheresTo(Communication context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", value);
        return context;
    }

    public static List<Reference> getAdheresToReferenceList(Communication context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static Communication addAdheresToUri(Communication context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new UriType(value));
        return context;
    }

    public static Condition addAdheresToCanonical(Condition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new CanonicalType(value));
        return context;
    }

    public static List<String> getAdheresToStringList(Condition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static Condition addAdheresTo(Condition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", value);
        return context;
    }

    public static List<Reference> getAdheresToReferenceList(Condition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static Condition addAdheresToUri(Condition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new UriType(value));
        return context;
    }

    public static DiagnosticReport addAdheresToCanonical(DiagnosticReport context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new CanonicalType(value));
        return context;
    }

    public static List<String> getAdheresToStringList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static DiagnosticReport addAdheresTo(DiagnosticReport context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", value);
        return context;
    }

    public static List<Reference> getAdheresToReferenceList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static DiagnosticReport addAdheresToUri(DiagnosticReport context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new UriType(value));
        return context;
    }

    public static DocumentReference addAdheresToCanonical(DocumentReference context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new CanonicalType(value));
        return context;
    }

    public static List<String> getAdheresToStringList(DocumentReference context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static DocumentReference addAdheresTo(DocumentReference context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", value);
        return context;
    }

    public static List<Reference> getAdheresToReferenceList(DocumentReference context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static DocumentReference addAdheresToUri(DocumentReference context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new UriType(value));
        return context;
    }

    public static Encounter addAdheresToCanonical(Encounter context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new CanonicalType(value));
        return context;
    }

    public static List<String> getAdheresToStringList(Encounter context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static Encounter addAdheresTo(Encounter context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", value);
        return context;
    }

    public static List<Reference> getAdheresToReferenceList(Encounter context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static Encounter addAdheresToUri(Encounter context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new UriType(value));
        return context;
    }

    public static FamilyMemberHistory addAdheresToCanonical(FamilyMemberHistory context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new CanonicalType(value));
        return context;
    }

    public static List<String> getAdheresToStringList(FamilyMemberHistory context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static FamilyMemberHistory addAdheresTo(FamilyMemberHistory context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", value);
        return context;
    }

    public static List<Reference> getAdheresToReferenceList(FamilyMemberHistory context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static FamilyMemberHistory addAdheresToUri(FamilyMemberHistory context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new UriType(value));
        return context;
    }

    public static Immunization addAdheresToCanonical(Immunization context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new CanonicalType(value));
        return context;
    }

    public static List<String> getAdheresToStringList(Immunization context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static Immunization addAdheresTo(Immunization context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", value);
        return context;
    }

    public static List<Reference> getAdheresToReferenceList(Immunization context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static Immunization addAdheresToUri(Immunization context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new UriType(value));
        return context;
    }

    public static ImmunizationEvaluation addAdheresToCanonical(ImmunizationEvaluation context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new CanonicalType(value));
        return context;
    }

    public static List<String> getAdheresToStringList(ImmunizationEvaluation context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static ImmunizationEvaluation addAdheresTo(ImmunizationEvaluation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", value);
        return context;
    }

    public static List<Reference> getAdheresToReferenceList(ImmunizationEvaluation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static ImmunizationEvaluation addAdheresToUri(ImmunizationEvaluation context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new UriType(value));
        return context;
    }

    public static Observation addAdheresToCanonical(Observation context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new CanonicalType(value));
        return context;
    }

    public static List<String> getAdheresToStringList(Observation context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static Observation addAdheresTo(Observation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", value);
        return context;
    }

    public static List<Reference> getAdheresToReferenceList(Observation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static Observation addAdheresToUri(Observation context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new UriType(value));
        return context;
    }

    public static QuestionnaireResponse addAdheresToCanonical(QuestionnaireResponse context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new CanonicalType(value));
        return context;
    }

    public static List<String> getAdheresToStringList(QuestionnaireResponse context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static QuestionnaireResponse addAdheresTo(QuestionnaireResponse context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", value);
        return context;
    }

    public static List<Reference> getAdheresToReferenceList(QuestionnaireResponse context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static QuestionnaireResponse addAdheresToUri(QuestionnaireResponse context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new UriType(value));
        return context;
    }

    public static SupplyDelivery addAdheresToCanonical(SupplyDelivery context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new CanonicalType(value));
        return context;
    }

    public static List<String> getAdheresToStringList(SupplyDelivery context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static SupplyDelivery addAdheresTo(SupplyDelivery context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", value);
        return context;
    }

    public static List<Reference> getAdheresToReferenceList(SupplyDelivery context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo");
    }

    public static SupplyDelivery addAdheresToUri(SupplyDelivery context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-adheresTo", new UriType(value));
        return context;
    }

    public static Extension makeWorkflowBarrier(CodeableReference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-barrier").setValue(value);
    }

    public static CommunicationRequest addWorkflowBarrier(CommunicationRequest context, CodeableReference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-barrier", value);
        return context;
    }

    public static List<CodeableReference> getWorkflowBarrierList(CommunicationRequest context) {
        return ExtensionsUtils.getExtensionList(CodeableReference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-barrier");
    }

    public static Goal addWorkflowBarrier(Goal context, CodeableReference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-barrier", value);
        return context;
    }

    public static List<CodeableReference> getWorkflowBarrierList(Goal context) {
        return ExtensionsUtils.getExtensionList(CodeableReference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-barrier");
    }

    public static CarePlan.CarePlanActivityComponent addWorkflowBarrier(CarePlan.CarePlanActivityComponent context, CodeableReference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-barrier", value);
        return context;
    }

    public static List<CodeableReference> getWorkflowBarrierList(CarePlan.CarePlanActivityComponent context) {
        return ExtensionsUtils.getExtensionList(CodeableReference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-barrier");
    }

    public static Extension makeCompliesWithCanonical(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-compliesWith").setValue(new CanonicalType(value));
    }

    public static Extension makeCompliesWith(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-compliesWith").setValue(value);
    }

    public static Extension makeCompliesWithUri(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-compliesWith").setValue(new UriType(value));
    }

    public static CarePlan addCompliesWithCanonical(CarePlan context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getCompliesWithStringList(CarePlan context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static CarePlan addCompliesWith(CarePlan context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", value);
        return context;
    }

    public static List<Reference> getCompliesWithReferenceList(CarePlan context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static CarePlan addCompliesWithUri(CarePlan context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new UriType(value));
        return context;
    }

    public static CommunicationRequest addCompliesWithCanonical(CommunicationRequest context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getCompliesWithStringList(CommunicationRequest context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static CommunicationRequest addCompliesWith(CommunicationRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", value);
        return context;
    }

    public static List<Reference> getCompliesWithReferenceList(CommunicationRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static CommunicationRequest addCompliesWithUri(CommunicationRequest context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new UriType(value));
        return context;
    }

    public static DeviceRequest addCompliesWithCanonical(DeviceRequest context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getCompliesWithStringList(DeviceRequest context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static DeviceRequest addCompliesWith(DeviceRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", value);
        return context;
    }

    public static List<Reference> getCompliesWithReferenceList(DeviceRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static DeviceRequest addCompliesWithUri(DeviceRequest context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new UriType(value));
        return context;
    }

    public static ImmunizationRecommendation addCompliesWithCanonical(ImmunizationRecommendation context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getCompliesWithStringList(ImmunizationRecommendation context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static ImmunizationRecommendation addCompliesWith(ImmunizationRecommendation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", value);
        return context;
    }

    public static List<Reference> getCompliesWithReferenceList(ImmunizationRecommendation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static ImmunizationRecommendation addCompliesWithUri(ImmunizationRecommendation context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new UriType(value));
        return context;
    }

    public static NutritionOrder addCompliesWithCanonical(NutritionOrder context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getCompliesWithStringList(NutritionOrder context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static NutritionOrder addCompliesWith(NutritionOrder context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", value);
        return context;
    }

    public static List<Reference> getCompliesWithReferenceList(NutritionOrder context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static NutritionOrder addCompliesWithUri(NutritionOrder context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new UriType(value));
        return context;
    }

    public static RequestOrchestration addCompliesWithCanonical(RequestOrchestration context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getCompliesWithStringList(RequestOrchestration context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static RequestOrchestration addCompliesWith(RequestOrchestration context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", value);
        return context;
    }

    public static List<Reference> getCompliesWithReferenceList(RequestOrchestration context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static RequestOrchestration addCompliesWithUri(RequestOrchestration context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new UriType(value));
        return context;
    }

    public static ServiceRequest addCompliesWithCanonical(ServiceRequest context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getCompliesWithStringList(ServiceRequest context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static ServiceRequest addCompliesWith(ServiceRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", value);
        return context;
    }

    public static List<Reference> getCompliesWithReferenceList(ServiceRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static ServiceRequest addCompliesWithUri(ServiceRequest context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new UriType(value));
        return context;
    }

    public static SupplyRequest addCompliesWithCanonical(SupplyRequest context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getCompliesWithStringList(SupplyRequest context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static SupplyRequest addCompliesWith(SupplyRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", value);
        return context;
    }

    public static List<Reference> getCompliesWithReferenceList(SupplyRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static SupplyRequest addCompliesWithUri(SupplyRequest context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new UriType(value));
        return context;
    }

    public static Task addCompliesWithCanonical(Task context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getCompliesWithStringList(Task context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static Task addCompliesWith(Task context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", value);
        return context;
    }

    public static List<Reference> getCompliesWithReferenceList(Task context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith");
    }

    public static Task addCompliesWithUri(Task context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-compliesWith", new UriType(value));
        return context;
    }

    public static Extension makeEpisodeOfCare(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare").setValue(value);
    }

    public static AdverseEvent addEpisodeOfCare(AdverseEvent context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(AdverseEvent context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Appointment addEpisodeOfCare(Appointment context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Appointment context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Basic addEpisodeOfCare(Basic context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Basic context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static CarePlan addEpisodeOfCare(CarePlan context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(CarePlan context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static ChargeItem addEpisodeOfCare(ChargeItem context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(ChargeItem context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static ClinicalImpression addEpisodeOfCare(ClinicalImpression context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(ClinicalImpression context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Communication addEpisodeOfCare(Communication context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Communication context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static CommunicationRequest addEpisodeOfCare(CommunicationRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(CommunicationRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Composition addEpisodeOfCare(Composition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Composition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Condition addEpisodeOfCare(Condition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Condition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Consent addEpisodeOfCare(Consent context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Consent context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static DetectedIssue addEpisodeOfCare(DetectedIssue context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(DetectedIssue context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static DeviceRequest addEpisodeOfCare(DeviceRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(DeviceRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static DeviceUsage addEpisodeOfCare(DeviceUsage context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(DeviceUsage context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static DiagnosticReport addEpisodeOfCare(DiagnosticReport context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static DocumentReference addEpisodeOfCare(DocumentReference context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(DocumentReference context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Encounter addEpisodeOfCare(Encounter context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Encounter context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static EnrollmentRequest addEpisodeOfCare(EnrollmentRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(EnrollmentRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static EnrollmentResponse addEpisodeOfCare(EnrollmentResponse context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(EnrollmentResponse context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static FamilyMemberHistory addEpisodeOfCare(FamilyMemberHistory context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(FamilyMemberHistory context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Flag addEpisodeOfCare(Flag context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Flag context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Goal addEpisodeOfCare(Goal context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Goal context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static ImagingStudy addEpisodeOfCare(ImagingStudy context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(ImagingStudy context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Immunization addEpisodeOfCare(Immunization context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Immunization context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static ImmunizationEvaluation addEpisodeOfCare(ImmunizationEvaluation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(ImmunizationEvaluation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static ImmunizationRecommendation addEpisodeOfCare(ImmunizationRecommendation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(ImmunizationRecommendation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Invoice addEpisodeOfCare(Invoice context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Invoice context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static ListResource addEpisodeOfCare(ListResource context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(ListResource context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static MeasureReport addEpisodeOfCare(MeasureReport context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(MeasureReport context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static MedicationAdministration addEpisodeOfCare(MedicationAdministration context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(MedicationAdministration context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static MedicationDispense addEpisodeOfCare(MedicationDispense context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(MedicationDispense context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static MedicationRequest addEpisodeOfCare(MedicationRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(MedicationRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static MedicationStatement addEpisodeOfCare(MedicationStatement context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(MedicationStatement context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static MolecularSequence addEpisodeOfCare(MolecularSequence context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(MolecularSequence context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static NutritionIntake addEpisodeOfCare(NutritionIntake context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(NutritionIntake context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static NutritionOrder addEpisodeOfCare(NutritionOrder context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(NutritionOrder context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Observation addEpisodeOfCare(Observation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Observation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Procedure addEpisodeOfCare(Procedure context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(Procedure context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static QuestionnaireResponse addEpisodeOfCare(QuestionnaireResponse context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(QuestionnaireResponse context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static RequestOrchestration addEpisodeOfCare(RequestOrchestration context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(RequestOrchestration context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static ResearchSubject addEpisodeOfCare(ResearchSubject context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(ResearchSubject context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static RiskAssessment addEpisodeOfCare(RiskAssessment context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(RiskAssessment context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static ServiceRequest addEpisodeOfCare(ServiceRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(ServiceRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static SupplyDelivery addEpisodeOfCare(SupplyDelivery context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(SupplyDelivery context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static SupplyRequest addEpisodeOfCare(SupplyRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(SupplyRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static VisionPrescription addEpisodeOfCare(VisionPrescription context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare", value);
        return context;
    }

    public static List<Reference> getEpisodeOfCareList(VisionPrescription context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-episodeOfCare");
    }

    public static Extension makeFollowOnOf(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-followOnOf").setValue(value);
    }

    public static DeviceRequest addFollowOnOf(DeviceRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-followOnOf", value);
        return context;
    }

    public static List<Reference> getFollowOnOfList(DeviceRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-followOnOf");
    }

    public static Encounter addFollowOnOf(Encounter context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-followOnOf", value);
        return context;
    }

    public static List<Reference> getFollowOnOfList(Encounter context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-followOnOf");
    }

    public static Procedure addFollowOnOf(Procedure context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-followOnOf", value);
        return context;
    }

    public static List<Reference> getFollowOnOfList(Procedure context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-followOnOf");
    }

    public static ServiceRequest addFollowOnOf(ServiceRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-followOnOf", value);
        return context;
    }

    public static List<Reference> getFollowOnOfList(ServiceRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-followOnOf");
    }

    public static Task addFollowOnOf(Task context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-followOnOf", value);
        return context;
    }

    public static List<Reference> getFollowOnOfList(Task context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-followOnOf");
    }

    public static Extension makeGeneratedFrom(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom").setValue(new CanonicalType(value));
    }

    public static CarePlan setGeneratedFrom(CarePlan context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom", new CanonicalType(value));
        return context;
    }

    public static String getGeneratedFrom(CarePlan context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom");
    }

    public static CommunicationRequest setGeneratedFrom(CommunicationRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom", new CanonicalType(value));
        return context;
    }

    public static String getGeneratedFrom(CommunicationRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom");
    }

    public static DeviceRequest setGeneratedFrom(DeviceRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom", new CanonicalType(value));
        return context;
    }

    public static String getGeneratedFrom(DeviceRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom");
    }

    public static ImmunizationEvaluation setGeneratedFrom(ImmunizationEvaluation context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom", new CanonicalType(value));
        return context;
    }

    public static String getGeneratedFrom(ImmunizationEvaluation context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom");
    }

    public static ImmunizationRecommendation setGeneratedFrom(ImmunizationRecommendation context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom", new CanonicalType(value));
        return context;
    }

    public static String getGeneratedFrom(ImmunizationRecommendation context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom");
    }

    public static NutritionOrder setGeneratedFrom(NutritionOrder context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom", new CanonicalType(value));
        return context;
    }

    public static String getGeneratedFrom(NutritionOrder context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom");
    }

    public static RequestOrchestration setGeneratedFrom(RequestOrchestration context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom", new CanonicalType(value));
        return context;
    }

    public static String getGeneratedFrom(RequestOrchestration context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom");
    }

    public static ServiceRequest setGeneratedFrom(ServiceRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom", new CanonicalType(value));
        return context;
    }

    public static String getGeneratedFrom(ServiceRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom");
    }

    public static SupplyRequest setGeneratedFrom(SupplyRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom", new CanonicalType(value));
        return context;
    }

    public static String getGeneratedFrom(SupplyRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom");
    }

    public static Task setGeneratedFrom(Task context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom", new CanonicalType(value));
        return context;
    }

    public static String getGeneratedFrom(Task context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-generatedFrom");
    }

    public static Extension makeProtectiveFactor(CodeableReference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-protectiveFactor").setValue(value);
    }

    public static CommunicationRequest addProtectiveFactor(CommunicationRequest context, CodeableReference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-protectiveFactor", value);
        return context;
    }

    public static List<CodeableReference> getProtectiveFactorList(CommunicationRequest context) {
        return ExtensionsUtils.getExtensionList(CodeableReference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-protectiveFactor");
    }

    public static Goal addProtectiveFactor(Goal context, CodeableReference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-protectiveFactor", value);
        return context;
    }

    public static List<CodeableReference> getProtectiveFactorList(Goal context) {
        return ExtensionsUtils.getExtensionList(CodeableReference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-protectiveFactor");
    }

    public static CarePlan.CarePlanActivityComponent addProtectiveFactor(CarePlan.CarePlanActivityComponent context, CodeableReference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-protectiveFactor", value);
        return context;
    }

    public static List<CodeableReference> getProtectiveFactorList(CarePlan.CarePlanActivityComponent context) {
        return ExtensionsUtils.getExtensionList(CodeableReference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-protectiveFactor");
    }

    public static Extension makeWorkflowReason(CodeableReference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-reason").setValue(value);
    }

    public static DiagnosticReport addWorkflowReason(DiagnosticReport context, CodeableReference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-reason", value);
        return context;
    }

    public static List<CodeableReference> getWorkflowReasonList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionList(CodeableReference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-reason");
    }

    public static DocumentReference addWorkflowReason(DocumentReference context, CodeableReference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-reason", value);
        return context;
    }

    public static List<CodeableReference> getWorkflowReasonList(DocumentReference context) {
        return ExtensionsUtils.getExtensionList(CodeableReference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-reason");
    }

    public static NutritionOrder addWorkflowReason(NutritionOrder context, CodeableReference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-reason", value);
        return context;
    }

    public static List<CodeableReference> getWorkflowReasonList(NutritionOrder context) {
        return ExtensionsUtils.getExtensionList(CodeableReference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-reason");
    }

    public static Observation addWorkflowReason(Observation context, CodeableReference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-reason", value);
        return context;
    }

    public static List<CodeableReference> getWorkflowReasonList(Observation context) {
        return ExtensionsUtils.getExtensionList(CodeableReference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-reason");
    }

    public static Extension makeRelatedArtifact(RelatedArtifact value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact").setValue(value);
    }

    public static ConceptMap addRelatedArtifact(ConceptMap context, RelatedArtifact value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact", value);
        return context;
    }

    public static List<RelatedArtifact> getRelatedArtifactList(ConceptMap context) {
        return ExtensionsUtils.getExtensionList(RelatedArtifact.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact");
    }

    public static DiagnosticReport addRelatedArtifact(DiagnosticReport context, RelatedArtifact value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact", value);
        return context;
    }

    public static List<RelatedArtifact> getRelatedArtifactList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionList(RelatedArtifact.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact");
    }

    public static Observation addRelatedArtifact(Observation context, RelatedArtifact value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact", value);
        return context;
    }

    public static List<RelatedArtifact> getRelatedArtifactList(Observation context) {
        return ExtensionsUtils.getExtensionList(RelatedArtifact.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-relatedArtifact");
    }

    public static Extension makeReleaseDate(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-releaseDate").setValue(new DateTimeType(value));
    }

    public static Account setReleaseDate(Account context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(Account context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static Appointment setReleaseDate(Appointment context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(Appointment context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static ArtifactAssessment setReleaseDate(ArtifactAssessment context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(ArtifactAssessment context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static CarePlan setReleaseDate(CarePlan context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(CarePlan context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static ClinicalImpression setReleaseDate(ClinicalImpression context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(ClinicalImpression context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static Communication setReleaseDate(Communication context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(Communication context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static CommunicationRequest setReleaseDate(CommunicationRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(CommunicationRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static Contract setReleaseDate(Contract context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(Contract context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static DeviceDispense setReleaseDate(DeviceDispense context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(DeviceDispense context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static DeviceRequest setReleaseDate(DeviceRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(DeviceRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static DeviceUsage setReleaseDate(DeviceUsage context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(DeviceUsage context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static Encounter setReleaseDate(Encounter context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(Encounter context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static Endpoint setReleaseDate(Endpoint context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(Endpoint context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static EpisodeOfCare setReleaseDate(EpisodeOfCare context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(EpisodeOfCare context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static Goal setReleaseDate(Goal context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(Goal context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static MedicationAdministration setReleaseDate(MedicationAdministration context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(MedicationAdministration context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static MedicationDispense setReleaseDate(MedicationDispense context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(MedicationDispense context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static MedicationRequest setReleaseDate(MedicationRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(MedicationRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static NutritionIntake setReleaseDate(NutritionIntake context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(NutritionIntake context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static NutritionOrder setReleaseDate(NutritionOrder context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(NutritionOrder context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static Procedure setReleaseDate(Procedure context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(Procedure context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static RequestOrchestration setReleaseDate(RequestOrchestration context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(RequestOrchestration context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static ServiceRequest setReleaseDate(ServiceRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(ServiceRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static SupplyRequest setReleaseDate(SupplyRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(SupplyRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static Task setReleaseDate(Task context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(Task context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static CarePlan.CarePlanActivityComponent setReleaseDate(CarePlan.CarePlanActivityComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate", new DateTimeType(value));
        return context;
    }

    public static String getReleaseDate(CarePlan.CarePlanActivityComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-releaseDate");
    }

    public static Extension makeResearchStudy(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-researchStudy").setValue(value);
    }

    public static Composition addResearchStudy(Composition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(Composition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static Consent addResearchStudy(Consent context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(Consent context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static DeviceUsage addResearchStudy(DeviceUsage context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(DeviceUsage context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static DiagnosticReport addResearchStudy(DiagnosticReport context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static DocumentReference addResearchStudy(DocumentReference context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(DocumentReference context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static Encounter addResearchStudy(Encounter context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(Encounter context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static FamilyMemberHistory addResearchStudy(FamilyMemberHistory context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(FamilyMemberHistory context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static Immunization addResearchStudy(Immunization context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(Immunization context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static MedicationAdministration addResearchStudy(MedicationAdministration context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(MedicationAdministration context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static MedicationDispense addResearchStudy(MedicationDispense context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(MedicationDispense context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static MedicationStatement addResearchStudy(MedicationStatement context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(MedicationStatement context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static Observation addResearchStudy(Observation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(Observation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static Procedure addResearchStudy(Procedure context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(Procedure context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static QuestionnaireResponse addResearchStudy(QuestionnaireResponse context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(QuestionnaireResponse context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static RiskAssessment addResearchStudy(RiskAssessment context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(RiskAssessment context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static ServiceRequest addResearchStudy(ServiceRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(ServiceRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static SupplyDelivery addResearchStudy(SupplyDelivery context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(SupplyDelivery context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static Task addResearchStudy(Task context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy", value);
        return context;
    }

    public static List<Reference> getResearchStudyList(Task context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-researchStudy");
    }

    public static Extension makeShallComplyWithCanonical(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith").setValue(new CanonicalType(value));
    }

    public static Extension makeShallComplyWith(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith").setValue(value);
    }

    public static Extension makeShallComplyWithUri(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith").setValue(new UriType(value));
    }

    public static ActivityDefinition addShallComplyWithCanonical(ActivityDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getShallComplyWithStringList(ActivityDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static ActivityDefinition addShallComplyWith(ActivityDefinition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", value);
        return context;
    }

    public static List<Reference> getShallComplyWithReferenceList(ActivityDefinition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static ActivityDefinition addShallComplyWithUri(ActivityDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new UriType(value));
        return context;
    }

    public static CommunicationRequest addShallComplyWithCanonical(CommunicationRequest context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getShallComplyWithStringList(CommunicationRequest context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static CommunicationRequest addShallComplyWith(CommunicationRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", value);
        return context;
    }

    public static List<Reference> getShallComplyWithReferenceList(CommunicationRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static CommunicationRequest addShallComplyWithUri(CommunicationRequest context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new UriType(value));
        return context;
    }

    public static Condition addShallComplyWithCanonical(Condition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getShallComplyWithStringList(Condition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static Condition addShallComplyWith(Condition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", value);
        return context;
    }

    public static List<Reference> getShallComplyWithReferenceList(Condition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static Condition addShallComplyWithUri(Condition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new UriType(value));
        return context;
    }

    public static DiagnosticReport addShallComplyWithCanonical(DiagnosticReport context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getShallComplyWithStringList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static DiagnosticReport addShallComplyWith(DiagnosticReport context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", value);
        return context;
    }

    public static List<Reference> getShallComplyWithReferenceList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static DiagnosticReport addShallComplyWithUri(DiagnosticReport context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new UriType(value));
        return context;
    }

    public static DocumentReference addShallComplyWithCanonical(DocumentReference context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getShallComplyWithStringList(DocumentReference context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static DocumentReference addShallComplyWith(DocumentReference context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", value);
        return context;
    }

    public static List<Reference> getShallComplyWithReferenceList(DocumentReference context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static DocumentReference addShallComplyWithUri(DocumentReference context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new UriType(value));
        return context;
    }

    public static Measure addShallComplyWithCanonical(Measure context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getShallComplyWithStringList(Measure context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static Measure addShallComplyWith(Measure context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", value);
        return context;
    }

    public static List<Reference> getShallComplyWithReferenceList(Measure context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static Measure addShallComplyWithUri(Measure context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new UriType(value));
        return context;
    }

    public static Observation addShallComplyWithCanonical(Observation context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getShallComplyWithStringList(Observation context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static Observation addShallComplyWith(Observation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", value);
        return context;
    }

    public static List<Reference> getShallComplyWithReferenceList(Observation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static Observation addShallComplyWithUri(Observation context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new UriType(value));
        return context;
    }

    public static OperationDefinition addShallComplyWithCanonical(OperationDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getShallComplyWithStringList(OperationDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static OperationDefinition addShallComplyWith(OperationDefinition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", value);
        return context;
    }

    public static List<Reference> getShallComplyWithReferenceList(OperationDefinition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static OperationDefinition addShallComplyWithUri(OperationDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new UriType(value));
        return context;
    }

    public static PlanDefinition addShallComplyWithCanonical(PlanDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getShallComplyWithStringList(PlanDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static PlanDefinition addShallComplyWith(PlanDefinition context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", value);
        return context;
    }

    public static List<Reference> getShallComplyWithReferenceList(PlanDefinition context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static PlanDefinition addShallComplyWithUri(PlanDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new UriType(value));
        return context;
    }

    public static SupplyDelivery addShallComplyWithCanonical(SupplyDelivery context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getShallComplyWithStringList(SupplyDelivery context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static SupplyDelivery addShallComplyWith(SupplyDelivery context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", value);
        return context;
    }

    public static List<Reference> getShallComplyWithReferenceList(SupplyDelivery context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static SupplyDelivery addShallComplyWithUri(SupplyDelivery context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new UriType(value));
        return context;
    }

    public static SupplyRequest addShallComplyWithCanonical(SupplyRequest context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new CanonicalType(value));
        return context;
    }

    public static List<String> getShallComplyWithStringList(SupplyRequest context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static SupplyRequest addShallComplyWith(SupplyRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", value);
        return context;
    }

    public static List<Reference> getShallComplyWithReferenceList(SupplyRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith");
    }

    public static SupplyRequest addShallComplyWithUri(SupplyRequest context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-shallComplyWith", new UriType(value));
        return context;
    }

    public static Extension makeSupportingInfo(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo").setValue(value);
    }

    public static CommunicationRequest addSupportingInfo(CommunicationRequest context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo", value);
        return context;
    }

    public static List<Reference> getSupportingInfoList(CommunicationRequest context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo");
    }

    public static DiagnosticReport addSupportingInfo(DiagnosticReport context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo", value);
        return context;
    }

    public static List<Reference> getSupportingInfoList(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo");
    }

    public static DocumentReference addSupportingInfo(DocumentReference context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo", value);
        return context;
    }

    public static List<Reference> getSupportingInfoList(DocumentReference context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo");
    }

    public static Encounter addSupportingInfo(Encounter context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo", value);
        return context;
    }

    public static List<Reference> getSupportingInfoList(Encounter context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo");
    }

    public static Observation addSupportingInfo(Observation context, Reference value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo", value);
        return context;
    }

    public static List<Reference> getSupportingInfoList(Observation context) {
        return ExtensionsUtils.getExtensionList(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-supportingInfo");
    }

    public static Extension makeTriggeredByCanonical(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy").setValue(new CanonicalType(value));
    }

    public static Extension makeTriggeredBy(Reference value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy").setValue(value);
    }

    public static Extension makeTriggeredByUri(String value) {
        return new Extension("http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy").setValue(new UriType(value));
    }

    public static CarePlan setTriggeredByCanonical(CarePlan context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(CarePlan context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static CarePlan setTriggeredBy(CarePlan context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(CarePlan context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static CarePlan setTriggeredByUri(CarePlan context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static Communication setTriggeredByCanonical(Communication context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(Communication context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static Communication setTriggeredBy(Communication context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(Communication context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static Communication setTriggeredByUri(Communication context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static CommunicationRequest setTriggeredByCanonical(CommunicationRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(CommunicationRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static CommunicationRequest setTriggeredBy(CommunicationRequest context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(CommunicationRequest context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static CommunicationRequest setTriggeredByUri(CommunicationRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static Condition setTriggeredByCanonical(Condition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(Condition context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static Condition setTriggeredBy(Condition context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(Condition context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static Condition setTriggeredByUri(Condition context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static DeviceRequest setTriggeredByCanonical(DeviceRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(DeviceRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static DeviceRequest setTriggeredBy(DeviceRequest context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(DeviceRequest context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static DeviceRequest setTriggeredByUri(DeviceRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static DiagnosticReport setTriggeredByCanonical(DiagnosticReport context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(DiagnosticReport context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static DiagnosticReport setTriggeredBy(DiagnosticReport context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(DiagnosticReport context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static DiagnosticReport setTriggeredByUri(DiagnosticReport context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static DocumentReference setTriggeredByCanonical(DocumentReference context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(DocumentReference context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static DocumentReference setTriggeredBy(DocumentReference context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(DocumentReference context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static DocumentReference setTriggeredByUri(DocumentReference context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static Encounter setTriggeredByCanonical(Encounter context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(Encounter context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static Encounter setTriggeredBy(Encounter context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(Encounter context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static Encounter setTriggeredByUri(Encounter context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static FamilyMemberHistory setTriggeredByCanonical(FamilyMemberHistory context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(FamilyMemberHistory context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static FamilyMemberHistory setTriggeredBy(FamilyMemberHistory context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(FamilyMemberHistory context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static FamilyMemberHistory setTriggeredByUri(FamilyMemberHistory context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static Immunization setTriggeredByCanonical(Immunization context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(Immunization context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static Immunization setTriggeredBy(Immunization context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(Immunization context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static Immunization setTriggeredByUri(Immunization context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static ImmunizationRecommendation setTriggeredByCanonical(ImmunizationRecommendation context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(ImmunizationRecommendation context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static ImmunizationRecommendation setTriggeredBy(ImmunizationRecommendation context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(ImmunizationRecommendation context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static ImmunizationRecommendation setTriggeredByUri(ImmunizationRecommendation context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static NutritionOrder setTriggeredByCanonical(NutritionOrder context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(NutritionOrder context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static NutritionOrder setTriggeredBy(NutritionOrder context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(NutritionOrder context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static NutritionOrder setTriggeredByUri(NutritionOrder context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static Observation setTriggeredByCanonical(Observation context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(Observation context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static Observation setTriggeredBy(Observation context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(Observation context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static Observation setTriggeredByUri(Observation context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static QuestionnaireResponse setTriggeredByCanonical(QuestionnaireResponse context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(QuestionnaireResponse context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static QuestionnaireResponse setTriggeredBy(QuestionnaireResponse context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(QuestionnaireResponse context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static QuestionnaireResponse setTriggeredByUri(QuestionnaireResponse context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static RequestOrchestration setTriggeredByCanonical(RequestOrchestration context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(RequestOrchestration context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static RequestOrchestration setTriggeredBy(RequestOrchestration context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(RequestOrchestration context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static RequestOrchestration setTriggeredByUri(RequestOrchestration context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static ServiceRequest setTriggeredByCanonical(ServiceRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(ServiceRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static ServiceRequest setTriggeredBy(ServiceRequest context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(ServiceRequest context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static ServiceRequest setTriggeredByUri(ServiceRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static SupplyDelivery setTriggeredByCanonical(SupplyDelivery context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(SupplyDelivery context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static SupplyDelivery setTriggeredBy(SupplyDelivery context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(SupplyDelivery context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static SupplyDelivery setTriggeredByUri(SupplyDelivery context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static SupplyRequest setTriggeredByCanonical(SupplyRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(SupplyRequest context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static SupplyRequest setTriggeredBy(SupplyRequest context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(SupplyRequest context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static SupplyRequest setTriggeredByUri(SupplyRequest context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static Task setTriggeredByCanonical(Task context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new CanonicalType(value));
        return context;
    }

    public static String getTriggeredByString(Task context) {
        return ExtensionsUtils.getExtensionString(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static Task setTriggeredBy(Task context, Reference value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", value);
        return context;
    }

    public static Reference getTriggeredByReference(Task context) {
        return ExtensionsUtils.getExtension(Reference.class, context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy");
    }

    public static Task setTriggeredByUri(Task context, String value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/StructureDefinition/workflow-triggeredBy", new UriType(value));
        return context;
    }

    public static Extension makeBindingDefinition(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/binding-definition").setValue(new MarkdownType(value));
    }

    public static ElementDefinition.ElementDefinitionBindingComponent addBindingDefinition(ElementDefinition.ElementDefinitionBindingComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/binding-definition", new MarkdownType(value));
        return context;
    }

    public static List<String> getBindingDefinitionList(ElementDefinition.ElementDefinitionBindingComponent context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/binding-definition");
    }

    public static Extension makeVocabBindingStylesEXT(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/binding-style").setValue(new CodeType(value));
    }

    public static StructureDefinition addVocabBindingStylesEXT(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/binding-style", new CodeType(value));
        return context;
    }

    public static List<String> getVocabBindingStylesEXTList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/binding-style");
    }

    public static Extension makeDateFormat(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format").setValue(new StringType(value));
    }

    public static ElementDefinition addDateFormat(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format", new StringType(value));
        return context;
    }

    public static List<String> getDateFormatList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format");
    }

    public static Extension makeJsonPropertyName(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name").setValue(new StringType(value));
    }

    public static ElementDefinition addJsonPropertyName(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name", new StringType(value));
        return context;
    }

    public static List<String> getJsonPropertyNameList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name");
    }

    public static Extension makeExtensionStylesEXT(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/extension-style").setValue(new CodeType(value));
    }

    public static StructureDefinition addExtensionStylesEXT(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/extension-style", new CodeType(value));
        return context;
    }

    public static List<String> getExtensionStylesEXTList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/extension-style");
    }

    public static Extension makeIdExpectationExt(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/id-expectation").setValue(new CodeType(value));
    }

    public static ElementDefinition addIdExpectationExt(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/id-expectation", new CodeType(value));
        return context;
    }

    public static List<String> getIdExpectationExtList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/id-expectation");
    }

    public static ElementDefinition.TypeRefComponent addIdExpectationExt(ElementDefinition.TypeRefComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/id-expectation", new CodeType(value));
        return context;
    }

    public static List<String> getIdExpectationExtList(ElementDefinition.TypeRefComponent context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/id-expectation");
    }

    public static Extension makeIGPageName(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/ig-page-name").setValue(new UrlType(value));
    }

    public static Extension makeIGDependencyComment(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment").setValue(new MarkdownType(value));
    }

    public static ImplementationGuide.ImplementationGuideDependsOnComponent addIGDependencyComment(ImplementationGuide.ImplementationGuideDependsOnComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment", new MarkdownType(value));
        return context;
    }

    public static List<String> getIGDependencyCommentList(ImplementationGuide.ImplementationGuideDependsOnComponent context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment");
    }

    public static Extension makeBinaryResourceFormat(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format").setValue(new CodeType(value));
    }

    public static Extension makeBinaryResourceLogical(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical").setValue(new CanonicalType(value));
    }

    public static Extension makeImpliedStringPrefix(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix").setValue(new StringType(value));
    }

    public static ElementDefinition addImpliedStringPrefix(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix", new StringType(value));
        return context;
    }

    public static List<String> getImpliedStringPrefixList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix");
    }

    public static Extension makeJsonEmptyBehavior(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior").setValue(new CodeType(value));
    }

    public static ElementDefinition addJsonEmptyBehavior(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior", new CodeType(value));
        return context;
    }

    public static List<String> getJsonEmptyBehaviorList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior");
    }

    public static ElementDefinition.TypeRefComponent addJsonEmptyBehavior(ElementDefinition.TypeRefComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior", new CodeType(value));
        return context;
    }

    public static List<String> getJsonEmptyBehaviorList(ElementDefinition.TypeRefComponent context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior");
    }

    public static Extension makeJsonNullableExt(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/json-nullable").setValue(new BooleanType(value));
    }

    public static ElementDefinition setJsonNullableExt(ElementDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-nullable", new BooleanType(value));
        return context;
    }

    public static Boolean getJsonNullableExt(ElementDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/tools/StructureDefinition/json-nullable");
    }

    public static ElementDefinition.TypeRefComponent setJsonNullableExt(ElementDefinition.TypeRefComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-nullable", new BooleanType(value));
        return context;
    }

    public static Boolean getJsonNullableExt(ElementDefinition.TypeRefComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/tools/StructureDefinition/json-nullable");
    }

    public static Extension makeJsonPrimitiveChoiceExt(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice").setValue(new BooleanType(value));
    }

    public static ElementDefinition setJsonPrimitiveChoiceExt(ElementDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice", new BooleanType(value));
        return context;
    }

    public static Boolean getJsonPrimitiveChoiceExt(ElementDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice");
    }

    public static ElementDefinition.TypeRefComponent setJsonPrimitiveChoiceExt(ElementDefinition.TypeRefComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice", new BooleanType(value));
        return context;
    }

    public static Boolean getJsonPrimitiveChoiceExt(ElementDefinition.TypeRefComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice");
    }

    public static Extension makeJsonPropertyKey(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/json-property-key").setValue(new CodeType(value));
    }

    public static ElementDefinition addJsonPropertyKey(ElementDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-property-key", new CodeType(value));
        return context;
    }

    public static List<String> getJsonPropertyKeyList(ElementDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/json-property-key");
    }

    public static ElementDefinition.TypeRefComponent addJsonPropertyKey(ElementDefinition.TypeRefComponent context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/json-property-key", new CodeType(value));
        return context;
    }

    public static List<String> getJsonPropertyKeyList(ElementDefinition.TypeRefComponent context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/json-property-key");
    }

    public static Extension makeNoBinding(boolean value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/no-binding").setValue(new BooleanType(value));
    }

    public static ElementDefinition setNoBinding(ElementDefinition context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/no-binding", new BooleanType(value));
        return context;
    }

    public static Boolean getNoBinding(ElementDefinition context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/tools/StructureDefinition/no-binding");
    }

    public static ElementDefinition.TypeRefComponent setNoBinding(ElementDefinition.TypeRefComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/no-binding", new BooleanType(value));
        return context;
    }

    public static Boolean getNoBinding(ElementDefinition.TypeRefComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://hl7.org/fhir/tools/StructureDefinition/no-binding");
    }

    public static Extension makeProfileMapping(DataType value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/profile-mapping").setValue(value);
    }

    public static Extension makeProfileSummary(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/profile-summary").setValue(new MarkdownType(value));
    }

    public static StructureDefinition addProfileSummary(StructureDefinition context, String value) {
        ExtensionsUtils.addExtension(context, "http://hl7.org/fhir/tools/StructureDefinition/profile-summary", new MarkdownType(value));
        return context;
    }

    public static List<String> getProfileSummaryList(StructureDefinition context) {
        return ExtensionsUtils.getExtensionStringList(context, "http://hl7.org/fhir/tools/StructureDefinition/profile-summary");
    }

    public static Extension makeSelectByMap(String value) {
        return new Extension("http://hl7.org/fhir/tools/StructureDefinition/select-by-map").setValue(new CanonicalType(value));
    }

    public static Extension makeSupportedConceptRelationshipInverseName(String value) {
        return new Extension("http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName").setValue(new StringType(value));
    }

    public static CodeSystem.PropertyComponent setSupportedConceptRelationshipInverseName(CodeSystem.PropertyComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName", new StringType(value));
        return context;
    }

    public static String getSupportedConceptRelationshipInverseName(CodeSystem.PropertyComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-inverseName");
    }

    public static Extension makeSupportedConceptRelationshipIsNavigable(boolean value) {
        return new Extension("http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable").setValue(new BooleanType(value));
    }

    public static CodeSystem.PropertyComponent setSupportedConceptRelationshipIsNavigable(CodeSystem.PropertyComponent context, boolean value) {
        ExtensionsUtils.setExtension(context, "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable", new BooleanType(value));
        return context;
    }

    public static Boolean getSupportedConceptRelationshipIsNavigable(CodeSystem.PropertyComponent context) {
        return ExtensionsUtils.getExtensionBoolean(context, "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-isNavigable");
    }

    public static Extension makeSupportedConceptRelationshipReflexivity(String value) {
        return new Extension("http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity").setValue(new CodeType(value));
    }

    public static CodeSystem.PropertyComponent setSupportedConceptRelationshipReflexivity(CodeSystem.PropertyComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity", new CodeType(value));
        return context;
    }

    public static String getSupportedConceptRelationshipReflexivity(CodeSystem.PropertyComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-reflexivity");
    }

    public static Extension makeSupportedConceptRelationshipRelationshipKind(String value) {
        return new Extension("http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind").setValue(new CodeType(value));
    }

    public static CodeSystem.PropertyComponent setSupportedConceptRelationshipRelationshipKind(CodeSystem.PropertyComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind", new CodeType(value));
        return context;
    }

    public static String getSupportedConceptRelationshipRelationshipKind(CodeSystem.PropertyComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-relationshipKind");
    }

    public static Extension makeSupportedConceptRelationshipSymmetry(String value) {
        return new Extension("http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry").setValue(new CodeType(value));
    }

    public static CodeSystem.PropertyComponent setSupportedConceptRelationshipSymmetry(CodeSystem.PropertyComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry", new CodeType(value));
        return context;
    }

    public static String getSupportedConceptRelationshipSymmetry(CodeSystem.PropertyComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-symmetry");
    }

    public static Extension makeSupportedConceptRelationshipTransitivity(String value) {
        return new Extension("http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity").setValue(new CodeType(value));
    }

    public static CodeSystem.PropertyComponent setSupportedConceptRelationshipTransitivity(CodeSystem.PropertyComponent context, String value) {
        ExtensionsUtils.setExtension(context, "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity", new CodeType(value));
        return context;
    }

    public static String getSupportedConceptRelationshipTransitivity(CodeSystem.PropertyComponent context) {
        return ExtensionsUtils.getExtensionString(context, "http://terminology.hl7.org/StructureDefinition/ext-mif-relationship-transitivity");
    }

    public static Extension makeNamingSystemTitle(String value) {
        return new Extension("http://terminology.hl7.org/StructureDefinition/ext-namingsystem-title").setValue(new StringType(value));
    }

    public static NamingSystem setNamingSystemTitle(NamingSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://terminology.hl7.org/StructureDefinition/ext-namingsystem-title", new StringType(value));
        return context;
    }

    public static String getNamingSystemTitle(NamingSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://terminology.hl7.org/StructureDefinition/ext-namingsystem-title");
    }

    public static Extension makeNamingSystemVersion(String value) {
        return new Extension("http://terminology.hl7.org/StructureDefinition/ext-namingsystem-version").setValue(new StringType(value));
    }

    public static NamingSystem setNamingSystemVersion(NamingSystem context, String value) {
        ExtensionsUtils.setExtension(context, "http://terminology.hl7.org/StructureDefinition/ext-namingsystem-version", new StringType(value));
        return context;
    }

    public static String getNamingSystemVersion(NamingSystem context) {
        return ExtensionsUtils.getExtensionString(context, "http://terminology.hl7.org/StructureDefinition/ext-namingsystem-version");
    }
}

