/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.comparison.CanonicalResourceComparer;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;

public class VersionComparisonAnnotation {
    public static final String USER_DATA_NAME = "version-annotation";
    private AnotationType type;
    private String original;
    private Map<String, List<Base>> deletedChildren;
    private CanonicalResourceComparer.CanonicalResourceComparison<? extends CanonicalResource> comp;

    public VersionComparisonAnnotation(AnotationType type) {
        this.type = type;
    }

    public void added() {
        assert (this.type == AnotationType.NoChange);
        this.type = AnotationType.Added;
    }

    public void changed(Base orig) {
        assert (this.type == AnotationType.NoChange);
        this.type = AnotationType.Changed;
        if (orig != null && orig.isPrimitive() && orig.primitiveValue().length() < 120) {
            this.original = orig.primitiveValue();
        }
    }

    public void deleted() {
        assert (this.type == AnotationType.NoChange);
        this.type = AnotationType.Deleted;
    }

    public void deleted(String name, Base other) {
        if (this.deletedChildren == null) {
            this.deletedChildren = new HashMap<String, List<Base>>();
        }
        if (!this.deletedChildren.containsKey(name)) {
            this.deletedChildren.put(name, new ArrayList());
        }
        this.deletedChildren.get(name).add(other);
    }

    public void comp(CanonicalResourceComparer.CanonicalResourceComparison<? extends CanonicalResource> comp) {
        assert (this.comp == null);
        if (!comp.noUpdates()) {
            this.type = AnotationType.Changed;
        }
        this.comp = comp;
    }

    public static String getUserDataName() {
        return USER_DATA_NAME;
    }

    public AnotationType getType() {
        return this.type;
    }

    public String getOriginal() {
        return this.original;
    }

    public Map<String, List<Base>> getDeletedChildren() {
        return this.deletedChildren;
    }

    public CanonicalResourceComparer.CanonicalResourceComparison<? extends CanonicalResource> getComp() {
        return this.comp;
    }

    public static boolean hasDeleted(Base base, String ... names) {
        boolean result = false;
        if (base.hasUserData(USER_DATA_NAME)) {
            VersionComparisonAnnotation self = (VersionComparisonAnnotation)base.getUserData(USER_DATA_NAME);
            for (String name : names) {
                if (self.deletedChildren == null || !self.deletedChildren.containsKey(name)) continue;
                result = true;
            }
        }
        return result;
    }

    public static List<Base> getDeleted(Base base, String ... names) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasUserData(USER_DATA_NAME)) {
            VersionComparisonAnnotation self = (VersionComparisonAnnotation)base.getUserData(USER_DATA_NAME);
            for (String name : names) {
                if (self.deletedChildren == null || !self.deletedChildren.containsKey(name)) continue;
                result.addAll((Collection<Base>)self.deletedChildren.get(name));
            }
        }
        return result;
    }

    public static Base getDeletedItem(Base base, String name) {
        ArrayList result = new ArrayList();
        if (base.hasUserData(USER_DATA_NAME)) {
            VersionComparisonAnnotation self = (VersionComparisonAnnotation)base.getUserData(USER_DATA_NAME);
            if (self.deletedChildren != null && self.deletedChildren.containsKey(name)) {
                result.addAll(self.deletedChildren.get(name));
            }
        }
        return result.isEmpty() ? null : (Base)result.get(0);
    }

    public static CanonicalResourceComparer.CanonicalResourceComparison<? extends CanonicalResource> artifactComparison(Base base) {
        if (base.hasUserData(USER_DATA_NAME)) {
            VersionComparisonAnnotation self = (VersionComparisonAnnotation)base.getUserData(USER_DATA_NAME);
            return self.comp;
        }
        return null;
    }

    public static enum AnotationType {
        NoChange,
        Added,
        Changed,
        Deleted;

    }
}

