package org.hl7.fhir.r5.model;


/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, \
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this \
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, \
     this list of conditions and the following disclaimer in the documentation \
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND \
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED \
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. \
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, \
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT \
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR \
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, \
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) \
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE \
  POSSIBILITY OF SUCH DAMAGE.
  */

// Generated on Thu, Mar 23, 2023 19:59+1100 for FHIR v5.0.0

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.math.*;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.r5.model.Enumerations.*;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Block;

import org.hl7.fhir.instance.model.api.IBaseBundle;
/**
 * A container for a collection of resources.
 */
@ResourceDef(name="Bundle", profile="http://hl7.org/fhir/StructureDefinition/Bundle")
public class Bundle extends Resource implements IBaseBundle {

    public enum BundleType {
        /**
         * The bundle is a document. The first resource is a Composition.
         */
        DOCUMENT, 
        /**
         * The bundle is a message. The first resource is a MessageHeader.
         */
        MESSAGE, 
        /**
         * The bundle is a transaction - intended to be processed by a server as an atomic commit.
         */
        TRANSACTION, 
        /**
         * The bundle is a transaction response. Because the response is a transaction response, the transaction has succeeded, and all responses are error free.
         */
        TRANSACTIONRESPONSE, 
        /**
         * The bundle is a set of actions - intended to be processed by a server as a group of independent actions.
         */
        BATCH, 
        /**
         * The bundle is a batch response. Note that as a batch, some responses may indicate failure and others success.
         */
        BATCHRESPONSE, 
        /**
         * The bundle is a list of resources from a history interaction on a server.
         */
        HISTORY, 
        /**
         * The bundle is a list of resources returned as a result of a search/query interaction, operation, or message.
         */
        SEARCHSET, 
        /**
         * The bundle is a set of resources collected into a single package for ease of distribution that imposes no processing obligations or behavioral rules beyond persistence.
         */
        COLLECTION, 
        /**
         * The bundle has been generated by a Subscription to communicate information to a client.
         */
        SUBSCRIPTIONNOTIFICATION, 
        /**
         * added to help the parsers with the generic types
         */
        NULL;
        public static BundleType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("document".equals(codeString))
          return DOCUMENT;
        if ("message".equals(codeString))
          return MESSAGE;
        if ("transaction".equals(codeString))
          return TRANSACTION;
        if ("transaction-response".equals(codeString))
          return TRANSACTIONRESPONSE;
        if ("batch".equals(codeString))
          return BATCH;
        if ("batch-response".equals(codeString))
          return BATCHRESPONSE;
        if ("history".equals(codeString))
          return HISTORY;
        if ("searchset".equals(codeString))
          return SEARCHSET;
        if ("collection".equals(codeString))
          return COLLECTION;
        if ("subscription-notification".equals(codeString))
          return SUBSCRIPTIONNOTIFICATION;
        if (Configuration.isAcceptInvalidEnums())
          return null;
        else
          throw new FHIRException("Unknown BundleType code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case DOCUMENT: return "document";
            case MESSAGE: return "message";
            case TRANSACTION: return "transaction";
            case TRANSACTIONRESPONSE: return "transaction-response";
            case BATCH: return "batch";
            case BATCHRESPONSE: return "batch-response";
            case HISTORY: return "history";
            case SEARCHSET: return "searchset";
            case COLLECTION: return "collection";
            case SUBSCRIPTIONNOTIFICATION: return "subscription-notification";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getSystem() {
          switch (this) {
            case DOCUMENT: return "http://hl7.org/fhir/bundle-type";
            case MESSAGE: return "http://hl7.org/fhir/bundle-type";
            case TRANSACTION: return "http://hl7.org/fhir/bundle-type";
            case TRANSACTIONRESPONSE: return "http://hl7.org/fhir/bundle-type";
            case BATCH: return "http://hl7.org/fhir/bundle-type";
            case BATCHRESPONSE: return "http://hl7.org/fhir/bundle-type";
            case HISTORY: return "http://hl7.org/fhir/bundle-type";
            case SEARCHSET: return "http://hl7.org/fhir/bundle-type";
            case COLLECTION: return "http://hl7.org/fhir/bundle-type";
            case SUBSCRIPTIONNOTIFICATION: return "http://hl7.org/fhir/bundle-type";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getDefinition() {
          switch (this) {
            case DOCUMENT: return "The bundle is a document. The first resource is a Composition.";
            case MESSAGE: return "The bundle is a message. The first resource is a MessageHeader.";
            case TRANSACTION: return "The bundle is a transaction - intended to be processed by a server as an atomic commit.";
            case TRANSACTIONRESPONSE: return "The bundle is a transaction response. Because the response is a transaction response, the transaction has succeeded, and all responses are error free.";
            case BATCH: return "The bundle is a set of actions - intended to be processed by a server as a group of independent actions.";
            case BATCHRESPONSE: return "The bundle is a batch response. Note that as a batch, some responses may indicate failure and others success.";
            case HISTORY: return "The bundle is a list of resources from a history interaction on a server.";
            case SEARCHSET: return "The bundle is a list of resources returned as a result of a search/query interaction, operation, or message.";
            case COLLECTION: return "The bundle is a set of resources collected into a single package for ease of distribution that imposes no processing obligations or behavioral rules beyond persistence.";
            case SUBSCRIPTIONNOTIFICATION: return "The bundle has been generated by a Subscription to communicate information to a client.";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case DOCUMENT: return "Document";
            case MESSAGE: return "Message";
            case TRANSACTION: return "Transaction";
            case TRANSACTIONRESPONSE: return "Transaction Response";
            case BATCH: return "Batch";
            case BATCHRESPONSE: return "Batch Response";
            case HISTORY: return "History List";
            case SEARCHSET: return "Search Results";
            case COLLECTION: return "Collection";
            case SUBSCRIPTIONNOTIFICATION: return "Subscription Notification";
            case NULL: return null;
            default: return "?";
          }
        }
    }

  public static class BundleTypeEnumFactory implements EnumFactory<BundleType> {
    public BundleType fromCode(String codeString) throws IllegalArgumentException {
      if (codeString == null || "".equals(codeString))
            if (codeString == null || "".equals(codeString))
                return null;
        if ("document".equals(codeString))
          return BundleType.DOCUMENT;
        if ("message".equals(codeString))
          return BundleType.MESSAGE;
        if ("transaction".equals(codeString))
          return BundleType.TRANSACTION;
        if ("transaction-response".equals(codeString))
          return BundleType.TRANSACTIONRESPONSE;
        if ("batch".equals(codeString))
          return BundleType.BATCH;
        if ("batch-response".equals(codeString))
          return BundleType.BATCHRESPONSE;
        if ("history".equals(codeString))
          return BundleType.HISTORY;
        if ("searchset".equals(codeString))
          return BundleType.SEARCHSET;
        if ("collection".equals(codeString))
          return BundleType.COLLECTION;
        if ("subscription-notification".equals(codeString))
          return BundleType.SUBSCRIPTIONNOTIFICATION;
        throw new IllegalArgumentException("Unknown BundleType code '"+codeString+"'");
        }
        public Enumeration<BundleType> fromType(PrimitiveType<?> code) throws FHIRException {
          if (code == null)
            return null;
          if (code.isEmpty())
            return new Enumeration<BundleType>(this, BundleType.NULL, code);
          String codeString = ((PrimitiveType) code).asStringValue();
          if (codeString == null || "".equals(codeString))
            return new Enumeration<BundleType>(this, BundleType.NULL, code);
        if ("document".equals(codeString))
          return new Enumeration<BundleType>(this, BundleType.DOCUMENT, code);
        if ("message".equals(codeString))
          return new Enumeration<BundleType>(this, BundleType.MESSAGE, code);
        if ("transaction".equals(codeString))
          return new Enumeration<BundleType>(this, BundleType.TRANSACTION, code);
        if ("transaction-response".equals(codeString))
          return new Enumeration<BundleType>(this, BundleType.TRANSACTIONRESPONSE, code);
        if ("batch".equals(codeString))
          return new Enumeration<BundleType>(this, BundleType.BATCH, code);
        if ("batch-response".equals(codeString))
          return new Enumeration<BundleType>(this, BundleType.BATCHRESPONSE, code);
        if ("history".equals(codeString))
          return new Enumeration<BundleType>(this, BundleType.HISTORY, code);
        if ("searchset".equals(codeString))
          return new Enumeration<BundleType>(this, BundleType.SEARCHSET, code);
        if ("collection".equals(codeString))
          return new Enumeration<BundleType>(this, BundleType.COLLECTION, code);
        if ("subscription-notification".equals(codeString))
          return new Enumeration<BundleType>(this, BundleType.SUBSCRIPTIONNOTIFICATION, code);
        throw new FHIRException("Unknown BundleType code '"+codeString+"'");
        }
    public String toCode(BundleType code) {
      if (code == BundleType.DOCUMENT)
        return "document";
      if (code == BundleType.MESSAGE)
        return "message";
      if (code == BundleType.TRANSACTION)
        return "transaction";
      if (code == BundleType.TRANSACTIONRESPONSE)
        return "transaction-response";
      if (code == BundleType.BATCH)
        return "batch";
      if (code == BundleType.BATCHRESPONSE)
        return "batch-response";
      if (code == BundleType.HISTORY)
        return "history";
      if (code == BundleType.SEARCHSET)
        return "searchset";
      if (code == BundleType.COLLECTION)
        return "collection";
      if (code == BundleType.SUBSCRIPTIONNOTIFICATION)
        return "subscription-notification";
      return "?";
      }
    public String toSystem(BundleType code) {
      return code.getSystem();
      }
    }

    public enum HTTPVerb {
        /**
         * HTTP GET Command.
         */
        GET, 
        /**
         * HTTP HEAD Command.
         */
        HEAD, 
        /**
         * HTTP POST Command.
         */
        POST, 
        /**
         * HTTP PUT Command.
         */
        PUT, 
        /**
         * HTTP DELETE Command.
         */
        DELETE, 
        /**
         * HTTP PATCH Command.
         */
        PATCH, 
        /**
         * added to help the parsers with the generic types
         */
        NULL;
        public static HTTPVerb fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("GET".equals(codeString))
          return GET;
        if ("HEAD".equals(codeString))
          return HEAD;
        if ("POST".equals(codeString))
          return POST;
        if ("PUT".equals(codeString))
          return PUT;
        if ("DELETE".equals(codeString))
          return DELETE;
        if ("PATCH".equals(codeString))
          return PATCH;
        if (Configuration.isAcceptInvalidEnums())
          return null;
        else
          throw new FHIRException("Unknown HTTPVerb code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case GET: return "GET";
            case HEAD: return "HEAD";
            case POST: return "POST";
            case PUT: return "PUT";
            case DELETE: return "DELETE";
            case PATCH: return "PATCH";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getSystem() {
          switch (this) {
            case GET: return "http://hl7.org/fhir/http-verb";
            case HEAD: return "http://hl7.org/fhir/http-verb";
            case POST: return "http://hl7.org/fhir/http-verb";
            case PUT: return "http://hl7.org/fhir/http-verb";
            case DELETE: return "http://hl7.org/fhir/http-verb";
            case PATCH: return "http://hl7.org/fhir/http-verb";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getDefinition() {
          switch (this) {
            case GET: return "HTTP GET Command.";
            case HEAD: return "HTTP HEAD Command.";
            case POST: return "HTTP POST Command.";
            case PUT: return "HTTP PUT Command.";
            case DELETE: return "HTTP DELETE Command.";
            case PATCH: return "HTTP PATCH Command.";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case GET: return "GET";
            case HEAD: return "HEAD";
            case POST: return "POST";
            case PUT: return "PUT";
            case DELETE: return "DELETE";
            case PATCH: return "PATCH";
            case NULL: return null;
            default: return "?";
          }
        }
    }

  public static class HTTPVerbEnumFactory implements EnumFactory<HTTPVerb> {
    public HTTPVerb fromCode(String codeString) throws IllegalArgumentException {
      if (codeString == null || "".equals(codeString))
            if (codeString == null || "".equals(codeString))
                return null;
        if ("GET".equals(codeString))
          return HTTPVerb.GET;
        if ("HEAD".equals(codeString))
          return HTTPVerb.HEAD;
        if ("POST".equals(codeString))
          return HTTPVerb.POST;
        if ("PUT".equals(codeString))
          return HTTPVerb.PUT;
        if ("DELETE".equals(codeString))
          return HTTPVerb.DELETE;
        if ("PATCH".equals(codeString))
          return HTTPVerb.PATCH;
        throw new IllegalArgumentException("Unknown HTTPVerb code '"+codeString+"'");
        }
        public Enumeration<HTTPVerb> fromType(PrimitiveType<?> code) throws FHIRException {
          if (code == null)
            return null;
          if (code.isEmpty())
            return new Enumeration<HTTPVerb>(this, HTTPVerb.NULL, code);
          String codeString = ((PrimitiveType) code).asStringValue();
          if (codeString == null || "".equals(codeString))
            return new Enumeration<HTTPVerb>(this, HTTPVerb.NULL, code);
        if ("GET".equals(codeString))
          return new Enumeration<HTTPVerb>(this, HTTPVerb.GET, code);
        if ("HEAD".equals(codeString))
          return new Enumeration<HTTPVerb>(this, HTTPVerb.HEAD, code);
        if ("POST".equals(codeString))
          return new Enumeration<HTTPVerb>(this, HTTPVerb.POST, code);
        if ("PUT".equals(codeString))
          return new Enumeration<HTTPVerb>(this, HTTPVerb.PUT, code);
        if ("DELETE".equals(codeString))
          return new Enumeration<HTTPVerb>(this, HTTPVerb.DELETE, code);
        if ("PATCH".equals(codeString))
          return new Enumeration<HTTPVerb>(this, HTTPVerb.PATCH, code);
        throw new FHIRException("Unknown HTTPVerb code '"+codeString+"'");
        }
    public String toCode(HTTPVerb code) {
      if (code == HTTPVerb.GET)
        return "GET";
      if (code == HTTPVerb.HEAD)
        return "HEAD";
      if (code == HTTPVerb.POST)
        return "POST";
      if (code == HTTPVerb.PUT)
        return "PUT";
      if (code == HTTPVerb.DELETE)
        return "DELETE";
      if (code == HTTPVerb.PATCH)
        return "PATCH";
      return "?";
      }
    public String toSystem(HTTPVerb code) {
      return code.getSystem();
      }
    }

    public enum LinkRelationTypes {
        /**
         * Refers to a resource that is the subject of the link's context.
         */
        ABOUT, 
        /**
         * Asserts that the link target provides an access control description for the link context.
         */
        ACL, 
        /**
         * Refers to a substitute for this context
         */
        ALTERNATE, 
        /**
         * Used to reference alternative content that uses the AMP profile of the HTML format.
         */
        AMPHTML, 
        /**
         * Refers to an appendix.
         */
        APPENDIX, 
        /**
         * Refers to an icon for the context. Synonym for icon.
         */
        APPLETOUCHICON, 
        /**
         * Refers to a launch screen for the context.
         */
        APPLETOUCHSTARTUPIMAGE, 
        /**
         * Refers to a collection of records, documents, or other\n      materials of historical interest.
         */
        ARCHIVES, 
        /**
         * Refers to the context's author.
         */
        AUTHOR, 
        /**
         * Identifies the entity that blocks access to a resource\n      following receipt of a legal demand.
         */
        BLOCKEDBY, 
        /**
         * Gives a permanent link to use for bookmarking purposes.
         */
        BOOKMARK, 
        /**
         * Designates the preferred version of a resource (the IRI and its contents).
         */
        CANONICAL, 
        /**
         * Refers to a chapter in a collection of resources.
         */
        CHAPTER, 
        /**
         * Indicates that the link target is preferred over the link context for the purpose of permanent citation.
         */
        CITEAS, 
        /**
         * The target IRI points to a resource which represents the collection resource for the context IRI.
         */
        COLLECTION, 
        /**
         * Refers to a table of contents.
         */
        CONTENTS, 
        /**
         * The document linked to was later converted to the\n      document that contains this link relation.  For example, an RFC can\n      have a link to the Internet-Draft that became the RFC; in that case,\n      the link relation would be \"convertedFrom\".
         */
        CONVERTEDFROM, 
        /**
         * Refers to a copyright statement that applies to the\n    link's context.
         */
        COPYRIGHT, 
        /**
         * The target IRI points to a resource where a submission form can be obtained.
         */
        CREATEFORM, 
        /**
         * Refers to a resource containing the most recent\n      item(s) in a collection of resources.
         */
        CURRENT, 
        /**
         * Refers to a resource providing information about the\n      link's context.
         */
        DESCRIBEDBY, 
        /**
         * The relationship A 'describes' B asserts that\n      resource A provides a description of resource B. There are no\n      constraints on the format or representation of either A or B,\n      neither are there any further constraints on either resource.
         */
        DESCRIBES, 
        /**
         * Refers to a list of patent disclosures made with respect to \n      material for which 'disclosure' relation is specified.
         */
        DISCLOSURE, 
        /**
         * Used to indicate an origin that will be used to fetch required \n      resources for the link context, and that the user agent ought to resolve \n      as early as possible.
         */
        DNSPREFETCH, 
        /**
         * Refers to a resource whose available representations\n      are byte-for-byte identical with the corresponding representations of\n      the context IRI.
         */
        DUPLICATE, 
        /**
         * Refers to a resource that can be used to edit the\n      link's context.
         */
        EDIT, 
        /**
         * The target IRI points to a resource where a submission form for\n      editing associated resource can be obtained.
         */
        EDITFORM, 
        /**
         * Refers to a resource that can be used to edit media\n      associated with the link's context.
         */
        EDITMEDIA, 
        /**
         * Identifies a related resource that is potentially\n      large and might require special handling.
         */
        ENCLOSURE, 
        /**
         * Refers to a resource that is not part of the same site as the current context.
         */
        EXTERNAL, 
        /**
         * An IRI that refers to the furthest preceding resource\n    in a series of resources.
         */
        FIRST, 
        /**
         * Refers to a glossary of terms.
         */
        GLOSSARY, 
        /**
         * Refers to context-sensitive help.
         */
        HELP, 
        /**
         * Refers to a resource hosted by the server indicated by\n      the link context.
         */
        HOSTS, 
        /**
         * Refers to a hub that enables registration for\n    notification of updates to the context.
         */
        HUB, 
        /**
         * Refers to an icon representing the link's context.
         */
        ICON, 
        /**
         * Refers to an index.
         */
        INDEX, 
        /**
         * refers to a resource associated with a time interval that ends before the beginning of the time interval associated with the context resource
         */
        INTERVALAFTER, 
        /**
         * refers to a resource associated with a time interval that begins after the end of the time interval associated with the context resource
         */
        INTERVALBEFORE, 
        /**
         * refers to a resource associated with a time interval that begins after the beginning of the time interval associated with the context resource, and ends before the end of the time interval associated with the context resource
         */
        INTERVALCONTAINS, 
        /**
         * refers to a resource associated with a time interval that begins after the end of the time interval associated with the context resource, or ends before the beginning of the time interval associated with the context resource
         */
        INTERVALDISJOINT, 
        /**
         * refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource
         */
        INTERVALDURING, 
        /**
         * refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource
         */
        INTERVALEQUALS, 
        /**
         * refers to a resource associated with a time interval that begins after the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource
         */
        INTERVALFINISHEDBY, 
        /**
         * refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource
         */
        INTERVALFINISHES, 
        /**
         * refers to a resource associated with a time interval that begins before or is coincident with the beginning of the time interval associated with the context resource, and ends after or is coincident with the end of the time interval associated with the context resource
         */
        INTERVALIN, 
        /**
         * refers to a resource associated with a time interval whose beginning coincides with the end of the time interval associated with the context resource
         */
        INTERVALMEETS, 
        /**
         * refers to a resource associated with a time interval whose end coincides with the beginning of the time interval associated with the context resource
         */
        INTERVALMETBY, 
        /**
         * refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and ends after the beginning of the time interval associated with the context resource
         */
        INTERVALOVERLAPPEDBY, 
        /**
         * refers to a resource associated with a time interval that begins before the end of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource
         */
        INTERVALOVERLAPS, 
        /**
         * refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and ends before the end of the time interval associated with the context resource
         */
        INTERVALSTARTEDBY, 
        /**
         * refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource
         */
        INTERVALSTARTS, 
        /**
         * The target IRI points to a resource that is a member of the collection represented by the context IRI.
         */
        ITEM, 
        /**
         * An IRI that refers to the furthest following resource\n      in a series of resources.
         */
        LAST, 
        /**
         * Points to a resource containing the latest (e.g.,\n      current) version of the context.
         */
        LATESTVERSION, 
        /**
         * Refers to a license associated with this context.
         */
        LICENSE, 
        /**
         * The link target of a link with the \"linkset\" relation\n      type provides a set of links, including links in which the link\n      context of the link participates.\n    
         */
        LINKSET, 
        /**
         * Refers to further information about the link's context,\n      expressed as a LRDD (\"Link-based Resource Descriptor Document\")\n      resource.  See  for information about\n      processing this relation type in host-meta documents. When used\n      elsewhere, it refers to additional links and other metadata.\n      Multiple instances indicate additional LRDD resources. LRDD\n      resources MUST have an \"application/xrd+xml\" representation, and\n      MAY have others.
         */
        LRDD, 
        /**
         * Links to a manifest file for the context.
         */
        MANIFEST, 
        /**
         * Refers to a mask that can be applied to the icon for the context.
         */
        MASKICON, 
        /**
         * Refers to a feed of personalised media recommendations relevant to the link context.
         */
        MEDIAFEED, 
        /**
         * The Target IRI points to a Memento, a fixed resource that will not change state anymore.
         */
        MEMENTO, 
        /**
         * Links to the context's Micropub endpoint.
         */
        MICROPUB, 
        /**
         * Refers to a module that the user agent is to preemptively fetch and store for use in the current context.
         */
        MODULEPRELOAD, 
        /**
         * Refers to a resource that can be used to monitor changes in an HTTP resource.\n    
         */
        MONITOR, 
        /**
         * Refers to a resource that can be used to monitor changes in a specified group of HTTP resources.\n    
         */
        MONITORGROUP, 
        /**
         * Indicates that the link's context is a part of a series, and\n      that the next in the series is the link target.\n    
         */
        NEXT, 
        /**
         * Refers to the immediately following archive resource.
         */
        NEXTARCHIVE, 
        /**
         * Indicates that the context’s original author or publisher does not endorse the link target.
         */
        NOFOLLOW, 
        /**
         * Indicates that any newly created top-level browsing context which results from following the link will not be an auxiliary browsing context.
         */
        NOOPENER, 
        /**
         * Indicates that no referrer information is to be leaked when following the link.
         */
        NOREFERRER, 
        /**
         * Indicates that any newly created top-level browsing context which results from following the link will be an auxiliary browsing context.
         */
        OPENER, 
        /**
         * Refers to an OpenID Authentication server on which the context relies for an assertion that the end user controls an Identifier.
         */
        OPENID2_LOCALID, 
        /**
         * Refers to a resource which accepts OpenID Authentication protocol messages for the context.
         */
        OPENID2_PROVIDER, 
        /**
         * The Target IRI points to an Original Resource.
         */
        ORIGINAL, 
        /**
         * Refers to a P3P privacy policy for the context.
         */
        P3PV1, 
        /**
         * Indicates a resource where payment is accepted.
         */
        PAYMENT, 
        /**
         * Gives the address of the pingback resource for the link context.
         */
        PINGBACK, 
        /**
         * Used to indicate an origin that will be used to fetch required \n      resources for the link context. Initiating an early connection, which \n      includes the DNS lookup, TCP handshake, and optional TLS negotiation, \n      allows the user agent to mask the high latency costs of establishing a \n      connection.
         */
        PRECONNECT, 
        /**
         * Points to a resource containing the predecessor\n      version in the version history.\n    
         */
        PREDECESSORVERSION, 
        /**
         * The prefetch link relation type is used to identify a resource \n      that might be required by the next navigation from the link context, and \n      that the user agent ought to fetch, such that the user agent can deliver a \n      faster response once the resource is requested in the future.
         */
        PREFETCH, 
        /**
         * Refers to a resource that should be loaded early in the \n      processing of the link's context, without blocking rendering.
         */
        PRELOAD, 
        /**
         * Used to identify a resource that might be required by the next \n      navigation from the link context, and that the user agent ought to fetch \n      and execute, such that the user agent can deliver a faster response once \n      the resource is requested in the future.
         */
        PRERENDER, 
        /**
         * Indicates that the link's context is a part of a series, and\n      that the previous in the series is the link target.\n    
         */
        PREV, 
        /**
         * Refers to a resource that provides a preview of the link's context.
         */
        PREVIEW, 
        /**
         * Refers to the previous resource in an ordered series\n      of resources.  Synonym for \"prev\".
         */
        PREVIOUS, 
        /**
         * Refers to the immediately preceding archive resource.
         */
        PREVARCHIVE, 
        /**
         * Refers to a privacy policy associated with the link's context.
         */
        PRIVACYPOLICY, 
        /**
         * Identifying that a resource representation conforms\nto a certain profile, without affecting the non-profile semantics\nof the resource representation.
         */
        PROFILE, 
        /**
         * Links to a publication manifest. A manifest represents \n      structured information about a publication, such as informative metadata, \n      a list of resources, and a default reading order.
         */
        PUBLICATION, 
        /**
         * Identifies a related resource.
         */
        RELATED, 
        /**
         * Identifies the root of RESTCONF API as configured on this HTTP server.\n      The \"restconf\" relation defines the root of the API defined in RFC8040.\n      Subsequent revisions of RESTCONF will use alternate relation values to support \n      protocol versioning.
         */
        RESTCONF, 
        /**
         * Identifies a resource that is a reply to the context\n      of the link.\n    
         */
        REPLIES, 
        /**
         * The resource identified by the link target provides an input value to an \n    instance of a rule, where the resource which represents the rule instance is \n    identified by the link context.\n    
         */
        RULEINPUT, 
        /**
         * Refers to a resource that can be used to search through\n      the link's context and related resources.
         */
        SEARCH, 
        /**
         * Refers to a section in a collection of resources.
         */
        SECTION, 
        /**
         * Conveys an identifier for the link's context.\n    
         */
        SELF, 
        /**
         * Indicates a URI that can be used to retrieve a\n      service document.
         */
        SERVICE, 
        /**
         * Identifies service description for the context that\n      is primarily intended for consumption by machines.
         */
        SERVICEDESC, 
        /**
         * Identifies service documentation for the context that\n      is primarily intended for human consumption.
         */
        SERVICEDOC, 
        /**
         * Identifies general metadata for the context that is\n      primarily intended for consumption by machines.
         */
        SERVICEMETA, 
        /**
         * Refers to a resource that is within a context that is \n		sponsored (such as advertising or another compensation agreement).
         */
        SPONSORED, 
        /**
         * Refers to the first resource in a collection of\n      resources.
         */
        START, 
        /**
         * Identifies a resource that represents the context's\n      status.
         */
        STATUS, 
        /**
         * Refers to a stylesheet.
         */
        STYLESHEET, 
        /**
         * Refers to a resource serving as a subsection in a\n      collection of resources.
         */
        SUBSECTION, 
        /**
         * Points to a resource containing the successor version\n      in the version history.\n    
         */
        SUCCESSORVERSION, 
        /**
         * Identifies a resource that provides information about\n      the context's retirement policy.\n    
         */
        SUNSET, 
        /**
         * Gives a tag (identified by the given address) that applies to\n      the current document.\n    
         */
        TAG, 
        /**
         * Refers to the terms of service associated with the link's context.
         */
        TERMSOFSERVICE, 
        /**
         * The Target IRI points to a TimeGate for an Original Resource.
         */
        TIMEGATE, 
        /**
         * The Target IRI points to a TimeMap for an Original Resource.
         */
        TIMEMAP, 
        /**
         * Refers to a resource identifying the abstract semantic type of which the link's context is considered to be an instance.
         */
        TYPE, 
        /**
         * Refers to a resource that is within a context that is User Generated Content.\n    
         */
        UGC, 
        /**
         * Refers to a parent document in a hierarchy of\n      documents.\n    
         */
        UP, 
        /**
         * Points to a resource containing the version history\n      for the context.\n    
         */
        VERSIONHISTORY, 
        /**
         * Identifies a resource that is the source of the\n      information in the link's context.\n    
         */
        VIA, 
        /**
         * Identifies a target URI that supports the Webmention protocol.\n    This allows clients that mention a resource in some form of publishing process\n    to contact that endpoint and inform it that this resource has been mentioned.
         */
        WEBMENTION, 
        /**
         * Points to a working copy for this resource.
         */
        WORKINGCOPY, 
        /**
         * Points to the versioned resource from which this\n      working copy was obtained.\n    
         */
        WORKINGCOPYOF, 
        /**
         * added to help the parsers with the generic types
         */
        NULL;
        public static LinkRelationTypes fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("about".equals(codeString))
          return ABOUT;
        if ("acl".equals(codeString))
          return ACL;
        if ("alternate".equals(codeString))
          return ALTERNATE;
        if ("amphtml".equals(codeString))
          return AMPHTML;
        if ("appendix".equals(codeString))
          return APPENDIX;
        if ("apple-touch-icon".equals(codeString))
          return APPLETOUCHICON;
        if ("apple-touch-startup-image".equals(codeString))
          return APPLETOUCHSTARTUPIMAGE;
        if ("archives".equals(codeString))
          return ARCHIVES;
        if ("author".equals(codeString))
          return AUTHOR;
        if ("blocked-by".equals(codeString))
          return BLOCKEDBY;
        if ("bookmark".equals(codeString))
          return BOOKMARK;
        if ("canonical".equals(codeString))
          return CANONICAL;
        if ("chapter".equals(codeString))
          return CHAPTER;
        if ("cite-as".equals(codeString))
          return CITEAS;
        if ("collection".equals(codeString))
          return COLLECTION;
        if ("contents".equals(codeString))
          return CONTENTS;
        if ("convertedFrom".equals(codeString))
          return CONVERTEDFROM;
        if ("copyright".equals(codeString))
          return COPYRIGHT;
        if ("create-form".equals(codeString))
          return CREATEFORM;
        if ("current".equals(codeString))
          return CURRENT;
        if ("describedby".equals(codeString))
          return DESCRIBEDBY;
        if ("describes".equals(codeString))
          return DESCRIBES;
        if ("disclosure".equals(codeString))
          return DISCLOSURE;
        if ("dns-prefetch".equals(codeString))
          return DNSPREFETCH;
        if ("duplicate".equals(codeString))
          return DUPLICATE;
        if ("edit".equals(codeString))
          return EDIT;
        if ("edit-form".equals(codeString))
          return EDITFORM;
        if ("edit-media".equals(codeString))
          return EDITMEDIA;
        if ("enclosure".equals(codeString))
          return ENCLOSURE;
        if ("external".equals(codeString))
          return EXTERNAL;
        if ("first".equals(codeString))
          return FIRST;
        if ("glossary".equals(codeString))
          return GLOSSARY;
        if ("help".equals(codeString))
          return HELP;
        if ("hosts".equals(codeString))
          return HOSTS;
        if ("hub".equals(codeString))
          return HUB;
        if ("icon".equals(codeString))
          return ICON;
        if ("index".equals(codeString))
          return INDEX;
        if ("intervalAfter".equals(codeString))
          return INTERVALAFTER;
        if ("intervalBefore".equals(codeString))
          return INTERVALBEFORE;
        if ("intervalContains".equals(codeString))
          return INTERVALCONTAINS;
        if ("intervalDisjoint".equals(codeString))
          return INTERVALDISJOINT;
        if ("intervalDuring".equals(codeString))
          return INTERVALDURING;
        if ("intervalEquals".equals(codeString))
          return INTERVALEQUALS;
        if ("intervalFinishedBy".equals(codeString))
          return INTERVALFINISHEDBY;
        if ("intervalFinishes".equals(codeString))
          return INTERVALFINISHES;
        if ("intervalIn".equals(codeString))
          return INTERVALIN;
        if ("intervalMeets".equals(codeString))
          return INTERVALMEETS;
        if ("intervalMetBy".equals(codeString))
          return INTERVALMETBY;
        if ("intervalOverlappedBy".equals(codeString))
          return INTERVALOVERLAPPEDBY;
        if ("intervalOverlaps".equals(codeString))
          return INTERVALOVERLAPS;
        if ("intervalStartedBy".equals(codeString))
          return INTERVALSTARTEDBY;
        if ("intervalStarts".equals(codeString))
          return INTERVALSTARTS;
        if ("item".equals(codeString))
          return ITEM;
        if ("last".equals(codeString))
          return LAST;
        if ("latest-version".equals(codeString))
          return LATESTVERSION;
        if ("license".equals(codeString))
          return LICENSE;
        if ("linkset".equals(codeString))
          return LINKSET;
        if ("lrdd".equals(codeString))
          return LRDD;
        if ("manifest".equals(codeString))
          return MANIFEST;
        if ("mask-icon".equals(codeString))
          return MASKICON;
        if ("media-feed".equals(codeString))
          return MEDIAFEED;
        if ("memento".equals(codeString))
          return MEMENTO;
        if ("micropub".equals(codeString))
          return MICROPUB;
        if ("modulepreload".equals(codeString))
          return MODULEPRELOAD;
        if ("monitor".equals(codeString))
          return MONITOR;
        if ("monitor-group".equals(codeString))
          return MONITORGROUP;
        if ("next".equals(codeString))
          return NEXT;
        if ("next-archive".equals(codeString))
          return NEXTARCHIVE;
        if ("nofollow".equals(codeString))
          return NOFOLLOW;
        if ("noopener".equals(codeString))
          return NOOPENER;
        if ("noreferrer".equals(codeString))
          return NOREFERRER;
        if ("opener".equals(codeString))
          return OPENER;
        if ("openid2.local_id".equals(codeString))
          return OPENID2_LOCALID;
        if ("openid2.provider".equals(codeString))
          return OPENID2_PROVIDER;
        if ("original".equals(codeString))
          return ORIGINAL;
        if ("P3Pv1".equals(codeString))
          return P3PV1;
        if ("payment".equals(codeString))
          return PAYMENT;
        if ("pingback".equals(codeString))
          return PINGBACK;
        if ("preconnect".equals(codeString))
          return PRECONNECT;
        if ("predecessor-version".equals(codeString))
          return PREDECESSORVERSION;
        if ("prefetch".equals(codeString))
          return PREFETCH;
        if ("preload".equals(codeString))
          return PRELOAD;
        if ("prerender".equals(codeString))
          return PRERENDER;
        if ("prev".equals(codeString))
          return PREV;
        if ("preview".equals(codeString))
          return PREVIEW;
        if ("previous".equals(codeString))
          return PREVIOUS;
        if ("prev-archive".equals(codeString))
          return PREVARCHIVE;
        if ("privacy-policy".equals(codeString))
          return PRIVACYPOLICY;
        if ("profile".equals(codeString))
          return PROFILE;
        if ("publication".equals(codeString))
          return PUBLICATION;
        if ("related".equals(codeString))
          return RELATED;
        if ("restconf".equals(codeString))
          return RESTCONF;
        if ("replies".equals(codeString))
          return REPLIES;
        if ("ruleinput".equals(codeString))
          return RULEINPUT;
        if ("search".equals(codeString))
          return SEARCH;
        if ("section".equals(codeString))
          return SECTION;
        if ("self".equals(codeString))
          return SELF;
        if ("service".equals(codeString))
          return SERVICE;
        if ("service-desc".equals(codeString))
          return SERVICEDESC;
        if ("service-doc".equals(codeString))
          return SERVICEDOC;
        if ("service-meta".equals(codeString))
          return SERVICEMETA;
        if ("sponsored".equals(codeString))
          return SPONSORED;
        if ("start".equals(codeString))
          return START;
        if ("status".equals(codeString))
          return STATUS;
        if ("stylesheet".equals(codeString))
          return STYLESHEET;
        if ("subsection".equals(codeString))
          return SUBSECTION;
        if ("successor-version".equals(codeString))
          return SUCCESSORVERSION;
        if ("sunset".equals(codeString))
          return SUNSET;
        if ("tag".equals(codeString))
          return TAG;
        if ("terms-of-service".equals(codeString))
          return TERMSOFSERVICE;
        if ("timegate".equals(codeString))
          return TIMEGATE;
        if ("timemap".equals(codeString))
          return TIMEMAP;
        if ("type".equals(codeString))
          return TYPE;
        if ("ugc".equals(codeString))
          return UGC;
        if ("up".equals(codeString))
          return UP;
        if ("version-history".equals(codeString))
          return VERSIONHISTORY;
        if ("via".equals(codeString))
          return VIA;
        if ("webmention".equals(codeString))
          return WEBMENTION;
        if ("working-copy".equals(codeString))
          return WORKINGCOPY;
        if ("working-copy-of".equals(codeString))
          return WORKINGCOPYOF;
        if (Configuration.isAcceptInvalidEnums())
          return null;
        else
          throw new FHIRException("Unknown LinkRelationTypes code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case ABOUT: return "about";
            case ACL: return "acl";
            case ALTERNATE: return "alternate";
            case AMPHTML: return "amphtml";
            case APPENDIX: return "appendix";
            case APPLETOUCHICON: return "apple-touch-icon";
            case APPLETOUCHSTARTUPIMAGE: return "apple-touch-startup-image";
            case ARCHIVES: return "archives";
            case AUTHOR: return "author";
            case BLOCKEDBY: return "blocked-by";
            case BOOKMARK: return "bookmark";
            case CANONICAL: return "canonical";
            case CHAPTER: return "chapter";
            case CITEAS: return "cite-as";
            case COLLECTION: return "collection";
            case CONTENTS: return "contents";
            case CONVERTEDFROM: return "convertedFrom";
            case COPYRIGHT: return "copyright";
            case CREATEFORM: return "create-form";
            case CURRENT: return "current";
            case DESCRIBEDBY: return "describedby";
            case DESCRIBES: return "describes";
            case DISCLOSURE: return "disclosure";
            case DNSPREFETCH: return "dns-prefetch";
            case DUPLICATE: return "duplicate";
            case EDIT: return "edit";
            case EDITFORM: return "edit-form";
            case EDITMEDIA: return "edit-media";
            case ENCLOSURE: return "enclosure";
            case EXTERNAL: return "external";
            case FIRST: return "first";
            case GLOSSARY: return "glossary";
            case HELP: return "help";
            case HOSTS: return "hosts";
            case HUB: return "hub";
            case ICON: return "icon";
            case INDEX: return "index";
            case INTERVALAFTER: return "intervalAfter";
            case INTERVALBEFORE: return "intervalBefore";
            case INTERVALCONTAINS: return "intervalContains";
            case INTERVALDISJOINT: return "intervalDisjoint";
            case INTERVALDURING: return "intervalDuring";
            case INTERVALEQUALS: return "intervalEquals";
            case INTERVALFINISHEDBY: return "intervalFinishedBy";
            case INTERVALFINISHES: return "intervalFinishes";
            case INTERVALIN: return "intervalIn";
            case INTERVALMEETS: return "intervalMeets";
            case INTERVALMETBY: return "intervalMetBy";
            case INTERVALOVERLAPPEDBY: return "intervalOverlappedBy";
            case INTERVALOVERLAPS: return "intervalOverlaps";
            case INTERVALSTARTEDBY: return "intervalStartedBy";
            case INTERVALSTARTS: return "intervalStarts";
            case ITEM: return "item";
            case LAST: return "last";
            case LATESTVERSION: return "latest-version";
            case LICENSE: return "license";
            case LINKSET: return "linkset";
            case LRDD: return "lrdd";
            case MANIFEST: return "manifest";
            case MASKICON: return "mask-icon";
            case MEDIAFEED: return "media-feed";
            case MEMENTO: return "memento";
            case MICROPUB: return "micropub";
            case MODULEPRELOAD: return "modulepreload";
            case MONITOR: return "monitor";
            case MONITORGROUP: return "monitor-group";
            case NEXT: return "next";
            case NEXTARCHIVE: return "next-archive";
            case NOFOLLOW: return "nofollow";
            case NOOPENER: return "noopener";
            case NOREFERRER: return "noreferrer";
            case OPENER: return "opener";
            case OPENID2_LOCALID: return "openid2.local_id";
            case OPENID2_PROVIDER: return "openid2.provider";
            case ORIGINAL: return "original";
            case P3PV1: return "P3Pv1";
            case PAYMENT: return "payment";
            case PINGBACK: return "pingback";
            case PRECONNECT: return "preconnect";
            case PREDECESSORVERSION: return "predecessor-version";
            case PREFETCH: return "prefetch";
            case PRELOAD: return "preload";
            case PRERENDER: return "prerender";
            case PREV: return "prev";
            case PREVIEW: return "preview";
            case PREVIOUS: return "previous";
            case PREVARCHIVE: return "prev-archive";
            case PRIVACYPOLICY: return "privacy-policy";
            case PROFILE: return "profile";
            case PUBLICATION: return "publication";
            case RELATED: return "related";
            case RESTCONF: return "restconf";
            case REPLIES: return "replies";
            case RULEINPUT: return "ruleinput";
            case SEARCH: return "search";
            case SECTION: return "section";
            case SELF: return "self";
            case SERVICE: return "service";
            case SERVICEDESC: return "service-desc";
            case SERVICEDOC: return "service-doc";
            case SERVICEMETA: return "service-meta";
            case SPONSORED: return "sponsored";
            case START: return "start";
            case STATUS: return "status";
            case STYLESHEET: return "stylesheet";
            case SUBSECTION: return "subsection";
            case SUCCESSORVERSION: return "successor-version";
            case SUNSET: return "sunset";
            case TAG: return "tag";
            case TERMSOFSERVICE: return "terms-of-service";
            case TIMEGATE: return "timegate";
            case TIMEMAP: return "timemap";
            case TYPE: return "type";
            case UGC: return "ugc";
            case UP: return "up";
            case VERSIONHISTORY: return "version-history";
            case VIA: return "via";
            case WEBMENTION: return "webmention";
            case WORKINGCOPY: return "working-copy";
            case WORKINGCOPYOF: return "working-copy-of";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getSystem() {
          switch (this) {
            case ABOUT: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case ACL: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case ALTERNATE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case AMPHTML: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case APPENDIX: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case APPLETOUCHICON: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case APPLETOUCHSTARTUPIMAGE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case ARCHIVES: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case AUTHOR: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case BLOCKEDBY: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case BOOKMARK: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case CANONICAL: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case CHAPTER: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case CITEAS: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case COLLECTION: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case CONTENTS: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case CONVERTEDFROM: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case COPYRIGHT: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case CREATEFORM: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case CURRENT: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case DESCRIBEDBY: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case DESCRIBES: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case DISCLOSURE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case DNSPREFETCH: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case DUPLICATE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case EDIT: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case EDITFORM: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case EDITMEDIA: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case ENCLOSURE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case EXTERNAL: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case FIRST: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case GLOSSARY: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case HELP: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case HOSTS: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case HUB: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case ICON: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INDEX: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALAFTER: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALBEFORE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALCONTAINS: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALDISJOINT: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALDURING: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALEQUALS: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALFINISHEDBY: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALFINISHES: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALIN: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALMEETS: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALMETBY: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALOVERLAPPEDBY: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALOVERLAPS: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALSTARTEDBY: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case INTERVALSTARTS: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case ITEM: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case LAST: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case LATESTVERSION: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case LICENSE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case LINKSET: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case LRDD: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case MANIFEST: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case MASKICON: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case MEDIAFEED: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case MEMENTO: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case MICROPUB: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case MODULEPRELOAD: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case MONITOR: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case MONITORGROUP: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case NEXT: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case NEXTARCHIVE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case NOFOLLOW: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case NOOPENER: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case NOREFERRER: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case OPENER: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case OPENID2_LOCALID: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case OPENID2_PROVIDER: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case ORIGINAL: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case P3PV1: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PAYMENT: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PINGBACK: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PRECONNECT: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PREDECESSORVERSION: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PREFETCH: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PRELOAD: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PRERENDER: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PREV: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PREVIEW: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PREVIOUS: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PREVARCHIVE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PRIVACYPOLICY: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PROFILE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case PUBLICATION: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case RELATED: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case RESTCONF: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case REPLIES: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case RULEINPUT: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case SEARCH: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case SECTION: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case SELF: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case SERVICE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case SERVICEDESC: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case SERVICEDOC: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case SERVICEMETA: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case SPONSORED: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case START: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case STATUS: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case STYLESHEET: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case SUBSECTION: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case SUCCESSORVERSION: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case SUNSET: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case TAG: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case TERMSOFSERVICE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case TIMEGATE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case TIMEMAP: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case TYPE: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case UGC: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case UP: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case VERSIONHISTORY: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case VIA: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case WEBMENTION: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case WORKINGCOPY: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case WORKINGCOPYOF: return "http://hl7.org/fhir/CodeSystem/iana-link-relations";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getDefinition() {
          switch (this) {
            case ABOUT: return "Refers to a resource that is the subject of the link's context.";
            case ACL: return "Asserts that the link target provides an access control description for the link context.";
            case ALTERNATE: return "Refers to a substitute for this context";
            case AMPHTML: return "Used to reference alternative content that uses the AMP profile of the HTML format.";
            case APPENDIX: return "Refers to an appendix.";
            case APPLETOUCHICON: return "Refers to an icon for the context. Synonym for icon.";
            case APPLETOUCHSTARTUPIMAGE: return "Refers to a launch screen for the context.";
            case ARCHIVES: return "Refers to a collection of records, documents, or other\n      materials of historical interest.";
            case AUTHOR: return "Refers to the context's author.";
            case BLOCKEDBY: return "Identifies the entity that blocks access to a resource\n      following receipt of a legal demand.";
            case BOOKMARK: return "Gives a permanent link to use for bookmarking purposes.";
            case CANONICAL: return "Designates the preferred version of a resource (the IRI and its contents).";
            case CHAPTER: return "Refers to a chapter in a collection of resources.";
            case CITEAS: return "Indicates that the link target is preferred over the link context for the purpose of permanent citation.";
            case COLLECTION: return "The target IRI points to a resource which represents the collection resource for the context IRI.";
            case CONTENTS: return "Refers to a table of contents.";
            case CONVERTEDFROM: return "The document linked to was later converted to the\n      document that contains this link relation.  For example, an RFC can\n      have a link to the Internet-Draft that became the RFC; in that case,\n      the link relation would be \"convertedFrom\".";
            case COPYRIGHT: return "Refers to a copyright statement that applies to the\n    link's context.";
            case CREATEFORM: return "The target IRI points to a resource where a submission form can be obtained.";
            case CURRENT: return "Refers to a resource containing the most recent\n      item(s) in a collection of resources.";
            case DESCRIBEDBY: return "Refers to a resource providing information about the\n      link's context.";
            case DESCRIBES: return "The relationship A 'describes' B asserts that\n      resource A provides a description of resource B. There are no\n      constraints on the format or representation of either A or B,\n      neither are there any further constraints on either resource.";
            case DISCLOSURE: return "Refers to a list of patent disclosures made with respect to \n      material for which 'disclosure' relation is specified.";
            case DNSPREFETCH: return "Used to indicate an origin that will be used to fetch required \n      resources for the link context, and that the user agent ought to resolve \n      as early as possible.";
            case DUPLICATE: return "Refers to a resource whose available representations\n      are byte-for-byte identical with the corresponding representations of\n      the context IRI.";
            case EDIT: return "Refers to a resource that can be used to edit the\n      link's context.";
            case EDITFORM: return "The target IRI points to a resource where a submission form for\n      editing associated resource can be obtained.";
            case EDITMEDIA: return "Refers to a resource that can be used to edit media\n      associated with the link's context.";
            case ENCLOSURE: return "Identifies a related resource that is potentially\n      large and might require special handling.";
            case EXTERNAL: return "Refers to a resource that is not part of the same site as the current context.";
            case FIRST: return "An IRI that refers to the furthest preceding resource\n    in a series of resources.";
            case GLOSSARY: return "Refers to a glossary of terms.";
            case HELP: return "Refers to context-sensitive help.";
            case HOSTS: return "Refers to a resource hosted by the server indicated by\n      the link context.";
            case HUB: return "Refers to a hub that enables registration for\n    notification of updates to the context.";
            case ICON: return "Refers to an icon representing the link's context.";
            case INDEX: return "Refers to an index.";
            case INTERVALAFTER: return "refers to a resource associated with a time interval that ends before the beginning of the time interval associated with the context resource";
            case INTERVALBEFORE: return "refers to a resource associated with a time interval that begins after the end of the time interval associated with the context resource";
            case INTERVALCONTAINS: return "refers to a resource associated with a time interval that begins after the beginning of the time interval associated with the context resource, and ends before the end of the time interval associated with the context resource";
            case INTERVALDISJOINT: return "refers to a resource associated with a time interval that begins after the end of the time interval associated with the context resource, or ends before the beginning of the time interval associated with the context resource";
            case INTERVALDURING: return "refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource";
            case INTERVALEQUALS: return "refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource";
            case INTERVALFINISHEDBY: return "refers to a resource associated with a time interval that begins after the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource";
            case INTERVALFINISHES: return "refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource";
            case INTERVALIN: return "refers to a resource associated with a time interval that begins before or is coincident with the beginning of the time interval associated with the context resource, and ends after or is coincident with the end of the time interval associated with the context resource";
            case INTERVALMEETS: return "refers to a resource associated with a time interval whose beginning coincides with the end of the time interval associated with the context resource";
            case INTERVALMETBY: return "refers to a resource associated with a time interval whose end coincides with the beginning of the time interval associated with the context resource";
            case INTERVALOVERLAPPEDBY: return "refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and ends after the beginning of the time interval associated with the context resource";
            case INTERVALOVERLAPS: return "refers to a resource associated with a time interval that begins before the end of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource";
            case INTERVALSTARTEDBY: return "refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and ends before the end of the time interval associated with the context resource";
            case INTERVALSTARTS: return "refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource";
            case ITEM: return "The target IRI points to a resource that is a member of the collection represented by the context IRI.";
            case LAST: return "An IRI that refers to the furthest following resource\n      in a series of resources.";
            case LATESTVERSION: return "Points to a resource containing the latest (e.g.,\n      current) version of the context.";
            case LICENSE: return "Refers to a license associated with this context.";
            case LINKSET: return "The link target of a link with the \"linkset\" relation\n      type provides a set of links, including links in which the link\n      context of the link participates.\n    ";
            case LRDD: return "Refers to further information about the link's context,\n      expressed as a LRDD (\"Link-based Resource Descriptor Document\")\n      resource.  See  for information about\n      processing this relation type in host-meta documents. When used\n      elsewhere, it refers to additional links and other metadata.\n      Multiple instances indicate additional LRDD resources. LRDD\n      resources MUST have an \"application/xrd+xml\" representation, and\n      MAY have others.";
            case MANIFEST: return "Links to a manifest file for the context.";
            case MASKICON: return "Refers to a mask that can be applied to the icon for the context.";
            case MEDIAFEED: return "Refers to a feed of personalised media recommendations relevant to the link context.";
            case MEMENTO: return "The Target IRI points to a Memento, a fixed resource that will not change state anymore.";
            case MICROPUB: return "Links to the context's Micropub endpoint.";
            case MODULEPRELOAD: return "Refers to a module that the user agent is to preemptively fetch and store for use in the current context.";
            case MONITOR: return "Refers to a resource that can be used to monitor changes in an HTTP resource.\n    ";
            case MONITORGROUP: return "Refers to a resource that can be used to monitor changes in a specified group of HTTP resources.\n    ";
            case NEXT: return "Indicates that the link's context is a part of a series, and\n      that the next in the series is the link target.\n    ";
            case NEXTARCHIVE: return "Refers to the immediately following archive resource.";
            case NOFOLLOW: return "Indicates that the context’s original author or publisher does not endorse the link target.";
            case NOOPENER: return "Indicates that any newly created top-level browsing context which results from following the link will not be an auxiliary browsing context.";
            case NOREFERRER: return "Indicates that no referrer information is to be leaked when following the link.";
            case OPENER: return "Indicates that any newly created top-level browsing context which results from following the link will be an auxiliary browsing context.";
            case OPENID2_LOCALID: return "Refers to an OpenID Authentication server on which the context relies for an assertion that the end user controls an Identifier.";
            case OPENID2_PROVIDER: return "Refers to a resource which accepts OpenID Authentication protocol messages for the context.";
            case ORIGINAL: return "The Target IRI points to an Original Resource.";
            case P3PV1: return "Refers to a P3P privacy policy for the context.";
            case PAYMENT: return "Indicates a resource where payment is accepted.";
            case PINGBACK: return "Gives the address of the pingback resource for the link context.";
            case PRECONNECT: return "Used to indicate an origin that will be used to fetch required \n      resources for the link context. Initiating an early connection, which \n      includes the DNS lookup, TCP handshake, and optional TLS negotiation, \n      allows the user agent to mask the high latency costs of establishing a \n      connection.";
            case PREDECESSORVERSION: return "Points to a resource containing the predecessor\n      version in the version history.\n    ";
            case PREFETCH: return "The prefetch link relation type is used to identify a resource \n      that might be required by the next navigation from the link context, and \n      that the user agent ought to fetch, such that the user agent can deliver a \n      faster response once the resource is requested in the future.";
            case PRELOAD: return "Refers to a resource that should be loaded early in the \n      processing of the link's context, without blocking rendering.";
            case PRERENDER: return "Used to identify a resource that might be required by the next \n      navigation from the link context, and that the user agent ought to fetch \n      and execute, such that the user agent can deliver a faster response once \n      the resource is requested in the future.";
            case PREV: return "Indicates that the link's context is a part of a series, and\n      that the previous in the series is the link target.\n    ";
            case PREVIEW: return "Refers to a resource that provides a preview of the link's context.";
            case PREVIOUS: return "Refers to the previous resource in an ordered series\n      of resources.  Synonym for \"prev\".";
            case PREVARCHIVE: return "Refers to the immediately preceding archive resource.";
            case PRIVACYPOLICY: return "Refers to a privacy policy associated with the link's context.";
            case PROFILE: return "Identifying that a resource representation conforms\nto a certain profile, without affecting the non-profile semantics\nof the resource representation.";
            case PUBLICATION: return "Links to a publication manifest. A manifest represents \n      structured information about a publication, such as informative metadata, \n      a list of resources, and a default reading order.";
            case RELATED: return "Identifies a related resource.";
            case RESTCONF: return "Identifies the root of RESTCONF API as configured on this HTTP server.\n      The \"restconf\" relation defines the root of the API defined in RFC8040.\n      Subsequent revisions of RESTCONF will use alternate relation values to support \n      protocol versioning.";
            case REPLIES: return "Identifies a resource that is a reply to the context\n      of the link.\n    ";
            case RULEINPUT: return "The resource identified by the link target provides an input value to an \n    instance of a rule, where the resource which represents the rule instance is \n    identified by the link context.\n    ";
            case SEARCH: return "Refers to a resource that can be used to search through\n      the link's context and related resources.";
            case SECTION: return "Refers to a section in a collection of resources.";
            case SELF: return "Conveys an identifier for the link's context.\n    ";
            case SERVICE: return "Indicates a URI that can be used to retrieve a\n      service document.";
            case SERVICEDESC: return "Identifies service description for the context that\n      is primarily intended for consumption by machines.";
            case SERVICEDOC: return "Identifies service documentation for the context that\n      is primarily intended for human consumption.";
            case SERVICEMETA: return "Identifies general metadata for the context that is\n      primarily intended for consumption by machines.";
            case SPONSORED: return "Refers to a resource that is within a context that is \n		sponsored (such as advertising or another compensation agreement).";
            case START: return "Refers to the first resource in a collection of\n      resources.";
            case STATUS: return "Identifies a resource that represents the context's\n      status.";
            case STYLESHEET: return "Refers to a stylesheet.";
            case SUBSECTION: return "Refers to a resource serving as a subsection in a\n      collection of resources.";
            case SUCCESSORVERSION: return "Points to a resource containing the successor version\n      in the version history.\n    ";
            case SUNSET: return "Identifies a resource that provides information about\n      the context's retirement policy.\n    ";
            case TAG: return "Gives a tag (identified by the given address) that applies to\n      the current document.\n    ";
            case TERMSOFSERVICE: return "Refers to the terms of service associated with the link's context.";
            case TIMEGATE: return "The Target IRI points to a TimeGate for an Original Resource.";
            case TIMEMAP: return "The Target IRI points to a TimeMap for an Original Resource.";
            case TYPE: return "Refers to a resource identifying the abstract semantic type of which the link's context is considered to be an instance.";
            case UGC: return "Refers to a resource that is within a context that is User Generated Content.\n    ";
            case UP: return "Refers to a parent document in a hierarchy of\n      documents.\n    ";
            case VERSIONHISTORY: return "Points to a resource containing the version history\n      for the context.\n    ";
            case VIA: return "Identifies a resource that is the source of the\n      information in the link's context.\n    ";
            case WEBMENTION: return "Identifies a target URI that supports the Webmention protocol.\n    This allows clients that mention a resource in some form of publishing process\n    to contact that endpoint and inform it that this resource has been mentioned.";
            case WORKINGCOPY: return "Points to a working copy for this resource.";
            case WORKINGCOPYOF: return "Points to the versioned resource from which this\n      working copy was obtained.\n    ";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case ABOUT: return "Refers to a resource that is the subject of the link's context.";
            case ACL: return "Asserts that the link target provides an access control description for the link context.";
            case ALTERNATE: return "Refers to a substitute for this context";
            case AMPHTML: return "Used to reference alternative content that uses the AMP profile of the HTML format.";
            case APPENDIX: return "Refers to an appendix.";
            case APPLETOUCHICON: return "Refers to an icon for the context. Synonym for icon.";
            case APPLETOUCHSTARTUPIMAGE: return "Refers to a launch screen for the context.";
            case ARCHIVES: return "Refers to a collection of records, documents, or other\n      materials of historical interest.";
            case AUTHOR: return "Refers to the context's author.";
            case BLOCKEDBY: return "Identifies the entity that blocks access to a resource\n      following receipt of a legal demand.";
            case BOOKMARK: return "Gives a permanent link to use for bookmarking purposes.";
            case CANONICAL: return "Designates the preferred version of a resource (the IRI and its contents).";
            case CHAPTER: return "Refers to a chapter in a collection of resources.";
            case CITEAS: return "Indicates that the link target is preferred over the link context for the purpose of permanent citation.";
            case COLLECTION: return "The target IRI points to a resource which represents the collection resource for the context IRI.";
            case CONTENTS: return "Refers to a table of contents.";
            case CONVERTEDFROM: return "The document linked to was later converted to the\n      document that contains this link relation.  For example, an RFC can\n      have a link to the Internet-Draft that became the RFC; in that case,\n      the link relation would be \"convertedFrom\".";
            case COPYRIGHT: return "Refers to a copyright statement that applies to the\n    link's context.";
            case CREATEFORM: return "The target IRI points to a resource where a submission form can be obtained.";
            case CURRENT: return "Refers to a resource containing the most recent\n      item(s) in a collection of resources.";
            case DESCRIBEDBY: return "Refers to a resource providing information about the\n      link's context.";
            case DESCRIBES: return "The relationship A 'describes' B asserts that\n      resource A provides a description of resource B. There are no\n      constraints on the format or representation of either A or B,\n      neither are there any further constraints on either resource.";
            case DISCLOSURE: return "Refers to a list of patent disclosures made with respect to \n      material for which 'disclosure' relation is specified.";
            case DNSPREFETCH: return "Used to indicate an origin that will be used to fetch required \n      resources for the link context, and that the user agent ought to resolve \n      as early as possible.";
            case DUPLICATE: return "Refers to a resource whose available representations\n      are byte-for-byte identical with the corresponding representations of\n      the context IRI.";
            case EDIT: return "Refers to a resource that can be used to edit the\n      link's context.";
            case EDITFORM: return "The target IRI points to a resource where a submission form for\n      editing associated resource can be obtained.";
            case EDITMEDIA: return "Refers to a resource that can be used to edit media\n      associated with the link's context.";
            case ENCLOSURE: return "Identifies a related resource that is potentially\n      large and might require special handling.";
            case EXTERNAL: return "Refers to a resource that is not part of the same site as the current context.";
            case FIRST: return "An IRI that refers to the furthest preceding resource\n    in a series of resources.";
            case GLOSSARY: return "Refers to a glossary of terms.";
            case HELP: return "Refers to context-sensitive help.";
            case HOSTS: return "Refers to a resource hosted by the server indicated by\n      the link context.";
            case HUB: return "Refers to a hub that enables registration for\n    notification of updates to the context.";
            case ICON: return "Refers to an icon representing the link's context.";
            case INDEX: return "Refers to an index.";
            case INTERVALAFTER: return "refers to a resource associated with a time interval that ends before the beginning of the time interval associated with the context resource";
            case INTERVALBEFORE: return "refers to a resource associated with a time interval that begins after the end of the time interval associated with the context resource";
            case INTERVALCONTAINS: return "refers to a resource associated with a time interval that begins after the beginning of the time interval associated with the context resource, and ends before the end of the time interval associated with the context resource";
            case INTERVALDISJOINT: return "refers to a resource associated with a time interval that begins after the end of the time interval associated with the context resource, or ends before the beginning of the time interval associated with the context resource";
            case INTERVALDURING: return "refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource";
            case INTERVALEQUALS: return "refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource";
            case INTERVALFINISHEDBY: return "refers to a resource associated with a time interval that begins after the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource";
            case INTERVALFINISHES: return "refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and whose end coincides with the end of the time interval associated with the context resource";
            case INTERVALIN: return "refers to a resource associated with a time interval that begins before or is coincident with the beginning of the time interval associated with the context resource, and ends after or is coincident with the end of the time interval associated with the context resource";
            case INTERVALMEETS: return "refers to a resource associated with a time interval whose beginning coincides with the end of the time interval associated with the context resource";
            case INTERVALMETBY: return "refers to a resource associated with a time interval whose end coincides with the beginning of the time interval associated with the context resource";
            case INTERVALOVERLAPPEDBY: return "refers to a resource associated with a time interval that begins before the beginning of the time interval associated with the context resource, and ends after the beginning of the time interval associated with the context resource";
            case INTERVALOVERLAPS: return "refers to a resource associated with a time interval that begins before the end of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource";
            case INTERVALSTARTEDBY: return "refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and ends before the end of the time interval associated with the context resource";
            case INTERVALSTARTS: return "refers to a resource associated with a time interval whose beginning coincides with the beginning of the time interval associated with the context resource, and ends after the end of the time interval associated with the context resource";
            case ITEM: return "The target IRI points to a resource that is a member of the collection represented by the context IRI.";
            case LAST: return "An IRI that refers to the furthest following resource\n      in a series of resources.";
            case LATESTVERSION: return "Points to a resource containing the latest (e.g.,\n      current) version of the context.";
            case LICENSE: return "Refers to a license associated with this context.";
            case LINKSET: return "The link target of a link with the \"linkset\" relation\n      type provides a set of links, including links in which the link\n      context of the link participates.\n    ";
            case LRDD: return "Refers to further information about the link's context,\n      expressed as a LRDD (\"Link-based Resource Descriptor Document\")\n      resource.  See  for information about\n      processing this relation type in host-meta documents. When used\n      elsewhere, it refers to additional links and other metadata.\n      Multiple instances indicate additional LRDD resources. LRDD\n      resources MUST have an \"application/xrd+xml\" representation, and\n      MAY have others.";
            case MANIFEST: return "Links to a manifest file for the context.";
            case MASKICON: return "Refers to a mask that can be applied to the icon for the context.";
            case MEDIAFEED: return "Refers to a feed of personalised media recommendations relevant to the link context.";
            case MEMENTO: return "The Target IRI points to a Memento, a fixed resource that will not change state anymore.";
            case MICROPUB: return "Links to the context's Micropub endpoint.";
            case MODULEPRELOAD: return "Refers to a module that the user agent is to preemptively fetch and store for use in the current context.";
            case MONITOR: return "Refers to a resource that can be used to monitor changes in an HTTP resource.\n    ";
            case MONITORGROUP: return "Refers to a resource that can be used to monitor changes in a specified group of HTTP resources.\n    ";
            case NEXT: return "Indicates that the link's context is a part of a series, and\n      that the next in the series is the link target.\n    ";
            case NEXTARCHIVE: return "Refers to the immediately following archive resource.";
            case NOFOLLOW: return "Indicates that the context’s original author or publisher does not endorse the link target.";
            case NOOPENER: return "Indicates that any newly created top-level browsing context which results from following the link will not be an auxiliary browsing context.";
            case NOREFERRER: return "Indicates that no referrer information is to be leaked when following the link.";
            case OPENER: return "Indicates that any newly created top-level browsing context which results from following the link will be an auxiliary browsing context.";
            case OPENID2_LOCALID: return "Refers to an OpenID Authentication server on which the context relies for an assertion that the end user controls an Identifier.";
            case OPENID2_PROVIDER: return "Refers to a resource which accepts OpenID Authentication protocol messages for the context.";
            case ORIGINAL: return "The Target IRI points to an Original Resource.";
            case P3PV1: return "Refers to a P3P privacy policy for the context.";
            case PAYMENT: return "Indicates a resource where payment is accepted.";
            case PINGBACK: return "Gives the address of the pingback resource for the link context.";
            case PRECONNECT: return "Used to indicate an origin that will be used to fetch required \n      resources for the link context. Initiating an early connection, which \n      includes the DNS lookup, TCP handshake, and optional TLS negotiation, \n      allows the user agent to mask the high latency costs of establishing a \n      connection.";
            case PREDECESSORVERSION: return "Points to a resource containing the predecessor\n      version in the version history.\n    ";
            case PREFETCH: return "The prefetch link relation type is used to identify a resource \n      that might be required by the next navigation from the link context, and \n      that the user agent ought to fetch, such that the user agent can deliver a \n      faster response once the resource is requested in the future.";
            case PRELOAD: return "Refers to a resource that should be loaded early in the \n      processing of the link's context, without blocking rendering.";
            case PRERENDER: return "Used to identify a resource that might be required by the next \n      navigation from the link context, and that the user agent ought to fetch \n      and execute, such that the user agent can deliver a faster response once \n      the resource is requested in the future.";
            case PREV: return "Indicates that the link's context is a part of a series, and\n      that the previous in the series is the link target.\n    ";
            case PREVIEW: return "Refers to a resource that provides a preview of the link's context.";
            case PREVIOUS: return "Refers to the previous resource in an ordered series\n      of resources.  Synonym for \"prev\".";
            case PREVARCHIVE: return "Refers to the immediately preceding archive resource.";
            case PRIVACYPOLICY: return "Refers to a privacy policy associated with the link's context.";
            case PROFILE: return "Identifying that a resource representation conforms\nto a certain profile, without affecting the non-profile semantics\nof the resource representation.";
            case PUBLICATION: return "Links to a publication manifest. A manifest represents \n      structured information about a publication, such as informative metadata, \n      a list of resources, and a default reading order.";
            case RELATED: return "Identifies a related resource.";
            case RESTCONF: return "Identifies the root of RESTCONF API as configured on this HTTP server.\n      The \"restconf\" relation defines the root of the API defined in RFC8040.\n      Subsequent revisions of RESTCONF will use alternate relation values to support \n      protocol versioning.";
            case REPLIES: return "Identifies a resource that is a reply to the context\n      of the link.\n    ";
            case RULEINPUT: return "The resource identified by the link target provides an input value to an \n    instance of a rule, where the resource which represents the rule instance is \n    identified by the link context.\n    ";
            case SEARCH: return "Refers to a resource that can be used to search through\n      the link's context and related resources.";
            case SECTION: return "Refers to a section in a collection of resources.";
            case SELF: return "Conveys an identifier for the link's context.\n    ";
            case SERVICE: return "Indicates a URI that can be used to retrieve a\n      service document.";
            case SERVICEDESC: return "Identifies service description for the context that\n      is primarily intended for consumption by machines.";
            case SERVICEDOC: return "Identifies service documentation for the context that\n      is primarily intended for human consumption.";
            case SERVICEMETA: return "Identifies general metadata for the context that is\n      primarily intended for consumption by machines.";
            case SPONSORED: return "Refers to a resource that is within a context that is \n		sponsored (such as advertising or another compensation agreement).";
            case START: return "Refers to the first resource in a collection of\n      resources.";
            case STATUS: return "Identifies a resource that represents the context's\n      status.";
            case STYLESHEET: return "Refers to a stylesheet.";
            case SUBSECTION: return "Refers to a resource serving as a subsection in a\n      collection of resources.";
            case SUCCESSORVERSION: return "Points to a resource containing the successor version\n      in the version history.\n    ";
            case SUNSET: return "Identifies a resource that provides information about\n      the context's retirement policy.\n    ";
            case TAG: return "Gives a tag (identified by the given address) that applies to\n      the current document.\n    ";
            case TERMSOFSERVICE: return "Refers to the terms of service associated with the link's context.";
            case TIMEGATE: return "The Target IRI points to a TimeGate for an Original Resource.";
            case TIMEMAP: return "The Target IRI points to a TimeMap for an Original Resource.";
            case TYPE: return "Refers to a resource identifying the abstract semantic type of which the link's context is considered to be an instance.";
            case UGC: return "Refers to a resource that is within a context that is User Generated Content.\n    ";
            case UP: return "Refers to a parent document in a hierarchy of\n      documents.\n    ";
            case VERSIONHISTORY: return "Points to a resource containing the version history\n      for the context.\n    ";
            case VIA: return "Identifies a resource that is the source of the\n      information in the link's context.\n    ";
            case WEBMENTION: return "Identifies a target URI that supports the Webmention protocol.\n    This allows clients that mention a resource in some form of publishing process\n    to contact that endpoint and inform it that this resource has been mentioned.";
            case WORKINGCOPY: return "Points to a working copy for this resource.";
            case WORKINGCOPYOF: return "Points to the versioned resource from which this\n      working copy was obtained.\n    ";
            case NULL: return null;
            default: return "?";
          }
        }
    }

  public static class LinkRelationTypesEnumFactory implements EnumFactory<LinkRelationTypes> {
    public LinkRelationTypes fromCode(String codeString) throws IllegalArgumentException {
      if (codeString == null || "".equals(codeString))
            if (codeString == null || "".equals(codeString))
                return null;
        if ("about".equals(codeString))
          return LinkRelationTypes.ABOUT;
        if ("acl".equals(codeString))
          return LinkRelationTypes.ACL;
        if ("alternate".equals(codeString))
          return LinkRelationTypes.ALTERNATE;
        if ("amphtml".equals(codeString))
          return LinkRelationTypes.AMPHTML;
        if ("appendix".equals(codeString))
          return LinkRelationTypes.APPENDIX;
        if ("apple-touch-icon".equals(codeString))
          return LinkRelationTypes.APPLETOUCHICON;
        if ("apple-touch-startup-image".equals(codeString))
          return LinkRelationTypes.APPLETOUCHSTARTUPIMAGE;
        if ("archives".equals(codeString))
          return LinkRelationTypes.ARCHIVES;
        if ("author".equals(codeString))
          return LinkRelationTypes.AUTHOR;
        if ("blocked-by".equals(codeString))
          return LinkRelationTypes.BLOCKEDBY;
        if ("bookmark".equals(codeString))
          return LinkRelationTypes.BOOKMARK;
        if ("canonical".equals(codeString))
          return LinkRelationTypes.CANONICAL;
        if ("chapter".equals(codeString))
          return LinkRelationTypes.CHAPTER;
        if ("cite-as".equals(codeString))
          return LinkRelationTypes.CITEAS;
        if ("collection".equals(codeString))
          return LinkRelationTypes.COLLECTION;
        if ("contents".equals(codeString))
          return LinkRelationTypes.CONTENTS;
        if ("convertedFrom".equals(codeString))
          return LinkRelationTypes.CONVERTEDFROM;
        if ("copyright".equals(codeString))
          return LinkRelationTypes.COPYRIGHT;
        if ("create-form".equals(codeString))
          return LinkRelationTypes.CREATEFORM;
        if ("current".equals(codeString))
          return LinkRelationTypes.CURRENT;
        if ("describedby".equals(codeString))
          return LinkRelationTypes.DESCRIBEDBY;
        if ("describes".equals(codeString))
          return LinkRelationTypes.DESCRIBES;
        if ("disclosure".equals(codeString))
          return LinkRelationTypes.DISCLOSURE;
        if ("dns-prefetch".equals(codeString))
          return LinkRelationTypes.DNSPREFETCH;
        if ("duplicate".equals(codeString))
          return LinkRelationTypes.DUPLICATE;
        if ("edit".equals(codeString))
          return LinkRelationTypes.EDIT;
        if ("edit-form".equals(codeString))
          return LinkRelationTypes.EDITFORM;
        if ("edit-media".equals(codeString))
          return LinkRelationTypes.EDITMEDIA;
        if ("enclosure".equals(codeString))
          return LinkRelationTypes.ENCLOSURE;
        if ("external".equals(codeString))
          return LinkRelationTypes.EXTERNAL;
        if ("first".equals(codeString))
          return LinkRelationTypes.FIRST;
        if ("glossary".equals(codeString))
          return LinkRelationTypes.GLOSSARY;
        if ("help".equals(codeString))
          return LinkRelationTypes.HELP;
        if ("hosts".equals(codeString))
          return LinkRelationTypes.HOSTS;
        if ("hub".equals(codeString))
          return LinkRelationTypes.HUB;
        if ("icon".equals(codeString))
          return LinkRelationTypes.ICON;
        if ("index".equals(codeString))
          return LinkRelationTypes.INDEX;
        if ("intervalAfter".equals(codeString))
          return LinkRelationTypes.INTERVALAFTER;
        if ("intervalBefore".equals(codeString))
          return LinkRelationTypes.INTERVALBEFORE;
        if ("intervalContains".equals(codeString))
          return LinkRelationTypes.INTERVALCONTAINS;
        if ("intervalDisjoint".equals(codeString))
          return LinkRelationTypes.INTERVALDISJOINT;
        if ("intervalDuring".equals(codeString))
          return LinkRelationTypes.INTERVALDURING;
        if ("intervalEquals".equals(codeString))
          return LinkRelationTypes.INTERVALEQUALS;
        if ("intervalFinishedBy".equals(codeString))
          return LinkRelationTypes.INTERVALFINISHEDBY;
        if ("intervalFinishes".equals(codeString))
          return LinkRelationTypes.INTERVALFINISHES;
        if ("intervalIn".equals(codeString))
          return LinkRelationTypes.INTERVALIN;
        if ("intervalMeets".equals(codeString))
          return LinkRelationTypes.INTERVALMEETS;
        if ("intervalMetBy".equals(codeString))
          return LinkRelationTypes.INTERVALMETBY;
        if ("intervalOverlappedBy".equals(codeString))
          return LinkRelationTypes.INTERVALOVERLAPPEDBY;
        if ("intervalOverlaps".equals(codeString))
          return LinkRelationTypes.INTERVALOVERLAPS;
        if ("intervalStartedBy".equals(codeString))
          return LinkRelationTypes.INTERVALSTARTEDBY;
        if ("intervalStarts".equals(codeString))
          return LinkRelationTypes.INTERVALSTARTS;
        if ("item".equals(codeString))
          return LinkRelationTypes.ITEM;
        if ("last".equals(codeString))
          return LinkRelationTypes.LAST;
        if ("latest-version".equals(codeString))
          return LinkRelationTypes.LATESTVERSION;
        if ("license".equals(codeString))
          return LinkRelationTypes.LICENSE;
        if ("linkset".equals(codeString))
          return LinkRelationTypes.LINKSET;
        if ("lrdd".equals(codeString))
          return LinkRelationTypes.LRDD;
        if ("manifest".equals(codeString))
          return LinkRelationTypes.MANIFEST;
        if ("mask-icon".equals(codeString))
          return LinkRelationTypes.MASKICON;
        if ("media-feed".equals(codeString))
          return LinkRelationTypes.MEDIAFEED;
        if ("memento".equals(codeString))
          return LinkRelationTypes.MEMENTO;
        if ("micropub".equals(codeString))
          return LinkRelationTypes.MICROPUB;
        if ("modulepreload".equals(codeString))
          return LinkRelationTypes.MODULEPRELOAD;
        if ("monitor".equals(codeString))
          return LinkRelationTypes.MONITOR;
        if ("monitor-group".equals(codeString))
          return LinkRelationTypes.MONITORGROUP;
        if ("next".equals(codeString))
          return LinkRelationTypes.NEXT;
        if ("next-archive".equals(codeString))
          return LinkRelationTypes.NEXTARCHIVE;
        if ("nofollow".equals(codeString))
          return LinkRelationTypes.NOFOLLOW;
        if ("noopener".equals(codeString))
          return LinkRelationTypes.NOOPENER;
        if ("noreferrer".equals(codeString))
          return LinkRelationTypes.NOREFERRER;
        if ("opener".equals(codeString))
          return LinkRelationTypes.OPENER;
        if ("openid2.local_id".equals(codeString))
          return LinkRelationTypes.OPENID2_LOCALID;
        if ("openid2.provider".equals(codeString))
          return LinkRelationTypes.OPENID2_PROVIDER;
        if ("original".equals(codeString))
          return LinkRelationTypes.ORIGINAL;
        if ("P3Pv1".equals(codeString))
          return LinkRelationTypes.P3PV1;
        if ("payment".equals(codeString))
          return LinkRelationTypes.PAYMENT;
        if ("pingback".equals(codeString))
          return LinkRelationTypes.PINGBACK;
        if ("preconnect".equals(codeString))
          return LinkRelationTypes.PRECONNECT;
        if ("predecessor-version".equals(codeString))
          return LinkRelationTypes.PREDECESSORVERSION;
        if ("prefetch".equals(codeString))
          return LinkRelationTypes.PREFETCH;
        if ("preload".equals(codeString))
          return LinkRelationTypes.PRELOAD;
        if ("prerender".equals(codeString))
          return LinkRelationTypes.PRERENDER;
        if ("prev".equals(codeString))
          return LinkRelationTypes.PREV;
        if ("preview".equals(codeString))
          return LinkRelationTypes.PREVIEW;
        if ("previous".equals(codeString))
          return LinkRelationTypes.PREVIOUS;
        if ("prev-archive".equals(codeString))
          return LinkRelationTypes.PREVARCHIVE;
        if ("privacy-policy".equals(codeString))
          return LinkRelationTypes.PRIVACYPOLICY;
        if ("profile".equals(codeString))
          return LinkRelationTypes.PROFILE;
        if ("publication".equals(codeString))
          return LinkRelationTypes.PUBLICATION;
        if ("related".equals(codeString))
          return LinkRelationTypes.RELATED;
        if ("restconf".equals(codeString))
          return LinkRelationTypes.RESTCONF;
        if ("replies".equals(codeString))
          return LinkRelationTypes.REPLIES;
        if ("ruleinput".equals(codeString))
          return LinkRelationTypes.RULEINPUT;
        if ("search".equals(codeString))
          return LinkRelationTypes.SEARCH;
        if ("section".equals(codeString))
          return LinkRelationTypes.SECTION;
        if ("self".equals(codeString))
          return LinkRelationTypes.SELF;
        if ("service".equals(codeString))
          return LinkRelationTypes.SERVICE;
        if ("service-desc".equals(codeString))
          return LinkRelationTypes.SERVICEDESC;
        if ("service-doc".equals(codeString))
          return LinkRelationTypes.SERVICEDOC;
        if ("service-meta".equals(codeString))
          return LinkRelationTypes.SERVICEMETA;
        if ("sponsored".equals(codeString))
          return LinkRelationTypes.SPONSORED;
        if ("start".equals(codeString))
          return LinkRelationTypes.START;
        if ("status".equals(codeString))
          return LinkRelationTypes.STATUS;
        if ("stylesheet".equals(codeString))
          return LinkRelationTypes.STYLESHEET;
        if ("subsection".equals(codeString))
          return LinkRelationTypes.SUBSECTION;
        if ("successor-version".equals(codeString))
          return LinkRelationTypes.SUCCESSORVERSION;
        if ("sunset".equals(codeString))
          return LinkRelationTypes.SUNSET;
        if ("tag".equals(codeString))
          return LinkRelationTypes.TAG;
        if ("terms-of-service".equals(codeString))
          return LinkRelationTypes.TERMSOFSERVICE;
        if ("timegate".equals(codeString))
          return LinkRelationTypes.TIMEGATE;
        if ("timemap".equals(codeString))
          return LinkRelationTypes.TIMEMAP;
        if ("type".equals(codeString))
          return LinkRelationTypes.TYPE;
        if ("ugc".equals(codeString))
          return LinkRelationTypes.UGC;
        if ("up".equals(codeString))
          return LinkRelationTypes.UP;
        if ("version-history".equals(codeString))
          return LinkRelationTypes.VERSIONHISTORY;
        if ("via".equals(codeString))
          return LinkRelationTypes.VIA;
        if ("webmention".equals(codeString))
          return LinkRelationTypes.WEBMENTION;
        if ("working-copy".equals(codeString))
          return LinkRelationTypes.WORKINGCOPY;
        if ("working-copy-of".equals(codeString))
          return LinkRelationTypes.WORKINGCOPYOF;
        throw new IllegalArgumentException("Unknown LinkRelationTypes code '"+codeString+"'");
        }
        public Enumeration<LinkRelationTypes> fromType(PrimitiveType<?> code) throws FHIRException {
          if (code == null)
            return null;
          if (code.isEmpty())
            return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.NULL, code);
          String codeString = ((PrimitiveType) code).asStringValue();
          if (codeString == null || "".equals(codeString))
            return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.NULL, code);
        if ("about".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ABOUT, code);
        if ("acl".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ACL, code);
        if ("alternate".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ALTERNATE, code);
        if ("amphtml".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.AMPHTML, code);
        if ("appendix".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.APPENDIX, code);
        if ("apple-touch-icon".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.APPLETOUCHICON, code);
        if ("apple-touch-startup-image".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.APPLETOUCHSTARTUPIMAGE, code);
        if ("archives".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ARCHIVES, code);
        if ("author".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.AUTHOR, code);
        if ("blocked-by".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.BLOCKEDBY, code);
        if ("bookmark".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.BOOKMARK, code);
        if ("canonical".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CANONICAL, code);
        if ("chapter".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CHAPTER, code);
        if ("cite-as".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CITEAS, code);
        if ("collection".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.COLLECTION, code);
        if ("contents".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CONTENTS, code);
        if ("convertedFrom".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CONVERTEDFROM, code);
        if ("copyright".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.COPYRIGHT, code);
        if ("create-form".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CREATEFORM, code);
        if ("current".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.CURRENT, code);
        if ("describedby".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.DESCRIBEDBY, code);
        if ("describes".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.DESCRIBES, code);
        if ("disclosure".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.DISCLOSURE, code);
        if ("dns-prefetch".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.DNSPREFETCH, code);
        if ("duplicate".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.DUPLICATE, code);
        if ("edit".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.EDIT, code);
        if ("edit-form".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.EDITFORM, code);
        if ("edit-media".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.EDITMEDIA, code);
        if ("enclosure".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ENCLOSURE, code);
        if ("external".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.EXTERNAL, code);
        if ("first".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.FIRST, code);
        if ("glossary".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.GLOSSARY, code);
        if ("help".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.HELP, code);
        if ("hosts".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.HOSTS, code);
        if ("hub".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.HUB, code);
        if ("icon".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ICON, code);
        if ("index".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INDEX, code);
        if ("intervalAfter".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALAFTER, code);
        if ("intervalBefore".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALBEFORE, code);
        if ("intervalContains".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALCONTAINS, code);
        if ("intervalDisjoint".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALDISJOINT, code);
        if ("intervalDuring".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALDURING, code);
        if ("intervalEquals".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALEQUALS, code);
        if ("intervalFinishedBy".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALFINISHEDBY, code);
        if ("intervalFinishes".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALFINISHES, code);
        if ("intervalIn".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALIN, code);
        if ("intervalMeets".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALMEETS, code);
        if ("intervalMetBy".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALMETBY, code);
        if ("intervalOverlappedBy".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALOVERLAPPEDBY, code);
        if ("intervalOverlaps".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALOVERLAPS, code);
        if ("intervalStartedBy".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALSTARTEDBY, code);
        if ("intervalStarts".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.INTERVALSTARTS, code);
        if ("item".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ITEM, code);
        if ("last".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.LAST, code);
        if ("latest-version".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.LATESTVERSION, code);
        if ("license".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.LICENSE, code);
        if ("linkset".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.LINKSET, code);
        if ("lrdd".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.LRDD, code);
        if ("manifest".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MANIFEST, code);
        if ("mask-icon".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MASKICON, code);
        if ("media-feed".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MEDIAFEED, code);
        if ("memento".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MEMENTO, code);
        if ("micropub".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MICROPUB, code);
        if ("modulepreload".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MODULEPRELOAD, code);
        if ("monitor".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MONITOR, code);
        if ("monitor-group".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.MONITORGROUP, code);
        if ("next".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.NEXT, code);
        if ("next-archive".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.NEXTARCHIVE, code);
        if ("nofollow".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.NOFOLLOW, code);
        if ("noopener".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.NOOPENER, code);
        if ("noreferrer".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.NOREFERRER, code);
        if ("opener".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.OPENER, code);
        if ("openid2.local_id".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.OPENID2_LOCALID, code);
        if ("openid2.provider".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.OPENID2_PROVIDER, code);
        if ("original".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.ORIGINAL, code);
        if ("P3Pv1".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.P3PV1, code);
        if ("payment".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PAYMENT, code);
        if ("pingback".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PINGBACK, code);
        if ("preconnect".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PRECONNECT, code);
        if ("predecessor-version".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PREDECESSORVERSION, code);
        if ("prefetch".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PREFETCH, code);
        if ("preload".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PRELOAD, code);
        if ("prerender".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PRERENDER, code);
        if ("prev".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PREV, code);
        if ("preview".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PREVIEW, code);
        if ("previous".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PREVIOUS, code);
        if ("prev-archive".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PREVARCHIVE, code);
        if ("privacy-policy".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PRIVACYPOLICY, code);
        if ("profile".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PROFILE, code);
        if ("publication".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.PUBLICATION, code);
        if ("related".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.RELATED, code);
        if ("restconf".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.RESTCONF, code);
        if ("replies".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.REPLIES, code);
        if ("ruleinput".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.RULEINPUT, code);
        if ("search".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SEARCH, code);
        if ("section".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SECTION, code);
        if ("self".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SELF, code);
        if ("service".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SERVICE, code);
        if ("service-desc".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SERVICEDESC, code);
        if ("service-doc".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SERVICEDOC, code);
        if ("service-meta".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SERVICEMETA, code);
        if ("sponsored".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SPONSORED, code);
        if ("start".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.START, code);
        if ("status".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.STATUS, code);
        if ("stylesheet".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.STYLESHEET, code);
        if ("subsection".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SUBSECTION, code);
        if ("successor-version".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SUCCESSORVERSION, code);
        if ("sunset".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.SUNSET, code);
        if ("tag".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.TAG, code);
        if ("terms-of-service".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.TERMSOFSERVICE, code);
        if ("timegate".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.TIMEGATE, code);
        if ("timemap".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.TIMEMAP, code);
        if ("type".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.TYPE, code);
        if ("ugc".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.UGC, code);
        if ("up".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.UP, code);
        if ("version-history".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.VERSIONHISTORY, code);
        if ("via".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.VIA, code);
        if ("webmention".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.WEBMENTION, code);
        if ("working-copy".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.WORKINGCOPY, code);
        if ("working-copy-of".equals(codeString))
          return new Enumeration<LinkRelationTypes>(this, LinkRelationTypes.WORKINGCOPYOF, code);
        throw new FHIRException("Unknown LinkRelationTypes code '"+codeString+"'");
        }
    public String toCode(LinkRelationTypes code) {
      if (code == LinkRelationTypes.ABOUT)
        return "about";
      if (code == LinkRelationTypes.ACL)
        return "acl";
      if (code == LinkRelationTypes.ALTERNATE)
        return "alternate";
      if (code == LinkRelationTypes.AMPHTML)
        return "amphtml";
      if (code == LinkRelationTypes.APPENDIX)
        return "appendix";
      if (code == LinkRelationTypes.APPLETOUCHICON)
        return "apple-touch-icon";
      if (code == LinkRelationTypes.APPLETOUCHSTARTUPIMAGE)
        return "apple-touch-startup-image";
      if (code == LinkRelationTypes.ARCHIVES)
        return "archives";
      if (code == LinkRelationTypes.AUTHOR)
        return "author";
      if (code == LinkRelationTypes.BLOCKEDBY)
        return "blocked-by";
      if (code == LinkRelationTypes.BOOKMARK)
        return "bookmark";
      if (code == LinkRelationTypes.CANONICAL)
        return "canonical";
      if (code == LinkRelationTypes.CHAPTER)
        return "chapter";
      if (code == LinkRelationTypes.CITEAS)
        return "cite-as";
      if (code == LinkRelationTypes.COLLECTION)
        return "collection";
      if (code == LinkRelationTypes.CONTENTS)
        return "contents";
      if (code == LinkRelationTypes.CONVERTEDFROM)
        return "convertedFrom";
      if (code == LinkRelationTypes.COPYRIGHT)
        return "copyright";
      if (code == LinkRelationTypes.CREATEFORM)
        return "create-form";
      if (code == LinkRelationTypes.CURRENT)
        return "current";
      if (code == LinkRelationTypes.DESCRIBEDBY)
        return "describedby";
      if (code == LinkRelationTypes.DESCRIBES)
        return "describes";
      if (code == LinkRelationTypes.DISCLOSURE)
        return "disclosure";
      if (code == LinkRelationTypes.DNSPREFETCH)
        return "dns-prefetch";
      if (code == LinkRelationTypes.DUPLICATE)
        return "duplicate";
      if (code == LinkRelationTypes.EDIT)
        return "edit";
      if (code == LinkRelationTypes.EDITFORM)
        return "edit-form";
      if (code == LinkRelationTypes.EDITMEDIA)
        return "edit-media";
      if (code == LinkRelationTypes.ENCLOSURE)
        return "enclosure";
      if (code == LinkRelationTypes.EXTERNAL)
        return "external";
      if (code == LinkRelationTypes.FIRST)
        return "first";
      if (code == LinkRelationTypes.GLOSSARY)
        return "glossary";
      if (code == LinkRelationTypes.HELP)
        return "help";
      if (code == LinkRelationTypes.HOSTS)
        return "hosts";
      if (code == LinkRelationTypes.HUB)
        return "hub";
      if (code == LinkRelationTypes.ICON)
        return "icon";
      if (code == LinkRelationTypes.INDEX)
        return "index";
      if (code == LinkRelationTypes.INTERVALAFTER)
        return "intervalAfter";
      if (code == LinkRelationTypes.INTERVALBEFORE)
        return "intervalBefore";
      if (code == LinkRelationTypes.INTERVALCONTAINS)
        return "intervalContains";
      if (code == LinkRelationTypes.INTERVALDISJOINT)
        return "intervalDisjoint";
      if (code == LinkRelationTypes.INTERVALDURING)
        return "intervalDuring";
      if (code == LinkRelationTypes.INTERVALEQUALS)
        return "intervalEquals";
      if (code == LinkRelationTypes.INTERVALFINISHEDBY)
        return "intervalFinishedBy";
      if (code == LinkRelationTypes.INTERVALFINISHES)
        return "intervalFinishes";
      if (code == LinkRelationTypes.INTERVALIN)
        return "intervalIn";
      if (code == LinkRelationTypes.INTERVALMEETS)
        return "intervalMeets";
      if (code == LinkRelationTypes.INTERVALMETBY)
        return "intervalMetBy";
      if (code == LinkRelationTypes.INTERVALOVERLAPPEDBY)
        return "intervalOverlappedBy";
      if (code == LinkRelationTypes.INTERVALOVERLAPS)
        return "intervalOverlaps";
      if (code == LinkRelationTypes.INTERVALSTARTEDBY)
        return "intervalStartedBy";
      if (code == LinkRelationTypes.INTERVALSTARTS)
        return "intervalStarts";
      if (code == LinkRelationTypes.ITEM)
        return "item";
      if (code == LinkRelationTypes.LAST)
        return "last";
      if (code == LinkRelationTypes.LATESTVERSION)
        return "latest-version";
      if (code == LinkRelationTypes.LICENSE)
        return "license";
      if (code == LinkRelationTypes.LINKSET)
        return "linkset";
      if (code == LinkRelationTypes.LRDD)
        return "lrdd";
      if (code == LinkRelationTypes.MANIFEST)
        return "manifest";
      if (code == LinkRelationTypes.MASKICON)
        return "mask-icon";
      if (code == LinkRelationTypes.MEDIAFEED)
        return "media-feed";
      if (code == LinkRelationTypes.MEMENTO)
        return "memento";
      if (code == LinkRelationTypes.MICROPUB)
        return "micropub";
      if (code == LinkRelationTypes.MODULEPRELOAD)
        return "modulepreload";
      if (code == LinkRelationTypes.MONITOR)
        return "monitor";
      if (code == LinkRelationTypes.MONITORGROUP)
        return "monitor-group";
      if (code == LinkRelationTypes.NEXT)
        return "next";
      if (code == LinkRelationTypes.NEXTARCHIVE)
        return "next-archive";
      if (code == LinkRelationTypes.NOFOLLOW)
        return "nofollow";
      if (code == LinkRelationTypes.NOOPENER)
        return "noopener";
      if (code == LinkRelationTypes.NOREFERRER)
        return "noreferrer";
      if (code == LinkRelationTypes.OPENER)
        return "opener";
      if (code == LinkRelationTypes.OPENID2_LOCALID)
        return "openid2.local_id";
      if (code == LinkRelationTypes.OPENID2_PROVIDER)
        return "openid2.provider";
      if (code == LinkRelationTypes.ORIGINAL)
        return "original";
      if (code == LinkRelationTypes.P3PV1)
        return "P3Pv1";
      if (code == LinkRelationTypes.PAYMENT)
        return "payment";
      if (code == LinkRelationTypes.PINGBACK)
        return "pingback";
      if (code == LinkRelationTypes.PRECONNECT)
        return "preconnect";
      if (code == LinkRelationTypes.PREDECESSORVERSION)
        return "predecessor-version";
      if (code == LinkRelationTypes.PREFETCH)
        return "prefetch";
      if (code == LinkRelationTypes.PRELOAD)
        return "preload";
      if (code == LinkRelationTypes.PRERENDER)
        return "prerender";
      if (code == LinkRelationTypes.PREV)
        return "prev";
      if (code == LinkRelationTypes.PREVIEW)
        return "preview";
      if (code == LinkRelationTypes.PREVIOUS)
        return "previous";
      if (code == LinkRelationTypes.PREVARCHIVE)
        return "prev-archive";
      if (code == LinkRelationTypes.PRIVACYPOLICY)
        return "privacy-policy";
      if (code == LinkRelationTypes.PROFILE)
        return "profile";
      if (code == LinkRelationTypes.PUBLICATION)
        return "publication";
      if (code == LinkRelationTypes.RELATED)
        return "related";
      if (code == LinkRelationTypes.RESTCONF)
        return "restconf";
      if (code == LinkRelationTypes.REPLIES)
        return "replies";
      if (code == LinkRelationTypes.RULEINPUT)
        return "ruleinput";
      if (code == LinkRelationTypes.SEARCH)
        return "search";
      if (code == LinkRelationTypes.SECTION)
        return "section";
      if (code == LinkRelationTypes.SELF)
        return "self";
      if (code == LinkRelationTypes.SERVICE)
        return "service";
      if (code == LinkRelationTypes.SERVICEDESC)
        return "service-desc";
      if (code == LinkRelationTypes.SERVICEDOC)
        return "service-doc";
      if (code == LinkRelationTypes.SERVICEMETA)
        return "service-meta";
      if (code == LinkRelationTypes.SPONSORED)
        return "sponsored";
      if (code == LinkRelationTypes.START)
        return "start";
      if (code == LinkRelationTypes.STATUS)
        return "status";
      if (code == LinkRelationTypes.STYLESHEET)
        return "stylesheet";
      if (code == LinkRelationTypes.SUBSECTION)
        return "subsection";
      if (code == LinkRelationTypes.SUCCESSORVERSION)
        return "successor-version";
      if (code == LinkRelationTypes.SUNSET)
        return "sunset";
      if (code == LinkRelationTypes.TAG)
        return "tag";
      if (code == LinkRelationTypes.TERMSOFSERVICE)
        return "terms-of-service";
      if (code == LinkRelationTypes.TIMEGATE)
        return "timegate";
      if (code == LinkRelationTypes.TIMEMAP)
        return "timemap";
      if (code == LinkRelationTypes.TYPE)
        return "type";
      if (code == LinkRelationTypes.UGC)
        return "ugc";
      if (code == LinkRelationTypes.UP)
        return "up";
      if (code == LinkRelationTypes.VERSIONHISTORY)
        return "version-history";
      if (code == LinkRelationTypes.VIA)
        return "via";
      if (code == LinkRelationTypes.WEBMENTION)
        return "webmention";
      if (code == LinkRelationTypes.WORKINGCOPY)
        return "working-copy";
      if (code == LinkRelationTypes.WORKINGCOPYOF)
        return "working-copy-of";
      return "?";
      }
    public String toSystem(LinkRelationTypes code) {
      return code.getSystem();
      }
    }

    public enum SearchEntryMode {
        /**
         * This resource matched the search specification.
         */
        MATCH, 
        /**
         * This resource is returned because it is referred to from another resource in the search set.
         */
        INCLUDE, 
        /**
         * An OperationOutcome that provides additional information about the processing of a search.
         */
        OUTCOME, 
        /**
         * added to help the parsers with the generic types
         */
        NULL;
        public static SearchEntryMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString))
                return null;
        if ("match".equals(codeString))
          return MATCH;
        if ("include".equals(codeString))
          return INCLUDE;
        if ("outcome".equals(codeString))
          return OUTCOME;
        if (Configuration.isAcceptInvalidEnums())
          return null;
        else
          throw new FHIRException("Unknown SearchEntryMode code '"+codeString+"'");
        }
        public String toCode() {
          switch (this) {
            case MATCH: return "match";
            case INCLUDE: return "include";
            case OUTCOME: return "outcome";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getSystem() {
          switch (this) {
            case MATCH: return "http://hl7.org/fhir/search-entry-mode";
            case INCLUDE: return "http://hl7.org/fhir/search-entry-mode";
            case OUTCOME: return "http://hl7.org/fhir/search-entry-mode";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getDefinition() {
          switch (this) {
            case MATCH: return "This resource matched the search specification.";
            case INCLUDE: return "This resource is returned because it is referred to from another resource in the search set.";
            case OUTCOME: return "An OperationOutcome that provides additional information about the processing of a search.";
            case NULL: return null;
            default: return "?";
          }
        }
        public String getDisplay() {
          switch (this) {
            case MATCH: return "Match";
            case INCLUDE: return "Include";
            case OUTCOME: return "Outcome";
            case NULL: return null;
            default: return "?";
          }
        }
    }

  public static class SearchEntryModeEnumFactory implements EnumFactory<SearchEntryMode> {
    public SearchEntryMode fromCode(String codeString) throws IllegalArgumentException {
      if (codeString == null || "".equals(codeString))
            if (codeString == null || "".equals(codeString))
                return null;
        if ("match".equals(codeString))
          return SearchEntryMode.MATCH;
        if ("include".equals(codeString))
          return SearchEntryMode.INCLUDE;
        if ("outcome".equals(codeString))
          return SearchEntryMode.OUTCOME;
        throw new IllegalArgumentException("Unknown SearchEntryMode code '"+codeString+"'");
        }
        public Enumeration<SearchEntryMode> fromType(PrimitiveType<?> code) throws FHIRException {
          if (code == null)
            return null;
          if (code.isEmpty())
            return new Enumeration<SearchEntryMode>(this, SearchEntryMode.NULL, code);
          String codeString = ((PrimitiveType) code).asStringValue();
          if (codeString == null || "".equals(codeString))
            return new Enumeration<SearchEntryMode>(this, SearchEntryMode.NULL, code);
        if ("match".equals(codeString))
          return new Enumeration<SearchEntryMode>(this, SearchEntryMode.MATCH, code);
        if ("include".equals(codeString))
          return new Enumeration<SearchEntryMode>(this, SearchEntryMode.INCLUDE, code);
        if ("outcome".equals(codeString))
          return new Enumeration<SearchEntryMode>(this, SearchEntryMode.OUTCOME, code);
        throw new FHIRException("Unknown SearchEntryMode code '"+codeString+"'");
        }
    public String toCode(SearchEntryMode code) {
      if (code == SearchEntryMode.MATCH)
        return "match";
      if (code == SearchEntryMode.INCLUDE)
        return "include";
      if (code == SearchEntryMode.OUTCOME)
        return "outcome";
      return "?";
      }
    public String toSystem(SearchEntryMode code) {
      return code.getSystem();
      }
    }

    @Block()
    public static class BundleLinkComponent extends BackboneElement implements IBaseBackboneElement {
        /**
         * A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).
         */
        @Child(name = "relation", type = {CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="See http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1", formalDefinition="A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1)." )
        @ca.uhn.fhir.model.api.annotation.Binding(valueSet="http://hl7.org/fhir/ValueSet/iana-link-relations")
        protected Enumeration<LinkRelationTypes> relation;

        /**
         * The reference details for the link.
         */
        @Child(name = "url", type = {UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference details for the link", formalDefinition="The reference details for the link." )
        protected UriType url;

        private static final long serialVersionUID = -878418349L;

    /**
     * Constructor
     */
      public BundleLinkComponent() {
        super();
      }

    /**
     * Constructor
     */
      public BundleLinkComponent(LinkRelationTypes relation, String url) {
        super();
        this.setRelation(relation);
        this.setUrl(url);
      }

        /**
         * @return {@link #relation} (A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).). This is the underlying object with id, value and extensions. The accessor "getRelation" gives direct access to the value
         */
        public Enumeration<LinkRelationTypes> getRelationElement() { 
          if (this.relation == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleLinkComponent.relation");
            else if (Configuration.doAutoCreate())
              this.relation = new Enumeration<LinkRelationTypes>(new LinkRelationTypesEnumFactory()); // bb
          return this.relation;
        }

        public boolean hasRelationElement() { 
          return this.relation != null && !this.relation.isEmpty();
        }

        public boolean hasRelation() { 
          return this.relation != null && !this.relation.isEmpty();
        }

        /**
         * @param value {@link #relation} (A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).). This is the underlying object with id, value and extensions. The accessor "getRelation" gives direct access to the value
         */
        public BundleLinkComponent setRelationElement(Enumeration<LinkRelationTypes> value) { 
          this.relation = value;
          return this;
        }

        /**
         * @return A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).
         */
        public LinkRelationTypes getRelation() { 
          return this.relation == null ? null : this.relation.getValue();
        }

        /**
         * @param value A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).
         */
        public BundleLinkComponent setRelation(LinkRelationTypes value) { 
            if (this.relation == null)
              this.relation = new Enumeration<LinkRelationTypes>(new LinkRelationTypesEnumFactory());
            this.relation.setValue(value);
          return this;
        }

        /**
         * @return {@link #url} (The reference details for the link.). This is the underlying object with id, value and extensions. The accessor "getUrl" gives direct access to the value
         */
        public UriType getUrlElement() { 
          if (this.url == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleLinkComponent.url");
            else if (Configuration.doAutoCreate())
              this.url = new UriType(); // bb
          return this.url;
        }

        public boolean hasUrlElement() { 
          return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() { 
          return this.url != null && !this.url.isEmpty();
        }

        /**
         * @param value {@link #url} (The reference details for the link.). This is the underlying object with id, value and extensions. The accessor "getUrl" gives direct access to the value
         */
        public BundleLinkComponent setUrlElement(UriType value) { 
          this.url = value;
          return this;
        }

        /**
         * @return The reference details for the link.
         */
        public String getUrl() { 
          return this.url == null ? null : this.url.getValue();
        }

        /**
         * @param value The reference details for the link.
         */
        public BundleLinkComponent setUrl(String value) { 
            if (this.url == null)
              this.url = new UriType();
            this.url.setValue(value);
          return this;
        }

        protected void listChildren(List<Property> children) {
          super.listChildren(children);
          children.add(new Property("relation", "code", "A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).", 0, 1, relation));
          children.add(new Property("url", "uri", "The reference details for the link.", 0, 1, url));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
          switch (_hash) {
          case -554436100: /*relation*/  return new Property("relation", "code", "A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).", 0, 1, relation);
          case 116079: /*url*/  return new Property("url", "uri", "The reference details for the link.", 0, 1, url);
          default: return super.getNamedProperty(_hash, _name, _checkValid);
          }

        }

      @Override
      public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
        case -554436100: /*relation*/ return this.relation == null ? new Base[0] : new Base[] {this.relation}; // Enumeration<LinkRelationTypes>
        case 116079: /*url*/ return this.url == null ? new Base[0] : new Base[] {this.url}; // UriType
        default: return super.getProperty(hash, name, checkValid);
        }

      }

      @Override
      public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
        case -554436100: // relation
          value = new LinkRelationTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
          this.relation = (Enumeration) value; // Enumeration<LinkRelationTypes>
          return value;
        case 116079: // url
          this.url = TypeConvertor.castToUri(value); // UriType
          return value;
        default: return super.setProperty(hash, name, value);
        }

      }

      @Override
      public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("relation")) {
          value = new LinkRelationTypesEnumFactory().fromType(TypeConvertor.castToCode(value));
          this.relation = (Enumeration) value; // Enumeration<LinkRelationTypes>
        } else if (name.equals("url")) {
          this.url = TypeConvertor.castToUri(value); // UriType
        } else
          return super.setProperty(name, value);
        return value;
      }

      @Override
      public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
        case -554436100:  return getRelationElement();
        case 116079:  return getUrlElement();
        default: return super.makeProperty(hash, name);
        }

      }

      @Override
      public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
        case -554436100: /*relation*/ return new String[] {"code"};
        case 116079: /*url*/ return new String[] {"uri"};
        default: return super.getTypesForProperty(hash, name);
        }

      }

      @Override
      public Base addChild(String name) throws FHIRException {
        if (name.equals("relation")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.link.relation");
        }
        else if (name.equals("url")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.link.url");
        }
        else
          return super.addChild(name);
      }

      public BundleLinkComponent copy() {
        BundleLinkComponent dst = new BundleLinkComponent();
        copyValues(dst);
        return dst;
      }

      public void copyValues(BundleLinkComponent dst) {
        super.copyValues(dst);
        dst.relation = relation == null ? null : relation.copy();
        dst.url = url == null ? null : url.copy();
      }

      @Override
      public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_))
          return false;
        if (!(other_ instanceof BundleLinkComponent))
          return false;
        BundleLinkComponent o = (BundleLinkComponent) other_;
        return compareDeep(relation, o.relation, true) && compareDeep(url, o.url, true);
      }

      @Override
      public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_))
          return false;
        if (!(other_ instanceof BundleLinkComponent))
          return false;
        BundleLinkComponent o = (BundleLinkComponent) other_;
        return compareValues(relation, o.relation, true) && compareValues(url, o.url, true);
      }

      public boolean isEmpty() {
        return super.isEmpty() && ca.uhn.fhir.util.ElementUtil.isEmpty(relation, url);
      }

  public String fhirType() {
    return "Bundle.link";

  }

  }

    @Block()
    public static class BundleEntryComponent extends BackboneElement implements IBaseBackboneElement {
        /**
         * A series of links that provide context to this entry.
         */
        @Child(name = "link", type = {BundleLinkComponent.class}, order=1, min=0, max=Child.MAX_UNLIMITED, modifier=false, summary=true)
        @Description(shortDefinition="Links related to this entry", formalDefinition="A series of links that provide context to this entry." )
        protected List<BundleLinkComponent> link;

        /**
         * The Absolute URL for the resource. Except for transactions and batches, each entry in a Bundle must have a fullUrl. The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. Even when not required, fullUrl MAY be set to a urn:uuid to allow referencing entries in a transaction. The fullUrl can be an arbitrary URI and is not limited to urn:uuid, urn:oid, http, and https. The fullUrl element SHALL have a value except when: 
* invoking a create
* invoking or responding to an operation where the body is not a single identified resource
* invoking or returning the results of a search or history operation.
         */
        @Child(name = "fullUrl", type = {UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URI for resource (e.g. the absolute URL server address, URI for UUID/OID, etc.)", formalDefinition="The Absolute URL for the resource. Except for transactions and batches, each entry in a Bundle must have a fullUrl. The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. Even when not required, fullUrl MAY be set to a urn:uuid to allow referencing entries in a transaction. The fullUrl can be an arbitrary URI and is not limited to urn:uuid, urn:oid, http, and https. The fullUrl element SHALL have a value except when: \n* invoking a create\n* invoking or responding to an operation where the body is not a single identified resource\n* invoking or returning the results of a search or history operation." )
        protected UriType fullUrl;

        /**
         * The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type. This is allowed to be a Parameters resource if and only if it is referenced by something else within the Bundle that provides context/meaning.
         */
        @Child(name = "resource", type = {Resource.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A resource in the bundle", formalDefinition="The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type. This is allowed to be a Parameters resource if and only if it is referenced by something else within the Bundle that provides context/meaning." )
        protected Resource resource;

        /**
         * Information about the search process that lead to the creation of this entry.
         */
        @Child(name = "search", type = {}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Search related information", formalDefinition="Information about the search process that lead to the creation of this entry." )
        protected BundleEntrySearchComponent search;

        /**
         * Additional information about how this entry should be processed as part of a transaction or batch.  For history, it shows how the entry was processed to create the version contained in the entry.
         */
        @Child(name = "request", type = {}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Additional execution information (transaction/batch/history)", formalDefinition="Additional information about how this entry should be processed as part of a transaction or batch.  For history, it shows how the entry was processed to create the version contained in the entry." )
        protected BundleEntryRequestComponent request;

        /**
         * Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history.
         */
        @Child(name = "response", type = {}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Results of execution (transaction/batch/history)", formalDefinition="Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history." )
        protected BundleEntryResponseComponent response;

        private static final long serialVersionUID = 517783054L;

    /**
     * Constructor
     */
      public BundleEntryComponent() {
        super();
      }

        /**
         * @return {@link #link} (A series of links that provide context to this entry.)
         */
        public List<BundleLinkComponent> getLink() { 
          if (this.link == null)
            this.link = new ArrayList<BundleLinkComponent>();
          return this.link;
        }

        /**
         * @return Returns a reference to <code>this</code> for easy method chaining
         */
        public BundleEntryComponent setLink(List<BundleLinkComponent> theLink) { 
          this.link = theLink;
          return this;
        }

        public boolean hasLink() { 
          if (this.link == null)
            return false;
          for (BundleLinkComponent item : this.link)
            if (!item.isEmpty())
              return true;
          return false;
        }

        public BundleLinkComponent addLink() { //3
          BundleLinkComponent t = new BundleLinkComponent();
          if (this.link == null)
            this.link = new ArrayList<BundleLinkComponent>();
          this.link.add(t);
          return t;
        }

        public BundleEntryComponent addLink(BundleLinkComponent t) { //3
          if (t == null)
            return this;
          if (this.link == null)
            this.link = new ArrayList<BundleLinkComponent>();
          this.link.add(t);
          return this;
        }

        /**
         * @return The first repetition of repeating field {@link #link}, creating it if it does not already exist {3}
         */
        public BundleLinkComponent getLinkFirstRep() { 
          if (getLink().isEmpty()) {
            addLink();
          }
          return getLink().get(0);
        }

        /**
         * @return {@link #fullUrl} (The Absolute URL for the resource. Except for transactions and batches, each entry in a Bundle must have a fullUrl. The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. Even when not required, fullUrl MAY be set to a urn:uuid to allow referencing entries in a transaction. The fullUrl can be an arbitrary URI and is not limited to urn:uuid, urn:oid, http, and https. The fullUrl element SHALL have a value except when: 
* invoking a create
* invoking or responding to an operation where the body is not a single identified resource
* invoking or returning the results of a search or history operation.). This is the underlying object with id, value and extensions. The accessor "getFullUrl" gives direct access to the value
         */
        public UriType getFullUrlElement() { 
          if (this.fullUrl == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryComponent.fullUrl");
            else if (Configuration.doAutoCreate())
              this.fullUrl = new UriType(); // bb
          return this.fullUrl;
        }

        public boolean hasFullUrlElement() { 
          return this.fullUrl != null && !this.fullUrl.isEmpty();
        }

        public boolean hasFullUrl() { 
          return this.fullUrl != null && !this.fullUrl.isEmpty();
        }

        /**
         * @param value {@link #fullUrl} (The Absolute URL for the resource. Except for transactions and batches, each entry in a Bundle must have a fullUrl. The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. Even when not required, fullUrl MAY be set to a urn:uuid to allow referencing entries in a transaction. The fullUrl can be an arbitrary URI and is not limited to urn:uuid, urn:oid, http, and https. The fullUrl element SHALL have a value except when: 
* invoking a create
* invoking or responding to an operation where the body is not a single identified resource
* invoking or returning the results of a search or history operation.). This is the underlying object with id, value and extensions. The accessor "getFullUrl" gives direct access to the value
         */
        public BundleEntryComponent setFullUrlElement(UriType value) { 
          this.fullUrl = value;
          return this;
        }

        /**
         * @return The Absolute URL for the resource. Except for transactions and batches, each entry in a Bundle must have a fullUrl. The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. Even when not required, fullUrl MAY be set to a urn:uuid to allow referencing entries in a transaction. The fullUrl can be an arbitrary URI and is not limited to urn:uuid, urn:oid, http, and https. The fullUrl element SHALL have a value except when: 
* invoking a create
* invoking or responding to an operation where the body is not a single identified resource
* invoking or returning the results of a search or history operation.
         */
        public String getFullUrl() { 
          return this.fullUrl == null ? null : this.fullUrl.getValue();
        }

        /**
         * @param value The Absolute URL for the resource. Except for transactions and batches, each entry in a Bundle must have a fullUrl. The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. Even when not required, fullUrl MAY be set to a urn:uuid to allow referencing entries in a transaction. The fullUrl can be an arbitrary URI and is not limited to urn:uuid, urn:oid, http, and https. The fullUrl element SHALL have a value except when: 
* invoking a create
* invoking or responding to an operation where the body is not a single identified resource
* invoking or returning the results of a search or history operation.
         */
        public BundleEntryComponent setFullUrl(String value) { 
          if (Utilities.noString(value))
            this.fullUrl = null;
          else {
            if (this.fullUrl == null)
              this.fullUrl = new UriType();
            this.fullUrl.setValue(value);
          }
          return this;
        }

        /**
         * @return {@link #resource} (The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type. This is allowed to be a Parameters resource if and only if it is referenced by something else within the Bundle that provides context/meaning.)
         */
        public Resource getResource() { 
          return this.resource;
        }

        public boolean hasResource() { 
          return this.resource != null && !this.resource.isEmpty();
        }

        /**
         * @param value {@link #resource} (The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type. This is allowed to be a Parameters resource if and only if it is referenced by something else within the Bundle that provides context/meaning.)
         */
        public BundleEntryComponent setResource(Resource value) { 
          this.resource = value;
          return this;
        }

        /**
         * @return {@link #search} (Information about the search process that lead to the creation of this entry.)
         */
        public BundleEntrySearchComponent getSearch() { 
          if (this.search == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryComponent.search");
            else if (Configuration.doAutoCreate())
              this.search = new BundleEntrySearchComponent(); // cc
          return this.search;
        }

        public boolean hasSearch() { 
          return this.search != null && !this.search.isEmpty();
        }

        /**
         * @param value {@link #search} (Information about the search process that lead to the creation of this entry.)
         */
        public BundleEntryComponent setSearch(BundleEntrySearchComponent value) { 
          this.search = value;
          return this;
        }

        /**
         * @return {@link #request} (Additional information about how this entry should be processed as part of a transaction or batch.  For history, it shows how the entry was processed to create the version contained in the entry.)
         */
        public BundleEntryRequestComponent getRequest() { 
          if (this.request == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryComponent.request");
            else if (Configuration.doAutoCreate())
              this.request = new BundleEntryRequestComponent(); // cc
          return this.request;
        }

        public boolean hasRequest() { 
          return this.request != null && !this.request.isEmpty();
        }

        /**
         * @param value {@link #request} (Additional information about how this entry should be processed as part of a transaction or batch.  For history, it shows how the entry was processed to create the version contained in the entry.)
         */
        public BundleEntryComponent setRequest(BundleEntryRequestComponent value) { 
          this.request = value;
          return this;
        }

        /**
         * @return {@link #response} (Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history.)
         */
        public BundleEntryResponseComponent getResponse() { 
          if (this.response == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryComponent.response");
            else if (Configuration.doAutoCreate())
              this.response = new BundleEntryResponseComponent(); // cc
          return this.response;
        }

        public boolean hasResponse() { 
          return this.response != null && !this.response.isEmpty();
        }

        /**
         * @param value {@link #response} (Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history.)
         */
        public BundleEntryComponent setResponse(BundleEntryResponseComponent value) { 
          this.response = value;
          return this;
        }

        protected void listChildren(List<Property> children) {
          super.listChildren(children);
          children.add(new Property("link", "@Bundle.link", "A series of links that provide context to this entry.", 0, java.lang.Integer.MAX_VALUE, link));
          children.add(new Property("fullUrl", "uri", "The Absolute URL for the resource. Except for transactions and batches, each entry in a Bundle must have a fullUrl. The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. Even when not required, fullUrl MAY be set to a urn:uuid to allow referencing entries in a transaction. The fullUrl can be an arbitrary URI and is not limited to urn:uuid, urn:oid, http, and https. The fullUrl element SHALL have a value except when: \n* invoking a create\n* invoking or responding to an operation where the body is not a single identified resource\n* invoking or returning the results of a search or history operation.", 0, 1, fullUrl));
          children.add(new Property("resource", "Resource", "The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type. This is allowed to be a Parameters resource if and only if it is referenced by something else within the Bundle that provides context/meaning.", 0, 1, resource));
          children.add(new Property("search", "", "Information about the search process that lead to the creation of this entry.", 0, 1, search));
          children.add(new Property("request", "", "Additional information about how this entry should be processed as part of a transaction or batch.  For history, it shows how the entry was processed to create the version contained in the entry.", 0, 1, request));
          children.add(new Property("response", "", "Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history.", 0, 1, response));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
          switch (_hash) {
          case 3321850: /*link*/  return new Property("link", "@Bundle.link", "A series of links that provide context to this entry.", 0, java.lang.Integer.MAX_VALUE, link);
          case -511251360: /*fullUrl*/  return new Property("fullUrl", "uri", "The Absolute URL for the resource. Except for transactions and batches, each entry in a Bundle must have a fullUrl. The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. Even when not required, fullUrl MAY be set to a urn:uuid to allow referencing entries in a transaction. The fullUrl can be an arbitrary URI and is not limited to urn:uuid, urn:oid, http, and https. The fullUrl element SHALL have a value except when: \n* invoking a create\n* invoking or responding to an operation where the body is not a single identified resource\n* invoking or returning the results of a search or history operation.", 0, 1, fullUrl);
          case -341064690: /*resource*/  return new Property("resource", "Resource", "The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type. This is allowed to be a Parameters resource if and only if it is referenced by something else within the Bundle that provides context/meaning.", 0, 1, resource);
          case -906336856: /*search*/  return new Property("search", "", "Information about the search process that lead to the creation of this entry.", 0, 1, search);
          case 1095692943: /*request*/  return new Property("request", "", "Additional information about how this entry should be processed as part of a transaction or batch.  For history, it shows how the entry was processed to create the version contained in the entry.", 0, 1, request);
          case -340323263: /*response*/  return new Property("response", "", "Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history.", 0, 1, response);
          default: return super.getNamedProperty(_hash, _name, _checkValid);
          }

        }

      @Override
      public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
        case 3321850: /*link*/ return this.link == null ? new Base[0] : this.link.toArray(new Base[this.link.size()]); // BundleLinkComponent
        case -511251360: /*fullUrl*/ return this.fullUrl == null ? new Base[0] : new Base[] {this.fullUrl}; // UriType
        case -341064690: /*resource*/ return this.resource == null ? new Base[0] : new Base[] {this.resource}; // Resource
        case -906336856: /*search*/ return this.search == null ? new Base[0] : new Base[] {this.search}; // BundleEntrySearchComponent
        case 1095692943: /*request*/ return this.request == null ? new Base[0] : new Base[] {this.request}; // BundleEntryRequestComponent
        case -340323263: /*response*/ return this.response == null ? new Base[0] : new Base[] {this.response}; // BundleEntryResponseComponent
        default: return super.getProperty(hash, name, checkValid);
        }

      }

      @Override
      public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
        case 3321850: // link
          this.getLink().add((BundleLinkComponent) value); // BundleLinkComponent
          return value;
        case -511251360: // fullUrl
          this.fullUrl = TypeConvertor.castToUri(value); // UriType
          return value;
        case -341064690: // resource
          this.resource = TypeConvertor.castToResource(value); // Resource
          return value;
        case -906336856: // search
          this.search = (BundleEntrySearchComponent) value; // BundleEntrySearchComponent
          return value;
        case 1095692943: // request
          this.request = (BundleEntryRequestComponent) value; // BundleEntryRequestComponent
          return value;
        case -340323263: // response
          this.response = (BundleEntryResponseComponent) value; // BundleEntryResponseComponent
          return value;
        default: return super.setProperty(hash, name, value);
        }

      }

      @Override
      public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("link")) {
          this.getLink().add((BundleLinkComponent) value);
        } else if (name.equals("fullUrl")) {
          this.fullUrl = TypeConvertor.castToUri(value); // UriType
        } else if (name.equals("resource")) {
          this.resource = TypeConvertor.castToResource(value); // Resource
        } else if (name.equals("search")) {
          this.search = (BundleEntrySearchComponent) value; // BundleEntrySearchComponent
        } else if (name.equals("request")) {
          this.request = (BundleEntryRequestComponent) value; // BundleEntryRequestComponent
        } else if (name.equals("response")) {
          this.response = (BundleEntryResponseComponent) value; // BundleEntryResponseComponent
        } else
          return super.setProperty(name, value);
        return value;
      }

      @Override
      public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
        case 3321850:  return addLink(); 
        case -511251360:  return getFullUrlElement();
        case -341064690: throw new FHIRException("Cannot make property resource as it is not a complex type"); // Resource
        case -906336856:  return getSearch();
        case 1095692943:  return getRequest();
        case -340323263:  return getResponse();
        default: return super.makeProperty(hash, name);
        }

      }

      @Override
      public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
        case 3321850: /*link*/ return new String[] {"@Bundle.link"};
        case -511251360: /*fullUrl*/ return new String[] {"uri"};
        case -341064690: /*resource*/ return new String[] {"Resource"};
        case -906336856: /*search*/ return new String[] {};
        case 1095692943: /*request*/ return new String[] {};
        case -340323263: /*response*/ return new String[] {};
        default: return super.getTypesForProperty(hash, name);
        }

      }

      @Override
      public Base addChild(String name) throws FHIRException {
        if (name.equals("link")) {
          return addLink();
        }
        else if (name.equals("fullUrl")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.fullUrl");
        }
        else if (name.equals("resource")) {
          throw new FHIRException("Cannot call addChild on an abstract type Bundle.entry.resource");
        }
        else if (name.equals("search")) {
          this.search = new BundleEntrySearchComponent();
          return this.search;
        }
        else if (name.equals("request")) {
          this.request = new BundleEntryRequestComponent();
          return this.request;
        }
        else if (name.equals("response")) {
          this.response = new BundleEntryResponseComponent();
          return this.response;
        }
        else
          return super.addChild(name);
      }

      public BundleEntryComponent copy() {
        BundleEntryComponent dst = new BundleEntryComponent();
        copyValues(dst);
        return dst;
      }

      public void copyValues(BundleEntryComponent dst) {
        super.copyValues(dst);
        if (link != null) {
          dst.link = new ArrayList<BundleLinkComponent>();
          for (BundleLinkComponent i : link)
            dst.link.add(i.copy());
        };
        dst.fullUrl = fullUrl == null ? null : fullUrl.copy();
        dst.resource = resource == null ? null : resource.copy();
        dst.search = search == null ? null : search.copy();
        dst.request = request == null ? null : request.copy();
        dst.response = response == null ? null : response.copy();
      }

      @Override
      public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_))
          return false;
        if (!(other_ instanceof BundleEntryComponent))
          return false;
        BundleEntryComponent o = (BundleEntryComponent) other_;
        return compareDeep(link, o.link, true) && compareDeep(fullUrl, o.fullUrl, true) && compareDeep(resource, o.resource, true)
           && compareDeep(search, o.search, true) && compareDeep(request, o.request, true) && compareDeep(response, o.response, true)
          ;
      }

      @Override
      public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_))
          return false;
        if (!(other_ instanceof BundleEntryComponent))
          return false;
        BundleEntryComponent o = (BundleEntryComponent) other_;
        return compareValues(fullUrl, o.fullUrl, true);
      }

      public boolean isEmpty() {
        return super.isEmpty() && ca.uhn.fhir.util.ElementUtil.isEmpty(link, fullUrl, resource
          , search, request, response);
      }

  public String fhirType() {
    return "Bundle.entry";

  }

// added from java-adornments.txt:
/** 
   * Returns the {@link #getLink() link} which matches a given {@link BundleLinkComponent#getRelation() relation}.  
   * If no link is found which matches the given relation, returns <code>null</code>. If more than one 
   * link is found which matches the given relation, returns the first matching BundleLinkComponent. 
   *  
   * @param theRelation 
   *            The relation, such as \"next\", or \"self. See the constants such as {@link IBaseBundle#LINK_SELF} and {@link IBaseBundle#LINK_NEXT}. 
   * @return Returns a matching BundleLinkComponent, or <code>null</code> 
   * @see IBaseBundle#LINK_NEXT 
   * @see IBaseBundle#LINK_PREV 
   * @see IBaseBundle#LINK_SELF 
   */ 
  public BundleLinkComponent getLink(String theRelation) { 
    org.apache.commons.lang3.Validate.notBlank(theRelation, "theRelation may not be null or empty"); 
    for (BundleLinkComponent next : getLink()) { 
      if (theRelation.equals(next.getRelation().toCode())) { 
        return next; 
      } 
    } 
    return null; 
  } 
  
  /** 
   * Returns the {@link #getLink() link} which matches a given {@link BundleLinkComponent#getRelation() relation}.  
   * If no link is found which matches the given relation, creates a new BundleLinkComponent with the 
   * given relation and adds it to this Bundle. If more than one 
   * link is found which matches the given relation, returns the first matching BundleLinkComponent. 
   *  
   * @param theRelation 
   *            The relation, such as \"next\", or \"self. See the constants such as {@link IBaseBundle#LINK_SELF} and {@link IBaseBundle#LINK_NEXT}. 
   * @return Returns a matching BundleLinkComponent, or <code>null</code> 
   * @see IBaseBundle#LINK_NEXT 
   * @see IBaseBundle#LINK_PREV 
   * @see IBaseBundle#LINK_SELF 
   */ 
  public BundleLinkComponent getLinkOrCreate(String theRelation) { 
    org.apache.commons.lang3.Validate.notBlank(theRelation, "theRelation may not be null or empty"); 
    for (BundleLinkComponent next : getLink()) { 
      if (theRelation.equals(next.getRelation().toCode())) { 
        return next; 
      } 
    } 
    BundleLinkComponent retVal = new BundleLinkComponent(); 
    retVal.setRelation(LinkRelationTypes.fromCode(theRelation)); 
    getLink().add(retVal); 
    return retVal; 
  }
// end addition
  }

    @Block()
    public static class BundleEntrySearchComponent extends BackboneElement implements IBaseBackboneElement {
        /**
         * Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.
         */
        @Child(name = "mode", type = {CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="match | include - why this is in the result set", formalDefinition="Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process." )
        @ca.uhn.fhir.model.api.annotation.Binding(valueSet="http://hl7.org/fhir/ValueSet/search-entry-mode")
        protected Enumeration<SearchEntryMode> mode;

        /**
         * When searching, the server's search ranking score for the entry.
         */
        @Child(name = "score", type = {DecimalType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Search ranking (between 0 and 1)", formalDefinition="When searching, the server's search ranking score for the entry." )
        protected DecimalType score;

        private static final long serialVersionUID = 837739866L;

    /**
     * Constructor
     */
      public BundleEntrySearchComponent() {
        super();
      }

        /**
         * @return {@link #mode} (Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.). This is the underlying object with id, value and extensions. The accessor "getMode" gives direct access to the value
         */
        public Enumeration<SearchEntryMode> getModeElement() { 
          if (this.mode == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntrySearchComponent.mode");
            else if (Configuration.doAutoCreate())
              this.mode = new Enumeration<SearchEntryMode>(new SearchEntryModeEnumFactory()); // bb
          return this.mode;
        }

        public boolean hasModeElement() { 
          return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() { 
          return this.mode != null && !this.mode.isEmpty();
        }

        /**
         * @param value {@link #mode} (Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.). This is the underlying object with id, value and extensions. The accessor "getMode" gives direct access to the value
         */
        public BundleEntrySearchComponent setModeElement(Enumeration<SearchEntryMode> value) { 
          this.mode = value;
          return this;
        }

        /**
         * @return Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.
         */
        public SearchEntryMode getMode() { 
          return this.mode == null ? null : this.mode.getValue();
        }

        /**
         * @param value Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.
         */
        public BundleEntrySearchComponent setMode(SearchEntryMode value) { 
          if (value == null)
            this.mode = null;
          else {
            if (this.mode == null)
              this.mode = new Enumeration<SearchEntryMode>(new SearchEntryModeEnumFactory());
            this.mode.setValue(value);
          }
          return this;
        }

        /**
         * @return {@link #score} (When searching, the server's search ranking score for the entry.). This is the underlying object with id, value and extensions. The accessor "getScore" gives direct access to the value
         */
        public DecimalType getScoreElement() { 
          if (this.score == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntrySearchComponent.score");
            else if (Configuration.doAutoCreate())
              this.score = new DecimalType(); // bb
          return this.score;
        }

        public boolean hasScoreElement() { 
          return this.score != null && !this.score.isEmpty();
        }

        public boolean hasScore() { 
          return this.score != null && !this.score.isEmpty();
        }

        /**
         * @param value {@link #score} (When searching, the server's search ranking score for the entry.). This is the underlying object with id, value and extensions. The accessor "getScore" gives direct access to the value
         */
        public BundleEntrySearchComponent setScoreElement(DecimalType value) { 
          this.score = value;
          return this;
        }

        /**
         * @return When searching, the server's search ranking score for the entry.
         */
        public BigDecimal getScore() { 
          return this.score == null ? null : this.score.getValue();
        }

        /**
         * @param value When searching, the server's search ranking score for the entry.
         */
        public BundleEntrySearchComponent setScore(BigDecimal value) { 
          if (value == null)
            this.score = null;
          else {
            if (this.score == null)
              this.score = new DecimalType();
            this.score.setValue(value);
          }
          return this;
        }

        /**
         * @param value When searching, the server's search ranking score for the entry.
         */
        public BundleEntrySearchComponent setScore(long value) { 
              this.score = new DecimalType();
            this.score.setValue(value);
          return this;
        }

        /**
         * @param value When searching, the server's search ranking score for the entry.
         */
        public BundleEntrySearchComponent setScore(double value) { 
              this.score = new DecimalType();
            this.score.setValue(value);
          return this;
        }

        protected void listChildren(List<Property> children) {
          super.listChildren(children);
          children.add(new Property("mode", "code", "Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.", 0, 1, mode));
          children.add(new Property("score", "decimal", "When searching, the server's search ranking score for the entry.", 0, 1, score));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
          switch (_hash) {
          case 3357091: /*mode*/  return new Property("mode", "code", "Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.", 0, 1, mode);
          case 109264530: /*score*/  return new Property("score", "decimal", "When searching, the server's search ranking score for the entry.", 0, 1, score);
          default: return super.getNamedProperty(_hash, _name, _checkValid);
          }

        }

      @Override
      public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
        case 3357091: /*mode*/ return this.mode == null ? new Base[0] : new Base[] {this.mode}; // Enumeration<SearchEntryMode>
        case 109264530: /*score*/ return this.score == null ? new Base[0] : new Base[] {this.score}; // DecimalType
        default: return super.getProperty(hash, name, checkValid);
        }

      }

      @Override
      public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
        case 3357091: // mode
          value = new SearchEntryModeEnumFactory().fromType(TypeConvertor.castToCode(value));
          this.mode = (Enumeration) value; // Enumeration<SearchEntryMode>
          return value;
        case 109264530: // score
          this.score = TypeConvertor.castToDecimal(value); // DecimalType
          return value;
        default: return super.setProperty(hash, name, value);
        }

      }

      @Override
      public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("mode")) {
          value = new SearchEntryModeEnumFactory().fromType(TypeConvertor.castToCode(value));
          this.mode = (Enumeration) value; // Enumeration<SearchEntryMode>
        } else if (name.equals("score")) {
          this.score = TypeConvertor.castToDecimal(value); // DecimalType
        } else
          return super.setProperty(name, value);
        return value;
      }

      @Override
      public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
        case 3357091:  return getModeElement();
        case 109264530:  return getScoreElement();
        default: return super.makeProperty(hash, name);
        }

      }

      @Override
      public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
        case 3357091: /*mode*/ return new String[] {"code"};
        case 109264530: /*score*/ return new String[] {"decimal"};
        default: return super.getTypesForProperty(hash, name);
        }

      }

      @Override
      public Base addChild(String name) throws FHIRException {
        if (name.equals("mode")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.search.mode");
        }
        else if (name.equals("score")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.search.score");
        }
        else
          return super.addChild(name);
      }

      public BundleEntrySearchComponent copy() {
        BundleEntrySearchComponent dst = new BundleEntrySearchComponent();
        copyValues(dst);
        return dst;
      }

      public void copyValues(BundleEntrySearchComponent dst) {
        super.copyValues(dst);
        dst.mode = mode == null ? null : mode.copy();
        dst.score = score == null ? null : score.copy();
      }

      @Override
      public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_))
          return false;
        if (!(other_ instanceof BundleEntrySearchComponent))
          return false;
        BundleEntrySearchComponent o = (BundleEntrySearchComponent) other_;
        return compareDeep(mode, o.mode, true) && compareDeep(score, o.score, true);
      }

      @Override
      public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_))
          return false;
        if (!(other_ instanceof BundleEntrySearchComponent))
          return false;
        BundleEntrySearchComponent o = (BundleEntrySearchComponent) other_;
        return compareValues(mode, o.mode, true) && compareValues(score, o.score, true);
      }

      public boolean isEmpty() {
        return super.isEmpty() && ca.uhn.fhir.util.ElementUtil.isEmpty(mode, score);
      }

  public String fhirType() {
    return "Bundle.entry.search";

  }

  }

    @Block()
    public static class BundleEntryRequestComponent extends BackboneElement implements IBaseBackboneElement {
        /**
         * In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.
         */
        @Child(name = "method", type = {CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="GET | HEAD | POST | PUT | DELETE | PATCH", formalDefinition="In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred." )
        @ca.uhn.fhir.model.api.annotation.Binding(valueSet="http://hl7.org/fhir/ValueSet/http-verb")
        protected Enumeration<HTTPVerb> method;

        /**
         * The URL for this entry, relative to the root (the address to which the request is posted).
         */
        @Child(name = "url", type = {UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URL for HTTP equivalent of this entry", formalDefinition="The URL for this entry, relative to the root (the address to which the request is posted)." )
        protected UriType url;

        /**
         * If the ETag values match, return a 304 Not Modified status. See the API documentation for ["Conditional Read"](http.html#cread).
         */
        @Child(name = "ifNoneMatch", type = {StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For managing cache validation", formalDefinition="If the ETag values match, return a 304 Not Modified status. See the API documentation for [\"Conditional Read\"](http.html#cread)." )
        protected StringType ifNoneMatch;

        /**
         * Only perform the operation if the last updated date matches. See the API documentation for ["Conditional Read"](http.html#cread).
         */
        @Child(name = "ifModifiedSince", type = {InstantType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For managing cache currency", formalDefinition="Only perform the operation if the last updated date matches. See the API documentation for [\"Conditional Read\"](http.html#cread)." )
        protected InstantType ifModifiedSince;

        /**
         * Only perform the operation if the Etag value matches. For more information, see the API section ["Managing Resource Contention"](http.html#concurrency).
         */
        @Child(name = "ifMatch", type = {StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For managing update contention", formalDefinition="Only perform the operation if the Etag value matches. For more information, see the API section [\"Managing Resource Contention\"](http.html#concurrency)." )
        protected StringType ifMatch;

        /**
         * Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for ["Conditional Create"](http.html#ccreate). This is just the query portion of the URL - what follows the "?" (not including the "?").
         */
        @Child(name = "ifNoneExist", type = {StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For conditional creates", formalDefinition="Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for [\"Conditional Create\"](http.html#ccreate). This is just the query portion of the URL - what follows the \"?\" (not including the \"?\")." )
        protected StringType ifNoneExist;

        private static final long serialVersionUID = -1349769744L;

    /**
     * Constructor
     */
      public BundleEntryRequestComponent() {
        super();
      }

    /**
     * Constructor
     */
      public BundleEntryRequestComponent(HTTPVerb method, String url) {
        super();
        this.setMethod(method);
        this.setUrl(url);
      }

        /**
         * @return {@link #method} (In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.). This is the underlying object with id, value and extensions. The accessor "getMethod" gives direct access to the value
         */
        public Enumeration<HTTPVerb> getMethodElement() { 
          if (this.method == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryRequestComponent.method");
            else if (Configuration.doAutoCreate())
              this.method = new Enumeration<HTTPVerb>(new HTTPVerbEnumFactory()); // bb
          return this.method;
        }

        public boolean hasMethodElement() { 
          return this.method != null && !this.method.isEmpty();
        }

        public boolean hasMethod() { 
          return this.method != null && !this.method.isEmpty();
        }

        /**
         * @param value {@link #method} (In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.). This is the underlying object with id, value and extensions. The accessor "getMethod" gives direct access to the value
         */
        public BundleEntryRequestComponent setMethodElement(Enumeration<HTTPVerb> value) { 
          this.method = value;
          return this;
        }

        /**
         * @return In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.
         */
        public HTTPVerb getMethod() { 
          return this.method == null ? null : this.method.getValue();
        }

        /**
         * @param value In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.
         */
        public BundleEntryRequestComponent setMethod(HTTPVerb value) { 
            if (this.method == null)
              this.method = new Enumeration<HTTPVerb>(new HTTPVerbEnumFactory());
            this.method.setValue(value);
          return this;
        }

        /**
         * @return {@link #url} (The URL for this entry, relative to the root (the address to which the request is posted).). This is the underlying object with id, value and extensions. The accessor "getUrl" gives direct access to the value
         */
        public UriType getUrlElement() { 
          if (this.url == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryRequestComponent.url");
            else if (Configuration.doAutoCreate())
              this.url = new UriType(); // bb
          return this.url;
        }

        public boolean hasUrlElement() { 
          return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() { 
          return this.url != null && !this.url.isEmpty();
        }

        /**
         * @param value {@link #url} (The URL for this entry, relative to the root (the address to which the request is posted).). This is the underlying object with id, value and extensions. The accessor "getUrl" gives direct access to the value
         */
        public BundleEntryRequestComponent setUrlElement(UriType value) { 
          this.url = value;
          return this;
        }

        /**
         * @return The URL for this entry, relative to the root (the address to which the request is posted).
         */
        public String getUrl() { 
          return this.url == null ? null : this.url.getValue();
        }

        /**
         * @param value The URL for this entry, relative to the root (the address to which the request is posted).
         */
        public BundleEntryRequestComponent setUrl(String value) { 
            if (this.url == null)
              this.url = new UriType();
            this.url.setValue(value);
          return this;
        }

        /**
         * @return {@link #ifNoneMatch} (If the ETag values match, return a 304 Not Modified status. See the API documentation for ["Conditional Read"](http.html#cread).). This is the underlying object with id, value and extensions. The accessor "getIfNoneMatch" gives direct access to the value
         */
        public StringType getIfNoneMatchElement() { 
          if (this.ifNoneMatch == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifNoneMatch");
            else if (Configuration.doAutoCreate())
              this.ifNoneMatch = new StringType(); // bb
          return this.ifNoneMatch;
        }

        public boolean hasIfNoneMatchElement() { 
          return this.ifNoneMatch != null && !this.ifNoneMatch.isEmpty();
        }

        public boolean hasIfNoneMatch() { 
          return this.ifNoneMatch != null && !this.ifNoneMatch.isEmpty();
        }

        /**
         * @param value {@link #ifNoneMatch} (If the ETag values match, return a 304 Not Modified status. See the API documentation for ["Conditional Read"](http.html#cread).). This is the underlying object with id, value and extensions. The accessor "getIfNoneMatch" gives direct access to the value
         */
        public BundleEntryRequestComponent setIfNoneMatchElement(StringType value) { 
          this.ifNoneMatch = value;
          return this;
        }

        /**
         * @return If the ETag values match, return a 304 Not Modified status. See the API documentation for ["Conditional Read"](http.html#cread).
         */
        public String getIfNoneMatch() { 
          return this.ifNoneMatch == null ? null : this.ifNoneMatch.getValue();
        }

        /**
         * @param value If the ETag values match, return a 304 Not Modified status. See the API documentation for ["Conditional Read"](http.html#cread).
         */
        public BundleEntryRequestComponent setIfNoneMatch(String value) { 
          if (Utilities.noString(value))
            this.ifNoneMatch = null;
          else {
            if (this.ifNoneMatch == null)
              this.ifNoneMatch = new StringType();
            this.ifNoneMatch.setValue(value);
          }
          return this;
        }

        /**
         * @return {@link #ifModifiedSince} (Only perform the operation if the last updated date matches. See the API documentation for ["Conditional Read"](http.html#cread).). This is the underlying object with id, value and extensions. The accessor "getIfModifiedSince" gives direct access to the value
         */
        public InstantType getIfModifiedSinceElement() { 
          if (this.ifModifiedSince == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifModifiedSince");
            else if (Configuration.doAutoCreate())
              this.ifModifiedSince = new InstantType(); // bb
          return this.ifModifiedSince;
        }

        public boolean hasIfModifiedSinceElement() { 
          return this.ifModifiedSince != null && !this.ifModifiedSince.isEmpty();
        }

        public boolean hasIfModifiedSince() { 
          return this.ifModifiedSince != null && !this.ifModifiedSince.isEmpty();
        }

        /**
         * @param value {@link #ifModifiedSince} (Only perform the operation if the last updated date matches. See the API documentation for ["Conditional Read"](http.html#cread).). This is the underlying object with id, value and extensions. The accessor "getIfModifiedSince" gives direct access to the value
         */
        public BundleEntryRequestComponent setIfModifiedSinceElement(InstantType value) { 
          this.ifModifiedSince = value;
          return this;
        }

        /**
         * @return Only perform the operation if the last updated date matches. See the API documentation for ["Conditional Read"](http.html#cread).
         */
        public Date getIfModifiedSince() { 
          return this.ifModifiedSince == null ? null : this.ifModifiedSince.getValue();
        }

        /**
         * @param value Only perform the operation if the last updated date matches. See the API documentation for ["Conditional Read"](http.html#cread).
         */
        public BundleEntryRequestComponent setIfModifiedSince(Date value) { 
          if (value == null)
            this.ifModifiedSince = null;
          else {
            if (this.ifModifiedSince == null)
              this.ifModifiedSince = new InstantType();
            this.ifModifiedSince.setValue(value);
          }
          return this;
        }

        /**
         * @return {@link #ifMatch} (Only perform the operation if the Etag value matches. For more information, see the API section ["Managing Resource Contention"](http.html#concurrency).). This is the underlying object with id, value and extensions. The accessor "getIfMatch" gives direct access to the value
         */
        public StringType getIfMatchElement() { 
          if (this.ifMatch == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifMatch");
            else if (Configuration.doAutoCreate())
              this.ifMatch = new StringType(); // bb
          return this.ifMatch;
        }

        public boolean hasIfMatchElement() { 
          return this.ifMatch != null && !this.ifMatch.isEmpty();
        }

        public boolean hasIfMatch() { 
          return this.ifMatch != null && !this.ifMatch.isEmpty();
        }

        /**
         * @param value {@link #ifMatch} (Only perform the operation if the Etag value matches. For more information, see the API section ["Managing Resource Contention"](http.html#concurrency).). This is the underlying object with id, value and extensions. The accessor "getIfMatch" gives direct access to the value
         */
        public BundleEntryRequestComponent setIfMatchElement(StringType value) { 
          this.ifMatch = value;
          return this;
        }

        /**
         * @return Only perform the operation if the Etag value matches. For more information, see the API section ["Managing Resource Contention"](http.html#concurrency).
         */
        public String getIfMatch() { 
          return this.ifMatch == null ? null : this.ifMatch.getValue();
        }

        /**
         * @param value Only perform the operation if the Etag value matches. For more information, see the API section ["Managing Resource Contention"](http.html#concurrency).
         */
        public BundleEntryRequestComponent setIfMatch(String value) { 
          if (Utilities.noString(value))
            this.ifMatch = null;
          else {
            if (this.ifMatch == null)
              this.ifMatch = new StringType();
            this.ifMatch.setValue(value);
          }
          return this;
        }

        /**
         * @return {@link #ifNoneExist} (Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for ["Conditional Create"](http.html#ccreate). This is just the query portion of the URL - what follows the "?" (not including the "?").). This is the underlying object with id, value and extensions. The accessor "getIfNoneExist" gives direct access to the value
         */
        public StringType getIfNoneExistElement() { 
          if (this.ifNoneExist == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifNoneExist");
            else if (Configuration.doAutoCreate())
              this.ifNoneExist = new StringType(); // bb
          return this.ifNoneExist;
        }

        public boolean hasIfNoneExistElement() { 
          return this.ifNoneExist != null && !this.ifNoneExist.isEmpty();
        }

        public boolean hasIfNoneExist() { 
          return this.ifNoneExist != null && !this.ifNoneExist.isEmpty();
        }

        /**
         * @param value {@link #ifNoneExist} (Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for ["Conditional Create"](http.html#ccreate). This is just the query portion of the URL - what follows the "?" (not including the "?").). This is the underlying object with id, value and extensions. The accessor "getIfNoneExist" gives direct access to the value
         */
        public BundleEntryRequestComponent setIfNoneExistElement(StringType value) { 
          this.ifNoneExist = value;
          return this;
        }

        /**
         * @return Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for ["Conditional Create"](http.html#ccreate). This is just the query portion of the URL - what follows the "?" (not including the "?").
         */
        public String getIfNoneExist() { 
          return this.ifNoneExist == null ? null : this.ifNoneExist.getValue();
        }

        /**
         * @param value Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for ["Conditional Create"](http.html#ccreate). This is just the query portion of the URL - what follows the "?" (not including the "?").
         */
        public BundleEntryRequestComponent setIfNoneExist(String value) { 
          if (Utilities.noString(value))
            this.ifNoneExist = null;
          else {
            if (this.ifNoneExist == null)
              this.ifNoneExist = new StringType();
            this.ifNoneExist.setValue(value);
          }
          return this;
        }

        protected void listChildren(List<Property> children) {
          super.listChildren(children);
          children.add(new Property("method", "code", "In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.", 0, 1, method));
          children.add(new Property("url", "uri", "The URL for this entry, relative to the root (the address to which the request is posted).", 0, 1, url));
          children.add(new Property("ifNoneMatch", "string", "If the ETag values match, return a 304 Not Modified status. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, 1, ifNoneMatch));
          children.add(new Property("ifModifiedSince", "instant", "Only perform the operation if the last updated date matches. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, 1, ifModifiedSince));
          children.add(new Property("ifMatch", "string", "Only perform the operation if the Etag value matches. For more information, see the API section [\"Managing Resource Contention\"](http.html#concurrency).", 0, 1, ifMatch));
          children.add(new Property("ifNoneExist", "string", "Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for [\"Conditional Create\"](http.html#ccreate). This is just the query portion of the URL - what follows the \"?\" (not including the \"?\").", 0, 1, ifNoneExist));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
          switch (_hash) {
          case -1077554975: /*method*/  return new Property("method", "code", "In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.", 0, 1, method);
          case 116079: /*url*/  return new Property("url", "uri", "The URL for this entry, relative to the root (the address to which the request is posted).", 0, 1, url);
          case 171868368: /*ifNoneMatch*/  return new Property("ifNoneMatch", "string", "If the ETag values match, return a 304 Not Modified status. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, 1, ifNoneMatch);
          case -2061602860: /*ifModifiedSince*/  return new Property("ifModifiedSince", "instant", "Only perform the operation if the last updated date matches. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, 1, ifModifiedSince);
          case 1692894888: /*ifMatch*/  return new Property("ifMatch", "string", "Only perform the operation if the Etag value matches. For more information, see the API section [\"Managing Resource Contention\"](http.html#concurrency).", 0, 1, ifMatch);
          case 165155330: /*ifNoneExist*/  return new Property("ifNoneExist", "string", "Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for [\"Conditional Create\"](http.html#ccreate). This is just the query portion of the URL - what follows the \"?\" (not including the \"?\").", 0, 1, ifNoneExist);
          default: return super.getNamedProperty(_hash, _name, _checkValid);
          }

        }

      @Override
      public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
        case -1077554975: /*method*/ return this.method == null ? new Base[0] : new Base[] {this.method}; // Enumeration<HTTPVerb>
        case 116079: /*url*/ return this.url == null ? new Base[0] : new Base[] {this.url}; // UriType
        case 171868368: /*ifNoneMatch*/ return this.ifNoneMatch == null ? new Base[0] : new Base[] {this.ifNoneMatch}; // StringType
        case -2061602860: /*ifModifiedSince*/ return this.ifModifiedSince == null ? new Base[0] : new Base[] {this.ifModifiedSince}; // InstantType
        case 1692894888: /*ifMatch*/ return this.ifMatch == null ? new Base[0] : new Base[] {this.ifMatch}; // StringType
        case 165155330: /*ifNoneExist*/ return this.ifNoneExist == null ? new Base[0] : new Base[] {this.ifNoneExist}; // StringType
        default: return super.getProperty(hash, name, checkValid);
        }

      }

      @Override
      public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
        case -1077554975: // method
          value = new HTTPVerbEnumFactory().fromType(TypeConvertor.castToCode(value));
          this.method = (Enumeration) value; // Enumeration<HTTPVerb>
          return value;
        case 116079: // url
          this.url = TypeConvertor.castToUri(value); // UriType
          return value;
        case 171868368: // ifNoneMatch
          this.ifNoneMatch = TypeConvertor.castToString(value); // StringType
          return value;
        case -2061602860: // ifModifiedSince
          this.ifModifiedSince = TypeConvertor.castToInstant(value); // InstantType
          return value;
        case 1692894888: // ifMatch
          this.ifMatch = TypeConvertor.castToString(value); // StringType
          return value;
        case 165155330: // ifNoneExist
          this.ifNoneExist = TypeConvertor.castToString(value); // StringType
          return value;
        default: return super.setProperty(hash, name, value);
        }

      }

      @Override
      public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("method")) {
          value = new HTTPVerbEnumFactory().fromType(TypeConvertor.castToCode(value));
          this.method = (Enumeration) value; // Enumeration<HTTPVerb>
        } else if (name.equals("url")) {
          this.url = TypeConvertor.castToUri(value); // UriType
        } else if (name.equals("ifNoneMatch")) {
          this.ifNoneMatch = TypeConvertor.castToString(value); // StringType
        } else if (name.equals("ifModifiedSince")) {
          this.ifModifiedSince = TypeConvertor.castToInstant(value); // InstantType
        } else if (name.equals("ifMatch")) {
          this.ifMatch = TypeConvertor.castToString(value); // StringType
        } else if (name.equals("ifNoneExist")) {
          this.ifNoneExist = TypeConvertor.castToString(value); // StringType
        } else
          return super.setProperty(name, value);
        return value;
      }

      @Override
      public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
        case -1077554975:  return getMethodElement();
        case 116079:  return getUrlElement();
        case 171868368:  return getIfNoneMatchElement();
        case -2061602860:  return getIfModifiedSinceElement();
        case 1692894888:  return getIfMatchElement();
        case 165155330:  return getIfNoneExistElement();
        default: return super.makeProperty(hash, name);
        }

      }

      @Override
      public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
        case -1077554975: /*method*/ return new String[] {"code"};
        case 116079: /*url*/ return new String[] {"uri"};
        case 171868368: /*ifNoneMatch*/ return new String[] {"string"};
        case -2061602860: /*ifModifiedSince*/ return new String[] {"instant"};
        case 1692894888: /*ifMatch*/ return new String[] {"string"};
        case 165155330: /*ifNoneExist*/ return new String[] {"string"};
        default: return super.getTypesForProperty(hash, name);
        }

      }

      @Override
      public Base addChild(String name) throws FHIRException {
        if (name.equals("method")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.request.method");
        }
        else if (name.equals("url")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.request.url");
        }
        else if (name.equals("ifNoneMatch")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.request.ifNoneMatch");
        }
        else if (name.equals("ifModifiedSince")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.request.ifModifiedSince");
        }
        else if (name.equals("ifMatch")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.request.ifMatch");
        }
        else if (name.equals("ifNoneExist")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.request.ifNoneExist");
        }
        else
          return super.addChild(name);
      }

      public BundleEntryRequestComponent copy() {
        BundleEntryRequestComponent dst = new BundleEntryRequestComponent();
        copyValues(dst);
        return dst;
      }

      public void copyValues(BundleEntryRequestComponent dst) {
        super.copyValues(dst);
        dst.method = method == null ? null : method.copy();
        dst.url = url == null ? null : url.copy();
        dst.ifNoneMatch = ifNoneMatch == null ? null : ifNoneMatch.copy();
        dst.ifModifiedSince = ifModifiedSince == null ? null : ifModifiedSince.copy();
        dst.ifMatch = ifMatch == null ? null : ifMatch.copy();
        dst.ifNoneExist = ifNoneExist == null ? null : ifNoneExist.copy();
      }

      @Override
      public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_))
          return false;
        if (!(other_ instanceof BundleEntryRequestComponent))
          return false;
        BundleEntryRequestComponent o = (BundleEntryRequestComponent) other_;
        return compareDeep(method, o.method, true) && compareDeep(url, o.url, true) && compareDeep(ifNoneMatch, o.ifNoneMatch, true)
           && compareDeep(ifModifiedSince, o.ifModifiedSince, true) && compareDeep(ifMatch, o.ifMatch, true)
           && compareDeep(ifNoneExist, o.ifNoneExist, true);
      }

      @Override
      public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_))
          return false;
        if (!(other_ instanceof BundleEntryRequestComponent))
          return false;
        BundleEntryRequestComponent o = (BundleEntryRequestComponent) other_;
        return compareValues(method, o.method, true) && compareValues(url, o.url, true) && compareValues(ifNoneMatch, o.ifNoneMatch, true)
           && compareValues(ifModifiedSince, o.ifModifiedSince, true) && compareValues(ifMatch, o.ifMatch, true)
           && compareValues(ifNoneExist, o.ifNoneExist, true);
      }

      public boolean isEmpty() {
        return super.isEmpty() && ca.uhn.fhir.util.ElementUtil.isEmpty(method, url, ifNoneMatch
          , ifModifiedSince, ifMatch, ifNoneExist);
      }

  public String fhirType() {
    return "Bundle.entry.request";

  }

  }

    @Block()
    public static class BundleEntryResponseComponent extends BackboneElement implements IBaseBackboneElement {
        /**
         * The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.
         */
        @Child(name = "status", type = {StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Status response code (text optional)", formalDefinition="The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code." )
        protected StringType status;

        /**
         * The location header created by processing this operation, populated if the operation returns a location.
         */
        @Child(name = "location", type = {UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The location (if the operation returns a location)", formalDefinition="The location header created by processing this operation, populated if the operation returns a location." )
        protected UriType location;

        /**
         * The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).
         */
        @Child(name = "etag", type = {StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The Etag for the resource (if relevant)", formalDefinition="The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency))." )
        protected StringType etag;

        /**
         * The date/time that the resource was modified on the server.
         */
        @Child(name = "lastModified", type = {InstantType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Server's date time modified", formalDefinition="The date/time that the resource was modified on the server." )
        protected InstantType lastModified;

        /**
         * An OperationOutcome containing hints and warnings produced as part of processing this entry in a batch or transaction.
         */
        @Child(name = "outcome", type = {Resource.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="OperationOutcome with hints and warnings (for batch/transaction)", formalDefinition="An OperationOutcome containing hints and warnings produced as part of processing this entry in a batch or transaction." )
        protected Resource outcome;

        private static final long serialVersionUID = 923278008L;

    /**
     * Constructor
     */
      public BundleEntryResponseComponent() {
        super();
      }

    /**
     * Constructor
     */
      public BundleEntryResponseComponent(String status) {
        super();
        this.setStatus(status);
      }

        /**
         * @return {@link #status} (The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.). This is the underlying object with id, value and extensions. The accessor "getStatus" gives direct access to the value
         */
        public StringType getStatusElement() { 
          if (this.status == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryResponseComponent.status");
            else if (Configuration.doAutoCreate())
              this.status = new StringType(); // bb
          return this.status;
        }

        public boolean hasStatusElement() { 
          return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() { 
          return this.status != null && !this.status.isEmpty();
        }

        /**
         * @param value {@link #status} (The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.). This is the underlying object with id, value and extensions. The accessor "getStatus" gives direct access to the value
         */
        public BundleEntryResponseComponent setStatusElement(StringType value) { 
          this.status = value;
          return this;
        }

        /**
         * @return The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.
         */
        public String getStatus() { 
          return this.status == null ? null : this.status.getValue();
        }

        /**
         * @param value The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.
         */
        public BundleEntryResponseComponent setStatus(String value) { 
            if (this.status == null)
              this.status = new StringType();
            this.status.setValue(value);
          return this;
        }

        /**
         * @return {@link #location} (The location header created by processing this operation, populated if the operation returns a location.). This is the underlying object with id, value and extensions. The accessor "getLocation" gives direct access to the value
         */
        public UriType getLocationElement() { 
          if (this.location == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryResponseComponent.location");
            else if (Configuration.doAutoCreate())
              this.location = new UriType(); // bb
          return this.location;
        }

        public boolean hasLocationElement() { 
          return this.location != null && !this.location.isEmpty();
        }

        public boolean hasLocation() { 
          return this.location != null && !this.location.isEmpty();
        }

        /**
         * @param value {@link #location} (The location header created by processing this operation, populated if the operation returns a location.). This is the underlying object with id, value and extensions. The accessor "getLocation" gives direct access to the value
         */
        public BundleEntryResponseComponent setLocationElement(UriType value) { 
          this.location = value;
          return this;
        }

        /**
         * @return The location header created by processing this operation, populated if the operation returns a location.
         */
        public String getLocation() { 
          return this.location == null ? null : this.location.getValue();
        }

        /**
         * @param value The location header created by processing this operation, populated if the operation returns a location.
         */
        public BundleEntryResponseComponent setLocation(String value) { 
          if (Utilities.noString(value))
            this.location = null;
          else {
            if (this.location == null)
              this.location = new UriType();
            this.location.setValue(value);
          }
          return this;
        }

        /**
         * @return {@link #etag} (The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).). This is the underlying object with id, value and extensions. The accessor "getEtag" gives direct access to the value
         */
        public StringType getEtagElement() { 
          if (this.etag == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryResponseComponent.etag");
            else if (Configuration.doAutoCreate())
              this.etag = new StringType(); // bb
          return this.etag;
        }

        public boolean hasEtagElement() { 
          return this.etag != null && !this.etag.isEmpty();
        }

        public boolean hasEtag() { 
          return this.etag != null && !this.etag.isEmpty();
        }

        /**
         * @param value {@link #etag} (The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).). This is the underlying object with id, value and extensions. The accessor "getEtag" gives direct access to the value
         */
        public BundleEntryResponseComponent setEtagElement(StringType value) { 
          this.etag = value;
          return this;
        }

        /**
         * @return The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).
         */
        public String getEtag() { 
          return this.etag == null ? null : this.etag.getValue();
        }

        /**
         * @param value The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).
         */
        public BundleEntryResponseComponent setEtag(String value) { 
          if (Utilities.noString(value))
            this.etag = null;
          else {
            if (this.etag == null)
              this.etag = new StringType();
            this.etag.setValue(value);
          }
          return this;
        }

        /**
         * @return {@link #lastModified} (The date/time that the resource was modified on the server.). This is the underlying object with id, value and extensions. The accessor "getLastModified" gives direct access to the value
         */
        public InstantType getLastModifiedElement() { 
          if (this.lastModified == null)
            if (Configuration.errorOnAutoCreate())
              throw new Error("Attempt to auto-create BundleEntryResponseComponent.lastModified");
            else if (Configuration.doAutoCreate())
              this.lastModified = new InstantType(); // bb
          return this.lastModified;
        }

        public boolean hasLastModifiedElement() { 
          return this.lastModified != null && !this.lastModified.isEmpty();
        }

        public boolean hasLastModified() { 
          return this.lastModified != null && !this.lastModified.isEmpty();
        }

        /**
         * @param value {@link #lastModified} (The date/time that the resource was modified on the server.). This is the underlying object with id, value and extensions. The accessor "getLastModified" gives direct access to the value
         */
        public BundleEntryResponseComponent setLastModifiedElement(InstantType value) { 
          this.lastModified = value;
          return this;
        }

        /**
         * @return The date/time that the resource was modified on the server.
         */
        public Date getLastModified() { 
          return this.lastModified == null ? null : this.lastModified.getValue();
        }

        /**
         * @param value The date/time that the resource was modified on the server.
         */
        public BundleEntryResponseComponent setLastModified(Date value) { 
          if (value == null)
            this.lastModified = null;
          else {
            if (this.lastModified == null)
              this.lastModified = new InstantType();
            this.lastModified.setValue(value);
          }
          return this;
        }

        /**
         * @return {@link #outcome} (An OperationOutcome containing hints and warnings produced as part of processing this entry in a batch or transaction.)
         */
        public Resource getOutcome() { 
          return this.outcome;
        }

        public boolean hasOutcome() { 
          return this.outcome != null && !this.outcome.isEmpty();
        }

        /**
         * @param value {@link #outcome} (An OperationOutcome containing hints and warnings produced as part of processing this entry in a batch or transaction.)
         */
        public BundleEntryResponseComponent setOutcome(Resource value) { 
          this.outcome = value;
          return this;
        }

        protected void listChildren(List<Property> children) {
          super.listChildren(children);
          children.add(new Property("status", "string", "The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.", 0, 1, status));
          children.add(new Property("location", "uri", "The location header created by processing this operation, populated if the operation returns a location.", 0, 1, location));
          children.add(new Property("etag", "string", "The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).", 0, 1, etag));
          children.add(new Property("lastModified", "instant", "The date/time that the resource was modified on the server.", 0, 1, lastModified));
          children.add(new Property("outcome", "Resource", "An OperationOutcome containing hints and warnings produced as part of processing this entry in a batch or transaction.", 0, 1, outcome));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
          switch (_hash) {
          case -892481550: /*status*/  return new Property("status", "string", "The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.", 0, 1, status);
          case 1901043637: /*location*/  return new Property("location", "uri", "The location header created by processing this operation, populated if the operation returns a location.", 0, 1, location);
          case 3123477: /*etag*/  return new Property("etag", "string", "The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).", 0, 1, etag);
          case 1959003007: /*lastModified*/  return new Property("lastModified", "instant", "The date/time that the resource was modified on the server.", 0, 1, lastModified);
          case -1106507950: /*outcome*/  return new Property("outcome", "Resource", "An OperationOutcome containing hints and warnings produced as part of processing this entry in a batch or transaction.", 0, 1, outcome);
          default: return super.getNamedProperty(_hash, _name, _checkValid);
          }

        }

      @Override
      public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
        case -892481550: /*status*/ return this.status == null ? new Base[0] : new Base[] {this.status}; // StringType
        case 1901043637: /*location*/ return this.location == null ? new Base[0] : new Base[] {this.location}; // UriType
        case 3123477: /*etag*/ return this.etag == null ? new Base[0] : new Base[] {this.etag}; // StringType
        case 1959003007: /*lastModified*/ return this.lastModified == null ? new Base[0] : new Base[] {this.lastModified}; // InstantType
        case -1106507950: /*outcome*/ return this.outcome == null ? new Base[0] : new Base[] {this.outcome}; // Resource
        default: return super.getProperty(hash, name, checkValid);
        }

      }

      @Override
      public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
        case -892481550: // status
          this.status = TypeConvertor.castToString(value); // StringType
          return value;
        case 1901043637: // location
          this.location = TypeConvertor.castToUri(value); // UriType
          return value;
        case 3123477: // etag
          this.etag = TypeConvertor.castToString(value); // StringType
          return value;
        case 1959003007: // lastModified
          this.lastModified = TypeConvertor.castToInstant(value); // InstantType
          return value;
        case -1106507950: // outcome
          this.outcome = TypeConvertor.castToResource(value); // Resource
          return value;
        default: return super.setProperty(hash, name, value);
        }

      }

      @Override
      public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("status")) {
          this.status = TypeConvertor.castToString(value); // StringType
        } else if (name.equals("location")) {
          this.location = TypeConvertor.castToUri(value); // UriType
        } else if (name.equals("etag")) {
          this.etag = TypeConvertor.castToString(value); // StringType
        } else if (name.equals("lastModified")) {
          this.lastModified = TypeConvertor.castToInstant(value); // InstantType
        } else if (name.equals("outcome")) {
          this.outcome = TypeConvertor.castToResource(value); // Resource
        } else
          return super.setProperty(name, value);
        return value;
      }

      @Override
      public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
        case -892481550:  return getStatusElement();
        case 1901043637:  return getLocationElement();
        case 3123477:  return getEtagElement();
        case 1959003007:  return getLastModifiedElement();
        case -1106507950: throw new FHIRException("Cannot make property outcome as it is not a complex type"); // Resource
        default: return super.makeProperty(hash, name);
        }

      }

      @Override
      public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
        case -892481550: /*status*/ return new String[] {"string"};
        case 1901043637: /*location*/ return new String[] {"uri"};
        case 3123477: /*etag*/ return new String[] {"string"};
        case 1959003007: /*lastModified*/ return new String[] {"instant"};
        case -1106507950: /*outcome*/ return new String[] {"Resource"};
        default: return super.getTypesForProperty(hash, name);
        }

      }

      @Override
      public Base addChild(String name) throws FHIRException {
        if (name.equals("status")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.response.status");
        }
        else if (name.equals("location")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.response.location");
        }
        else if (name.equals("etag")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.response.etag");
        }
        else if (name.equals("lastModified")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.entry.response.lastModified");
        }
        else if (name.equals("outcome")) {
          throw new FHIRException("Cannot call addChild on an abstract type Bundle.entry.response.outcome");
        }
        else
          return super.addChild(name);
      }

      public BundleEntryResponseComponent copy() {
        BundleEntryResponseComponent dst = new BundleEntryResponseComponent();
        copyValues(dst);
        return dst;
      }

      public void copyValues(BundleEntryResponseComponent dst) {
        super.copyValues(dst);
        dst.status = status == null ? null : status.copy();
        dst.location = location == null ? null : location.copy();
        dst.etag = etag == null ? null : etag.copy();
        dst.lastModified = lastModified == null ? null : lastModified.copy();
        dst.outcome = outcome == null ? null : outcome.copy();
      }

      @Override
      public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_))
          return false;
        if (!(other_ instanceof BundleEntryResponseComponent))
          return false;
        BundleEntryResponseComponent o = (BundleEntryResponseComponent) other_;
        return compareDeep(status, o.status, true) && compareDeep(location, o.location, true) && compareDeep(etag, o.etag, true)
           && compareDeep(lastModified, o.lastModified, true) && compareDeep(outcome, o.outcome, true);
      }

      @Override
      public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_))
          return false;
        if (!(other_ instanceof BundleEntryResponseComponent))
          return false;
        BundleEntryResponseComponent o = (BundleEntryResponseComponent) other_;
        return compareValues(status, o.status, true) && compareValues(location, o.location, true) && compareValues(etag, o.etag, true)
           && compareValues(lastModified, o.lastModified, true);
      }

      public boolean isEmpty() {
        return super.isEmpty() && ca.uhn.fhir.util.ElementUtil.isEmpty(status, location, etag, lastModified
          , outcome);
      }

  public String fhirType() {
    return "Bundle.entry.response";

  }

  }

    /**
     * A persistent identifier for the bundle that won't change as a bundle is copied from server to server.
     */
    @Child(name = "identifier", type = {Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Persistent identifier for the bundle", formalDefinition="A persistent identifier for the bundle that won't change as a bundle is copied from server to server." )
    protected Identifier identifier;

    /**
     * Indicates the purpose of this bundle - how it is intended to be used.
     */
    @Child(name = "type", type = {CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="document | message | transaction | transaction-response | batch | batch-response | history | searchset | collection | subscription-notification", formalDefinition="Indicates the purpose of this bundle - how it is intended to be used." )
    @ca.uhn.fhir.model.api.annotation.Binding(valueSet="http://hl7.org/fhir/ValueSet/bundle-type")
    protected Enumeration<BundleType> type;

    /**
     * The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.
     */
    @Child(name = "timestamp", type = {InstantType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the bundle was assembled", formalDefinition="The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle." )
    protected InstantType timestamp;

    /**
     * If a set of search matches, this is the (potentially estimated) total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.
     */
    @Child(name = "total", type = {UnsignedIntType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If search, the total number of matches", formalDefinition="If a set of search matches, this is the (potentially estimated) total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle." )
    protected UnsignedIntType total;

    /**
     * A series of links that provide context to this bundle.
     */
    @Child(name = "link", type = {}, order=4, min=0, max=Child.MAX_UNLIMITED, modifier=false, summary=true)
    @Description(shortDefinition="Links related to this Bundle", formalDefinition="A series of links that provide context to this bundle." )
    protected List<BundleLinkComponent> link;

    /**
     * An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).
     */
    @Child(name = "entry", type = {}, order=5, min=0, max=Child.MAX_UNLIMITED, modifier=false, summary=true)
    @Description(shortDefinition="Entry in the bundle - will have a resource or information", formalDefinition="An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only)." )
    protected List<BundleEntryComponent> entry;

    /**
     * Digital Signature - base64 encoded. XML-DSig or a JWS.
     */
    @Child(name = "signature", type = {Signature.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Digital Signature", formalDefinition="Digital Signature - base64 encoded. XML-DSig or a JWS." )
    protected Signature signature;

    /**
     * Captures issues and warnings that relate to the construction of the Bundle and the content within it.
     */
    @Child(name = "issues", type = {Resource.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Issues with the Bundle", formalDefinition="Captures issues and warnings that relate to the construction of the Bundle and the content within it." )
    protected Resource issues;

    private static final long serialVersionUID = -843739668L;

  /**
   * Constructor
   */
    public Bundle() {
      super();
    }

  /**
   * Constructor
   */
    public Bundle(BundleType type) {
      super();
      this.setType(type);
    }

    /**
     * @return {@link #identifier} (A persistent identifier for the bundle that won't change as a bundle is copied from server to server.)
     */
    public Identifier getIdentifier() { 
      if (this.identifier == null)
        if (Configuration.errorOnAutoCreate())
          throw new Error("Attempt to auto-create Bundle.identifier");
        else if (Configuration.doAutoCreate())
          this.identifier = new Identifier(); // cc
      return this.identifier;
    }

    public boolean hasIdentifier() { 
      return this.identifier != null && !this.identifier.isEmpty();
    }

    /**
     * @param value {@link #identifier} (A persistent identifier for the bundle that won't change as a bundle is copied from server to server.)
     */
    public Bundle setIdentifier(Identifier value) { 
      this.identifier = value;
      return this;
    }

    /**
     * @return {@link #type} (Indicates the purpose of this bundle - how it is intended to be used.). This is the underlying object with id, value and extensions. The accessor "getType" gives direct access to the value
     */
    public Enumeration<BundleType> getTypeElement() { 
      if (this.type == null)
        if (Configuration.errorOnAutoCreate())
          throw new Error("Attempt to auto-create Bundle.type");
        else if (Configuration.doAutoCreate())
          this.type = new Enumeration<BundleType>(new BundleTypeEnumFactory()); // bb
      return this.type;
    }

    public boolean hasTypeElement() { 
      return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() { 
      return this.type != null && !this.type.isEmpty();
    }

    /**
     * @param value {@link #type} (Indicates the purpose of this bundle - how it is intended to be used.). This is the underlying object with id, value and extensions. The accessor "getType" gives direct access to the value
     */
    public Bundle setTypeElement(Enumeration<BundleType> value) { 
      this.type = value;
      return this;
    }

    /**
     * @return Indicates the purpose of this bundle - how it is intended to be used.
     */
    public BundleType getType() { 
      return this.type == null ? null : this.type.getValue();
    }

    /**
     * @param value Indicates the purpose of this bundle - how it is intended to be used.
     */
    public Bundle setType(BundleType value) { 
        if (this.type == null)
          this.type = new Enumeration<BundleType>(new BundleTypeEnumFactory());
        this.type.setValue(value);
      return this;
    }

    /**
     * @return {@link #timestamp} (The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.). This is the underlying object with id, value and extensions. The accessor "getTimestamp" gives direct access to the value
     */
    public InstantType getTimestampElement() { 
      if (this.timestamp == null)
        if (Configuration.errorOnAutoCreate())
          throw new Error("Attempt to auto-create Bundle.timestamp");
        else if (Configuration.doAutoCreate())
          this.timestamp = new InstantType(); // bb
      return this.timestamp;
    }

    public boolean hasTimestampElement() { 
      return this.timestamp != null && !this.timestamp.isEmpty();
    }

    public boolean hasTimestamp() { 
      return this.timestamp != null && !this.timestamp.isEmpty();
    }

    /**
     * @param value {@link #timestamp} (The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.). This is the underlying object with id, value and extensions. The accessor "getTimestamp" gives direct access to the value
     */
    public Bundle setTimestampElement(InstantType value) { 
      this.timestamp = value;
      return this;
    }

    /**
     * @return The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.
     */
    public Date getTimestamp() { 
      return this.timestamp == null ? null : this.timestamp.getValue();
    }

    /**
     * @param value The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.
     */
    public Bundle setTimestamp(Date value) { 
      if (value == null)
        this.timestamp = null;
      else {
        if (this.timestamp == null)
          this.timestamp = new InstantType();
        this.timestamp.setValue(value);
      }
      return this;
    }

    /**
     * @return {@link #total} (If a set of search matches, this is the (potentially estimated) total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.). This is the underlying object with id, value and extensions. The accessor "getTotal" gives direct access to the value
     */
    public UnsignedIntType getTotalElement() { 
      if (this.total == null)
        if (Configuration.errorOnAutoCreate())
          throw new Error("Attempt to auto-create Bundle.total");
        else if (Configuration.doAutoCreate())
          this.total = new UnsignedIntType(); // bb
      return this.total;
    }

    public boolean hasTotalElement() { 
      return this.total != null && !this.total.isEmpty();
    }

    public boolean hasTotal() { 
      return this.total != null && !this.total.isEmpty();
    }

    /**
     * @param value {@link #total} (If a set of search matches, this is the (potentially estimated) total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.). This is the underlying object with id, value and extensions. The accessor "getTotal" gives direct access to the value
     */
    public Bundle setTotalElement(UnsignedIntType value) { 
      this.total = value;
      return this;
    }

    /**
     * @return If a set of search matches, this is the (potentially estimated) total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.
     */
    public int getTotal() { 
      return this.total == null || this.total.isEmpty() ? 0 : this.total.getValue();
    }

    /**
     * @param value If a set of search matches, this is the (potentially estimated) total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.
     */
    public Bundle setTotal(int value) { 
        if (this.total == null)
          this.total = new UnsignedIntType();
        this.total.setValue(value);
      return this;
    }

    /**
     * @return {@link #link} (A series of links that provide context to this bundle.)
     */
    public List<BundleLinkComponent> getLink() { 
      if (this.link == null)
        this.link = new ArrayList<BundleLinkComponent>();
      return this.link;
    }

    /**
     * @return Returns a reference to <code>this</code> for easy method chaining
     */
    public Bundle setLink(List<BundleLinkComponent> theLink) { 
      this.link = theLink;
      return this;
    }

    public boolean hasLink() { 
      if (this.link == null)
        return false;
      for (BundleLinkComponent item : this.link)
        if (!item.isEmpty())
          return true;
      return false;
    }

    public BundleLinkComponent addLink() { //3
      BundleLinkComponent t = new BundleLinkComponent();
      if (this.link == null)
        this.link = new ArrayList<BundleLinkComponent>();
      this.link.add(t);
      return t;
    }

    public Bundle addLink(BundleLinkComponent t) { //3
      if (t == null)
        return this;
      if (this.link == null)
        this.link = new ArrayList<BundleLinkComponent>();
      this.link.add(t);
      return this;
    }

    /**
     * @return The first repetition of repeating field {@link #link}, creating it if it does not already exist {3}
     */
    public BundleLinkComponent getLinkFirstRep() { 
      if (getLink().isEmpty()) {
        addLink();
      }
      return getLink().get(0);
    }

    /**
     * @return {@link #entry} (An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).)
     */
    public List<BundleEntryComponent> getEntry() { 
      if (this.entry == null)
        this.entry = new ArrayList<BundleEntryComponent>();
      return this.entry;
    }

    /**
     * @return Returns a reference to <code>this</code> for easy method chaining
     */
    public Bundle setEntry(List<BundleEntryComponent> theEntry) { 
      this.entry = theEntry;
      return this;
    }

    public boolean hasEntry() { 
      if (this.entry == null)
        return false;
      for (BundleEntryComponent item : this.entry)
        if (!item.isEmpty())
          return true;
      return false;
    }

    public BundleEntryComponent addEntry() { //3
      BundleEntryComponent t = new BundleEntryComponent();
      if (this.entry == null)
        this.entry = new ArrayList<BundleEntryComponent>();
      this.entry.add(t);
      return t;
    }

    public Bundle addEntry(BundleEntryComponent t) { //3
      if (t == null)
        return this;
      if (this.entry == null)
        this.entry = new ArrayList<BundleEntryComponent>();
      this.entry.add(t);
      return this;
    }

    /**
     * @return The first repetition of repeating field {@link #entry}, creating it if it does not already exist {3}
     */
    public BundleEntryComponent getEntryFirstRep() { 
      if (getEntry().isEmpty()) {
        addEntry();
      }
      return getEntry().get(0);
    }

    /**
     * @return {@link #signature} (Digital Signature - base64 encoded. XML-DSig or a JWS.)
     */
    public Signature getSignature() { 
      if (this.signature == null)
        if (Configuration.errorOnAutoCreate())
          throw new Error("Attempt to auto-create Bundle.signature");
        else if (Configuration.doAutoCreate())
          this.signature = new Signature(); // cc
      return this.signature;
    }

    public boolean hasSignature() { 
      return this.signature != null && !this.signature.isEmpty();
    }

    /**
     * @param value {@link #signature} (Digital Signature - base64 encoded. XML-DSig or a JWS.)
     */
    public Bundle setSignature(Signature value) { 
      this.signature = value;
      return this;
    }

    /**
     * @return {@link #issues} (Captures issues and warnings that relate to the construction of the Bundle and the content within it.)
     */
    public Resource getIssues() { 
      return this.issues;
    }

    public boolean hasIssues() { 
      return this.issues != null && !this.issues.isEmpty();
    }

    /**
     * @param value {@link #issues} (Captures issues and warnings that relate to the construction of the Bundle and the content within it.)
     */
    public Bundle setIssues(Resource value) { 
      this.issues = value;
      return this;
    }

      protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "A persistent identifier for the bundle that won't change as a bundle is copied from server to server.", 0, 1, identifier));
        children.add(new Property("type", "code", "Indicates the purpose of this bundle - how it is intended to be used.", 0, 1, type));
        children.add(new Property("timestamp", "instant", "The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.", 0, 1, timestamp));
        children.add(new Property("total", "unsignedInt", "If a set of search matches, this is the (potentially estimated) total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.", 0, 1, total));
        children.add(new Property("link", "", "A series of links that provide context to this bundle.", 0, java.lang.Integer.MAX_VALUE, link));
        children.add(new Property("entry", "", "An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).", 0, java.lang.Integer.MAX_VALUE, entry));
        children.add(new Property("signature", "Signature", "Digital Signature - base64 encoded. XML-DSig or a JWS.", 0, 1, signature));
        children.add(new Property("issues", "Resource", "Captures issues and warnings that relate to the construction of the Bundle and the content within it.", 0, 1, issues));
      }

      @Override
      public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
        case -1618432855: /*identifier*/  return new Property("identifier", "Identifier", "A persistent identifier for the bundle that won't change as a bundle is copied from server to server.", 0, 1, identifier);
        case 3575610: /*type*/  return new Property("type", "code", "Indicates the purpose of this bundle - how it is intended to be used.", 0, 1, type);
        case 55126294: /*timestamp*/  return new Property("timestamp", "instant", "The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.", 0, 1, timestamp);
        case 110549828: /*total*/  return new Property("total", "unsignedInt", "If a set of search matches, this is the (potentially estimated) total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.", 0, 1, total);
        case 3321850: /*link*/  return new Property("link", "", "A series of links that provide context to this bundle.", 0, java.lang.Integer.MAX_VALUE, link);
        case 96667762: /*entry*/  return new Property("entry", "", "An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).", 0, java.lang.Integer.MAX_VALUE, entry);
        case 1073584312: /*signature*/  return new Property("signature", "Signature", "Digital Signature - base64 encoded. XML-DSig or a JWS.", 0, 1, signature);
        case -1179159878: /*issues*/  return new Property("issues", "Resource", "Captures issues and warnings that relate to the construction of the Bundle and the content within it.", 0, 1, issues);
        default: return super.getNamedProperty(_hash, _name, _checkValid);
        }

      }

      @Override
      public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
        case -1618432855: /*identifier*/ return this.identifier == null ? new Base[0] : new Base[] {this.identifier}; // Identifier
        case 3575610: /*type*/ return this.type == null ? new Base[0] : new Base[] {this.type}; // Enumeration<BundleType>
        case 55126294: /*timestamp*/ return this.timestamp == null ? new Base[0] : new Base[] {this.timestamp}; // InstantType
        case 110549828: /*total*/ return this.total == null ? new Base[0] : new Base[] {this.total}; // UnsignedIntType
        case 3321850: /*link*/ return this.link == null ? new Base[0] : this.link.toArray(new Base[this.link.size()]); // BundleLinkComponent
        case 96667762: /*entry*/ return this.entry == null ? new Base[0] : this.entry.toArray(new Base[this.entry.size()]); // BundleEntryComponent
        case 1073584312: /*signature*/ return this.signature == null ? new Base[0] : new Base[] {this.signature}; // Signature
        case -1179159878: /*issues*/ return this.issues == null ? new Base[0] : new Base[] {this.issues}; // Resource
        default: return super.getProperty(hash, name, checkValid);
        }

      }

      @Override
      public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
        case -1618432855: // identifier
          this.identifier = TypeConvertor.castToIdentifier(value); // Identifier
          return value;
        case 3575610: // type
          value = new BundleTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
          this.type = (Enumeration) value; // Enumeration<BundleType>
          return value;
        case 55126294: // timestamp
          this.timestamp = TypeConvertor.castToInstant(value); // InstantType
          return value;
        case 110549828: // total
          this.total = TypeConvertor.castToUnsignedInt(value); // UnsignedIntType
          return value;
        case 3321850: // link
          this.getLink().add((BundleLinkComponent) value); // BundleLinkComponent
          return value;
        case 96667762: // entry
          this.getEntry().add((BundleEntryComponent) value); // BundleEntryComponent
          return value;
        case 1073584312: // signature
          this.signature = TypeConvertor.castToSignature(value); // Signature
          return value;
        case -1179159878: // issues
          this.issues = TypeConvertor.castToResource(value); // Resource
          return value;
        default: return super.setProperty(hash, name, value);
        }

      }

      @Override
      public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
          this.identifier = TypeConvertor.castToIdentifier(value); // Identifier
        } else if (name.equals("type")) {
          value = new BundleTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
          this.type = (Enumeration) value; // Enumeration<BundleType>
        } else if (name.equals("timestamp")) {
          this.timestamp = TypeConvertor.castToInstant(value); // InstantType
        } else if (name.equals("total")) {
          this.total = TypeConvertor.castToUnsignedInt(value); // UnsignedIntType
        } else if (name.equals("link")) {
          this.getLink().add((BundleLinkComponent) value);
        } else if (name.equals("entry")) {
          this.getEntry().add((BundleEntryComponent) value);
        } else if (name.equals("signature")) {
          this.signature = TypeConvertor.castToSignature(value); // Signature
        } else if (name.equals("issues")) {
          this.issues = TypeConvertor.castToResource(value); // Resource
        } else
          return super.setProperty(name, value);
        return value;
      }

      @Override
      public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
        case -1618432855:  return getIdentifier();
        case 3575610:  return getTypeElement();
        case 55126294:  return getTimestampElement();
        case 110549828:  return getTotalElement();
        case 3321850:  return addLink(); 
        case 96667762:  return addEntry(); 
        case 1073584312:  return getSignature();
        case -1179159878: throw new FHIRException("Cannot make property issues as it is not a complex type"); // Resource
        default: return super.makeProperty(hash, name);
        }

      }

      @Override
      public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
        case -1618432855: /*identifier*/ return new String[] {"Identifier"};
        case 3575610: /*type*/ return new String[] {"code"};
        case 55126294: /*timestamp*/ return new String[] {"instant"};
        case 110549828: /*total*/ return new String[] {"unsignedInt"};
        case 3321850: /*link*/ return new String[] {};
        case 96667762: /*entry*/ return new String[] {};
        case 1073584312: /*signature*/ return new String[] {"Signature"};
        case -1179159878: /*issues*/ return new String[] {"Resource"};
        default: return super.getTypesForProperty(hash, name);
        }

      }

      @Override
      public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
          this.identifier = new Identifier();
          return this.identifier;
        }
        else if (name.equals("type")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.type");
        }
        else if (name.equals("timestamp")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.timestamp");
        }
        else if (name.equals("total")) {
          throw new FHIRException("Cannot call addChild on a singleton property Bundle.total");
        }
        else if (name.equals("link")) {
          return addLink();
        }
        else if (name.equals("entry")) {
          return addEntry();
        }
        else if (name.equals("signature")) {
          this.signature = new Signature();
          return this.signature;
        }
        else if (name.equals("issues")) {
          throw new FHIRException("Cannot call addChild on an abstract type Bundle.issues");
        }
        else
          return super.addChild(name);
      }

  public String fhirType() {
    return "Bundle";

  }

      public Bundle copy() {
        Bundle dst = new Bundle();
        copyValues(dst);
        return dst;
      }

      public void copyValues(Bundle dst) {
        super.copyValues(dst);
        dst.identifier = identifier == null ? null : identifier.copy();
        dst.type = type == null ? null : type.copy();
        dst.timestamp = timestamp == null ? null : timestamp.copy();
        dst.total = total == null ? null : total.copy();
        if (link != null) {
          dst.link = new ArrayList<BundleLinkComponent>();
          for (BundleLinkComponent i : link)
            dst.link.add(i.copy());
        };
        if (entry != null) {
          dst.entry = new ArrayList<BundleEntryComponent>();
          for (BundleEntryComponent i : entry)
            dst.entry.add(i.copy());
        };
        dst.signature = signature == null ? null : signature.copy();
        dst.issues = issues == null ? null : issues.copy();
      }

      protected Bundle typedCopy() {
        return copy();
      }

      @Override
      public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_))
          return false;
        if (!(other_ instanceof Bundle))
          return false;
        Bundle o = (Bundle) other_;
        return compareDeep(identifier, o.identifier, true) && compareDeep(type, o.type, true) && compareDeep(timestamp, o.timestamp, true)
           && compareDeep(total, o.total, true) && compareDeep(link, o.link, true) && compareDeep(entry, o.entry, true)
           && compareDeep(signature, o.signature, true) && compareDeep(issues, o.issues, true);
      }

      @Override
      public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_))
          return false;
        if (!(other_ instanceof Bundle))
          return false;
        Bundle o = (Bundle) other_;
        return compareValues(type, o.type, true) && compareValues(timestamp, o.timestamp, true) && compareValues(total, o.total, true)
          ;
      }

      public boolean isEmpty() {
        return super.isEmpty() && ca.uhn.fhir.util.ElementUtil.isEmpty(identifier, type, timestamp
          , total, link, entry, signature, issues);
      }

  @Override
  public ResourceType getResourceType() {
    return ResourceType.Bundle;
   }

 /**
   * Search parameter: <b>composition</b>
   * <p>
   * Description: <b>The first resource in the bundle, if the bundle type is "document" - this is a composition, and this parameter provides access to search its contents</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Bundle.entry[0].resource as Composition</b><br>
   * </p>
   */
  @SearchParamDefinition(name="composition", path="Bundle.entry[0].resource as Composition", description="The first resource in the bundle, if the bundle type is \"document\" - this is a composition, and this parameter provides access to search its contents", type="reference", target={Composition.class } )
  public static final String SP_COMPOSITION = "composition";
 /**
   * <b>Fluent Client</b> search parameter constant for <b>composition</b>
   * <p>
   * Description: <b>The first resource in the bundle, if the bundle type is "document" - this is a composition, and this parameter provides access to search its contents</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Bundle.entry[0].resource as Composition</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.ReferenceClientParam COMPOSITION = new ca.uhn.fhir.rest.gclient.ReferenceClientParam(SP_COMPOSITION);

/**
   * Constant for fluent queries to be used to add include statements. Specifies
   * the path value of "<b>Bundle:composition</b>".
   */
  public static final ca.uhn.fhir.model.api.Include INCLUDE_COMPOSITION = new ca.uhn.fhir.model.api.Include("Bundle:composition").toLocked();

 /**
   * Search parameter: <b>identifier</b>
   * <p>
   * Description: <b>Persistent identifier for the bundle</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Bundle.identifier</b><br>
   * </p>
   */
  @SearchParamDefinition(name="identifier", path="Bundle.identifier", description="Persistent identifier for the bundle", type="token" )
  public static final String SP_IDENTIFIER = "identifier";
 /**
   * <b>Fluent Client</b> search parameter constant for <b>identifier</b>
   * <p>
   * Description: <b>Persistent identifier for the bundle</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Bundle.identifier</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam IDENTIFIER = new ca.uhn.fhir.rest.gclient.TokenClientParam(SP_IDENTIFIER);

 /**
   * Search parameter: <b>message</b>
   * <p>
   * Description: <b>The first resource in the bundle, if the bundle type is "message" - this is a message header, and this parameter provides access to search its contents</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Bundle.entry[0].resource as MessageHeader</b><br>
   * </p>
   */
  @SearchParamDefinition(name="message", path="Bundle.entry[0].resource as MessageHeader", description="The first resource in the bundle, if the bundle type is \"message\" - this is a message header, and this parameter provides access to search its contents", type="reference", target={MessageHeader.class } )
  public static final String SP_MESSAGE = "message";
 /**
   * <b>Fluent Client</b> search parameter constant for <b>message</b>
   * <p>
   * Description: <b>The first resource in the bundle, if the bundle type is "message" - this is a message header, and this parameter provides access to search its contents</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Bundle.entry[0].resource as MessageHeader</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.ReferenceClientParam MESSAGE = new ca.uhn.fhir.rest.gclient.ReferenceClientParam(SP_MESSAGE);

/**
   * Constant for fluent queries to be used to add include statements. Specifies
   * the path value of "<b>Bundle:message</b>".
   */
  public static final ca.uhn.fhir.model.api.Include INCLUDE_MESSAGE = new ca.uhn.fhir.model.api.Include("Bundle:message").toLocked();

 /**
   * Search parameter: <b>timestamp</b>
   * <p>
   * Description: <b>When the bundle was assembled</b><br>
   * Type: <b>date</b><br>
   * Path: <b>Bundle.timestamp</b><br>
   * </p>
   */
  @SearchParamDefinition(name="timestamp", path="Bundle.timestamp", description="When the bundle was assembled", type="date" )
  public static final String SP_TIMESTAMP = "timestamp";
 /**
   * <b>Fluent Client</b> search parameter constant for <b>timestamp</b>
   * <p>
   * Description: <b>When the bundle was assembled</b><br>
   * Type: <b>date</b><br>
   * Path: <b>Bundle.timestamp</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.DateClientParam TIMESTAMP = new ca.uhn.fhir.rest.gclient.DateClientParam(SP_TIMESTAMP);

 /**
   * Search parameter: <b>type</b>
   * <p>
   * Description: <b>document | message | transaction | transaction-response | batch | batch-response | history | searchset | collection | subscription-notification</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Bundle.type</b><br>
   * </p>
   */
  @SearchParamDefinition(name="type", path="Bundle.type", description="document | message | transaction | transaction-response | batch | batch-response | history | searchset | collection | subscription-notification", type="token" )
  public static final String SP_TYPE = "type";
 /**
   * <b>Fluent Client</b> search parameter constant for <b>type</b>
   * <p>
   * Description: <b>document | message | transaction | transaction-response | batch | batch-response | history | searchset | collection | subscription-notification</b><br>
   * Type: <b>token</b><br>
   * Path: <b>Bundle.type</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.TokenClientParam TYPE = new ca.uhn.fhir.rest.gclient.TokenClientParam(SP_TYPE);

 /**
   * Search parameter: <b>example-constraint</b>
   * <p>
   * Description: <b>Search Composition Bundle</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Bundle.entry[0].resource</b><br>
   * </p>
   */
  @SearchParamDefinition(name="example-constraint", path="Bundle.entry[0].resource", description="Search Composition Bundle", type="reference", target={Composition.class } )
  public static final String SP_EXAMPLE_CONSTRAINT = "example-constraint";
 /**
   * <b>Fluent Client</b> search parameter constant for <b>example-constraint</b>
   * <p>
   * Description: <b>Search Composition Bundle</b><br>
   * Type: <b>reference</b><br>
   * Path: <b>Bundle.entry[0].resource</b><br>
   * </p>
   */
  public static final ca.uhn.fhir.rest.gclient.ReferenceClientParam EXAMPLE_CONSTRAINT = new ca.uhn.fhir.rest.gclient.ReferenceClientParam(SP_EXAMPLE_CONSTRAINT);

/**
   * Constant for fluent queries to be used to add include statements. Specifies
   * the path value of "<b>Bundle:example-constraint</b>".
   */
  public static final ca.uhn.fhir.model.api.Include INCLUDE_EXAMPLE_CONSTRAINT = new ca.uhn.fhir.model.api.Include("Bundle:example-constraint").toLocked();

// Manual code (from Configuration.txt):
/** 
   * Returns the {@link #getLink() link} which matches a given {@link BundleLinkComponent#getRelation() relation}.  
   * If no link is found which matches the given relation, returns <code>null</code>. If more than one 
   * link is found which matches the given relation, returns the first matching BundleLinkComponent. 
   *  
   * @param theRelation 
   *            The relation, such as \"next\", or \"self. See the constants such as {@link IBaseBundle#LINK_SELF} and {@link IBaseBundle#LINK_NEXT}. 
   * @return Returns a matching BundleLinkComponent, or <code>null</code> 
   * @see IBaseBundle#LINK_NEXT 
   * @see IBaseBundle#LINK_PREV 
   * @see IBaseBundle#LINK_SELF 
   */ 
  public BundleLinkComponent getLink(String theRelation) { 
    org.apache.commons.lang3.Validate.notBlank(theRelation, "theRelation may not be null or empty"); 
    for (BundleLinkComponent next : getLink()) { 
      if (theRelation.equals(next.getRelation().toCode())) { 
        return next; 
      } 
    } 
    return null; 
  } 

  /** 
   * Returns the {@link #getLink() link} which matches a given {@link BundleLinkComponent#getRelation() relation}.  
   * If no link is found which matches the given relation, creates a new BundleLinkComponent with the 
   * given relation and adds it to this Bundle. If more than one 
   * link is found which matches the given relation, returns the first matching BundleLinkComponent. 
   *  
   * @param theRelation 
   *            The relation, such as \"next\", or \"self. See the constants such as {@link IBaseBundle#LINK_SELF} and {@link IBaseBundle#LINK_NEXT}. 
   * @return Returns a matching BundleLinkComponent, or <code>null</code> 
   * @see IBaseBundle#LINK_NEXT 
   * @see IBaseBundle#LINK_PREV 
   * @see IBaseBundle#LINK_SELF 
   */ 
  public BundleLinkComponent getLinkOrCreate(String theRelation) { 
    org.apache.commons.lang3.Validate.notBlank(theRelation, "theRelation may not be null or empty"); 
    for (BundleLinkComponent next : getLink()) { 
      if (theRelation.equals(next.getRelation().toCode())) { 
        return next; 
      } 
    } 
    BundleLinkComponent retVal = new BundleLinkComponent(); 
    retVal.setRelation(LinkRelationTypes.fromCode(theRelation)); 
    getLink().add(retVal); 
    return retVal; 
  }
// end addition

}

