/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.fhir.ucum.Utilities;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.ExtensionHelper;
import org.hl7.fhir.r5.model.Factory;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ToolingExtensions {
    public static final String EXT_ISSUE_MSG_ID = "http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id";
    public static final String EXT_ISSUE_LINE = "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line";
    public static final String EXT_ISSUE_COL = "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col";
    public static final String EXT_OO_FILE = "http://hl7.org/fhir/StructureDefinition/operationoutcome-file";
    public static final String EXT_RESOURCE_IMPLEMENTS = "http://hl7.org/fhir/StructureDefinition/structuredefinition-implements";
    public static final String EXT_XML_TYPE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-type";
    public static final String EXT_XML_NAME = "http://hl7.org/fhir/StructureDefinition/elementdefinition-xml-name";
    public static final String EXT_EXPLICIT_TYPE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name";
    public static final String EXT_IGP_RESOURCES = "http://hl7.org/fhir/StructureDefinition/igpublisher-folder-resource";
    public static final String EXT_IGP_PAGES = "http://hl7.org/fhir/StructureDefinition/igpublisher-folder-pages";
    public static final String EXT_IGP_SPREADSHEET = "http://hl7.org/fhir/StructureDefinition/igpublisher-spreadsheet";
    public static final String EXT_IGP_MAPPING_CSV = "http://hl7.org/fhir/StructureDefinition/igpublisher-mapping-csv";
    public static final String EXT_IGP_BUNDLE = "http://hl7.org/fhir/tools/StructureDefinition/igpublisher-bundle";
    public static final String EXT_IGP_BASE = "http://hl7.org/fhir/StructureDefinition/igpublisher-res-base";
    public static final String EXT_IGP_DEFNS = "http://hl7.org/fhir/StructureDefinition/igpublisher-res-defns";
    public static final String EXT_IGP_FORMAT = "http://hl7.org/fhir/StructureDefinition/igpublisher-res-format";
    public static final String EXT_IGP_SOURCE = "http://hl7.org/fhir/StructureDefinition/igpublisher-res-source";
    public static final String EXT_IGP_CONTAINED_RESOURCE_INFO = "http://hl7.org/fhir/tools/StructureDefinition/contained-resource-information";
    public static final String EXT_BINARY_FORMAT_OLD = "http://hl7.org/fhir/StructureDefinition/implementationguide-resource-format";
    public static final String EXT_BINARY_FORMAT_NEW = "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-format";
    public static final String EXT_BINARY_LOGICAL = "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-resource-logical";
    public static final String EXT_IGP_RESOURCE_INFO = "http://hl7.org/fhir/tools/StructureDefinition/resource-information";
    public static final String EXT_IGP_LOADVERSION = "http://hl7.org/fhir/StructureDefinition/igpublisher-loadversion";
    public static final String EXT_LIST_PACKAGE = "http://hl7.org/fhir/StructureDefinition/list-packageId";
    public static final String EXT_JSON_NAME = "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-json-name";
    public static final String EXT_BINDING_STYLE = "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style";
    public static final String EXT_EXTENSION_STYLE = "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-extension-style";
    public static final String EXT_PATTERN = "http://hl7.org/fhir/StructureDefinition/elementdefinition-pattern";
    public static final String EXT_ALLOWEDRESOURCE = "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceResource";
    private static final String EXT_ALLOWABLE_UNITS = "http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits";
    private static final String EXT_FHIRTYPE = "http://hl7.org/fhir/StructureDefinition/questionnaire-fhirType";
    public static final String EXT_ALLOWED_TYPE = "http://hl7.org/fhir/StructureDefinition/operationdefinition-allowed-type";
    public static final String EXT_BEST_PRACTICE = "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice";
    public static final String EXT_BEST_PRACTICE_EXPLANATION = "http://hl7.org/fhir/StructureDefinition/elementdefinition-bestpractice-explanation";
    public static final String EXT_BINDING_NAME = "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName";
    public static final String EXT_CONTROL = "http://hl7.org/fhir/StructureDefinition/questionnaire-itemControl";
    public static final String EXT_CS_COMMENT = "http://hl7.org/fhir/StructureDefinition/codesystem-concept-comments";
    public static final String EXT_CS_KEYWORD = "http://hl7.org/fhir/StructureDefinition/codesystem-keyWord";
    public static final String EXT_DEFINITION = "http://hl7.org/fhir/StructureDefinition/valueset-concept-definition";
    public static final String EXT_DISPLAY_HINT = "http://hl7.org/fhir/StructureDefinition/structuredefinition-display-hint";
    public static final String EXT_EXPAND_GROUP = "http://hl7.org/fhir/StructureDefinition/valueset-expand-group";
    public static final String EXT_EXPAND_RULES = "http://hl7.org/fhir/StructureDefinition/valueset-expand-rules";
    public static final String EXT_EXP_TOOCOSTLY = "http://hl7.org/fhir/StructureDefinition/valueset-toocostly";
    public static final String EXT_FHIR_TYPE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type";
    public static final String EXT_FMM_DERIVED = "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom";
    public static final String EXT_FMM_LEVEL = "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm";
    public static final String EXT_FMM_SUPPORT = "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm-support";
    public static final String EXT_HIERARCHY = "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy";
    public static final String EXT_ISSUE_SOURCE = "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source";
    public static final String EXT_MAXOCCURS = "http://hl7.org/fhir/StructureDefinition/questionnaire-maxOccurs";
    public static final String EXT_MAX_DECIMALS = "http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces";
    public static final String EXT_MAX_SIZE = "http://hl7.org/fhir/StructureDefinition/maxSize";
    public static final String EXT_MAX_VALUESET = "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet";
    public static final String EXT_MINOCCURS = "http://hl7.org/fhir/StructureDefinition/questionnaire-minOccurs";
    public static final String EXT_MIN_LENGTH = "http://hl7.org/fhir/StructureDefinition/minLength";
    public static final String EXT_MIN_VALUESET = "http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet";
    public static final String EXT_MUST_SUPPORT = "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support";
    public static final String EXT_NORMATIVE_VERSION = "http://hl7.org/fhir/StructureDefinition/structuredefinition-normative-version";
    public static final String EXT_PROFILE_ELEMENT = "http://hl7.org/fhir/StructureDefinition/elementdefinition-profile-element";
    public static final String EXT_QTYPE = "http://hl7.org/fhir/StructureDefinition/questionnnaire-baseType";
    public static final String EXT_Q_UNIT = "http://hl7.org/fhir/StructureDefinition/questionnaire-unit";
    public static final String EXT_REFERENCEFILTER = "http://hl7.org/fhir/StructureDefinition/questionnaire-referenceFilter";
    public static final String EXT_REGEX = "http://hl7.org/fhir/StructureDefinition/regex";
    public static final String EXT_RENDERED_VALUE = "http://hl7.org/fhir/StructureDefinition/rendered-value";
    public static final String EXT_REPLACED_BY = "http://hl7.org/fhir/StructureDefinition/codesystem-replacedby";
    public static final String EXT_RESOURCE_CATEGORY = "http://hl7.org/fhir/StructureDefinition/structuredefinition-category";
    public static final String EXT_RESOURCE_INTERFACE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-interface";
    public static final String EXT_SEC_CAT = "http://hl7.org/fhir/StructureDefinition/structuredefinition-security-category";
    public static final String EXT_STANDARDS_STATUS = "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status";
    public static final String EXT_STANDARDS_STATUS_REASON = "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status-reason";
    public static final String EXT_TABLE_NAME = "http://hl7.org/fhir/StructureDefinition/structuredefinition-table-name";
    public static final String EXT_TARGET_ID = "http://hl7.org/fhir/StructureDefinition/targetElement";
    public static final String EXT_TARGET_PATH = "http://hl7.org/fhir/StructureDefinition/targetPath";
    public static final String EXT_TRANSLATABLE = "http://hl7.org/fhir/StructureDefinition/elementdefinition-translatable";
    public static final String EXT_TRANSLATION = "http://hl7.org/fhir/StructureDefinition/translation";
    public static final String EXT_UNCLOSED = "http://hl7.org/fhir/StructureDefinition/valueset-unclosed";
    public static final String EXT_VALUESET_SYSTEM = "http://hl7.org/fhir/StructureDefinition/valueset-system";
    public static final String EXT_VS_COMMENT = "http://hl7.org/fhir/StructureDefinition/valueset-concept-comments";
    public static final String EXT_VS_KEYWORD = "http://hl7.org/fhir/StructureDefinition/valueset-keyWord";
    public static final String EXT_WORKGROUP = "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg";
    public static final String EXT_XML_NAMESPACE = "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace";
    public static final String EXT_OLD_CONCEPTMAP_EQUIVALENCE = "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence";
    public static final String EXT_Q_IS_SUBJ = "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-isSubject";
    public static final String EXT_Q_HIDDEN = "http://hl7.org/fhir/StructureDefinition/questionnaire-hidden";
    public static final String EXT_Q_OTP_DISP = "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-optionalDisplay";
    public static final String EXT_O_LINK_PERIOD = "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-observationLinkPeriod";
    public static final String EXT_Q_CHOICE_ORIENT = "http://hl7.org/fhir/StructureDefinition/questionnaire-choiceOrientation";
    public static final String EXT_Q_DISPLAY_CAT = "http://hl7.org/fhir/StructureDefinition/questionnaire-displayCategory";
    public static final String EXT_REND_MD = "http://hl7.org/fhir/StructureDefinition/rendering-markdown";
    public static final String EXT_CAP_STMT_EXPECT = "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation";
    public static final String EXT_ED_HEIRARCHY = "http://hl7.org/fhir/StructureDefinition/elementdefinition-heirarchy";
    public static final String EXT_SD_IMPOSE_PROFILE = "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile";
    public static final String EXT_XML_NO_ORDER = "http://hl7.org/fhir/StructureDefinition/structuredefinition-xml-no-order";
    public static final String EXT_DEF_TYPE = "http://hl7.org/fhir/StructureDefinition/elementdefinition-defaulttype";
    public static final String EXT_TYPE_SPEC = "http://hl7.org/fhir/tools/StructureDefinition/type-specifier";
    public static final String EXT_TYPE_CHARACTERISTICS = "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics";
    public static final String EXT_PRIVATE_BASE = "http://hl7.org/fhir/tools/";
    public static final String EXT_BINDING_ADDITIONAL = "http://hl7.org/fhir/tools/StructureDefinition/additional-binding";
    public static final String EXT_JSON_PROP_KEY = "http://hl7.org/fhir/tools/StructureDefinition/json-property-key";
    public static final String EXT_JSON_EMPTY = "http://hl7.org/fhir/tools/StructureDefinition/json-empty-behavior";
    public static final String EXT_JSON_NULLABLE = "http://hl7.org/fhir/tools/StructureDefinition/json-nullable";
    public static final String EXT_IMPLIED_PREFIX = "http://hl7.org/fhir/tools/StructureDefinition/implied-string-prefix";
    public static final String EXT_DATE_FORMAT = "http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-date-format";
    public static final String EXT_ID_EXPECTATION = "http://hl7.org/fhir/tools/StructureDefinition/id-expectation";
    public static final String EXT_JSON_PRIMITIVE_CHOICE = "http://hl7.org/fhir/tools/StructureDefinition/json-primitive-choice";
    public static final String EXT_SUMMARY = "http://hl7.org/fhir/tools/StructureDefinition/profile-summary";
    public static final String EXT_BINDING_DEFINITION = "http://hl7.org/fhir/tools/StructureDefinition/binding-definition";
    public static final String EXT_MAPPING_PREFIX = "http://hl7.org/fhir/tools/StructureDefinition/logical-mapping-prefix";
    public static final String EXT_MAPPING_SUFFIX = "http://hl7.org/fhir/tools/StructureDefinition/logical-mapping-suffix";
    public static final String EXT_MAPPING_NAME = "http://hl7.org/fhir/tools/StructureDefinition/conceptmap-source-name";
    public static final String EXT_MAPPING_TYPE = "http://hl7.org/fhir/tools/StructureDefinition/conceptmap-source-type";
    public static final String EXT_MAPPING_CARD = "http://hl7.org/fhir/tools/StructureDefinition/conceptmap-source-cardinality";
    public static final String EXT_MAPPING_TGTTYPE = "http://hl7.org/fhir/tools/StructureDefinition/conceptmap-target-type";
    public static final String EXT_MAPPING_TGTCARD = "http://hl7.org/fhir/tools/StructureDefinition/conceptmap-target-cardinality";
    public static final String WEB_EXTENSION_STYLE = "http://build.fhir.org/ig/FHIR/fhir-tools-ig/format-extensions.html#extension-related-extensions";
    public static final String EXT_IGDEP_COMMENT = "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment";
    public static final String EXT_XPATH_CONSTRAINT = "http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.constraint.xpath";
    public static final String EXT_OBLIGATION = "http://hl7.org/fhir/tools/StructureDefinition/obligation";
    public static final String EXT_NO_BINDING = "http://hl7.org/fhir/tools/StructureDefinition/no-binding";

    public static Extension makeIssueSource(ValidationMessage.Source source) {
        Extension ex = new Extension();
        ex.setUrl(EXT_ISSUE_SOURCE);
        StringType c = new StringType();
        c.setValue(source.toString());
        ex.setValue(c);
        return ex;
    }

    public static Extension makeIssueMessageId(String msgId) {
        Extension ex = new Extension();
        ex.setUrl(EXT_ISSUE_MSG_ID);
        CodeType c = new CodeType();
        c.setValue(msgId);
        ex.setValue(c);
        return ex;
    }

    public static boolean hasExtension(DomainResource de, String url) {
        return ToolingExtensions.getExtension(de, url) != null;
    }

    public static boolean hasExtension(Element e, String url) {
        return ToolingExtensions.getExtension(e, url) != null;
    }

    public static void addMarkdownExtension(DomainResource dr, String url, String content) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            Extension ex = ToolingExtensions.getExtension(dr, url);
            if (ex != null) {
                ex.setValue(new StringType(content));
            } else {
                dr.getExtension().add(Factory.newExtension(url, new MarkdownType(content), true));
            }
        }
    }

    public static void addStringExtension(Element e, String url, String content) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            Extension ex = ToolingExtensions.getExtension(e, url);
            if (ex != null) {
                ex.setValue(new StringType(content));
            } else {
                e.getExtension().add(Factory.newExtension(url, new StringType(content), true));
            }
        }
    }

    public static void addCodeExtension(Element e, String url, String content) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            Extension ex = ToolingExtensions.getExtension(e, url);
            if (ex != null) {
                ex.setValue(new CodeType(content));
            } else {
                e.getExtension().add(Factory.newExtension(url, new CodeType(content), true));
            }
        }
    }

    public static void addStringExtension(DomainResource e, String url, String content) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            Extension ex = ToolingExtensions.getExtension(e, url);
            if (ex != null) {
                ex.setValue(new StringType(content));
            } else {
                e.getExtension().add(Factory.newExtension(url, new StringType(content), true));
            }
        }
    }

    public static void addBooleanExtension(Element e, String url, boolean content) {
        Extension ex = ToolingExtensions.getExtension(e, url);
        if (ex != null) {
            ex.setValue(new BooleanType(content));
        } else {
            e.getExtension().add(Factory.newExtension(url, new BooleanType(content), true));
        }
    }

    public static void addBooleanExtension(DomainResource e, String url, boolean content) {
        Extension ex = ToolingExtensions.getExtension(e, url);
        if (ex != null) {
            ex.setValue(new BooleanType(content));
        } else {
            e.getExtension().add(Factory.newExtension(url, new BooleanType(content), true));
        }
    }

    public static void addIntegerExtension(DomainResource dr, String url, int value) {
        Extension ex = ToolingExtensions.getExtension(dr, url);
        if (ex != null) {
            ex.setValue(new IntegerType(value));
        } else {
            dr.getExtension().add(Factory.newExtension(url, new IntegerType(value), true));
        }
    }

    public static void addCodeExtension(DomainResource dr, String url, String value) {
        Extension ex = ToolingExtensions.getExtension(dr, url);
        if (ex != null) {
            ex.setValue(new CodeType(value));
        } else {
            dr.getExtension().add(Factory.newExtension(url, new CodeType(value), true));
        }
    }

    public static void addVSComment(ValueSet.ConceptSetComponent nc, String comment) {
        if (!StringUtils.isBlank((CharSequence)comment)) {
            nc.getExtension().add(Factory.newExtension(EXT_VS_COMMENT, Factory.newString_(comment), true));
        }
    }

    public static void addVSComment(ValueSet.ConceptReferenceComponent nc, String comment) {
        if (!StringUtils.isBlank((CharSequence)comment)) {
            nc.getExtension().add(Factory.newExtension(EXT_VS_COMMENT, Factory.newString_(comment), true));
        }
    }

    public static void addCSComment(CodeSystem.ConceptDefinitionComponent nc, String comment) {
        if (!StringUtils.isBlank((CharSequence)comment)) {
            nc.getExtension().add(Factory.newExtension(EXT_CS_COMMENT, Factory.newString_(comment), true));
        }
    }

    public static void addDefinition(Element nc, String definition) {
        if (!StringUtils.isBlank((CharSequence)definition)) {
            nc.getExtension().add(Factory.newExtension(EXT_DEFINITION, Factory.newString_(definition), true));
        }
    }

    public static void addDisplayHint(Element def, String hint) {
        if (!StringUtils.isBlank((CharSequence)hint)) {
            def.getExtension().add(Factory.newExtension(EXT_DISPLAY_HINT, Factory.newString_(hint), true));
        }
    }

    public static String getDisplayHint(Element def) {
        return ToolingExtensions.readStringExtension(def, EXT_DISPLAY_HINT);
    }

    public static String readStringExtension(Element c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        if (ex.getValue() instanceof UriType) {
            return (String)((UriType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof CanonicalType) {
            return (String)((CanonicalType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof CodeType) {
            return (String)((CodeType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof IntegerType) {
            return ((IntegerType)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof Integer64Type) {
            return ((Integer64Type)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof DecimalType) {
            return ((DecimalType)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof MarkdownType) {
            return (String)((MarkdownType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof PrimitiveType) {
            return ((PrimitiveType)ex.getValue()).primitiveValue();
        }
        if (!(ex.getValue() instanceof StringType)) {
            return null;
        }
        return (String)((StringType)ex.getValue()).getValue();
    }

    public static String readStringExtension(DomainResource c, String uri) {
        Extension ex = ToolingExtensions.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        if (ex.getValue() instanceof StringType) {
            return (String)((StringType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof UriType) {
            return (String)((UriType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof CodeType) {
            return (String)((CodeType)ex.getValue()).getValue();
        }
        if (ex.getValue() instanceof IntegerType) {
            return ((IntegerType)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof Integer64Type) {
            return ((Integer64Type)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof DecimalType) {
            return ((DecimalType)ex.getValue()).asStringValue();
        }
        if (ex.getValue() instanceof MarkdownType) {
            return (String)((MarkdownType)ex.getValue()).getValue();
        }
        return null;
    }

    public static PrimitiveType<DataType> readPrimitiveExtension(DomainResource c, String uri) {
        Extension ex = ToolingExtensions.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        return (PrimitiveType)ex.getValue();
    }

    public static boolean findStringExtension(Element c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return false;
        }
        if (!(ex.getValue() instanceof StringType)) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)((CharSequence)((StringType)ex.getValue()).getValue()));
    }

    public static Boolean readBooleanExtension(Element c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        if (!(ex.getValue() instanceof BooleanType)) {
            return null;
        }
        return (Boolean)((BooleanType)ex.getValue()).getValue();
    }

    public static boolean findBooleanExtension(Element c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return false;
        }
        return ex.getValue() instanceof BooleanType;
    }

    public static Boolean readBooleanExtension(DomainResource c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return null;
        }
        if (!(ex.getValue() instanceof BooleanType)) {
            return null;
        }
        return (Boolean)((BooleanType)ex.getValue()).getValue();
    }

    public static boolean readBoolExtension(DomainResource c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return false;
        }
        if (!(ex.getValue() instanceof BooleanType)) {
            return false;
        }
        return (Boolean)((BooleanType)ex.getValue()).getValue();
    }

    public static boolean readBoolExtension(Element e, String uri) {
        Extension ex = ExtensionHelper.getExtension(e, uri);
        if (ex == null) {
            return false;
        }
        if (!(ex.getValue() instanceof BooleanType)) {
            return false;
        }
        if (!ex.getValue().hasPrimitiveValue()) {
            return false;
        }
        return (Boolean)((BooleanType)ex.getValue()).getValue();
    }

    public static boolean findBooleanExtension(DomainResource c, String uri) {
        Extension ex = ExtensionHelper.getExtension(c, uri);
        if (ex == null) {
            return false;
        }
        return ex.getValue() instanceof BooleanType;
    }

    public static String getCSComment(CodeSystem.ConceptDefinitionComponent c) {
        return ToolingExtensions.readStringExtension(c, EXT_CS_COMMENT);
    }

    public static boolean hasCSComment(CodeSystem.ConceptDefinitionComponent c) {
        return ToolingExtensions.findStringExtension(c, EXT_CS_COMMENT);
    }

    public static void addFlyOver(Questionnaire.QuestionnaireItemComponent item, String text, String linkId) {
        if (!StringUtils.isBlank((CharSequence)text)) {
            Questionnaire.QuestionnaireItemComponent display = item.addItem();
            display.setType(Questionnaire.QuestionnaireItemType.DISPLAY);
            display.setText(text);
            display.setLinkId(linkId);
            display.getExtension().add(Factory.newExtension(EXT_CONTROL, Factory.newCodeableConcept("flyover", "http://hl7.org/fhir/questionnaire-item-control", "Fly-over"), true));
        }
    }

    public static void addMin(Questionnaire.QuestionnaireItemComponent item, int min) {
        item.getExtension().add(Factory.newExtension(EXT_MINOCCURS, Factory.newInteger(min), true));
    }

    public static void addMax(Questionnaire.QuestionnaireItemComponent item, int max) {
        item.getExtension().add(Factory.newExtension(EXT_MAXOCCURS, Factory.newInteger(max), true));
    }

    public static void addFhirType(Questionnaire.QuestionnaireItemComponent group, String value) {
        group.getExtension().add(Factory.newExtension(EXT_FHIRTYPE, Factory.newString_(value), true));
    }

    public static void addControl(Questionnaire.QuestionnaireItemComponent group, String value) {
        group.getExtension().add(Factory.newExtension(EXT_CONTROL, Factory.newCodeableConcept(value, "http://hl7.org/fhir/questionnaire-item-control", value), true));
    }

    public static void addAllowedResource(Questionnaire.QuestionnaireItemComponent group, String value) {
        group.getExtension().add(Factory.newExtension(EXT_ALLOWEDRESOURCE, Factory.newCode(value), true));
    }

    public static void addReferenceFilter(Questionnaire.QuestionnaireItemComponent group, String value) {
        group.getExtension().add(Factory.newExtension(EXT_REFERENCEFILTER, Factory.newString_(value), true));
    }

    public static Extension getExtension(DomainResource resource, String name) {
        if (resource == null || name == null) {
            return null;
        }
        if (!resource.hasExtension()) {
            return null;
        }
        for (Extension e : resource.getExtension()) {
            if (!name.equals(e.getUrl())) continue;
            return e;
        }
        return null;
    }

    public static Extension getExtension(Element el, String name) {
        if (name == null) {
            return null;
        }
        if (!el.hasExtension()) {
            return null;
        }
        for (Extension e : el.getExtension()) {
            if (!name.equals(e.getUrl())) continue;
            return e;
        }
        return null;
    }

    public static void setStringExtension(DomainResource resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ToolingExtensions.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new StringType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new StringType(value)));
        }
    }

    public static void setStringExtension(Element resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ToolingExtensions.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new StringType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new StringType(value)));
        }
    }

    public static void setUriExtension(DomainResource resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ToolingExtensions.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new UriType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new UriType(value)));
        }
    }

    public static void setUriExtension(Element resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ToolingExtensions.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new UriType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new UriType(value)));
        }
    }

    public static void setUrlExtension(DomainResource resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ToolingExtensions.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new UrlType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new UrlType(value)));
        }
    }

    public static void setUrlExtension(Element resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ToolingExtensions.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new UrlType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new UrlType(value)));
        }
    }

    public static void setCodeExtension(DomainResource resource, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ToolingExtensions.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new CodeType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new CodeType(value)));
        }
    }

    public static void setCodeExtension(Element element, String uri, String value) {
        if (Utilities.noString((String)value)) {
            return;
        }
        Extension ext = ToolingExtensions.getExtension(element, uri);
        if (ext != null) {
            ext.setValue(new CodeType(value));
        } else {
            element.getExtension().add(new Extension(uri).setValue(new CodeType(value)));
        }
    }

    public static void setIntegerExtension(DomainResource resource, String uri, int value) {
        Extension ext = ToolingExtensions.getExtension(resource, uri);
        if (ext != null) {
            ext.setValue(new IntegerType(value));
        } else {
            resource.getExtension().add(new Extension(uri).setValue(new IntegerType(value)));
        }
    }

    public static boolean hasLanguageTranslation(Element element, String lang) {
        for (Extension e : element.getExtension()) {
            Extension e1;
            if (!e.getUrl().equals(EXT_TRANSLATION) || (e1 = ExtensionHelper.getExtension(e, "lang")) == null || !(e1.getValue() instanceof CodeType) || !((String)((CodeType)e.getValue()).getValue()).equals(lang)) continue;
            return true;
        }
        return false;
    }

    public static String getLanguageTranslation(Element element, String lang) {
        for (Extension e : element.getExtension()) {
            Extension e1;
            if (!e.getUrl().equals(EXT_TRANSLATION) || (e1 = ExtensionHelper.getExtension(e, "lang")) == null || !(e1.getValue() instanceof CodeType) || !((String)((CodeType)e.getValue()).getValue()).equals(lang)) continue;
            e1 = ExtensionHelper.getExtension(e, "content");
            return (String)((StringType)e.getValue()).getValue();
        }
        return null;
    }

    public static void addLanguageTranslation(Element element, String lang, String value) {
        if (Utilities.noString((String)lang) || Utilities.noString((String)value)) {
            return;
        }
        Extension extension = new Extension().setUrl(EXT_TRANSLATION);
        extension.addExtension().setUrl("lang").setValue(new CodeType(lang));
        extension.addExtension().setUrl("content").setValue(new StringType(value));
        element.getExtension().add(extension);
    }

    public static DataType getAllowedUnits(ElementDefinition eld) {
        for (Extension e : eld.getExtension()) {
            if (!e.getUrl().equals(EXT_ALLOWABLE_UNITS)) continue;
            return e.getValue();
        }
        return null;
    }

    public static void setAllowableUnits(ElementDefinition eld, CodeableConcept cc) {
        for (Extension e : eld.getExtension()) {
            if (!e.getUrl().equals(EXT_ALLOWABLE_UNITS)) continue;
            e.setValue(cc);
            return;
        }
        eld.getExtension().add(new Extension().setUrl(EXT_ALLOWABLE_UNITS).setValue(cc));
    }

    public static List<Extension> getExtensions(Element element, String url) {
        ArrayList<Extension> results = new ArrayList<Extension>();
        for (Extension ex : element.getExtension()) {
            if (!ex.getUrl().equals(url)) continue;
            results.add(ex);
        }
        return results;
    }

    public static List<Extension> getExtensions(DomainResource resource, String url) {
        ArrayList<Extension> results = new ArrayList<Extension>();
        for (Extension ex : resource.getExtension()) {
            if (!ex.getUrl().equals(url)) continue;
            results.add(ex);
        }
        return results;
    }

    public static void setExtension(Element focus, String url, Coding c) {
        for (Extension e : focus.getExtension()) {
            if (!e.getUrl().equals(url)) continue;
            e.setValue(c);
            return;
        }
        focus.getExtension().add(new Extension().setUrl(url).setValue(c));
    }

    public static void removeExtension(DomainResource focus, String url) {
        Iterator<Extension> i = focus.getExtension().iterator();
        while (i.hasNext()) {
            Extension e = i.next();
            if (!e.getUrl().equals(url)) continue;
            i.remove();
        }
    }

    public static void removeExtension(Element focus, String url) {
        Iterator<Extension> i = focus.getExtension().iterator();
        while (i.hasNext()) {
            Extension e = i.next();
            if (!e.getUrl().equals(url)) continue;
            i.remove();
        }
    }

    public static int readIntegerExtension(DomainResource dr, String uri, int defaultValue) {
        Extension ex = ExtensionHelper.getExtension(dr, uri);
        if (ex == null) {
            return defaultValue;
        }
        if (ex.getValue() instanceof IntegerType) {
            return (Integer)((IntegerType)ex.getValue()).getValue();
        }
        throw new Error("Unable to read extension " + uri + " as an integer");
    }

    public static int readIntegerExtension(Element e, String uri, int defaultValue) {
        Extension ex = ExtensionHelper.getExtension(e, uri);
        if (ex == null) {
            return defaultValue;
        }
        if (ex.getValue() instanceof IntegerType) {
            return (Integer)((IntegerType)ex.getValue()).getValue();
        }
        throw new Error("Unable to read extension " + uri + " as an integer");
    }

    public static Map<String, String> getLanguageTranslations(Element e) {
        HashMap<String, String> res = new HashMap<String, String>();
        for (Extension ext : e.getExtension()) {
            if (!ext.getUrl().equals(EXT_TRANSLATION)) continue;
            String lang = ToolingExtensions.readStringExtension(ext, "lang");
            String value = ToolingExtensions.readStringExtension(ext, "content");
            res.put(lang, value);
        }
        return res;
    }

    public static StandardsStatus getStandardsStatus(DomainResource dr) throws FHIRException {
        return StandardsStatus.fromCode((String)ToolingExtensions.readStringExtension(dr, EXT_STANDARDS_STATUS));
    }

    public static StandardsStatus getStandardsStatus(Element e) throws FHIRException {
        return StandardsStatus.fromCode((String)ToolingExtensions.readStringExtension(e, EXT_STANDARDS_STATUS));
    }

    public static void setStandardsStatus(DomainResource dr, StandardsStatus status, String normativeVersion) {
        if (status == null) {
            ToolingExtensions.removeExtension(dr, EXT_STANDARDS_STATUS);
        } else {
            ToolingExtensions.setCodeExtension(dr, EXT_STANDARDS_STATUS, status.toCode());
        }
        if (normativeVersion == null) {
            ToolingExtensions.removeExtension(dr, EXT_NORMATIVE_VERSION);
        } else {
            ToolingExtensions.setCodeExtension(dr, EXT_NORMATIVE_VERSION, normativeVersion);
        }
    }

    public static void setStandardsStatus(Element dr, StandardsStatus status, String normativeVersion) {
        if (status == null) {
            ToolingExtensions.removeExtension(dr, EXT_STANDARDS_STATUS);
        } else {
            ToolingExtensions.setCodeExtension(dr, EXT_STANDARDS_STATUS, status.toCode());
        }
        if (normativeVersion == null) {
            ToolingExtensions.removeExtension(dr, EXT_NORMATIVE_VERSION);
        } else {
            ToolingExtensions.setCodeExtension(dr, EXT_NORMATIVE_VERSION, normativeVersion);
        }
    }

    public static ValidationMessage readValidationMessage(OperationOutcome.OperationOutcomeIssueComponent issue, ValidationMessage.Source source) {
        ValidationMessage vm = new ValidationMessage();
        vm.setSource(source);
        vm.setLevel(ToolingExtensions.mapSeverity(issue.getSeverity()));
        vm.setType(ToolingExtensions.mapType(issue.getCode()));
        if (issue.hasExtension(EXT_ISSUE_LINE)) {
            vm.setLine(ToolingExtensions.readIntegerExtension(issue, EXT_ISSUE_LINE, 0));
        }
        if (issue.hasExtension(EXT_ISSUE_COL)) {
            vm.setCol(ToolingExtensions.readIntegerExtension(issue, EXT_ISSUE_COL, 0));
        }
        if (issue.hasExpression()) {
            vm.setLocation(issue.getExpression().get(0).asStringValue());
        }
        vm.setMessage(issue.getDetails().getText());
        if (issue.hasExtension("http://hl7.org/fhir/StructureDefinition/rendering-xhtml")) {
            vm.setHtml(ToolingExtensions.readStringExtension(issue, "http://hl7.org/fhir/StructureDefinition/rendering-xhtml"));
        }
        return vm;
    }

    private static ValidationMessage.IssueType mapType(OperationOutcome.IssueType code) {
        switch (code) {
            case BUSINESSRULE: {
                return ValidationMessage.IssueType.BUSINESSRULE;
            }
            case CODEINVALID: {
                return ValidationMessage.IssueType.CODEINVALID;
            }
            case CONFLICT: {
                return ValidationMessage.IssueType.CONFLICT;
            }
            case DELETED: {
                return ValidationMessage.IssueType.DELETED;
            }
            case DUPLICATE: {
                return ValidationMessage.IssueType.DUPLICATE;
            }
            case EXCEPTION: {
                return ValidationMessage.IssueType.EXCEPTION;
            }
            case EXPIRED: {
                return ValidationMessage.IssueType.EXPIRED;
            }
            case EXTENSION: {
                return ValidationMessage.IssueType.EXTENSION;
            }
            case FORBIDDEN: {
                return ValidationMessage.IssueType.FORBIDDEN;
            }
            case INCOMPLETE: {
                return ValidationMessage.IssueType.INCOMPLETE;
            }
            case INFORMATIONAL: {
                return ValidationMessage.IssueType.INFORMATIONAL;
            }
            case INVALID: {
                return ValidationMessage.IssueType.INVALID;
            }
            case INVARIANT: {
                return ValidationMessage.IssueType.INVARIANT;
            }
            case LOCKERROR: {
                return ValidationMessage.IssueType.LOCKERROR;
            }
            case LOGIN: {
                return ValidationMessage.IssueType.LOGIN;
            }
            case MULTIPLEMATCHES: {
                return ValidationMessage.IssueType.MULTIPLEMATCHES;
            }
            case NOSTORE: {
                return ValidationMessage.IssueType.NOSTORE;
            }
            case NOTFOUND: {
                return ValidationMessage.IssueType.NOTFOUND;
            }
            case NOTSUPPORTED: {
                return ValidationMessage.IssueType.NOTSUPPORTED;
            }
            case NULL: {
                return ValidationMessage.IssueType.NULL;
            }
            case PROCESSING: {
                return ValidationMessage.IssueType.PROCESSING;
            }
            case REQUIRED: {
                return ValidationMessage.IssueType.REQUIRED;
            }
            case SECURITY: {
                return ValidationMessage.IssueType.SECURITY;
            }
            case STRUCTURE: {
                return ValidationMessage.IssueType.STRUCTURE;
            }
            case SUPPRESSED: {
                return ValidationMessage.IssueType.SUPPRESSED;
            }
            case THROTTLED: {
                return ValidationMessage.IssueType.THROTTLED;
            }
            case TIMEOUT: {
                return ValidationMessage.IssueType.TIMEOUT;
            }
            case TOOCOSTLY: {
                return ValidationMessage.IssueType.TOOCOSTLY;
            }
            case TOOLONG: {
                return ValidationMessage.IssueType.TOOLONG;
            }
            case TRANSIENT: {
                return ValidationMessage.IssueType.TRANSIENT;
            }
            case UNKNOWN: {
                return ValidationMessage.IssueType.UNKNOWN;
            }
            case VALUE: {
                return ValidationMessage.IssueType.VALUE;
            }
        }
        return null;
    }

    private static ValidationMessage.IssueSeverity mapSeverity(OperationOutcome.IssueSeverity severity) {
        switch (severity) {
            case ERROR: {
                return ValidationMessage.IssueSeverity.ERROR;
            }
            case FATAL: {
                return ValidationMessage.IssueSeverity.FATAL;
            }
            case INFORMATION: {
                return ValidationMessage.IssueSeverity.INFORMATION;
            }
            case WARNING: {
                return ValidationMessage.IssueSeverity.WARNING;
            }
        }
        return null;
    }

    public static String getPresentation(PrimitiveType<?> type) {
        if (type.hasExtension(EXT_RENDERED_VALUE)) {
            return ToolingExtensions.readStringExtension(type, EXT_RENDERED_VALUE);
        }
        return type.primitiveValue();
    }

    public static String getPresentation(Element holder, PrimitiveType<?> type) {
        if (holder.hasExtension(EXT_RENDERED_VALUE)) {
            return ToolingExtensions.readStringExtension(holder, EXT_RENDERED_VALUE);
        }
        if (type.hasExtension(EXT_RENDERED_VALUE)) {
            return ToolingExtensions.readStringExtension(type, EXT_RENDERED_VALUE);
        }
        return type.primitiveValue();
    }

    public static void addUrlExtension(Element e, String url, String content) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            Extension ex = ToolingExtensions.getExtension(e, url);
            if (ex != null) {
                ex.setValue(new UrlType(content));
            } else {
                e.getExtension().add(Factory.newExtension(url, new UrlType(content), true));
            }
        }
    }

    public static void addUrlExtension(DomainResource dr, String url, String value) {
        Extension ex = ToolingExtensions.getExtension(dr, url);
        if (ex != null) {
            ex.setValue(new UrlType(value));
        } else {
            dr.getExtension().add(Factory.newExtension(url, new UrlType(value), true));
        }
    }

    public static void addUriExtension(Element e, String url, String content) {
        if (!StringUtils.isBlank((CharSequence)content)) {
            Extension ex = ToolingExtensions.getExtension(e, url);
            if (ex != null) {
                ex.setValue(new UriType(content));
            } else {
                e.getExtension().add(Factory.newExtension(url, new UriType(content), true));
            }
        }
    }

    public static void addUriExtension(DomainResource dr, String url, String value) {
        Extension ex = ToolingExtensions.getExtension(dr, url);
        if (ex != null) {
            ex.setValue(new UriType(value));
        } else {
            dr.getExtension().add(Factory.newExtension(url, new UriType(value), true));
        }
    }

    public static boolean usesExtension(String url, Base base) {
        if ("Extension".equals(base.fhirType())) {
            Property p = base.getNamedProperty("url");
            for (Base b : p.getValues()) {
                if (!url.equals(b.primitiveValue())) continue;
                return true;
            }
        }
        for (Property p : base.children()) {
            for (Base v : p.getValues()) {
                if (!ToolingExtensions.usesExtension(url, v)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<String> allConsts() {
        ArrayList<String> list = new ArrayList<String>();
        for (Field field : ToolingExtensions.class.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            try {
                list.add(field.get(field.getType()).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    public static boolean hasExtensions(ElementDefinition d, String ... urls) {
        for (String url : urls) {
            if (!d.hasExtension(url)) continue;
            return true;
        }
        return false;
    }

    public static int countExtensions(ElementDefinition d, String ... urls) {
        int res = 0;
        for (String url : urls) {
            if (!d.hasExtension(url)) continue;
            ++res;
        }
        return res;
    }
}

