/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonString;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.NpmPackageIndexBuilder;
import org.hl7.fhir.utilities.npm.PackageGenerator;

public class NPMPackageGenerator {
    private String destFile;
    private Set<String> created = new HashSet<String>();
    private TarArchiveOutputStream tar;
    private ByteArrayOutputStream OutputStream;
    private BufferedOutputStream bufferedOutputStream;
    private GzipCompressorOutputStream gzipOutputStream;
    private JsonObject packageJ;
    private JsonObject packageManifest;
    private NpmPackageIndexBuilder indexer;
    private String igVersion;

    public NPMPackageGenerator(String destFile, String canonical, String url, PackageGenerator.PackageType kind, ImplementationGuide ig, Date date, boolean notForPublication) throws FHIRException, IOException {
        this.destFile = destFile;
        this.start();
        ArrayList<String> fhirVersion = new ArrayList<String>();
        for (Enumeration<Enumerations.FHIRVersion> v : ig.getFhirVersion()) {
            fhirVersion.add(v.asStringValue());
        }
        this.buildPackageJson(canonical, kind, url, date, ig, fhirVersion, notForPublication);
    }

    public static NPMPackageGenerator subset(NPMPackageGenerator master, String destFile, String id, String name, Date date, boolean notForPublication) throws FHIRException, IOException {
        JsonObject p = master.packageJ.deepCopy();
        p.remove("name");
        p.add("name", id);
        p.remove("type");
        p.add("type", PackageGenerator.PackageType.CONFORMANCE.getCode());
        p.remove("title");
        p.add("title", name);
        if (notForPublication) {
            p.add("notForPublication", true);
        }
        return new NPMPackageGenerator(destFile, p, date, notForPublication);
    }

    public NPMPackageGenerator(String destFile, String canonical, String url, PackageGenerator.PackageType kind, ImplementationGuide ig, Date date, List<String> fhirVersion, boolean notForPublication) throws FHIRException, IOException {
        this.destFile = destFile;
        this.start();
        this.buildPackageJson(canonical, kind, url, date, ig, fhirVersion, notForPublication);
    }

    public NPMPackageGenerator(String destFile, JsonObject npm, Date date, boolean notForPublication) throws FHIRException, IOException {
        String dt = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
        this.packageJ = npm;
        this.packageManifest = new JsonObject();
        this.packageManifest.set("version", npm.asString("version"));
        this.packageManifest.set("date", dt);
        if (notForPublication) {
            this.packageManifest.add("notForPublication", true);
        }
        npm.set("date", dt);
        this.packageManifest.set("name", npm.asString("name"));
        this.destFile = destFile;
        this.start();
        String json = JsonParser.compose((JsonElement)npm, (boolean)true);
        try {
            this.addFile(Category.RESOURCE, "package.json", json.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void buildPackageJson(String canonical, PackageGenerator.PackageType kind, String web, Date date, ImplementationGuide ig, List<String> fhirVersion, boolean notForPublication) throws FHIRException, IOException {
        String dtHuman = new SimpleDateFormat("EEE, MMM d, yyyy HH:mmZ", new Locale("en", "US")).format(date);
        String dt = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (!ig.hasPackageId()) {
            b.append("packageId");
        }
        if (!ig.hasVersion()) {
            b.append("version");
        }
        if (!ig.hasFhirVersion()) {
            b.append("fhirVersion");
        }
        if (!ig.hasLicense()) {
            b.append("license");
        }
        for (ImplementationGuide.ImplementationGuideDependsOnComponent d : ig.getDependsOn()) {
            if (d.hasVersion()) continue;
            b.append("dependsOn.version(" + d.getUri() + ")");
        }
        JsonObject npm = new JsonObject();
        npm.add("name", ig.getPackageId());
        npm.add("version", ig.getVersion());
        this.igVersion = ig.getVersion();
        npm.add("tools-version", 3);
        npm.add("type", kind.getCode());
        npm.add("date", dt);
        if (ig.hasLicense()) {
            npm.add("license", ig.getLicense().toCode());
        }
        npm.add("canonical", canonical);
        if (notForPublication) {
            npm.add("notForPublication", true);
        }
        npm.add("url", web);
        if (ig.hasTitle()) {
            npm.add("title", ig.getTitle());
        }
        if (ig.hasDescription()) {
            npm.add("description", ig.getDescription() + " (built " + dtHuman + this.timezone() + ")");
        }
        JsonArray vl = new JsonArray();
        npm.add("fhirVersions", (JsonElement)vl);
        for (String string : fhirVersion) {
            vl.add((JsonElement)new JsonString(string));
        }
        if (kind != PackageGenerator.PackageType.CORE) {
            JsonObject dep = new JsonObject();
            npm.add("dependencies", (JsonElement)dep);
            for (String v : fhirVersion) {
                String vp = this.packageForVersion(v);
                if (vp == null) continue;
                dep.add(vp, v);
            }
            for (ImplementationGuide.ImplementationGuideDependsOnComponent d : ig.getDependsOn()) {
                dep.add(d.getPackageId(), d.getVersion());
            }
        }
        if (ig.hasPublisher()) {
            npm.add("author", ig.getPublisher());
        }
        JsonArray m = new JsonArray();
        for (ContactDetail t : ig.getContact()) {
            String email = this.email(t.getTelecom());
            String url = this.url(t.getTelecom());
            if (!(t.hasName() & (email != null || url != null))) continue;
            JsonObject md = new JsonObject();
            m.add((JsonElement)md);
            md.add("name", t.getName());
            if (email != null) {
                md.add("email", email);
            }
            if (url == null) continue;
            md.add("url", url);
        }
        if (m.size() > 0) {
            npm.add("maintainers", (JsonElement)m);
        }
        if (ig.getManifest().hasRendering()) {
            npm.add("homepage", ig.getManifest().getRendering());
        }
        JsonObject jsonObject = new JsonObject();
        npm.add("directories", (JsonElement)jsonObject);
        jsonObject.add("lib", "package");
        jsonObject.add("example", "example");
        String json = JsonParser.compose((JsonElement)npm, (boolean)true);
        try {
            this.addFile(Category.RESOURCE, "package.json", json.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException email) {
            // empty catch block
        }
        this.packageJ = npm;
        this.packageManifest = new JsonObject();
        this.packageManifest.add("version", ig.getVersion());
        JsonArray fv = new JsonArray();
        for (String v : fhirVersion) {
            fv.add(v);
        }
        this.packageManifest.add("fhirVersion", (JsonElement)fv);
        this.packageManifest.add("date", dt);
        this.packageManifest.add("name", ig.getPackageId());
    }

    private String packageForVersion(String v) {
        if (v == null) {
            return null;
        }
        if (v.startsWith("1.0")) {
            return "hl7.fhir.r2.core";
        }
        if (v.startsWith("1.4")) {
            return "hl7.fhir.r2b.core";
        }
        if (v.startsWith("3.0")) {
            return "hl7.fhir.r3.core";
        }
        if (v.startsWith("4.0")) {
            return "hl7.fhir.r4.core";
        }
        if (v.startsWith("4.1") || v.startsWith("4.3")) {
            return "hl7.fhir.r4b.core";
        }
        return null;
    }

    private String timezone() {
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = GregorianCalendar.getInstance(tz);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());
        Object offset = String.format("%02d:%02d", Math.abs(offsetInMillis / 3600000), Math.abs(offsetInMillis / 60000 % 60));
        offset = (offsetInMillis >= 0 ? "+" : "-") + (String)offset;
        return offset;
    }

    private String url(List<ContactPoint> telecom) {
        for (ContactPoint cp : telecom) {
            if (cp.getSystem() != ContactPoint.ContactPointSystem.URL) continue;
            return cp.getValue();
        }
        return null;
    }

    private String email(List<ContactPoint> telecom) {
        for (ContactPoint cp : telecom) {
            if (cp.getSystem() != ContactPoint.ContactPointSystem.EMAIL) continue;
            return cp.getValue();
        }
        return null;
    }

    private void start() throws IOException {
        this.OutputStream = new ByteArrayOutputStream();
        this.bufferedOutputStream = new BufferedOutputStream(this.OutputStream);
        this.gzipOutputStream = new GzipCompressorOutputStream((OutputStream)this.bufferedOutputStream);
        this.tar = new TarArchiveOutputStream((OutputStream)this.gzipOutputStream);
        this.indexer = new NpmPackageIndexBuilder();
        this.indexer.start();
    }

    public void addFile(Category cat, String name, byte[] content) throws IOException {
        String path = cat.getDirectory() + (String)name;
        if (path.length() > 100) {
            name = ((String)name).substring(0, ((String)name).indexOf("-")) + "-" + UUID.randomUUID().toString() + ".json";
            path = cat.getDirectory() + (String)name;
        }
        if (this.created.contains(path)) {
            System.out.println("Duplicate package file " + path);
        } else {
            this.created.add(path);
            TarArchiveEntry entry = new TarArchiveEntry(path);
            entry.setSize((long)content.length);
            this.tar.putArchiveEntry((ArchiveEntry)entry);
            this.tar.write(content);
            this.tar.closeArchiveEntry();
            if (cat == Category.RESOURCE) {
                this.indexer.seeFile((String)name, content);
            }
        }
    }

    public void addFile(String folder, String name, byte[] content) throws IOException {
        String path;
        if (!((String)folder).equals("package")) {
            folder = "package/" + (String)folder;
        }
        if ((path = (String)folder + "/" + (String)name).length() > 100) {
            name = ((String)name).substring(0, ((String)name).indexOf("-")) + "-" + UUID.randomUUID().toString() + ".json";
            path = (String)folder + "/" + (String)name;
        }
        if (this.created.contains(path)) {
            System.out.println("Duplicate package file " + path);
        } else {
            this.created.add(path);
            TarArchiveEntry entry = new TarArchiveEntry(path);
            entry.setSize((long)content.length);
            this.tar.putArchiveEntry((ArchiveEntry)entry);
            this.tar.write(content);
            this.tar.closeArchiveEntry();
            if (folder == "package") {
                this.indexer.seeFile((String)name, content);
            }
        }
    }

    public void finish() throws IOException {
        this.buildIndexJson();
        this.tar.finish();
        this.tar.close();
        this.gzipOutputStream.close();
        this.bufferedOutputStream.close();
        this.OutputStream.close();
        TextFile.bytesToFile((byte[])this.OutputStream.toByteArray(), (String)this.destFile);
        String json = JsonParser.compose((JsonElement)this.packageManifest, (boolean)true);
        TextFile.stringToFile((String)json, (String)Utilities.changeFileExt((String)this.destFile, (String)".manifest.json"), (boolean)false);
    }

    private void buildIndexJson() throws IOException {
        byte[] content = TextFile.stringToBytes((String)this.indexer.build(), (boolean)false);
        this.addFile(Category.RESOURCE, ".index.json", content);
    }

    public String filename() {
        return this.destFile;
    }

    public void loadDir(String rootDir, String name) throws IOException {
        this.loadFiles(rootDir, new File(Utilities.path((String[])new String[]{rootDir, name})), new String[0]);
    }

    public void loadFiles(String root, File dir, String ... noload) throws IOException {
        for (File f : dir.listFiles()) {
            if (Utilities.existsInList((String)f.getName(), (String[])noload)) continue;
            if (f.isDirectory()) {
                this.loadFiles(root, f, new String[0]);
                continue;
            }
            String path = f.getAbsolutePath().substring(root.length() + 1);
            byte[] content = TextFile.fileToBytes((File)f);
            if (this.created.contains(path)) {
                System.out.println("Duplicate package file " + path);
                continue;
            }
            this.created.add(path);
            TarArchiveEntry entry = new TarArchiveEntry(path);
            entry.setSize((long)content.length);
            this.tar.putArchiveEntry((ArchiveEntry)entry);
            this.tar.write(content);
            this.tar.closeArchiveEntry();
        }
    }

    public String version() {
        return this.igVersion;
    }

    public static enum Category {
        RESOURCE,
        EXAMPLE,
        OPENAPI,
        SCHEMATRON,
        RDF,
        OTHER,
        TOOL,
        TEMPLATE,
        JEKYLL;


        private String getDirectory() {
            switch (this) {
                case RESOURCE: {
                    return "package/";
                }
                case EXAMPLE: {
                    return "package/example/";
                }
                case OPENAPI: {
                    return "package/openapi/";
                }
                case SCHEMATRON: {
                    return "package/xml/";
                }
                case RDF: {
                    return "package/rdf/";
                }
                case OTHER: {
                    return "package/other/";
                }
                case TEMPLATE: {
                    return "package/other/";
                }
                case JEKYLL: {
                    return "package/jekyll/";
                }
                case TOOL: {
                    return "package/bin/";
                }
            }
            return "/";
        }
    }
}

