/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.ActorDefinitionRenderer;
import org.hl7.fhir.r5.renderers.BundleRenderer;
import org.hl7.fhir.r5.renderers.CapabilityStatementRenderer;
import org.hl7.fhir.r5.renderers.CodeSystemRenderer;
import org.hl7.fhir.r5.renderers.CompartmentDefinitionRenderer;
import org.hl7.fhir.r5.renderers.ConceptMapRenderer;
import org.hl7.fhir.r5.renderers.DiagnosticReportRenderer;
import org.hl7.fhir.r5.renderers.EncounterRenderer;
import org.hl7.fhir.r5.renderers.ImplementationGuideRenderer;
import org.hl7.fhir.r5.renderers.LibraryRenderer;
import org.hl7.fhir.r5.renderers.LiquidRenderer;
import org.hl7.fhir.r5.renderers.ListRenderer;
import org.hl7.fhir.r5.renderers.NamingSystemRenderer;
import org.hl7.fhir.r5.renderers.OperationDefinitionRenderer;
import org.hl7.fhir.r5.renderers.OperationOutcomeRenderer;
import org.hl7.fhir.r5.renderers.ParametersRenderer;
import org.hl7.fhir.r5.renderers.PatientRenderer;
import org.hl7.fhir.r5.renderers.ProfileDrivenRenderer;
import org.hl7.fhir.r5.renderers.ProvenanceRenderer;
import org.hl7.fhir.r5.renderers.QuestionnaireRenderer;
import org.hl7.fhir.r5.renderers.QuestionnaireResponseRenderer;
import org.hl7.fhir.r5.renderers.RequirementsRenderer;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.SearchParameterRenderer;
import org.hl7.fhir.r5.renderers.StructureDefinitionRenderer;
import org.hl7.fhir.r5.renderers.StructureMapRenderer;
import org.hl7.fhir.r5.renderers.ValueSetRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.utilities.Utilities;

public class RendererFactory {
    public static ResourceRenderer factory(String resourceName, RenderingContext context) {
        String liquidTemplate;
        if (context.getTemplateProvider() != null && (liquidTemplate = context.getTemplateProvider().findTemplate(context, resourceName)) != null) {
            return new LiquidRenderer(context, liquidTemplate);
        }
        if ("CodeSystem".equals(resourceName)) {
            return new CodeSystemRenderer(context);
        }
        if ("ValueSet".equals(resourceName)) {
            return new ValueSetRenderer(context);
        }
        if ("ConceptMap".equals(resourceName)) {
            return new ConceptMapRenderer(context);
        }
        if ("CapabilityStatement".equals(resourceName)) {
            return new CapabilityStatementRenderer(context);
        }
        if ("StructureDefinition".equals(resourceName)) {
            return new StructureDefinitionRenderer(context);
        }
        if ("OperationDefinition".equals(resourceName)) {
            return new OperationDefinitionRenderer(context);
        }
        if ("SearchParameter".equals(resourceName)) {
            return new SearchParameterRenderer(context);
        }
        if ("CompartmentDefinition".equals(resourceName)) {
            return new CompartmentDefinitionRenderer(context);
        }
        if ("ImplementationGuide".equals(resourceName)) {
            return new ImplementationGuideRenderer(context);
        }
        if ("NamingSystem".equals(resourceName)) {
            return new NamingSystemRenderer(context);
        }
        if ("Questionnaire".equals(resourceName)) {
            return new QuestionnaireRenderer(context);
        }
        if ("QuestionnaireResponse".equals(resourceName)) {
            return new QuestionnaireResponseRenderer(context);
        }
        if ("Patient".equals(resourceName)) {
            return new PatientRenderer(context);
        }
        if ("Encounter".equals(resourceName)) {
            return new EncounterRenderer(context);
        }
        if ("Library".equals(resourceName)) {
            return new LibraryRenderer(context);
        }
        if ("List".equals(resourceName)) {
            return new ListRenderer(context);
        }
        if ("DiagnosticReport".equals(resourceName)) {
            return new DiagnosticReportRenderer(context);
        }
        if ("Provenance".equals(resourceName)) {
            return new ProvenanceRenderer(context);
        }
        if ("OperationOutcome".equals(resourceName)) {
            return new OperationOutcomeRenderer(context);
        }
        if ("Parameters".equals(resourceName)) {
            return new ParametersRenderer(context);
        }
        if ("Bundle".equals(resourceName)) {
            return new BundleRenderer(context);
        }
        if ("ActorDefinition".equals(resourceName)) {
            return new ActorDefinitionRenderer(context);
        }
        if ("Requirements".equals(resourceName)) {
            return new RequirementsRenderer(context);
        }
        if ("StructureMap".equals(resourceName)) {
            return new StructureMapRenderer(context);
        }
        return new ProfileDrivenRenderer(context);
    }

    public static ResourceRenderer factory(Resource resource, RenderingContext context) {
        String liquidTemplate;
        if (context.getTemplateProvider() != null && resource instanceof DomainResource && (liquidTemplate = context.getTemplateProvider().findTemplate(context, (DomainResource)resource)) != null) {
            return new LiquidRenderer(context, liquidTemplate);
        }
        return RendererFactory.factory(resource.fhirType(), context);
    }

    public static ResourceRenderer factory(BaseWrappers.ResourceWrapper resource, RenderingContext context, Resolver.ResourceContext resourceContext) {
        String liquidTemplate;
        if (context.getTemplateProvider() != null && (liquidTemplate = context.getTemplateProvider().findTemplate(context, resource.getName())) != null) {
            return new LiquidRenderer(context, liquidTemplate);
        }
        if ("List".equals(resource.getName())) {
            return new ListRenderer(context);
        }
        if ("Library".equals(resource.getName())) {
            return new LibraryRenderer(context);
        }
        if ("Patient".equals(resource.getName())) {
            return new PatientRenderer(context);
        }
        if ("DiagnosticReport".equals(resource.getName())) {
            return new DiagnosticReportRenderer(context);
        }
        if ("QuestionnaireResponse".equals(resource.getName())) {
            return new QuestionnaireResponseRenderer(context);
        }
        return new ProfileDrivenRenderer(context, resourceContext);
    }

    public static ResourceRenderer factory(BaseWrappers.ResourceWrapper rw, RenderingContext lrc) {
        return RendererFactory.factory(rw, lrc, null);
    }

    public static boolean hasSpecificRenderer(String rt) {
        return Utilities.existsInList((String)rt, (String[])new String[]{"CodeSystem", "ValueSet", "ConceptMap", "CapabilityStatement", "CompartmentDefinition", "ImplementationGuide", "Library", "NamingSystem", "OperationDefinition", "Questionnaire", "SearchParameter", "StructureDefinition", "ActorDefinition", "Requirements"});
    }

    public static boolean hasIGSpecificRenderer(String rt) {
        return Utilities.existsInList((String)rt, (String[])new String[]{"ValueSet", "CapabilityStatement", "Questionnaire"});
    }
}

