/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.profilemodel;

import java.util.List;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.profilemodel.PEDefinition;
import org.hl7.fhir.r5.profilemodel.PEType;

public class PEDefinitionSlice
extends PEDefinition {
    protected ElementDefinition sliceDefinition;

    public PEDefinitionSlice(PEBuilder builder, String name, StructureDefinition profile, ElementDefinition profileDefinition, ElementDefinition sliceDefinition, String ppath) {
        super(builder, name, profile, profileDefinition, ppath);
        this.sliceDefinition = sliceDefinition;
    }

    @Override
    public void listTypes(List<PEType> types) {
        for (ElementDefinition.TypeRefComponent t : this.definition.getType()) {
            if (t.hasProfile()) {
                for (CanonicalType u : t.getProfile()) {
                    types.add(this.builder.makeType(t, u));
                }
                continue;
            }
            if (t.getCode().startsWith("http://hl7.org/fhirpath/")) continue;
            types.add(new PEType(t.getWorkingCode(), t.getWorkingCode(), "http://hl7.org/fhir/StructureDefinition/" + t.getWorkingCode()));
        }
    }

    @Override
    protected void makeChildren(String typeUrl, List<PEDefinition> children, boolean allFixed) {
        children.addAll(this.builder.listChildren(allFixed, this, this.profile, this.definition, typeUrl, new String[0]));
    }

    @Override
    public String fhirpath() {
        String base = this.schemaName().replace("[x]", "");
        String filter = this.builder.makeSliceExpression(this.profile, this.sliceDefinition.getSlicing(), this.definition);
        return base + ".where(" + filter + ")";
    }
}

