/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Endpoint", profile="http://hl7.org/fhir/StructureDefinition/Endpoint")
public class Endpoint
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifies this endpoint across multiple systems", formalDefinition="Identifier for the organization that is used to identify the endpoint across multiple disparate systems.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | suspended | error | off | entered-in-error | test", formalDefinition="The endpoint status represents the general expected availability of an endpoint.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/endpoint-status")
    protected Enumeration<EndpointStatus> status;
    @Child(name="connectionType", type={CodeableConcept.class}, order=2, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Protocol/Profile/Standard to be used with this endpoint connection", formalDefinition="A coded value that represents the technical details of the usage of this endpoint, such as what WSDLs should be used in what way. (e.g. XDS.b/DICOM/cds-hook).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/endpoint-connection-type")
    protected List<CodeableConcept> connectionType;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A name that this endpoint can be identified by", formalDefinition="A friendly name that this endpoint can be referred to with.")
    protected StringType name;
    @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional details about the endpoint that could be displayed as further information to identify the description beyond its name", formalDefinition="The description of the endpoint and what it is for (typically used as supplemental information in an endpoint directory describing its usage/purpose).")
    protected StringType description;
    @Child(name="environmentType", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The type of environment(s) exposed at this endpoint", formalDefinition="The type of environment(s) exposed at this endpoint (dev, prod, test, etc.).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/endpoint-environment")
    protected List<CodeableConcept> environmentType;
    @Child(name="managingOrganization", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that manages this endpoint (might not be the organization that exposes the endpoint)", formalDefinition="The organization that manages this endpoint (even if technically another organization is hosting this in the cloud, it is the organization associated with the data).")
    protected Reference managingOrganization;
    @Child(name="contact", type={ContactPoint.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contact details for source (e.g. troubleshooting)", formalDefinition="Contact details for a human to contact about the endpoint. The primary use of this for system administrator troubleshooting.")
    protected List<ContactPoint> contact;
    @Child(name="period", type={Period.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Interval the endpoint is expected to be operational", formalDefinition="The interval during which the endpoint is expected to be operational.")
    protected Period period;
    @Child(name="payload", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Set of payloads that are provided by this endpoint", formalDefinition="The set of payloads that are provided/available at this endpoint.")
    protected List<EndpointPayloadComponent> payload;
    @Child(name="address", type={UrlType.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The technical base address for connecting to this endpoint", formalDefinition="The uri that describes the actual end-point to connect to.")
    protected UrlType address;
    @Child(name="header", type={StringType.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Usage depends on the channel type", formalDefinition="Additional headers / information to send as part of the notification.")
    protected List<StringType> header;
    private static final long serialVersionUID = 1633700267L;
    @SearchParamDefinition(name="connection-type", path="Endpoint.connectionType", description="Protocol/Profile/Standard to be used with this endpoint connection", type="token")
    public static final String SP_CONNECTION_TYPE = "connection-type";
    public static final TokenClientParam CONNECTION_TYPE = new TokenClientParam("connection-type");
    @SearchParamDefinition(name="identifier", path="Endpoint.identifier", description="Identifies this endpoint across multiple systems", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="name", path="Endpoint.name", description="A name that this endpoint can be identified by", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="organization", path="Endpoint.managingOrganization", description="The organization that is managing the endpoint", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("Endpoint:organization").toLocked();
    @SearchParamDefinition(name="payload-type", path="Endpoint.payload.type", description="The type of content that may be used at this endpoint (e.g. XDS Discharge summaries)", type="token")
    public static final String SP_PAYLOAD_TYPE = "payload-type";
    public static final TokenClientParam PAYLOAD_TYPE = new TokenClientParam("payload-type");
    @SearchParamDefinition(name="status", path="Endpoint.status", description="The current status of the Endpoint (usually expected to be active)", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Endpoint() {
    }

    public Endpoint(EndpointStatus status, CodeableConcept connectionType, String address) {
        this.setStatus(status);
        this.addConnectionType(connectionType);
        this.setAddress(address);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Endpoint setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Endpoint addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<EndpointStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EndpointStatus>(new EndpointStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Endpoint setStatusElement(Enumeration<EndpointStatus> value) {
        this.status = value;
        return this;
    }

    public EndpointStatus getStatus() {
        return this.status == null ? null : (EndpointStatus)((Object)this.status.getValue());
    }

    public Endpoint setStatus(EndpointStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<EndpointStatus>(new EndpointStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getConnectionType() {
        if (this.connectionType == null) {
            this.connectionType = new ArrayList<CodeableConcept>();
        }
        return this.connectionType;
    }

    public Endpoint setConnectionType(List<CodeableConcept> theConnectionType) {
        this.connectionType = theConnectionType;
        return this;
    }

    public boolean hasConnectionType() {
        if (this.connectionType == null) {
            return false;
        }
        for (CodeableConcept item : this.connectionType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addConnectionType() {
        CodeableConcept t = new CodeableConcept();
        if (this.connectionType == null) {
            this.connectionType = new ArrayList<CodeableConcept>();
        }
        this.connectionType.add(t);
        return t;
    }

    public Endpoint addConnectionType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.connectionType == null) {
            this.connectionType = new ArrayList<CodeableConcept>();
        }
        this.connectionType.add(t);
        return this;
    }

    public CodeableConcept getConnectionTypeFirstRep() {
        if (this.getConnectionType().isEmpty()) {
            this.addConnectionType();
        }
        return this.getConnectionType().get(0);
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Endpoint setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Endpoint setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Endpoint setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Endpoint setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getEnvironmentType() {
        if (this.environmentType == null) {
            this.environmentType = new ArrayList<CodeableConcept>();
        }
        return this.environmentType;
    }

    public Endpoint setEnvironmentType(List<CodeableConcept> theEnvironmentType) {
        this.environmentType = theEnvironmentType;
        return this;
    }

    public boolean hasEnvironmentType() {
        if (this.environmentType == null) {
            return false;
        }
        for (CodeableConcept item : this.environmentType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addEnvironmentType() {
        CodeableConcept t = new CodeableConcept();
        if (this.environmentType == null) {
            this.environmentType = new ArrayList<CodeableConcept>();
        }
        this.environmentType.add(t);
        return t;
    }

    public Endpoint addEnvironmentType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.environmentType == null) {
            this.environmentType = new ArrayList<CodeableConcept>();
        }
        this.environmentType.add(t);
        return this;
    }

    public CodeableConcept getEnvironmentTypeFirstRep() {
        if (this.getEnvironmentType().isEmpty()) {
            this.addEnvironmentType();
        }
        return this.getEnvironmentType().get(0);
    }

    public Reference getManagingOrganization() {
        if (this.managingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganization = new Reference();
            }
        }
        return this.managingOrganization;
    }

    public boolean hasManagingOrganization() {
        return this.managingOrganization != null && !this.managingOrganization.isEmpty();
    }

    public Endpoint setManagingOrganization(Reference value) {
        this.managingOrganization = value;
        return this;
    }

    public List<ContactPoint> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        return this.contact;
    }

    public Endpoint setContact(List<ContactPoint> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactPoint item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addContact() {
        ContactPoint t = new ContactPoint();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return t;
    }

    public Endpoint addContact(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactPoint>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactPoint getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Endpoint setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<EndpointPayloadComponent> getPayload() {
        if (this.payload == null) {
            this.payload = new ArrayList<EndpointPayloadComponent>();
        }
        return this.payload;
    }

    public Endpoint setPayload(List<EndpointPayloadComponent> thePayload) {
        this.payload = thePayload;
        return this;
    }

    public boolean hasPayload() {
        if (this.payload == null) {
            return false;
        }
        for (EndpointPayloadComponent item : this.payload) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EndpointPayloadComponent addPayload() {
        EndpointPayloadComponent t = new EndpointPayloadComponent();
        if (this.payload == null) {
            this.payload = new ArrayList<EndpointPayloadComponent>();
        }
        this.payload.add(t);
        return t;
    }

    public Endpoint addPayload(EndpointPayloadComponent t) {
        if (t == null) {
            return this;
        }
        if (this.payload == null) {
            this.payload = new ArrayList<EndpointPayloadComponent>();
        }
        this.payload.add(t);
        return this;
    }

    public EndpointPayloadComponent getPayloadFirstRep() {
        if (this.getPayload().isEmpty()) {
            this.addPayload();
        }
        return this.getPayload().get(0);
    }

    public UrlType getAddressElement() {
        if (this.address == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Endpoint.address");
            }
            if (Configuration.doAutoCreate()) {
                this.address = new UrlType();
            }
        }
        return this.address;
    }

    public boolean hasAddressElement() {
        return this.address != null && !this.address.isEmpty();
    }

    public boolean hasAddress() {
        return this.address != null && !this.address.isEmpty();
    }

    public Endpoint setAddressElement(UrlType value) {
        this.address = value;
        return this;
    }

    public String getAddress() {
        return this.address == null ? null : (String)this.address.getValue();
    }

    public Endpoint setAddress(String value) {
        if (this.address == null) {
            this.address = new UrlType();
        }
        this.address.setValue(value);
        return this;
    }

    public List<StringType> getHeader() {
        if (this.header == null) {
            this.header = new ArrayList<StringType>();
        }
        return this.header;
    }

    public Endpoint setHeader(List<StringType> theHeader) {
        this.header = theHeader;
        return this;
    }

    public boolean hasHeader() {
        if (this.header == null) {
            return false;
        }
        for (StringType item : this.header) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addHeaderElement() {
        StringType t = new StringType();
        if (this.header == null) {
            this.header = new ArrayList<StringType>();
        }
        this.header.add(t);
        return t;
    }

    public Endpoint addHeader(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.header == null) {
            this.header = new ArrayList<StringType>();
        }
        this.header.add(t);
        return this;
    }

    public boolean hasHeader(String value) {
        if (this.header == null) {
            return false;
        }
        for (StringType v : this.header) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for the organization that is used to identify the endpoint across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The endpoint status represents the general expected availability of an endpoint.", 0, 1, this.status));
        children.add(new Property("connectionType", "CodeableConcept", "A coded value that represents the technical details of the usage of this endpoint, such as what WSDLs should be used in what way. (e.g. XDS.b/DICOM/cds-hook).", 0, Integer.MAX_VALUE, this.connectionType));
        children.add(new Property(SP_NAME, "string", "A friendly name that this endpoint can be referred to with.", 0, 1, this.name));
        children.add(new Property("description", "string", "The description of the endpoint and what it is for (typically used as supplemental information in an endpoint directory describing its usage/purpose).", 0, 1, this.description));
        children.add(new Property("environmentType", "CodeableConcept", "The type of environment(s) exposed at this endpoint (dev, prod, test, etc.).", 0, Integer.MAX_VALUE, this.environmentType));
        children.add(new Property("managingOrganization", "Reference(Organization)", "The organization that manages this endpoint (even if technically another organization is hosting this in the cloud, it is the organization associated with the data).", 0, 1, this.managingOrganization));
        children.add(new Property("contact", "ContactPoint", "Contact details for a human to contact about the endpoint. The primary use of this for system administrator troubleshooting.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("period", "Period", "The interval during which the endpoint is expected to be operational.", 0, 1, this.period));
        children.add(new Property("payload", "", "The set of payloads that are provided/available at this endpoint.", 0, Integer.MAX_VALUE, this.payload));
        children.add(new Property("address", "url", "The uri that describes the actual end-point to connect to.", 0, 1, this.address));
        children.add(new Property("header", "string", "Additional headers / information to send as part of the notification.", 0, Integer.MAX_VALUE, this.header));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier for the organization that is used to identify the endpoint across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The endpoint status represents the general expected availability of an endpoint.", 0, 1, this.status);
            }
            case 1270211384: {
                return new Property("connectionType", "CodeableConcept", "A coded value that represents the technical details of the usage of this endpoint, such as what WSDLs should be used in what way. (e.g. XDS.b/DICOM/cds-hook).", 0, Integer.MAX_VALUE, this.connectionType);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A friendly name that this endpoint can be referred to with.", 0, 1, this.name);
            }
            case -1724546052: {
                return new Property("description", "string", "The description of the endpoint and what it is for (typically used as supplemental information in an endpoint directory describing its usage/purpose).", 0, 1, this.description);
            }
            case 1680602093: {
                return new Property("environmentType", "CodeableConcept", "The type of environment(s) exposed at this endpoint (dev, prod, test, etc.).", 0, Integer.MAX_VALUE, this.environmentType);
            }
            case -2058947787: {
                return new Property("managingOrganization", "Reference(Organization)", "The organization that manages this endpoint (even if technically another organization is hosting this in the cloud, it is the organization associated with the data).", 0, 1, this.managingOrganization);
            }
            case 951526432: {
                return new Property("contact", "ContactPoint", "Contact details for a human to contact about the endpoint. The primary use of this for system administrator troubleshooting.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -991726143: {
                return new Property("period", "Period", "The interval during which the endpoint is expected to be operational.", 0, 1, this.period);
            }
            case -786701938: {
                return new Property("payload", "", "The set of payloads that are provided/available at this endpoint.", 0, Integer.MAX_VALUE, this.payload);
            }
            case -1147692044: {
                return new Property("address", "url", "The uri that describes the actual end-point to connect to.", 0, 1, this.address);
            }
            case -1221270899: {
                return new Property("header", "string", "Additional headers / information to send as part of the notification.", 0, Integer.MAX_VALUE, this.header);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 1270211384: {
                return this.connectionType == null ? new Base[]{} : this.connectionType.toArray(new Base[this.connectionType.size()]);
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.description;
                }
                return baseArray;
            }
            case 1680602093: {
                return this.environmentType == null ? new Base[]{} : this.environmentType.toArray(new Base[this.environmentType.size()]);
            }
            case -2058947787: {
                Base[] baseArray;
                if (this.managingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.managingOrganization;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.period;
                }
                return baseArray;
            }
            case -786701938: {
                return this.payload == null ? new Base[]{} : this.payload.toArray(new Base[this.payload.size()]);
            }
            case -1147692044: {
                Base[] baseArray;
                if (this.address == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.address;
                }
                return baseArray;
            }
            case -1221270899: {
                return this.header == null ? new Base[]{} : this.header.toArray(new Base[this.header.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new EndpointStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 1270211384: {
                this.getConnectionType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToString(value);
                return value;
            }
            case 1680602093: {
                this.getEnvironmentType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -2058947787: {
                this.managingOrganization = TypeConvertor.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactPoint(value));
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -786701938: {
                this.getPayload().add((EndpointPayloadComponent)((Object)value));
                return value;
            }
            case -1147692044: {
                this.address = TypeConvertor.castToUrl(value);
                return value;
            }
            case -1221270899: {
                this.getHeader().add(TypeConvertor.castToString(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new EndpointStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("connectionType")) {
            this.getConnectionType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToString(value);
        } else if (name.equals("environmentType")) {
            this.getEnvironmentType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("managingOrganization")) {
            this.managingOrganization = TypeConvertor.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactPoint(value));
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals("payload")) {
            this.getPayload().add((EndpointPayloadComponent)((Object)value));
        } else if (name.equals("address")) {
            this.address = TypeConvertor.castToUrl(value);
        } else if (name.equals("header")) {
            this.getHeader().add(TypeConvertor.castToString(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1270211384: {
                return this.addConnectionType();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 1680602093: {
                return this.addEnvironmentType();
            }
            case -2058947787: {
                return this.getManagingOrganization();
            }
            case 951526432: {
                return this.addContact();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -786701938: {
                return this.addPayload();
            }
            case -1147692044: {
                return this.getAddressElement();
            }
            case -1221270899: {
                return this.addHeaderElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1270211384: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case 1680602093: {
                return new String[]{"CodeableConcept"};
            }
            case -2058947787: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[]{"ContactPoint"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -786701938: {
                return new String[0];
            }
            case -1147692044: {
                return new String[]{"url"};
            }
            case -1221270899: {
                return new String[]{"string"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Endpoint.status");
        }
        if (name.equals("connectionType")) {
            return this.addConnectionType();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Endpoint.name");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Endpoint.description");
        }
        if (name.equals("environmentType")) {
            return this.addEnvironmentType();
        }
        if (name.equals("managingOrganization")) {
            this.managingOrganization = new Reference();
            return this.managingOrganization;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("payload")) {
            return this.addPayload();
        }
        if (name.equals("address")) {
            throw new FHIRException("Cannot call addChild on a primitive type Endpoint.address");
        }
        if (name.equals("header")) {
            throw new FHIRException("Cannot call addChild on a primitive type Endpoint.header");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Endpoint";
    }

    @Override
    public Endpoint copy() {
        Endpoint dst = new Endpoint();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Endpoint dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<EndpointStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.connectionType != null) {
            dst.connectionType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.connectionType) {
                dst.connectionType.add(codeableConcept.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.environmentType != null) {
            dst.environmentType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.environmentType) {
                dst.environmentType.add(codeableConcept.copy());
            }
        }
        Reference reference = dst.managingOrganization = this.managingOrganization == null ? null : this.managingOrganization.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.contact) {
                dst.contact.add(contactPoint.copy());
            }
        }
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.payload != null) {
            dst.payload = new ArrayList<EndpointPayloadComponent>();
            for (EndpointPayloadComponent endpointPayloadComponent : this.payload) {
                dst.payload.add(endpointPayloadComponent.copy());
            }
        }
        UrlType urlType = dst.address = this.address == null ? null : this.address.copy();
        if (this.header != null) {
            dst.header = new ArrayList<StringType>();
            for (StringType stringType2 : this.header) {
                dst.header.add(stringType2.copy());
            }
        }
    }

    protected Endpoint typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Endpoint)) {
            return false;
        }
        Endpoint o = (Endpoint)other_;
        return Endpoint.compareDeep(this.identifier, o.identifier, true) && Endpoint.compareDeep(this.status, o.status, true) && Endpoint.compareDeep(this.connectionType, o.connectionType, true) && Endpoint.compareDeep(this.name, o.name, true) && Endpoint.compareDeep(this.description, o.description, true) && Endpoint.compareDeep(this.environmentType, o.environmentType, true) && Endpoint.compareDeep(this.managingOrganization, o.managingOrganization, true) && Endpoint.compareDeep(this.contact, o.contact, true) && Endpoint.compareDeep(this.period, o.period, true) && Endpoint.compareDeep(this.payload, o.payload, true) && Endpoint.compareDeep(this.address, o.address, true) && Endpoint.compareDeep(this.header, o.header, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Endpoint)) {
            return false;
        }
        Endpoint o = (Endpoint)other_;
        return Endpoint.compareValues(this.status, o.status, true) && Endpoint.compareValues(this.name, o.name, true) && Endpoint.compareValues(this.description, o.description, true) && Endpoint.compareValues(this.address, o.address, true) && Endpoint.compareValues(this.header, o.header, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.connectionType, this.name, this.description, this.environmentType, this.managingOrganization, this.contact, this.period, this.payload, this.address, this.header});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Endpoint;
    }

    @Block
    public static class EndpointPayloadComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The type of content that may be used at this endpoint (e.g. XDS Discharge summaries)", formalDefinition="The payload type describes the acceptable content that can be communicated on the endpoint.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/endpoint-payload-type")
        protected List<CodeableConcept> type;
        @Child(name="mimeType", type={CodeType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Mimetype to send. If not specified, the content could be anything (including no payload, if the connectionType defined this)", formalDefinition="The mime type to send the payload in - e.g. application/fhir+xml, application/fhir+json. If the mime type is not specified, then the sender could send any content (including no content depending on the connectionType).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
        protected List<CodeType> mimeType;
        private static final long serialVersionUID = -1398955844L;

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public EndpointPayloadComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public EndpointPayloadComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public List<CodeType> getMimeType() {
            if (this.mimeType == null) {
                this.mimeType = new ArrayList<CodeType>();
            }
            return this.mimeType;
        }

        public EndpointPayloadComponent setMimeType(List<CodeType> theMimeType) {
            this.mimeType = theMimeType;
            return this;
        }

        public boolean hasMimeType() {
            if (this.mimeType == null) {
                return false;
            }
            for (CodeType item : this.mimeType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addMimeTypeElement() {
            CodeType t = new CodeType();
            if (this.mimeType == null) {
                this.mimeType = new ArrayList<CodeType>();
            }
            this.mimeType.add(t);
            return t;
        }

        public EndpointPayloadComponent addMimeType(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.mimeType == null) {
                this.mimeType = new ArrayList<CodeType>();
            }
            this.mimeType.add(t);
            return this;
        }

        public boolean hasMimeType(String value) {
            if (this.mimeType == null) {
                return false;
            }
            for (CodeType v : this.mimeType) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "The payload type describes the acceptable content that can be communicated on the endpoint.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("mimeType", "code", "The mime type to send the payload in - e.g. application/fhir+xml, application/fhir+json. If the mime type is not specified, then the sender could send any content (including no content depending on the connectionType).", 0, Integer.MAX_VALUE, this.mimeType));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "The payload type describes the acceptable content that can be communicated on the endpoint.", 0, Integer.MAX_VALUE, this.type);
                }
                case -1392120434: {
                    return new Property("mimeType", "code", "The mime type to send the payload in - e.g. application/fhir+xml, application/fhir+json. If the mime type is not specified, then the sender could send any content (including no content depending on the connectionType).", 0, Integer.MAX_VALUE, this.mimeType);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -1392120434: {
                    return this.mimeType == null ? new Base[]{} : this.mimeType.toArray(new Base[this.mimeType.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1392120434: {
                    this.getMimeType().add(TypeConvertor.castToCode(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("mimeType")) {
                this.getMimeType().add(TypeConvertor.castToCode(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.addType();
                }
                case -1392120434: {
                    return this.addMimeTypeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1392120434: {
                    return new String[]{"code"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                return this.addType();
            }
            if (name.equals("mimeType")) {
                throw new FHIRException("Cannot call addChild on a primitive type Endpoint.payload.mimeType");
            }
            return super.addChild(name);
        }

        @Override
        public EndpointPayloadComponent copy() {
            EndpointPayloadComponent dst = new EndpointPayloadComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EndpointPayloadComponent dst) {
            super.copyValues(dst);
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.type) {
                    dst.type.add(codeableConcept.copy());
                }
            }
            if (this.mimeType != null) {
                dst.mimeType = new ArrayList<CodeType>();
                for (CodeType codeType : this.mimeType) {
                    dst.mimeType.add(codeType.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EndpointPayloadComponent)) {
                return false;
            }
            EndpointPayloadComponent o = (EndpointPayloadComponent)other_;
            return EndpointPayloadComponent.compareDeep(this.type, o.type, true) && EndpointPayloadComponent.compareDeep(this.mimeType, o.mimeType, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EndpointPayloadComponent)) {
                return false;
            }
            EndpointPayloadComponent o = (EndpointPayloadComponent)other_;
            return EndpointPayloadComponent.compareValues(this.mimeType, o.mimeType, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.mimeType});
        }

        @Override
        public String fhirType() {
            return "Endpoint.payload";
        }
    }

    public static class EndpointStatusEnumFactory
    implements EnumFactory<EndpointStatus> {
        @Override
        public EndpointStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return EndpointStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return EndpointStatus.SUSPENDED;
            }
            if ("error".equals(codeString)) {
                return EndpointStatus.ERROR;
            }
            if ("off".equals(codeString)) {
                return EndpointStatus.OFF;
            }
            if ("entered-in-error".equals(codeString)) {
                return EndpointStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown EndpointStatus code '" + codeString + "'");
        }

        public Enumeration<EndpointStatus> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.NULL, code);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.ACTIVE, code);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.SUSPENDED, code);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.ERROR, code);
            }
            if ("off".equals(codeString)) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.OFF, code);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<EndpointStatus>(this, EndpointStatus.ENTEREDINERROR, code);
            }
            throw new FHIRException("Unknown EndpointStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EndpointStatus code) {
            if (code == EndpointStatus.ACTIVE) {
                return "active";
            }
            if (code == EndpointStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == EndpointStatus.ERROR) {
                return "error";
            }
            if (code == EndpointStatus.OFF) {
                return "off";
            }
            if (code == EndpointStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }

        @Override
        public String toSystem(EndpointStatus code) {
            return code.getSystem();
        }
    }

    public static enum EndpointStatus {
        ACTIVE,
        SUSPENDED,
        ERROR,
        OFF,
        ENTEREDINERROR,
        NULL;


        public static EndpointStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("off".equals(codeString)) {
                return OFF;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EndpointStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case ERROR: {
                    return "error";
                }
                case OFF: {
                    return "off";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/endpoint-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/endpoint-status";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/endpoint-status";
                }
                case OFF: {
                    return "http://hl7.org/fhir/endpoint-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/endpoint-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "This endpoint is expected to be active and can be used.";
                }
                case SUSPENDED: {
                    return "This endpoint is temporarily unavailable.";
                }
                case ERROR: {
                    return "This endpoint has exceeded connectivity thresholds and is considered in an error state and should no longer be attempted to connect to until corrective action is taken.";
                }
                case OFF: {
                    return "This endpoint is no longer to be used.";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case ERROR: {
                    return "Error";
                }
                case OFF: {
                    return "Off";
                }
                case ENTEREDINERROR: {
                    return "Entered in error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

