/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.conformance;

import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.VersionUtilities;

public class StructureDefinitionHacker {
    private String version;

    public StructureDefinitionHacker(String version) {
        this.version = version;
    }

    public Resource fixSD(StructureDefinition sd) {
        if (VersionUtilities.isR4Ver((String)this.version) && "http://hl7.org/fhir/StructureDefinition/example-composition".equals(sd.getUrl())) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                this.fixDocSecURL(ed);
            }
            for (ElementDefinition ed : sd.getDifferential().getElement()) {
                this.fixDocSecURL(ed);
            }
        }
        return sd;
    }

    private void fixDocSecURL(ElementDefinition ed) {
        for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
            for (CanonicalType c : tr.getProfile()) {
                if (!"http://hl7.org/fhir/StructureDefinition/document-section-library".equals(c.getValue())) continue;
                c.setValue("http://hl7.org/fhir/StructureDefinition/example-section-library");
            }
        }
    }
}

