/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Availability;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.ExtendedContactDetail;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="PractitionerRole", profile="http://hl7.org/fhir/StructureDefinition/PractitionerRole")
public class PractitionerRole
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifiers that are specific to a role/location", formalDefinition="Business Identifiers that are specific to a role/location.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether this practitioner role record is in active use", formalDefinition="Whether this practitioner role record is in active use.")
    protected BooleanType active;
    @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The period during which the practitioner is authorized to perform in these role(s)", formalDefinition="The period during which the person is authorized to act as a practitioner in these role(s) for the organization.")
    protected Period period;
    @Child(name="practitioner", type={Practitioner.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Practitioner that is able to provide the defined services for the organization", formalDefinition="Practitioner that is able to provide the defined services for the organization.")
    protected Reference practitioner;
    @Child(name="organization", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization where the roles are available", formalDefinition="The organization where the Practitioner performs the roles associated.")
    protected Reference organization;
    @Child(name="code", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Roles which this practitioner may perform", formalDefinition="Roles which this practitioner is authorized to perform for the organization.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/practitioner-role")
    protected List<CodeableConcept> code;
    @Child(name="specialty", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific specialty of the practitioner", formalDefinition="The specialty of a practitioner that describes the functional role they are practicing at a given organization or location.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    protected List<CodeableConcept> specialty;
    @Child(name="location", type={Location.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The location(s) at which this practitioner provides care", formalDefinition="The location(s) at which this practitioner provides care.")
    protected List<Reference> location;
    @Child(name="healthcareService", type={HealthcareService.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The list of healthcare services that this worker provides for this role's Organization/Location(s)", formalDefinition="The list of healthcare services that this worker provides for this role's Organization/Location(s).")
    protected List<Reference> healthcareService;
    @Child(name="contact", type={ExtendedContactDetail.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Official contact details relating to this PractitionerRole", formalDefinition="The contact details of communication devices available relevant to the specific PractitionerRole. This can include addresses, phone numbers, fax numbers, mobile numbers, email addresses and web sites.")
    protected List<ExtendedContactDetail> contact;
    @Child(name="availability", type={Availability.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Times the Practitioner is available at this location and/or healthcare service (including exceptions)", formalDefinition="A collection of times the practitioner is available or performing this role at the location and/or healthcareservice.")
    protected List<Availability> availability;
    @Child(name="endpoint", type={Endpoint.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Technical endpoints providing access to services operated for the practitioner with this role", formalDefinition="Technical endpoints providing access to services operated for the practitioner with this role.")
    protected List<Reference> endpoint;
    private static final long serialVersionUID = -309346881L;
    @SearchParamDefinition(name="active", path="PractitionerRole.active", description="Whether this practitioner role record is in active use", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="date", path="PractitionerRole.period", description="The period during which the practitioner is authorized to perform in these role(s)", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="endpoint", path="PractitionerRole.endpoint", description="Technical endpoints providing access to services operated for the practitioner with this role", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("PractitionerRole:endpoint").toLocked();
    @SearchParamDefinition(name="identifier", path="PractitionerRole.identifier", description="A practitioner's Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="location", path="PractitionerRole.location", description="One of the locations at which this practitioner provides care", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("PractitionerRole:location").toLocked();
    @SearchParamDefinition(name="organization", path="PractitionerRole.organization", description="The identity of the organization the practitioner represents / acts on behalf of", type="reference", target={Organization.class})
    public static final String SP_ORGANIZATION = "organization";
    public static final ReferenceClientParam ORGANIZATION = new ReferenceClientParam("organization");
    public static final Include INCLUDE_ORGANIZATION = new Include("PractitionerRole:organization").toLocked();
    @SearchParamDefinition(name="practitioner", path="PractitionerRole.practitioner", description="Practitioner that is able to provide the defined services for the organization", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Practitioner.class})
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_PRACTITIONER = new Include("PractitionerRole:practitioner").toLocked();
    @SearchParamDefinition(name="role", path="PractitionerRole.code", description="The practitioner can perform this role at for the organization", type="token")
    public static final String SP_ROLE = "role";
    public static final TokenClientParam ROLE = new TokenClientParam("role");
    @SearchParamDefinition(name="service", path="PractitionerRole.healthcareService", description="The list of healthcare services that this worker provides for this role's Organization/Location(s)", type="reference", target={HealthcareService.class})
    public static final String SP_SERVICE = "service";
    public static final ReferenceClientParam SERVICE = new ReferenceClientParam("service");
    public static final Include INCLUDE_SERVICE = new Include("PractitionerRole:service").toLocked();
    @SearchParamDefinition(name="specialty", path="PractitionerRole.specialty", description="The practitioner has this specialty at an organization", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="email", path="Patient.telecom.where(system='email') | Person.telecom.where(system='email') | Practitioner.telecom.where(system='email') | PractitionerRole.contact.telecom.where(system='email') | RelatedPerson.telecom.where(system='email')", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): A value in an email contact\r\n* [Person](person.html): A value in an email contact\r\n* [Practitioner](practitioner.html): A value in an email contact\r\n* [PractitionerRole](practitionerrole.html): A value in an email contact\r\n* [RelatedPerson](relatedperson.html): A value in an email contact\r\n", type="token")
    public static final String SP_EMAIL = "email";
    public static final TokenClientParam EMAIL = new TokenClientParam("email");
    @SearchParamDefinition(name="phone", path="Patient.telecom.where(system='phone') | Person.telecom.where(system='phone') | Practitioner.telecom.where(system='phone') | PractitionerRole.contact.telecom.where(system='phone') | RelatedPerson.telecom.where(system='phone')", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): A value in a phone contact\r\n* [Person](person.html): A value in a phone contact\r\n* [Practitioner](practitioner.html): A value in a phone contact\r\n* [PractitionerRole](practitionerrole.html): A value in a phone contact\r\n* [RelatedPerson](relatedperson.html): A value in a phone contact\r\n", type="token")
    public static final String SP_PHONE = "phone";
    public static final TokenClientParam PHONE = new TokenClientParam("phone");
    @SearchParamDefinition(name="telecom", path="Patient.telecom | Person.telecom | Practitioner.telecom | PractitionerRole.contact.telecom | RelatedPerson.telecom", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): The value in any kind of telecom details of the patient\r\n* [Person](person.html): The value in any kind of contact\r\n* [Practitioner](practitioner.html): The value in any kind of contact\r\n* [PractitionerRole](practitionerrole.html): The value in any kind of contact\r\n* [RelatedPerson](relatedperson.html): The value in any kind of contact\r\n", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public PractitionerRole setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PractitionerRole addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PractitionerRole.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public PractitionerRole setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public PractitionerRole setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PractitionerRole.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public PractitionerRole setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getPractitioner() {
        if (this.practitioner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PractitionerRole.practitioner");
            }
            if (Configuration.doAutoCreate()) {
                this.practitioner = new Reference();
            }
        }
        return this.practitioner;
    }

    public boolean hasPractitioner() {
        return this.practitioner != null && !this.practitioner.isEmpty();
    }

    public PractitionerRole setPractitioner(Reference value) {
        this.practitioner = value;
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PractitionerRole.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public PractitionerRole setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public List<CodeableConcept> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<CodeableConcept>();
        }
        return this.code;
    }

    public PractitionerRole setCode(List<CodeableConcept> theCode) {
        this.code = theCode;
        return this;
    }

    public boolean hasCode() {
        if (this.code == null) {
            return false;
        }
        for (CodeableConcept item : this.code) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.code == null) {
            this.code = new ArrayList<CodeableConcept>();
        }
        this.code.add(t);
        return t;
    }

    public PractitionerRole addCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.code == null) {
            this.code = new ArrayList<CodeableConcept>();
        }
        this.code.add(t);
        return this;
    }

    public CodeableConcept getCodeFirstRep() {
        if (this.getCode().isEmpty()) {
            this.addCode();
        }
        return this.getCode().get(0);
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public PractitionerRole setSpecialty(List<CodeableConcept> theSpecialty) {
        this.specialty = theSpecialty;
        return this;
    }

    public boolean hasSpecialty() {
        if (this.specialty == null) {
            return false;
        }
        for (CodeableConcept item : this.specialty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialty() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return t;
    }

    public PractitionerRole addSpecialty(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return this;
    }

    public CodeableConcept getSpecialtyFirstRep() {
        if (this.getSpecialty().isEmpty()) {
            this.addSpecialty();
        }
        return this.getSpecialty().get(0);
    }

    public List<Reference> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        return this.location;
    }

    public PractitionerRole setLocation(List<Reference> theLocation) {
        this.location = theLocation;
        return this;
    }

    public boolean hasLocation() {
        if (this.location == null) {
            return false;
        }
        for (Reference item : this.location) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addLocation() {
        Reference t = new Reference();
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        this.location.add(t);
        return t;
    }

    public PractitionerRole addLocation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        this.location.add(t);
        return this;
    }

    public Reference getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            this.addLocation();
        }
        return this.getLocation().get(0);
    }

    public List<Reference> getHealthcareService() {
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        return this.healthcareService;
    }

    public PractitionerRole setHealthcareService(List<Reference> theHealthcareService) {
        this.healthcareService = theHealthcareService;
        return this;
    }

    public boolean hasHealthcareService() {
        if (this.healthcareService == null) {
            return false;
        }
        for (Reference item : this.healthcareService) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addHealthcareService() {
        Reference t = new Reference();
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        this.healthcareService.add(t);
        return t;
    }

    public PractitionerRole addHealthcareService(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        this.healthcareService.add(t);
        return this;
    }

    public Reference getHealthcareServiceFirstRep() {
        if (this.getHealthcareService().isEmpty()) {
            this.addHealthcareService();
        }
        return this.getHealthcareService().get(0);
    }

    public List<ExtendedContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ExtendedContactDetail>();
        }
        return this.contact;
    }

    public PractitionerRole setContact(List<ExtendedContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ExtendedContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ExtendedContactDetail addContact() {
        ExtendedContactDetail t = new ExtendedContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ExtendedContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    public PractitionerRole addContact(ExtendedContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ExtendedContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    public ExtendedContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public List<Availability> getAvailability() {
        if (this.availability == null) {
            this.availability = new ArrayList<Availability>();
        }
        return this.availability;
    }

    public PractitionerRole setAvailability(List<Availability> theAvailability) {
        this.availability = theAvailability;
        return this;
    }

    public boolean hasAvailability() {
        if (this.availability == null) {
            return false;
        }
        for (Availability item : this.availability) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Availability addAvailability() {
        Availability t = new Availability();
        if (this.availability == null) {
            this.availability = new ArrayList<Availability>();
        }
        this.availability.add(t);
        return t;
    }

    public PractitionerRole addAvailability(Availability t) {
        if (t == null) {
            return this;
        }
        if (this.availability == null) {
            this.availability = new ArrayList<Availability>();
        }
        this.availability.add(t);
        return this;
    }

    public Availability getAvailabilityFirstRep() {
        if (this.getAvailability().isEmpty()) {
            this.addAvailability();
        }
        return this.getAvailability().get(0);
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public PractitionerRole setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public PractitionerRole addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business Identifiers that are specific to a role/location.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_ACTIVE, "boolean", "Whether this practitioner role record is in active use.", 0, 1, this.active));
        children.add(new Property("period", "Period", "The period during which the person is authorized to act as a practitioner in these role(s) for the organization.", 0, 1, this.period));
        children.add(new Property(SP_PRACTITIONER, "Reference(Practitioner)", "Practitioner that is able to provide the defined services for the organization.", 0, 1, this.practitioner));
        children.add(new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization where the Practitioner performs the roles associated.", 0, 1, this.organization));
        children.add(new Property("code", "CodeableConcept", "Roles which this practitioner is authorized to perform for the organization.", 0, Integer.MAX_VALUE, this.code));
        children.add(new Property(SP_SPECIALTY, "CodeableConcept", "The specialty of a practitioner that describes the functional role they are practicing at a given organization or location.", 0, Integer.MAX_VALUE, this.specialty));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The location(s) at which this practitioner provides care.", 0, Integer.MAX_VALUE, this.location));
        children.add(new Property("healthcareService", "Reference(HealthcareService)", "The list of healthcare services that this worker provides for this role's Organization/Location(s).", 0, Integer.MAX_VALUE, this.healthcareService));
        children.add(new Property("contact", "ExtendedContactDetail", "The contact details of communication devices available relevant to the specific PractitionerRole. This can include addresses, phone numbers, fax numbers, mobile numbers, email addresses and web sites.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("availability", "Availability", "A collection of times the practitioner is available or performing this role at the location and/or healthcareservice.", 0, Integer.MAX_VALUE, this.availability));
        children.add(new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the practitioner with this role.", 0, Integer.MAX_VALUE, this.endpoint));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business Identifiers that are specific to a role/location.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property(SP_ACTIVE, "boolean", "Whether this practitioner role record is in active use.", 0, 1, this.active);
            }
            case -991726143: {
                return new Property("period", "Period", "The period during which the person is authorized to act as a practitioner in these role(s) for the organization.", 0, 1, this.period);
            }
            case 574573338: {
                return new Property(SP_PRACTITIONER, "Reference(Practitioner)", "Practitioner that is able to provide the defined services for the organization.", 0, 1, this.practitioner);
            }
            case 1178922291: {
                return new Property(SP_ORGANIZATION, "Reference(Organization)", "The organization where the Practitioner performs the roles associated.", 0, 1, this.organization);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "Roles which this practitioner is authorized to perform for the organization.", 0, Integer.MAX_VALUE, this.code);
            }
            case -1694759682: {
                return new Property(SP_SPECIALTY, "CodeableConcept", "The specialty of a practitioner that describes the functional role they are practicing at a given organization or location.", 0, Integer.MAX_VALUE, this.specialty);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The location(s) at which this practitioner provides care.", 0, Integer.MAX_VALUE, this.location);
            }
            case 1289661064: {
                return new Property("healthcareService", "Reference(HealthcareService)", "The list of healthcare services that this worker provides for this role's Organization/Location(s).", 0, Integer.MAX_VALUE, this.healthcareService);
            }
            case 951526432: {
                return new Property("contact", "ExtendedContactDetail", "The contact details of communication devices available relevant to the specific PractitionerRole. This can include addresses, phone numbers, fax numbers, mobile numbers, email addresses and web sites.", 0, Integer.MAX_VALUE, this.contact);
            }
            case 1997542747: {
                return new Property("availability", "Availability", "A collection of times the practitioner is available or performing this role at the location and/or healthcareservice.", 0, Integer.MAX_VALUE, this.availability);
            }
            case 1741102485: {
                return new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for the practitioner with this role.", 0, Integer.MAX_VALUE, this.endpoint);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.period;
                }
                return baseArray;
            }
            case 574573338: {
                Base[] baseArray;
                if (this.practitioner == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.practitioner;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.organization;
                }
                return baseArray;
            }
            case 3059181: {
                return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
            }
            case -1694759682: {
                return this.specialty == null ? new Base[]{} : this.specialty.toArray(new Base[this.specialty.size()]);
            }
            case 1901043637: {
                return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
            }
            case 1289661064: {
                return this.healthcareService == null ? new Base[]{} : this.healthcareService.toArray(new Base[this.healthcareService.size()]);
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case 1997542747: {
                return this.availability == null ? new Base[]{} : this.availability.toArray(new Base[this.availability.size()]);
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 574573338: {
                this.practitioner = TypeConvertor.castToReference(value);
                return value;
            }
            case 1178922291: {
                this.organization = TypeConvertor.castToReference(value);
                return value;
            }
            case 3059181: {
                this.getCode().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1694759682: {
                this.getSpecialty().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1901043637: {
                this.getLocation().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1289661064: {
                this.getHealthcareService().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToExtendedContactDetail(value));
                return value;
            }
            case 1997542747: {
                this.getAvailability().add(TypeConvertor.castToAvailability(value));
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = TypeConvertor.castToBoolean(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_PRACTITIONER)) {
            this.practitioner = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ORGANIZATION)) {
            this.organization = TypeConvertor.castToReference(value);
        } else if (name.equals("code")) {
            this.getCode().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SPECIALTY)) {
            this.getSpecialty().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_LOCATION)) {
            this.getLocation().add(TypeConvertor.castToReference(value));
        } else if (name.equals("healthcareService")) {
            this.getHealthcareService().add(TypeConvertor.castToReference(value));
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToExtendedContactDetail(value));
        } else if (name.equals("availability")) {
            this.getAvailability().add(TypeConvertor.castToAvailability(value));
        } else if (name.equals(SP_ENDPOINT)) {
            this.getEndpoint().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 574573338: {
                return this.getPractitioner();
            }
            case 1178922291: {
                return this.getOrganization();
            }
            case 3059181: {
                return this.addCode();
            }
            case -1694759682: {
                return this.addSpecialty();
            }
            case 1901043637: {
                return this.addLocation();
            }
            case 1289661064: {
                return this.addHealthcareService();
            }
            case 951526432: {
                return this.addContact();
            }
            case 1997542747: {
                return this.addAvailability();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 574573338: {
                return new String[]{"Reference"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1694759682: {
                return new String[]{"CodeableConcept"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 1289661064: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[]{"ExtendedContactDetail"};
            }
            case 1997542747: {
                return new String[]{"Availability"};
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a primitive type PractitionerRole.active");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_PRACTITIONER)) {
            this.practitioner = new Reference();
            return this.practitioner;
        }
        if (name.equals(SP_ORGANIZATION)) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("code")) {
            return this.addCode();
        }
        if (name.equals(SP_SPECIALTY)) {
            return this.addSpecialty();
        }
        if (name.equals(SP_LOCATION)) {
            return this.addLocation();
        }
        if (name.equals("healthcareService")) {
            return this.addHealthcareService();
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("availability")) {
            return this.addAvailability();
        }
        if (name.equals(SP_ENDPOINT)) {
            return this.addEndpoint();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PractitionerRole";
    }

    @Override
    public PractitionerRole copy() {
        PractitionerRole dst = new PractitionerRole();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(PractitionerRole dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.active = this.active == null ? null : this.active.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.practitioner = this.practitioner == null ? null : this.practitioner.copy();
        Reference reference = dst.organization = this.organization == null ? null : this.organization.copy();
        if (this.code != null) {
            dst.code = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.code) {
                dst.code.add(codeableConcept.copy());
            }
        }
        if (this.specialty != null) {
            dst.specialty = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.specialty) {
                dst.specialty.add(codeableConcept.copy());
            }
        }
        if (this.location != null) {
            dst.location = new ArrayList<Reference>();
            for (Reference reference2 : this.location) {
                dst.location.add(reference2.copy());
            }
        }
        if (this.healthcareService != null) {
            dst.healthcareService = new ArrayList<Reference>();
            for (Reference reference3 : this.healthcareService) {
                dst.healthcareService.add(reference3.copy());
            }
        }
        if (this.contact != null) {
            dst.contact = new ArrayList<ExtendedContactDetail>();
            for (ExtendedContactDetail extendedContactDetail : this.contact) {
                dst.contact.add(extendedContactDetail.copy());
            }
        }
        if (this.availability != null) {
            dst.availability = new ArrayList<Availability>();
            for (Availability availability : this.availability) {
                dst.availability.add(availability.copy());
            }
        }
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference4 : this.endpoint) {
                dst.endpoint.add(reference4.copy());
            }
        }
    }

    protected PractitionerRole typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PractitionerRole)) {
            return false;
        }
        PractitionerRole o = (PractitionerRole)other_;
        return PractitionerRole.compareDeep(this.identifier, o.identifier, true) && PractitionerRole.compareDeep(this.active, o.active, true) && PractitionerRole.compareDeep(this.period, o.period, true) && PractitionerRole.compareDeep(this.practitioner, o.practitioner, true) && PractitionerRole.compareDeep(this.organization, o.organization, true) && PractitionerRole.compareDeep(this.code, o.code, true) && PractitionerRole.compareDeep(this.specialty, o.specialty, true) && PractitionerRole.compareDeep(this.location, o.location, true) && PractitionerRole.compareDeep(this.healthcareService, o.healthcareService, true) && PractitionerRole.compareDeep(this.contact, o.contact, true) && PractitionerRole.compareDeep(this.availability, o.availability, true) && PractitionerRole.compareDeep(this.endpoint, o.endpoint, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PractitionerRole)) {
            return false;
        }
        PractitionerRole o = (PractitionerRole)other_;
        return PractitionerRole.compareValues(this.active, o.active, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.active, this.period, this.practitioner, this.organization, this.code, this.specialty, this.location, this.healthcareService, this.contact, this.availability, this.endpoint});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PractitionerRole;
    }
}

