/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.IdType;

public abstract class BaseReference
extends DataType
implements IBaseReference,
ICompositeType {
    private transient IBaseResource resource;

    public BaseReference(String theReference) {
        this.setReference(theReference);
    }

    public BaseReference(IIdType theReference) {
        if (theReference != null) {
            this.setReference(theReference.getValue());
        } else {
            this.setReference(null);
        }
    }

    public BaseReference(IAnyResource theResource) {
        this.resource = theResource;
    }

    public BaseReference() {
    }

    public IBaseResource getResource() {
        return this.resource;
    }

    public IIdType getReferenceElement() {
        return new IdType(this.getReference());
    }

    abstract String getReference();

    public IBaseReference setResource(IBaseResource theResource) {
        this.resource = theResource;
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.resource == null && super.isEmpty();
    }

    @Override
    public void copyValues(Element dst) {
        super.copyValues(dst);
        if (this.resource != null && dst instanceof BaseReference) {
            ((BaseReference)dst).setResource(this.resource);
        }
    }
}

