/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatypeElement;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Availability")
public class Availability
extends DataType
implements ICompositeType {
    @Child(name="availableTime", type={}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Times the {item} is available", formalDefinition="Times the {item} is available.")
    protected List<AvailabilityAvailableTimeComponent> availableTime;
    @Child(name="notAvailableTime", type={}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Not available during this time due to provided reason", formalDefinition="Not available during this time due to provided reason.")
    protected List<AvailabilityNotAvailableTimeComponent> notAvailableTime;
    private static final long serialVersionUID = -444820754L;

    public List<AvailabilityAvailableTimeComponent> getAvailableTime() {
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<AvailabilityAvailableTimeComponent>();
        }
        return this.availableTime;
    }

    public Availability setAvailableTime(List<AvailabilityAvailableTimeComponent> theAvailableTime) {
        this.availableTime = theAvailableTime;
        return this;
    }

    public boolean hasAvailableTime() {
        if (this.availableTime == null) {
            return false;
        }
        for (AvailabilityAvailableTimeComponent item : this.availableTime) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AvailabilityAvailableTimeComponent addAvailableTime() {
        AvailabilityAvailableTimeComponent t = new AvailabilityAvailableTimeComponent();
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<AvailabilityAvailableTimeComponent>();
        }
        this.availableTime.add(t);
        return t;
    }

    public Availability addAvailableTime(AvailabilityAvailableTimeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.availableTime == null) {
            this.availableTime = new ArrayList<AvailabilityAvailableTimeComponent>();
        }
        this.availableTime.add(t);
        return this;
    }

    public AvailabilityAvailableTimeComponent getAvailableTimeFirstRep() {
        if (this.getAvailableTime().isEmpty()) {
            this.addAvailableTime();
        }
        return this.getAvailableTime().get(0);
    }

    public List<AvailabilityNotAvailableTimeComponent> getNotAvailableTime() {
        if (this.notAvailableTime == null) {
            this.notAvailableTime = new ArrayList<AvailabilityNotAvailableTimeComponent>();
        }
        return this.notAvailableTime;
    }

    public Availability setNotAvailableTime(List<AvailabilityNotAvailableTimeComponent> theNotAvailableTime) {
        this.notAvailableTime = theNotAvailableTime;
        return this;
    }

    public boolean hasNotAvailableTime() {
        if (this.notAvailableTime == null) {
            return false;
        }
        for (AvailabilityNotAvailableTimeComponent item : this.notAvailableTime) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AvailabilityNotAvailableTimeComponent addNotAvailableTime() {
        AvailabilityNotAvailableTimeComponent t = new AvailabilityNotAvailableTimeComponent();
        if (this.notAvailableTime == null) {
            this.notAvailableTime = new ArrayList<AvailabilityNotAvailableTimeComponent>();
        }
        this.notAvailableTime.add(t);
        return t;
    }

    public Availability addNotAvailableTime(AvailabilityNotAvailableTimeComponent t) {
        if (t == null) {
            return this;
        }
        if (this.notAvailableTime == null) {
            this.notAvailableTime = new ArrayList<AvailabilityNotAvailableTimeComponent>();
        }
        this.notAvailableTime.add(t);
        return this;
    }

    public AvailabilityNotAvailableTimeComponent getNotAvailableTimeFirstRep() {
        if (this.getNotAvailableTime().isEmpty()) {
            this.addNotAvailableTime();
        }
        return this.getNotAvailableTime().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("availableTime", "", "Times the {item} is available.", 0, Integer.MAX_VALUE, this.availableTime));
        children.add(new Property("notAvailableTime", "", "Not available during this time due to provided reason.", 0, Integer.MAX_VALUE, this.notAvailableTime));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 1873069366: {
                return new Property("availableTime", "", "Times the {item} is available.", 0, Integer.MAX_VALUE, this.availableTime);
            }
            case -627853021: {
                return new Property("notAvailableTime", "", "Not available during this time due to provided reason.", 0, Integer.MAX_VALUE, this.notAvailableTime);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 1873069366: {
                return this.availableTime == null ? new Base[]{} : this.availableTime.toArray(new Base[this.availableTime.size()]);
            }
            case -627853021: {
                return this.notAvailableTime == null ? new Base[]{} : this.notAvailableTime.toArray(new Base[this.notAvailableTime.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 1873069366: {
                this.getAvailableTime().add((AvailabilityAvailableTimeComponent)value);
                return value;
            }
            case -627853021: {
                this.getNotAvailableTime().add((AvailabilityNotAvailableTimeComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("availableTime")) {
            this.getAvailableTime().add((AvailabilityAvailableTimeComponent)value);
        } else if (name.equals("notAvailableTime")) {
            this.getNotAvailableTime().add((AvailabilityNotAvailableTimeComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1873069366: {
                return this.addAvailableTime();
            }
            case -627853021: {
                return this.addNotAvailableTime();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 1873069366: {
                return new String[0];
            }
            case -627853021: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("availableTime")) {
            return this.addAvailableTime();
        }
        if (name.equals("notAvailableTime")) {
            return this.addNotAvailableTime();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Availability";
    }

    @Override
    public Availability copy() {
        Availability dst = new Availability();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Availability dst) {
        super.copyValues(dst);
        if (this.availableTime != null) {
            dst.availableTime = new ArrayList<AvailabilityAvailableTimeComponent>();
            for (AvailabilityAvailableTimeComponent availabilityAvailableTimeComponent : this.availableTime) {
                dst.availableTime.add(availabilityAvailableTimeComponent.copy());
            }
        }
        if (this.notAvailableTime != null) {
            dst.notAvailableTime = new ArrayList<AvailabilityNotAvailableTimeComponent>();
            for (AvailabilityNotAvailableTimeComponent availabilityNotAvailableTimeComponent : this.notAvailableTime) {
                dst.notAvailableTime.add(availabilityNotAvailableTimeComponent.copy());
            }
        }
    }

    protected Availability typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Availability)) {
            return false;
        }
        Availability o = (Availability)other_;
        return Availability.compareDeep(this.availableTime, o.availableTime, true) && Availability.compareDeep(this.notAvailableTime, o.notAvailableTime, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Availability)) {
            return false;
        }
        Availability o = (Availability)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.availableTime, this.notAvailableTime});
    }

    @Block
    public static class AvailabilityNotAvailableTimeComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reason presented to the user explaining why time not available", formalDefinition="Reason presented to the user explaining why time not available.")
        protected StringType description;
        @Child(name="during", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service not available during this period", formalDefinition="Service not available during this period.")
        protected Period during;
        private static final long serialVersionUID = 310849929L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AvailabilityNotAvailableTimeComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public AvailabilityNotAvailableTimeComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public AvailabilityNotAvailableTimeComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Period getDuring() {
            if (this.during == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AvailabilityNotAvailableTimeComponent.during");
                }
                if (Configuration.doAutoCreate()) {
                    this.during = new Period();
                }
            }
            return this.during;
        }

        public boolean hasDuring() {
            return this.during != null && !this.during.isEmpty();
        }

        public AvailabilityNotAvailableTimeComponent setDuring(Period value) {
            this.during = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "Reason presented to the user explaining why time not available.", 0, 1, this.description));
            children.add(new Property("during", "Period", "Service not available during this period.", 0, 1, this.during));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "Reason presented to the user explaining why time not available.", 0, 1, this.description);
                }
                case -1320499647: {
                    return new Property("during", "Period", "Service not available during this period.", 0, 1, this.during);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1320499647: {
                    Base[] baseArray;
                    if (this.during == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.during;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -1320499647: {
                    this.during = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("during")) {
                this.during = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1320499647: {
                    return this.getDuring();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1320499647: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Availability.notAvailableTime.description");
            }
            if (name.equals("during")) {
                this.during = new Period();
                return this.during;
            }
            return super.addChild(name);
        }

        @Override
        public AvailabilityNotAvailableTimeComponent copy() {
            AvailabilityNotAvailableTimeComponent dst = new AvailabilityNotAvailableTimeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AvailabilityNotAvailableTimeComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.during = this.during == null ? null : this.during.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AvailabilityNotAvailableTimeComponent)) {
                return false;
            }
            AvailabilityNotAvailableTimeComponent o = (AvailabilityNotAvailableTimeComponent)other_;
            return AvailabilityNotAvailableTimeComponent.compareDeep(this.description, o.description, true) && AvailabilityNotAvailableTimeComponent.compareDeep(this.during, o.during, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AvailabilityNotAvailableTimeComponent)) {
                return false;
            }
            AvailabilityNotAvailableTimeComponent o = (AvailabilityNotAvailableTimeComponent)other_;
            return AvailabilityNotAvailableTimeComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.during});
        }

        @Override
        public String fhirType() {
            return "Availability.notAvailableTime";
        }
    }

    @Block
    public static class AvailabilityAvailableTimeComponent
    extends Element
    implements IBaseDatatypeElement {
        @Child(name="daysOfWeek", type={CodeType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="mon | tue | wed | thu | fri | sat | sun", formalDefinition="mon | tue | wed | thu | fri | sat | sun.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/days-of-week")
        protected List<Enumeration<Enumerations.DaysOfWeek>> daysOfWeek;
        @Child(name="allDay", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Always available? i.e. 24 hour service", formalDefinition="Always available? i.e. 24 hour service.")
        protected BooleanType allDay;
        @Child(name="availableStartTime", type={TimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Opening time of day (ignored if allDay = true)", formalDefinition="Opening time of day (ignored if allDay = true).")
        protected TimeType availableStartTime;
        @Child(name="availableEndTime", type={TimeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Closing time of day (ignored if allDay = true)", formalDefinition="Closing time of day (ignored if allDay = true).")
        protected TimeType availableEndTime;
        private static final long serialVersionUID = -2139510127L;

        public List<Enumeration<Enumerations.DaysOfWeek>> getDaysOfWeek() {
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<Enumeration<Enumerations.DaysOfWeek>>();
            }
            return this.daysOfWeek;
        }

        public AvailabilityAvailableTimeComponent setDaysOfWeek(List<Enumeration<Enumerations.DaysOfWeek>> theDaysOfWeek) {
            this.daysOfWeek = theDaysOfWeek;
            return this;
        }

        public boolean hasDaysOfWeek() {
            if (this.daysOfWeek == null) {
                return false;
            }
            for (Enumeration<Enumerations.DaysOfWeek> item : this.daysOfWeek) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<Enumerations.DaysOfWeek> addDaysOfWeekElement() {
            Enumeration<Enumerations.DaysOfWeek> t = new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory());
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<Enumeration<Enumerations.DaysOfWeek>>();
            }
            this.daysOfWeek.add(t);
            return t;
        }

        public AvailabilityAvailableTimeComponent addDaysOfWeek(Enumerations.DaysOfWeek value) {
            Enumeration<Enumerations.DaysOfWeek> t = new Enumeration<Enumerations.DaysOfWeek>(new Enumerations.DaysOfWeekEnumFactory());
            t.setValue((Object)value);
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new ArrayList<Enumeration<Enumerations.DaysOfWeek>>();
            }
            this.daysOfWeek.add(t);
            return this;
        }

        public boolean hasDaysOfWeek(Enumerations.DaysOfWeek value) {
            if (this.daysOfWeek == null) {
                return false;
            }
            for (Enumeration<Enumerations.DaysOfWeek> v : this.daysOfWeek) {
                if (!((Enumerations.DaysOfWeek)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public BooleanType getAllDayElement() {
            if (this.allDay == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AvailabilityAvailableTimeComponent.allDay");
                }
                if (Configuration.doAutoCreate()) {
                    this.allDay = new BooleanType();
                }
            }
            return this.allDay;
        }

        public boolean hasAllDayElement() {
            return this.allDay != null && !this.allDay.isEmpty();
        }

        public boolean hasAllDay() {
            return this.allDay != null && !this.allDay.isEmpty();
        }

        public AvailabilityAvailableTimeComponent setAllDayElement(BooleanType value) {
            this.allDay = value;
            return this;
        }

        public boolean getAllDay() {
            return this.allDay == null || this.allDay.isEmpty() ? false : (Boolean)this.allDay.getValue();
        }

        public AvailabilityAvailableTimeComponent setAllDay(boolean value) {
            if (this.allDay == null) {
                this.allDay = new BooleanType();
            }
            this.allDay.setValue((Object)value);
            return this;
        }

        public TimeType getAvailableStartTimeElement() {
            if (this.availableStartTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AvailabilityAvailableTimeComponent.availableStartTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.availableStartTime = new TimeType();
                }
            }
            return this.availableStartTime;
        }

        public boolean hasAvailableStartTimeElement() {
            return this.availableStartTime != null && !this.availableStartTime.isEmpty();
        }

        public boolean hasAvailableStartTime() {
            return this.availableStartTime != null && !this.availableStartTime.isEmpty();
        }

        public AvailabilityAvailableTimeComponent setAvailableStartTimeElement(TimeType value) {
            this.availableStartTime = value;
            return this;
        }

        public String getAvailableStartTime() {
            return this.availableStartTime == null ? null : (String)this.availableStartTime.getValue();
        }

        public AvailabilityAvailableTimeComponent setAvailableStartTime(String value) {
            if (value == null) {
                this.availableStartTime = null;
            } else {
                if (this.availableStartTime == null) {
                    this.availableStartTime = new TimeType();
                }
                this.availableStartTime.setValue(value);
            }
            return this;
        }

        public TimeType getAvailableEndTimeElement() {
            if (this.availableEndTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AvailabilityAvailableTimeComponent.availableEndTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.availableEndTime = new TimeType();
                }
            }
            return this.availableEndTime;
        }

        public boolean hasAvailableEndTimeElement() {
            return this.availableEndTime != null && !this.availableEndTime.isEmpty();
        }

        public boolean hasAvailableEndTime() {
            return this.availableEndTime != null && !this.availableEndTime.isEmpty();
        }

        public AvailabilityAvailableTimeComponent setAvailableEndTimeElement(TimeType value) {
            this.availableEndTime = value;
            return this;
        }

        public String getAvailableEndTime() {
            return this.availableEndTime == null ? null : (String)this.availableEndTime.getValue();
        }

        public AvailabilityAvailableTimeComponent setAvailableEndTime(String value) {
            if (value == null) {
                this.availableEndTime = null;
            } else {
                if (this.availableEndTime == null) {
                    this.availableEndTime = new TimeType();
                }
                this.availableEndTime.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("daysOfWeek", "code", "mon | tue | wed | thu | fri | sat | sun.", 0, Integer.MAX_VALUE, this.daysOfWeek));
            children.add(new Property("allDay", "boolean", "Always available? i.e. 24 hour service.", 0, 1, this.allDay));
            children.add(new Property("availableStartTime", "time", "Opening time of day (ignored if allDay = true).", 0, 1, this.availableStartTime));
            children.add(new Property("availableEndTime", "time", "Closing time of day (ignored if allDay = true).", 0, 1, this.availableEndTime));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 68050338: {
                    return new Property("daysOfWeek", "code", "mon | tue | wed | thu | fri | sat | sun.", 0, Integer.MAX_VALUE, this.daysOfWeek);
                }
                case -1414913477: {
                    return new Property("allDay", "boolean", "Always available? i.e. 24 hour service.", 0, 1, this.allDay);
                }
                case -1039453818: {
                    return new Property("availableStartTime", "time", "Opening time of day (ignored if allDay = true).", 0, 1, this.availableStartTime);
                }
                case 101151551: {
                    return new Property("availableEndTime", "time", "Closing time of day (ignored if allDay = true).", 0, 1, this.availableEndTime);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    return this.daysOfWeek == null ? new Base[]{} : this.daysOfWeek.toArray(new Base[this.daysOfWeek.size()]);
                }
                case -1414913477: {
                    Base[] baseArray;
                    if (this.allDay == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.allDay;
                    }
                    return baseArray;
                }
                case -1039453818: {
                    Base[] baseArray;
                    if (this.availableStartTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.availableStartTime;
                    }
                    return baseArray;
                }
                case 101151551: {
                    Base[] baseArray;
                    if (this.availableEndTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.availableEndTime;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    value = new Enumerations.DaysOfWeekEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.getDaysOfWeek().add(value);
                    return value;
                }
                case -1414913477: {
                    this.allDay = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -1039453818: {
                    this.availableStartTime = TypeConvertor.castToTime(value);
                    return value;
                }
                case 101151551: {
                    this.availableEndTime = TypeConvertor.castToTime(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("daysOfWeek")) {
                value = new Enumerations.DaysOfWeekEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getDaysOfWeek().add(value);
            } else if (name.equals("allDay")) {
                this.allDay = TypeConvertor.castToBoolean(value);
            } else if (name.equals("availableStartTime")) {
                this.availableStartTime = TypeConvertor.castToTime(value);
            } else if (name.equals("availableEndTime")) {
                this.availableEndTime = TypeConvertor.castToTime(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    return this.addDaysOfWeekElement();
                }
                case -1414913477: {
                    return this.getAllDayElement();
                }
                case -1039453818: {
                    return this.getAvailableStartTimeElement();
                }
                case 101151551: {
                    return this.getAvailableEndTimeElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 68050338: {
                    return new String[]{"code"};
                }
                case -1414913477: {
                    return new String[]{"boolean"};
                }
                case -1039453818: {
                    return new String[]{"time"};
                }
                case 101151551: {
                    return new String[]{"time"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("daysOfWeek")) {
                throw new FHIRException("Cannot call addChild on a primitive type Availability.availableTime.daysOfWeek");
            }
            if (name.equals("allDay")) {
                throw new FHIRException("Cannot call addChild on a primitive type Availability.availableTime.allDay");
            }
            if (name.equals("availableStartTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type Availability.availableTime.availableStartTime");
            }
            if (name.equals("availableEndTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type Availability.availableTime.availableEndTime");
            }
            return super.addChild(name);
        }

        @Override
        public AvailabilityAvailableTimeComponent copy() {
            AvailabilityAvailableTimeComponent dst = new AvailabilityAvailableTimeComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(AvailabilityAvailableTimeComponent dst) {
            super.copyValues(dst);
            if (this.daysOfWeek != null) {
                dst.daysOfWeek = new ArrayList<Enumeration<Enumerations.DaysOfWeek>>();
                for (Enumeration<Enumerations.DaysOfWeek> i : this.daysOfWeek) {
                    dst.daysOfWeek.add((Enumeration<Enumerations.DaysOfWeek>)i.copy());
                }
            }
            dst.allDay = this.allDay == null ? null : this.allDay.copy();
            dst.availableStartTime = this.availableStartTime == null ? null : this.availableStartTime.copy();
            dst.availableEndTime = this.availableEndTime == null ? null : this.availableEndTime.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof AvailabilityAvailableTimeComponent)) {
                return false;
            }
            AvailabilityAvailableTimeComponent o = (AvailabilityAvailableTimeComponent)other_;
            return AvailabilityAvailableTimeComponent.compareDeep(this.daysOfWeek, o.daysOfWeek, true) && AvailabilityAvailableTimeComponent.compareDeep(this.allDay, o.allDay, true) && AvailabilityAvailableTimeComponent.compareDeep(this.availableStartTime, o.availableStartTime, true) && AvailabilityAvailableTimeComponent.compareDeep(this.availableEndTime, o.availableEndTime, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof AvailabilityAvailableTimeComponent)) {
                return false;
            }
            AvailabilityAvailableTimeComponent o = (AvailabilityAvailableTimeComponent)other_;
            return AvailabilityAvailableTimeComponent.compareValues(this.daysOfWeek, o.daysOfWeek, true) && AvailabilityAvailableTimeComponent.compareValues(this.allDay, o.allDay, true) && AvailabilityAvailableTimeComponent.compareValues(this.availableStartTime, o.availableStartTime, true) && AvailabilityAvailableTimeComponent.compareValues(this.availableEndTime, o.availableEndTime, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.daysOfWeek, this.allDay, this.availableStartTime, this.availableEndTime});
        }

        @Override
        public String fhirType() {
            return "Availability.availableTime";
        }
    }
}

