/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Attachment")
public class Attachment
extends DataType
implements ICompositeType {
    @Child(name="contentType", type={CodeType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Mime type of the content, with charset etc.", formalDefinition="Identifies the type of the data in the attachment and allows a method to be chosen to interpret or render the data. Includes mime type parameters such as charset where appropriate.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/mimetypes")
    protected CodeType contentType;
    @Child(name="language", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human language of the content (BCP-47)", formalDefinition="The human language of the content. The value can be any valid value according to BCP 47.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/languages")
    protected CodeType language;
    @Child(name="data", type={Base64BinaryType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Data inline, base64ed", formalDefinition="The actual data of the attachment - a sequence of bytes, base64 encoded.")
    protected Base64BinaryType data;
    @Child(name="url", type={UrlType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Uri where the data can be found", formalDefinition="A location where the data can be accessed.")
    protected UrlType url;
    @Child(name="size", type={Integer64Type.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of bytes of content (if url provided)", formalDefinition="The number of bytes of data that make up this attachment (before base64 encoding, if that is done).")
    protected Integer64Type size;
    @Child(name="hash", type={Base64BinaryType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Hash of the data (sha-1, base64ed)", formalDefinition="The calculated hash of the data using SHA-1. Represented using base64.")
    protected Base64BinaryType hash;
    @Child(name="title", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Label to display in place of the data", formalDefinition="A label or set of text to display in place of the data.")
    protected StringType title;
    @Child(name="creation", type={DateTimeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date attachment was first created", formalDefinition="The date that the attachment was first created.")
    protected DateTimeType creation;
    @Child(name="height", type={PositiveIntType.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Height of the image in pixels (photo/video)", formalDefinition="Height of the image in pixels (photo/video).")
    protected PositiveIntType height;
    @Child(name="width", type={PositiveIntType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Width of the image in pixels (photo/video)", formalDefinition="Width of the image in pixels (photo/video).")
    protected PositiveIntType width;
    @Child(name="frames", type={PositiveIntType.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Number of frames if > 1 (photo)", formalDefinition="The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.")
    protected PositiveIntType frames;
    @Child(name="duration", type={DecimalType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Length in seconds (audio / video)", formalDefinition="The duration of the recording in seconds - for audio and video.")
    protected DecimalType duration;
    @Child(name="pages", type={PositiveIntType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Number of printed pages", formalDefinition="The number of pages when printed.")
    protected PositiveIntType pages;
    private static final long serialVersionUID = -1904332061L;

    public CodeType getContentTypeElement() {
        if (this.contentType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.contentType");
            }
            if (Configuration.doAutoCreate()) {
                this.contentType = new CodeType();
            }
        }
        return this.contentType;
    }

    public boolean hasContentTypeElement() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public boolean hasContentType() {
        return this.contentType != null && !this.contentType.isEmpty();
    }

    public Attachment setContentTypeElement(CodeType value) {
        this.contentType = value;
        return this;
    }

    public String getContentType() {
        return this.contentType == null ? null : (String)this.contentType.getValue();
    }

    public Attachment setContentType(String value) {
        if (Utilities.noString((String)value)) {
            this.contentType = null;
        } else {
            if (this.contentType == null) {
                this.contentType = new CodeType();
            }
            this.contentType.setValue(value);
        }
        return this;
    }

    public CodeType getLanguageElement() {
        if (this.language == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.language");
            }
            if (Configuration.doAutoCreate()) {
                this.language = new CodeType();
            }
        }
        return this.language;
    }

    public boolean hasLanguageElement() {
        return this.language != null && !this.language.isEmpty();
    }

    public boolean hasLanguage() {
        return this.language != null && !this.language.isEmpty();
    }

    public Attachment setLanguageElement(CodeType value) {
        this.language = value;
        return this;
    }

    public String getLanguage() {
        return this.language == null ? null : (String)this.language.getValue();
    }

    public Attachment setLanguage(String value) {
        if (Utilities.noString((String)value)) {
            this.language = null;
        } else {
            if (this.language == null) {
                this.language = new CodeType();
            }
            this.language.setValue(value);
        }
        return this;
    }

    public Base64BinaryType getDataElement() {
        if (this.data == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.data");
            }
            if (Configuration.doAutoCreate()) {
                this.data = new Base64BinaryType();
            }
        }
        return this.data;
    }

    public boolean hasDataElement() {
        return this.data != null && !this.data.isEmpty();
    }

    public boolean hasData() {
        return this.data != null && !this.data.isEmpty();
    }

    public Attachment setDataElement(Base64BinaryType value) {
        this.data = value;
        return this;
    }

    public byte[] getData() {
        return this.data == null ? null : this.data.getValue();
    }

    public Attachment setData(byte[] value) {
        if (value == null) {
            this.data = null;
        } else {
            if (this.data == null) {
                this.data = new Base64BinaryType();
            }
            this.data.setValue(value);
        }
        return this;
    }

    public UrlType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UrlType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Attachment setUrlElement(UrlType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public Attachment setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UrlType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public Integer64Type getSizeElement() {
        if (this.size == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.size");
            }
            if (Configuration.doAutoCreate()) {
                this.size = new Integer64Type();
            }
        }
        return this.size;
    }

    public boolean hasSizeElement() {
        return this.size != null && !this.size.isEmpty();
    }

    public boolean hasSize() {
        return this.size != null && !this.size.isEmpty();
    }

    public Attachment setSizeElement(Integer64Type value) {
        this.size = value;
        return this;
    }

    public long getSize() {
        return this.size == null || this.size.isEmpty() ? 0L : (Long)this.size.getValue();
    }

    public Attachment setSize(long value) {
        this.size = new Integer64Type();
        this.size.setValue((Object)value);
        return this;
    }

    public Base64BinaryType getHashElement() {
        if (this.hash == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.hash");
            }
            if (Configuration.doAutoCreate()) {
                this.hash = new Base64BinaryType();
            }
        }
        return this.hash;
    }

    public boolean hasHashElement() {
        return this.hash != null && !this.hash.isEmpty();
    }

    public boolean hasHash() {
        return this.hash != null && !this.hash.isEmpty();
    }

    public Attachment setHashElement(Base64BinaryType value) {
        this.hash = value;
        return this;
    }

    public byte[] getHash() {
        return this.hash == null ? null : this.hash.getValue();
    }

    public Attachment setHash(byte[] value) {
        if (value == null) {
            this.hash = null;
        } else {
            if (this.hash == null) {
                this.hash = new Base64BinaryType();
            }
            this.hash.setValue(value);
        }
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public Attachment setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public Attachment setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public DateTimeType getCreationElement() {
        if (this.creation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.creation");
            }
            if (Configuration.doAutoCreate()) {
                this.creation = new DateTimeType();
            }
        }
        return this.creation;
    }

    public boolean hasCreationElement() {
        return this.creation != null && !this.creation.isEmpty();
    }

    public boolean hasCreation() {
        return this.creation != null && !this.creation.isEmpty();
    }

    public Attachment setCreationElement(DateTimeType value) {
        this.creation = value;
        return this;
    }

    public Date getCreation() {
        return this.creation == null ? null : (Date)this.creation.getValue();
    }

    public Attachment setCreation(Date value) {
        if (value == null) {
            this.creation = null;
        } else {
            if (this.creation == null) {
                this.creation = new DateTimeType();
            }
            this.creation.setValue(value);
        }
        return this;
    }

    public PositiveIntType getHeightElement() {
        if (this.height == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.height");
            }
            if (Configuration.doAutoCreate()) {
                this.height = new PositiveIntType();
            }
        }
        return this.height;
    }

    public boolean hasHeightElement() {
        return this.height != null && !this.height.isEmpty();
    }

    public boolean hasHeight() {
        return this.height != null && !this.height.isEmpty();
    }

    public Attachment setHeightElement(PositiveIntType value) {
        this.height = value;
        return this;
    }

    public int getHeight() {
        return this.height == null || this.height.isEmpty() ? 0 : (Integer)this.height.getValue();
    }

    public Attachment setHeight(int value) {
        if (this.height == null) {
            this.height = new PositiveIntType();
        }
        this.height.setValue((Object)value);
        return this;
    }

    public PositiveIntType getWidthElement() {
        if (this.width == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.width");
            }
            if (Configuration.doAutoCreate()) {
                this.width = new PositiveIntType();
            }
        }
        return this.width;
    }

    public boolean hasWidthElement() {
        return this.width != null && !this.width.isEmpty();
    }

    public boolean hasWidth() {
        return this.width != null && !this.width.isEmpty();
    }

    public Attachment setWidthElement(PositiveIntType value) {
        this.width = value;
        return this;
    }

    public int getWidth() {
        return this.width == null || this.width.isEmpty() ? 0 : (Integer)this.width.getValue();
    }

    public Attachment setWidth(int value) {
        if (this.width == null) {
            this.width = new PositiveIntType();
        }
        this.width.setValue((Object)value);
        return this;
    }

    public PositiveIntType getFramesElement() {
        if (this.frames == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.frames");
            }
            if (Configuration.doAutoCreate()) {
                this.frames = new PositiveIntType();
            }
        }
        return this.frames;
    }

    public boolean hasFramesElement() {
        return this.frames != null && !this.frames.isEmpty();
    }

    public boolean hasFrames() {
        return this.frames != null && !this.frames.isEmpty();
    }

    public Attachment setFramesElement(PositiveIntType value) {
        this.frames = value;
        return this;
    }

    public int getFrames() {
        return this.frames == null || this.frames.isEmpty() ? 0 : (Integer)this.frames.getValue();
    }

    public Attachment setFrames(int value) {
        if (this.frames == null) {
            this.frames = new PositiveIntType();
        }
        this.frames.setValue((Object)value);
        return this;
    }

    public DecimalType getDurationElement() {
        if (this.duration == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.duration");
            }
            if (Configuration.doAutoCreate()) {
                this.duration = new DecimalType();
            }
        }
        return this.duration;
    }

    public boolean hasDurationElement() {
        return this.duration != null && !this.duration.isEmpty();
    }

    public boolean hasDuration() {
        return this.duration != null && !this.duration.isEmpty();
    }

    public Attachment setDurationElement(DecimalType value) {
        this.duration = value;
        return this;
    }

    public BigDecimal getDuration() {
        return this.duration == null ? null : (BigDecimal)this.duration.getValue();
    }

    public Attachment setDuration(BigDecimal value) {
        if (value == null) {
            this.duration = null;
        } else {
            if (this.duration == null) {
                this.duration = new DecimalType();
            }
            this.duration.setValue(value);
        }
        return this;
    }

    public Attachment setDuration(long value) {
        this.duration = new DecimalType();
        this.duration.setValue(value);
        return this;
    }

    public Attachment setDuration(double value) {
        this.duration = new DecimalType();
        this.duration.setValue(value);
        return this;
    }

    public PositiveIntType getPagesElement() {
        if (this.pages == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Attachment.pages");
            }
            if (Configuration.doAutoCreate()) {
                this.pages = new PositiveIntType();
            }
        }
        return this.pages;
    }

    public boolean hasPagesElement() {
        return this.pages != null && !this.pages.isEmpty();
    }

    public boolean hasPages() {
        return this.pages != null && !this.pages.isEmpty();
    }

    public Attachment setPagesElement(PositiveIntType value) {
        this.pages = value;
        return this;
    }

    public int getPages() {
        return this.pages == null || this.pages.isEmpty() ? 0 : (Integer)this.pages.getValue();
    }

    public Attachment setPages(int value) {
        if (this.pages == null) {
            this.pages = new PositiveIntType();
        }
        this.pages.setValue((Object)value);
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("contentType", "code", "Identifies the type of the data in the attachment and allows a method to be chosen to interpret or render the data. Includes mime type parameters such as charset where appropriate.", 0, 1, this.contentType));
        children.add(new Property("language", "code", "The human language of the content. The value can be any valid value according to BCP 47.", 0, 1, this.language));
        children.add(new Property("data", "base64Binary", "The actual data of the attachment - a sequence of bytes, base64 encoded.", 0, 1, this.data));
        children.add(new Property("url", "url", "A location where the data can be accessed.", 0, 1, this.url));
        children.add(new Property("size", "integer64", "The number of bytes of data that make up this attachment (before base64 encoding, if that is done).", 0, 1, this.size));
        children.add(new Property("hash", "base64Binary", "The calculated hash of the data using SHA-1. Represented using base64.", 0, 1, this.hash));
        children.add(new Property("title", "string", "A label or set of text to display in place of the data.", 0, 1, this.title));
        children.add(new Property("creation", "dateTime", "The date that the attachment was first created.", 0, 1, this.creation));
        children.add(new Property("height", "positiveInt", "Height of the image in pixels (photo/video).", 0, 1, this.height));
        children.add(new Property("width", "positiveInt", "Width of the image in pixels (photo/video).", 0, 1, this.width));
        children.add(new Property("frames", "positiveInt", "The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.", 0, 1, this.frames));
        children.add(new Property("duration", "decimal", "The duration of the recording in seconds - for audio and video.", 0, 1, this.duration));
        children.add(new Property("pages", "positiveInt", "The number of pages when printed.", 0, 1, this.pages));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -389131437: {
                return new Property("contentType", "code", "Identifies the type of the data in the attachment and allows a method to be chosen to interpret or render the data. Includes mime type parameters such as charset where appropriate.", 0, 1, this.contentType);
            }
            case -1613589672: {
                return new Property("language", "code", "The human language of the content. The value can be any valid value according to BCP 47.", 0, 1, this.language);
            }
            case 3076010: {
                return new Property("data", "base64Binary", "The actual data of the attachment - a sequence of bytes, base64 encoded.", 0, 1, this.data);
            }
            case 116079: {
                return new Property("url", "url", "A location where the data can be accessed.", 0, 1, this.url);
            }
            case 3530753: {
                return new Property("size", "integer64", "The number of bytes of data that make up this attachment (before base64 encoding, if that is done).", 0, 1, this.size);
            }
            case 3195150: {
                return new Property("hash", "base64Binary", "The calculated hash of the data using SHA-1. Represented using base64.", 0, 1, this.hash);
            }
            case 110371416: {
                return new Property("title", "string", "A label or set of text to display in place of the data.", 0, 1, this.title);
            }
            case 1820421855: {
                return new Property("creation", "dateTime", "The date that the attachment was first created.", 0, 1, this.creation);
            }
            case -1221029593: {
                return new Property("height", "positiveInt", "Height of the image in pixels (photo/video).", 0, 1, this.height);
            }
            case 113126854: {
                return new Property("width", "positiveInt", "Width of the image in pixels (photo/video).", 0, 1, this.width);
            }
            case -1266514778: {
                return new Property("frames", "positiveInt", "The number of frames in a photo. This is used with a multi-page fax, or an imaging acquisition context that takes multiple slices in a single image, or an animated gif. If there is more than one frame, this SHALL have a value in order to alert interface software that a multi-frame capable rendering widget is required.", 0, 1, this.frames);
            }
            case -1992012396: {
                return new Property("duration", "decimal", "The duration of the recording in seconds - for audio and video.", 0, 1, this.duration);
            }
            case 106426308: {
                return new Property("pages", "positiveInt", "The number of pages when printed.", 0, 1, this.pages);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -389131437: {
                Base[] baseArray;
                if (this.contentType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.contentType;
                }
                return baseArray;
            }
            case -1613589672: {
                Base[] baseArray;
                if (this.language == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.language;
                }
                return baseArray;
            }
            case 3076010: {
                Base[] baseArray;
                if (this.data == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.data;
                }
                return baseArray;
            }
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.url;
                }
                return baseArray;
            }
            case 3530753: {
                Base[] baseArray;
                if (this.size == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.size;
                }
                return baseArray;
            }
            case 3195150: {
                Base[] baseArray;
                if (this.hash == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.hash;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.title;
                }
                return baseArray;
            }
            case 1820421855: {
                Base[] baseArray;
                if (this.creation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.creation;
                }
                return baseArray;
            }
            case -1221029593: {
                Base[] baseArray;
                if (this.height == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.height;
                }
                return baseArray;
            }
            case 113126854: {
                Base[] baseArray;
                if (this.width == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.width;
                }
                return baseArray;
            }
            case -1266514778: {
                Base[] baseArray;
                if (this.frames == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.frames;
                }
                return baseArray;
            }
            case -1992012396: {
                Base[] baseArray;
                if (this.duration == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.duration;
                }
                return baseArray;
            }
            case 106426308: {
                Base[] baseArray;
                if (this.pages == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.pages;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -389131437: {
                this.contentType = TypeConvertor.castToCode(value);
                return value;
            }
            case -1613589672: {
                this.language = TypeConvertor.castToCode(value);
                return value;
            }
            case 3076010: {
                this.data = TypeConvertor.castToBase64Binary(value);
                return value;
            }
            case 116079: {
                this.url = TypeConvertor.castToUrl(value);
                return value;
            }
            case 3530753: {
                this.size = TypeConvertor.castToInteger64(value);
                return value;
            }
            case 3195150: {
                this.hash = TypeConvertor.castToBase64Binary(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case 1820421855: {
                this.creation = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1221029593: {
                this.height = TypeConvertor.castToPositiveInt(value);
                return value;
            }
            case 113126854: {
                this.width = TypeConvertor.castToPositiveInt(value);
                return value;
            }
            case -1266514778: {
                this.frames = TypeConvertor.castToPositiveInt(value);
                return value;
            }
            case -1992012396: {
                this.duration = TypeConvertor.castToDecimal(value);
                return value;
            }
            case 106426308: {
                this.pages = TypeConvertor.castToPositiveInt(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("contentType")) {
            this.contentType = TypeConvertor.castToCode(value);
        } else if (name.equals("language")) {
            this.language = TypeConvertor.castToCode(value);
        } else if (name.equals("data")) {
            this.data = TypeConvertor.castToBase64Binary(value);
        } else if (name.equals("url")) {
            this.url = TypeConvertor.castToUrl(value);
        } else if (name.equals("size")) {
            this.size = TypeConvertor.castToInteger64(value);
        } else if (name.equals("hash")) {
            this.hash = TypeConvertor.castToBase64Binary(value);
        } else if (name.equals("title")) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("creation")) {
            this.creation = TypeConvertor.castToDateTime(value);
        } else if (name.equals("height")) {
            this.height = TypeConvertor.castToPositiveInt(value);
        } else if (name.equals("width")) {
            this.width = TypeConvertor.castToPositiveInt(value);
        } else if (name.equals("frames")) {
            this.frames = TypeConvertor.castToPositiveInt(value);
        } else if (name.equals("duration")) {
            this.duration = TypeConvertor.castToDecimal(value);
        } else if (name.equals("pages")) {
            this.pages = TypeConvertor.castToPositiveInt(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -389131437: {
                return this.getContentTypeElement();
            }
            case -1613589672: {
                return this.getLanguageElement();
            }
            case 3076010: {
                return this.getDataElement();
            }
            case 116079: {
                return this.getUrlElement();
            }
            case 3530753: {
                return this.getSizeElement();
            }
            case 3195150: {
                return this.getHashElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case 1820421855: {
                return this.getCreationElement();
            }
            case -1221029593: {
                return this.getHeightElement();
            }
            case 113126854: {
                return this.getWidthElement();
            }
            case -1266514778: {
                return this.getFramesElement();
            }
            case -1992012396: {
                return this.getDurationElement();
            }
            case 106426308: {
                return this.getPagesElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -389131437: {
                return new String[]{"code"};
            }
            case -1613589672: {
                return new String[]{"code"};
            }
            case 3076010: {
                return new String[]{"base64Binary"};
            }
            case 116079: {
                return new String[]{"url"};
            }
            case 3530753: {
                return new String[]{"integer64"};
            }
            case 3195150: {
                return new String[]{"base64Binary"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case 1820421855: {
                return new String[]{"dateTime"};
            }
            case -1221029593: {
                return new String[]{"positiveInt"};
            }
            case 113126854: {
                return new String[]{"positiveInt"};
            }
            case -1266514778: {
                return new String[]{"positiveInt"};
            }
            case -1992012396: {
                return new String[]{"decimal"};
            }
            case 106426308: {
                return new String[]{"positiveInt"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("contentType")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.contentType");
        }
        if (name.equals("language")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.language");
        }
        if (name.equals("data")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.data");
        }
        if (name.equals("url")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.url");
        }
        if (name.equals("size")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.size");
        }
        if (name.equals("hash")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.hash");
        }
        if (name.equals("title")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.title");
        }
        if (name.equals("creation")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.creation");
        }
        if (name.equals("height")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.height");
        }
        if (name.equals("width")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.width");
        }
        if (name.equals("frames")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.frames");
        }
        if (name.equals("duration")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.duration");
        }
        if (name.equals("pages")) {
            throw new FHIRException("Cannot call addChild on a primitive type Attachment.pages");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Attachment";
    }

    @Override
    public Attachment copy() {
        Attachment dst = new Attachment();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Attachment dst) {
        super.copyValues(dst);
        dst.contentType = this.contentType == null ? null : this.contentType.copy();
        dst.language = this.language == null ? null : this.language.copy();
        dst.data = this.data == null ? null : this.data.copy();
        dst.url = this.url == null ? null : this.url.copy();
        dst.size = this.size == null ? null : this.size.copy();
        dst.hash = this.hash == null ? null : this.hash.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.creation = this.creation == null ? null : this.creation.copy();
        dst.height = this.height == null ? null : this.height.copy();
        dst.width = this.width == null ? null : this.width.copy();
        dst.frames = this.frames == null ? null : this.frames.copy();
        dst.duration = this.duration == null ? null : this.duration.copy();
        dst.pages = this.pages == null ? null : this.pages.copy();
    }

    protected Attachment typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Attachment)) {
            return false;
        }
        Attachment o = (Attachment)other_;
        return Attachment.compareDeep(this.contentType, o.contentType, true) && Attachment.compareDeep(this.language, o.language, true) && Attachment.compareDeep(this.data, o.data, true) && Attachment.compareDeep(this.url, o.url, true) && Attachment.compareDeep(this.size, o.size, true) && Attachment.compareDeep(this.hash, o.hash, true) && Attachment.compareDeep(this.title, o.title, true) && Attachment.compareDeep(this.creation, o.creation, true) && Attachment.compareDeep(this.height, o.height, true) && Attachment.compareDeep(this.width, o.width, true) && Attachment.compareDeep(this.frames, o.frames, true) && Attachment.compareDeep(this.duration, o.duration, true) && Attachment.compareDeep(this.pages, o.pages, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Attachment)) {
            return false;
        }
        Attachment o = (Attachment)other_;
        return Attachment.compareValues(this.contentType, o.contentType, true) && Attachment.compareValues(this.language, o.language, true) && Attachment.compareValues(this.data, o.data, true) && Attachment.compareValues(this.url, o.url, true) && Attachment.compareValues(this.size, o.size, true) && Attachment.compareValues(this.hash, o.hash, true) && Attachment.compareValues(this.title, o.title, true) && Attachment.compareValues(this.creation, o.creation, true) && Attachment.compareValues(this.height, o.height, true) && Attachment.compareValues(this.width, o.width, true) && Attachment.compareValues(this.frames, o.frames, true) && Attachment.compareValues(this.duration, o.duration, true) && Attachment.compareValues(this.pages, o.pages, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.contentType, this.language, this.data, this.url, this.size, this.hash, this.title, this.creation, this.height, this.width, this.frames, this.duration, this.pages});
    }
}

