/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.formats;

import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.XmlParserBase;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.Age;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.ArtifactAssessment;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.Availability;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Contributor;
import org.hl7.fhir.r5.model.Count;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DataRequirement;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceDispense;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.Distance;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.Expression;
import org.hl7.fhir.r5.model.ExtendedContactDetail;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.ExtensionHelper;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.FormularyItem;
import org.hl7.fhir.r5.model.GenomicStudy;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingSelection;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.MarketingStatus;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.Meta;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.MonetaryComponent;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.ParameterDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Population;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.ProductShelfLife;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Ratio;
import org.hl7.fhir.r5.model.RatioRange;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedArtifact;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestOrchestration;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.SampledData;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Signature;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.Timing;
import org.hl7.fhir.r5.model.Transport;
import org.hl7.fhir.r5.model.TriggerDefinition;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.UuidType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VirtualServiceDetail;
import org.hl7.fhir.r5.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlParser
extends XmlParserBase {
    public XmlParser() {
    }

    public XmlParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    protected boolean parseBaseContent(int eventType, XmlPullParser xpp, Base res) throws XmlPullParserException, IOException, FHIRFormatError {
        return false;
    }

    protected <E extends Enum<E>> Enumeration<E> parseEnumeration(XmlPullParser xpp, E item, EnumFactory e) throws XmlPullParserException, IOException, FHIRFormatError {
        Enumeration res = new Enumeration(e);
        this.parseElementAttributes(xpp, res);
        res.setValue(e.fromCode(xpp.getAttributeValue(null, "value")));
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DateType parseDate(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DateType res = new DateType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DateTimeType parseDateTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DateTimeType res = new DateTimeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeType parseCode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeType res = new CodeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StringType parseString(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        StringType res = new StringType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected IntegerType parseInteger(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        IntegerType res = new IntegerType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Integer64Type parseInteger64(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Integer64Type res = new Integer64Type(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OidType parseOid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OidType res = new OidType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CanonicalType parseCanonical(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CanonicalType res = new CanonicalType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UriType parseUri(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UriType res = new UriType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UuidType parseUuid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UuidType res = new UuidType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UrlType parseUrl(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UrlType res = new UrlType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected InstantType parseInstant(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InstantType res = new InstantType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected BooleanType parseBoolean(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BooleanType res = new BooleanType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Base64BinaryType parseBase64Binary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Base64BinaryType res = new Base64BinaryType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UnsignedIntType parseUnsignedInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UnsignedIntType res = new UnsignedIntType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MarkdownType parseMarkdown(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MarkdownType res = new MarkdownType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TimeType parseTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TimeType res = new TimeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected IdType parseId(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        IdType res = new IdType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PositiveIntType parsePositiveInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PositiveIntType res = new PositiveIntType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DecimalType parseDecimal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DecimalType res = new DecimalType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBackboneElementContent(int eventType, XmlPullParser xpp, BackboneElement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("modifierExtension")) {
            res.getModifierExtension().add(this.parseExtension(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected boolean parseBackboneTypeContent(int eventType, XmlPullParser xpp, BackboneType res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("modifierExtension")) {
            res.getModifierExtension().add(this.parseExtension(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected boolean parseDataTypeContent(int eventType, XmlPullParser xpp, DataType res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseElementContent(eventType, xpp, res);
    }

    protected boolean parseElementContent(int eventType, XmlPullParser xpp, Element res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("extension")) {
            res.getExtension().add(this.parseExtension(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Address parseAddress(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Address res = new Address();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAddressContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAddressContent(int eventType, XmlPullParser xpp, Address res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("line")) {
            res.getLine().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("city")) {
            res.setCityElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("district")) {
            res.setDistrictElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("state")) {
            res.setStateElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("postalCode")) {
            res.setPostalCodeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("country")) {
            res.setCountryElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Age parseAge(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Age res = new Age();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAgeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAgeContent(int eventType, XmlPullParser xpp, Age res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected Annotation parseAnnotation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Annotation res = new Annotation();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAnnotationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAnnotationContent(int eventType, XmlPullParser xpp, Annotation res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "author")) {
            res.setAuthor(this.parseType("author", xpp));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseMarkdown(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Attachment parseAttachment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Attachment res = new Attachment();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAttachmentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAttachmentContent(int eventType, XmlPullParser xpp, Attachment res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("contentType")) {
            res.setContentTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setDataElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("size")) {
            res.setSizeElement(this.parseInteger64(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hash")) {
            res.setHashElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("creation")) {
            res.setCreationElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("height")) {
            res.setHeightElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("width")) {
            res.setWidthElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("frames")) {
            res.setFramesElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("duration")) {
            res.setDurationElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("pages")) {
            res.setPagesElement(this.parsePositiveInt(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Availability parseAvailability(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Availability res = new Availability();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAvailabilityContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAvailabilityContent(int eventType, XmlPullParser xpp, Availability res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("availableTime")) {
            res.getAvailableTime().add(this.parseAvailabilityAvailableTimeComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("notAvailableTime")) {
            res.getNotAvailableTime().add(this.parseAvailabilityNotAvailableTimeComponent(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Availability.AvailabilityAvailableTimeComponent parseAvailabilityAvailableTimeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Availability.AvailabilityAvailableTimeComponent res = new Availability.AvailabilityAvailableTimeComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAvailabilityAvailableTimeComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAvailabilityAvailableTimeComponentContent(int eventType, XmlPullParser xpp, Availability.AvailabilityAvailableTimeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("daysOfWeek")) {
            res.getDaysOfWeek().add(this.parseEnumeration(xpp, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("allDay")) {
            res.setAllDayElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availableStartTime")) {
            res.setAvailableStartTimeElement(this.parseTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availableEndTime")) {
            res.setAvailableEndTimeElement(this.parseTime(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Availability.AvailabilityNotAvailableTimeComponent parseAvailabilityNotAvailableTimeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Availability.AvailabilityNotAvailableTimeComponent res = new Availability.AvailabilityNotAvailableTimeComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAvailabilityNotAvailableTimeComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAvailabilityNotAvailableTimeComponentContent(int eventType, XmlPullParser xpp, Availability.AvailabilityNotAvailableTimeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("during")) {
            res.setDuring(this.parsePeriod(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeableConcept parseCodeableConcept(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeableConcept res = new CodeableConcept();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeableConceptContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeableConceptContent(int eventType, XmlPullParser xpp, CodeableConcept res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("coding")) {
            res.getCoding().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeableReference parseCodeableReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeableReference res = new CodeableReference();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeableReferenceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeableReferenceContent(int eventType, XmlPullParser xpp, CodeableReference res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("concept")) {
            res.setConcept(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coding parseCoding(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coding res = new Coding();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodingContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodingContent(int eventType, XmlPullParser xpp, Coding res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("userSelected")) {
            res.setUserSelectedElement(this.parseBoolean(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ContactDetail parseContactDetail(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ContactDetail res = new ContactDetail();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContactDetailContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContactDetailContent(int eventType, XmlPullParser xpp, ContactDetail res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ContactPoint parseContactPoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ContactPoint res = new ContactPoint();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContactPointContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContactPointContent(int eventType, XmlPullParser xpp, ContactPoint res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseEnumeration(xpp, ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("rank")) {
            res.setRankElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contributor parseContributor(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contributor res = new Contributor();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContributorContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContributorContent(int eventType, XmlPullParser xpp, Contributor res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Count parseCount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Count res = new Count();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCountContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCountContent(int eventType, XmlPullParser xpp, Count res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected DataRequirement parseDataRequirement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement res = new DataRequirement();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataRequirementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataRequirementContent(int eventType, XmlPullParser xpp, DataRequirement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.FHIRTypes.NULL, new Enumerations.FHIRTypesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "subject")) {
            res.setSubject(this.parseType("subject", xpp));
        } else if (eventType == 2 && xpp.getName().equals("mustSupport")) {
            res.getMustSupport().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("codeFilter")) {
            res.getCodeFilter().add(this.parseDataRequirementCodeFilterComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateFilter")) {
            res.getDateFilter().add(this.parseDataRequirementDateFilterComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueFilter")) {
            res.getValueFilter().add(this.parseDataRequirementValueFilterComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("limit")) {
            res.setLimitElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sort")) {
            res.getSort().add(this.parseDataRequirementSortComponent(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementCodeFilterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataRequirementCodeFilterComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataRequirementCodeFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement.DataRequirementCodeFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
            res.setSearchParamElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
            res.setValueSetElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCoding(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDateFilterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataRequirementDateFilterComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataRequirementDateFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement.DataRequirementDateFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
            res.setSearchParamElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DataRequirement.DataRequirementValueFilterComponent parseDataRequirementValueFilterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement.DataRequirementValueFilterComponent res = new DataRequirement.DataRequirementValueFilterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataRequirementValueFilterComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataRequirementValueFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement.DataRequirementValueFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
            res.setSearchParamElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comparator")) {
            res.setComparatorElement(this.parseEnumeration(xpp, DataRequirement.ValueFilterComparator.NULL, new DataRequirement.ValueFilterComparatorEnumFactory()));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DataRequirement.DataRequirementSortComponent parseDataRequirementSortComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement.DataRequirementSortComponent res = new DataRequirement.DataRequirementSortComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataRequirementSortComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataRequirementSortComponentContent(int eventType, XmlPullParser xpp, DataRequirement.DataRequirementSortComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("direction")) {
            res.setDirectionElement(this.parseEnumeration(xpp, DataRequirement.SortDirection.NULL, new DataRequirement.SortDirectionEnumFactory()));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Distance parseDistance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Distance res = new Distance();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDistanceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDistanceContent(int eventType, XmlPullParser xpp, Distance res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected Dosage parseDosage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Dosage res = new Dosage();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDosageContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDosageContent(int eventType, XmlPullParser xpp, Dosage res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additionalInstruction")) {
            res.getAdditionalInstruction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientInstruction")) {
            res.setPatientInstructionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("timing")) {
            res.setTiming(this.parseTiming(xpp));
        } else if (eventType == 2 && xpp.getName().equals("asNeeded")) {
            res.setAsNeededElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("asNeededFor")) {
            res.getAsNeededFor().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("site")) {
            res.setSite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("route")) {
            res.setRoute(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethod(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseAndRate")) {
            res.getDoseAndRate().add(this.parseDosageDoseAndRateComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerPeriod")) {
            res.getMaxDosePerPeriod().add(this.parseRatio(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerAdministration")) {
            res.setMaxDosePerAdministration(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerLifetime")) {
            res.setMaxDosePerLifetime(this.parseQuantity(xpp));
        } else if (!this.parseBackboneTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Dosage.DosageDoseAndRateComponent parseDosageDoseAndRateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Dosage.DosageDoseAndRateComponent res = new Dosage.DosageDoseAndRateComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDosageDoseAndRateComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDosageDoseAndRateComponentContent(int eventType, XmlPullParser xpp, Dosage.DosageDoseAndRateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "dose")) {
            res.setDose(this.parseType("dose", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
            res.setRate(this.parseType("rate", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Duration parseDuration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Duration res = new Duration();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDurationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDurationContent(int eventType, XmlPullParser xpp, Duration res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected ElementDefinition parseElementDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition res = new ElementDefinition();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionContent(int eventType, XmlPullParser xpp, ElementDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("representation")) {
            res.getRepresentation().add(this.parseEnumeration(xpp, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("sliceName")) {
            res.setSliceNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sliceIsConstraining")) {
            res.setSliceIsConstrainingElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("slicing")) {
            res.setSlicing(this.parseElementDefinitionSlicingComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("short")) {
            res.setShortElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requirements")) {
            res.setRequirementsElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alias")) {
            res.getAlias().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("base")) {
            res.setBase(this.parseElementDefinitionBaseComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contentReference")) {
            res.setContentReferenceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseElementDefinitionTypeRefComponent(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "defaultValue")) {
            res.setDefaultValue(this.parseType("defaultValue", xpp));
        } else if (eventType == 2 && xpp.getName().equals("meaningWhenMissing")) {
            res.setMeaningWhenMissingElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("orderMeaning")) {
            res.setOrderMeaningElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "fixed")) {
            res.setFixed(this.parseType("fixed", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "pattern")) {
            res.setPattern(this.parseType("pattern", xpp));
        } else if (eventType == 2 && xpp.getName().equals("example")) {
            res.getExample().add(this.parseElementDefinitionExampleComponent(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "minValue")) {
            res.setMinValue(this.parseType("minValue", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "maxValue")) {
            res.setMaxValue(this.parseType("maxValue", xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxLength")) {
            res.setMaxLengthElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.getCondition().add(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("constraint")) {
            res.getConstraint().add(this.parseElementDefinitionConstraintComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mustHaveValue")) {
            res.setMustHaveValueElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueAlternatives")) {
            res.getValueAlternatives().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mustSupport")) {
            res.setMustSupportElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("obligation")) {
            res.getObligation().add(this.parseElementDefinitionObligationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isModifier")) {
            res.setIsModifierElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isModifierReason")) {
            res.setIsModifierReasonElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isSummary")) {
            res.setIsSummaryElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("binding")) {
            res.setBinding(this.parseElementDefinitionBindingComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mapping")) {
            res.getMapping().add(this.parseElementDefinitionMappingComponent(xpp));
        } else if (!this.parseBackboneTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionSlicingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionSlicingComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionSlicingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionSlicingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("discriminator")) {
            res.getDiscriminator().add(this.parseElementDefinitionSlicingDiscriminatorComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ordered")) {
            res.setOrderedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rules")) {
            res.setRulesElement(this.parseEnumeration(xpp, ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionSlicingDiscriminatorComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionSlicingDiscriminatorComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionSlicingDiscriminatorComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionBaseComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionBaseComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionBaseComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionBaseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionTypeRefComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionTypeRefComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.TypeRefComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetProfile")) {
            res.getTargetProfile().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("aggregation")) {
            res.getAggregation().add(this.parseEnumeration(xpp, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("versioning")) {
            res.setVersioningElement(this.parseEnumeration(xpp, ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionExampleComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionExampleComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionExampleComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionExampleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionConstraintComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionConstraintComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionConstraintComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionConstraintComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("key")) {
            res.setKeyElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requirements")) {
            res.setRequirementsElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverityElement(this.parseEnumeration(xpp, ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("suppress")) {
            res.setSuppressElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("human")) {
            res.setHumanElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseCanonical(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionObligationComponent parseElementDefinitionObligationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionObligationComponent res = new ElementDefinition.ElementDefinitionObligationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionObligationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionObligationComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionObligationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.getActor().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.getUsage().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("filter")) {
            res.setFilterElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("filterDocumentation")) {
            res.setFilterDocumentationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("process")) {
            res.getProcess().add(this.parseUri(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionBindingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionBindingComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionBindingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionBindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("strength")) {
            res.setStrengthElement(this.parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
            res.setValueSetElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additional")) {
            res.getAdditional().add(this.parseElementDefinitionBindingAdditionalComponent(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionBindingAdditionalComponent parseElementDefinitionBindingAdditionalComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBindingAdditionalComponent res = new ElementDefinition.ElementDefinitionBindingAdditionalComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionBindingAdditionalComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionBindingAdditionalComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionBindingAdditionalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseEnumeration(xpp, ElementDefinition.AdditionalBindingPurposeVS.NULL, new ElementDefinition.AdditionalBindingPurposeVSEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
            res.setValueSetElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("shortDoco")) {
            res.setShortDocoElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.getUsage().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("any")) {
            res.setAnyElement(this.parseBoolean(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionMappingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionMappingComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionMappingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition.ElementDefinitionMappingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identity")) {
            res.setIdentityElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("map")) {
            res.setMapElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseMarkdown(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Expression parseExpression(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Expression res = new Expression();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExpressionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExpressionContent(int eventType, XmlPullParser xpp, Expression res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReferenceElement(this.parseUri(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExtendedContactDetail parseExtendedContactDetail(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExtendedContactDetail res = new ExtendedContactDetail();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExtendedContactDetailContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExtendedContactDetailContent(int eventType, XmlPullParser xpp, ExtendedContactDetail res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurpose(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.getName().add(this.parseHumanName(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddress(this.parseAddress(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Extension parseExtension(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Extension res = new Extension();
        this.parseElementAttributes(xpp, res);
        if (xpp.getAttributeValue(null, "url") != null) {
            res.setUrl(xpp.getAttributeValue(null, "url"));
        }
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExtensionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExtensionContent(int eventType, XmlPullParser xpp, Extension res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected HumanName parseHumanName(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HumanName res = new HumanName();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHumanNameContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHumanNameContent(int eventType, XmlPullParser xpp, HumanName res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("family")) {
            res.setFamilyElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("given")) {
            res.getGiven().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prefix")) {
            res.getPrefix().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("suffix")) {
            res.getSuffix().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Identifier parseIdentifier(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Identifier res = new Identifier();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseIdentifierContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseIdentifierContent(int eventType, XmlPullParser xpp, Identifier res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("assigner")) {
            res.setAssigner(this.parseReference(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MarketingStatus parseMarketingStatus(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MarketingStatus res = new MarketingStatus();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMarketingStatusContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMarketingStatusContent(int eventType, XmlPullParser xpp, MarketingStatus res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("country")) {
            res.setCountry(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.setJurisdiction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateRange")) {
            res.setDateRange(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("restoreDate")) {
            res.setRestoreDateElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Meta parseMeta(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Meta res = new Meta();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMetaContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMetaContent(int eventType, XmlPullParser xpp, Meta res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("versionId")) {
            res.setVersionIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastUpdated")) {
            res.setLastUpdatedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("security")) {
            res.getSecurity().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tag")) {
            res.getTag().add(this.parseCoding(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MonetaryComponent parseMonetaryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MonetaryComponent res = new MonetaryComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMonetaryComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMonetaryComponentContent(int eventType, XmlPullParser xpp, MonetaryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, MonetaryComponent.PriceComponentType.NULL, new MonetaryComponent.PriceComponentTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Money parseMoney(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Money res = new Money();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMoneyContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMoneyContent(int eventType, XmlPullParser xpp, Money res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("currency")) {
            res.setCurrencyElement(this.parseCode(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Narrative parseNarrative(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Narrative res = new Narrative();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNarrativeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNarrativeContent(int eventType, XmlPullParser xpp, Narrative res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("div")) {
            res.setDiv(this.parseXhtml(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ParameterDefinition parseParameterDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ParameterDefinition res = new ParameterDefinition();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseParameterDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseParameterDefinitionContent(int eventType, XmlPullParser xpp, ParameterDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, Enumerations.OperationParameterUse.NULL, new Enumerations.OperationParameterUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.FHIRTypes.NULL, new Enumerations.FHIRTypesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Period parsePeriod(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Period res = new Period();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePeriodContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePeriodContent(int eventType, XmlPullParser xpp, Period res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseDateTime(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Population parsePopulation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Population res = new Population();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePopulationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePopulationContent(int eventType, XmlPullParser xpp, Population res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "age")) {
            res.setAge(this.parseType("age", xpp));
        } else if (eventType == 2 && xpp.getName().equals("gender")) {
            res.setGender(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("race")) {
            res.setRace(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("physiologicalCondition")) {
            res.setPhysiologicalCondition(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ProductShelfLife parseProductShelfLife(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ProductShelfLife res = new ProductShelfLife();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProductShelfLifeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProductShelfLifeContent(int eventType, XmlPullParser xpp, ProductShelfLife res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "period")) {
            res.setPeriod(this.parseType("period", xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialPrecautionsForStorage")) {
            res.getSpecialPrecautionsForStorage().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Quantity parseQuantity(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Quantity res = new Quantity();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseQuantityContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseQuantityContent(int eventType, XmlPullParser xpp, Quantity res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comparator")) {
            res.setComparatorElement(this.parseEnumeration(xpp, Enumerations.QuantityComparator.NULL, new Enumerations.QuantityComparatorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnitElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Range parseRange(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Range res = new Range();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRangeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRangeContent(int eventType, XmlPullParser xpp, Range res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("low")) {
            res.setLow(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("high")) {
            res.setHigh(this.parseQuantity(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Ratio parseRatio(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Ratio res = new Ratio();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRatioContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRatioContent(int eventType, XmlPullParser xpp, Ratio res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("numerator")) {
            res.setNumerator(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("denominator")) {
            res.setDenominator(this.parseQuantity(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RatioRange parseRatioRange(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RatioRange res = new RatioRange();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRatioRangeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRatioRangeContent(int eventType, XmlPullParser xpp, RatioRange res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("lowNumerator")) {
            res.setLowNumerator(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("highNumerator")) {
            res.setHighNumerator(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("denominator")) {
            res.setDenominator(this.parseQuantity(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Reference parseReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Reference res = new Reference();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseReferenceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseReferenceContent(int eventType, XmlPullParser xpp, Reference res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReferenceElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RelatedArtifact parseRelatedArtifact(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RelatedArtifact res = new RelatedArtifact();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRelatedArtifactContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRelatedArtifactContent(int eventType, XmlPullParser xpp, RelatedArtifact res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("classifier")) {
            res.getClassifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("citation")) {
            res.setCitationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("document")) {
            res.setDocument(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResourceElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resourceReference")) {
            res.setResourceReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publicationStatus")) {
            res.setPublicationStatusElement(this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("publicationDate")) {
            res.setPublicationDateElement(this.parseDate(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SampledData parseSampledData(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SampledData res = new SampledData();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSampledDataContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSampledDataContent(int eventType, XmlPullParser xpp, SampledData res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("origin")) {
            res.setOrigin(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interval")) {
            res.setIntervalElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intervalUnit")) {
            res.setIntervalUnitElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lowerLimit")) {
            res.setLowerLimitElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("upperLimit")) {
            res.setUpperLimitElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dimensions")) {
            res.setDimensionsElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setDataElement(this.parseString(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Signature parseSignature(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Signature res = new Signature();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSignatureContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSignatureContent(int eventType, XmlPullParser xpp, Signature res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("when")) {
            res.setWhenElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("who")) {
            res.setWho(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetFormat")) {
            res.setTargetFormatElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sigFormat")) {
            res.setSigFormatElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setDataElement(this.parseBase64Binary(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Timing parseTiming(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Timing res = new Timing();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTimingContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTimingContent(int eventType, XmlPullParser xpp, Timing res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("event")) {
            res.getEvent().add(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("repeat")) {
            res.setRepeat(this.parseTimingRepeatComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Timing.TimingRepeatComponent parseTimingRepeatComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTimingRepeatComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTimingRepeatComponentContent(int eventType, XmlPullParser xpp, Timing.TimingRepeatComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "bounds")) {
            res.setBounds(this.parseType("bounds", xpp));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCountElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("countMax")) {
            res.setCountMaxElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("duration")) {
            res.setDurationElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("durationMax")) {
            res.setDurationMaxElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("durationUnit")) {
            res.setDurationUnitElement(this.parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("frequency")) {
            res.setFrequencyElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("frequencyMax")) {
            res.setFrequencyMaxElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriodElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("periodMax")) {
            res.setPeriodMaxElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("periodUnit")) {
            res.setPeriodUnitElement(this.parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("dayOfWeek")) {
            res.getDayOfWeek().add(this.parseEnumeration(xpp, Enumerations.DaysOfWeek.NULL, new Enumerations.DaysOfWeekEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("timeOfDay")) {
            res.getTimeOfDay().add(this.parseTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("when")) {
            res.getWhen().add(this.parseEnumeration(xpp, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("offset")) {
            res.setOffsetElement(this.parseUnsignedInt(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TriggerDefinition parseTriggerDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TriggerDefinition res = new TriggerDefinition();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTriggerDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTriggerDefinitionContent(int eventType, XmlPullParser xpp, TriggerDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subscriptionTopic")) {
            res.setSubscriptionTopicElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.getData().add(this.parseDataRequirement(xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setCondition(this.parseExpression(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected UsageContext parseUsageContext(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UsageContext res = new UsageContext();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseUsageContextContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseUsageContextContent(int eventType, XmlPullParser xpp, UsageContext res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCoding(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected VirtualServiceDetail parseVirtualServiceDetail(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        VirtualServiceDetail res = new VirtualServiceDetail();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseVirtualServiceDetailContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseVirtualServiceDetailContent(int eventType, XmlPullParser xpp, VirtualServiceDetail res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("channelType")) {
            res.setChannelType(this.parseCoding(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "address")) {
            res.setAddress(this.parseType("address", xpp));
        } else if (eventType == 2 && xpp.getName().equals("additionalInfo")) {
            res.getAdditionalInfo().add(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxParticipants")) {
            res.setMaxParticipantsElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sessionKey")) {
            res.setSessionKeyElement(this.parseString(xpp));
        } else if (!this.parseDataTypeContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected boolean parseCanonicalResourceContent(int eventType, XmlPullParser xpp, CanonicalResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseDomainResourceContent(eventType, xpp, res);
    }

    protected boolean parseDomainResourceContent(int eventType, XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("text")) {
            res.setText(this.parseNarrative(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contained")) {
            res.getContained().add(this.parseResourceContained(xpp));
        } else if (eventType == 2 && xpp.getName().equals("extension")) {
            res.getExtension().add(this.parseExtension(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifierExtension")) {
            res.getModifierExtension().add(this.parseExtension(xpp));
        } else if (!this.parseResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected boolean parseMetadataResourceContent(int eventType, XmlPullParser xpp, MetadataResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseCanonicalResourceContent(eventType, xpp, res);
    }

    protected boolean parseResourceContent(int eventType, XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("id")) {
            res.setIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("meta")) {
            res.setMeta(this.parseMeta(xpp));
        } else if (eventType == 2 && xpp.getName().equals("implicitRules")) {
            res.setImplicitRulesElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (!this.parseBaseContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Account parseAccount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Account res = new Account();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAccountContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAccountContent(int eventType, XmlPullParser xpp, Account res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("billingStatus")) {
            res.setBillingStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("servicePeriod")) {
            res.setServicePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.getCoverage().add(this.parseAccountCoverageComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("owner")) {
            res.setOwner(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("guarantor")) {
            res.getGuarantor().add(this.parseAccountGuarantorComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedAccount")) {
            res.getRelatedAccount().add(this.parseAccountRelatedAccountComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("currency")) {
            res.setCurrency(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("balance")) {
            res.getBalance().add(this.parseAccountBalanceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("calculatedAt")) {
            res.setCalculatedAtElement(this.parseInstant(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Account.CoverageComponent parseAccountCoverageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Account.CoverageComponent res = new Account.CoverageComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAccountCoverageComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAccountCoverageComponentContent(int eventType, XmlPullParser xpp, Account.CoverageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Account.GuarantorComponent parseAccountGuarantorComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Account.GuarantorComponent res = new Account.GuarantorComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAccountGuarantorComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAccountGuarantorComponentContent(int eventType, XmlPullParser xpp, Account.GuarantorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onHold")) {
            res.setOnHoldElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Account.AccountRelatedAccountComponent parseAccountRelatedAccountComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Account.AccountRelatedAccountComponent res = new Account.AccountRelatedAccountComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAccountRelatedAccountComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAccountRelatedAccountComponentContent(int eventType, XmlPullParser xpp, Account.AccountRelatedAccountComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.setAccount(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Account.AccountBalanceComponent parseAccountBalanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Account.AccountBalanceComponent res = new Account.AccountBalanceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAccountBalanceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAccountBalanceComponentContent(int eventType, XmlPullParser xpp, Account.AccountBalanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("aggregate")) {
            res.setAggregate(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("term")) {
            res.setTerm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("estimate")) {
            res.setEstimateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ActivityDefinition parseActivityDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ActivityDefinition res = new ActivityDefinition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseActivityDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseActivityDefinitionContent(int eventType, XmlPullParser xpp, ActivityDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "subject")) {
            res.setSubject(this.parseType("subject", xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("library")) {
            res.getLibrary().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, ActivityDefinition.RequestResourceTypes.NULL, new ActivityDefinition.RequestResourceTypesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "asNeeded")) {
            res.setAsNeeded(this.parseType("asNeeded", xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseActivityDefinitionParticipantComponent(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "product")) {
            res.setProduct(this.parseType("product", xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dosage")) {
            res.getDosage().add(this.parseDosage(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.getBodySite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specimenRequirement")) {
            res.getSpecimenRequirement().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("observationRequirement")) {
            res.getObservationRequirement().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("observationResultRequirement")) {
            res.getObservationResultRequirement().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("transform")) {
            res.setTransformElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dynamicValue")) {
            res.getDynamicValue().add(this.parseActivityDefinitionDynamicValueComponent(xpp));
        } else if (!this.parseMetadataResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseActivityDefinitionParticipantComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseActivityDefinitionParticipantComponentContent(int eventType, XmlPullParser xpp, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.ActionParticipantType.NULL, new Enumerations.ActionParticipantTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("typeCanonical")) {
            res.setTypeCanonicalElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("typeReference")) {
            res.setTypeReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionDynamicValueComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseActivityDefinitionDynamicValueComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseActivityDefinitionDynamicValueComponentContent(int eventType, XmlPullParser xpp, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpression(this.parseExpression(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ActorDefinition parseActorDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ActorDefinition res = new ActorDefinition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseActorDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseActorDefinitionContent(int eventType, XmlPullParser xpp, ActorDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.ExampleScenarioActorType.NULL, new Enumerations.ExampleScenarioActorTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.getReference().add(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("capabilities")) {
            res.setCapabilitiesElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("derivedFrom")) {
            res.getDerivedFrom().add(this.parseCanonical(xpp));
        } else if (!this.parseCanonicalResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdministrableProductDefinition parseAdministrableProductDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdministrableProductDefinition res = new AdministrableProductDefinition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdministrableProductDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdministrableProductDefinitionContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("formOf")) {
            res.getFormOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("administrableDoseForm")) {
            res.setAdministrableDoseForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitOfPresentation")) {
            res.setUnitOfPresentation(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("producedFrom")) {
            res.getProducedFrom().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ingredient")) {
            res.getIngredient().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.setDevice(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseAdministrableProductDefinitionPropertyComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("routeOfAdministration")) {
            res.getRouteOfAdministration().add(this.parseAdministrableProductDefinitionRouteOfAdministrationComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent parseAdministrableProductDefinitionPropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdministrableProductDefinitionPropertyComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdministrableProductDefinitionPropertyComponentContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition.AdministrableProductDefinitionPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatus(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent parseAdministrableProductDefinitionRouteOfAdministrationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdministrableProductDefinitionRouteOfAdministrationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdministrableProductDefinitionRouteOfAdministrationComponentContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("firstDose")) {
            res.setFirstDose(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxSingleDose")) {
            res.setMaxSingleDose(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerDay")) {
            res.setMaxDosePerDay(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerTreatmentPeriod")) {
            res.setMaxDosePerTreatmentPeriod(this.parseRatio(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxTreatmentPeriod")) {
            res.setMaxTreatmentPeriod(this.parseDuration(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetSpecies")) {
            res.getTargetSpecies().add(this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponentContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("withdrawalPeriod")) {
            res.getWithdrawalPeriod().add(this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res = new AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentContent(int eventType, XmlPullParser xpp, AdministrableProductDefinition.AdministrableProductDefinitionRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("tissue")) {
            res.setTissue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.setSupportingInformationElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent parseAdverseEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent res = new AdverseEvent();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventContent(int eventType, XmlPullParser xpp, AdverseEvent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, AdverseEvent.AdverseEventStatus.NULL, new AdverseEvent.AdverseEventStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("actuality")) {
            res.setActualityElement(this.parseEnumeration(xpp, AdverseEvent.AdverseEventActuality.NULL, new AdverseEvent.AdverseEventActualityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("detected")) {
            res.setDetectedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resultingEffect")) {
            res.getResultingEffect().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("seriousness")) {
            res.setSeriousness(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.getOutcome().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recorder")) {
            res.setRecorder(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseAdverseEventParticipantComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("study")) {
            res.getStudy().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expectedInResearchStudy")) {
            res.setExpectedInResearchStudyElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("suspectEntity")) {
            res.getSuspectEntity().add(this.parseAdverseEventSuspectEntityComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributingFactor")) {
            res.getContributingFactor().add(this.parseAdverseEventContributingFactorComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preventiveAction")) {
            res.getPreventiveAction().add(this.parseAdverseEventPreventiveActionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mitigatingAction")) {
            res.getMitigatingAction().add(this.parseAdverseEventMitigatingActionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseAdverseEventSupportingInfoComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent.AdverseEventParticipantComponent parseAdverseEventParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent.AdverseEventParticipantComponent res = new AdverseEvent.AdverseEventParticipantComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventParticipantComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventParticipantComponentContent(int eventType, XmlPullParser xpp, AdverseEvent.AdverseEventParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventSuspectEntityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventSuspectEntityComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventSuspectEntityComponentContent(int eventType, XmlPullParser xpp, AdverseEvent.AdverseEventSuspectEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "instance")) {
            res.setInstance(this.parseType("instance", xpp));
        } else if (eventType == 2 && xpp.getName().equals("causality")) {
            res.setCausality(this.parseAdverseEventSuspectEntityCausalityComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent.AdverseEventSuspectEntityCausalityComponent parseAdverseEventSuspectEntityCausalityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSuspectEntityCausalityComponent res = new AdverseEvent.AdverseEventSuspectEntityCausalityComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventSuspectEntityCausalityComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventSuspectEntityCausalityComponentContent(int eventType, XmlPullParser xpp, AdverseEvent.AdverseEventSuspectEntityCausalityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("assessmentMethod")) {
            res.setAssessmentMethod(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entityRelatedness")) {
            res.setEntityRelatedness(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent.AdverseEventContributingFactorComponent parseAdverseEventContributingFactorComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent.AdverseEventContributingFactorComponent res = new AdverseEvent.AdverseEventContributingFactorComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventContributingFactorComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventContributingFactorComponentContent(int eventType, XmlPullParser xpp, AdverseEvent.AdverseEventContributingFactorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent.AdverseEventPreventiveActionComponent parseAdverseEventPreventiveActionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent.AdverseEventPreventiveActionComponent res = new AdverseEvent.AdverseEventPreventiveActionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventPreventiveActionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventPreventiveActionComponentContent(int eventType, XmlPullParser xpp, AdverseEvent.AdverseEventPreventiveActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent.AdverseEventMitigatingActionComponent parseAdverseEventMitigatingActionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent.AdverseEventMitigatingActionComponent res = new AdverseEvent.AdverseEventMitigatingActionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventMitigatingActionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventMitigatingActionComponentContent(int eventType, XmlPullParser xpp, AdverseEvent.AdverseEventMitigatingActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent.AdverseEventSupportingInfoComponent parseAdverseEventSupportingInfoComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSupportingInfoComponent res = new AdverseEvent.AdverseEventSupportingInfoComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventSupportingInfoComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventSupportingInfoComponentContent(int eventType, XmlPullParser xpp, AdverseEvent.AdverseEventSupportingInfoComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AllergyIntolerance parseAllergyIntolerance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AllergyIntolerance res = new AllergyIntolerance();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAllergyIntoleranceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAllergyIntoleranceContent(int eventType, XmlPullParser xpp, AllergyIntolerance res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("clinicalStatus")) {
            res.setClinicalStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("verificationStatus")) {
            res.setVerificationStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("criticality")) {
            res.setCriticalityElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
            res.setOnset(this.parseType("onset", xpp));
        } else if (eventType == 2 && xpp.getName().equals("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseAllergyIntoleranceParticipantComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastOccurrence")) {
            res.setLastOccurrenceElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reaction")) {
            res.getReaction().add(this.parseAllergyIntoleranceReactionComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AllergyIntolerance.AllergyIntoleranceParticipantComponent parseAllergyIntoleranceParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AllergyIntolerance.AllergyIntoleranceParticipantComponent res = new AllergyIntolerance.AllergyIntoleranceParticipantComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAllergyIntoleranceParticipantComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAllergyIntoleranceParticipantComponentContent(int eventType, XmlPullParser xpp, AllergyIntolerance.AllergyIntoleranceParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceReactionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAllergyIntoleranceReactionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAllergyIntoleranceReactionComponentContent(int eventType, XmlPullParser xpp, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("substance")) {
            res.setSubstance(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manifestation")) {
            res.getManifestation().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onset")) {
            res.setOnsetElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverityElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("exposureRoute")) {
            res.setExposureRoute(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Appointment parseAppointment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment res = new Appointment();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentContent(int eventType, XmlPullParser xpp, Appointment res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("cancellationReason")) {
            res.setCancellationReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("class")) {
            res.getClass_().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceCategory")) {
            res.getServiceCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceType")) {
            res.getServiceType().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialty")) {
            res.getSpecialty().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appointmentType")) {
            res.setAppointmentType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("virtualService")) {
            res.getVirtualService().add(this.parseVirtualServiceDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("previousAppointment")) {
            res.setPreviousAppointment(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("originatingAppointment")) {
            res.setOriginatingAppointment(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("minutesDuration")) {
            res.setMinutesDurationElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("slot")) {
            res.getSlot().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.getAccount().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientInstruction")) {
            res.getPatientInstruction().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseAppointmentParticipantComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestedPeriod")) {
            res.getRequestedPeriod().add(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recurrenceId")) {
            res.setRecurrenceIdElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("occurrenceChanged")) {
            res.setOccurrenceChangedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recurrenceTemplate")) {
            res.getRecurrenceTemplate().add(this.parseAppointmentRecurrenceTemplateComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Appointment.AppointmentParticipantComponent parseAppointmentParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentParticipantComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentParticipantComponentContent(int eventType, XmlPullParser xpp, Appointment.AppointmentParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("required")) {
            res.setRequiredElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.ParticipationStatus.NULL, new Enumerations.ParticipationStatusEnumFactory()));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Appointment.AppointmentRecurrenceTemplateComponent parseAppointmentRecurrenceTemplateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment.AppointmentRecurrenceTemplateComponent res = new Appointment.AppointmentRecurrenceTemplateComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentRecurrenceTemplateComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentRecurrenceTemplateComponentContent(int eventType, XmlPullParser xpp, Appointment.AppointmentRecurrenceTemplateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("timezone")) {
            res.setTimezone(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recurrenceType")) {
            res.setRecurrenceType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastOccurrenceDate")) {
            res.setLastOccurrenceDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("occurrenceCount")) {
            res.setOccurrenceCountElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("occurrenceDate")) {
            res.getOccurrenceDate().add(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("weeklyTemplate")) {
            res.setWeeklyTemplate(this.parseAppointmentRecurrenceTemplateWeeklyTemplateComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("monthlyTemplate")) {
            res.setMonthlyTemplate(this.parseAppointmentRecurrenceTemplateMonthlyTemplateComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("yearlyTemplate")) {
            res.setYearlyTemplate(this.parseAppointmentRecurrenceTemplateYearlyTemplateComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excludingDate")) {
            res.getExcludingDate().add(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excludingRecurrenceId")) {
            res.getExcludingRecurrenceId().add(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent parseAppointmentRecurrenceTemplateWeeklyTemplateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent res = new Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentRecurrenceTemplateWeeklyTemplateComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentRecurrenceTemplateWeeklyTemplateComponentContent(int eventType, XmlPullParser xpp, Appointment.AppointmentRecurrenceTemplateWeeklyTemplateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("monday")) {
            res.setMondayElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tuesday")) {
            res.setTuesdayElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("wednesday")) {
            res.setWednesdayElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("thursday")) {
            res.setThursdayElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("friday")) {
            res.setFridayElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("saturday")) {
            res.setSaturdayElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sunday")) {
            res.setSundayElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("weekInterval")) {
            res.setWeekIntervalElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent parseAppointmentRecurrenceTemplateMonthlyTemplateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent res = new Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentRecurrenceTemplateMonthlyTemplateComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentRecurrenceTemplateMonthlyTemplateComponentContent(int eventType, XmlPullParser xpp, Appointment.AppointmentRecurrenceTemplateMonthlyTemplateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("dayOfMonth")) {
            res.setDayOfMonthElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("nthWeekOfMonth")) {
            res.setNthWeekOfMonth(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dayOfWeek")) {
            res.setDayOfWeek(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("monthInterval")) {
            res.setMonthIntervalElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent parseAppointmentRecurrenceTemplateYearlyTemplateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent res = new Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentRecurrenceTemplateYearlyTemplateComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentRecurrenceTemplateYearlyTemplateComponentContent(int eventType, XmlPullParser xpp, Appointment.AppointmentRecurrenceTemplateYearlyTemplateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("yearInterval")) {
            res.setYearIntervalElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AppointmentResponse parseAppointmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AppointmentResponse res = new AppointmentResponse();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentResponseContent(int eventType, XmlPullParser xpp, AppointmentResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appointment")) {
            res.setAppointment(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("proposedNewTime")) {
            res.setProposedNewTimeElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participantType")) {
            res.getParticipantType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participantStatus")) {
            res.setParticipantStatusElement(this.parseEnumeration(xpp, Enumerations.ParticipationStatus.NULL, new Enumerations.ParticipationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recurring")) {
            res.setRecurringElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("occurrenceDate")) {
            res.setOccurrenceDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recurrenceId")) {
            res.setRecurrenceIdElement(this.parsePositiveInt(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ArtifactAssessment parseArtifactAssessment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ArtifactAssessment res = new ArtifactAssessment();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseArtifactAssessmentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseArtifactAssessmentContent(int eventType, XmlPullParser xpp, ArtifactAssessment res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "citeAs")) {
            res.setCiteAs(this.parseType("citeAs", xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "artifact")) {
            res.setArtifact(this.parseType("artifact", xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.getContent().add(this.parseArtifactAssessmentContentComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("workflowStatus")) {
            res.setWorkflowStatusElement(this.parseEnumeration(xpp, ArtifactAssessment.ArtifactAssessmentWorkflowStatus.NULL, new ArtifactAssessment.ArtifactAssessmentWorkflowStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseEnumeration(xpp, ArtifactAssessment.ArtifactAssessmentDisposition.NULL, new ArtifactAssessment.ArtifactAssessmentDispositionEnumFactory()));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ArtifactAssessment.ArtifactAssessmentContentComponent parseArtifactAssessmentContentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ArtifactAssessment.ArtifactAssessmentContentComponent res = new ArtifactAssessment.ArtifactAssessmentContentComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseArtifactAssessmentContentComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseArtifactAssessmentContentComponentContent(int eventType, XmlPullParser xpp, ArtifactAssessment.ArtifactAssessmentContentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("informationType")) {
            res.setInformationTypeElement(this.parseEnumeration(xpp, ArtifactAssessment.ArtifactAssessmentInformationType.NULL, new ArtifactAssessment.ArtifactAssessmentInformationTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("summary")) {
            res.setSummaryElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classifier")) {
            res.getClassifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("path")) {
            res.getPath().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("freeToShare")) {
            res.setFreeToShareElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("component")) {
            res.getComponent().add(this.parseArtifactAssessmentContentComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent parseAuditEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent res = new AuditEvent();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventContent(int eventType, XmlPullParser xpp, AuditEvent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.setActionElement(this.parseEnumeration(xpp, AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverityElement(this.parseEnumeration(xpp, AuditEvent.AuditEventSeverity.NULL, new AuditEvent.AuditEventSeverityEnumFactory()));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurred")) {
            res.setOccurred(this.parseType("occurred", xpp));
        } else if (eventType == 2 && xpp.getName().equals("recorded")) {
            res.setRecordedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseAuditEventOutcomeComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authorization")) {
            res.getAuthorization().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("agent")) {
            res.getAgent().add(this.parseAuditEventAgentComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseAuditEventSourceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entity")) {
            res.getEntity().add(this.parseAuditEventEntityComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventOutcomeComponent parseAuditEventOutcomeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventOutcomeComponent res = new AuditEvent.AuditEventOutcomeComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventOutcomeComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventOutcomeComponentContent(int eventType, XmlPullParser xpp, AuditEvent.AuditEventOutcomeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventAgentComponent parseAuditEventAgentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventAgentComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventAgentComponentContent(int eventType, XmlPullParser xpp, AuditEvent.AuditEventAgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.getRole().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("who")) {
            res.setWho(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestor")) {
            res.setRequestorElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("policy")) {
            res.getPolicy().add(this.parseUri(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "network")) {
            res.setNetwork(this.parseType("network", xpp));
        } else if (eventType == 2 && xpp.getName().equals("authorization")) {
            res.getAuthorization().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventSourceComponent parseAuditEventSourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventSourceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventSourceComponentContent(int eventType, XmlPullParser xpp, AuditEvent.AuditEventSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("site")) {
            res.setSite(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("observer")) {
            res.setObserver(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventEntityComponent parseAuditEventEntityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventEntityComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventEntityComponentContent(int eventType, XmlPullParser xpp, AuditEvent.AuditEventEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("what")) {
            res.setWhat(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("query")) {
            res.setQueryElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseAuditEventEntityDetailComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("agent")) {
            res.getAgent().add(this.parseAuditEventAgentComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventEntityDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventEntityDetailComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventEntityDetailComponentContent(int eventType, XmlPullParser xpp, AuditEvent.AuditEventEntityDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Basic parseBasic(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Basic res = new Basic();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBasicContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBasicContent(int eventType, XmlPullParser xpp, Basic res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Binary parseBinary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Binary res = new Binary();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBinaryContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBinaryContent(int eventType, XmlPullParser xpp, Binary res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("contentType")) {
            res.setContentTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityContext")) {
            res.setSecurityContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setDataElement(this.parseBase64Binary(xpp));
        } else if (!this.parseResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BiologicallyDerivedProduct parseBiologicallyDerivedProduct(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BiologicallyDerivedProduct res = new BiologicallyDerivedProduct();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBiologicallyDerivedProductContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBiologicallyDerivedProductContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("productCategory")) {
            res.setProductCategory(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productCode")) {
            res.setProductCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.getParent().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.getRequest().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("biologicalSourceEvent")) {
            res.setBiologicalSourceEvent(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("processingFacility")) {
            res.getProcessingFacility().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("division")) {
            res.setDivisionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productStatus")) {
            res.setProductStatus(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("collection")) {
            res.setCollection(this.parseBiologicallyDerivedProductCollectionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("storageTempRequirements")) {
            res.setStorageTempRequirements(this.parseRange(xpp));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseBiologicallyDerivedProductPropertyComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent parseBiologicallyDerivedProductCollectionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBiologicallyDerivedProductCollectionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBiologicallyDerivedProductCollectionComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("collector")) {
            res.setCollector(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "collected")) {
            res.setCollected(this.parseType("collected", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent parseBiologicallyDerivedProductPropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBiologicallyDerivedProductPropertyComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBiologicallyDerivedProductPropertyComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCoding(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BodyStructure parseBodyStructure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BodyStructure res = new BodyStructure();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBodyStructureContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBodyStructureContent(int eventType, XmlPullParser xpp, BodyStructure res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("morphology")) {
            res.setMorphology(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("includedStructure")) {
            res.getIncludedStructure().add(this.parseBodyStructureIncludedStructureComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excludedStructure")) {
            res.getExcludedStructure().add(this.parseBodyStructureExcludedStructureComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("image")) {
            res.getImage().add(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BodyStructure.BodyStructureIncludedStructureComponent parseBodyStructureIncludedStructureComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BodyStructure.BodyStructureIncludedStructureComponent res = new BodyStructure.BodyStructureIncludedStructureComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBodyStructureIncludedStructureComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBodyStructureIncludedStructureComponentContent(int eventType, XmlPullParser xpp, BodyStructure.BodyStructureIncludedStructureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("structure")) {
            res.setStructure(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("laterality")) {
            res.setLaterality(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("qualifier")) {
            res.getQualifier().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BodyStructure.BodyStructureExcludedStructureComponent parseBodyStructureExcludedStructureComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BodyStructure.BodyStructureExcludedStructureComponent res = new BodyStructure.BodyStructureExcludedStructureComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBodyStructureExcludedStructureComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBodyStructureExcludedStructureComponentContent(int eventType, XmlPullParser xpp, BodyStructure.BodyStructureExcludedStructureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("structure")) {
            res.setStructure(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("laterality")) {
            res.setLaterality(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("qualifier")) {
            res.getQualifier().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle parseBundle(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle res = new Bundle();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleContent(int eventType, XmlPullParser xpp, Bundle res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("timestamp")) {
            res.setTimestampElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("total")) {
            res.setTotalElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseBundleLinkComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entry")) {
            res.getEntry().add(this.parseBundleEntryComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("signature")) {
            res.setSignature(this.parseSignature(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issues")) {
            res.setIssues(this.parseResourceContained(xpp));
        } else if (!this.parseResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleLinkComponent parseBundleLinkComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleLinkComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleLinkComponentContent(int eventType, XmlPullParser xpp, Bundle.BundleLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("relation")) {
            res.setRelationElement(this.parseEnumeration(xpp, Bundle.LinkRelationTypes.NULL, new Bundle.LinkRelationTypesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleEntryComponent parseBundleEntryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleEntryComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleEntryComponentContent(int eventType, XmlPullParser xpp, Bundle.BundleEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseBundleLinkComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fullUrl")) {
            res.setFullUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseResourceContained(xpp));
        } else if (eventType == 2 && xpp.getName().equals("search")) {
            res.setSearch(this.parseBundleEntrySearchComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseBundleEntryRequestComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("response")) {
            res.setResponse(this.parseBundleEntryResponseComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleEntrySearchComponent parseBundleEntrySearchComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleEntrySearchComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleEntrySearchComponentContent(int eventType, XmlPullParser xpp, Bundle.BundleEntrySearchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("score")) {
            res.setScoreElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleEntryRequestComponent parseBundleEntryRequestComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleEntryRequestComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleEntryRequestComponentContent(int eventType, XmlPullParser xpp, Bundle.BundleEntryRequestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethodElement(this.parseEnumeration(xpp, Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ifNoneMatch")) {
            res.setIfNoneMatchElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ifModifiedSince")) {
            res.setIfModifiedSinceElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ifMatch")) {
            res.setIfMatchElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ifNoneExist")) {
            res.setIfNoneExistElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleEntryResponseComponent parseBundleEntryResponseComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleEntryResponseComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleEntryResponseComponentContent(int eventType, XmlPullParser xpp, Bundle.BundleEntryResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocationElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("etag")) {
            res.setEtagElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastModified")) {
            res.setLastModifiedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseResourceContained(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement parseCapabilityStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement res = new CapabilityStatement();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementContent(int eventType, XmlPullParser xpp, CapabilityStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "versionAlgorithm")) {
            res.setVersionAlgorithm(this.parseType("versionAlgorithm", xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, Enumerations.CapabilityStatementKind.NULL, new Enumerations.CapabilityStatementKindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("instantiates")) {
            res.getInstantiates().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("imports")) {
            res.getImports().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("software")) {
            res.setSoftware(this.parseCapabilityStatementSoftwareComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("implementation")) {
            res.setImplementation(this.parseCapabilityStatementImplementationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
            res.setFhirVersionElement(this.parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("format")) {
            res.getFormat().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patchFormat")) {
            res.getPatchFormat().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("acceptLanguage")) {
            res.getAcceptLanguage().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("implementationGuide")) {
            res.getImplementationGuide().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rest")) {
            res.getRest().add(this.parseCapabilityStatementRestComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("messaging")) {
            res.getMessaging().add(this.parseCapabilityStatementMessagingComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("document")) {
            res.getDocument().add(this.parseCapabilityStatementDocumentComponent(xpp));
        } else if (!this.parseCanonicalResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementSoftwareComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementSoftwareComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementSoftwareComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("releaseDate")) {
            res.setReleaseDateElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementImplementationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementImplementationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementImplementationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementImplementationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("custodian")) {
            res.setCustodian(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementRestComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementRestComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementRestComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementRestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, CapabilityStatement.RestfulCapabilityMode.NULL, new CapabilityStatement.RestfulCapabilityModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("security")) {
            res.setSecurity(this.parseCapabilityStatementRestSecurityComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResource().add(this.parseCapabilityStatementRestResourceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interaction")) {
            res.getInteraction().add(this.parseCapabilityStatementSystemInteractionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
            res.getSearchParam().add(this.parseCapabilityStatementRestResourceSearchParamComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operation")) {
            res.getOperation().add(this.parseCapabilityStatementRestResourceOperationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("compartment")) {
            res.getCompartment().add(this.parseCanonical(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementRestSecurityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementRestSecurityComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementRestSecurityComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("cors")) {
            res.setCorsElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.getService().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementRestResourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementRestResourceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementRestResourceComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportedProfile")) {
            res.getSupportedProfile().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interaction")) {
            res.getInteraction().add(this.parseCapabilityStatementResourceInteractionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("versioning")) {
            res.setVersioningElement(this.parseEnumeration(xpp, CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("readHistory")) {
            res.setReadHistoryElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("updateCreate")) {
            res.setUpdateCreateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conditionalCreate")) {
            res.setConditionalCreateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conditionalRead")) {
            res.setConditionalReadElement(this.parseEnumeration(xpp, CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("conditionalUpdate")) {
            res.setConditionalUpdateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conditionalPatch")) {
            res.setConditionalPatchElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conditionalDelete")) {
            res.setConditionalDeleteElement(this.parseEnumeration(xpp, CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("referencePolicy")) {
            res.getReferencePolicy().add(this.parseEnumeration(xpp, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("searchInclude")) {
            res.getSearchInclude().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchRevInclude")) {
            res.getSearchRevInclude().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
            res.getSearchParam().add(this.parseCapabilityStatementRestResourceSearchParamComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operation")) {
            res.getOperation().add(this.parseCapabilityStatementRestResourceOperationComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementResourceInteractionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementResourceInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.ResourceInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementRestResourceSearchParamComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementRestResourceSearchParamComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementRestResourceSearchParamComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestResourceOperationComponent parseCapabilityStatementRestResourceOperationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent res = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementRestResourceOperationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementRestResourceOperationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementRestResourceOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementSystemInteractionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementSystemInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.SystemInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementMessagingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementMessagingComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementMessagingComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementMessagingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseCapabilityStatementMessagingEndpointComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reliableCache")) {
            res.setReliableCacheElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportedMessage")) {
            res.getSupportedMessage().add(this.parseCapabilityStatementMessagingSupportedMessageComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementMessagingEndpointComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementMessagingEndpointComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementMessagingEndpointComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("protocol")) {
            res.setProtocol(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddressElement(this.parseUrl(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementMessagingSupportedMessageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementMessagingSupportedMessageComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementMessagingSupportedMessageComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseCanonical(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementDocumentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementDocumentComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementDocumentComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement.CapabilityStatementDocumentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CarePlan parseCarePlan(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan res = new CarePlan();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCarePlanContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCarePlanContent(int eventType, XmlPullParser xpp, CarePlan res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.getInstantiatesCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.getInstantiatesUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("custodian")) {
            res.setCustodian(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributor")) {
            res.getContributor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeam")) {
            res.getCareTeam().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("addresses")) {
            res.getAddresses().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("goal")) {
            res.getGoal().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("activity")) {
            res.getActivity().add(this.parseCarePlanActivityComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CarePlan.CarePlanActivityComponent parseCarePlanActivityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCarePlanActivityComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCarePlanActivityComponentContent(int eventType, XmlPullParser xpp, CarePlan.CarePlanActivityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("performedActivity")) {
            res.getPerformedActivity().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("progress")) {
            res.getProgress().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("plannedActivityReference")) {
            res.setPlannedActivityReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("plannedActivityDetail")) {
            res.setPlannedActivityDetail(this.parseCarePlanActivityPlannedActivityDetailComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CarePlan.CarePlanActivityPlannedActivityDetailComponent parseCarePlanActivityPlannedActivityDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanActivityPlannedActivityDetailComponent res = new CarePlan.CarePlanActivityPlannedActivityDetailComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCarePlanActivityPlannedActivityDetailComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCarePlanActivityPlannedActivityDetailComponentContent(int eventType, XmlPullParser xpp, CarePlan.CarePlanActivityPlannedActivityDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, CarePlan.CarePlanActivityKind.NULL, new CarePlan.CarePlanActivityKindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.getInstantiatesCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.getInstantiatesUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("goal")) {
            res.getGoal().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "scheduled")) {
            res.setScheduled(this.parseType("scheduled", xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "reported")) {
            res.setReported(this.parseType("reported", xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "product")) {
            res.setProduct(this.parseType("product", xpp));
        } else if (eventType == 2 && xpp.getName().equals("dailyAmount")) {
            res.setDailyAmount(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CareTeam parseCareTeam(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CareTeam res = new CareTeam();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCareTeamContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCareTeamContent(int eventType, XmlPullParser xpp, CareTeam res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseCareTeamParticipantComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.getManagingOrganization().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CareTeam.CareTeamParticipantComponent parseCareTeamParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCareTeamParticipantComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCareTeamParticipantComponentContent(int eventType, XmlPullParser xpp, CareTeam.CareTeamParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("member")) {
            res.setMember(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "coverage")) {
            res.setCoverage(this.parseType("coverage", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItem parseChargeItem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItem res = new ChargeItem();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemContent(int eventType, XmlPullParser xpp, ChargeItem res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definitionUri")) {
            res.getDefinitionUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definitionCanonical")) {
            res.getDefinitionCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseChargeItemPerformerComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performingOrganization")) {
            res.setPerformingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestingOrganization")) {
            res.setRequestingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("costCenter")) {
            res.setCostCenter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodysite")) {
            res.getBodysite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPriceComponent")) {
            res.setUnitPriceComponent(this.parseMonetaryComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("totalPriceComponent")) {
            res.setTotalPriceComponent(this.parseMonetaryComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("overrideReason")) {
            res.setOverrideReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enteredDate")) {
            res.setEnteredDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.getService().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("product")) {
            res.getProduct().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.getAccount().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItem.ChargeItemPerformerComponent parseChargeItemPerformerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItem.ChargeItemPerformerComponent res = new ChargeItem.ChargeItemPerformerComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemPerformerComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemPerformerComponentContent(int eventType, XmlPullParser xpp, ChargeItem.ChargeItemPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItemDefinition parseChargeItemDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItemDefinition res = new ChargeItemDefinition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemDefinitionContent(int eventType, XmlPullParser xpp, ChargeItemDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("derivedFromUri")) {
            res.getDerivedFromUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instance")) {
            res.getInstance().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("applicability")) {
            res.getApplicability().add(this.parseChargeItemDefinitionApplicabilityComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("propertyGroup")) {
            res.getPropertyGroup().add(this.parseChargeItemDefinitionPropertyGroupComponent(xpp));
        } else if (!this.parseMetadataResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent parseChargeItemDefinitionApplicabilityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res = new ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemDefinitionApplicabilityComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemDefinitionApplicabilityComponentContent(int eventType, XmlPullParser xpp, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setCondition(this.parseExpression(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.setRelatedArtifact(this.parseRelatedArtifact(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent parseChargeItemDefinitionPropertyGroupComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemDefinitionPropertyGroupComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemDefinitionPropertyGroupComponentContent(int eventType, XmlPullParser xpp, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("applicability")) {
            res.getApplicability().add(this.parseChargeItemDefinitionApplicabilityComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priceComponent")) {
            res.getPriceComponent().add(this.parseMonetaryComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation parseCitation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation res = new Citation();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationContent(int eventType, XmlPullParser xpp, Citation res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("summary")) {
            res.getSummary().add(this.parseCitationSummaryComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classification")) {
            res.getClassification().add(this.parseCitationClassificationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("currentState")) {
            res.getCurrentState().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statusDate")) {
            res.getStatusDate().add(this.parseCitationStatusDateComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("citedArtifact")) {
            res.setCitedArtifact(this.parseCitationCitedArtifactComponent(xpp));
        } else if (!this.parseMetadataResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationSummaryComponent parseCitationSummaryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationSummaryComponent res = new Citation.CitationSummaryComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationSummaryComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationSummaryComponentContent(int eventType, XmlPullParser xpp, Citation.CitationSummaryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("style")) {
            res.setStyle(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationClassificationComponent parseCitationClassificationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationClassificationComponent res = new Citation.CitationClassificationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationClassificationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationClassificationComponentContent(int eventType, XmlPullParser xpp, Citation.CitationClassificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classifier")) {
            res.getClassifier().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationStatusDateComponent parseCitationStatusDateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationStatusDateComponent res = new Citation.CitationStatusDateComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationStatusDateComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationStatusDateComponentContent(int eventType, XmlPullParser xpp, Citation.CitationStatusDateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("activity")) {
            res.setActivity(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actual")) {
            res.setActualElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactComponent parseCitationCitedArtifactComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactComponent res = new Citation.CitationCitedArtifactComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedIdentifier")) {
            res.getRelatedIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateAccessed")) {
            res.setDateAccessedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersion(this.parseCitationCitedArtifactVersionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("currentState")) {
            res.getCurrentState().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statusDate")) {
            res.getStatusDate().add(this.parseCitationCitedArtifactStatusDateComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.getTitle().add(this.parseCitationCitedArtifactTitleComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("abstract")) {
            res.getAbstract().add(this.parseCitationCitedArtifactAbstractComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("part")) {
            res.setPart(this.parseCitationCitedArtifactPartComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatesTo")) {
            res.getRelatesTo().add(this.parseCitationCitedArtifactRelatesToComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publicationForm")) {
            res.getPublicationForm().add(this.parseCitationCitedArtifactPublicationFormComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("webLocation")) {
            res.getWebLocation().add(this.parseCitationCitedArtifactWebLocationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classification")) {
            res.getClassification().add(this.parseCitationCitedArtifactClassificationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributorship")) {
            res.setContributorship(this.parseCitationCitedArtifactContributorshipComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactVersionComponent parseCitationCitedArtifactVersionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactVersionComponent res = new Citation.CitationCitedArtifactVersionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactVersionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactVersionComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("baseCitation")) {
            res.setBaseCitation(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactStatusDateComponent parseCitationCitedArtifactStatusDateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactStatusDateComponent res = new Citation.CitationCitedArtifactStatusDateComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactStatusDateComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactStatusDateComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactStatusDateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("activity")) {
            res.setActivity(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actual")) {
            res.setActualElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactTitleComponent parseCitationCitedArtifactTitleComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactTitleComponent res = new Citation.CitationCitedArtifactTitleComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactTitleComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactTitleComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactTitleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactAbstractComponent parseCitationCitedArtifactAbstractComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactAbstractComponent res = new Citation.CitationCitedArtifactAbstractComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactAbstractComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactAbstractComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactAbstractComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactPartComponent parseCitationCitedArtifactPartComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactPartComponent res = new Citation.CitationCitedArtifactPartComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactPartComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactPartComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactPartComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("baseCitation")) {
            res.setBaseCitation(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactRelatesToComponent parseCitationCitedArtifactRelatesToComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactRelatesToComponent res = new Citation.CitationCitedArtifactRelatesToComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactRelatesToComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactRelatesToComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Citation.RelatedArtifactTypeExpanded.NULL, new Citation.RelatedArtifactTypeExpandedEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("classifier")) {
            res.getClassifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("citation")) {
            res.setCitationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("document")) {
            res.setDocument(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResourceElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resourceReference")) {
            res.setResourceReference(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactPublicationFormComponent parseCitationCitedArtifactPublicationFormComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactPublicationFormComponent res = new Citation.CitationCitedArtifactPublicationFormComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactPublicationFormComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactPublicationFormComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactPublicationFormComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("publishedIn")) {
            res.setPublishedIn(this.parseCitationCitedArtifactPublicationFormPublishedInComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("citedMedium")) {
            res.setCitedMedium(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("volume")) {
            res.setVolumeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issue")) {
            res.setIssueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publicationDateYear")) {
            res.setPublicationDateYearElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publicationDateMonth")) {
            res.setPublicationDateMonthElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publicationDateDay")) {
            res.setPublicationDateDayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publicationDateSeason")) {
            res.setPublicationDateSeasonElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publicationDateText")) {
            res.setPublicationDateTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("articleDate")) {
            res.setArticleDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastRevisionDate")) {
            res.setLastRevisionDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.getLanguage().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("accessionNumber")) {
            res.setAccessionNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("pageString")) {
            res.setPageStringElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("firstPage")) {
            res.setFirstPageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastPage")) {
            res.setLastPageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("pageCount")) {
            res.setPageCountElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactPublicationFormPublishedInComponent parseCitationCitedArtifactPublicationFormPublishedInComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactPublicationFormPublishedInComponent res = new Citation.CitationCitedArtifactPublicationFormPublishedInComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactPublicationFormPublishedInComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactPublicationFormPublishedInComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactPublicationFormPublishedInComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisher(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisherLocation")) {
            res.setPublisherLocationElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactWebLocationComponent parseCitationCitedArtifactWebLocationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactWebLocationComponent res = new Citation.CitationCitedArtifactWebLocationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactWebLocationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactWebLocationComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactWebLocationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("classifier")) {
            res.getClassifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactClassificationComponent parseCitationCitedArtifactClassificationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactClassificationComponent res = new Citation.CitationCitedArtifactClassificationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactClassificationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactClassificationComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactClassificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classifier")) {
            res.getClassifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("artifactAssessment")) {
            res.getArtifactAssessment().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactContributorshipComponent parseCitationCitedArtifactContributorshipComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactContributorshipComponent res = new Citation.CitationCitedArtifactContributorshipComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactContributorshipComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactContributorshipComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactContributorshipComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("complete")) {
            res.setCompleteElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entry")) {
            res.getEntry().add(this.parseCitationCitedArtifactContributorshipEntryComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("summary")) {
            res.getSummary().add(this.parseCitationContributorshipSummaryComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactContributorshipEntryComponent parseCitationCitedArtifactContributorshipEntryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactContributorshipEntryComponent res = new Citation.CitationCitedArtifactContributorshipEntryComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactContributorshipEntryComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactContributorshipEntryComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactContributorshipEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("contributor")) {
            res.setContributor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("forenameInitials")) {
            res.setForenameInitialsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("affiliation")) {
            res.getAffiliation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributionType")) {
            res.getContributionType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributionInstance")) {
            res.getContributionInstance().add(this.parseCitationCitedArtifactContributorshipEntryContributionInstanceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("correspondingContact")) {
            res.setCorrespondingContactElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rankingOrder")) {
            res.setRankingOrderElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent parseCitationCitedArtifactContributorshipEntryContributionInstanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent res = new Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationCitedArtifactContributorshipEntryContributionInstanceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationCitedArtifactContributorshipEntryContributionInstanceComponentContent(int eventType, XmlPullParser xpp, Citation.CitationCitedArtifactContributorshipEntryContributionInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTimeElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Citation.ContributorshipSummaryComponent parseCitationContributorshipSummaryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Citation.ContributorshipSummaryComponent res = new Citation.ContributorshipSummaryComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCitationContributorshipSummaryComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCitationContributorshipSummaryComponentContent(int eventType, XmlPullParser xpp, Citation.ContributorshipSummaryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("style")) {
            res.setStyle(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim parseClaim(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim res = new Claim();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimContent(int eventType, XmlPullParser xpp, Claim res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.setSubType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("related")) {
            res.getRelated().add(this.parseClaimRelatedClaimComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prescription")) {
            res.setPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payee")) {
            res.setPayee(this.parseClaimPayeeComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referral")) {
            res.setReferral(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.getEncounter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facility")) {
            res.setFacility(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosisRelatedGroup")) {
            res.setDiagnosisRelatedGroup(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeam")) {
            res.getCareTeam().add(this.parseClaimCareTeamComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseClaimSupportingInformationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseClaimDiagnosisComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedure")) {
            res.getProcedure().add(this.parseClaimProcedureComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseClaimInsuranceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("accident")) {
            res.setAccident(this.parseClaimAccidentComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientPaid")) {
            res.setPatientPaid(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseClaimItemComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("total")) {
            res.setTotal(this.parseMoney(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimRelatedClaimComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimRelatedClaimComponentContent(int eventType, XmlPullParser xpp, Claim.RelatedClaimComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("claim")) {
            res.setClaim(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.PayeeComponent parseClaimPayeeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.PayeeComponent res = new Claim.PayeeComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimPayeeComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimPayeeComponentContent(int eventType, XmlPullParser xpp, Claim.PayeeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.CareTeamComponent parseClaimCareTeamComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.CareTeamComponent res = new Claim.CareTeamComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimCareTeamComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimCareTeamComponentContent(int eventType, XmlPullParser xpp, Claim.CareTeamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsible")) {
            res.setResponsibleElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialty")) {
            res.setSpecialty(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.SupportingInformationComponent parseClaimSupportingInformationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.SupportingInformationComponent res = new Claim.SupportingInformationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimSupportingInformationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimSupportingInformationComponentContent(int eventType, XmlPullParser xpp, Claim.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimDiagnosisComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimDiagnosisComponentContent(int eventType, XmlPullParser xpp, Claim.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "diagnosis")) {
            res.setDiagnosis(this.parseType("diagnosis", xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onAdmission")) {
            res.setOnAdmission(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.ProcedureComponent parseClaimProcedureComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.ProcedureComponent res = new Claim.ProcedureComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimProcedureComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimProcedureComponentContent(int eventType, XmlPullParser xpp, Claim.ProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "procedure")) {
            res.setProcedure(this.parseType("procedure", xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.InsuranceComponent parseClaimInsuranceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.InsuranceComponent res = new Claim.InsuranceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimInsuranceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimInsuranceComponentContent(int eventType, XmlPullParser xpp, Claim.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focal")) {
            res.setFocalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.getPreAuthRef().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
            res.setClaimResponse(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.AccidentComponent parseClaimAccidentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.AccidentComponent res = new Claim.AccidentComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimAccidentComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimAccidentComponentContent(int eventType, XmlPullParser xpp, Claim.AccidentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.ItemComponent parseClaimItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.ItemComponent res = new Claim.ItemComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimItemComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimItemComponentContent(int eventType, XmlPullParser xpp, Claim.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeamSequence")) {
            res.getCareTeamSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosisSequence")) {
            res.getDiagnosisSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedureSequence")) {
            res.getProcedureSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("informationSequence")) {
            res.getInformationSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientPaid")) {
            res.setPatientPaid(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tax")) {
            res.setTax(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.getBodySite().add(this.parseClaimBodySiteComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.getEncounter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseClaimDetailComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.BodySiteComponent parseClaimBodySiteComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.BodySiteComponent res = new Claim.BodySiteComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimBodySiteComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimBodySiteComponentContent(int eventType, XmlPullParser xpp, Claim.BodySiteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("site")) {
            res.getSite().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subSite")) {
            res.getSubSite().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.DetailComponent parseClaimDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.DetailComponent res = new Claim.DetailComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimDetailComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimDetailComponentContent(int eventType, XmlPullParser xpp, Claim.DetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientPaid")) {
            res.setPatientPaid(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tax")) {
            res.setTax(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseClaimSubDetailComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.SubDetailComponent parseClaimSubDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.SubDetailComponent res = new Claim.SubDetailComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimSubDetailComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimSubDetailComponentContent(int eventType, XmlPullParser xpp, Claim.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientPaid")) {
            res.setPatientPaid(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tax")) {
            res.setTax(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse parseClaimResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse res = new ClaimResponse();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseContent(int eventType, XmlPullParser xpp, ClaimResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.setSubType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestor")) {
            res.setRequestor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.setPreAuthRefElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthPeriod")) {
            res.setPreAuthPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payeeType")) {
            res.setPayeeType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.getEncounter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosisRelatedGroup")) {
            res.setDiagnosisRelatedGroup(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseClaimResponseItemComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("addItem")) {
            res.getAddItem().add(this.parseClaimResponseAddedItemComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("total")) {
            res.getTotal().add(this.parseClaimResponseTotalComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payment")) {
            res.setPayment(this.parseClaimResponsePaymentComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("formCode")) {
            res.setFormCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("processNote")) {
            res.getProcessNote().add(this.parseClaimResponseNoteComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("communicationRequest")) {
            res.getCommunicationRequest().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseClaimResponseInsuranceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("error")) {
            res.getError().add(this.parseClaimResponseErrorComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseItemComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseItemComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("itemSequence")) {
            res.setItemSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseClaimResponseItemDetailComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseAdjudicationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseAdjudicationComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.AdjudicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseItemDetailComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseItemDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.ItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("detailSequence")) {
            res.setDetailSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseClaimResponseSubDetailComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseSubDetailComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseSubDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("subDetailSequence")) {
            res.setSubDetailSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseAddedItemComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseAddedItemComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.AddedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("itemSequence")) {
            res.getItemSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detailSequence")) {
            res.getDetailSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subdetailSequence")) {
            res.getSubdetailSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.getProvider().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tax")) {
            res.setTax(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.getBodySite().add(this.parseClaimResponseBodySiteComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseClaimResponseAddedItemDetailComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.BodySiteComponent parseClaimResponseBodySiteComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.BodySiteComponent res = new ClaimResponse.BodySiteComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseBodySiteComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseBodySiteComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.BodySiteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("site")) {
            res.getSite().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subSite")) {
            res.getSubSite().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.AddedItemDetailComponent parseClaimResponseAddedItemDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemDetailComponent res = new ClaimResponse.AddedItemDetailComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseAddedItemDetailComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseAddedItemDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.AddedItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tax")) {
            res.setTax(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseClaimResponseAddedItemSubDetailComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.AddedItemSubDetailComponent parseClaimResponseAddedItemSubDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemSubDetailComponent res = new ClaimResponse.AddedItemSubDetailComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseAddedItemSubDetailComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseAddedItemSubDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.AddedItemSubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tax")) {
            res.setTax(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.TotalComponent parseClaimResponseTotalComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.TotalComponent res = new ClaimResponse.TotalComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseTotalComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseTotalComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.TotalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponsePaymentComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponsePaymentComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.PaymentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjustment")) {
            res.setAdjustment(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjustmentReason")) {
            res.setAdjustmentReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseNoteComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseNoteComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.NoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseInsuranceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseInsuranceComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focal")) {
            res.setFocalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
            res.setClaimResponse(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseErrorComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseErrorComponentContent(int eventType, XmlPullParser xpp, ClaimResponse.ErrorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("itemSequence")) {
            res.setItemSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detailSequence")) {
            res.setDetailSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subDetailSequence")) {
            res.setSubDetailSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalImpression parseClinicalImpression(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression res = new ClinicalImpression();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalImpressionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalImpressionContent(int eventType, XmlPullParser xpp, ClinicalImpression res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.EventStatus.NULL, new Enumerations.EventStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
            res.setEffective(this.parseType("effective", xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("previous")) {
            res.setPrevious(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("problem")) {
            res.getProblem().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("changePattern")) {
            res.setChangePattern(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("protocol")) {
            res.getProtocol().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("summary")) {
            res.setSummaryElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("finding")) {
            res.getFinding().add(this.parseClinicalImpressionFindingComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prognosisCodeableConcept")) {
            res.getPrognosisCodeableConcept().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prognosisReference")) {
            res.getPrognosisReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionFindingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalImpressionFindingComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalImpressionFindingComponentContent(int eventType, XmlPullParser xpp, ClinicalImpression.ClinicalImpressionFindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("item")) {
            res.setItem(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basis")) {
            res.setBasisElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalUseDefinition parseClinicalUseDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalUseDefinition res = new ClinicalUseDefinition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalUseDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalUseDefinitionContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, ClinicalUseDefinition.ClinicalUseDefinitionType.NULL, new ClinicalUseDefinition.ClinicalUseDefinitionTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contraindication")) {
            res.setContraindication(this.parseClinicalUseDefinitionContraindicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("indication")) {
            res.setIndication(this.parseClinicalUseDefinitionIndicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interaction")) {
            res.setInteraction(this.parseClinicalUseDefinitionInteractionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("population")) {
            res.getPopulation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("library")) {
            res.getLibrary().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("undesirableEffect")) {
            res.setUndesirableEffect(this.parseClinicalUseDefinitionUndesirableEffectComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("warning")) {
            res.setWarning(this.parseClinicalUseDefinitionWarningComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent parseClinicalUseDefinitionContraindicationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalUseDefinitionContraindicationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalUseDefinitionContraindicationComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("diseaseSymptomProcedure")) {
            res.setDiseaseSymptomProcedure(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diseaseStatus")) {
            res.setDiseaseStatus(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comorbidity")) {
            res.getComorbidity().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("indication")) {
            res.getIndication().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("applicability")) {
            res.setApplicability(this.parseExpression(xpp));
        } else if (eventType == 2 && xpp.getName().equals("otherTherapy")) {
            res.getOtherTherapy().add(this.parseClinicalUseDefinitionContraindicationOtherTherapyComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent parseClinicalUseDefinitionContraindicationOtherTherapyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalUseDefinitionContraindicationOtherTherapyComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalUseDefinitionContraindicationOtherTherapyComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionContraindicationOtherTherapyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("relationshipType")) {
            res.setRelationshipType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("treatment")) {
            res.setTreatment(this.parseCodeableReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent parseClinicalUseDefinitionIndicationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalUseDefinitionIndicationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalUseDefinitionIndicationComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionIndicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("diseaseSymptomProcedure")) {
            res.setDiseaseSymptomProcedure(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diseaseStatus")) {
            res.setDiseaseStatus(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comorbidity")) {
            res.getComorbidity().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intendedEffect")) {
            res.setIntendedEffect(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "duration")) {
            res.setDuration(this.parseType("duration", xpp));
        } else if (eventType == 2 && xpp.getName().equals("undesirableEffect")) {
            res.getUndesirableEffect().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("applicability")) {
            res.setApplicability(this.parseExpression(xpp));
        } else if (eventType == 2 && xpp.getName().equals("otherTherapy")) {
            res.getOtherTherapy().add(this.parseClinicalUseDefinitionContraindicationOtherTherapyComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent parseClinicalUseDefinitionInteractionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalUseDefinitionInteractionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalUseDefinitionInteractionComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("interactant")) {
            res.getInteractant().add(this.parseClinicalUseDefinitionInteractionInteractantComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effect")) {
            res.setEffect(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("incidence")) {
            res.setIncidence(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("management")) {
            res.getManagement().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent parseClinicalUseDefinitionInteractionInteractantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalUseDefinitionInteractionInteractantComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalUseDefinitionInteractionInteractantComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionInteractionInteractantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent parseClinicalUseDefinitionUndesirableEffectComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalUseDefinitionUndesirableEffectComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalUseDefinitionUndesirableEffectComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionUndesirableEffectComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("symptomConditionEffect")) {
            res.setSymptomConditionEffect(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classification")) {
            res.setClassification(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("frequencyOfOccurrence")) {
            res.setFrequencyOfOccurrence(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent parseClinicalUseDefinitionWarningComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent res = new ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalUseDefinitionWarningComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalUseDefinitionWarningComponentContent(int eventType, XmlPullParser xpp, ClinicalUseDefinition.ClinicalUseDefinitionWarningComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem parseCodeSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem res = new CodeSystem();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemContent(int eventType, XmlPullParser xpp, CodeSystem res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("caseSensitive")) {
            res.setCaseSensitiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
            res.setValueSetElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hierarchyMeaning")) {
            res.setHierarchyMeaningElement(this.parseEnumeration(xpp, CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("compositional")) {
            res.setCompositionalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("versionNeeded")) {
            res.setVersionNeededElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.setContentElement(this.parseEnumeration(xpp, CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("supplements")) {
            res.setSupplementsElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCountElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("filter")) {
            res.getFilter().add(this.parseCodeSystemFilterComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseCodeSystemPropertyComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("concept")) {
            res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(xpp));
        } else if (!this.parseMetadataResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.CodeSystemFilterComponent parseCodeSystemFilterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemFilterComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemFilterComponentContent(int eventType, XmlPullParser xpp, CodeSystem.CodeSystemFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operator")) {
            res.getOperator().add(this.parseEnumeration(xpp, Enumerations.FilterOperator.NULL, new Enumerations.FilterOperatorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemPropertyComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemPropertyComponentContent(int eventType, XmlPullParser xpp, CodeSystem.PropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uri")) {
            res.setUriElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemConceptDefinitionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemConceptDefinitionComponentContent(int eventType, XmlPullParser xpp, CodeSystem.ConceptDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("designation")) {
            res.getDesignation().add(this.parseCodeSystemConceptDefinitionDesignationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseCodeSystemConceptPropertyComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("concept")) {
            res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemConceptDefinitionDesignationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemConceptDefinitionDesignationComponentContent(int eventType, XmlPullParser xpp, CodeSystem.ConceptDefinitionDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUse(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additionalUse")) {
            res.getAdditionalUse().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemConceptPropertyComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemConceptPropertyComponentContent(int eventType, XmlPullParser xpp, CodeSystem.ConceptPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Communication parseCommunication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Communication res = new Communication();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationContent(int eventType, XmlPullParser xpp, Communication res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.getInstantiatesCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.getInstantiatesUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("inResponseTo")) {
            res.getInResponseTo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.EventStatus.NULL, new Enumerations.EventStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("medium")) {
            res.getMedium().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.setTopic(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("about")) {
            res.getAbout().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sent")) {
            res.setSentElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("received")) {
            res.setReceivedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.getRecipient().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sender")) {
            res.setSender(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payload")) {
            res.getPayload().add(this.parseCommunicationPayloadComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Communication.CommunicationPayloadComponent parseCommunicationPayloadComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationPayloadComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationPayloadComponentContent(int eventType, XmlPullParser xpp, Communication.CommunicationPayloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CommunicationRequest parseCommunicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CommunicationRequest res = new CommunicationRequest();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationRequestContent(int eventType, XmlPullParser xpp, CommunicationRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("medium")) {
            res.getMedium().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("about")) {
            res.getAbout().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payload")) {
            res.getPayload().add(this.parseCommunicationRequestPayloadComponent(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.setRequester(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.getRecipient().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("informationProvider")) {
            res.getInformationProvider().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestPayloadComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationRequestPayloadComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationRequestPayloadComponentContent(int eventType, XmlPullParser xpp, CommunicationRequest.CommunicationRequestPayloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CompartmentDefinition parseCompartmentDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CompartmentDefinition res = new CompartmentDefinition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompartmentDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompartmentDefinitionContent(int eventType, XmlPullParser xpp, CompartmentDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "versionAlgorithm")) {
            res.setVersionAlgorithm(this.parseType("versionAlgorithm", xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, Enumerations.CompartmentType.NULL, new Enumerations.CompartmentTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("search")) {
            res.setSearchElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResource().add(this.parseCompartmentDefinitionResourceComponent(xpp));
        } else if (!this.parseCanonicalResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionResourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompartmentDefinitionResourceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompartmentDefinitionResourceComponentContent(int eventType, XmlPullParser xpp, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("param")) {
            res.getParam().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("startParam")) {
            res.setStartParamElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endParam")) {
            res.setEndParamElement(this.parseUri(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition parseComposition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition res = new Composition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionContent(int eventType, XmlPullParser xpp, Composition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.CompositionStatus.NULL, new Enumerations.CompositionStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("attester")) {
            res.getAttester().add(this.parseCompositionAttesterComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("custodian")) {
            res.setCustodian(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatesTo")) {
            res.getRelatesTo().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("event")) {
            res.getEvent().add(this.parseCompositionEventComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("section")) {
            res.getSection().add(this.parseCompositionSectionComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition.CompositionAttesterComponent parseCompositionAttesterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionAttesterComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionAttesterComponentContent(int eventType, XmlPullParser xpp, Composition.CompositionAttesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setMode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition.CompositionEventComponent parseCompositionEventComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionEventComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionEventComponentContent(int eventType, XmlPullParser xpp, Composition.CompositionEventComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition.SectionComponent parseCompositionSectionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.SectionComponent res = new Composition.SectionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionSectionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionSectionComponentContent(int eventType, XmlPullParser xpp, Composition.SectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focus")) {
            res.setFocus(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setText(this.parseNarrative(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entry")) {
            res.getEntry().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("section")) {
            res.getSection().add(this.parseCompositionSectionComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap parseConceptMap(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap res = new ConceptMap();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapContent(int eventType, XmlPullParser xpp, ConceptMap res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "sourceScope")) {
            res.setSourceScope(this.parseType("sourceScope", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "targetScope")) {
            res.setTargetScope(this.parseType("targetScope", xpp));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.getGroup().add(this.parseConceptMapGroupComponent(xpp));
        } else if (!this.parseMetadataResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.ConceptMapGroupComponent parseConceptMapGroupComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapGroupComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapGroupComponentContent(int eventType, XmlPullParser xpp, ConceptMap.ConceptMapGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTargetElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("element")) {
            res.getElement().add(this.parseConceptMapSourceElementComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unmapped")) {
            res.setUnmapped(this.parseConceptMapGroupUnmappedComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapSourceElementComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapSourceElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap.SourceElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
            res.setValueSetElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noMap")) {
            res.setNoMapElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.getTarget().add(this.parseConceptMapTargetElementComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapTargetElementComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapTargetElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap.TargetElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
            res.setValueSetElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationshipElement(this.parseEnumeration(xpp, Enumerations.ConceptMapRelationship.NULL, new Enumerations.ConceptMapRelationshipEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dependsOn")) {
            res.getDependsOn().add(this.parseConceptMapOtherElementComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("product")) {
            res.getProduct().add(this.parseConceptMapOtherElementComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapOtherElementComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapOtherElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap.OtherElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("property")) {
            res.setPropertyElement(this.parseUri(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
            res.setValueSetElement(this.parseCanonical(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapGroupUnmappedComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapGroupUnmappedComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapGroupUnmappedComponentContent(int eventType, XmlPullParser xpp, ConceptMap.ConceptMapGroupUnmappedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
            res.setValueSetElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationshipElement(this.parseEnumeration(xpp, Enumerations.ConceptMapRelationship.NULL, new Enumerations.ConceptMapRelationshipEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("otherMap")) {
            res.setOtherMapElement(this.parseCanonical(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Condition parseCondition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition res = new Condition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionContent(int eventType, XmlPullParser xpp, Condition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("clinicalStatus")) {
            res.setClinicalStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("verificationStatus")) {
            res.setVerificationStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverity(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.getBodySite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
            res.setOnset(this.parseType("onset", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "abatement")) {
            res.setAbatement(this.parseType("abatement", xpp));
        } else if (eventType == 2 && xpp.getName().equals("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseConditionParticipantComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("stage")) {
            res.getStage().add(this.parseConditionStageComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("evidence")) {
            res.getEvidence().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Condition.ConditionParticipantComponent parseConditionParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition.ConditionParticipantComponent res = new Condition.ConditionParticipantComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionParticipantComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionParticipantComponentContent(int eventType, XmlPullParser xpp, Condition.ConditionParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Condition.ConditionStageComponent parseConditionStageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionStageComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionStageComponentContent(int eventType, XmlPullParser xpp, Condition.ConditionStageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("summary")) {
            res.setSummary(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("assessment")) {
            res.getAssessment().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConditionDefinition parseConditionDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConditionDefinition res = new ConditionDefinition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionDefinitionContent(int eventType, XmlPullParser xpp, ConditionDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverity(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("stage")) {
            res.setStage(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hasSeverity")) {
            res.setHasSeverityElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hasBodySite")) {
            res.setHasBodySiteElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hasStage")) {
            res.setHasStageElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("observation")) {
            res.getObservation().add(this.parseConditionDefinitionObservationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("medication")) {
            res.getMedication().add(this.parseConditionDefinitionMedicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("precondition")) {
            res.getPrecondition().add(this.parseConditionDefinitionPreconditionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("team")) {
            res.getTeam().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("questionnaire")) {
            res.getQuestionnaire().add(this.parseConditionDefinitionQuestionnaireComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("plan")) {
            res.getPlan().add(this.parseConditionDefinitionPlanComponent(xpp));
        } else if (!this.parseMetadataResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConditionDefinition.ConditionDefinitionObservationComponent parseConditionDefinitionObservationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionObservationComponent res = new ConditionDefinition.ConditionDefinitionObservationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionDefinitionObservationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionDefinitionObservationComponentContent(int eventType, XmlPullParser xpp, ConditionDefinition.ConditionDefinitionObservationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConditionDefinition.ConditionDefinitionMedicationComponent parseConditionDefinitionMedicationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionMedicationComponent res = new ConditionDefinition.ConditionDefinitionMedicationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionDefinitionMedicationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionDefinitionMedicationComponentContent(int eventType, XmlPullParser xpp, ConditionDefinition.ConditionDefinitionMedicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConditionDefinition.ConditionDefinitionPreconditionComponent parseConditionDefinitionPreconditionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionPreconditionComponent res = new ConditionDefinition.ConditionDefinitionPreconditionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionDefinitionPreconditionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionDefinitionPreconditionComponentContent(int eventType, XmlPullParser xpp, ConditionDefinition.ConditionDefinitionPreconditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, ConditionDefinition.ConditionPreconditionType.NULL, new ConditionDefinition.ConditionPreconditionTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConditionDefinition.ConditionDefinitionQuestionnaireComponent parseConditionDefinitionQuestionnaireComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionQuestionnaireComponent res = new ConditionDefinition.ConditionDefinitionQuestionnaireComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionDefinitionQuestionnaireComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionDefinitionQuestionnaireComponentContent(int eventType, XmlPullParser xpp, ConditionDefinition.ConditionDefinitionQuestionnaireComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseEnumeration(xpp, ConditionDefinition.ConditionQuestionnairePurpose.NULL, new ConditionDefinition.ConditionQuestionnairePurposeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConditionDefinition.ConditionDefinitionPlanComponent parseConditionDefinitionPlanComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConditionDefinition.ConditionDefinitionPlanComponent res = new ConditionDefinition.ConditionDefinitionPlanComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionDefinitionPlanComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionDefinitionPlanComponentContent(int eventType, XmlPullParser xpp, ConditionDefinition.ConditionDefinitionPlanComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent parseConsent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent res = new Consent();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentContent(int eventType, XmlPullParser xpp, Consent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("grantor")) {
            res.getGrantor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("grantee")) {
            res.getGrantee().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manager")) {
            res.getManager().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("controller")) {
            res.getController().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sourceAttachment")) {
            res.getSourceAttachment().add(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sourceReference")) {
            res.getSourceReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("regulatoryBasis")) {
            res.getRegulatoryBasis().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("policyBasis")) {
            res.setPolicyBasis(this.parseConsentPolicyBasisComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("policyText")) {
            res.getPolicyText().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("verification")) {
            res.getVerification().add(this.parseConsentVerificationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provision")) {
            res.setProvision(this.parseConsentProvisionComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ConsentPolicyBasisComponent parseConsentPolicyBasisComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ConsentPolicyBasisComponent res = new Consent.ConsentPolicyBasisComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentPolicyBasisComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentPolicyBasisComponentContent(int eventType, XmlPullParser xpp, Consent.ConsentPolicyBasisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUrl(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ConsentVerificationComponent parseConsentVerificationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ConsentVerificationComponent res = new Consent.ConsentVerificationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentVerificationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentVerificationComponentContent(int eventType, XmlPullParser xpp, Consent.ConsentVerificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("verified")) {
            res.setVerifiedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("verificationType")) {
            res.setVerificationType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("verifiedBy")) {
            res.setVerifiedBy(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("verifiedWith")) {
            res.setVerifiedWith(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("verificationDate")) {
            res.getVerificationDate().add(this.parseDateTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ProvisionComponent parseConsentProvisionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ProvisionComponent res = new Consent.ProvisionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentProvisionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentProvisionComponentContent(int eventType, XmlPullParser xpp, Consent.ProvisionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.ConsentProvisionType.NULL, new Enumerations.ConsentProvisionTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.getActor().add(this.parseConsentProvisionActorComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.getPurpose().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentType")) {
            res.getDocumentType().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resourceType")) {
            res.getResourceType().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataPeriod")) {
            res.setDataPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.getData().add(this.parseConsentProvisionDataComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpression(this.parseExpression(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provision")) {
            res.getProvision().add(this.parseConsentProvisionComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ProvisionActorComponent parseConsentProvisionActorComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ProvisionActorComponent res = new Consent.ProvisionActorComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentProvisionActorComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentProvisionActorComponentContent(int eventType, XmlPullParser xpp, Consent.ProvisionActorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ProvisionDataComponent parseConsentProvisionDataComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ProvisionDataComponent res = new Consent.ProvisionDataComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentProvisionDataComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentProvisionDataComponentContent(int eventType, XmlPullParser xpp, Consent.ProvisionDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("meaning")) {
            res.setMeaningElement(this.parseEnumeration(xpp, Enumerations.ConsentDataMeaning.NULL, new Enumerations.ConsentDataMeaningEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract parseContract(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract res = new Contract();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractContent(int eventType, XmlPullParser xpp, Contract res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Contract.ContractResourceStatusCodes.NULL, new Contract.ContractResourceStatusCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("legalState")) {
            res.setLegalState(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.setInstantiatesCanonical(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.setInstantiatesUriElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contentDerivative")) {
            res.setContentDerivative(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("applies")) {
            res.setApplies(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expirationType")) {
            res.setExpirationType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authority")) {
            res.getAuthority().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("domain")) {
            res.getDomain().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("site")) {
            res.getSite().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alias")) {
            res.getAlias().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scope")) {
            res.setScope(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "topic")) {
            res.setTopic(this.parseType("topic", xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.getSubType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contentDefinition")) {
            res.setContentDefinition(this.parseContractContentDefinitionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("term")) {
            res.getTerm().add(this.parseContractTermComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relevantHistory")) {
            res.getRelevantHistory().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("signer")) {
            res.getSigner().add(this.parseContractSignatoryComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("friendly")) {
            res.getFriendly().add(this.parseContractFriendlyLanguageComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("legal")) {
            res.getLegal().add(this.parseContractLegalLanguageComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rule")) {
            res.getRule().add(this.parseContractComputableLanguageComponent(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "legallyBinding")) {
            res.setLegallyBinding(this.parseType("legallyBinding", xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ContentDefinitionComponent parseContractContentDefinitionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ContentDefinitionComponent res = new Contract.ContentDefinitionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractContentDefinitionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractContentDefinitionComponentContent(int eventType, XmlPullParser xpp, Contract.ContentDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.setSubType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisher(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publicationDate")) {
            res.setPublicationDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publicationStatus")) {
            res.setPublicationStatusElement(this.parseEnumeration(xpp, Contract.ContractResourcePublicationStatusCodes.NULL, new Contract.ContractResourcePublicationStatusCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.TermComponent parseContractTermComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.TermComponent res = new Contract.TermComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractTermComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractTermComponentContent(int eventType, XmlPullParser xpp, Contract.TermComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("applies")) {
            res.setApplies(this.parsePeriod(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "topic")) {
            res.setTopic(this.parseType("topic", xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.setSubType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseContractSecurityLabelComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("offer")) {
            res.setOffer(this.parseContractOfferComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("asset")) {
            res.getAsset().add(this.parseContractAssetComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseContractActionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.getGroup().add(this.parseContractTermComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.SecurityLabelComponent parseContractSecurityLabelComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.SecurityLabelComponent res = new Contract.SecurityLabelComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractSecurityLabelComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractSecurityLabelComponentContent(int eventType, XmlPullParser xpp, Contract.SecurityLabelComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("number")) {
            res.getNumber().add(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classification")) {
            res.setClassification(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("control")) {
            res.getControl().add(this.parseCoding(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ContractOfferComponent parseContractOfferComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ContractOfferComponent res = new Contract.ContractOfferComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractOfferComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractOfferComponentContent(int eventType, XmlPullParser xpp, Contract.ContractOfferComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.getParty().add(this.parseContractPartyComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.setTopic(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decisionMode")) {
            res.getDecisionMode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("answer")) {
            res.getAnswer().add(this.parseContractAnswerComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("linkId")) {
            res.getLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabelNumber")) {
            res.getSecurityLabelNumber().add(this.parseUnsignedInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ContractPartyComponent parseContractPartyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ContractPartyComponent res = new Contract.ContractPartyComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractPartyComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractPartyComponentContent(int eventType, XmlPullParser xpp, Contract.ContractPartyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.getReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.AnswerComponent parseContractAnswerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.AnswerComponent res = new Contract.AnswerComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractAnswerComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractAnswerComponentContent(int eventType, XmlPullParser xpp, Contract.AnswerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ContractAssetComponent parseContractAssetComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ContractAssetComponent res = new Contract.ContractAssetComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractAssetComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractAssetComponentContent(int eventType, XmlPullParser xpp, Contract.ContractAssetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("scope")) {
            res.setScope(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("typeReference")) {
            res.getTypeReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtype")) {
            res.getSubtype().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.getContext().add(this.parseContractAssetContextComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setConditionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("periodType")) {
            res.getPeriodType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.getPeriod().add(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usePeriod")) {
            res.getUsePeriod().add(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("linkId")) {
            res.getLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("answer")) {
            res.getAnswer().add(this.parseContractAnswerComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabelNumber")) {
            res.getSecurityLabelNumber().add(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valuedItem")) {
            res.getValuedItem().add(this.parseContractValuedItemComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.AssetContextComponent parseContractAssetContextComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.AssetContextComponent res = new Contract.AssetContextComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractAssetContextComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractAssetContextComponentContent(int eventType, XmlPullParser xpp, Contract.AssetContextComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ValuedItemComponent parseContractValuedItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractValuedItemComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractValuedItemComponentContent(int eventType, XmlPullParser xpp, Contract.ValuedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "entity")) {
            res.setEntity(this.parseType("entity", xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectiveTime")) {
            res.setEffectiveTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("points")) {
            res.setPointsElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payment")) {
            res.setPaymentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("paymentDate")) {
            res.setPaymentDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsible")) {
            res.setResponsible(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.setRecipient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("linkId")) {
            res.getLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabelNumber")) {
            res.getSecurityLabelNumber().add(this.parseUnsignedInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ActionComponent parseContractActionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ActionComponent res = new Contract.ActionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractActionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractActionComponentContent(int eventType, XmlPullParser xpp, Contract.ActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseContractActionSubjectComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntent(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("linkId")) {
            res.getLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contextLinkId")) {
            res.getContextLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.getRequester().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requesterLinkId")) {
            res.getRequesterLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performerType")) {
            res.getPerformerType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performerRole")) {
            res.setPerformerRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performerLinkId")) {
            res.getPerformerLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonLinkId")) {
            res.getReasonLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabelNumber")) {
            res.getSecurityLabelNumber().add(this.parseUnsignedInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ActionSubjectComponent parseContractActionSubjectComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ActionSubjectComponent res = new Contract.ActionSubjectComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractActionSubjectComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractActionSubjectComponentContent(int eventType, XmlPullParser xpp, Contract.ActionSubjectComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.getReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.SignatoryComponent parseContractSignatoryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.SignatoryComponent res = new Contract.SignatoryComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractSignatoryComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractSignatoryComponentContent(int eventType, XmlPullParser xpp, Contract.SignatoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("signature")) {
            res.getSignature().add(this.parseSignature(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractFriendlyLanguageComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractFriendlyLanguageComponentContent(int eventType, XmlPullParser xpp, Contract.FriendlyLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractLegalLanguageComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractLegalLanguageComponentContent(int eventType, XmlPullParser xpp, Contract.LegalLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractComputableLanguageComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractComputableLanguageComponentContent(int eventType, XmlPullParser xpp, Contract.ComputableLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coverage parseCoverage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage res = new Coverage();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageContent(int eventType, XmlPullParser xpp, Coverage res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, Coverage.Kind.NULL, new Coverage.KindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("paymentBy")) {
            res.getPaymentBy().add(this.parseCoveragePaymentByComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("policyHolder")) {
            res.setPolicyHolder(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subscriber")) {
            res.setSubscriber(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subscriberId")) {
            res.getSubscriberId().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("beneficiary")) {
            res.setBeneficiary(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dependent")) {
            res.setDependentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("class")) {
            res.getClass_().add(this.parseCoverageClassComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("order")) {
            res.setOrderElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.setNetworkElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("costToBeneficiary")) {
            res.getCostToBeneficiary().add(this.parseCoverageCostToBeneficiaryComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subrogation")) {
            res.setSubrogationElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contract")) {
            res.getContract().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurancePlan")) {
            res.setInsurancePlan(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coverage.CoveragePaymentByComponent parseCoveragePaymentByComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage.CoveragePaymentByComponent res = new Coverage.CoveragePaymentByComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoveragePaymentByComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoveragePaymentByComponentContent(int eventType, XmlPullParser xpp, Coverage.CoveragePaymentByComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsibility")) {
            res.setResponsibilityElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coverage.ClassComponent parseCoverageClassComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage.ClassComponent res = new Coverage.ClassComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageClassComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageClassComponentContent(int eventType, XmlPullParser xpp, Coverage.ClassComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coverage.CostToBeneficiaryComponent parseCoverageCostToBeneficiaryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage.CostToBeneficiaryComponent res = new Coverage.CostToBeneficiaryComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageCostToBeneficiaryComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageCostToBeneficiaryComponentContent(int eventType, XmlPullParser xpp, Coverage.CostToBeneficiaryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.setNetwork(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnit(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("term")) {
            res.setTerm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("exception")) {
            res.getException().add(this.parseCoverageExemptionComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coverage.ExemptionComponent parseCoverageExemptionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage.ExemptionComponent res = new Coverage.ExemptionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageExemptionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageExemptionComponentContent(int eventType, XmlPullParser xpp, Coverage.ExemptionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityRequest parseCoverageEligibilityRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityRequest res = new CoverageEligibilityRequest();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityRequestContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.getPurpose().add(this.parseEnumeration(xpp, CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facility")) {
            res.setFacility(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseCoverageEligibilityRequestSupportingInformationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseCoverageEligibilityRequestInsuranceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseCoverageEligibilityRequestDetailsComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityRequest.SupportingInformationComponent parseCoverageEligibilityRequestSupportingInformationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityRequest.SupportingInformationComponent res = new CoverageEligibilityRequest.SupportingInformationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityRequestSupportingInformationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityRequestSupportingInformationComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("information")) {
            res.setInformation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appliesToAll")) {
            res.setAppliesToAllElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityRequest.InsuranceComponent parseCoverageEligibilityRequestInsuranceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityRequest.InsuranceComponent res = new CoverageEligibilityRequest.InsuranceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityRequestInsuranceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityRequestInsuranceComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("focal")) {
            res.setFocalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityRequest.DetailsComponent parseCoverageEligibilityRequestDetailsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityRequest.DetailsComponent res = new CoverageEligibilityRequest.DetailsComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityRequestDetailsComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityRequestDetailsComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest.DetailsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("supportingInfoSequence")) {
            res.getSupportingInfoSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facility")) {
            res.setFacility(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseCoverageEligibilityRequestDiagnosisComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityRequest.DiagnosisComponent parseCoverageEligibilityRequestDiagnosisComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityRequest.DiagnosisComponent res = new CoverageEligibilityRequest.DiagnosisComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityRequestDiagnosisComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityRequestDiagnosisComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "diagnosis")) {
            res.setDiagnosis(this.parseType("diagnosis", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityResponse parseCoverageEligibilityResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityResponse res = new CoverageEligibilityResponse();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityResponseContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.getPurpose().add(this.parseEnumeration(xpp, CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestor")) {
            res.setRequestor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(xpp, CoverageEligibilityResponse.EligibilityOutcome.NULL, new CoverageEligibilityResponse.EligibilityOutcomeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseCoverageEligibilityResponseInsuranceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.setPreAuthRefElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("error")) {
            res.getError().add(this.parseCoverageEligibilityResponseErrorsComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityResponse.InsuranceComponent parseCoverageEligibilityResponseInsuranceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityResponse.InsuranceComponent res = new CoverageEligibilityResponse.InsuranceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityResponseInsuranceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityResponseInsuranceComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("inforce")) {
            res.setInforceElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefitPeriod")) {
            res.setBenefitPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseCoverageEligibilityResponseItemsComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityResponse.ItemsComponent parseCoverageEligibilityResponseItemsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityResponse.ItemsComponent res = new CoverageEligibilityResponse.ItemsComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityResponseItemsComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityResponseItemsComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse.ItemsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excluded")) {
            res.setExcludedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.setNetwork(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnit(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("term")) {
            res.setTerm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefit")) {
            res.getBenefit().add(this.parseCoverageEligibilityResponseBenefitComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authorizationRequired")) {
            res.setAuthorizationRequiredElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authorizationSupporting")) {
            res.getAuthorizationSupporting().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authorizationUrl")) {
            res.setAuthorizationUrlElement(this.parseUri(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityResponse.BenefitComponent parseCoverageEligibilityResponseBenefitComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityResponse.BenefitComponent res = new CoverageEligibilityResponse.BenefitComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityResponseBenefitComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityResponseBenefitComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse.BenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "allowed")) {
            res.setAllowed(this.parseType("allowed", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "used")) {
            res.setUsed(this.parseType("used", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityResponse.ErrorsComponent parseCoverageEligibilityResponseErrorsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityResponse.ErrorsComponent res = new CoverageEligibilityResponse.ErrorsComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityResponseErrorsComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityResponseErrorsComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse.ErrorsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DetectedIssue parseDetectedIssue(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DetectedIssue res = new DetectedIssue();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDetectedIssueContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDetectedIssueContent(int eventType, XmlPullParser xpp, DetectedIssue res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, DetectedIssue.DetectedIssueStatus.NULL, new DetectedIssue.DetectedIssueStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverityElement(this.parseEnumeration(xpp, DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "identified")) {
            res.setIdentified(this.parseType("identified", xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("implicated")) {
            res.getImplicated().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("evidence")) {
            res.getEvidence().add(this.parseDetectedIssueEvidenceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.setDetailElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReferenceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mitigation")) {
            res.getMitigation().add(this.parseDetectedIssueMitigationComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DetectedIssue.DetectedIssueEvidenceComponent parseDetectedIssueEvidenceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueEvidenceComponent res = new DetectedIssue.DetectedIssueEvidenceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDetectedIssueEvidenceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDetectedIssueEvidenceComponentContent(int eventType, XmlPullParser xpp, DetectedIssue.DetectedIssueEvidenceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueMitigationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDetectedIssueMitigationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDetectedIssueMitigationComponentContent(int eventType, XmlPullParser xpp, DetectedIssue.DetectedIssueMitigationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("action")) {
            res.setAction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device parseDevice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Device res = new Device();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceContent(int eventType, XmlPullParser xpp, Device res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("displayName")) {
            res.setDisplayNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinition(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udiCarrier")) {
            res.getUdiCarrier().add(this.parseDeviceUdiCarrierComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("availabilityStatus")) {
            res.setAvailabilityStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("biologicalSourceEvent")) {
            res.setBiologicalSourceEvent(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.setManufacturerElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufactureDate")) {
            res.setManufactureDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lotNumber")) {
            res.setLotNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serialNumber")) {
            res.setSerialNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("deviceName")) {
            res.getDeviceName().add(this.parseDeviceDeviceNameComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modelNumber")) {
            res.setModelNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partNumber")) {
            res.setPartNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.getVersion().add(this.parseDeviceVersionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialization")) {
            res.getSpecialization().add(this.parseDeviceSpecializationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseDevicePropertyComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operation")) {
            res.getOperation().add(this.parseDeviceOperationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("association")) {
            res.getAssociation().add(this.parseDeviceAssociationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("owner")) {
            res.setOwner(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("gateway")) {
            res.getGateway().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("safety")) {
            res.getSafety().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.setParent(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DeviceUdiCarrierComponent parseDeviceUdiCarrierComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DeviceUdiCarrierComponent res = new Device.DeviceUdiCarrierComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceUdiCarrierComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceUdiCarrierComponentContent(int eventType, XmlPullParser xpp, Device.DeviceUdiCarrierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("deviceIdentifier")) {
            res.setDeviceIdentifierElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issuer")) {
            res.setIssuerElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.setJurisdictionElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("carrierAIDC")) {
            res.setCarrierAIDCElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("carrierHRF")) {
            res.setCarrierHRFElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entryType")) {
            res.setEntryTypeElement(this.parseEnumeration(xpp, Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DeviceDeviceNameComponent parseDeviceDeviceNameComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DeviceDeviceNameComponent res = new Device.DeviceDeviceNameComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDeviceNameComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDeviceNameComponentContent(int eventType, XmlPullParser xpp, Device.DeviceDeviceNameComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.DeviceNameType.NULL, new Enumerations.DeviceNameTypeEnumFactory()));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DeviceVersionComponent parseDeviceVersionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DeviceVersionComponent res = new Device.DeviceVersionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceVersionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceVersionComponentContent(int eventType, XmlPullParser xpp, Device.DeviceVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("component")) {
            res.setComponent(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("installDate")) {
            res.setInstallDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DeviceSpecializationComponent parseDeviceSpecializationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DeviceSpecializationComponent res = new Device.DeviceSpecializationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceSpecializationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceSpecializationComponentContent(int eventType, XmlPullParser xpp, Device.DeviceSpecializationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("systemType")) {
            res.setSystemType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCoding(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DevicePropertyComponent parseDevicePropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DevicePropertyComponent res = new Device.DevicePropertyComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDevicePropertyComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDevicePropertyComponentContent(int eventType, XmlPullParser xpp, Device.DevicePropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DeviceOperationComponent parseDeviceOperationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DeviceOperationComponent res = new Device.DeviceOperationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceOperationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceOperationComponentContent(int eventType, XmlPullParser xpp, Device.DeviceOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.getStatusReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operator")) {
            res.getOperator().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setMode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("cycle")) {
            res.setCycle(this.parseCount(xpp));
        } else if (eventType == 2 && xpp.getName().equals("duration")) {
            res.setDuration(this.parseDuration(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DeviceAssociationComponent parseDeviceAssociationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DeviceAssociationComponent res = new Device.DeviceAssociationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceAssociationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceAssociationComponentContent(int eventType, XmlPullParser xpp, Device.DeviceAssociationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.getStatusReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("humanSubject")) {
            res.setHumanSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodyStructure")) {
            res.setBodyStructure(this.parseCodeableReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition parseDeviceDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition res = new DeviceDefinition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionContent(int eventType, XmlPullParser xpp, DeviceDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udiDeviceIdentifier")) {
            res.getUdiDeviceIdentifier().add(this.parseDeviceDefinitionUdiDeviceIdentifierComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("regulatoryIdentifier")) {
            res.getRegulatoryIdentifier().add(this.parseDeviceDefinitionRegulatoryIdentifierComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partNumber")) {
            res.setPartNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.setManufacturer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("deviceName")) {
            res.getDeviceName().add(this.parseDeviceDefinitionDeviceNameComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modelNumber")) {
            res.setModelNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classification")) {
            res.getClassification().add(this.parseDeviceDefinitionClassificationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialization")) {
            res.getSpecialization().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hasPart")) {
            res.getHasPart().add(this.parseDeviceDefinitionHasPartComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("packaging")) {
            res.getPackaging().add(this.parseDeviceDefinitionPackagingComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.getVersion().add(this.parseDeviceDefinitionVersionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("safety")) {
            res.getSafety().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("shelfLifeStorage")) {
            res.getShelfLifeStorage().add(this.parseProductShelfLife(xpp));
        } else if (eventType == 2 && xpp.getName().equals("languageCode")) {
            res.getLanguageCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseDeviceDefinitionPropertyComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("owner")) {
            res.setOwner(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseDeviceDefinitionLinkComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parentDevice")) {
            res.setParentDevice(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("material")) {
            res.getMaterial().add(this.parseDeviceDefinitionMaterialComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productionIdentifierInUDI")) {
            res.getProductionIdentifierInUDI().add(this.parseEnumeration(xpp, DeviceDefinition.DeviceProductionIdentifierInUDI.NULL, new DeviceDefinition.DeviceProductionIdentifierInUDIEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("guideline")) {
            res.setGuideline(this.parseDeviceDefinitionGuidelineComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("correctiveAction")) {
            res.setCorrectiveAction(this.parseDeviceDefinitionCorrectiveActionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("chargeItem")) {
            res.getChargeItem().add(this.parseDeviceDefinitionChargeItemComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent parseDeviceDefinitionUdiDeviceIdentifierComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res = new DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionUdiDeviceIdentifierComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionUdiDeviceIdentifierComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("deviceIdentifier")) {
            res.setDeviceIdentifierElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issuer")) {
            res.setIssuerElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.setJurisdictionElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("marketDistribution")) {
            res.getMarketDistribution().add(this.parseDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent parseDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent res = new DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionUdiDeviceIdentifierMarketDistributionComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.UdiDeviceIdentifierMarketDistributionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("marketPeriod")) {
            res.setMarketPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subJurisdiction")) {
            res.setSubJurisdictionElement(this.parseUri(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent parseDeviceDefinitionRegulatoryIdentifierComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent res = new DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionRegulatoryIdentifierComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionRegulatoryIdentifierComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionRegulatoryIdentifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, DeviceDefinition.DeviceDefinitionRegulatoryIdentifierType.NULL, new DeviceDefinition.DeviceDefinitionRegulatoryIdentifierTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("deviceIdentifier")) {
            res.setDeviceIdentifierElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issuer")) {
            res.setIssuerElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.setJurisdictionElement(this.parseUri(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionDeviceNameComponent parseDeviceDefinitionDeviceNameComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionDeviceNameComponent res = new DeviceDefinition.DeviceDefinitionDeviceNameComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionDeviceNameComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionDeviceNameComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionDeviceNameComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.DeviceNameType.NULL, new Enumerations.DeviceNameTypeEnumFactory()));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionClassificationComponent parseDeviceDefinitionClassificationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionClassificationComponent res = new DeviceDefinition.DeviceDefinitionClassificationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionClassificationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionClassificationComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionClassificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("justification")) {
            res.getJustification().add(this.parseRelatedArtifact(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionHasPartComponent parseDeviceDefinitionHasPartComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionHasPartComponent res = new DeviceDefinition.DeviceDefinitionHasPartComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionHasPartComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionHasPartComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionHasPartComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCountElement(this.parseInteger(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionPackagingComponent parseDeviceDefinitionPackagingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionPackagingComponent res = new DeviceDefinition.DeviceDefinitionPackagingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionPackagingComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionPackagingComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionPackagingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCountElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("distributor")) {
            res.getDistributor().add(this.parseDeviceDefinitionPackagingDistributorComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udiDeviceIdentifier")) {
            res.getUdiDeviceIdentifier().add(this.parseDeviceDefinitionUdiDeviceIdentifierComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("packaging")) {
            res.getPackaging().add(this.parseDeviceDefinitionPackagingComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.PackagingDistributorComponent parseDeviceDefinitionPackagingDistributorComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.PackagingDistributorComponent res = new DeviceDefinition.PackagingDistributorComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionPackagingDistributorComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionPackagingDistributorComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.PackagingDistributorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organizationReference")) {
            res.getOrganizationReference().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionVersionComponent parseDeviceDefinitionVersionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionVersionComponent res = new DeviceDefinition.DeviceDefinitionVersionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionVersionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionVersionComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("component")) {
            res.setComponent(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionPropertyComponent parseDeviceDefinitionPropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionPropertyComponent res = new DeviceDefinition.DeviceDefinitionPropertyComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionPropertyComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionPropertyComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionLinkComponent parseDeviceDefinitionLinkComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionLinkComponent res = new DeviceDefinition.DeviceDefinitionLinkComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionLinkComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionLinkComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("relation")) {
            res.setRelation(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedDevice")) {
            res.setRelatedDevice(this.parseCodeableReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionMaterialComponent parseDeviceDefinitionMaterialComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionMaterialComponent res = new DeviceDefinition.DeviceDefinitionMaterialComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionMaterialComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionMaterialComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionMaterialComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("substance")) {
            res.setSubstance(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alternate")) {
            res.setAlternateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("allergenicIndicator")) {
            res.setAllergenicIndicatorElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionGuidelineComponent parseDeviceDefinitionGuidelineComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionGuidelineComponent res = new DeviceDefinition.DeviceDefinitionGuidelineComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionGuidelineComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionGuidelineComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionGuidelineComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usageInstruction")) {
            res.setUsageInstructionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("indication")) {
            res.getIndication().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contraindication")) {
            res.getContraindication().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("warning")) {
            res.getWarning().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intendedUse")) {
            res.setIntendedUseElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionCorrectiveActionComponent parseDeviceDefinitionCorrectiveActionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionCorrectiveActionComponent res = new DeviceDefinition.DeviceDefinitionCorrectiveActionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionCorrectiveActionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionCorrectiveActionComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionCorrectiveActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("recall")) {
            res.setRecallElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scope")) {
            res.setScopeElement(this.parseEnumeration(xpp, DeviceDefinition.DeviceCorrectiveActionScope.NULL, new DeviceDefinition.DeviceCorrectiveActionScopeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionChargeItemComponent parseDeviceDefinitionChargeItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionChargeItemComponent res = new DeviceDefinition.DeviceDefinitionChargeItemComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionChargeItemComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionChargeItemComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition.DeviceDefinitionChargeItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("chargeItemCode")) {
            res.setChargeItemCode(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCount(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDispense parseDeviceDispense(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDispense res = new DeviceDispense();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDispenseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDispenseContent(int eventType, XmlPullParser xpp, DeviceDispense res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, DeviceDispense.DeviceDispenseStatusCodes.NULL, new DeviceDispense.DeviceDispenseStatusCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.setDevice(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseDeviceDispensePerformerComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preparedDate")) {
            res.setPreparedDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("whenHandedOver")) {
            res.setWhenHandedOverElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("destination")) {
            res.setDestination(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usageInstruction")) {
            res.setUsageInstructionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("eventHistory")) {
            res.getEventHistory().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDispense.DeviceDispensePerformerComponent parseDeviceDispensePerformerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDispense.DeviceDispensePerformerComponent res = new DeviceDispense.DeviceDispensePerformerComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDispensePerformerComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDispensePerformerComponentContent(int eventType, XmlPullParser xpp, DeviceDispense.DeviceDispensePerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceMetric parseDeviceMetric(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceMetric res = new DeviceMetric();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceMetricContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceMetricContent(int eventType, XmlPullParser xpp, DeviceMetric res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnit(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.setParent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operationalStatus")) {
            res.setOperationalStatusElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("color")) {
            res.setColorElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategoryElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("measurementPeriod")) {
            res.setMeasurementPeriod(this.parseTiming(xpp));
        } else if (eventType == 2 && xpp.getName().equals("calibration")) {
            res.getCalibration().add(this.parseDeviceMetricCalibrationComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricCalibrationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceMetricCalibrationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceMetricCalibrationComponentContent(int eventType, XmlPullParser xpp, DeviceMetric.DeviceMetricCalibrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("state")) {
            res.setStateElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTimeElement(this.parseInstant(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceRequest parseDeviceRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceRequest res = new DeviceRequest();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceRequestContent(int eventType, XmlPullParser xpp, DeviceRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.getInstantiatesCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.getInstantiatesUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.RequestStatus.NULL, new Enumerations.RequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, Enumerations.RequestIntent.NULL, new Enumerations.RequestIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, Enumerations.RequestPriority.NULL, new Enumerations.RequestPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantityElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameter().add(this.parseDeviceRequestParameterComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.setRequester(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performerType")) {
            res.setPerformerType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("asNeeded")) {
            res.setAsNeededElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("asNeededFor")) {
            res.setAsNeededFor(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relevantHistory")) {
            res.getRelevantHistory().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceRequest.DeviceRequestParameterComponent parseDeviceRequestParameterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceRequest.DeviceRequestParameterComponent res = new DeviceRequest.DeviceRequestParameterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceRequestParameterComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceRequestParameterComponentContent(int eventType, XmlPullParser xpp, DeviceRequest.DeviceRequestParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceUsage parseDeviceUsage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceUsage res = new DeviceUsage();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceUsageContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceUsageContent(int eventType, XmlPullParser xpp, DeviceUsage res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, DeviceUsage.DeviceUsageStatus.NULL, new DeviceUsage.DeviceUsageStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("derivedFrom")) {
            res.getDerivedFrom().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateAsserted")) {
            res.setDateAssertedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usageStatus")) {
            res.setUsageStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usageReason")) {
            res.getUsageReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adherence")) {
            res.setAdherence(this.parseDeviceUsageAdherenceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("informationSource")) {
            res.setInformationSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.setDevice(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceUsage.DeviceUsageAdherenceComponent parseDeviceUsageAdherenceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceUsage.DeviceUsageAdherenceComponent res = new DeviceUsage.DeviceUsageAdherenceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceUsageAdherenceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceUsageAdherenceComponentContent(int eventType, XmlPullParser xpp, DeviceUsage.DeviceUsageAdherenceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DiagnosticReport parseDiagnosticReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticReport res = new DiagnosticReport();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDiagnosticReportContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDiagnosticReportContent(int eventType, XmlPullParser xpp, DiagnosticReport res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
            res.setEffective(this.parseType("effective", xpp));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resultsInterpreter")) {
            res.getResultsInterpreter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specimen")) {
            res.getSpecimen().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("result")) {
            res.getResult().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("study")) {
            res.getStudy().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseDiagnosticReportSupportingInfoComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("media")) {
            res.getMedia().add(this.parseDiagnosticReportMediaComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("composition")) {
            res.setComposition(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conclusion")) {
            res.setConclusionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conclusionCode")) {
            res.getConclusionCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("presentedForm")) {
            res.getPresentedForm().add(this.parseAttachment(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DiagnosticReport.DiagnosticReportSupportingInfoComponent parseDiagnosticReportSupportingInfoComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportSupportingInfoComponent res = new DiagnosticReport.DiagnosticReportSupportingInfoComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDiagnosticReportSupportingInfoComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDiagnosticReportSupportingInfoComponentContent(int eventType, XmlPullParser xpp, DiagnosticReport.DiagnosticReportSupportingInfoComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DiagnosticReport.DiagnosticReportMediaComponent parseDiagnosticReportMediaComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportMediaComponent res = new DiagnosticReport.DiagnosticReportMediaComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDiagnosticReportMediaComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDiagnosticReportMediaComponentContent(int eventType, XmlPullParser xpp, DiagnosticReport.DiagnosticReportMediaComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.setLink(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentManifest parseDocumentManifest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest res = new DocumentManifest();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentManifestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentManifestContent(int eventType, XmlPullParser xpp, DocumentManifest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("masterIdentifier")) {
            res.setMasterIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.getRecipient().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.getContent().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("related")) {
            res.getRelated().add(this.parseDocumentManifestRelatedComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestRelatedComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentManifestRelatedComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentManifestRelatedComponentContent(int eventType, XmlPullParser xpp, DocumentManifest.DocumentManifestRelatedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ref")) {
            res.setRef(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference parseDocumentReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference res = new DocumentReference();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceContent(int eventType, XmlPullParser xpp, DocumentReference res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("docStatus")) {
            res.setDocStatusElement(this.parseEnumeration(xpp, Enumerations.CompositionStatus.NULL, new Enumerations.CompositionStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.getContext().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("event")) {
            res.getEvent().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facilityType")) {
            res.setFacilityType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("practiceSetting")) {
            res.setPracticeSetting(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("attester")) {
            res.getAttester().add(this.parseDocumentReferenceAttesterComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("custodian")) {
            res.setCustodian(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatesTo")) {
            res.getRelatesTo().add(this.parseDocumentReferenceRelatesToComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.getContent().add(this.parseDocumentReferenceContentComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference.DocumentReferenceAttesterComponent parseDocumentReferenceAttesterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceAttesterComponent res = new DocumentReference.DocumentReferenceAttesterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceAttesterComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceAttesterComponentContent(int eventType, XmlPullParser xpp, DocumentReference.DocumentReferenceAttesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setMode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceRelatesToComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceRelatesToComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceRelatesToComponentContent(int eventType, XmlPullParser xpp, DocumentReference.DocumentReferenceRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceContentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceContentComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceContentComponentContent(int eventType, XmlPullParser xpp, DocumentReference.DocumentReferenceContentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("attachment")) {
            res.setAttachment(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseDocumentReferenceContentProfileComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference.DocumentReferenceContentProfileComponent parseDocumentReferenceContentProfileComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContentProfileComponent res = new DocumentReference.DocumentReferenceContentProfileComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceContentProfileComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceContentProfileComponentContent(int eventType, XmlPullParser xpp, DocumentReference.DocumentReferenceContentProfileComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter parseEncounter(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter res = new Encounter();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterContent(int eventType, XmlPullParser xpp, Encounter res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusHistory")) {
            res.getStatusHistory().add(this.parseEncounterStatusHistoryComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("class")) {
            res.getClass_().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classHistory")) {
            res.getClassHistory().add(this.parseEncounterClassHistoryComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceType")) {
            res.getServiceType().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subjectStatus")) {
            res.setSubjectStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("episodeOfCare")) {
            res.getEpisodeOfCare().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeam")) {
            res.getCareTeam().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.setPartOf(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceProvider")) {
            res.setServiceProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseEncounterParticipantComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appointment")) {
            res.getAppointment().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("virtualService")) {
            res.getVirtualService().add(this.parseVirtualServiceDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actualPeriod")) {
            res.setActualPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("plannedStartDate")) {
            res.setPlannedStartDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("plannedEndDate")) {
            res.setPlannedEndDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("length")) {
            res.setLength(this.parseDuration(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseEncounterDiagnosisComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.getAccount().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("admission")) {
            res.setAdmission(this.parseEncounterAdmissionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.getLocation().add(this.parseEncounterLocationComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.StatusHistoryComponent parseEncounterStatusHistoryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.StatusHistoryComponent res = new Encounter.StatusHistoryComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterStatusHistoryComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterStatusHistoryComponentContent(int eventType, XmlPullParser xpp, Encounter.StatusHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.ClassHistoryComponent parseEncounterClassHistoryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.ClassHistoryComponent res = new Encounter.ClassHistoryComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterClassHistoryComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterClassHistoryComponentContent(int eventType, XmlPullParser xpp, Encounter.ClassHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("class")) {
            res.setClass_(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.EncounterParticipantComponent parseEncounterParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterParticipantComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterParticipantComponentContent(int eventType, XmlPullParser xpp, Encounter.EncounterParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterDiagnosisComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterDiagnosisComponentContent(int eventType, XmlPullParser xpp, Encounter.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setCondition(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUse(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rank")) {
            res.setRankElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.EncounterAdmissionComponent parseEncounterAdmissionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterAdmissionComponent res = new Encounter.EncounterAdmissionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterAdmissionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterAdmissionComponentContent(int eventType, XmlPullParser xpp, Encounter.EncounterAdmissionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("preAdmissionIdentifier")) {
            res.setPreAdmissionIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("origin")) {
            res.setOrigin(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("admitSource")) {
            res.setAdmitSource(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reAdmission")) {
            res.setReAdmission(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dietPreference")) {
            res.getDietPreference().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialCourtesy")) {
            res.getSpecialCourtesy().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialArrangement")) {
            res.getSpecialArrangement().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("destination")) {
            res.setDestination(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dischargeDisposition")) {
            res.setDischargeDisposition(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.EncounterLocationComponent parseEncounterLocationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterLocationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterLocationComponentContent(int eventType, XmlPullParser xpp, Encounter.EncounterLocationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Endpoint parseEndpoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Endpoint res = new Endpoint();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEndpointContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEndpointContent(int eventType, XmlPullParser xpp, Endpoint res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("connectionType")) {
            res.getConnectionType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("environmentType")) {
            res.getEnvironmentType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payloadType")) {
            res.getPayloadType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payloadMimeType")) {
            res.getPayloadMimeType().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddressElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("header")) {
            res.getHeader().add(this.parseString(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EnrollmentRequest parseEnrollmentRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EnrollmentRequest res = new EnrollmentRequest();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEnrollmentRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEnrollmentRequestContent(int eventType, XmlPullParser xpp, EnrollmentRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("candidate")) {
            res.setCandidate(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EnrollmentResponse parseEnrollmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EnrollmentResponse res = new EnrollmentResponse();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEnrollmentResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEnrollmentResponseContent(int eventType, XmlPullParser xpp, EnrollmentResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.FinancialResourceStatusCodes.NULL, new Enumerations.FinancialResourceStatusCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(xpp, EnrollmentResponse.EnrollmentOutcome.NULL, new EnrollmentResponse.EnrollmentOutcomeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
            res.setRequestProvider(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EpisodeOfCare parseEpisodeOfCare(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare res = new EpisodeOfCare();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEpisodeOfCareContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEpisodeOfCareContent(int eventType, XmlPullParser xpp, EpisodeOfCare res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusHistory")) {
            res.getStatusHistory().add(this.parseEpisodeOfCareStatusHistoryComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseEpisodeOfCareDiagnosisComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referralRequest")) {
            res.getReferralRequest().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careManager")) {
            res.setCareManager(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeam")) {
            res.getCareTeam().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.getAccount().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareStatusHistoryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEpisodeOfCareStatusHistoryComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEpisodeOfCareStatusHistoryComponentContent(int eventType, XmlPullParser xpp, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEpisodeOfCareDiagnosisComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEpisodeOfCareDiagnosisComponentContent(int eventType, XmlPullParser xpp, EpisodeOfCare.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setCondition(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rank")) {
            res.setRankElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EventDefinition parseEventDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EventDefinition res = new EventDefinition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEventDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEventDefinitionContent(int eventType, XmlPullParser xpp, EventDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "subject")) {
            res.setSubject(this.parseType("subject", xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("trigger")) {
            res.getTrigger().add(this.parseTriggerDefinition(xpp));
        } else if (!this.parseMetadataResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Evidence parseEvidence(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Evidence res = new Evidence();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceContent(int eventType, XmlPullParser xpp, Evidence res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "citeAs")) {
            res.setCiteAs(this.parseType("citeAs", xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("assertion")) {
            res.setAssertionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("variableDefinition")) {
            res.getVariableDefinition().add(this.parseEvidenceVariableDefinitionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("synthesisType")) {
            res.setSynthesisType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("studyDesign")) {
            res.getStudyDesign().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statistic")) {
            res.getStatistic().add(this.parseEvidenceStatisticComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("certainty")) {
            res.getCertainty().add(this.parseEvidenceCertaintyComponent(xpp));
        } else if (!this.parseMetadataResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Evidence.EvidenceVariableDefinitionComponent parseEvidenceVariableDefinitionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Evidence.EvidenceVariableDefinitionComponent res = new Evidence.EvidenceVariableDefinitionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceVariableDefinitionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceVariableDefinitionComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceVariableDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("variableRole")) {
            res.setVariableRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("observed")) {
            res.setObserved(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intended")) {
            res.setIntended(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("directnessMatch")) {
            res.setDirectnessMatch(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Evidence.EvidenceStatisticComponent parseEvidenceStatisticComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Evidence.EvidenceStatisticComponent res = new Evidence.EvidenceStatisticComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceStatisticComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceStatisticComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceStatisticComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statisticType")) {
            res.setStatisticType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfEvents")) {
            res.setNumberOfEventsElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberAffected")) {
            res.setNumberAffectedElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sampleSize")) {
            res.setSampleSize(this.parseEvidenceStatisticSampleSizeComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("attributeEstimate")) {
            res.getAttributeEstimate().add(this.parseEvidenceStatisticAttributeEstimateComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modelCharacteristic")) {
            res.getModelCharacteristic().add(this.parseEvidenceStatisticModelCharacteristicComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Evidence.EvidenceStatisticSampleSizeComponent parseEvidenceStatisticSampleSizeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Evidence.EvidenceStatisticSampleSizeComponent res = new Evidence.EvidenceStatisticSampleSizeComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceStatisticSampleSizeComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceStatisticSampleSizeComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceStatisticSampleSizeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfStudies")) {
            res.setNumberOfStudiesElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfParticipants")) {
            res.setNumberOfParticipantsElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("knownDataCount")) {
            res.setKnownDataCountElement(this.parseUnsignedInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Evidence.EvidenceStatisticAttributeEstimateComponent parseEvidenceStatisticAttributeEstimateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Evidence.EvidenceStatisticAttributeEstimateComponent res = new Evidence.EvidenceStatisticAttributeEstimateComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceStatisticAttributeEstimateComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceStatisticAttributeEstimateComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceStatisticAttributeEstimateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("level")) {
            res.setLevelElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("range")) {
            res.setRange(this.parseRange(xpp));
        } else if (eventType == 2 && xpp.getName().equals("attributeEstimate")) {
            res.getAttributeEstimate().add(this.parseEvidenceStatisticAttributeEstimateComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Evidence.EvidenceStatisticModelCharacteristicComponent parseEvidenceStatisticModelCharacteristicComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Evidence.EvidenceStatisticModelCharacteristicComponent res = new Evidence.EvidenceStatisticModelCharacteristicComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceStatisticModelCharacteristicComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceStatisticModelCharacteristicComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceStatisticModelCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("variable")) {
            res.getVariable().add(this.parseEvidenceStatisticModelCharacteristicVariableComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("attributeEstimate")) {
            res.getAttributeEstimate().add(this.parseEvidenceStatisticAttributeEstimateComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Evidence.EvidenceStatisticModelCharacteristicVariableComponent parseEvidenceStatisticModelCharacteristicVariableComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Evidence.EvidenceStatisticModelCharacteristicVariableComponent res = new Evidence.EvidenceStatisticModelCharacteristicVariableComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceStatisticModelCharacteristicVariableComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceStatisticModelCharacteristicVariableComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceStatisticModelCharacteristicVariableComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("variableDefinition")) {
            res.setVariableDefinition(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("handling")) {
            res.setHandlingElement(this.parseEnumeration(xpp, Enumerations.EvidenceVariableHandling.NULL, new Enumerations.EvidenceVariableHandlingEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("valueCategory")) {
            res.getValueCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueQuantity")) {
            res.getValueQuantity().add(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueRange")) {
            res.getValueRange().add(this.parseRange(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Evidence.EvidenceCertaintyComponent parseEvidenceCertaintyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Evidence.EvidenceCertaintyComponent res = new Evidence.EvidenceCertaintyComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceCertaintyComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceCertaintyComponentContent(int eventType, XmlPullParser xpp, Evidence.EvidenceCertaintyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rating")) {
            res.setRating(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rater")) {
            res.setRaterElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subcomponent")) {
            res.getSubcomponent().add(this.parseEvidenceCertaintyComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceReport parseEvidenceReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceReport res = new EvidenceReport();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceReportContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceReportContent(int eventType, XmlPullParser xpp, EvidenceReport res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedIdentifier")) {
            res.getRelatedIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "citeAs")) {
            res.setCiteAs(this.parseType("citeAs", xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseEvidenceReportSubjectComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatesTo")) {
            res.getRelatesTo().add(this.parseEvidenceReportRelatesToComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("section")) {
            res.getSection().add(this.parseEvidenceReportSectionComponent(xpp));
        } else if (!this.parseMetadataResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceReport.EvidenceReportSubjectComponent parseEvidenceReportSubjectComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceReport.EvidenceReportSubjectComponent res = new EvidenceReport.EvidenceReportSubjectComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceReportSubjectComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceReportSubjectComponentContent(int eventType, XmlPullParser xpp, EvidenceReport.EvidenceReportSubjectComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("characteristic")) {
            res.getCharacteristic().add(this.parseEvidenceReportSubjectCharacteristicComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceReport.EvidenceReportSubjectCharacteristicComponent parseEvidenceReportSubjectCharacteristicComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceReport.EvidenceReportSubjectCharacteristicComponent res = new EvidenceReport.EvidenceReportSubjectCharacteristicComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceReportSubjectCharacteristicComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceReportSubjectCharacteristicComponentContent(int eventType, XmlPullParser xpp, EvidenceReport.EvidenceReportSubjectCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("exclude")) {
            res.setExcludeElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceReport.EvidenceReportRelatesToComponent parseEvidenceReportRelatesToComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceReport.EvidenceReportRelatesToComponent res = new EvidenceReport.EvidenceReportRelatesToComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceReportRelatesToComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceReportRelatesToComponentContent(int eventType, XmlPullParser xpp, EvidenceReport.EvidenceReportRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, EvidenceReport.ReportRelationshipType.NULL, new EvidenceReport.ReportRelationshipTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseEvidenceReportRelatesToTargetComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceReport.EvidenceReportRelatesToTargetComponent parseEvidenceReportRelatesToTargetComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceReport.EvidenceReportRelatesToTargetComponent res = new EvidenceReport.EvidenceReportRelatesToTargetComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceReportRelatesToTargetComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceReportRelatesToTargetComponentContent(int eventType, XmlPullParser xpp, EvidenceReport.EvidenceReportRelatesToTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceReport.SectionComponent parseEvidenceReportSectionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceReport.SectionComponent res = new EvidenceReport.SectionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceReportSectionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceReportSectionComponentContent(int eventType, XmlPullParser xpp, EvidenceReport.SectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focus")) {
            res.setFocus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focusReference")) {
            res.setFocusReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setText(this.parseNarrative(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entryClassifier")) {
            res.getEntryClassifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entryReference")) {
            res.getEntryReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entryQuantity")) {
            res.getEntryQuantity().add(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("section")) {
            res.getSection().add(this.parseEvidenceReportSectionComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceVariable parseEvidenceVariable(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceVariable res = new EvidenceVariable();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceVariableContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceVariableContent(int eventType, XmlPullParser xpp, EvidenceVariable res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("shortTitle")) {
            res.setShortTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actual")) {
            res.setActualElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
            res.getCharacteristic().add(this.parseEvidenceVariableCharacteristicComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("handling")) {
            res.setHandlingElement(this.parseEnumeration(xpp, Enumerations.EvidenceVariableHandling.NULL, new Enumerations.EvidenceVariableHandlingEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseEvidenceVariableCategoryComponent(xpp));
        } else if (!this.parseMetadataResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceVariable.EvidenceVariableCharacteristicComponent parseEvidenceVariableCharacteristicComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCharacteristicComponent res = new EvidenceVariable.EvidenceVariableCharacteristicComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceVariableCharacteristicComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceVariableCharacteristicComponentContent(int eventType, XmlPullParser xpp, EvidenceVariable.EvidenceVariableCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("linkId")) {
            res.setLinkIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("exclude")) {
            res.setExcludeElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definitionReference")) {
            res.setDefinitionReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definitionCanonical")) {
            res.setDefinitionCanonicalElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definitionCodeableConcept")) {
            res.setDefinitionCodeableConcept(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definitionExpression")) {
            res.setDefinitionExpression(this.parseExpression(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definitionId")) {
            res.setDefinitionIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definitionByTypeAndValue")) {
            res.setDefinitionByTypeAndValue(this.parseEvidenceVariableCharacteristicDefinitionByTypeAndValueComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definitionByCombination")) {
            res.setDefinitionByCombination(this.parseEvidenceVariableCharacteristicDefinitionByCombinationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("timeFromEvent")) {
            res.getTimeFromEvent().add(this.parseEvidenceVariableCharacteristicTimeFromEventComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent parseEvidenceVariableCharacteristicDefinitionByTypeAndValueComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent res = new EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceVariableCharacteristicDefinitionByTypeAndValueComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceVariableCharacteristicDefinitionByTypeAndValueComponentContent(int eventType, XmlPullParser xpp, EvidenceVariable.EvidenceVariableCharacteristicDefinitionByTypeAndValueComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("method")) {
            res.getMethod().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.setDevice(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("offset")) {
            res.setOffset(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent parseEvidenceVariableCharacteristicDefinitionByCombinationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent res = new EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceVariableCharacteristicDefinitionByCombinationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceVariableCharacteristicDefinitionByCombinationComponentContent(int eventType, XmlPullParser xpp, EvidenceVariable.EvidenceVariableCharacteristicDefinitionByCombinationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, EvidenceVariable.CharacteristicCombination.NULL, new EvidenceVariable.CharacteristicCombinationEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("threshold")) {
            res.setThresholdElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
            res.getCharacteristic().add(this.parseEvidenceVariableCharacteristicComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent parseEvidenceVariableCharacteristicTimeFromEventComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent res = new EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceVariableCharacteristicTimeFromEventComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceVariableCharacteristicTimeFromEventComponentContent(int eventType, XmlPullParser xpp, EvidenceVariable.EvidenceVariableCharacteristicTimeFromEventComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "event")) {
            res.setEvent(this.parseType("event", xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("range")) {
            res.setRange(this.parseRange(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceVariable.EvidenceVariableCategoryComponent parseEvidenceVariableCategoryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCategoryComponent res = new EvidenceVariable.EvidenceVariableCategoryComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceVariableCategoryComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceVariableCategoryComponentContent(int eventType, XmlPullParser xpp, EvidenceVariable.EvidenceVariableCategoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario parseExampleScenario(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario res = new ExampleScenario();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioContent(int eventType, XmlPullParser xpp, ExampleScenario res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "versionAlgorithm")) {
            res.setVersionAlgorithm(this.parseType("versionAlgorithm", xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.getActor().add(this.parseExampleScenarioActorComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instance")) {
            res.getInstance().add(this.parseExampleScenarioInstanceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("process")) {
            res.getProcess().add(this.parseExampleScenarioProcessComponent(xpp));
        } else if (!this.parseCanonicalResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioActorComponent parseExampleScenarioActorComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioActorComponent res = new ExampleScenario.ExampleScenarioActorComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioActorComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioActorComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioActorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("key")) {
            res.setKeyElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.ExampleScenarioActorType.NULL, new Enumerations.ExampleScenarioActorTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioInstanceComponent parseExampleScenarioInstanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioInstanceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioInstanceComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("key")) {
            res.setKeyElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("structureType")) {
            res.setStructureType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("structureVersion")) {
            res.setStructureVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "structureProfile")) {
            res.setStructureProfile(this.parseType("structureProfile", xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.setContent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.getVersion().add(this.parseExampleScenarioInstanceVersionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("containedInstance")) {
            res.getContainedInstance().add(this.parseExampleScenarioInstanceContainedInstanceComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioInstanceVersionComponent parseExampleScenarioInstanceVersionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioInstanceVersionComponent res = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioInstanceVersionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioInstanceVersionComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioInstanceVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("key")) {
            res.setKeyElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.setContent(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent parseExampleScenarioInstanceContainedInstanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioInstanceContainedInstanceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioInstanceContainedInstanceComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("instanceReference")) {
            res.setInstanceReferenceElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("versionReference")) {
            res.setVersionReferenceElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioProcessComponent parseExampleScenarioProcessComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessComponent res = new ExampleScenario.ExampleScenarioProcessComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioProcessComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioProcessComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioProcessComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preConditions")) {
            res.setPreConditionsElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("postConditions")) {
            res.setPostConditionsElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("step")) {
            res.getStep().add(this.parseExampleScenarioProcessStepComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioProcessStepComponent parseExampleScenarioProcessStepComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessStepComponent res = new ExampleScenario.ExampleScenarioProcessStepComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioProcessStepComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioProcessStepComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioProcessStepComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("process")) {
            res.setProcess(this.parseExampleScenarioProcessComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("workflow")) {
            res.setWorkflowElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operation")) {
            res.setOperation(this.parseExampleScenarioProcessStepOperationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alternative")) {
            res.getAlternative().add(this.parseExampleScenarioProcessStepAlternativeComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("pause")) {
            res.setPauseElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioProcessStepOperationComponent parseExampleScenarioProcessStepOperationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessStepOperationComponent res = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioProcessStepOperationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioProcessStepOperationComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioProcessStepOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("initiator")) {
            res.setInitiatorElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("receiver")) {
            res.setReceiverElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("initiatorActive")) {
            res.setInitiatorActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("receiverActive")) {
            res.setReceiverActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseExampleScenarioInstanceContainedInstanceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("response")) {
            res.setResponse(this.parseExampleScenarioInstanceContainedInstanceComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioProcessStepAlternativeComponent parseExampleScenarioProcessStepAlternativeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioProcessStepAlternativeComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioProcessStepAlternativeComponentContent(int eventType, XmlPullParser xpp, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("step")) {
            res.getStep().add(this.parseExampleScenarioProcessStepComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit parseExplanationOfBenefit(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit res = new ExplanationOfBenefit();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.setSubType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, Enumerations.Use.NULL, new Enumerations.UseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fundsReserveRequested")) {
            res.setFundsReserveRequested(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("related")) {
            res.getRelated().add(this.parseExplanationOfBenefitRelatedClaimComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prescription")) {
            res.setPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payee")) {
            res.setPayee(this.parseExplanationOfBenefitPayeeComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referral")) {
            res.setReferral(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.getEncounter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facility")) {
            res.setFacility(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("claim")) {
            res.setClaim(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
            res.setClaimResponse(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.ClaimProcessingCodes.NULL, new Enumerations.ClaimProcessingCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.getPreAuthRef().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRefPeriod")) {
            res.getPreAuthRefPeriod().add(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosisRelatedGroup")) {
            res.setDiagnosisRelatedGroup(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeam")) {
            res.getCareTeam().add(this.parseExplanationOfBenefitCareTeamComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseExplanationOfBenefitSupportingInformationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseExplanationOfBenefitDiagnosisComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedure")) {
            res.getProcedure().add(this.parseExplanationOfBenefitProcedureComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("precedence")) {
            res.setPrecedenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseExplanationOfBenefitInsuranceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("accident")) {
            res.setAccident(this.parseExplanationOfBenefitAccidentComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientPaid")) {
            res.setPatientPaid(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseExplanationOfBenefitItemComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("addItem")) {
            res.getAddItem().add(this.parseExplanationOfBenefitAddedItemComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("total")) {
            res.getTotal().add(this.parseExplanationOfBenefitTotalComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payment")) {
            res.setPayment(this.parseExplanationOfBenefitPaymentComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("formCode")) {
            res.setFormCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("processNote")) {
            res.getProcessNote().add(this.parseExplanationOfBenefitNoteComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefitPeriod")) {
            res.setBenefitPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefitBalance")) {
            res.getBenefitBalance().add(this.parseExplanationOfBenefitBenefitBalanceComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitRelatedClaimComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitRelatedClaimComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.RelatedClaimComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("claim")) {
            res.setClaim(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitPayeeComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitPayeeComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.PayeeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitCareTeamComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitCareTeamComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.CareTeamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsible")) {
            res.setResponsibleElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialty")) {
            res.setSpecialty(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitSupportingInformationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitSupportingInformationComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCoding(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitDiagnosisComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitDiagnosisComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "diagnosis")) {
            res.setDiagnosis(this.parseType("diagnosis", xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onAdmission")) {
            res.setOnAdmission(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitProcedureComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitProcedureComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.ProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "procedure")) {
            res.setProcedure(this.parseType("procedure", xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitInsuranceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitInsuranceComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("focal")) {
            res.setFocalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.getPreAuthRef().add(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAccidentComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAccidentComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.AccidentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitItemComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitItemComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeamSequence")) {
            res.getCareTeamSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosisSequence")) {
            res.getDiagnosisSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedureSequence")) {
            res.getProcedureSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("informationSequence")) {
            res.getInformationSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientPaid")) {
            res.setPatientPaid(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tax")) {
            res.setTax(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.getBodySite().add(this.parseExplanationOfBenefitItemBodySiteComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.getEncounter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseExplanationOfBenefitDetailComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.ItemBodySiteComponent parseExplanationOfBenefitItemBodySiteComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.ItemBodySiteComponent res = new ExplanationOfBenefit.ItemBodySiteComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitItemBodySiteComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitItemBodySiteComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.ItemBodySiteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("site")) {
            res.getSite().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subSite")) {
            res.getSubSite().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAdjudicationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAdjudicationComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.AdjudicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitDetailComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.DetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientPaid")) {
            res.setPatientPaid(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tax")) {
            res.setTax(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseExplanationOfBenefitSubDetailComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitSubDetailComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitSubDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientPaid")) {
            res.setPatientPaid(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tax")) {
            res.setTax(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAddedItemComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAddedItemComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.AddedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("itemSequence")) {
            res.getItemSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detailSequence")) {
            res.getDetailSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subDetailSequence")) {
            res.getSubDetailSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.getProvider().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientPaid")) {
            res.setPatientPaid(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tax")) {
            res.setTax(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.getBodySite().add(this.parseExplanationOfBenefitAddedItemBodySiteComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseExplanationOfBenefitAddedItemDetailComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AddedItemBodySiteComponent parseExplanationOfBenefitAddedItemBodySiteComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemBodySiteComponent res = new ExplanationOfBenefit.AddedItemBodySiteComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAddedItemBodySiteComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAddedItemBodySiteComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.AddedItemBodySiteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("site")) {
            res.getSite().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subSite")) {
            res.getSubSite().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AddedItemDetailComponent parseExplanationOfBenefitAddedItemDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemDetailComponent res = new ExplanationOfBenefit.AddedItemDetailComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAddedItemDetailComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAddedItemDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.AddedItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientPaid")) {
            res.setPatientPaid(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tax")) {
            res.setTax(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseExplanationOfBenefitAddedItemDetailSubDetailComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AddedItemDetailSubDetailComponent parseExplanationOfBenefitAddedItemDetailSubDetailComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemDetailSubDetailComponent res = new ExplanationOfBenefit.AddedItemDetailSubDetailComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAddedItemDetailSubDetailComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAddedItemDetailSubDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.AddedItemDetailSubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrServiceEnd")) {
            res.setProductOrServiceEnd(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientPaid")) {
            res.setPatientPaid(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tax")) {
            res.setTax(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.TotalComponent parseExplanationOfBenefitTotalComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.TotalComponent res = new ExplanationOfBenefit.TotalComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitTotalComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitTotalComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.TotalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitPaymentComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitPaymentComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.PaymentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjustment")) {
            res.setAdjustment(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjustmentReason")) {
            res.setAdjustmentReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitNoteComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitNoteComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.NoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitBenefitBalanceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitBenefitBalanceComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.BenefitBalanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excluded")) {
            res.setExcludedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.setNetwork(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnit(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("term")) {
            res.setTerm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("financial")) {
            res.getFinancial().add(this.parseExplanationOfBenefitBenefitComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitBenefitComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitBenefitComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit.BenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "allowed")) {
            res.setAllowed(this.parseType("allowed", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "used")) {
            res.setUsed(this.parseType("used", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected FamilyMemberHistory parseFamilyMemberHistory(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        FamilyMemberHistory res = new FamilyMemberHistory();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFamilyMemberHistoryContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFamilyMemberHistoryContent(int eventType, XmlPullParser xpp, FamilyMemberHistory res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.getInstantiatesCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.getInstantiatesUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("dataAbsentReason")) {
            res.setDataAbsentReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseFamilyMemberHistoryParticipantComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sex")) {
            res.setSex(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "born")) {
            res.setBorn(this.parseType("born", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "age")) {
            res.setAge(this.parseType("age", xpp));
        } else if (eventType == 2 && xpp.getName().equals("estimatedAge")) {
            res.setEstimatedAgeElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "deceased")) {
            res.setDeceased(this.parseType("deceased", xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.getCondition().add(this.parseFamilyMemberHistoryConditionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedure")) {
            res.getProcedure().add(this.parseFamilyMemberHistoryProcedureComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected FamilyMemberHistory.FamilyMemberHistoryParticipantComponent parseFamilyMemberHistoryParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        FamilyMemberHistory.FamilyMemberHistoryParticipantComponent res = new FamilyMemberHistory.FamilyMemberHistoryParticipantComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFamilyMemberHistoryParticipantComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFamilyMemberHistoryParticipantComponentContent(int eventType, XmlPullParser xpp, FamilyMemberHistory.FamilyMemberHistoryParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryConditionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFamilyMemberHistoryConditionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFamilyMemberHistoryConditionComponentContent(int eventType, XmlPullParser xpp, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributedToDeath")) {
            res.setContributedToDeathElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
            res.setOnset(this.parseType("onset", xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected FamilyMemberHistory.FamilyMemberHistoryProcedureComponent parseFamilyMemberHistoryProcedureComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        FamilyMemberHistory.FamilyMemberHistoryProcedureComponent res = new FamilyMemberHistory.FamilyMemberHistoryProcedureComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFamilyMemberHistoryProcedureComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFamilyMemberHistoryProcedureComponentContent(int eventType, XmlPullParser xpp, FamilyMemberHistory.FamilyMemberHistoryProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributedToDeath")) {
            res.setContributedToDeathElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "performed")) {
            res.setPerformed(this.parseType("performed", xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Flag parseFlag(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Flag res = new Flag();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFlagContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFlagContent(int eventType, XmlPullParser xpp, Flag res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected FormularyItem parseFormularyItem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        FormularyItem res = new FormularyItem();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFormularyItemContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFormularyItemContent(int eventType, XmlPullParser xpp, FormularyItem res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, FormularyItem.FormularyItemStatusCodes.NULL, new FormularyItem.FormularyItemStatusCodesEnumFactory()));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GenomicStudy parseGenomicStudy(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GenomicStudy res = new GenomicStudy();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGenomicStudyContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGenomicStudyContent(int eventType, XmlPullParser xpp, GenomicStudy res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("startDate")) {
            res.setStartDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referrer")) {
            res.setReferrer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interpreter")) {
            res.getInterpreter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.setInstantiatesCanonicalElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.setInstantiatesUriElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("analysis")) {
            res.getAnalysis().add(this.parseGenomicStudyAnalysisComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GenomicStudy.GenomicStudyAnalysisComponent parseGenomicStudyAnalysisComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GenomicStudy.GenomicStudyAnalysisComponent res = new GenomicStudy.GenomicStudyAnalysisComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGenomicStudyAnalysisComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGenomicStudyAnalysisComponentContent(int eventType, XmlPullParser xpp, GenomicStudy.GenomicStudyAnalysisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("methodType")) {
            res.getMethodType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("changeType")) {
            res.getChangeType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("genomeBuild")) {
            res.setGenomeBuild(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.setInstantiatesCanonicalElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.setInstantiatesUriElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specimen")) {
            res.getSpecimen().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("protocolPerformed")) {
            res.setProtocolPerformed(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("regionsStudied")) {
            res.getRegionsStudied().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("regionsCalled")) {
            res.getRegionsCalled().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("input")) {
            res.getInput().add(this.parseGenomicStudyAnalysisInputComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("output")) {
            res.getOutput().add(this.parseGenomicStudyAnalysisOutputComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseGenomicStudyAnalysisPerformerComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.getDevice().add(this.parseGenomicStudyAnalysisDeviceComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GenomicStudy.GenomicStudyAnalysisInputComponent parseGenomicStudyAnalysisInputComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GenomicStudy.GenomicStudyAnalysisInputComponent res = new GenomicStudy.GenomicStudyAnalysisInputComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGenomicStudyAnalysisInputComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGenomicStudyAnalysisInputComponentContent(int eventType, XmlPullParser xpp, GenomicStudy.GenomicStudyAnalysisInputComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("file")) {
            res.setFile(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "generatedBy")) {
            res.setGeneratedBy(this.parseType("generatedBy", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GenomicStudy.GenomicStudyAnalysisOutputComponent parseGenomicStudyAnalysisOutputComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GenomicStudy.GenomicStudyAnalysisOutputComponent res = new GenomicStudy.GenomicStudyAnalysisOutputComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGenomicStudyAnalysisOutputComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGenomicStudyAnalysisOutputComponentContent(int eventType, XmlPullParser xpp, GenomicStudy.GenomicStudyAnalysisOutputComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("file")) {
            res.setFile(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GenomicStudy.GenomicStudyAnalysisPerformerComponent parseGenomicStudyAnalysisPerformerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GenomicStudy.GenomicStudyAnalysisPerformerComponent res = new GenomicStudy.GenomicStudyAnalysisPerformerComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGenomicStudyAnalysisPerformerComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGenomicStudyAnalysisPerformerComponentContent(int eventType, XmlPullParser xpp, GenomicStudy.GenomicStudyAnalysisPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GenomicStudy.GenomicStudyAnalysisDeviceComponent parseGenomicStudyAnalysisDeviceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GenomicStudy.GenomicStudyAnalysisDeviceComponent res = new GenomicStudy.GenomicStudyAnalysisDeviceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGenomicStudyAnalysisDeviceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGenomicStudyAnalysisDeviceComponentContent(int eventType, XmlPullParser xpp, GenomicStudy.GenomicStudyAnalysisDeviceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("device")) {
            res.setDevice(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Goal parseGoal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Goal res = new Goal();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGoalContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGoalContent(int eventType, XmlPullParser xpp, Goal res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lifecycleStatus")) {
            res.setLifecycleStatusElement(this.parseEnumeration(xpp, Goal.GoalLifecycleStatus.NULL, new Goal.GoalLifecycleStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("achievementStatus")) {
            res.setAchievementStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("continuous")) {
            res.setContinuousElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescription(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "start")) {
            res.setStart(this.parseType("start", xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.getTarget().add(this.parseGoalTargetComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statusDate")) {
            res.setStatusDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReasonElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("addresses")) {
            res.getAddresses().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.getOutcome().add(this.parseCodeableReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Goal.GoalTargetComponent parseGoalTargetComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGoalTargetComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGoalTargetComponentContent(int eventType, XmlPullParser xpp, Goal.GoalTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("measure")) {
            res.setMeasure(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "detail")) {
            res.setDetail(this.parseType("detail", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "due")) {
            res.setDue(this.parseType("due", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GraphDefinition parseGraphDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GraphDefinition res = new GraphDefinition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGraphDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGraphDefinitionContent(int eventType, XmlPullParser xpp, GraphDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "versionAlgorithm")) {
            res.setVersionAlgorithm(this.parseType("versionAlgorithm", xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("node")) {
            res.getNode().add(this.parseGraphDefinitionNodeComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseGraphDefinitionLinkComponent(xpp));
        } else if (!this.parseCanonicalResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GraphDefinition.GraphDefinitionNodeComponent parseGraphDefinitionNodeComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionNodeComponent res = new GraphDefinition.GraphDefinitionNodeComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGraphDefinitionNodeComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGraphDefinitionNodeComponentContent(int eventType, XmlPullParser xpp, GraphDefinition.GraphDefinitionNodeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("nodeId")) {
            res.setNodeIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.AllResourceTypes.NULL, new Enumerations.AllResourceTypesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionLinkComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGraphDefinitionLinkComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGraphDefinitionLinkComponentContent(int eventType, XmlPullParser xpp, GraphDefinition.GraphDefinitionLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sourceId")) {
            res.setSourceIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sliceName")) {
            res.setSliceNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetId")) {
            res.setTargetIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("params")) {
            res.setParamsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("compartment")) {
            res.getCompartment().add(this.parseGraphDefinitionLinkCompartmentComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GraphDefinition.GraphDefinitionLinkCompartmentComponent parseGraphDefinitionLinkCompartmentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkCompartmentComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGraphDefinitionLinkCompartmentComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGraphDefinitionLinkCompartmentComponentContent(int eventType, XmlPullParser xpp, GraphDefinition.GraphDefinitionLinkCompartmentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, GraphDefinition.GraphCompartmentUse.NULL, new GraphDefinition.GraphCompartmentUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("rule")) {
            res.setRuleElement(this.parseEnumeration(xpp, GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, Enumerations.CompartmentType.NULL, new Enumerations.CompartmentTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Group parseGroup(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Group res = new Group();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGroupContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGroupContent(int eventType, XmlPullParser xpp, Group res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("membership")) {
            res.setMembershipElement(this.parseEnumeration(xpp, Group.GroupMembershipBasis.NULL, new Group.GroupMembershipBasisEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantityElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingEntity")) {
            res.setManagingEntity(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
            res.getCharacteristic().add(this.parseGroupCharacteristicComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("member")) {
            res.getMember().add(this.parseGroupMemberComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Group.GroupCharacteristicComponent parseGroupCharacteristicComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGroupCharacteristicComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGroupCharacteristicComponentContent(int eventType, XmlPullParser xpp, Group.GroupCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("exclude")) {
            res.setExcludeElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Group.GroupMemberComponent parseGroupMemberComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Group.GroupMemberComponent res = new Group.GroupMemberComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGroupMemberComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGroupMemberComponentContent(int eventType, XmlPullParser xpp, Group.GroupMemberComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("entity")) {
            res.setEntity(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("inactive")) {
            res.setInactiveElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GuidanceResponse parseGuidanceResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GuidanceResponse res = new GuidanceResponse();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGuidanceResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGuidanceResponseContent(int eventType, XmlPullParser xpp, GuidanceResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("requestIdentifier")) {
            res.setRequestIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "module")) {
            res.setModule(this.parseType("module", xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("occurrenceDateTime")) {
            res.setOccurrenceDateTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("evaluationMessage")) {
            res.getEvaluationMessage().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outputParameters")) {
            res.setOutputParameters(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("result")) {
            res.setResult(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataRequirement")) {
            res.getDataRequirement().add(this.parseDataRequirement(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected HealthcareService parseHealthcareService(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService res = new HealthcareService();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHealthcareServiceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHealthcareServiceContent(int eventType, XmlPullParser xpp, HealthcareService res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("providedBy")) {
            res.setProvidedBy(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("offeredIn")) {
            res.getOfferedIn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialty")) {
            res.getSpecialty().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.getLocation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("extraDetails")) {
            res.setExtraDetailsElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("photo")) {
            res.setPhoto(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseExtendedContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverageArea")) {
            res.getCoverageArea().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceProvisionCode")) {
            res.getServiceProvisionCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("eligibility")) {
            res.getEligibility().add(this.parseHealthcareServiceEligibilityComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("program")) {
            res.getProgram().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
            res.getCharacteristic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("communication")) {
            res.getCommunication().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referralMethod")) {
            res.getReferralMethod().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appointmentRequired")) {
            res.setAppointmentRequiredElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availability")) {
            res.getAvailability().add(this.parseAvailability(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected HealthcareService.HealthcareServiceEligibilityComponent parseHealthcareServiceEligibilityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceEligibilityComponent res = new HealthcareService.HealthcareServiceEligibilityComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHealthcareServiceEligibilityComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHealthcareServiceEligibilityComponentContent(int eventType, XmlPullParser xpp, HealthcareService.HealthcareServiceEligibilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingSelection parseImagingSelection(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingSelection res = new ImagingSelection();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingSelectionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingSelectionContent(int eventType, XmlPullParser xpp, ImagingSelection res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ImagingSelection.ImagingSelectionStatus.NULL, new ImagingSelection.ImagingSelectionStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseImagingSelectionPerformerComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("studyUid")) {
            res.setStudyUidElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("derivedFrom")) {
            res.getDerivedFrom().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("seriesUid")) {
            res.setSeriesUidElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("seriesNumber")) {
            res.setSeriesNumberElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("frameOfReferenceUid")) {
            res.setFrameOfReferenceUidElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focus")) {
            res.getFocus().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instance")) {
            res.getInstance().add(this.parseImagingSelectionInstanceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("imageRegion")) {
            res.getImageRegion().add(this.parseImagingSelectionImageRegion3DComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingSelection.ImagingSelectionPerformerComponent parseImagingSelectionPerformerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingSelection.ImagingSelectionPerformerComponent res = new ImagingSelection.ImagingSelectionPerformerComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingSelectionPerformerComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingSelectionPerformerComponentContent(int eventType, XmlPullParser xpp, ImagingSelection.ImagingSelectionPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingSelection.ImagingSelectionInstanceComponent parseImagingSelectionInstanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingSelection.ImagingSelectionInstanceComponent res = new ImagingSelection.ImagingSelectionInstanceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingSelectionInstanceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingSelectionInstanceComponentContent(int eventType, XmlPullParser xpp, ImagingSelection.ImagingSelectionInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUidElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sopClass")) {
            res.setSopClass(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subset")) {
            res.getSubset().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("imageRegion")) {
            res.getImageRegion().add(this.parseImagingSelectionImageRegion2DComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingSelection.ImageRegion2DComponent parseImagingSelectionImageRegion2DComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingSelection.ImageRegion2DComponent res = new ImagingSelection.ImageRegion2DComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingSelectionImageRegion2DComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingSelectionImageRegion2DComponentContent(int eventType, XmlPullParser xpp, ImagingSelection.ImageRegion2DComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("regionType")) {
            res.setRegionTypeElement(this.parseEnumeration(xpp, ImagingSelection.ImagingSelection2DGraphicType.NULL, new ImagingSelection.ImagingSelection2DGraphicTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("coordinate")) {
            res.getCoordinate().add(this.parseDecimal(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingSelection.ImageRegion3DComponent parseImagingSelectionImageRegion3DComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingSelection.ImageRegion3DComponent res = new ImagingSelection.ImageRegion3DComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingSelectionImageRegion3DComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingSelectionImageRegion3DComponentContent(int eventType, XmlPullParser xpp, ImagingSelection.ImageRegion3DComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("regionType")) {
            res.setRegionTypeElement(this.parseEnumeration(xpp, ImagingSelection.ImagingSelection3DGraphicType.NULL, new ImagingSelection.ImagingSelection3DGraphicTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("coordinate")) {
            res.getCoordinate().add(this.parseDecimal(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingStudy parseImagingStudy(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy res = new ImagingStudy();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingStudyContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingStudyContent(int eventType, XmlPullParser xpp, ImagingStudy res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ImagingStudy.ImagingStudyStatus.NULL, new ImagingStudy.ImagingStudyStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("modality")) {
            res.getModality().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("started")) {
            res.setStartedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referrer")) {
            res.setReferrer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interpreter")) {
            res.getInterpreter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfSeries")) {
            res.setNumberOfSeriesElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedure")) {
            res.getProcedure().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("series")) {
            res.getSeries().add(this.parseImagingStudySeriesComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudySeriesComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingStudySeriesComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingStudySeriesComponentContent(int eventType, XmlPullParser xpp, ImagingStudy.ImagingStudySeriesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUidElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modality")) {
            res.setModality(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("laterality")) {
            res.setLaterality(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specimen")) {
            res.getSpecimen().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("started")) {
            res.setStartedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseImagingStudySeriesPerformerComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instance")) {
            res.getInstance().add(this.parseImagingStudySeriesInstanceComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingStudy.ImagingStudySeriesPerformerComponent parseImagingStudySeriesPerformerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesPerformerComponent res = new ImagingStudy.ImagingStudySeriesPerformerComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingStudySeriesPerformerComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingStudySeriesPerformerComponentContent(int eventType, XmlPullParser xpp, ImagingStudy.ImagingStudySeriesPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudySeriesInstanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingStudySeriesInstanceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingStudySeriesInstanceComponentContent(int eventType, XmlPullParser xpp, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUidElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sopClass")) {
            res.setSopClass(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization parseImmunization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization res = new Immunization();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationContent(int eventType, XmlPullParser xpp, Immunization res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Immunization.ImmunizationStatusCodes.NULL, new Immunization.ImmunizationStatusCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("vaccineCode")) {
            res.setVaccineCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("administeredProduct")) {
            res.setAdministeredProduct(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.setManufacturer(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lotNumber")) {
            res.setLotNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
            res.setExpirationDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("primarySource")) {
            res.setPrimarySourceElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("informationSource")) {
            res.setInformationSource(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("site")) {
            res.setSite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("route")) {
            res.setRoute(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseQuantity")) {
            res.setDoseQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseImmunizationPerformerComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isSubpotent")) {
            res.setIsSubpotentElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subpotentReason")) {
            res.getSubpotentReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programEligibility")) {
            res.getProgramEligibility().add(this.parseImmunizationProgramEligibilityComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fundingSource")) {
            res.setFundingSource(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reaction")) {
            res.getReaction().add(this.parseImmunizationReactionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("protocolApplied")) {
            res.getProtocolApplied().add(this.parseImmunizationProtocolAppliedComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization.ImmunizationPerformerComponent parseImmunizationPerformerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationPerformerComponent res = new Immunization.ImmunizationPerformerComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationPerformerComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationPerformerComponentContent(int eventType, XmlPullParser xpp, Immunization.ImmunizationPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization.ImmunizationProgramEligibilityComponent parseImmunizationProgramEligibilityComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationProgramEligibilityComponent res = new Immunization.ImmunizationProgramEligibilityComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationProgramEligibilityComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationProgramEligibilityComponentContent(int eventType, XmlPullParser xpp, Immunization.ImmunizationProgramEligibilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("program")) {
            res.setProgram(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programStatus")) {
            res.setProgramStatus(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization.ImmunizationReactionComponent parseImmunizationReactionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationReactionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationReactionComponentContent(int eventType, XmlPullParser xpp, Immunization.ImmunizationReactionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manifestation")) {
            res.setManifestation(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reported")) {
            res.setReportedElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization.ImmunizationProtocolAppliedComponent parseImmunizationProtocolAppliedComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationProtocolAppliedComponent res = new Immunization.ImmunizationProtocolAppliedComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationProtocolAppliedComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationProtocolAppliedComponentContent(int eventType, XmlPullParser xpp, Immunization.ImmunizationProtocolAppliedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("series")) {
            res.setSeriesElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authority")) {
            res.setAuthority(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetDisease")) {
            res.getTargetDisease().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseNumber")) {
            res.setDoseNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("seriesDoses")) {
            res.setSeriesDosesElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImmunizationEvaluation parseImmunizationEvaluation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationEvaluation res = new ImmunizationEvaluation();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationEvaluationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationEvaluationContent(int eventType, XmlPullParser xpp, ImmunizationEvaluation res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ImmunizationEvaluation.ImmunizationEvaluationStatusCodes.NULL, new ImmunizationEvaluation.ImmunizationEvaluationStatusCodesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authority")) {
            res.setAuthority(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetDisease")) {
            res.setTargetDisease(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("immunizationEvent")) {
            res.setImmunizationEvent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseStatus")) {
            res.setDoseStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseStatusReason")) {
            res.getDoseStatusReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("series")) {
            res.setSeriesElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseNumber")) {
            res.setDoseNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("seriesDoses")) {
            res.setSeriesDosesElement(this.parseString(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImmunizationRecommendation parseImmunizationRecommendation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation res = new ImmunizationRecommendation();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationRecommendationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationRecommendationContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authority")) {
            res.setAuthority(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recommendation")) {
            res.getRecommendation().add(this.parseImmunizationRecommendationRecommendationComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationRecommendationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationRecommendationRecommendationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationRecommendationRecommendationComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("vaccineCode")) {
            res.getVaccineCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetDisease")) {
            res.getTargetDisease().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contraindicatedVaccineCode")) {
            res.getContraindicatedVaccineCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("forecastStatus")) {
            res.setForecastStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("forecastReason")) {
            res.getForecastReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateCriterion")) {
            res.getDateCriterion().add(this.parseImmunizationRecommendationRecommendationDateCriterionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("series")) {
            res.setSeriesElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseNumber")) {
            res.setDoseNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("seriesDoses")) {
            res.setSeriesDosesElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingImmunization")) {
            res.getSupportingImmunization().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingPatientInformation")) {
            res.getSupportingPatientInformation().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationRecommendationDateCriterionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationRecommendationRecommendationDateCriterionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationRecommendationRecommendationDateCriterionComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide parseImplementationGuide(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide res = new ImplementationGuide();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideContent(int eventType, XmlPullParser xpp, ImplementationGuide res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "versionAlgorithm")) {
            res.setVersionAlgorithm(this.parseType("versionAlgorithm", xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyrightLabel")) {
            res.setCopyrightLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("packageId")) {
            res.setPackageIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("license")) {
            res.setLicenseElement(this.parseEnumeration(xpp, ImplementationGuide.SPDXLicense.NULL, new ImplementationGuide.SPDXLicenseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
            res.getFhirVersion().add(this.parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("dependsOn")) {
            res.getDependsOn().add(this.parseImplementationGuideDependsOnComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("global")) {
            res.getGlobal().add(this.parseImplementationGuideGlobalComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinition(this.parseImplementationGuideDefinitionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manifest")) {
            res.setManifest(this.parseImplementationGuideManifestComponent(xpp));
        } else if (!this.parseCanonicalResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDependsOnComponent parseImplementationGuideDependsOnComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDependsOnComponent res = new ImplementationGuide.ImplementationGuideDependsOnComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideDependsOnComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideDependsOnComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDependsOnComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uri")) {
            res.setUriElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("packageId")) {
            res.setPackageIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReasonElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideGlobalComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideGlobalComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideGlobalComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideGlobalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDefinitionComponent parseImplementationGuideDefinitionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionComponent res = new ImplementationGuide.ImplementationGuideDefinitionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideDefinitionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideDefinitionComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("grouping")) {
            res.getGrouping().add(this.parseImplementationGuideDefinitionGroupingComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResource().add(this.parseImplementationGuideDefinitionResourceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("page")) {
            res.setPage(this.parseImplementationGuideDefinitionPageComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameter().add(this.parseImplementationGuideDefinitionParameterComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("template")) {
            res.getTemplate().add(this.parseImplementationGuideDefinitionTemplateComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDefinitionGroupingComponent parseImplementationGuideDefinitionGroupingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideDefinitionGroupingComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideDefinitionGroupingComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDefinitionResourceComponent parseImplementationGuideDefinitionResourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionResourceComponent res = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideDefinitionResourceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideDefinitionResourceComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDefinitionResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
            res.getFhirVersion().add(this.parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isExample")) {
            res.setIsExampleElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupingId")) {
            res.setGroupingIdElement(this.parseId(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDefinitionPageComponent parseImplementationGuideDefinitionPageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionPageComponent res = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideDefinitionPageComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideDefinitionPageComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDefinitionPageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "source")) {
            res.setSource(this.parseType("source", xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("generation")) {
            res.setGenerationElement(this.parseEnumeration(xpp, ImplementationGuide.GuidePageGeneration.NULL, new ImplementationGuide.GuidePageGenerationEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("page")) {
            res.getPage().add(this.parseImplementationGuideDefinitionPageComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDefinitionParameterComponent parseImplementationGuideDefinitionParameterComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionParameterComponent res = new ImplementationGuide.ImplementationGuideDefinitionParameterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideDefinitionParameterComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideDefinitionParameterComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDefinitionParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDefinitionTemplateComponent parseImplementationGuideDefinitionTemplateComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res = new ImplementationGuide.ImplementationGuideDefinitionTemplateComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideDefinitionTemplateComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideDefinitionTemplateComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scope")) {
            res.setScopeElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideManifestComponent parseImplementationGuideManifestComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideManifestComponent res = new ImplementationGuide.ImplementationGuideManifestComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideManifestComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideManifestComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ImplementationGuideManifestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("rendering")) {
            res.setRenderingElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResource().add(this.parseImplementationGuideManifestResourceComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("page")) {
            res.getPage().add(this.parseImplementationGuideManifestPageComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("image")) {
            res.getImage().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("other")) {
            res.getOther().add(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ManifestResourceComponent parseImplementationGuideManifestResourceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ManifestResourceComponent res = new ImplementationGuide.ManifestResourceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideManifestResourceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideManifestResourceComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ManifestResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isExample")) {
            res.setIsExampleElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relativePath")) {
            res.setRelativePathElement(this.parseUrl(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ManifestPageComponent parseImplementationGuideManifestPageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ManifestPageComponent res = new ImplementationGuide.ManifestPageComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideManifestPageComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideManifestPageComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide.ManifestPageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("anchor")) {
            res.getAnchor().add(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Ingredient parseIngredient(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Ingredient res = new Ingredient();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseIngredientContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseIngredientContent(int eventType, XmlPullParser xpp, Ingredient res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("for")) {
            res.getFor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("function")) {
            res.getFunction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.setGroup(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("allergenicIndicator")) {
            res.setAllergenicIndicatorElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.getManufacturer().add(this.parseIngredientManufacturerComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("substance")) {
            res.setSubstance(this.parseIngredientSubstanceComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Ingredient.IngredientManufacturerComponent parseIngredientManufacturerComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Ingredient.IngredientManufacturerComponent res = new Ingredient.IngredientManufacturerComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseIngredientManufacturerComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseIngredientManufacturerComponentContent(int eventType, XmlPullParser xpp, Ingredient.IngredientManufacturerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRoleElement(this.parseEnumeration(xpp, Ingredient.IngredientManufacturerRole.NULL, new Ingredient.IngredientManufacturerRoleEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.setManufacturer(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Ingredient.IngredientSubstanceComponent parseIngredientSubstanceComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Ingredient.IngredientSubstanceComponent res = new Ingredient.IngredientSubstanceComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseIngredientSubstanceComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseIngredientSubstanceComponentContent(int eventType, XmlPullParser xpp, Ingredient.IngredientSubstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("strength")) {
            res.getStrength().add(this.parseIngredientSubstanceStrengthComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Ingredient.IngredientSubstanceStrengthComponent parseIngredientSubstanceStrengthComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Ingredient.IngredientSubstanceStrengthComponent res = new Ingredient.IngredientSubstanceStrengthComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseIngredientSubstanceStrengthComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseIngredientSubstanceStrengthComponentContent(int eventType, XmlPullParser xpp, Ingredient.IngredientSubstanceStrengthComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "presentation")) {
            res.setPresentation(this.parseType("presentation", xpp));
        } else if (eventType == 2 && xpp.getName().equals("textPresentation")) {
            res.setTextPresentationElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "concentration")) {
            res.setConcentration(this.parseType("concentration", xpp));
        } else if (eventType == 2 && xpp.getName().equals("textConcentration")) {
            res.setTextConcentrationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basis")) {
            res.setBasis(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("measurementPoint")) {
            res.setMeasurementPointElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("country")) {
            res.getCountry().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceStrength")) {
            res.getReferenceStrength().add(this.parseIngredientSubstanceStrengthReferenceStrengthComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent parseIngredientSubstanceStrengthReferenceStrengthComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent res = new Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseIngredientSubstanceStrengthReferenceStrengthComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseIngredientSubstanceStrengthReferenceStrengthComponentContent(int eventType, XmlPullParser xpp, Ingredient.IngredientSubstanceStrengthReferenceStrengthComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("substance")) {
            res.setSubstance(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "strength")) {
            res.setStrength(this.parseType("strength", xpp));
        } else if (eventType == 2 && xpp.getName().equals("measurementPoint")) {
            res.setMeasurementPointElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("country")) {
            res.getCountry().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan parseInsurancePlan(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan res = new InsurancePlan();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanContent(int eventType, XmlPullParser xpp, InsurancePlan res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alias")) {
            res.getAlias().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ownedBy")) {
            res.setOwnedBy(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("administeredBy")) {
            res.setAdministeredBy(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverageArea")) {
            res.getCoverageArea().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseExtendedContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.getNetwork().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.getCoverage().add(this.parseInsurancePlanCoverageComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("plan")) {
            res.getPlan().add(this.parseInsurancePlanPlanComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.InsurancePlanCoverageComponent parseInsurancePlanCoverageComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.InsurancePlanCoverageComponent res = new InsurancePlan.InsurancePlanCoverageComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanCoverageComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanCoverageComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.InsurancePlanCoverageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.getNetwork().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefit")) {
            res.getBenefit().add(this.parseInsurancePlanCoverageBenefitComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.CoverageBenefitComponent parseInsurancePlanCoverageBenefitComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.CoverageBenefitComponent res = new InsurancePlan.CoverageBenefitComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanCoverageBenefitComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanCoverageBenefitComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.CoverageBenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requirement")) {
            res.setRequirementElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("limit")) {
            res.getLimit().add(this.parseInsurancePlanCoverageBenefitLimitComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.CoverageBenefitLimitComponent parseInsurancePlanCoverageBenefitLimitComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.CoverageBenefitLimitComponent res = new InsurancePlan.CoverageBenefitLimitComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanCoverageBenefitLimitComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanCoverageBenefitLimitComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.CoverageBenefitLimitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.InsurancePlanPlanComponent parseInsurancePlanPlanComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.InsurancePlanPlanComponent res = new InsurancePlan.InsurancePlanPlanComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanPlanComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanPlanComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.InsurancePlanPlanComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverageArea")) {
            res.getCoverageArea().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.getNetwork().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("generalCost")) {
            res.getGeneralCost().add(this.parseInsurancePlanPlanGeneralCostComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specificCost")) {
            res.getSpecificCost().add(this.parseInsurancePlanPlanSpecificCostComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.InsurancePlanPlanGeneralCostComponent parseInsurancePlanPlanGeneralCostComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.InsurancePlanPlanGeneralCostComponent res = new InsurancePlan.InsurancePlanPlanGeneralCostComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanPlanGeneralCostComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanPlanGeneralCostComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.InsurancePlanPlanGeneralCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupSize")) {
            res.setGroupSizeElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("cost")) {
            res.setCost(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.InsurancePlanPlanSpecificCostComponent parseInsurancePlanPlanSpecificCostComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.InsurancePlanPlanSpecificCostComponent res = new InsurancePlan.InsurancePlanPlanSpecificCostComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanPlanSpecificCostComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanPlanSpecificCostComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.InsurancePlanPlanSpecificCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefit")) {
            res.getBenefit().add(this.parseInsurancePlanPlanBenefitComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.PlanBenefitComponent parseInsurancePlanPlanBenefitComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.PlanBenefitComponent res = new InsurancePlan.PlanBenefitComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanPlanBenefitComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanPlanBenefitComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.PlanBenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("cost")) {
            res.getCost().add(this.parseInsurancePlanPlanBenefitCostComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.PlanBenefitCostComponent parseInsurancePlanPlanBenefitCostComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.PlanBenefitCostComponent res = new InsurancePlan.PlanBenefitCostComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanPlanBenefitCostComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanPlanBenefitCostComponentContent(int eventType, XmlPullParser xpp, InsurancePlan.PlanBenefitCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("applicability")) {
            res.setApplicability(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("qualifiers")) {
            res.getQualifiers().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseQuantity(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InventoryReport parseInventoryReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InventoryReport res = new InventoryReport();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInventoryReportContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInventoryReportContent(int eventType, XmlPullParser xpp, InventoryReport res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, InventoryReport.InventoryReportStatus.NULL, new InventoryReport.InventoryReportStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("countType")) {
            res.setCountTypeElement(this.parseEnumeration(xpp, InventoryReport.InventoryCountType.NULL, new InventoryReport.InventoryCountTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("operationType")) {
            res.setOperationType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operationTypeReason")) {
            res.setOperationTypeReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reportedDateTime")) {
            res.setReportedDateTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reporter")) {
            res.setReporter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reportingPeriod")) {
            res.setReportingPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("inventoryListing")) {
            res.getInventoryListing().add(this.parseInventoryReportInventoryListingComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.setNote(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InventoryReport.InventoryReportInventoryListingComponent parseInventoryReportInventoryListingComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InventoryReport.InventoryReportInventoryListingComponent res = new InventoryReport.InventoryReportInventoryListingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInventoryReportInventoryListingComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInventoryReportInventoryListingComponentContent(int eventType, XmlPullParser xpp, InventoryReport.InventoryReportInventoryListingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("itemStatus")) {
            res.setItemStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("countingDateTime")) {
            res.setCountingDateTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("items")) {
            res.getItems().add(this.parseInventoryReportInventoryListingItemsComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InventoryReport.InventoryReportInventoryListingItemsComponent parseInventoryReportInventoryListingItemsComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InventoryReport.InventoryReportInventoryListingItemsComponent res = new InventoryReport.InventoryReportInventoryListingItemsComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInventoryReportInventoryListingItemsComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInventoryReportInventoryListingItemsComponentContent(int eventType, XmlPullParser xpp, InventoryReport.InventoryReportInventoryListingItemsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.setItem(this.parseCodeableReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lot")) {
            res.setLotElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serial")) {
            res.setSerialElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expiry")) {
            res.setExpiryElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturingDate")) {
            res.setManufacturingDateElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Invoice parseInvoice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Invoice res = new Invoice();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInvoiceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInvoiceContent(int eventType, XmlPullParser xpp, Invoice res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Invoice.InvoiceStatus.NULL, new Invoice.InvoiceStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("cancelledReason")) {
            res.setCancelledReasonElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.setRecipient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("creation")) {
            res.setCreationElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "period")) {
            res.setPeriod(this.parseType("period", xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseInvoiceParticipantComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issuer")) {
            res.setIssuer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.setAccount(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lineItem")) {
            res.getLineItem().add(this.parseInvoiceLineItemComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("totalPriceComponent")) {
            res.getTotalPriceComponent().add(this.parseMonetaryComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("totalNet")) {
            res.setTotalNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("totalGross")) {
            res.setTotalGross(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("paymentTerms")) {
            res.setPaymentTermsElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Invoice.InvoiceParticipantComponent parseInvoiceParticipantComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Invoice.InvoiceParticipantComponent res = new Invoice.InvoiceParticipantComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInvoiceParticipantComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInvoiceParticipantComponentContent(int eventType, XmlPullParser xpp, Invoice.InvoiceParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Invoice.InvoiceLineItemComponent parseInvoiceLineItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Invoice.InvoiceLineItemComponent res = new Invoice.InvoiceLineItemComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInvoiceLineItemComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInvoiceLineItemComponentContent(int eventType, XmlPullParser xpp, Invoice.InvoiceLineItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "chargeItem")) {
            res.setChargeItem(this.parseType("chargeItem", xpp));
        } else if (eventType == 2 && xpp.getName().equals("priceComponent")) {
            res.getPriceComponent().add(this.parseMonetaryComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Library parseLibrary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Library res = new Library();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLibraryContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLibraryContent(int eventType, XmlPullParser xpp, Library res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "subject")) {
            res.setSubject(this.parseType("subject", xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameter().add(this.parseParameterDefinition(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataRequirement")) {
            res.getDataRequirement().add(this.parseDataRequirement(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.getContent().add(this.parseAttachment(xpp));
        } else if (!this.parseMetadataResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Linkage parseLinkage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Linkage res = new Linkage();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLinkageContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLinkageContent(int eventType, XmlPullParser xpp, Linkage res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseLinkageItemComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Linkage.LinkageItemComponent parseLinkageItemComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLinkageItemComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLinkageItemComponentContent(int eventType, XmlPullParser xpp, Linkage.LinkageItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ListResource parseListResource(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ListResource res = new ListResource();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseListResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseListResourceContent(int eventType, XmlPullParser xpp, ListResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, Enumerations.ListMode.NULL, new Enumerations.ListModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entry")) {
            res.getEntry().add(this.parseListResourceEntryComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ListResource.ListResourceEntryComponent parseListResourceEntryComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ListResource.ListResourceEntryComponent res = new ListResource.ListResourceEntryComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseListResourceEntryComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseListResourceEntryComponentContent(int eventType, XmlPullParser xpp, ListResource.ListResourceEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("flag")) {
            res.setFlag(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("deleted")) {
            res.setDeletedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.setItem(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Location parseLocation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Location res = new Location();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLocationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLocationContent(int eventType, XmlPullParser xpp, Location res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("operationalStatus")) {
            res.setOperationalStatus(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alias")) {
            res.getAlias().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseExtendedContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddress(this.parseAddress(xpp));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("position")) {
            res.setPosition(this.parseLocationPositionComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.setPartOf(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
            res.getCharacteristic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hoursOfOperation")) {
            res.getHoursOfOperation().add(this.parseAvailability(xpp));
        } else if (eventType == 2 && xpp.getName().equals("virtualService")) {
            res.getVirtualService().add(this.parseVirtualServiceDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Location.LocationPositionComponent parseLocationPositionComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Location.LocationPositionComponent res = new Location.LocationPositionComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLocationPositionComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLocationPositionComponentContent(int eventType, XmlPullParser xpp, Location.LocationPositionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("longitude")) {
            res.setLongitudeElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("latitude")) {
            res.setLatitudeElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("altitude")) {
            res.setAltitudeElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ManufacturedItemDefinition parseManufacturedItemDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ManufacturedItemDefinition res = new ManufacturedItemDefinition();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseManufacturedItemDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseManufacturedItemDefinitionContent(int eventType, XmlPullParser xpp, ManufacturedItemDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturedDoseForm")) {
            res.setManufacturedDoseForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitOfPresentation")) {
            res.setUnitOfPresentation(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.getManufacturer().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("marketingStatus")) {
            res.getMarketingStatus().add(this.parseMarketingStatus(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ingredient")) {
            res.getIngredient().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseManufacturedItemDefinitionPropertyComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("component")) {
            res.getComponent().add(this.parseManufacturedItemDefinitionComponentComponent(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ManufacturedItemDefinition.ManufacturedItemDefinitionPropertyComponent parseManufacturedItemDefinitionPropertyComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ManufacturedItemDefinition.ManufacturedItemDefinitionPropertyComponent res = new ManufacturedItemDefinition.ManufacturedItemDefinitionPropertyComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseManufacturedItemDefinitionPropertyComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseManufacturedItemDefinitionPropertyComponentContent(int eventType, XmlPullParser xpp, ManufacturedItemDefinition.ManufacturedItemDefinitionPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ManufacturedItemDefinition.ManufacturedItemDefinitionComponentComponent parseManufacturedItemDefinitionComponentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ManufacturedItemDefinition.ManufacturedItemDefinitionComponentComponent res = new ManufacturedItemDefinition.ManufacturedItemDefinitionComponentComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseManufacturedItemDefinitionComponentComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseManufacturedItemDefinitionComponentComponentContent(int eventType, XmlPullParser xpp, ManufacturedItemDefinition.ManufacturedItemDefinitionComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("function")) {
            res.getFunction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.getAmount().add(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("constituent")) {
            res.getConstituent().add(this.parseManufacturedItemDefinitionComponentConstituentComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseManufacturedItemDefinitionPropertyComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("component")) {
            res.getComponent().add(this.parseManufacturedItemDefinitionComponentComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ManufacturedItemDefinition.ManufacturedItemDefinitionComponentConstituentComponent parseManufacturedItemDefinitionComponentConstituentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ManufacturedItemDefinition.ManufacturedItemDefinitionComponentConstituentComponent res = new ManufacturedItemDefinition.ManufacturedItemDefinitionComponentConstituentComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseManufacturedItemDefinitionComponentConstituentComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseManufacturedItemDefinitionComponentConstituentComponentContent(int eventType, XmlPullParser xpp, ManufacturedItemDefinition.ManufacturedItemDefinitionComponentConstituentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("amount")) {
            res.getAmount().add(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.getLocation().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("function")) {
            res.getFunction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hasIngredient")) {
            res.getHasIngredient().add(this.parseCodeableReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure parseMeasure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure res = new Measure();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureContent(int eventType, XmlPullParser xpp, Measure res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "subject")) {
            res.setSubject(this.parseType("subject", xpp));
        } else if (eventType == 2 && xpp.getName().equals("basis")) {
            res.setBasisElement(this.parseEnumeration(xpp, Enumerations.FHIRTypes.NULL, new Enumerations.FHIRTypesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("library")) {
            res.getLibrary().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("disclaimer")) {
            res.setDisclaimerElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scoring")) {
            res.setScoring(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scoringUnit")) {
            res.setScoringUnit(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("compositeScoring")) {
            res.setCompositeScoring(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("riskAdjustment")) {
            res.setRiskAdjustmentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rateAggregation")) {
            res.setRateAggregationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rationale")) {
            res.setRationaleElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("clinicalRecommendationStatement")) {
            res.setClinicalRecommendationStatementElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("improvementNotation")) {
            res.setImprovementNotation(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("term")) {
            res.getTerm().add(this.parseMeasureTermComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("guidance")) {
            res.setGuidanceElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.getGroup().add(this.parseMeasureGroupComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supplementalData")) {
            res.getSupplementalData().add(this.parseMeasureSupplementalDataComponent(xpp));
        } else if (!this.parseMetadataResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureTermComponent parseMeasureTermComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureTermComponent res = new Measure.MeasureTermComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureTermComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureTermComponentContent(int eventType, XmlPullParser xpp, Measure.MeasureTermComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureGroupComponent parseMeasureGroupComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureGroupComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureGroupComponentContent(int eventType, XmlPullParser xpp, Measure.MeasureGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basis")) {
            res.setBasisElement(this.parseEnumeration(xpp, Enumerations.FHIRTypes.NULL, new Enumerations.FHIRTypesEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("scoring")) {
            res.setScoring(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scoringUnit")) {
            res.setScoringUnit(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("improvementNotation")) {
            res.setImprovementNotation(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("population")) {
            res.getPopulation().add(this.parseMeasureGroupPopulationComponent(xpp));
        } else if (eventType == 2 && xpp.getName().equals("stratifier")) {
            res.getStratifier().add(this.parseMeasureGroupStratifierComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureGroupPopulationComponent parseMeasureGroupPopulationComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureGroupPopulationComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureGroupPopulationComponentContent(int eventType, XmlPullParser xpp, Measure.MeasureGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("criteria")) {
            res.setCriteria(this.parseExpression(xpp));
        } else if (eventType == 2 && xpp.getName().equals("inputPopulationId")) {
            res.setInputPopulationIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("aggregateMethod")) {
            res.setAggregateMethod(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureGroupStratifierComponent parseMeasureGroupStratifierComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureGroupStratifierComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureGroupStratifierComponentContent(int eventType, XmlPullParser xpp, Measure.MeasureGroupStratifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("criteria")) {
            res.setCriteria(this.parseExpression(xpp));
        } else if (eventType == 2 && xpp.getName().equals("component")) {
            res.getComponent().add(this.parseMeasureGroupStratifierComponentComponent(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureGroupStratifierComponentComponent parseMeasureGroupStratifierComponentComponent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupStratifierComponentComponent res = new Measure.MeasureGroupStratifierComponentComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureGroupStratifierComponentComponentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureGroupStratifierComponentComponentContent(int eventType, XmlPullParser xpp, Measure.MeasureGroupStratifierC