/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.spreadsheets;

import org.apache.poi.ss.usermodel.Sheet;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.renderers.spreadsheets.CanonicalSpreadsheetGenerator;

public class ConceptMapSpreadsheetGenerator
extends CanonicalSpreadsheetGenerator {
    public ConceptMapSpreadsheetGenerator(IWorkerContext context) {
        super(context);
    }

    public boolean canGenerate(ConceptMap cm) {
        return true;
    }

    public ConceptMapSpreadsheetGenerator renderConceptMap(ConceptMap cm) {
        this.addConceptMapMetadata(this.renderCanonicalResource(cm), cm);
        int i = 0;
        for (ConceptMap.ConceptMapGroupComponent grp : cm.getGroup()) {
            this.renderGroup(grp, i);
            ++i;
        }
        return this;
    }

    private void addConceptMapMetadata(Sheet sheet, ConceptMap cm) {
        if (cm.hasSourceScope()) {
            this.addMetadataRow(sheet, "Source", cm.getSourceScope().primitiveValue());
        }
        if (cm.hasTargetScope()) {
            this.addMetadataRow(sheet, "Target", cm.getTargetScope().primitiveValue());
        }
    }

    private void renderGroup(ConceptMap.ConceptMapGroupComponent grp, int i) {
        Sheet sheet = this.makeSheet("Mapping Table " + Integer.toString(i));
        this.addHeaders(sheet, "Source", "Display", "Relationship", "Target", "Display");
        this.addRow(sheet, grp.getSource(), "", "", grp.getTarget(), "");
        for (ConceptMap.SourceElementComponent s : grp.getElement()) {
            for (ConceptMap.TargetElementComponent t : s.getTarget()) {
                this.addRow(sheet, s.getCode(), s.getDisplay(), t.getRelationshipElement().asStringValue(), t.getCode(), t.getDisplay());
            }
        }
    }
}

