/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Narrative;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.renderers.DataRenderer;
import org.hl7.fhir.r5.renderers.ProfileDrivenRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.DirectWrappers;
import org.hl7.fhir.r5.renderers.utils.ElementWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public abstract class ResourceRenderer
extends DataRenderer {
    protected Resolver.ResourceContext rcontext;
    protected XVerExtensionManager xverManager;
    protected boolean forResource;

    public ResourceRenderer(RenderingContext context) {
        super(context);
    }

    public ResourceRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context);
        this.rcontext = rcontext;
    }

    public XhtmlNode build(Resource dr) throws FHIRFormatError, DefinitionException, FHIRException, IOException, EOperationOutcome {
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        this.render(x, dr);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(DomainResource r) throws IOException, FHIRException, EOperationOutcome {
        boolean hasExtensions;
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean ofr = this.forResource;
        try {
            this.forResource = true;
            hasExtensions = this.render(x, r);
        }
        finally {
            this.forResource = ofr;
        }
        ResourceRenderer.inject(r, x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
    }

    public XhtmlNode render(BaseWrappers.ResourceWrapper r) throws IOException, FHIRException, EOperationOutcome {
        assert (r.getContext() == this.context);
        XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
        boolean hasExtensions = this.render(x, r);
        if (r.hasNarrative()) {
            r.injectNarrative(x, hasExtensions ? Narrative.NarrativeStatus.EXTENSIONS : Narrative.NarrativeStatus.GENERATED);
        }
        return x;
    }

    public abstract boolean render(XhtmlNode var1, Resource var2) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome;

    public boolean render(XhtmlNode x, BaseWrappers.ResourceWrapper r) throws FHIRFormatError, DefinitionException, IOException, FHIRException, EOperationOutcome {
        ProfileDrivenRenderer pr = new ProfileDrivenRenderer(this.context);
        return pr.render(x, r);
    }

    public void describe(XhtmlNode x, Resource r) throws UnsupportedEncodingException, IOException {
        x.tx(this.display(r));
    }

    public void describe(XhtmlNode x, BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        x.tx(this.display(r));
    }

    public abstract String display(Resource var1) throws UnsupportedEncodingException, IOException;

    public abstract String display(BaseWrappers.ResourceWrapper var1) throws UnsupportedEncodingException, IOException;

    public static void inject(DomainResource r, XhtmlNode x, Narrative.NarrativeStatus status) {
        if (!x.hasAttribute("xmlns")) {
            x.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        }
        if (r.hasLanguage()) {
            x.setAttribute("lang", r.getLanguage());
            x.setAttribute("xml:lang", r.getLanguage());
        }
        r.getText().setUserData("renderer.generated", true);
        if (!r.hasText() || !r.getText().hasDiv() || r.getText().getDiv().getChildNodes().isEmpty()) {
            r.setText(new Narrative());
            r.getText().setDiv(x);
            r.getText().setStatus(status);
        } else {
            XhtmlNode n = r.getText().getDiv();
            n.clear();
            n.getChildNodes().addAll(x.getChildNodes());
        }
    }

    public void renderCanonical(Resource res, XhtmlNode x, String url) throws UnsupportedEncodingException, IOException {
        DirectWrappers.ResourceWrapperDirect rw = new DirectWrappers.ResourceWrapperDirect(this.context, res);
        this.renderCanonical(rw, x, url);
    }

    public void renderCanonical(BaseWrappers.ResourceWrapper rw, XhtmlNode x, String url) throws UnsupportedEncodingException, IOException {
        this.renderCanonical(rw, x, url, true);
    }

    public void renderCanonical(BaseWrappers.ResourceWrapper rw, XhtmlNode x, String url, boolean allowLinks) throws UnsupportedEncodingException, IOException {
        if (url == null) {
            return;
        }
        Resource target = this.context.getWorker().fetchResource(Resource.class, url);
        if (target == null || !(target instanceof CanonicalResource)) {
            x.code().tx(url);
        } else {
            CanonicalResource cr = (CanonicalResource)target;
            if (url.contains("|")) {
                if (target.hasUserData("path")) {
                    x.ah(target.getUserString("path")).tx(cr.present() + " (version " + cr.getVersion() + ")");
                } else {
                    url = url.substring(0, url.indexOf("|"));
                    x.code().tx(url);
                    x.tx(": " + cr.present() + " (version " + cr.getVersion() + ")");
                }
            } else if (target.hasUserData("path")) {
                x.ah(target.getUserString("path")).tx(cr.present());
            } else {
                x.code().tx(url);
                x.tx(" (" + cr.present() + ")");
            }
        }
    }

    public void render(Resource res, XhtmlNode x, DataType type) throws FHIRFormatError, DefinitionException, IOException {
        if (type instanceof Reference) {
            this.renderReference(res, x, (Reference)type);
        } else if (type instanceof CodeableReference) {
            CodeableReference cr = (CodeableReference)type;
            if (cr.hasReference()) {
                this.renderReference(res, x, cr.getReference());
            } else {
                this.render(x, type);
            }
        } else {
            this.render(x, type);
        }
    }

    public void render(BaseWrappers.ResourceWrapper res, XhtmlNode x, DataType type) throws FHIRFormatError, DefinitionException, IOException {
        if (type instanceof Reference) {
            this.renderReference(res, x, (Reference)type);
        } else if (type instanceof CodeableReference) {
            CodeableReference cr = (CodeableReference)type;
            if (cr.hasReference()) {
                this.renderReference(res, x, cr.getReference());
            } else {
                this.render(x, type);
            }
        } else {
            this.render(x, type);
        }
    }

    public void renderReference(Resource res, XhtmlNode x, Reference r) throws UnsupportedEncodingException, IOException {
        DirectWrappers.ResourceWrapperDirect rw = new DirectWrappers.ResourceWrapperDirect(this.context, res);
        this.renderReference((BaseWrappers.ResourceWrapper)rw, x, r);
    }

    public void renderReference(BaseWrappers.ResourceWrapper rw, XhtmlNode x, Reference r) throws UnsupportedEncodingException, IOException {
        this.renderReference(rw, x, r, true);
    }

    public void renderReference(BaseWrappers.ResourceWrapper rw, XhtmlNode x, Reference r, boolean allowLinks) throws UnsupportedEncodingException, IOException {
        String name;
        if (r == null) {
            x.tx("null!");
            return;
        }
        XhtmlNode c = null;
        Resolver.ResourceWithReference tr = null;
        if (r.hasReferenceElement() && allowLinks) {
            tr = this.resolveReference(rw, r.getReference());
            c = !r.getReference().startsWith("#") ? (tr != null && tr.getReference() != null ? x.ah(tr.getReference()) : x.ah(r.getReference())) : x.ah(r.getReference());
        } else {
            c = x.span(null, null);
        }
        if (tr != null && tr.getReference() != null && tr.getReference().startsWith("#")) {
            c.tx("See above (");
        }
        String display = r.hasDisplayElement() ? r.getDisplay() : null;
        String string = name = tr != null && tr.getResource() != null ? tr.getResource().getNameFromResource() : null;
        if (display == null && (tr == null || tr.getResource() == null)) {
            c.addText(r.getReference());
        } else if (this.context.isTechnicalMode()) {
            c.addText(r.getReference());
            if (display != null) {
                c.addText(": " + display);
            }
            if (!(tr != null && tr.getReference().startsWith("#") || name == null)) {
                x.addText(" \"" + name + "\"");
            }
            if (r.hasExtension("http://hl7.org/fhir/StructureDefinition/targetElement")) {
                x.addText("(#" + r.getExtensionString("http://hl7.org/fhir/StructureDefinition/targetElement") + ")");
            } else if (r.hasExtension("http://hl7.org/fhir/StructureDefinition/targetPath")) {
                x.addText("(#/" + r.getExtensionString("http://hl7.org/fhir/StructureDefinition/targetPath") + ")");
            }
        } else if (display != null) {
            c.addText(display);
        } else if (name != null) {
            c.addText(name);
        } else {
            c.tx(". Generated Summary: ");
            if (tr != null) {
                new ProfileDrivenRenderer(this.context).generateResourceSummary(c, tr.getResource(), true, r.getReference().startsWith("#"), true);
            }
        }
        if (tr != null && tr.getReference() != null && tr.getReference().startsWith("#")) {
            c.tx(")");
        }
    }

    public void renderReference(BaseWrappers.ResourceWrapper rw, XhtmlNode x, BaseWrappers.BaseWrapper r) throws UnsupportedEncodingException, IOException {
        String v;
        XhtmlNode c = x;
        Resolver.ResourceWithReference tr = null;
        if (r.has("reference")) {
            v = r.get("reference").primitiveValue();
            tr = this.resolveReference(rw, v);
            if (!v.startsWith("#")) {
                c = tr != null && tr.getReference() != null ? x.ah(tr.getReference()) : x.ah(v);
            }
        } else {
            v = "";
        }
        if (r.has("display")) {
            c.addText(r.get("display").primitiveValue());
            if (tr != null && tr.getResource() != null) {
                c.tx(". Generated Summary: ");
                new ProfileDrivenRenderer(this.context).generateResourceSummary(c, tr.getResource(), true, v.startsWith("#"), false);
            }
        } else if (tr != null && tr.getResource() != null) {
            new ProfileDrivenRenderer(this.context).generateResourceSummary(c, tr.getResource(), v.startsWith("#"), v.startsWith("#"), false);
        } else {
            c.addText(v);
        }
    }

    protected Resolver.ResourceWithReference resolveReference(BaseWrappers.ResourceWrapper res, String url) {
        Object ae;
        if (url == null) {
            return null;
        }
        if (url.startsWith("#") && res != null) {
            for (BaseWrappers.ResourceWrapper r : res.getContained()) {
                if (!r.getId().equals(url.substring(1))) continue;
                return new Resolver.ResourceWithReference(null, r);
            }
            return null;
        }
        String version = null;
        if (url.contains("/_history/")) {
            version = url.substring(url.indexOf("/_history/") + 10);
            url = url.substring(0, url.indexOf("/_history/"));
        }
        if (this.rcontext != null) {
            Bundle.BundleEntryComponent bundleResource = this.rcontext.resolve(url);
            if (bundleResource != null) {
                String bundleUrl = "#" + bundleResource.getResource().getResourceType().name() + "_" + bundleResource.getResource().getId();
                return new Resolver.ResourceWithReference(bundleUrl, new DirectWrappers.ResourceWrapperDirect(this.context, bundleResource.getResource()));
            }
            Element bundleElement = this.rcontext.resolveElement(url, version);
            if (bundleElement != null) {
                String bundleUrl = null;
                Element br = bundleElement.getNamedChild("resource");
                bundleUrl = br.getChildValue("id") != null ? "#" + br.fhirType() + "_" + br.getChildValue("id") : "#" + this.fullUrlToAnchor(bundleElement.getChildValue("fullUrl"));
                return new Resolver.ResourceWithReference(bundleUrl, new ElementWrappers.ResourceWrapperMetaElement(this.context, br));
            }
        }
        if ((ae = this.getContext().getWorker().fetchResource(null, url, version)) != null) {
            return new Resolver.ResourceWithReference(url, new DirectWrappers.ResourceWrapperDirect(this.context, (Resource)ae));
        }
        if (this.context.getResolver() != null) {
            return this.context.getResolver().resolve(this.context, url);
        }
        return null;
    }

    private String fullUrlToAnchor(String url) {
        return url.replace(":", "").replace("/", "_");
    }

    protected void generateCopyright(XhtmlNode x, CanonicalResource cs) {
        XhtmlNode p = x.para();
        p.b().tx(this.getContext().getWorker().translator().translate("xhtml-gen-cs", "Copyright Statement:", this.context.getLang()));
        this.smartAddText(p, " " + cs.getCopyright());
    }

    public String displayReference(Resource res, Reference r) throws UnsupportedEncodingException, IOException {
        return "todo";
    }

    public Base parseType(String string, String type) {
        return null;
    }

    protected BaseWrappers.PropertyWrapper getProperty(BaseWrappers.ResourceWrapper res, String name) {
        for (BaseWrappers.PropertyWrapper t : res.children()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    protected BaseWrappers.PropertyWrapper getProperty(BaseWrappers.BaseWrapper res, String name) {
        for (BaseWrappers.PropertyWrapper t : res.children()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        return null;
    }

    protected boolean valued(BaseWrappers.PropertyWrapper pw) {
        return pw != null && pw.hasValues();
    }

    protected BaseWrappers.ResourceWrapper fetchResource(BaseWrappers.BaseWrapper subject) throws UnsupportedEncodingException, FHIRException, IOException {
        if (this.context.getResolver() == null) {
            return null;
        }
        BaseWrappers.PropertyWrapper ref = subject.getChildByName("reference");
        if (ref == null || !ref.hasValues()) {
            return null;
        }
        String url = ref.value().getBase().primitiveValue();
        Resolver.ResourceWithReference rr = this.context.getResolver().resolve(this.context, url);
        return rr == null ? null : rr.getResource();
    }

    protected String describeStatus(Enumerations.PublicationStatus status, boolean experimental) {
        switch (status) {
            case ACTIVE: {
                return experimental ? "Experimental" : "Active";
            }
            case DRAFT: {
                return "draft";
            }
            case RETIRED: {
                return "retired";
            }
        }
        return "Unknown";
    }

    protected void renderCommitteeLink(XhtmlNode x, CanonicalResource cr) {
        String code = ToolingExtensions.readStringExtension(cr, "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg");
        CodeSystem cs = this.context.getWorker().fetchCodeSystem("http://terminology.hl7.org/CodeSystem/hl7-work-group");
        if (cs == null || !cs.hasUserData("path")) {
            x.tx(code);
        } else {
            CodeSystem.ConceptDefinitionComponent cd = CodeSystemUtilities.findCode(cs.getConcept(), code);
            if (cd == null) {
                x.tx(code);
            } else {
                x.ah(cs.getUserString("path") + "#" + cs.getId() + "-" + cd.getCode()).tx(cd.getDisplay());
            }
        }
    }

    public static String makeInternalBundleLink(String fullUrl) {
        return fullUrl.replace(":", "-");
    }

    public boolean canRender(Resource resource) {
        return true;
    }

    protected void renderResourceHeader(BaseWrappers.ResourceWrapper r, XhtmlNode x, boolean doId) throws UnsupportedEncodingException, FHIRException, IOException {
        XhtmlNode div = x.div().style("display: inline-block").style("background-color: #d9e0e7").style("padding: 6px").style("margin: 4px").style("border: 1px solid #8da1b4").style("border-radius: 5px").style("line-height: 60%");
        String id = this.getPrimitiveValue(r, "id");
        if (doId) {
            div.an(id);
        }
        String lang = this.getPrimitiveValue(r, "language");
        String ir = this.getPrimitiveValue(r, "implicitRules");
        BaseWrappers.BaseWrapper meta = r.getChildByName("meta").hasValues() ? r.getChildByName("meta").getValues().get(0) : null;
        String versionId = this.getPrimitiveValue(meta, "versionId");
        String lastUpdated = this.getPrimitiveValue(meta, "lastUpdated");
        String source = this.getPrimitiveValue(meta, "source");
        if (id != null || lang != null || versionId != null || lastUpdated != null) {
            XhtmlNode p = this.plateStyle(div.para());
            p.tx("Resource ");
            p.tx(r.fhirType());
            p.tx(" ");
            if (id != null) {
                p.tx("\"" + id + "\" ");
            }
            if (versionId != null) {
                p.tx("Version \"" + versionId + "\" ");
            }
            if (lastUpdated != null) {
                p.tx("Updated \"");
                this.renderDateTime(p, lastUpdated);
                p.tx("\" ");
            }
            if (lang != null) {
                p.tx(" (Language \"" + lang + "\") ");
            }
        }
        if (ir != null) {
            this.plateStyle(div.para()).b().tx("Special rules apply: " + ir + "!");
        }
        if (source != null) {
            this.plateStyle(div.para()).tx("Information Source: " + source + "!");
        }
        if (meta != null) {
            BaseWrappers.PropertyWrapper sl;
            BaseWrappers.PropertyWrapper tl;
            BaseWrappers.PropertyWrapper pl = meta.getChildByName("profile");
            if (pl.hasValues()) {
                XhtmlNode p = this.plateStyle(div.para());
                p.tx(Utilities.pluralize((String)"Profile", (int)pl.getValues().size()) + ": ");
                boolean first = true;
                for (BaseWrappers.BaseWrapper baseWrapper : pl.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        p.tx(", ");
                    }
                    this.renderCanonical(r, p, baseWrapper.getBase().primitiveValue());
                }
            }
            if ((tl = meta.getChildByName("tag")).hasValues()) {
                XhtmlNode p = this.plateStyle(div.para());
                p.tx(Utilities.pluralize((String)"Tag", (int)tl.getValues().size()) + ": ");
                boolean first = true;
                for (BaseWrappers.BaseWrapper bw : tl.getValues()) {
                    if (first) {
                        first = false;
                    } else {
                        p.tx(", ");
                    }
                    String system = this.getPrimitiveValue(bw, "system");
                    String version = this.getPrimitiveValue(bw, "version");
                    String code = this.getPrimitiveValue(bw, "system");
                    String display = this.getPrimitiveValue(bw, "system");
                    this.renderCoding(p, new Coding(system, version, code, display));
                }
            }
            if ((sl = meta.getChildByName("security")).hasValues()) {
                XhtmlNode p = this.plateStyle(div.para());
                p.tx(Utilities.pluralize((String)"Security Label", (int)tl.getValues().size()) + ": ");
                boolean bl = true;
                for (BaseWrappers.BaseWrapper bw : sl.getValues()) {
                    boolean bl2;
                    if (bl2) {
                        bl2 = false;
                    } else {
                        p.tx(", ");
                    }
                    String system = this.getPrimitiveValue(bw, "system");
                    String version = this.getPrimitiveValue(bw, "version");
                    String code = this.getPrimitiveValue(bw, "system");
                    String display = this.getPrimitiveValue(bw, "system");
                    this.renderCoding(p, new Coding(system, version, code, display));
                }
            }
        }
    }

    private XhtmlNode plateStyle(XhtmlNode para) {
        return para.style("margin-bottom: 0px");
    }

    private String getPrimitiveValue(BaseWrappers.BaseWrapper b, String name) throws UnsupportedEncodingException, FHIRException, IOException {
        return b != null && b.has(name) && b.getChildByName(name).hasValues() ? b.getChildByName(name).getValues().get(0).getBase().primitiveValue() : null;
    }

    private String getPrimitiveValue(BaseWrappers.ResourceWrapper r, String name) throws UnsupportedEncodingException, FHIRException, IOException {
        return r.has(name) && r.getChildByName(name).hasValues() ? r.getChildByName(name).getValues().get(0).getBase().primitiveValue() : null;
    }

    public void renderOrError(DomainResource dr) {
        try {
            this.render(dr);
        }
        catch (Exception e) {
            XhtmlNode x = new XhtmlNode(NodeType.Element, "div");
            x.para().tx("Error rendering: " + e.getMessage());
            dr.setText(null);
            ResourceRenderer.inject(dr, x, Narrative.NarrativeStatus.GENERATED);
        }
    }

    public RendererType getRendererType() {
        return RendererType.NATIVE;
    }

    public static enum RendererType {
        NATIVE,
        PROFILE,
        LIQUID;

    }
}

