/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.ExtensionHelper;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.renderers.ResourceRenderer;
import org.hl7.fhir.r5.renderers.utils.BaseWrappers;
import org.hl7.fhir.r5.renderers.utils.RenderingContext;
import org.hl7.fhir.r5.renderers.utils.Resolver;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class OperationOutcomeRenderer
extends ResourceRenderer {
    public OperationOutcomeRenderer(RenderingContext context) {
        super(context);
    }

    public OperationOutcomeRenderer(RenderingContext context, Resolver.ResourceContext rcontext) {
        super(context, rcontext);
    }

    @Override
    public boolean render(XhtmlNode x, Resource dr) throws FHIRFormatError, DefinitionException, IOException {
        return this.render(x, (OperationOutcome)dr);
    }

    public boolean render(XhtmlNode x, OperationOutcome op) throws FHIRFormatError, DefinitionException, IOException {
        boolean hasSource = false;
        boolean success = true;
        for (OperationOutcome.OperationOutcomeIssueComponent i : op.getIssue()) {
            success = success && i.getSeverity() == OperationOutcome.IssueSeverity.INFORMATION;
            hasSource = hasSource || ExtensionHelper.hasExtension(i, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
        }
        if (success) {
            x.para().tx("All OK");
        }
        if (op.getIssue().size() > 0) {
            XhtmlNode tbl = x.table("grid");
            XhtmlNode tr = tbl.tr();
            tr.td().b().tx("Severity");
            tr.td().b().tx("Location");
            tr.td().b().tx("Code");
            tr.td().b().tx("Details");
            tr.td().b().tx("Diagnostics");
            if (hasSource) {
                tr.td().b().tx("Source");
            }
            for (OperationOutcome.OperationOutcomeIssueComponent i : op.getIssue()) {
                tr = tbl.tr();
                tr.td().addText(i.getSeverity().toString());
                XhtmlNode td = tr.td();
                boolean d = false;
                for (StringType s : i.getLocation()) {
                    if (d) {
                        td.tx(", ");
                    } else {
                        d = true;
                    }
                    td.addText((String)s.getValue());
                }
                tr.td().addText(i.getCode().getDisplay());
                tr.td().addText(this.display(i.getDetails()));
                this.smartAddText(tr.td(), i.getDiagnostics());
                if (!hasSource) continue;
                Extension ext = ExtensionHelper.getExtension(i, "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source");
                tr.td().addText(ext == null ? "" : this.display(ext));
            }
        }
        return true;
    }

    public void describe(XhtmlNode x, OperationOutcome oo) {
        x.tx(this.display(oo));
    }

    public String display(OperationOutcome oo) {
        return "todo";
    }

    @Override
    public String display(BaseWrappers.ResourceWrapper r) throws UnsupportedEncodingException, IOException {
        return "Not done yet";
    }

    @Override
    public String display(Resource r) throws UnsupportedEncodingException, IOException {
        return this.display((OperationOutcome)r);
    }

    public static String toString(OperationOutcome oo) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (OperationOutcome.OperationOutcomeIssueComponent issue : oo.getIssue()) {
            b.append(issue.getSeverity().toCode() + ": " + issue.getDetails().getText());
        }
        return b.toString();
    }
}

