/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Money;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="PaymentReconciliation", profile="http://hl7.org/fhir/StructureDefinition/PaymentReconciliation")
public class PaymentReconciliation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Business Identifier for a payment reconciliation", formalDefinition="A unique identifier assigned to this payment reconciliation.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Category of payment", formalDefinition="Code to indicate the nature of the payment such as payment, adjustment.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/payment-type")
    protected CodeableConcept type;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | cancelled | draft | entered-in-error", formalDefinition="The status of the resource instance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/fm-status")
    protected Enumeration<Enumerations.FinancialResourceStatusCodes> status;
    @Child(name="kind", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Workflow originating payment", formalDefinition="The workflow or activity which gave rise to or during which the payment ocurred such as a kiosk, deposit on account, periodic payment etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/payment-kind")
    protected CodeableConcept kind;
    @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Period covered", formalDefinition="The period of time for which payments have been gathered into this bulk payment for settlement.")
    protected Period period;
    @Child(name="created", type={DateTimeType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the resource was created.")
    protected DateTimeType created;
    @Child(name="enterer", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Who entered the payment", formalDefinition="Payment enterer if not the actual payment issuer.")
    protected Reference enterer;
    @Child(name="issuerType", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Nature of the source", formalDefinition="The type of the source such as patient or insurance.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/payment-issuertype")
    protected CodeableConcept issuerType;
    @Child(name="paymentIssuer", type={Organization.class, Patient.class, Person.class, RelatedPerson.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Party generating payment", formalDefinition="The party who generated the payment.")
    protected Reference paymentIssuer;
    @Child(name="request", type={Task.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to requesting resource", formalDefinition="Original request resource reference.")
    protected Reference request;
    @Child(name="requestor", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference requestor;
    @Child(name="outcome", type={CodeType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="queued | complete | error | partial", formalDefinition="The outcome of a request for a reconciliation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/payment-outcome")
    protected Enumeration<PaymentOutcome> outcome;
    @Child(name="disposition", type={StringType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Disposition message", formalDefinition="A human readable description of the status of the request for the reconciliation.")
    protected StringType disposition;
    @Child(name="date", type={DateType.class}, order=13, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When payment issued", formalDefinition="The date of payment as indicated on the financial instrument.")
    protected DateType date;
    @Child(name="location", type={Location.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Where payment collected", formalDefinition="The location of the site or device for electronic transfers or physical location for cash payments.")
    protected Reference location;
    @Child(name="method", type={CodeableConcept.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Payment instrument", formalDefinition="The means of payment such as check, card cash, or electronic funds transfer.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0570")
    protected CodeableConcept method;
    @Child(name="cardBrand", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of card", formalDefinition="The card brand such as debit, Visa, Amex etc. used if a card is the method of payment.")
    protected StringType cardBrand;
    @Child(name="accountNumber", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Digits for verification", formalDefinition="A portion of the account number, often the last 4 digits, used for verification not charging purposes.")
    protected StringType accountNumber;
    @Child(name="expirationDate", type={DateType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Expiration year-month", formalDefinition="The year and month (YYYY-MM) when the instrument, typically card, expires.")
    protected DateType expirationDate;
    @Child(name="processor", type={StringType.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Processor name", formalDefinition="The name of the card processor, etf processor, bank for checks.")
    protected StringType processor;
    @Child(name="referenceNumber", type={StringType.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Check number or payment reference", formalDefinition="The check number, eft reference, car processor reference.")
    protected StringType referenceNumber;
    @Child(name="authorization", type={StringType.class}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Authorization number", formalDefinition="An alphanumeric issued by the processor to confirm the successful issuance of payment.")
    protected StringType authorization;
    @Child(name="tenderedAmount", type={Money.class}, order=22, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Amount offered by the issuer", formalDefinition="The amount offered by the issuer, typically applies to cash when the issuer provides an amount in bank note denominations equal to or excess of the amount actually being paid.")
    protected Money tenderedAmount;
    @Child(name="returnedAmount", type={Money.class}, order=23, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Amount returned by the receiver", formalDefinition="The amount returned by the receiver which is excess to the amount payable, often referred to as 'change'.")
    protected Money returnedAmount;
    @Child(name="amount", type={Money.class}, order=24, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Total amount of Payment", formalDefinition="Total payment amount as indicated on the financial instrument.")
    protected Money amount;
    @Child(name="paymentIdentifier", type={Identifier.class}, order=25, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Business identifier for the payment", formalDefinition="Issuer's unique identifier for the payment instrument.")
    protected Identifier paymentIdentifier;
    @Child(name="allocation", type={}, order=26, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Settlement particulars", formalDefinition="Distribution of the payment amount for a previously acknowledged payable.")
    protected List<PaymentReconciliationAllocationComponent> allocation;
    @Child(name="formCode", type={CodeableConcept.class}, order=27, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Printed form identifier", formalDefinition="A code for the form to be used for printing the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/forms")
    protected CodeableConcept formCode;
    @Child(name="processNote", type={}, order=28, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Note concerning processing", formalDefinition="A note that describes or explains the processing in a human readable form.")
    protected List<NotesComponent> processNote;
    private static final long serialVersionUID = 705873820L;
    @SearchParamDefinition(name="allocation-account", path="PaymentReconciliation.allocation.account", description="The account to which payment or adjustment was applied.", type="reference", target={Account.class})
    public static final String SP_ALLOCATION_ACCOUNT = "allocation-account";
    public static final ReferenceClientParam ALLOCATION_ACCOUNT = new ReferenceClientParam("allocation-account");
    public static final Include INCLUDE_ALLOCATION_ACCOUNT = new Include("PaymentReconciliation:allocation-account").toLocked();
    @SearchParamDefinition(name="allocation-encounter", path="PaymentReconciliation.allocation.encounter", description="The encounter to which payment or adjustment was applied.", type="reference", target={Encounter.class})
    public static final String SP_ALLOCATION_ENCOUNTER = "allocation-encounter";
    public static final ReferenceClientParam ALLOCATION_ENCOUNTER = new ReferenceClientParam("allocation-encounter");
    public static final Include INCLUDE_ALLOCATION_ENCOUNTER = new Include("PaymentReconciliation:allocation-encounter").toLocked();
    @SearchParamDefinition(name="created", path="PaymentReconciliation.created", description="The creation date", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="disposition", path="PaymentReconciliation.disposition", description="The contents of the disposition message", type="string")
    public static final String SP_DISPOSITION = "disposition";
    public static final StringClientParam DISPOSITION = new StringClientParam("disposition");
    @SearchParamDefinition(name="identifier", path="PaymentReconciliation.identifier", description="The business identifier of the ExplanationOfBenefit", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="outcome", path="PaymentReconciliation.outcome", description="The processing outcome", type="token")
    public static final String SP_OUTCOME = "outcome";
    public static final TokenClientParam OUTCOME = new TokenClientParam("outcome");
    @SearchParamDefinition(name="payment-issuer", path="PaymentReconciliation.paymentIssuer", description="The organization which generated this resource", type="reference", target={Organization.class, Patient.class, Person.class, RelatedPerson.class})
    public static final String SP_PAYMENT_ISSUER = "payment-issuer";
    public static final ReferenceClientParam PAYMENT_ISSUER = new ReferenceClientParam("payment-issuer");
    public static final Include INCLUDE_PAYMENT_ISSUER = new Include("PaymentReconciliation:payment-issuer").toLocked();
    @SearchParamDefinition(name="request", path="PaymentReconciliation.request", description="The reference to the claim", type="reference", target={Task.class})
    public static final String SP_REQUEST = "request";
    public static final ReferenceClientParam REQUEST = new ReferenceClientParam("request");
    public static final Include INCLUDE_REQUEST = new Include("PaymentReconciliation:request").toLocked();
    @SearchParamDefinition(name="requestor", path="PaymentReconciliation.requestor", description="The reference to the provider who submitted the claim", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_REQUESTOR = "requestor";
    public static final ReferenceClientParam REQUESTOR = new ReferenceClientParam("requestor");
    public static final Include INCLUDE_REQUESTOR = new Include("PaymentReconciliation:requestor").toLocked();
    @SearchParamDefinition(name="status", path="PaymentReconciliation.status", description="The status of the payment reconciliation", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public PaymentReconciliation() {
    }

    public PaymentReconciliation(CodeableConcept type, Enumerations.FinancialResourceStatusCodes status, Date created, Date date, Money amount) {
        this.setType(type);
        this.setStatus(status);
        this.setCreated(created);
        this.setDate(date);
        this.setAmount(amount);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public PaymentReconciliation setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public PaymentReconciliation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public PaymentReconciliation setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Enumeration<Enumerations.FinancialResourceStatusCodes> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public PaymentReconciliation setStatusElement(Enumeration<Enumerations.FinancialResourceStatusCodes> value) {
        this.status = value;
        return this;
    }

    public Enumerations.FinancialResourceStatusCodes getStatus() {
        return this.status == null ? null : (Enumerations.FinancialResourceStatusCodes)((Object)this.status.getValue());
    }

    public PaymentReconciliation setStatus(Enumerations.FinancialResourceStatusCodes value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.FinancialResourceStatusCodes>(new Enumerations.FinancialResourceStatusCodesEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getKind() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new CodeableConcept();
            }
        }
        return this.kind;
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public PaymentReconciliation setKind(CodeableConcept value) {
        this.kind = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public PaymentReconciliation setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public PaymentReconciliation setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public PaymentReconciliation setCreated(Date value) {
        if (this.created == null) {
            this.created = new DateTimeType();
        }
        this.created.setValue(value);
        return this;
    }

    public Reference getEnterer() {
        if (this.enterer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.enterer = new Reference();
            }
        }
        return this.enterer;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public PaymentReconciliation setEnterer(Reference value) {
        this.enterer = value;
        return this;
    }

    public CodeableConcept getIssuerType() {
        if (this.issuerType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.issuerType");
            }
            if (Configuration.doAutoCreate()) {
                this.issuerType = new CodeableConcept();
            }
        }
        return this.issuerType;
    }

    public boolean hasIssuerType() {
        return this.issuerType != null && !this.issuerType.isEmpty();
    }

    public PaymentReconciliation setIssuerType(CodeableConcept value) {
        this.issuerType = value;
        return this;
    }

    public Reference getPaymentIssuer() {
        if (this.paymentIssuer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.paymentIssuer");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentIssuer = new Reference();
            }
        }
        return this.paymentIssuer;
    }

    public boolean hasPaymentIssuer() {
        return this.paymentIssuer != null && !this.paymentIssuer.isEmpty();
    }

    public PaymentReconciliation setPaymentIssuer(Reference value) {
        this.paymentIssuer = value;
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public PaymentReconciliation setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Reference getRequestor() {
        if (this.requestor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.requestor");
            }
            if (Configuration.doAutoCreate()) {
                this.requestor = new Reference();
            }
        }
        return this.requestor;
    }

    public boolean hasRequestor() {
        return this.requestor != null && !this.requestor.isEmpty();
    }

    public PaymentReconciliation setRequestor(Reference value) {
        this.requestor = value;
        return this;
    }

    public Enumeration<PaymentOutcome> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<PaymentOutcome>(new PaymentOutcomeEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public PaymentReconciliation setOutcomeElement(Enumeration<PaymentOutcome> value) {
        this.outcome = value;
        return this;
    }

    public PaymentOutcome getOutcome() {
        return this.outcome == null ? null : (PaymentOutcome)((Object)this.outcome.getValue());
    }

    public PaymentReconciliation setOutcome(PaymentOutcome value) {
        if (value == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new Enumeration<PaymentOutcome>(new PaymentOutcomeEnumFactory());
            }
            this.outcome.setValue((Object)value);
        }
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public PaymentReconciliation setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public PaymentReconciliation setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public DateType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public PaymentReconciliation setDateElement(DateType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public PaymentReconciliation setDate(Date value) {
        if (this.date == null) {
            this.date = new DateType();
        }
        this.date.setValue(value);
        return this;
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public PaymentReconciliation setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public CodeableConcept getMethod() {
        if (this.method == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.method");
            }
            if (Configuration.doAutoCreate()) {
                this.method = new CodeableConcept();
            }
        }
        return this.method;
    }

    public boolean hasMethod() {
        return this.method != null && !this.method.isEmpty();
    }

    public PaymentReconciliation setMethod(CodeableConcept value) {
        this.method = value;
        return this;
    }

    public StringType getCardBrandElement() {
        if (this.cardBrand == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.cardBrand");
            }
            if (Configuration.doAutoCreate()) {
                this.cardBrand = new StringType();
            }
        }
        return this.cardBrand;
    }

    public boolean hasCardBrandElement() {
        return this.cardBrand != null && !this.cardBrand.isEmpty();
    }

    public boolean hasCardBrand() {
        return this.cardBrand != null && !this.cardBrand.isEmpty();
    }

    public PaymentReconciliation setCardBrandElement(StringType value) {
        this.cardBrand = value;
        return this;
    }

    public String getCardBrand() {
        return this.cardBrand == null ? null : (String)this.cardBrand.getValue();
    }

    public PaymentReconciliation setCardBrand(String value) {
        if (Utilities.noString((String)value)) {
            this.cardBrand = null;
        } else {
            if (this.cardBrand == null) {
                this.cardBrand = new StringType();
            }
            this.cardBrand.setValue(value);
        }
        return this;
    }

    public StringType getAccountNumberElement() {
        if (this.accountNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.accountNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.accountNumber = new StringType();
            }
        }
        return this.accountNumber;
    }

    public boolean hasAccountNumberElement() {
        return this.accountNumber != null && !this.accountNumber.isEmpty();
    }

    public boolean hasAccountNumber() {
        return this.accountNumber != null && !this.accountNumber.isEmpty();
    }

    public PaymentReconciliation setAccountNumberElement(StringType value) {
        this.accountNumber = value;
        return this;
    }

    public String getAccountNumber() {
        return this.accountNumber == null ? null : (String)this.accountNumber.getValue();
    }

    public PaymentReconciliation setAccountNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.accountNumber = null;
        } else {
            if (this.accountNumber == null) {
                this.accountNumber = new StringType();
            }
            this.accountNumber.setValue(value);
        }
        return this;
    }

    public DateType getExpirationDateElement() {
        if (this.expirationDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.expirationDate");
            }
            if (Configuration.doAutoCreate()) {
                this.expirationDate = new DateType();
            }
        }
        return this.expirationDate;
    }

    public boolean hasExpirationDateElement() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public boolean hasExpirationDate() {
        return this.expirationDate != null && !this.expirationDate.isEmpty();
    }

    public PaymentReconciliation setExpirationDateElement(DateType value) {
        this.expirationDate = value;
        return this;
    }

    public Date getExpirationDate() {
        return this.expirationDate == null ? null : (Date)this.expirationDate.getValue();
    }

    public PaymentReconciliation setExpirationDate(Date value) {
        if (value == null) {
            this.expirationDate = null;
        } else {
            if (this.expirationDate == null) {
                this.expirationDate = new DateType();
            }
            this.expirationDate.setValue(value);
        }
        return this;
    }

    public StringType getProcessorElement() {
        if (this.processor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.processor");
            }
            if (Configuration.doAutoCreate()) {
                this.processor = new StringType();
            }
        }
        return this.processor;
    }

    public boolean hasProcessorElement() {
        return this.processor != null && !this.processor.isEmpty();
    }

    public boolean hasProcessor() {
        return this.processor != null && !this.processor.isEmpty();
    }

    public PaymentReconciliation setProcessorElement(StringType value) {
        this.processor = value;
        return this;
    }

    public String getProcessor() {
        return this.processor == null ? null : (String)this.processor.getValue();
    }

    public PaymentReconciliation setProcessor(String value) {
        if (Utilities.noString((String)value)) {
            this.processor = null;
        } else {
            if (this.processor == null) {
                this.processor = new StringType();
            }
            this.processor.setValue(value);
        }
        return this;
    }

    public StringType getReferenceNumberElement() {
        if (this.referenceNumber == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.referenceNumber");
            }
            if (Configuration.doAutoCreate()) {
                this.referenceNumber = new StringType();
            }
        }
        return this.referenceNumber;
    }

    public boolean hasReferenceNumberElement() {
        return this.referenceNumber != null && !this.referenceNumber.isEmpty();
    }

    public boolean hasReferenceNumber() {
        return this.referenceNumber != null && !this.referenceNumber.isEmpty();
    }

    public PaymentReconciliation setReferenceNumberElement(StringType value) {
        this.referenceNumber = value;
        return this;
    }

    public String getReferenceNumber() {
        return this.referenceNumber == null ? null : (String)this.referenceNumber.getValue();
    }

    public PaymentReconciliation setReferenceNumber(String value) {
        if (Utilities.noString((String)value)) {
            this.referenceNumber = null;
        } else {
            if (this.referenceNumber == null) {
                this.referenceNumber = new StringType();
            }
            this.referenceNumber.setValue(value);
        }
        return this;
    }

    public StringType getAuthorizationElement() {
        if (this.authorization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.authorization");
            }
            if (Configuration.doAutoCreate()) {
                this.authorization = new StringType();
            }
        }
        return this.authorization;
    }

    public boolean hasAuthorizationElement() {
        return this.authorization != null && !this.authorization.isEmpty();
    }

    public boolean hasAuthorization() {
        return this.authorization != null && !this.authorization.isEmpty();
    }

    public PaymentReconciliation setAuthorizationElement(StringType value) {
        this.authorization = value;
        return this;
    }

    public String getAuthorization() {
        return this.authorization == null ? null : (String)this.authorization.getValue();
    }

    public PaymentReconciliation setAuthorization(String value) {
        if (Utilities.noString((String)value)) {
            this.authorization = null;
        } else {
            if (this.authorization == null) {
                this.authorization = new StringType();
            }
            this.authorization.setValue(value);
        }
        return this;
    }

    public Money getTenderedAmount() {
        if (this.tenderedAmount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.tenderedAmount");
            }
            if (Configuration.doAutoCreate()) {
                this.tenderedAmount = new Money();
            }
        }
        return this.tenderedAmount;
    }

    public boolean hasTenderedAmount() {
        return this.tenderedAmount != null && !this.tenderedAmount.isEmpty();
    }

    public PaymentReconciliation setTenderedAmount(Money value) {
        this.tenderedAmount = value;
        return this;
    }

    public Money getReturnedAmount() {
        if (this.returnedAmount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.returnedAmount");
            }
            if (Configuration.doAutoCreate()) {
                this.returnedAmount = new Money();
            }
        }
        return this.returnedAmount;
    }

    public boolean hasReturnedAmount() {
        return this.returnedAmount != null && !this.returnedAmount.isEmpty();
    }

    public PaymentReconciliation setReturnedAmount(Money value) {
        this.returnedAmount = value;
        return this;
    }

    public Money getAmount() {
        if (this.amount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.amount");
            }
            if (Configuration.doAutoCreate()) {
                this.amount = new Money();
            }
        }
        return this.amount;
    }

    public boolean hasAmount() {
        return this.amount != null && !this.amount.isEmpty();
    }

    public PaymentReconciliation setAmount(Money value) {
        this.amount = value;
        return this;
    }

    public Identifier getPaymentIdentifier() {
        if (this.paymentIdentifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.paymentIdentifier");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentIdentifier = new Identifier();
            }
        }
        return this.paymentIdentifier;
    }

    public boolean hasPaymentIdentifier() {
        return this.paymentIdentifier != null && !this.paymentIdentifier.isEmpty();
    }

    public PaymentReconciliation setPaymentIdentifier(Identifier value) {
        this.paymentIdentifier = value;
        return this;
    }

    public List<PaymentReconciliationAllocationComponent> getAllocation() {
        if (this.allocation == null) {
            this.allocation = new ArrayList<PaymentReconciliationAllocationComponent>();
        }
        return this.allocation;
    }

    public PaymentReconciliation setAllocation(List<PaymentReconciliationAllocationComponent> theAllocation) {
        this.allocation = theAllocation;
        return this;
    }

    public boolean hasAllocation() {
        if (this.allocation == null) {
            return false;
        }
        for (PaymentReconciliationAllocationComponent item : this.allocation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PaymentReconciliationAllocationComponent addAllocation() {
        PaymentReconciliationAllocationComponent t = new PaymentReconciliationAllocationComponent();
        if (this.allocation == null) {
            this.allocation = new ArrayList<PaymentReconciliationAllocationComponent>();
        }
        this.allocation.add(t);
        return t;
    }

    public PaymentReconciliation addAllocation(PaymentReconciliationAllocationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.allocation == null) {
            this.allocation = new ArrayList<PaymentReconciliationAllocationComponent>();
        }
        this.allocation.add(t);
        return this;
    }

    public PaymentReconciliationAllocationComponent getAllocationFirstRep() {
        if (this.getAllocation().isEmpty()) {
            this.addAllocation();
        }
        return this.getAllocation().get(0);
    }

    public CodeableConcept getFormCode() {
        if (this.formCode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create PaymentReconciliation.formCode");
            }
            if (Configuration.doAutoCreate()) {
                this.formCode = new CodeableConcept();
            }
        }
        return this.formCode;
    }

    public boolean hasFormCode() {
        return this.formCode != null && !this.formCode.isEmpty();
    }

    public PaymentReconciliation setFormCode(CodeableConcept value) {
        this.formCode = value;
        return this;
    }

    public List<NotesComponent> getProcessNote() {
        if (this.processNote == null) {
            this.processNote = new ArrayList<NotesComponent>();
        }
        return this.processNote;
    }

    public PaymentReconciliation setProcessNote(List<NotesComponent> theProcessNote) {
        this.processNote = theProcessNote;
        return this;
    }

    public boolean hasProcessNote() {
        if (this.processNote == null) {
            return false;
        }
        for (NotesComponent item : this.processNote) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NotesComponent addProcessNote() {
        NotesComponent t = new NotesComponent();
        if (this.processNote == null) {
            this.processNote = new ArrayList<NotesComponent>();
        }
        this.processNote.add(t);
        return t;
    }

    public PaymentReconciliation addProcessNote(NotesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.processNote == null) {
            this.processNote = new ArrayList<NotesComponent>();
        }
        this.processNote.add(t);
        return this;
    }

    public NotesComponent getProcessNoteFirstRep() {
        if (this.getProcessNote().isEmpty()) {
            this.addProcessNote();
        }
        return this.getProcessNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this payment reconciliation.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("type", "CodeableConcept", "Code to indicate the nature of the payment such as payment, adjustment.", 0, 1, this.type));
        children.add(new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status));
        children.add(new Property("kind", "CodeableConcept", "The workflow or activity which gave rise to or during which the payment ocurred such as a kiosk, deposit on account, periodic payment etc.", 0, 1, this.kind));
        children.add(new Property("period", "Period", "The period of time for which payments have been gathered into this bulk payment for settlement.", 0, 1, this.period));
        children.add(new Property(SP_CREATED, "dateTime", "The date when the resource was created.", 0, 1, this.created));
        children.add(new Property("enterer", "Reference(Practitioner|PractitionerRole|Organization)", "Payment enterer if not the actual payment issuer.", 0, 1, this.enterer));
        children.add(new Property("issuerType", "CodeableConcept", "The type of the source such as patient or insurance.", 0, 1, this.issuerType));
        children.add(new Property("paymentIssuer", "Reference(Organization|Patient|Person|RelatedPerson)", "The party who generated the payment.", 0, 1, this.paymentIssuer));
        children.add(new Property(SP_REQUEST, "Reference(Task)", "Original request resource reference.", 0, 1, this.request));
        children.add(new Property(SP_REQUESTOR, "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestor));
        children.add(new Property(SP_OUTCOME, "code", "The outcome of a request for a reconciliation.", 0, 1, this.outcome));
        children.add(new Property(SP_DISPOSITION, "string", "A human readable description of the status of the request for the reconciliation.", 0, 1, this.disposition));
        children.add(new Property("date", "date", "The date of payment as indicated on the financial instrument.", 0, 1, this.date));
        children.add(new Property("location", "Reference(Location)", "The location of the site or device for electronic transfers or physical location for cash payments.", 0, 1, this.location));
        children.add(new Property("method", "CodeableConcept", "The means of payment such as check, card cash, or electronic funds transfer.", 0, 1, this.method));
        children.add(new Property("cardBrand", "string", "The card brand such as debit, Visa, Amex etc. used if a card is the method of payment.", 0, 1, this.cardBrand));
        children.add(new Property("accountNumber", "string", "A portion of the account number, often the last 4 digits, used for verification not charging purposes.", 0, 1, this.accountNumber));
        children.add(new Property("expirationDate", "date", "The year and month (YYYY-MM) when the instrument, typically card, expires.", 0, 1, this.expirationDate));
        children.add(new Property("processor", "string", "The name of the card processor, etf processor, bank for checks.", 0, 1, this.processor));
        children.add(new Property("referenceNumber", "string", "The check number, eft reference, car processor reference.", 0, 1, this.referenceNumber));
        children.add(new Property("authorization", "string", "An alphanumeric issued by the processor to confirm the successful issuance of payment.", 0, 1, this.authorization));
        children.add(new Property("tenderedAmount", "Money", "The amount offered by the issuer, typically applies to cash when the issuer provides an amount in bank note denominations equal to or excess of the amount actually being paid.", 0, 1, this.tenderedAmount));
        children.add(new Property("returnedAmount", "Money", "The amount returned by the receiver which is excess to the amount payable, often referred to as 'change'.", 0, 1, this.returnedAmount));
        children.add(new Property("amount", "Money", "Total payment amount as indicated on the financial instrument.", 0, 1, this.amount));
        children.add(new Property("paymentIdentifier", "Identifier", "Issuer's unique identifier for the payment instrument.", 0, 1, this.paymentIdentifier));
        children.add(new Property("allocation", "", "Distribution of the payment amount for a previously acknowledged payable.", 0, Integer.MAX_VALUE, this.allocation));
        children.add(new Property("formCode", "CodeableConcept", "A code for the form to be used for printing the content.", 0, 1, this.formCode));
        children.add(new Property("processNote", "", "A note that describes or explains the processing in a human readable form.", 0, Integer.MAX_VALUE, this.processNote));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A unique identifier assigned to this payment reconciliation.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 3575610: {
                return new Property("type", "CodeableConcept", "Code to indicate the nature of the payment such as payment, adjustment.", 0, 1, this.type);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the resource instance.", 0, 1, this.status);
            }
            case 3292052: {
                return new Property("kind", "CodeableConcept", "The workflow or activity which gave rise to or during which the payment ocurred such as a kiosk, deposit on account, periodic payment etc.", 0, 1, this.kind);
            }
            case -991726143: {
                return new Property("period", "Period", "The period of time for which payments have been gathered into this bulk payment for settlement.", 0, 1, this.period);
            }
            case 1028554472: {
                return new Property(SP_CREATED, "dateTime", "The date when the resource was created.", 0, 1, this.created);
            }
            case -1591951995: {
                return new Property("enterer", "Reference(Practitioner|PractitionerRole|Organization)", "Payment enterer if not the actual payment issuer.", 0, 1, this.enterer);
            }
            case 1459974547: {
                return new Property("issuerType", "CodeableConcept", "The type of the source such as patient or insurance.", 0, 1, this.issuerType);
            }
            case 1144026207: {
                return new Property("paymentIssuer", "Reference(Organization|Patient|Person|RelatedPerson)", "The party who generated the payment.", 0, 1, this.paymentIssuer);
            }
            case 1095692943: {
                return new Property(SP_REQUEST, "Reference(Task)", "Original request resource reference.", 0, 1, this.request);
            }
            case 693934258: {
                return new Property(SP_REQUESTOR, "Reference(Practitioner|PractitionerRole|Organization)", "The practitioner who is responsible for the services rendered to the patient.", 0, 1, this.requestor);
            }
            case -1106507950: {
                return new Property(SP_OUTCOME, "code", "The outcome of a request for a reconciliation.", 0, 1, this.outcome);
            }
            case 583380919: {
                return new Property(SP_DISPOSITION, "string", "A human readable description of the status of the request for the reconciliation.", 0, 1, this.disposition);
            }
            case 3076014: {
                return new Property("date", "date", "The date of payment as indicated on the financial instrument.", 0, 1, this.date);
            }
            case 1901043637: {
                return new Property("location", "Reference(Location)", "The location of the site or device for electronic transfers or physical location for cash payments.", 0, 1, this.location);
            }
            case -1077554975: {
                return new Property("method", "CodeableConcept", "The means of payment such as check, card cash, or electronic funds transfer.", 0, 1, this.method);
            }
            case -271889833: {
                return new Property("cardBrand", "string", "The card brand such as debit, Visa, Amex etc. used if a card is the method of payment.", 0, 1, this.cardBrand);
            }
            case -1011205162: {
                return new Property("accountNumber", "string", "A portion of the account number, often the last 4 digits, used for verification not charging purposes.", 0, 1, this.accountNumber);
            }
            case -668811523: {
                return new Property("expirationDate", "date", "The year and month (YYYY-MM) when the instrument, typically card, expires.", 0, 1, this.expirationDate);
            }
            case -1094759278: {
                return new Property("processor", "string", "The name of the card processor, etf processor, bank for checks.", 0, 1, this.processor);
            }
            case 744563316: {
                return new Property("referenceNumber", "string", "The check number, eft reference, car processor reference.", 0, 1, this.referenceNumber);
            }
            case -1385570183: {
                return new Property("authorization", "string", "An alphanumeric issued by the processor to confirm the successful issuance of payment.", 0, 1, this.authorization);
            }
            case 1815344299: {
                return new Property("tenderedAmount", "Money", "The amount offered by the issuer, typically applies to cash when the issuer provides an amount in bank note denominations equal to or excess of the amount actually being paid.", 0, 1, this.tenderedAmount);
            }
            case -797236473: {
                return new Property("returnedAmount", "Money", "The amount returned by the receiver which is excess to the amount payable, often referred to as 'change'.", 0, 1, this.returnedAmount);
            }
            case -1413853096: {
                return new Property("amount", "Money", "Total payment amount as indicated on the financial instrument.", 0, 1, this.amount);
            }
            case 1555852111: {
                return new Property("paymentIdentifier", "Identifier", "Issuer's unique identifier for the payment instrument.", 0, 1, this.paymentIdentifier);
            }
            case -1912450848: {
                return new Property("allocation", "", "Distribution of the payment amount for a previously acknowledged payable.", 0, Integer.MAX_VALUE, this.allocation);
            }
            case 473181393: {
                return new Property("formCode", "CodeableConcept", "A code for the form to be used for printing the content.", 0, 1, this.formCode);
            }
            case 202339073: {
                return new Property("processNote", "", "A note that describes or explains the processing in a human readable form.", 0, Integer.MAX_VALUE, this.processNote);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.kind;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.period;
                }
                return baseArray;
            }
            case 1028554472: {
                Base[] baseArray;
                if (this.created == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.created;
                }
                return baseArray;
            }
            case -1591951995: {
                Base[] baseArray;
                if (this.enterer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.enterer;
                }
                return baseArray;
            }
            case 1459974547: {
                Base[] baseArray;
                if (this.issuerType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.issuerType;
                }
                return baseArray;
            }
            case 1144026207: {
                Base[] baseArray;
                if (this.paymentIssuer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.paymentIssuer;
                }
                return baseArray;
            }
            case 1095692943: {
                Base[] baseArray;
                if (this.request == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.request;
                }
                return baseArray;
            }
            case 693934258: {
                Base[] baseArray;
                if (this.requestor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.requestor;
                }
                return baseArray;
            }
            case -1106507950: {
                Base[] baseArray;
                if (this.outcome == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.outcome;
                }
                return baseArray;
            }
            case 583380919: {
                Base[] baseArray;
                if (this.disposition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.disposition;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.date;
                }
                return baseArray;
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.location;
                }
                return baseArray;
            }
            case -1077554975: {
                Base[] baseArray;
                if (this.method == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.method;
                }
                return baseArray;
            }
            case -271889833: {
                Base[] baseArray;
                if (this.cardBrand == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.cardBrand;
                }
                return baseArray;
            }
            case -1011205162: {
                Base[] baseArray;
                if (this.accountNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.accountNumber;
                }
                return baseArray;
            }
            case -668811523: {
                Base[] baseArray;
                if (this.expirationDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.expirationDate;
                }
                return baseArray;
            }
            case -1094759278: {
                Base[] baseArray;
                if (this.processor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.processor;
                }
                return baseArray;
            }
            case 744563316: {
                Base[] baseArray;
                if (this.referenceNumber == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.referenceNumber;
                }
                return baseArray;
            }
            case -1385570183: {
                Base[] baseArray;
                if (this.authorization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray22 = new Base[1];
                    baseArray = baseArray22;
                    baseArray22[0] = this.authorization;
                }
                return baseArray;
            }
            case 1815344299: {
                Base[] baseArray;
                if (this.tenderedAmount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray23 = new Base[1];
                    baseArray = baseArray23;
                    baseArray23[0] = this.tenderedAmount;
                }
                return baseArray;
            }
            case -797236473: {
                Base[] baseArray;
                if (this.returnedAmount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray24 = new Base[1];
                    baseArray = baseArray24;
                    baseArray24[0] = this.returnedAmount;
                }
                return baseArray;
            }
            case -1413853096: {
                Base[] baseArray;
                if (this.amount == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray25 = new Base[1];
                    baseArray = baseArray25;
                    baseArray25[0] = this.amount;
                }
                return baseArray;
            }
            case 1555852111: {
                Base[] baseArray;
                if (this.paymentIdentifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray26 = new Base[1];
                    baseArray = baseArray26;
                    baseArray26[0] = this.paymentIdentifier;
                }
                return baseArray;
            }
            case -1912450848: {
                return this.allocation == null ? new Base[]{} : this.allocation.toArray(new Base[this.allocation.size()]);
            }
            case 473181393: {
                Base[] baseArray;
                if (this.formCode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray27 = new Base[1];
                    baseArray = baseArray27;
                    baseArray27[0] = this.formCode;
                }
                return baseArray;
            }
            case 202339073: {
                return this.processNote == null ? new Base[]{} : this.processNote.toArray(new Base[this.processNote.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 3575610: {
                this.type = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 3292052: {
                this.kind = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 1028554472: {
                this.created = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -1591951995: {
                this.enterer = TypeConvertor.castToReference(value);
                return value;
            }
            case 1459974547: {
                this.issuerType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 1144026207: {
                this.paymentIssuer = TypeConvertor.castToReference(value);
                return value;
            }
            case 1095692943: {
                this.request = TypeConvertor.castToReference(value);
                return value;
            }
            case 693934258: {
                this.requestor = TypeConvertor.castToReference(value);
                return value;
            }
            case -1106507950: {
                value = new PaymentOutcomeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.outcome = value;
                return value;
            }
            case 583380919: {
                this.disposition = TypeConvertor.castToString(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDate(value);
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case -1077554975: {
                this.method = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -271889833: {
                this.cardBrand = TypeConvertor.castToString(value);
                return value;
            }
            case -1011205162: {
                this.accountNumber = TypeConvertor.castToString(value);
                return value;
            }
            case -668811523: {
                this.expirationDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1094759278: {
                this.processor = TypeConvertor.castToString(value);
                return value;
            }
            case 744563316: {
                this.referenceNumber = TypeConvertor.castToString(value);
                return value;
            }
            case -1385570183: {
                this.authorization = TypeConvertor.castToString(value);
                return value;
            }
            case 1815344299: {
                this.tenderedAmount = TypeConvertor.castToMoney(value);
                return value;
            }
            case -797236473: {
                this.returnedAmount = TypeConvertor.castToMoney(value);
                return value;
            }
            case -1413853096: {
                this.amount = TypeConvertor.castToMoney(value);
                return value;
            }
            case 1555852111: {
                this.paymentIdentifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case -1912450848: {
                this.getAllocation().add((PaymentReconciliationAllocationComponent)((Object)value));
                return value;
            }
            case 473181393: {
                this.formCode = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case 202339073: {
                this.getProcessNote().add((NotesComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("type")) {
            this.type = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.FinancialResourceStatusCodesEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("kind")) {
            this.kind = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_CREATED)) {
            this.created = TypeConvertor.castToDateTime(value);
        } else if (name.equals("enterer")) {
            this.enterer = TypeConvertor.castToReference(value);
        } else if (name.equals("issuerType")) {
            this.issuerType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("paymentIssuer")) {
            this.paymentIssuer = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_REQUEST)) {
            this.request = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_REQUESTOR)) {
            this.requestor = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_OUTCOME)) {
            value = new PaymentOutcomeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.outcome = value;
        } else if (name.equals(SP_DISPOSITION)) {
            this.disposition = TypeConvertor.castToString(value);
        } else if (name.equals("date")) {
            this.date = TypeConvertor.castToDate(value);
        } else if (name.equals("location")) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals("method")) {
            this.method = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("cardBrand")) {
            this.cardBrand = TypeConvertor.castToString(value);
        } else if (name.equals("accountNumber")) {
            this.accountNumber = TypeConvertor.castToString(value);
        } else if (name.equals("expirationDate")) {
            this.expirationDate = TypeConvertor.castToDate(value);
        } else if (name.equals("processor")) {
            this.processor = TypeConvertor.castToString(value);
        } else if (name.equals("referenceNumber")) {
            this.referenceNumber = TypeConvertor.castToString(value);
        } else if (name.equals("authorization")) {
            this.authorization = TypeConvertor.castToString(value);
        } else if (name.equals("tenderedAmount")) {
            this.tenderedAmount = TypeConvertor.castToMoney(value);
        } else if (name.equals("returnedAmount")) {
            this.returnedAmount = TypeConvertor.castToMoney(value);
        } else if (name.equals("amount")) {
            this.amount = TypeConvertor.castToMoney(value);
        } else if (name.equals("paymentIdentifier")) {
            this.paymentIdentifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals("allocation")) {
            this.getAllocation().add((PaymentReconciliationAllocationComponent)((Object)value));
        } else if (name.equals("formCode")) {
            this.formCode = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("processNote")) {
            this.getProcessNote().add((NotesComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 3575610: {
                return this.getType();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 3292052: {
                return this.getKind();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 1028554472: {
                return this.getCreatedElement();
            }
            case -1591951995: {
                return this.getEnterer();
            }
            case 1459974547: {
                return this.getIssuerType();
            }
            case 1144026207: {
                return this.getPaymentIssuer();
            }
            case 1095692943: {
                return this.getRequest();
            }
            case 693934258: {
                return this.getRequestor();
            }
            case -1106507950: {
                return this.getOutcomeElement();
            }
            case 583380919: {
                return this.getDispositionElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -1077554975: {
                return this.getMethod();
            }
            case -271889833: {
                return this.getCardBrandElement();
            }
            case -1011205162: {
                return this.getAccountNumberElement();
            }
            case -668811523: {
                return this.getExpirationDateElement();
            }
            case -1094759278: {
                return this.getProcessorElement();
            }
            case 744563316: {
                return this.getReferenceNumberElement();
            }
            case -1385570183: {
                return this.getAuthorizationElement();
            }
            case 1815344299: {
                return this.getTenderedAmount();
            }
            case -797236473: {
                return this.getReturnedAmount();
            }
            case -1413853096: {
                return this.getAmount();
            }
            case 1555852111: {
                return this.getPaymentIdentifier();
            }
            case -1912450848: {
                return this.addAllocation();
            }
            case 473181393: {
                return this.getFormCode();
            }
            case 202339073: {
                return this.addProcessNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 3292052: {
                return new String[]{"CodeableConcept"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 1028554472: {
                return new String[]{"dateTime"};
            }
            case -1591951995: {
                return new String[]{"Reference"};
            }
            case 1459974547: {
                return new String[]{"CodeableConcept"};
            }
            case 1144026207: {
                return new String[]{"Reference"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case 693934258: {
                return new String[]{"Reference"};
            }
            case -1106507950: {
                return new String[]{"code"};
            }
            case 583380919: {
                return new String[]{"string"};
            }
            case 3076014: {
                return new String[]{"date"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case -1077554975: {
                return new String[]{"CodeableConcept"};
            }
            case -271889833: {
                return new String[]{"string"};
            }
            case -1011205162: {
                return new String[]{"string"};
            }
            case -668811523: {
                return new String[]{"date"};
            }
            case -1094759278: {
                return new String[]{"string"};
            }
            case 744563316: {
                return new String[]{"string"};
            }
            case -1385570183: {
                return new String[]{"string"};
            }
            case 1815344299: {
                return new String[]{"Money"};
            }
            case -797236473: {
                return new String[]{"Money"};
            }
            case -1413853096: {
                return new String[]{"Money"};
            }
            case 1555852111: {
                return new String[]{"Identifier"};
            }
            case -1912450848: {
                return new String[0];
            }
            case 473181393: {
                return new String[]{"CodeableConcept"};
            }
            case 202339073: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.status");
        }
        if (name.equals("kind")) {
            this.kind = new CodeableConcept();
            return this.kind;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_CREATED)) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.created");
        }
        if (name.equals("enterer")) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals("issuerType")) {
            this.issuerType = new CodeableConcept();
            return this.issuerType;
        }
        if (name.equals("paymentIssuer")) {
            this.paymentIssuer = new Reference();
            return this.paymentIssuer;
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_REQUESTOR)) {
            this.requestor = new Reference();
            return this.requestor;
        }
        if (name.equals(SP_OUTCOME)) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.outcome");
        }
        if (name.equals(SP_DISPOSITION)) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.disposition");
        }
        if (name.equals("date")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.date");
        }
        if (name.equals("location")) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals("method")) {
            this.method = new CodeableConcept();
            return this.method;
        }
        if (name.equals("cardBrand")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.cardBrand");
        }
        if (name.equals("accountNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.accountNumber");
        }
        if (name.equals("expirationDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.expirationDate");
        }
        if (name.equals("processor")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.processor");
        }
        if (name.equals("referenceNumber")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.referenceNumber");
        }
        if (name.equals("authorization")) {
            throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.authorization");
        }
        if (name.equals("tenderedAmount")) {
            this.tenderedAmount = new Money();
            return this.tenderedAmount;
        }
        if (name.equals("returnedAmount")) {
            this.returnedAmount = new Money();
            return this.returnedAmount;
        }
        if (name.equals("amount")) {
            this.amount = new Money();
            return this.amount;
        }
        if (name.equals("paymentIdentifier")) {
            this.paymentIdentifier = new Identifier();
            return this.paymentIdentifier;
        }
        if (name.equals("allocation")) {
            return this.addAllocation();
        }
        if (name.equals("formCode")) {
            this.formCode = new CodeableConcept();
            return this.formCode;
        }
        if (name.equals("processNote")) {
            return this.addProcessNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "PaymentReconciliation";
    }

    @Override
    public PaymentReconciliation copy() {
        PaymentReconciliation dst = new PaymentReconciliation();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(PaymentReconciliation dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.kind = this.kind == null ? null : this.kind.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        dst.issuerType = this.issuerType == null ? null : this.issuerType.copy();
        dst.paymentIssuer = this.paymentIssuer == null ? null : this.paymentIssuer.copy();
        dst.request = this.request == null ? null : this.request.copy();
        dst.requestor = this.requestor == null ? null : this.requestor.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.location = this.location == null ? null : this.location.copy();
        dst.method = this.method == null ? null : this.method.copy();
        dst.cardBrand = this.cardBrand == null ? null : this.cardBrand.copy();
        dst.accountNumber = this.accountNumber == null ? null : this.accountNumber.copy();
        dst.expirationDate = this.expirationDate == null ? null : this.expirationDate.copy();
        dst.processor = this.processor == null ? null : this.processor.copy();
        dst.referenceNumber = this.referenceNumber == null ? null : this.referenceNumber.copy();
        dst.authorization = this.authorization == null ? null : this.authorization.copy();
        dst.tenderedAmount = this.tenderedAmount == null ? null : this.tenderedAmount.copy();
        dst.returnedAmount = this.returnedAmount == null ? null : this.returnedAmount.copy();
        dst.amount = this.amount == null ? null : this.amount.copy();
        Identifier identifier = dst.paymentIdentifier = this.paymentIdentifier == null ? null : this.paymentIdentifier.copy();
        if (this.allocation != null) {
            dst.allocation = new ArrayList<PaymentReconciliationAllocationComponent>();
            for (PaymentReconciliationAllocationComponent paymentReconciliationAllocationComponent : this.allocation) {
                dst.allocation.add(paymentReconciliationAllocationComponent.copy());
            }
        }
        CodeableConcept codeableConcept = dst.formCode = this.formCode == null ? null : this.formCode.copy();
        if (this.processNote != null) {
            dst.processNote = new ArrayList<NotesComponent>();
            for (NotesComponent notesComponent : this.processNote) {
                dst.processNote.add(notesComponent.copy());
            }
        }
    }

    protected PaymentReconciliation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof PaymentReconciliation)) {
            return false;
        }
        PaymentReconciliation o = (PaymentReconciliation)other_;
        return PaymentReconciliation.compareDeep(this.identifier, o.identifier, true) && PaymentReconciliation.compareDeep(this.type, o.type, true) && PaymentReconciliation.compareDeep(this.status, o.status, true) && PaymentReconciliation.compareDeep(this.kind, o.kind, true) && PaymentReconciliation.compareDeep(this.period, o.period, true) && PaymentReconciliation.compareDeep(this.created, o.created, true) && PaymentReconciliation.compareDeep(this.enterer, o.enterer, true) && PaymentReconciliation.compareDeep(this.issuerType, o.issuerType, true) && PaymentReconciliation.compareDeep(this.paymentIssuer, o.paymentIssuer, true) && PaymentReconciliation.compareDeep(this.request, o.request, true) && PaymentReconciliation.compareDeep(this.requestor, o.requestor, true) && PaymentReconciliation.compareDeep(this.outcome, o.outcome, true) && PaymentReconciliation.compareDeep(this.disposition, o.disposition, true) && PaymentReconciliation.compareDeep(this.date, o.date, true) && PaymentReconciliation.compareDeep(this.location, o.location, true) && PaymentReconciliation.compareDeep(this.method, o.method, true) && PaymentReconciliation.compareDeep(this.cardBrand, o.cardBrand, true) && PaymentReconciliation.compareDeep(this.accountNumber, o.accountNumber, true) && PaymentReconciliation.compareDeep(this.expirationDate, o.expirationDate, true) && PaymentReconciliation.compareDeep(this.processor, o.processor, true) && PaymentReconciliation.compareDeep(this.referenceNumber, o.referenceNumber, true) && PaymentReconciliation.compareDeep(this.authorization, o.authorization, true) && PaymentReconciliation.compareDeep(this.tenderedAmount, o.tenderedAmount, true) && PaymentReconciliation.compareDeep(this.returnedAmount, o.returnedAmount, true) && PaymentReconciliation.compareDeep(this.amount, o.amount, true) && PaymentReconciliation.compareDeep(this.paymentIdentifier, o.paymentIdentifier, true) && PaymentReconciliation.compareDeep(this.allocation, o.allocation, true) && PaymentReconciliation.compareDeep(this.formCode, o.formCode, true) && PaymentReconciliation.compareDeep(this.processNote, o.processNote, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof PaymentReconciliation)) {
            return false;
        }
        PaymentReconciliation o = (PaymentReconciliation)other_;
        return PaymentReconciliation.compareValues(this.status, o.status, true) && PaymentReconciliation.compareValues(this.created, o.created, true) && PaymentReconciliation.compareValues(this.outcome, o.outcome, true) && PaymentReconciliation.compareValues(this.disposition, o.disposition, true) && PaymentReconciliation.compareValues(this.date, o.date, true) && PaymentReconciliation.compareValues(this.cardBrand, o.cardBrand, true) && PaymentReconciliation.compareValues(this.accountNumber, o.accountNumber, true) && PaymentReconciliation.compareValues(this.expirationDate, o.expirationDate, true) && PaymentReconciliation.compareValues(this.processor, o.processor, true) && PaymentReconciliation.compareValues(this.referenceNumber, o.referenceNumber, true) && PaymentReconciliation.compareValues(this.authorization, o.authorization, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.status, this.kind, this.period, this.created, this.enterer, this.issuerType, this.paymentIssuer, this.request, this.requestor, this.outcome, this.disposition, this.date, this.location, this.method, this.cardBrand, this.accountNumber, this.expirationDate, this.processor, this.referenceNumber, this.authorization, this.tenderedAmount, this.returnedAmount, this.amount, this.paymentIdentifier, this.allocation, this.formCode, this.processNote});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.PaymentReconciliation;
    }

    @Block
    public static class NotesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="display | print | printoper", formalDefinition="The business purpose of the note text.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/note-type")
        protected Enumeration<Enumerations.NoteType> type;
        @Child(name="text", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Note explanatory text", formalDefinition="The explanation or description associated with the processing.")
        protected StringType text;
        private static final long serialVersionUID = 529250161L;

        public Enumeration<Enumerations.NoteType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<Enumerations.NoteType>(new Enumerations.NoteTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NotesComponent setTypeElement(Enumeration<Enumerations.NoteType> value) {
            this.type = value;
            return this;
        }

        public Enumerations.NoteType getType() {
            return this.type == null ? null : (Enumerations.NoteType)((Object)this.type.getValue());
        }

        public NotesComponent setType(Enumerations.NoteType value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<Enumerations.NoteType>(new Enumerations.NoteTypeEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public NotesComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public NotesComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "The business purpose of the note text.", 0, 1, this.type));
            children.add(new Property("text", "string", "The explanation or description associated with the processing.", 0, 1, this.text));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "The business purpose of the note text.", 0, 1, this.type);
                }
                case 3556653: {
                    return new Property("text", "string", "The explanation or description associated with the processing.", 0, 1, this.text);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 3556653: {
                    Base[] baseArray;
                    if (this.text == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.text;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new Enumerations.NoteTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 3556653: {
                    this.text = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new Enumerations.NoteTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
            } else if (name.equals("text")) {
                this.text = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 3556653: {
                    return this.getTextElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 3556653: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.processNote.type");
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.processNote.text");
            }
            return super.addChild(name);
        }

        @Override
        public NotesComponent copy() {
            NotesComponent dst = new NotesComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(NotesComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.text = this.text == null ? null : this.text.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof NotesComponent)) {
                return false;
            }
            NotesComponent o = (NotesComponent)other_;
            return NotesComponent.compareDeep(this.type, o.type, true) && NotesComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof NotesComponent)) {
                return false;
            }
            NotesComponent o = (NotesComponent)other_;
            return NotesComponent.compareValues(this.type, o.type, true) && NotesComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.type, this.text});
        }

        @Override
        public String fhirType() {
            return "PaymentReconciliation.processNote";
        }
    }

    @Block
    public static class PaymentReconciliationAllocationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Business identifier of the payment detail", formalDefinition="Unique identifier for the current payment item for the referenced payable.")
        protected Identifier identifier;
        @Child(name="predecessor", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Business identifier of the prior payment detail", formalDefinition="Unique identifier for the prior payment item for the referenced payable.")
        protected Identifier predecessor;
        @Child(name="target", type={Claim.class, Account.class, Invoice.class, ChargeItem.class, Encounter.class, Contract.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Subject of the payment", formalDefinition="Specific resource to which the payment/adjustment/advance applies.")
        protected Reference target;
        @Child(name="targetItem", type={StringType.class, Identifier.class, PositiveIntType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Sub-element of the subject", formalDefinition=" Identifies the claim line item, encounter or other sub-element being paid. Note payment may be partial, that is not match the then outstanding balance or amount incurred.")
        protected DataType targetItem;
        @Child(name="encounter", type={Encounter.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Applied-to encounter", formalDefinition="The Encounter to which this payment applies, may be completed by the receiver, used for search.")
        protected Reference encounter;
        @Child(name="account", type={Account.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Applied-to account", formalDefinition="The Account to which this payment applies, may be completed by the receiver, used for search.")
        protected Reference account;
        @Child(name="type", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category of payment", formalDefinition="Code to indicate the nature of the payment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/payment-type")
        protected CodeableConcept type;
        @Child(name="submitter", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Submitter of the request", formalDefinition="The party which submitted the claim or financial transaction.")
        protected Reference submitter;
        @Child(name="response", type={ClaimResponse.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Response committing to a payment", formalDefinition="A resource, such as a ClaimResponse, which contains a commitment to payment.")
        protected Reference response;
        @Child(name="date", type={DateType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Date of commitment to pay", formalDefinition="The date from the response resource containing a commitment to pay.")
        protected DateType date;
        @Child(name="responsible", type={PractitionerRole.class}, order=11, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contact for the response", formalDefinition="A reference to the individual who is responsible for inquiries regarding the response and its payment.")
        protected Reference responsible;
        @Child(name="payee", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=12, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Recipient of the payment", formalDefinition="The party which is receiving the payment.")
        protected Reference payee;
        @Child(name="amount", type={Money.class}, order=13, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Amount allocated to this payable", formalDefinition="The monetary amount allocated from the total payment to the payable.")
        protected Money amount;
        private static final long serialVersionUID = -1153705409L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentReconciliationAllocationComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public Identifier getPredecessor() {
            if (this.predecessor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentReconciliationAllocationComponent.predecessor");
                }
                if (Configuration.doAutoCreate()) {
                    this.predecessor = new Identifier();
                }
            }
            return this.predecessor;
        }

        public boolean hasPredecessor() {
            return this.predecessor != null && !this.predecessor.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setPredecessor(Identifier value) {
            this.predecessor = value;
            return this;
        }

        public Reference getTarget() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentReconciliationAllocationComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new Reference();
                }
            }
            return this.target;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setTarget(Reference value) {
            this.target = value;
            return this;
        }

        public DataType getTargetItem() {
            return this.targetItem;
        }

        public StringType getTargetItemStringType() throws FHIRException {
            if (this.targetItem == null) {
                this.targetItem = new StringType();
            }
            if (!(this.targetItem instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.targetItem.getClass().getName() + " was encountered");
            }
            return (StringType)this.targetItem;
        }

        public boolean hasTargetItemStringType() {
            return this != null && this.targetItem instanceof StringType;
        }

        public Identifier getTargetItemIdentifier() throws FHIRException {
            if (this.targetItem == null) {
                this.targetItem = new Identifier();
            }
            if (!(this.targetItem instanceof Identifier)) {
                throw new FHIRException("Type mismatch: the type Identifier was expected, but " + this.targetItem.getClass().getName() + " was encountered");
            }
            return (Identifier)this.targetItem;
        }

        public boolean hasTargetItemIdentifier() {
            return this != null && this.targetItem instanceof Identifier;
        }

        public PositiveIntType getTargetItemPositiveIntType() throws FHIRException {
            if (this.targetItem == null) {
                this.targetItem = new PositiveIntType();
            }
            if (!(this.targetItem instanceof PositiveIntType)) {
                throw new FHIRException("Type mismatch: the type PositiveIntType was expected, but " + this.targetItem.getClass().getName() + " was encountered");
            }
            return (PositiveIntType)this.targetItem;
        }

        public boolean hasTargetItemPositiveIntType() {
            return this != null && this.targetItem instanceof PositiveIntType;
        }

        public boolean hasTargetItem() {
            return this.targetItem != null && !this.targetItem.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setTargetItem(DataType value) {
            if (!(value == null || value instanceof StringType || value instanceof Identifier || value instanceof PositiveIntType)) {
                throw new Error("Not the right type for PaymentReconciliation.allocation.targetItem[x]: " + value.fhirType());
            }
            this.targetItem = value;
            return this;
        }

        public Reference getEncounter() {
            if (this.encounter == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentReconciliationAllocationComponent.encounter");
                }
                if (Configuration.doAutoCreate()) {
                    this.encounter = new Reference();
                }
            }
            return this.encounter;
        }

        public boolean hasEncounter() {
            return this.encounter != null && !this.encounter.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setEncounter(Reference value) {
            this.encounter = value;
            return this;
        }

        public Reference getAccount() {
            if (this.account == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentReconciliationAllocationComponent.account");
                }
                if (Configuration.doAutoCreate()) {
                    this.account = new Reference();
                }
            }
            return this.account;
        }

        public boolean hasAccount() {
            return this.account != null && !this.account.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setAccount(Reference value) {
            this.account = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentReconciliationAllocationComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Reference getSubmitter() {
            if (this.submitter == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentReconciliationAllocationComponent.submitter");
                }
                if (Configuration.doAutoCreate()) {
                    this.submitter = new Reference();
                }
            }
            return this.submitter;
        }

        public boolean hasSubmitter() {
            return this.submitter != null && !this.submitter.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setSubmitter(Reference value) {
            this.submitter = value;
            return this;
        }

        public Reference getResponse() {
            if (this.response == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentReconciliationAllocationComponent.response");
                }
                if (Configuration.doAutoCreate()) {
                    this.response = new Reference();
                }
            }
            return this.response;
        }

        public boolean hasResponse() {
            return this.response != null && !this.response.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setResponse(Reference value) {
            this.response = value;
            return this;
        }

        public DateType getDateElement() {
            if (this.date == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentReconciliationAllocationComponent.date");
                }
                if (Configuration.doAutoCreate()) {
                    this.date = new DateType();
                }
            }
            return this.date;
        }

        public boolean hasDateElement() {
            return this.date != null && !this.date.isEmpty();
        }

        public boolean hasDate() {
            return this.date != null && !this.date.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setDateElement(DateType value) {
            this.date = value;
            return this;
        }

        public Date getDate() {
            return this.date == null ? null : (Date)this.date.getValue();
        }

        public PaymentReconciliationAllocationComponent setDate(Date value) {
            if (value == null) {
                this.date = null;
            } else {
                if (this.date == null) {
                    this.date = new DateType();
                }
                this.date.setValue(value);
            }
            return this;
        }

        public Reference getResponsible() {
            if (this.responsible == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentReconciliationAllocationComponent.responsible");
                }
                if (Configuration.doAutoCreate()) {
                    this.responsible = new Reference();
                }
            }
            return this.responsible;
        }

        public boolean hasResponsible() {
            return this.responsible != null && !this.responsible.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setResponsible(Reference value) {
            this.responsible = value;
            return this;
        }

        public Reference getPayee() {
            if (this.payee == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentReconciliationAllocationComponent.payee");
                }
                if (Configuration.doAutoCreate()) {
                    this.payee = new Reference();
                }
            }
            return this.payee;
        }

        public boolean hasPayee() {
            return this.payee != null && !this.payee.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setPayee(Reference value) {
            this.payee = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PaymentReconciliationAllocationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public PaymentReconciliationAllocationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(PaymentReconciliation.SP_IDENTIFIER, "Identifier", "Unique identifier for the current payment item for the referenced payable.", 0, 1, this.identifier));
            children.add(new Property("predecessor", "Identifier", "Unique identifier for the prior payment item for the referenced payable.", 0, 1, this.predecessor));
            children.add(new Property("target", "Reference(Claim|Account|Invoice|ChargeItem|Encounter|Contract)", "Specific resource to which the payment/adjustment/advance applies.", 0, 1, this.target));
            children.add(new Property("targetItem[x]", "string|Identifier|positiveInt", " Identifies the claim line item, encounter or other sub-element being paid. Note payment may be partial, that is not match the then outstanding balance or amount incurred.", 0, 1, this.targetItem));
            children.add(new Property("encounter", "Reference(Encounter)", "The Encounter to which this payment applies, may be completed by the receiver, used for search.", 0, 1, this.encounter));
            children.add(new Property("account", "Reference(Account)", "The Account to which this payment applies, may be completed by the receiver, used for search.", 0, 1, this.account));
            children.add(new Property("type", "CodeableConcept", "Code to indicate the nature of the payment.", 0, 1, this.type));
            children.add(new Property("submitter", "Reference(Practitioner|PractitionerRole|Organization)", "The party which submitted the claim or financial transaction.", 0, 1, this.submitter));
            children.add(new Property("response", "Reference(ClaimResponse)", "A resource, such as a ClaimResponse, which contains a commitment to payment.", 0, 1, this.response));
            children.add(new Property("date", "date", "The date from the response resource containing a commitment to pay.", 0, 1, this.date));
            children.add(new Property("responsible", "Reference(PractitionerRole)", "A reference to the individual who is responsible for inquiries regarding the response and its payment.", 0, 1, this.responsible));
            children.add(new Property("payee", "Reference(Practitioner|PractitionerRole|Organization)", "The party which is receiving the payment.", 0, 1, this.payee));
            children.add(new Property("amount", "Money", "The monetary amount allocated from the total payment to the payable.", 0, 1, this.amount));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1618432855: {
                    return new Property(PaymentReconciliation.SP_IDENTIFIER, "Identifier", "Unique identifier for the current payment item for the referenced payable.", 0, 1, this.identifier);
                }
                case -1925032183: {
                    return new Property("predecessor", "Identifier", "Unique identifier for the prior payment item for the referenced payable.", 0, 1, this.predecessor);
                }
                case -880905839: {
                    return new Property("target", "Reference(Claim|Account|Invoice|ChargeItem|Encounter|Contract)", "Specific resource to which the payment/adjustment/advance applies.", 0, 1, this.target);
                }
                case 125181372: {
                    return new Property("targetItem[x]", "string|Identifier|positiveInt", " Identifies the claim line item, encounter or other sub-element being paid. Note payment may be partial, that is not match the then outstanding balance or amount incurred.", 0, 1, this.targetItem);
                }
                case 486289476: {
                    return new Property("targetItem[x]", "string|Identifier|positiveInt", " Identifies the claim line item, encounter or other sub-element being paid. Note payment may be partial, that is not match the then outstanding balance or amount incurred.", 0, 1, this.targetItem);
                }
                case 1014643061: {
                    return new Property("targetItem[x]", "string", " Identifies the claim line item, encounter or other sub-element being paid. Note payment may be partial, that is not match the then outstanding balance or amount incurred.", 0, 1, this.targetItem);
                }
                case -1768279027: {
                    return new Property("targetItem[x]", "Identifier", " Identifies the claim line item, encounter or other sub-element being paid. Note payment may be partial, that is not match the then outstanding balance or amount incurred.", 0, 1, this.targetItem);
                }
                case -481526702: {
                    return new Property("targetItem[x]", "positiveInt", " Identifies the claim line item, encounter or other sub-element being paid. Note payment may be partial, that is not match the then outstanding balance or amount incurred.", 0, 1, this.targetItem);
                }
                case 1524132147: {
                    return new Property("encounter", "Reference(Encounter)", "The Encounter to which this payment applies, may be completed by the receiver, used for search.", 0, 1, this.encounter);
                }
                case -1177318867: {
                    return new Property("account", "Reference(Account)", "The Account to which this payment applies, may be completed by the receiver, used for search.", 0, 1, this.account);
                }
                case 3575610: {
                    return new Property("type", "CodeableConcept", "Code to indicate the nature of the payment.", 0, 1, this.type);
                }
                case 348678409: {
                    return new Property("submitter", "Reference(Practitioner|PractitionerRole|Organization)", "The party which submitted the claim or financial transaction.", 0, 1, this.submitter);
                }
                case -340323263: {
                    return new Property("response", "Reference(ClaimResponse)", "A resource, such as a ClaimResponse, which contains a commitment to payment.", 0, 1, this.response);
                }
                case 3076014: {
                    return new Property("date", "date", "The date from the response resource containing a commitment to pay.", 0, 1, this.date);
                }
                case 1847674614: {
                    return new Property("responsible", "Reference(PractitionerRole)", "A reference to the individual who is responsible for inquiries regarding the response and its payment.", 0, 1, this.responsible);
                }
                case 106443592: {
                    return new Property("payee", "Reference(Practitioner|PractitionerRole|Organization)", "The party which is receiving the payment.", 0, 1, this.payee);
                }
                case -1413853096: {
                    return new Property("amount", "Money", "The monetary amount allocated from the total payment to the payable.", 0, 1, this.amount);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    Base[] baseArray;
                    if (this.identifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identifier;
                    }
                    return baseArray;
                }
                case -1925032183: {
                    Base[] baseArray;
                    if (this.predecessor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.predecessor;
                    }
                    return baseArray;
                }
                case -880905839: {
                    Base[] baseArray;
                    if (this.target == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.target;
                    }
                    return baseArray;
                }
                case 486289476: {
                    Base[] baseArray;
                    if (this.targetItem == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.targetItem;
                    }
                    return baseArray;
                }
                case 1524132147: {
                    Base[] baseArray;
                    if (this.encounter == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.encounter;
                    }
                    return baseArray;
                }
                case -1177318867: {
                    Base[] baseArray;
                    if (this.account == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.account;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.type;
                    }
                    return baseArray;
                }
                case 348678409: {
                    Base[] baseArray;
                    if (this.submitter == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.submitter;
                    }
                    return baseArray;
                }
                case -340323263: {
                    Base[] baseArray;
                    if (this.response == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.response;
                    }
                    return baseArray;
                }
                case 3076014: {
                    Base[] baseArray;
                    if (this.date == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.date;
                    }
                    return baseArray;
                }
                case 1847674614: {
                    Base[] baseArray;
                    if (this.responsible == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray12 = new Base[1];
                        baseArray = baseArray12;
                        baseArray12[0] = this.responsible;
                    }
                    return baseArray;
                }
                case 106443592: {
                    Base[] baseArray;
                    if (this.payee == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray13 = new Base[1];
                        baseArray = baseArray13;
                        baseArray13[0] = this.payee;
                    }
                    return baseArray;
                }
                case -1413853096: {
                    Base[] baseArray;
                    if (this.amount == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray14 = new Base[1];
                        baseArray = baseArray14;
                        baseArray14[0] = this.amount;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    this.identifier = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case -1925032183: {
                    this.predecessor = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case -880905839: {
                    this.target = TypeConvertor.castToReference(value);
                    return value;
                }
                case 486289476: {
                    this.targetItem = TypeConvertor.castToType(value);
                    return value;
                }
                case 1524132147: {
                    this.encounter = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1177318867: {
                    this.account = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 348678409: {
                    this.submitter = TypeConvertor.castToReference(value);
                    return value;
                }
                case -340323263: {
                    this.response = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3076014: {
                    this.date = TypeConvertor.castToDate(value);
                    return value;
                }
                case 1847674614: {
                    this.responsible = TypeConvertor.castToReference(value);
                    return value;
                }
                case 106443592: {
                    this.payee = TypeConvertor.castToReference(value);
                    return value;
                }
                case -1413853096: {
                    this.amount = TypeConvertor.castToMoney(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(PaymentReconciliation.SP_IDENTIFIER)) {
                this.identifier = TypeConvertor.castToIdentifier(value);
            } else if (name.equals("predecessor")) {
                this.predecessor = TypeConvertor.castToIdentifier(value);
            } else if (name.equals("target")) {
                this.target = TypeConvertor.castToReference(value);
            } else if (name.equals("targetItem[x]")) {
                this.targetItem = TypeConvertor.castToType(value);
            } else if (name.equals("encounter")) {
                this.encounter = TypeConvertor.castToReference(value);
            } else if (name.equals("account")) {
                this.account = TypeConvertor.castToReference(value);
            } else if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("submitter")) {
                this.submitter = TypeConvertor.castToReference(value);
            } else if (name.equals("response")) {
                this.response = TypeConvertor.castToReference(value);
            } else if (name.equals("date")) {
                this.date = TypeConvertor.castToDate(value);
            } else if (name.equals("responsible")) {
                this.responsible = TypeConvertor.castToReference(value);
            } else if (name.equals("payee")) {
                this.payee = TypeConvertor.castToReference(value);
            } else if (name.equals("amount")) {
                this.amount = TypeConvertor.castToMoney(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return this.getIdentifier();
                }
                case -1925032183: {
                    return this.getPredecessor();
                }
                case -880905839: {
                    return this.getTarget();
                }
                case 125181372: {
                    return this.getTargetItem();
                }
                case 486289476: {
                    return this.getTargetItem();
                }
                case 1524132147: {
                    return this.getEncounter();
                }
                case -1177318867: {
                    return this.getAccount();
                }
                case 3575610: {
                    return this.getType();
                }
                case 348678409: {
                    return this.getSubmitter();
                }
                case -340323263: {
                    return this.getResponse();
                }
                case 3076014: {
                    return this.getDateElement();
                }
                case 1847674614: {
                    return this.getResponsible();
                }
                case 106443592: {
                    return this.getPayee();
                }
                case -1413853096: {
                    return this.getAmount();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1618432855: {
                    return new String[]{"Identifier"};
                }
                case -1925032183: {
                    return new String[]{"Identifier"};
                }
                case -880905839: {
                    return new String[]{"Reference"};
                }
                case 486289476: {
                    return new String[]{"string", "Identifier", "positiveInt"};
                }
                case 1524132147: {
                    return new String[]{"Reference"};
                }
                case -1177318867: {
                    return new String[]{"Reference"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 348678409: {
                    return new String[]{"Reference"};
                }
                case -340323263: {
                    return new String[]{"Reference"};
                }
                case 3076014: {
                    return new String[]{"date"};
                }
                case 1847674614: {
                    return new String[]{"Reference"};
                }
                case 106443592: {
                    return new String[]{"Reference"};
                }
                case -1413853096: {
                    return new String[]{"Money"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(PaymentReconciliation.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("predecessor")) {
                this.predecessor = new Identifier();
                return this.predecessor;
            }
            if (name.equals("target")) {
                this.target = new Reference();
                return this.target;
            }
            if (name.equals("targetItemString")) {
                this.targetItem = new StringType();
                return this.targetItem;
            }
            if (name.equals("targetItemIdentifier")) {
                this.targetItem = new Identifier();
                return this.targetItem;
            }
            if (name.equals("targetItemPositiveInt")) {
                this.targetItem = new PositiveIntType();
                return this.targetItem;
            }
            if (name.equals("encounter")) {
                this.encounter = new Reference();
                return this.encounter;
            }
            if (name.equals("account")) {
                this.account = new Reference();
                return this.account;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("submitter")) {
                this.submitter = new Reference();
                return this.submitter;
            }
            if (name.equals("response")) {
                this.response = new Reference();
                return this.response;
            }
            if (name.equals("date")) {
                throw new FHIRException("Cannot call addChild on a primitive type PaymentReconciliation.allocation.date");
            }
            if (name.equals("responsible")) {
                this.responsible = new Reference();
                return this.responsible;
            }
            if (name.equals("payee")) {
                this.payee = new Reference();
                return this.payee;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            return super.addChild(name);
        }

        @Override
        public PaymentReconciliationAllocationComponent copy() {
            PaymentReconciliationAllocationComponent dst = new PaymentReconciliationAllocationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(PaymentReconciliationAllocationComponent dst) {
            super.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.predecessor = this.predecessor == null ? null : this.predecessor.copy();
            dst.target = this.target == null ? null : this.target.copy();
            dst.targetItem = this.targetItem == null ? null : this.targetItem.copy();
            dst.encounter = this.encounter == null ? null : this.encounter.copy();
            dst.account = this.account == null ? null : this.account.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.submitter = this.submitter == null ? null : this.submitter.copy();
            dst.response = this.response == null ? null : this.response.copy();
            dst.date = this.date == null ? null : this.date.copy();
            dst.responsible = this.responsible == null ? null : this.responsible.copy();
            dst.payee = this.payee == null ? null : this.payee.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof PaymentReconciliationAllocationComponent)) {
                return false;
            }
            PaymentReconciliationAllocationComponent o = (PaymentReconciliationAllocationComponent)other_;
            return PaymentReconciliationAllocationComponent.compareDeep(this.identifier, o.identifier, true) && PaymentReconciliationAllocationComponent.compareDeep(this.predecessor, o.predecessor, true) && PaymentReconciliationAllocationComponent.compareDeep(this.target, o.target, true) && PaymentReconciliationAllocationComponent.compareDeep(this.targetItem, o.targetItem, true) && PaymentReconciliationAllocationComponent.compareDeep(this.encounter, o.encounter, true) && PaymentReconciliationAllocationComponent.compareDeep(this.account, o.account, true) && PaymentReconciliationAllocationComponent.compareDeep(this.type, o.type, true) && PaymentReconciliationAllocationComponent.compareDeep(this.submitter, o.submitter, true) && PaymentReconciliationAllocationComponent.compareDeep(this.response, o.response, true) && PaymentReconciliationAllocationComponent.compareDeep(this.date, o.date, true) && PaymentReconciliationAllocationComponent.compareDeep(this.responsible, o.responsible, true) && PaymentReconciliationAllocationComponent.compareDeep(this.payee, o.payee, true) && PaymentReconciliationAllocationComponent.compareDeep(this.amount, o.amount, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof PaymentReconciliationAllocationComponent)) {
                return false;
            }
            PaymentReconciliationAllocationComponent o = (PaymentReconciliationAllocationComponent)other_;
            return PaymentReconciliationAllocationComponent.compareValues(this.date, o.date, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.identifier, this.predecessor, this.target, this.targetItem, this.encounter, this.account, this.type, this.submitter, this.response, this.date, this.responsible, this.payee, this.amount});
        }

        @Override
        public String fhirType() {
            return "PaymentReconciliation.allocation";
        }
    }

    public static class PaymentOutcomeEnumFactory
    implements EnumFactory<PaymentOutcome> {
        @Override
        public PaymentOutcome fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("queued".equals(codeString)) {
                return PaymentOutcome.QUEUED;
            }
            if ("complete".equals(codeString)) {
                return PaymentOutcome.COMPLETE;
            }
            if ("error".equals(codeString)) {
                return PaymentOutcome.ERROR;
            }
            if ("partial".equals(codeString)) {
                return PaymentOutcome.PARTIAL;
            }
            throw new IllegalArgumentException("Unknown PaymentOutcome code '" + codeString + "'");
        }

        public Enumeration<PaymentOutcome> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<PaymentOutcome>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("queued".equals(codeString)) {
                return new Enumeration<PaymentOutcome>(this, PaymentOutcome.QUEUED);
            }
            if ("complete".equals(codeString)) {
                return new Enumeration<PaymentOutcome>(this, PaymentOutcome.COMPLETE);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<PaymentOutcome>(this, PaymentOutcome.ERROR);
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<PaymentOutcome>(this, PaymentOutcome.PARTIAL);
            }
            throw new FHIRException("Unknown PaymentOutcome code '" + codeString + "'");
        }

        @Override
        public String toCode(PaymentOutcome code) {
            if (code == PaymentOutcome.QUEUED) {
                return "queued";
            }
            if (code == PaymentOutcome.COMPLETE) {
                return "complete";
            }
            if (code == PaymentOutcome.ERROR) {
                return "error";
            }
            if (code == PaymentOutcome.PARTIAL) {
                return "partial";
            }
            return "?";
        }

        @Override
        public String toSystem(PaymentOutcome code) {
            return code.getSystem();
        }
    }

    public static enum PaymentOutcome {
        QUEUED,
        COMPLETE,
        ERROR,
        PARTIAL,
        NULL;


        public static PaymentOutcome fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("queued".equals(codeString)) {
                return QUEUED;
            }
            if ("complete".equals(codeString)) {
                return COMPLETE;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown PaymentOutcome code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case QUEUED: {
                    return "queued";
                }
                case COMPLETE: {
                    return "complete";
                }
                case ERROR: {
                    return "error";
                }
                case PARTIAL: {
                    return "partial";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case QUEUED: {
                    return "http://hl7.org/fhir/payment-outcome";
                }
                case COMPLETE: {
                    return "http://hl7.org/fhir/payment-outcome";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/payment-outcome";
                }
                case PARTIAL: {
                    return "http://hl7.org/fhir/payment-outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case QUEUED: {
                    return "The Claim/Pre-authorization/Pre-determination has been received but processing has not begun.";
                }
                case COMPLETE: {
                    return "The processing has completed without errors";
                }
                case ERROR: {
                    return "One or more errors have been detected in the Claim";
                }
                case PARTIAL: {
                    return "No errors have been detected in the Claim and some of the adjudication has been performed.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case QUEUED: {
                    return "Queued";
                }
                case COMPLETE: {
                    return "Processing Complete";
                }
                case ERROR: {
                    return "Error";
                }
                case PARTIAL: {
                    return "Partial Processing";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

