/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;

@DatatypeDef(name="Contributor")
public class Contributor
extends DataType
implements ICompositeType {
    @Child(name="type", type={CodeType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="author | editor | reviewer | endorser", formalDefinition="The type of contributor.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/contributor-type")
    protected Enumeration<ContributorType> type;
    @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who contributed the content", formalDefinition="The name of the individual or organization responsible for the contribution.")
    protected StringType name;
    @Child(name="contact", type={ContactDetail.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details of the contributor", formalDefinition="Contact details to assist a user in finding and communicating with the contributor.")
    protected List<ContactDetail> contact;
    private static final long serialVersionUID = -609887113L;

    public Contributor() {
    }

    public Contributor(ContributorType type, String name) {
        this.setType(type);
        this.setName(name);
    }

    public Enumeration<ContributorType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contributor.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<ContributorType>(new ContributorTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Contributor setTypeElement(Enumeration<ContributorType> value) {
        this.type = value;
        return this;
    }

    public ContributorType getType() {
        return this.type == null ? null : (ContributorType)((Object)this.type.getValue());
    }

    public Contributor setType(ContributorType value) {
        if (this.type == null) {
            this.type = new Enumeration<ContributorType>(new ContributorTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contributor.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Contributor setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Contributor setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    public Contributor setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    public Contributor addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("type", "code", "The type of contributor.", 0, 1, this.type));
        children.add(new Property("name", "string", "The name of the individual or organization responsible for the contribution.", 0, 1, this.name));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the contributor.", 0, Integer.MAX_VALUE, this.contact));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3575610: {
                return new Property("type", "code", "The type of contributor.", 0, 1, this.type);
            }
            case 3373707: {
                return new Property("name", "string", "The name of the individual or organization responsible for the contribution.", 0, 1, this.name);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the contributor.", 0, Integer.MAX_VALUE, this.contact);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.type;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3575610: {
                value = new ContributorTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("type")) {
            value = new ContributorTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.type = value;
        } else if (name.equals("name")) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return this.getTypeElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 951526432: {
                return this.addContact();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3575610: {
                return new String[]{"code"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("type")) {
            throw new FHIRException("Cannot call addChild on a primitive type Contributor.type");
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type Contributor.name");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Contributor";
    }

    @Override
    public Contributor copy() {
        Contributor dst = new Contributor();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Contributor dst) {
        super.copyValues(dst);
        dst.type = this.type == null ? null : this.type.copy();
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail i : this.contact) {
                dst.contact.add(i.copy());
            }
        }
    }

    protected Contributor typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Contributor)) {
            return false;
        }
        Contributor o = (Contributor)other_;
        return Contributor.compareDeep(this.type, o.type, true) && Contributor.compareDeep(this.name, o.name, true) && Contributor.compareDeep(this.contact, o.contact, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Contributor)) {
            return false;
        }
        Contributor o = (Contributor)other_;
        return Contributor.compareValues(this.type, o.type, true) && Contributor.compareValues(this.name, o.name, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.type, this.name, this.contact});
    }

    public static class ContributorTypeEnumFactory
    implements EnumFactory<ContributorType> {
        @Override
        public ContributorType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("author".equals(codeString)) {
                return ContributorType.AUTHOR;
            }
            if ("editor".equals(codeString)) {
                return ContributorType.EDITOR;
            }
            if ("reviewer".equals(codeString)) {
                return ContributorType.REVIEWER;
            }
            if ("endorser".equals(codeString)) {
                return ContributorType.ENDORSER;
            }
            throw new IllegalArgumentException("Unknown ContributorType code '" + codeString + "'");
        }

        public Enumeration<ContributorType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ContributorType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("author".equals(codeString)) {
                return new Enumeration<ContributorType>(this, ContributorType.AUTHOR);
            }
            if ("editor".equals(codeString)) {
                return new Enumeration<ContributorType>(this, ContributorType.EDITOR);
            }
            if ("reviewer".equals(codeString)) {
                return new Enumeration<ContributorType>(this, ContributorType.REVIEWER);
            }
            if ("endorser".equals(codeString)) {
                return new Enumeration<ContributorType>(this, ContributorType.ENDORSER);
            }
            throw new FHIRException("Unknown ContributorType code '" + codeString + "'");
        }

        @Override
        public String toCode(ContributorType code) {
            if (code == ContributorType.AUTHOR) {
                return "author";
            }
            if (code == ContributorType.EDITOR) {
                return "editor";
            }
            if (code == ContributorType.REVIEWER) {
                return "reviewer";
            }
            if (code == ContributorType.ENDORSER) {
                return "endorser";
            }
            return "?";
        }

        @Override
        public String toSystem(ContributorType code) {
            return code.getSystem();
        }
    }

    public static enum ContributorType {
        AUTHOR,
        EDITOR,
        REVIEWER,
        ENDORSER,
        NULL;


        public static ContributorType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("author".equals(codeString)) {
                return AUTHOR;
            }
            if ("editor".equals(codeString)) {
                return EDITOR;
            }
            if ("reviewer".equals(codeString)) {
                return REVIEWER;
            }
            if ("endorser".equals(codeString)) {
                return ENDORSER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ContributorType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AUTHOR: {
                    return "author";
                }
                case EDITOR: {
                    return "editor";
                }
                case REVIEWER: {
                    return "reviewer";
                }
                case ENDORSER: {
                    return "endorser";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AUTHOR: {
                    return "http://hl7.org/fhir/contributor-type";
                }
                case EDITOR: {
                    return "http://hl7.org/fhir/contributor-type";
                }
                case REVIEWER: {
                    return "http://hl7.org/fhir/contributor-type";
                }
                case ENDORSER: {
                    return "http://hl7.org/fhir/contributor-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AUTHOR: {
                    return "An author of the content of the module.";
                }
                case EDITOR: {
                    return "An editor of the content of the module.";
                }
                case REVIEWER: {
                    return "A reviewer of the content of the module.";
                }
                case ENDORSER: {
                    return "An endorser of the content of the module.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AUTHOR: {
                    return "Author";
                }
                case EDITOR: {
                    return "Editor";
                }
                case REVIEWER: {
                    return "Reviewer";
                }
                case ENDORSER: {
                    return "Endorser";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

