/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ICoding;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.utilities.ElementDecoration;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class Element
extends Base {
    private List<String> comments;
    private String name;
    private String type;
    private String value;
    private int index = -1;
    private List<Element> children;
    private Property property;
    private Property elementProperty;
    private int line;
    private int col;
    private SpecialElement special;
    private XhtmlNode xhtml;
    private String explicitType;
    private Element parentForValidator;
    private boolean hasParentForValidator;
    private String path;
    private List<ValidationMessage> messages;
    private boolean prohibited;
    private boolean required;
    private Map<String, List<Element>> childMap;
    private int descendentCount;
    private int instanceId;

    public Element(String name) {
        this.name = name;
    }

    public Element(Element other) {
        this.name = other.name;
        this.type = other.type;
        this.property = other.property;
        this.elementProperty = other.elementProperty;
        this.special = other.special;
    }

    public Element(String name, Property property) {
        this.name = name;
        this.property = property;
    }

    public Element(String name, Property property, String type, String value) {
        this.name = name;
        this.property = property;
        this.type = type;
        this.value = value;
    }

    public void updateProperty(Property property, SpecialElement special, Property elementProperty) {
        this.property = property;
        this.elementProperty = elementProperty;
        this.special = special;
    }

    public SpecialElement getSpecial() {
        return this.special;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        if (this.type == null) {
            return this.property.getType(this.name);
        }
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    public List<Element> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Element>();
        }
        return this.children;
    }

    public boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public List<String> getComments() {
        if (this.comments == null) {
            this.comments = new ArrayList<String>();
        }
        return this.comments;
    }

    public Property getProperty() {
        return this.property;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public List<Element> getChildrenByName(String name) {
        ArrayList<Element> res = new ArrayList<Element>();
        if (this.children.size() > 20) {
            this.populateChildMap();
            List<Element> l = this.childMap.get(name);
            if (l != null) {
                res.addAll(l);
            }
        } else if (this.hasChildren()) {
            for (Element child : this.children) {
                if (!name.equals(child.getName())) continue;
                res.add(child);
            }
        }
        return res;
    }

    public void numberChildren() {
        if (this.children == null) {
            return;
        }
        String last = "";
        int index = 0;
        for (Element child : this.children) {
            if (child.getProperty().isList()) {
                if (!last.equals(child.getName())) {
                    last = child.getName();
                    index = 0;
                }
                child.index = ++index;
            } else {
                child.index = -1;
            }
            child.numberChildren();
        }
    }

    public int getIndex() {
        return this.index;
    }

    public boolean hasIndex() {
        return this.index > -1;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public String getChildValue(String name) {
        if (this.children == null) {
            return null;
        }
        for (Element child : this.children) {
            if (!name.equals(child.getName())) continue;
            return child.getValue();
        }
        return null;
    }

    public void setChildValue(String name, String value) {
        if (this.children == null) {
            this.children = new ArrayList<Element>();
        }
        for (Element child : this.children) {
            if (!name.equals(child.getName())) continue;
            if (!child.isPrimitive()) {
                throw new Error("Cannot set a value of a non-primitive type (" + name + " on " + this.getName() + ")");
            }
            child.setValue(value);
        }
        this.childMap = null;
        try {
            this.setProperty(name.hashCode(), name, new StringType(value));
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    public List<Element> getChildren(String name) {
        ArrayList<Element> res = new ArrayList<Element>();
        if (this.children.size() > 20) {
            this.populateChildMap();
            List<Element> l = this.childMap.get(name);
            if (l != null) {
                res.addAll(l);
            }
        } else if (this.children != null) {
            for (Element child : this.children) {
                if (!name.equals(child.getName())) continue;
                res.add(child);
            }
        }
        return res;
    }

    public boolean hasType() {
        if (this.type == null) {
            return this.property.hasType(this.name);
        }
        return true;
    }

    @Override
    public String fhirType() {
        return this.getType();
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        if (this.isPrimitive() && hash == "value".hashCode() && !Utilities.noString((String)this.value)) {
            Base[] b = new Base[]{new StringType(this.value)};
            return b;
        }
        ArrayList<Element> result = new ArrayList<Element>();
        if (this.children != null) {
            if (this.children.size() > 20) {
                this.populateChildMap();
                List<Element> l = this.childMap.get(name);
                if (l != null) {
                    result.addAll(l);
                }
            } else {
                for (Element child : this.children) {
                    if (child.getName().equals(name)) {
                        result.add(child);
                    }
                    if (!child.getName().startsWith(name) || !child.getProperty().isChoice() || !child.getProperty().getName().equals(name + "[x]")) continue;
                    result.add(child);
                }
            }
        }
        if (!result.isEmpty() || checkValid) {
            // empty if block
        }
        return result.toArray(new Base[result.size()]);
    }

    private void populateChildMap() {
        if (this.childMap == null) {
            this.childMap = new HashMap<String, List<Element>>();
            for (Element child : this.children) {
                String n;
                if (child.getProperty().getName().endsWith("[x]")) {
                    n = child.getProperty().getName();
                    n = n.substring(0, n.length() - 3);
                } else {
                    n = child.getName();
                }
                List<Element> l = this.childMap.get(n);
                if (l == null) {
                    l = new ArrayList<Element>();
                    this.childMap.put(n, l);
                }
                l.add(child);
            }
        }
    }

    @Override
    protected void listChildren(List<org.hl7.fhir.r5.model.Property> childProps) {
        if (this.children != null) {
            HashMap<String, org.hl7.fhir.r5.model.Property> map = new HashMap<String, org.hl7.fhir.r5.model.Property>();
            for (Element c : this.children) {
                org.hl7.fhir.r5.model.Property p = (org.hl7.fhir.r5.model.Property)map.get(c.getName());
                if (p == null) {
                    p = new org.hl7.fhir.r5.model.Property(c.getName(), c.fhirType(), c.getProperty().getDefinition().getDefinition(), c.getProperty().getDefinition().getMin(), this.maxToInt(c.getProperty().getDefinition().getMax()), c);
                    childProps.add(p);
                    map.put(c.getName(), p);
                    continue;
                }
                p.getValues().add(c);
            }
        }
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        if ("xhtml".equals(this.getType()) && hash == "value".hashCode()) {
            this.xhtml = TypeConvertor.castToXhtml(value);
            this.value = TypeConvertor.castToXhtmlString(value);
            return this;
        }
        if (this.isPrimitive() && hash == "value".hashCode()) {
            this.value = TypeConvertor.castToString(value).asStringValue();
            return this;
        }
        if (!value.isPrimitive() && !(value instanceof Element)) {
            if (this.isDataType(value)) {
                value = this.convertToElement(this.property.getChild(name), value);
            } else {
                throw new FHIRException("Cannot set property " + name + " on " + this.name + " - value is not a primitive type (" + value.fhirType() + ") or an ElementModel type");
            }
        }
        this.childMap = null;
        if (this.children == null) {
            this.children = new ArrayList<Element>();
        }
        Element childForValue = null;
        for (Element element : this.children) {
            if (!element.getName().equals(name)) continue;
            if (!element.isList()) {
                childForValue = element;
                break;
            }
            Element ne = new Element(element);
            this.children.add(ne);
            this.numberChildren();
            childForValue = ne;
            break;
        }
        int i = 0;
        if (childForValue == null) {
            for (Property p : this.property.getChildProperties(this.name, this.type)) {
                int t = -1;
                for (int c = 0; c < this.children.size(); ++c) {
                    Element e = this.children.get(c);
                    if (!p.getName().equals(e.getName())) continue;
                    t = c;
                }
                if (t >= i) {
                    i = t + 1;
                }
                if (!p.getName().equals(name) && !p.getName().equals(name + "[x]")) continue;
                Element ne = new Element(name, p);
                this.children.add(i, ne);
                childForValue = ne;
                break;
            }
        }
        if (childForValue == null) {
            throw new Error("Cannot set property " + name + " on " + this.name);
        }
        if (value.isPrimitive()) {
            if (childForValue.property.getName().endsWith("[x]")) {
                childForValue.name = name + Utilities.capitalize((String)value.fhirType());
            }
            childForValue.setValue(value.primitiveValue());
        } else {
            Element element = (Element)value;
            childForValue.type = element.getType();
            if (childForValue.property.getName().endsWith("[x]")) {
                childForValue.name = name + Utilities.capitalize((String)childForValue.type);
            } else if (value.isResource()) {
                if (childForValue.elementProperty == null) {
                    childForValue.elementProperty = childForValue.property;
                }
                childForValue.property = element.property;
                childForValue.special = SpecialElement.BUNDLE_ENTRY;
            }
            if (element.children != null) {
                if (childForValue.children == null) {
                    childForValue.children = new ArrayList<Element>();
                } else {
                    childForValue.children.clear();
                }
                childForValue.children.addAll(element.children);
            }
        }
        return childForValue;
    }

    private Base convertToElement(Property prop, Base v) throws FHIRException {
        return new ObjectConverter(this.property.getContext()).convert(prop, (DataType)v);
    }

    private boolean isDataType(Base v) {
        return v instanceof DataType && this.property.getContext().getTypeNames().contains(v.fhirType());
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        if (this.isPrimitive() && hash == "value".hashCode()) {
            return new StringType(this.value);
        }
        if (this.children == null) {
            this.children = new ArrayList<Element>();
        }
        for (Element child : this.children) {
            if (!child.getName().equals(name)) continue;
            if (!child.isList()) {
                return child;
            }
            Element ne = new Element(child);
            this.children.add(ne);
            this.numberChildren();
            return ne;
        }
        for (Property p : this.property.getChildProperties(this.name, this.type)) {
            if (!p.getName().equals(name)) continue;
            Element ne = new Element(name, p);
            this.children.add(ne);
            return ne;
        }
        throw new Error("Unrecognised name " + name + " on " + this.name);
    }

    private int maxToInt(String max) {
        if (max.equals("*")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(max);
    }

    @Override
    public boolean isPrimitive() {
        return this.type != null ? this.property.isPrimitive(this.type) : this.property.isPrimitive(this.property.getType(this.name));
    }

    @Override
    public boolean isBooleanPrimitive() {
        return this.isPrimitive() && ("boolean".equals(this.type) || "boolean".equals(this.property.getType(this.name)));
    }

    @Override
    public boolean isResource() {
        return this.property.isResource();
    }

    @Override
    public boolean hasPrimitiveValue() {
        return this.property.isPrimitiveName(this.name) || this.property.IsLogicalAndHasPrimitiveValue(this.name);
    }

    @Override
    public String primitiveValue() {
        if (this.isPrimitive()) {
            return this.value;
        }
        if (this.hasPrimitiveValue() && this.children != null) {
            for (Element c : this.children) {
                if (!c.getName().equals("value")) continue;
                return c.primitiveValue();
            }
        }
        return null;
    }

    public int line() {
        return this.line;
    }

    public int col() {
        return this.col;
    }

    public Element markLocation(int line, int col) {
        this.line = line;
        this.col = col;
        return this;
    }

    public void clearDecorations() {
        this.clearUserData("fhir.decorations");
        for (Element e : this.children) {
            e.clearDecorations();
        }
        this.childMap = null;
    }

    public void markValidation(StructureDefinition profile, ElementDefinition definition) {
        ArrayList<ElementDecoration> decorations = (ArrayList<ElementDecoration>)this.getUserData("fhir.decorations");
        if (decorations == null) {
            decorations = new ArrayList<ElementDecoration>();
            this.setUserData("fhir.decorations", decorations);
        }
        decorations.add(new ElementDecoration(ElementDecoration.DecorationType.TYPE, profile.getUserString("path"), definition.getPath()));
        if (definition.getId() != null && this.tail(definition.getId()).contains(":")) {
            String[] details = this.tail(definition.getId()).split(":");
            decorations.add(new ElementDecoration(ElementDecoration.DecorationType.SLICE, null, details[1]));
        }
    }

    private String tail(String id) {
        return id.contains(".") ? id.substring(id.lastIndexOf(".") + 1) : id;
    }

    public Element getNamedChild(String name) {
        if (this.children == null) {
            return null;
        }
        if (this.children.size() > 20) {
            this.populateChildMap();
            List<Element> l = this.childMap.get(name);
            if (l != null) {
                if (l.size() > 1) {
                    throw new Error("Attempt to read a single element when there is more than one present (" + name + ")");
                }
                return l.get(0);
            }
        }
        Element result = null;
        for (Element child : this.children) {
            if (child.getName() == null || name == null || child.getProperty() == null || child.getProperty().getDefinition() == null || child.fhirType() == null || !child.getName().equals(name) && (child.getName().length() <= child.fhirType().length() || !child.getName().substring(0, child.getName().length() - child.fhirType().length()).equals(name) || !child.getProperty().getDefinition().isChoice())) continue;
            if (result == null) {
                result = child;
                continue;
            }
            throw new Error("Attempt to read a single element when there is more than one present (" + name + ")");
        }
        return result;
    }

    public void getNamedChildren(String name, List<Element> list) {
        if (this.children != null) {
            if (this.children.size() > 20) {
                this.populateChildMap();
                List<Element> l = this.childMap.get(name);
                if (l != null) {
                    list.addAll(l);
                }
            } else {
                for (Element child : this.children) {
                    if (!child.getName().equals(name)) continue;
                    list.add(child);
                }
            }
        }
    }

    public String getNamedChildValue(String name) {
        Element child = this.getNamedChild(name);
        return child == null ? null : child.value;
    }

    public void getNamedChildrenWithWildcard(String string, List<Element> values) {
        Validate.isTrue((boolean)string.endsWith("[x]"));
        String start = string.substring(0, string.length() - 3);
        if (this.children != null) {
            for (Element child : this.children) {
                if (!child.getName().startsWith(start)) continue;
                values.add(child);
            }
        }
    }

    @Override
    public XhtmlNode getXhtml() {
        return this.xhtml;
    }

    public Element setXhtml(XhtmlNode xhtml) {
        this.xhtml = xhtml;
        return this;
    }

    @Override
    public boolean isEmpty() {
        if (this.value != null) {
            return false;
        }
        for (Element next : this.getChildren()) {
            if (next.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Property getElementProperty() {
        return this.elementProperty;
    }

    public boolean hasElementProperty() {
        return this.elementProperty != null;
    }

    public boolean hasChild(String name) {
        return this.getNamedChild(name) != null;
    }

    public boolean hasChildren(String name) {
        if (this.children != null) {
            for (Element child : this.children) {
                if (!child.getName().equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.name.equals(this.fhirType()) && this.isResource()) {
            return this.fhirType() + "/" + this.getIdBase() + "[" + (this.children == null || this.hasValue() ? this.value : Integer.toString(this.children.size()) + " children") + "]";
        }
        if (this.isResource()) {
            return this.name + "=" + this.fhirType() + "/" + this.getIdBase() + "[" + (this.children == null || this.hasValue() ? this.value : Integer.toString(this.children.size()) + " children") + "]";
        }
        return this.name + "=" + this.fhirType() + "[" + (this.children == null || this.hasValue() ? this.value : Integer.toString(this.children.size()) + " children") + "]";
    }

    @Override
    public String getIdBase() {
        return this.getChildValue("id");
    }

    @Override
    public void setIdBase(String value) {
        this.setChildValue("id", value);
    }

    @Override
    public boolean equalsDeep(Base other) {
        org.hl7.fhir.r5.model.Property o;
        String name;
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (this.isPrimitive() && other.isPrimitive()) {
            return this.primitiveValue().equals(other.primitiveValue());
        }
        if (this.isPrimitive() || other.isPrimitive()) {
            return false;
        }
        HashSet<String> processed = new HashSet<String>();
        for (org.hl7.fhir.r5.model.Property p : this.children()) {
            name = p.getName();
            processed.add(name);
            o = other.getChildByName(name);
            if (this.equalsDeep(p, o)) continue;
            return false;
        }
        for (org.hl7.fhir.r5.model.Property p : this.children()) {
            name = p.getName();
            if (processed.contains(name) || this.equalsDeep(p, o = other.getChildByName(name))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsDeep(org.hl7.fhir.r5.model.Property p, org.hl7.fhir.r5.model.Property o) {
        if (o == null || p == null) {
            return false;
        }
        if (p.getValues().size() != o.getValues().size()) {
            return false;
        }
        for (int i = 0; i < p.getValues().size(); ++i) {
            if (Base.compareDeep(p.getValues().get(i), o.getValues().get(i), true)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (this.isPrimitive() && other.isPrimitive()) {
            return this.primitiveValue().equals(other.primitiveValue());
        }
        return !this.isPrimitive() && !other.isPrimitive();
    }

    public DataType asType() throws FHIRException {
        return new ObjectConverter(this.property.getContext()).convertToType(this);
    }

    @Override
    public boolean isMetadataBased() {
        return true;
    }

    public boolean isList() {
        if (this.elementProperty != null) {
            return this.elementProperty.isList();
        }
        return this.property.isList();
    }

    public boolean isBaseList() {
        if (this.elementProperty != null) {
            return this.elementProperty.isBaseList();
        }
        return this.property.isBaseList();
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        Property p = this.property.getChildSimpleName(this.name, name);
        if (p != null) {
            HashSet<String> types = new HashSet<String>();
            for (ElementDefinition.TypeRefComponent tr : p.getDefinition().getType()) {
                types.add(tr.getCode());
            }
            return types.toArray(new String[0]);
        }
        return super.getTypesForProperty(hash, name);
    }

    public void sort() {
        if (this.children != null) {
            ArrayList<Element> remove = new ArrayList<Element>();
            for (Element child : this.children) {
                child.sort();
                if (!child.isEmpty()) continue;
                remove.add(child);
            }
            this.children.removeAll(remove);
            Collections.sort(this.children, new ElementSortComparator(this, this.property));
            this.childMap = null;
        }
    }

    public ICoding getAsICoding() throws FHIRException {
        if ("code".equals(this.fhirType())) {
            if (this.property.getDefinition().getBinding().getStrength() != Enumerations.BindingStrength.REQUIRED) {
                return null;
            }
            ICodingImpl c = new ICodingImpl(true, true, false, false);
            c.code = this.primitiveValue();
            ValueSetExpander.ValueSetExpansionOutcome vse = this.property.getContext().expandVS(this.property.getDefinition().getBinding(), true, false);
            if (vse.getValueset() == null) {
                return null;
            }
            for (ValueSet.ValueSetExpansionContainsComponent cc : vse.getValueset().getExpansion().getContains()) {
                if (!cc.getCode().equals(c.code)) continue;
                c.system = cc.getSystem();
                if (cc.hasVersion()) {
                    c.doesVersion = true;
                    c.version = cc.getVersion();
                }
                if (!cc.hasDisplay()) continue;
                c.doesDisplay = true;
                c.display = cc.getDisplay();
            }
            if (c.system == null) {
                return null;
            }
            return c;
        }
        if ("Coding".equals(this.fhirType())) {
            ICodingImpl c = new ICodingImpl(true, true, true, true);
            c.system = this.getNamedChildValue("system");
            c.code = this.getNamedChildValue("code");
            c.display = this.getNamedChildValue("display");
            c.version = this.getNamedChildValue("version");
            return c;
        }
        if ("Quantity".equals(this.fhirType())) {
            ICodingImpl c = new ICodingImpl(true, true, false, false);
            c.system = this.getNamedChildValue("system");
            c.code = this.getNamedChildValue("code");
            return c;
        }
        return null;
    }

    public String getExplicitType() {
        return this.explicitType;
    }

    public void setExplicitType(String explicitType) {
        this.explicitType = explicitType;
    }

    public boolean hasDescendant(Element element) {
        if (this.children != null) {
            for (Element child : this.children) {
                if (element != child && !child.hasDescendant(element)) continue;
                return true;
            }
        }
        return false;
    }

    public Element getExtension(String url) {
        if (this.children != null) {
            for (Element child : this.children) {
                String u;
                if (!Utilities.existsInList((String)child.getName(), (String[])new String[]{"extension", "modifierExtension"}) || !url.equals(u = child.getChildValue("url"))) continue;
                return child;
            }
        }
        return null;
    }

    public Base getExtensionValue(String url) {
        if (this.children != null) {
            for (Element child : this.children) {
                String u;
                if (!Utilities.existsInList((String)child.getName(), (String[])new String[]{"extension", "modifierExtension"}) || !url.equals(u = child.getChildValue("url"))) continue;
                return child.getNamedChild("value");
            }
        }
        return null;
    }

    public boolean hasExtension(String url) {
        if (this.children != null) {
            for (Element child : this.children) {
                String u;
                if (!Utilities.existsInList((String)child.getName(), (String[])new String[]{"extension", "modifierExtension"}) || !url.equals(u = child.getChildValue("url"))) continue;
                return true;
            }
        }
        return false;
    }

    public Element getParentForValidator() {
        if (!this.hasParentForValidator) {
            throw new Error("Parent not set");
        }
        return this.parentForValidator;
    }

    public void setParentForValidator(Element parentForValidator) {
        this.parentForValidator = parentForValidator;
        this.hasParentForValidator = true;
    }

    public boolean hasParentForValidator() {
        return this.hasParentForValidator;
    }

    public void clear() {
        this.comments = null;
        this.children.clear();
        this.childMap = null;
        this.property = null;
        this.elementProperty = null;
        this.xhtml = null;
        this.path = null;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void addMessage(ValidationMessage vm) {
        if (this.messages == null) {
            this.messages = new ArrayList<ValidationMessage>();
        }
        this.messages.add(vm);
    }

    public boolean hasMessages() {
        return this.messages != null && !this.messages.isEmpty();
    }

    public List<ValidationMessage> getMessages() {
        return this.messages;
    }

    public void removeChild(String name) {
        this.children.removeIf(n -> name.equals(n.getName()));
        this.childMap = null;
    }

    public boolean isProhibited() {
        return this.prohibited;
    }

    public void setProhibited(boolean prohibited) {
        this.prohibited = prohibited;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public int getDescendentCount() {
        return this.descendentCount;
    }

    public void setDescendentCount(int descendentCount) {
        this.descendentCount = descendentCount;
    }

    public int countDescendents() {
        if (this.descendentCount > 0) {
            return this.descendentCount;
        }
        if (this.children != null) {
            this.descendentCount = this.children.size();
            for (Element e : this.children) {
                this.descendentCount += e.countDescendents();
            }
        } else {
            this.descendentCount = 0;
        }
        return this.descendentCount;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    public class ICodingImpl
    implements ICoding {
        private String system;
        private String version;
        private String code;
        private String display;
        private boolean doesSystem;
        private boolean doesVersion;
        private boolean doesCode;
        private boolean doesDisplay;

        public ICodingImpl(boolean doesCode, boolean doesSystem, boolean doesVersion, boolean doesDisplay) {
            this.doesCode = doesCode;
            this.doesSystem = doesSystem;
            this.doesVersion = doesVersion;
            this.doesDisplay = doesDisplay;
        }

        @Override
        public String getSystem() {
            return this.system;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        @Override
        public String getDisplay() {
            return this.display;
        }

        @Override
        public boolean hasSystem() {
            return !Utilities.noString((String)this.system);
        }

        @Override
        public boolean hasVersion() {
            return !Utilities.noString((String)this.version);
        }

        @Override
        public boolean hasCode() {
            return !Utilities.noString((String)this.code);
        }

        @Override
        public boolean hasDisplay() {
            return !Utilities.noString((String)this.display);
        }

        public boolean supportsSystem() {
            return this.doesSystem;
        }

        @Override
        public boolean supportsVersion() {
            return this.doesVersion;
        }

        public boolean supportsCode() {
            return this.doesCode;
        }

        @Override
        public boolean supportsDisplay() {
            return this.doesDisplay;
        }
    }

    public class ElementSortComparator
    implements Comparator<Element> {
        private List<ElementDefinition> children;

        public ElementSortComparator(Element e, Property property) {
            String tn = e.getType();
            StructureDefinition sd = property.getContext().fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(tn, property.getContext().getOverrideVersionNs()));
            this.children = sd != null && !sd.getAbstract() ? sd.getSnapshot().getElement() : property.getStructure().getSnapshot().getElement();
        }

        @Override
        public int compare(Element e0, Element e1) {
            int i0 = this.find(e0);
            int i1 = this.find(e1);
            return Integer.compare(i0, i1);
        }

        private int find(Element e0) {
            int i = e0.elementProperty != null ? this.children.indexOf(e0.elementProperty.getDefinition()) : this.children.indexOf(e0.property.getDefinition());
            return i;
        }
    }

    public static enum SpecialElement {
        CONTAINED,
        BUNDLE_ENTRY,
        BUNDLE_OUTCOME,
        PARAMETER;


        public static SpecialElement fromProperty(Property property) {
            if (property.getStructure().getType().equals("Parameters")) {
                return PARAMETER;
            }
            if (property.getStructure().getType().equals("Bundle") && property.getName().equals("resource")) {
                return BUNDLE_ENTRY;
            }
            if (property.getStructure().getType().equals("Bundle") && property.getName().equals("outcome")) {
                return BUNDLE_OUTCOME;
            }
            if (property.getName().equals("contained")) {
                return CONTAINED;
            }
            throw new FHIRException("Unknown resource containing a native resource: " + property.getDefinition().getId());
        }

        public String toHuman() {
            switch (this) {
                case BUNDLE_ENTRY: {
                    return "entry";
                }
                case BUNDLE_OUTCOME: {
                    return "outcome";
                }
                case CONTAINED: {
                    return "contained";
                }
                case PARAMETER: {
                    return "parameter";
                }
            }
            return "??";
        }
    }
}

