/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.comparison.CapabilityStatementComparer;
import org.hl7.fhir.r5.comparison.CodeSystemComparer;
import org.hl7.fhir.r5.comparison.ProfileComparer;
import org.hl7.fhir.r5.comparison.ResourceComparer;
import org.hl7.fhir.r5.comparison.ValueSetComparer;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;

public class ComparisonSession {
    private Map<String, ResourceComparer.ResourceComparison> compares = new HashMap<String, ResourceComparer.ResourceComparison>();
    private IWorkerContext contextLeft;
    private IWorkerContext contextRight;
    private String sessiondId;
    private int count;
    private boolean debug;
    private String title;
    private ProfileUtilities.ProfileKnowledgeProvider pkpLeft;
    private ProfileUtilities.ProfileKnowledgeProvider pkpRight;

    public ComparisonSession(IWorkerContext contextLeft, IWorkerContext contextRight, String title, ProfileUtilities.ProfileKnowledgeProvider pkpLeft, ProfileUtilities.ProfileKnowledgeProvider pkpRight) {
        this.contextLeft = contextLeft;
        this.contextRight = contextRight;
        this.sessiondId = UUID.randomUUID().toString().toLowerCase();
        this.title = title;
        this.pkpLeft = pkpLeft;
        this.pkpRight = pkpRight;
        this.debug = false;
    }

    public IWorkerContext getContextLeft() {
        return this.contextLeft;
    }

    public IWorkerContext getContextRight() {
        return this.contextRight;
    }

    public String getTitle() {
        return this.title;
    }

    public ResourceComparer.ResourceComparison compare(String left, String right) throws DefinitionException, FHIRFormatError, IOException {
        CanonicalResource l = (CanonicalResource)this.contextLeft.fetchResource(Resource.class, left);
        if (l == null) {
            throw new DefinitionException("Unable to resolve " + left);
        }
        CanonicalResource r = (CanonicalResource)this.contextRight.fetchResource(Resource.class, right);
        if (r == null) {
            throw new DefinitionException("Unable to resolve " + right);
        }
        return this.compare(l, r);
    }

    public ResourceComparer.ResourceComparison compare(CanonicalResource left, CanonicalResource right) throws DefinitionException, FHIRFormatError, IOException {
        if (left != null && right != null) {
            String key = this.key(left.getUrl(), left.getVersion(), right.getUrl(), right.getVersion());
            if (this.compares.containsKey(key)) {
                return this.compares.get(key);
            }
            this.compares.put(key, null);
            try {
                if (left instanceof CodeSystem && right instanceof CodeSystem) {
                    CodeSystemComparer cs = new CodeSystemComparer(this);
                    CodeSystemComparer.CodeSystemComparison csc = cs.compare((CodeSystem)left, (CodeSystem)right);
                    this.compares.put(key, csc);
                    return csc;
                }
                if (left instanceof ValueSet && right instanceof ValueSet) {
                    ValueSetComparer cs = new ValueSetComparer(this);
                    ValueSetComparer.ValueSetComparison csc = cs.compare((ValueSet)left, (ValueSet)right);
                    this.compares.put(key, csc);
                    return csc;
                }
                if (left instanceof StructureDefinition && right instanceof StructureDefinition) {
                    ProfileComparer cs = new ProfileComparer(this, new ProfileUtilities(this.contextLeft, null, this.pkpLeft), new ProfileUtilities(this.contextRight, null, this.pkpRight));
                    ProfileComparer.ProfileComparison csc = cs.compare((StructureDefinition)left, (StructureDefinition)right);
                    this.compares.put(key, csc);
                    return csc;
                }
                if (left instanceof CapabilityStatement && right instanceof CapabilityStatement) {
                    CapabilityStatementComparer cs = new CapabilityStatementComparer(this);
                    CapabilityStatementComparer.CapabilityStatementComparison csc = cs.compare((CapabilityStatement)left, (CapabilityStatement)right);
                    this.compares.put(key, csc);
                    return csc;
                }
                throw new FHIRException("Unable to compare resources of type " + left.fhirType() + " and " + right.fhirType());
            }
            catch (Throwable e) {
                if (this.debug) {
                    e.printStackTrace();
                }
                ResourceComparer.PlaceHolderComparison csc = new ResourceComparer.PlaceHolderComparison(left, right, e);
                this.compares.put(key, csc);
                return csc;
            }
        }
        if (left != null) {
            String key = this.key(left.getUrl(), left.getVersion(), left.getUrl(), left.getVersion());
            if (this.compares.containsKey(key)) {
                return this.compares.get(key);
            }
            ResourceComparer.PlaceHolderComparison csc = new ResourceComparer.PlaceHolderComparison(left, right);
            this.compares.put(key, csc);
            return csc;
        }
        String key = this.key(right.getUrl(), right.getVersion(), right.getUrl(), right.getVersion());
        if (this.compares.containsKey(key)) {
            return this.compares.get(key);
        }
        ResourceComparer.PlaceHolderComparison csc = new ResourceComparer.PlaceHolderComparison(left, right);
        this.compares.put(key, csc);
        return csc;
    }

    private String key(String urlL, String verL, String urlR, String verR) {
        return urlL + "|" + verL + "||" + urlR + "|" + verR;
    }

    public void identify(CanonicalResource res) {
        ++this.count;
        res.setId(this.sessiondId + "-" + this.count);
        res.setUrl("http://hl7.org/fhir/comparison/" + res.fhirType() + "/" + res.getId());
    }

    public void identify(ResourceComparer.ResourceComparison res) {
        ++this.count;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Map<String, ResourceComparer.ResourceComparison> getCompares() {
        return this.compares;
    }

    public ProfileUtilities.ProfileKnowledgeProvider getPkpLeft() {
        return this.pkpLeft;
    }

    public ProfileUtilities.ProfileKnowledgeProvider getPkpRight() {
        return this.pkpRight;
    }
}

