/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.TypeConvertor;

@DatatypeDef(name="UsageContext")
public class UsageContext
extends DataType
implements ICompositeType {
    @Child(name="code", type={Coding.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of context being specified", formalDefinition="A code that identifies the type of context being specified by this usage context.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/usage-context-type")
    protected Coding code;
    @Child(name="value", type={CodeableConcept.class, Quantity.class, Range.class, PlanDefinition.class, ResearchStudy.class, InsurancePlan.class, HealthcareService.class, Group.class, Location.class, Organization.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Value that defines the context", formalDefinition="A value that defines the context specified in this context of use. The interpretation of the value is defined by the code.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/use-context")
    protected DataType value;
    private static final long serialVersionUID = -1546390646L;

    public UsageContext() {
    }

    public UsageContext(Coding code, DataType value) {
        this.setCode(code);
        this.setValue(value);
    }

    public Coding getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create UsageContext.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new Coding();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public UsageContext setCode(Coding value) {
        this.code = value;
        return this;
    }

    public DataType getValue() {
        return this.value;
    }

    public CodeableConcept getValueCodeableConcept() throws FHIRException {
        if (this.value == null) {
            this.value = new CodeableConcept();
        }
        if (!(this.value instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.value;
    }

    public boolean hasValueCodeableConcept() {
        return this != null && this.value instanceof CodeableConcept;
    }

    public Quantity getValueQuantity() throws FHIRException {
        if (this.value == null) {
            this.value = new Quantity();
        }
        if (!(this.value instanceof Quantity)) {
            throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Quantity)this.value;
    }

    public boolean hasValueQuantity() {
        return this != null && this.value instanceof Quantity;
    }

    public Range getValueRange() throws FHIRException {
        if (this.value == null) {
            this.value = new Range();
        }
        if (!(this.value instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Range)this.value;
    }

    public boolean hasValueRange() {
        return this != null && this.value instanceof Range;
    }

    public Reference getValueReference() throws FHIRException {
        if (this.value == null) {
            this.value = new Reference();
        }
        if (!(this.value instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
        }
        return (Reference)this.value;
    }

    public boolean hasValueReference() {
        return this != null && this.value instanceof Reference;
    }

    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public UsageContext setValue(DataType value) {
        if (!(value == null || value instanceof CodeableConcept || value instanceof Quantity || value instanceof Range || value instanceof Reference)) {
            throw new Error("Not the right type for UsageContext.value[x]: " + value.fhirType());
        }
        this.value = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("code", "Coding", "A code that identifies the type of context being specified by this usage context.", 0, 1, this.code));
        children.add(new Property("value[x]", "CodeableConcept|Quantity|Range|Reference(PlanDefinition|ResearchStudy|InsurancePlan|HealthcareService|Group|Location|Organization)", "A value that defines the context specified in this context of use. The interpretation of the value is defined by the code.", 0, 1, this.value));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 3059181: {
                return new Property("code", "Coding", "A code that identifies the type of context being specified by this usage context.", 0, 1, this.code);
            }
            case -1410166417: {
                return new Property("value[x]", "CodeableConcept|Quantity|Range|Reference(PlanDefinition|ResearchStudy|InsurancePlan|HealthcareService|Group|Location|Organization)", "A value that defines the context specified in this context of use. The interpretation of the value is defined by the code.", 0, 1, this.value);
            }
            case 111972721: {
                return new Property("value[x]", "CodeableConcept|Quantity|Range|Reference(PlanDefinition|ResearchStudy|InsurancePlan|HealthcareService|Group|Location|Organization)", "A value that defines the context specified in this context of use. The interpretation of the value is defined by the code.", 0, 1, this.value);
            }
            case 924902896: {
                return new Property("value[x]", "CodeableConcept", "A value that defines the context specified in this context of use. The interpretation of the value is defined by the code.", 0, 1, this.value);
            }
            case -2029823716: {
                return new Property("value[x]", "Quantity", "A value that defines the context specified in this context of use. The interpretation of the value is defined by the code.", 0, 1, this.value);
            }
            case 2030761548: {
                return new Property("value[x]", "Range", "A value that defines the context specified in this context of use. The interpretation of the value is defined by the code.", 0, 1, this.value);
            }
            case 1755241690: {
                return new Property("value[x]", "Reference(PlanDefinition|ResearchStudy|InsurancePlan|HealthcareService|Group|Location|Organization)", "A value that defines the context specified in this context of use. The interpretation of the value is defined by the code.", 0, 1, this.value);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.code;
                }
                return baseArray;
            }
            case 111972721: {
                Base[] baseArray;
                if (this.value == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.value;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 3059181: {
                this.code = TypeConvertor.castToCoding(value);
                return value;
            }
            case 111972721: {
                this.value = TypeConvertor.castToType(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("code")) {
            this.code = TypeConvertor.castToCoding(value);
        } else if (name.equals("value[x]")) {
            this.value = TypeConvertor.castToType(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3059181: {
                return this.getCode();
            }
            case -1410166417: {
                return this.getValue();
            }
            case 111972721: {
                return this.getValue();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 3059181: {
                return new String[]{"Coding"};
            }
            case 111972721: {
                return new String[]{"CodeableConcept", "Quantity", "Range", "Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("code")) {
            this.code = new Coding();
            return this.code;
        }
        if (name.equals("valueCodeableConcept")) {
            this.value = new CodeableConcept();
            return this.value;
        }
        if (name.equals("valueQuantity")) {
            this.value = new Quantity();
            return this.value;
        }
        if (name.equals("valueRange")) {
            this.value = new Range();
            return this.value;
        }
        if (name.equals("valueReference")) {
            this.value = new Reference();
            return this.value;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "UsageContext";
    }

    @Override
    public UsageContext copy() {
        UsageContext dst = new UsageContext();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(UsageContext dst) {
        super.copyValues(dst);
        dst.code = this.code == null ? null : this.code.copy();
        dst.value = this.value == null ? null : this.value.copy();
    }

    protected UsageContext typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof UsageContext)) {
            return false;
        }
        UsageContext o = (UsageContext)other_;
        return UsageContext.compareDeep(this.code, o.code, true) && UsageContext.compareDeep(this.value, o.value, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof UsageContext)) {
            return false;
        }
        UsageContext o = (UsageContext)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.value});
    }
}

