/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SpecimenDefinition", profile="http://hl7.org/fhir/StructureDefinition/SpecimenDefinition")
public class SpecimenDefinition
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical canonical URL to reference this SpecimenDefinition (globally unique)", formalDefinition="An absolute URL that is used to identify this SpecimenDefinition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this SpecimenDefinition is (or will be) published. The URL SHOULD include the major version of the SpecimenDefinition. For more information see Technical and Business Versions.")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifier", formalDefinition="A business identifier assigned to this SpecimenDefinition.")
    protected Identifier identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the SpecimenDefinition", formalDefinition="The identifier that is used to identify this version of the SpecimenDefinition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the SpecimenDefinition author and is not expected to be globally unique.")
    protected StringType version;
    @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this SpecimenDefinition (Human friendly)", formalDefinition="A short, descriptive, user-friendly title for the SpecimenDefinition.")
    protected StringType title;
    @Child(name="derivedFromCanonical", type={CanonicalType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Based on FHIR definition of another SpecimenDefinition", formalDefinition="The canonical URL pointing to another FHIR-defined SpecimenDefinition that is adhered to in whole or in part by this definition.")
    protected List<CanonicalType> derivedFromCanonical;
    @Child(name="derivedFromUri", type={UriType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Based on external definition", formalDefinition="The URL pointing to an externally-defined type of specimen, guideline or other definition that is adhered to in whole or in part by this definition.")
    protected List<UriType> derivedFromUri;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The current state of theSpecimenDefinition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=7, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="If this SpecimenDefinition is not for real usage", formalDefinition="A flag to indicate that this SpecimenDefinition is not authored for  genuine usage.")
    protected BooleanType experimental;
    @Child(name="subject", type={CodeableConcept.class, Group.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type of subject for specimen collection", formalDefinition="A code or group definition that describes the intended subject  from which this kind of specimen is to be collected.")
    protected DataType subject;
    @Child(name="date", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date status first applied", formalDefinition="For draft definitions, indicates the date of initial creation. For active definitions, represents the date of activation. For withdrawn definitions, indicates the date of withdrawal.")
    protected DateTimeType date;
    @Child(name="publisher", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The name of the individual or organization that published the SpecimenDefinition", formalDefinition="Helps establish the \"authority/credibility\" of the SpecimenDefinition. May also allow for contact.")
    protected Reference publisher;
    @Child(name="contact", type={ContactDetail.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the SpecimenDefinition", formalDefinition="A free text natural language description of the SpecimenDefinition from the consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of specimen definitions.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for this SpecimenDefinition (if applicable)", formalDefinition="A jurisdiction in which the SpecimenDefinition is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this SpecimenDefinition is defined", formalDefinition="Explains why this SpecimeDefinition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="Copyright statement relating to the SpecimenDefinition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the SpecimenDefinition.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When SpecimenDefinition was approved by publisher", formalDefinition="The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Last review date for the SpecimenDefinition", formalDefinition="The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The effective date range for the SpecimenDefinition", formalDefinition="The period during which the SpecimenDefinition content was or is planned to be effective.")
    protected Period effectivePeriod;
    @Child(name="typeCollected", type={CodeableConcept.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of material to collect", formalDefinition="The kind of material to be collected.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0487")
    protected CodeableConcept typeCollected;
    @Child(name="patientPreparation", type={CodeableConcept.class}, order=21, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Patient preparation for collection", formalDefinition="Preparation of the patient for specimen collection.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/prepare-patient-prior-specimen-collection")
    protected List<CodeableConcept> patientPreparation;
    @Child(name="timeAspect", type={StringType.class}, order=22, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time aspect for collection", formalDefinition="Time aspect of specimen collection (duration or offset).")
    protected StringType timeAspect;
    @Child(name="collection", type={CodeableConcept.class}, order=23, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specimen collection procedure", formalDefinition="The action to be performed for collecting the specimen.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-collection")
    protected List<CodeableConcept> collection;
    @Child(name="typeTested", type={}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specimen in container intended for testing by lab", formalDefinition="Specimen conditioned in a container as expected by the testing laboratory.")
    protected List<SpecimenDefinitionTypeTestedComponent> typeTested;
    private static final long serialVersionUID = 830184995L;
    @SearchParamDefinition(name="container", path="SpecimenDefinition.typeTested.container.type", description="The type of specimen conditioned in container expected by the lab", type="token")
    public static final String SP_CONTAINER = "container";
    public static final TokenClientParam CONTAINER = new TokenClientParam("container");
    @SearchParamDefinition(name="experimental", path="SpecimenDefinition.experimental", description="Not for genuine usage (true)", type="token")
    public static final String SP_EXPERIMENTAL = "experimental";
    public static final TokenClientParam EXPERIMENTAL = new TokenClientParam("experimental");
    @SearchParamDefinition(name="identifier", path="SpecimenDefinition.identifier", description="The unique identifier associated with the SpecimenDefinition", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="is-derived", path="SpecimenDefinition.typeTested.isDerived", description="Primary specimen (false) or derived specimen (true)", type="token")
    public static final String SP_IS_DERIVED = "is-derived";
    public static final TokenClientParam IS_DERIVED = new TokenClientParam("is-derived");
    @SearchParamDefinition(name="status", path="SpecimenDefinition.status", description="Publication status of the SpecimenDefinition: draft, active, retired, unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="title", path="SpecimenDefinition.title", description="Human-friendly name of the SpecimenDefinition", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="type-tested", path="SpecimenDefinition.typeTested.type", description="The type of specimen conditioned for testing", type="token")
    public static final String SP_TYPE_TESTED = "type-tested";
    public static final TokenClientParam TYPE_TESTED = new TokenClientParam("type-tested");
    @SearchParamDefinition(name="type", path="SpecimenDefinition.typeCollected", description="The type of collected specimen", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public SpecimenDefinition() {
    }

    public SpecimenDefinition(Enumerations.PublicationStatus status) {
        this.setStatus(status);
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public SpecimenDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public SpecimenDefinition setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public SpecimenDefinition setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public SpecimenDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public SpecimenDefinition setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public SpecimenDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public SpecimenDefinition setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<CanonicalType> getDerivedFromCanonical() {
        if (this.derivedFromCanonical == null) {
            this.derivedFromCanonical = new ArrayList<CanonicalType>();
        }
        return this.derivedFromCanonical;
    }

    public SpecimenDefinition setDerivedFromCanonical(List<CanonicalType> theDerivedFromCanonical) {
        this.derivedFromCanonical = theDerivedFromCanonical;
        return this;
    }

    public boolean hasDerivedFromCanonical() {
        if (this.derivedFromCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.derivedFromCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addDerivedFromCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.derivedFromCanonical == null) {
            this.derivedFromCanonical = new ArrayList<CanonicalType>();
        }
        this.derivedFromCanonical.add(t);
        return t;
    }

    public SpecimenDefinition addDerivedFromCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.derivedFromCanonical == null) {
            this.derivedFromCanonical = new ArrayList<CanonicalType>();
        }
        this.derivedFromCanonical.add(t);
        return this;
    }

    public boolean hasDerivedFromCanonical(String value) {
        if (this.derivedFromCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.derivedFromCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getDerivedFromUri() {
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        return this.derivedFromUri;
    }

    public SpecimenDefinition setDerivedFromUri(List<UriType> theDerivedFromUri) {
        this.derivedFromUri = theDerivedFromUri;
        return this;
    }

    public boolean hasDerivedFromUri() {
        if (this.derivedFromUri == null) {
            return false;
        }
        for (UriType item : this.derivedFromUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addDerivedFromUriElement() {
        UriType t = new UriType();
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        this.derivedFromUri.add(t);
        return t;
    }

    public SpecimenDefinition addDerivedFromUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        this.derivedFromUri.add(t);
        return this;
    }

    public boolean hasDerivedFromUri(String value) {
        if (this.derivedFromUri == null) {
            return false;
        }
        for (UriType v : this.derivedFromUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public SpecimenDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public SpecimenDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public SpecimenDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public SpecimenDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public DataType getSubject() {
        return this.subject;
    }

    public CodeableConcept getSubjectCodeableConcept() throws FHIRException {
        if (this.subject == null) {
            this.subject = new CodeableConcept();
        }
        if (!(this.subject instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.subject;
    }

    public boolean hasSubjectCodeableConcept() {
        return this != null && this.subject instanceof CodeableConcept;
    }

    public Reference getSubjectReference() throws FHIRException {
        if (this.subject == null) {
            this.subject = new Reference();
        }
        if (!(this.subject instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.subject.getClass().getName() + " was encountered");
        }
        return (Reference)this.subject;
    }

    public boolean hasSubjectReference() {
        return this != null && this.subject instanceof Reference;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public SpecimenDefinition setSubject(DataType value) {
        if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
            throw new Error("Not the right type for SpecimenDefinition.subject[x]: " + value.fhirType());
        }
        this.subject = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public SpecimenDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public SpecimenDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getPublisher() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new Reference();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public SpecimenDefinition setPublisher(Reference value) {
        this.publisher = value;
        return this;
    }

    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    public SpecimenDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    public SpecimenDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public SpecimenDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public SpecimenDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    public SpecimenDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    public SpecimenDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    public SpecimenDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    public SpecimenDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public SpecimenDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public SpecimenDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public SpecimenDefinition setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public SpecimenDefinition setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public SpecimenDefinition setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public SpecimenDefinition setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public SpecimenDefinition setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public SpecimenDefinition setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public SpecimenDefinition setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public CodeableConcept getTypeCollected() {
        if (this.typeCollected == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.typeCollected");
            }
            if (Configuration.doAutoCreate()) {
                this.typeCollected = new CodeableConcept();
            }
        }
        return this.typeCollected;
    }

    public boolean hasTypeCollected() {
        return this.typeCollected != null && !this.typeCollected.isEmpty();
    }

    public SpecimenDefinition setTypeCollected(CodeableConcept value) {
        this.typeCollected = value;
        return this;
    }

    public List<CodeableConcept> getPatientPreparation() {
        if (this.patientPreparation == null) {
            this.patientPreparation = new ArrayList<CodeableConcept>();
        }
        return this.patientPreparation;
    }

    public SpecimenDefinition setPatientPreparation(List<CodeableConcept> thePatientPreparation) {
        this.patientPreparation = thePatientPreparation;
        return this;
    }

    public boolean hasPatientPreparation() {
        if (this.patientPreparation == null) {
            return false;
        }
        for (CodeableConcept item : this.patientPreparation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addPatientPreparation() {
        CodeableConcept t = new CodeableConcept();
        if (this.patientPreparation == null) {
            this.patientPreparation = new ArrayList<CodeableConcept>();
        }
        this.patientPreparation.add(t);
        return t;
    }

    public SpecimenDefinition addPatientPreparation(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.patientPreparation == null) {
            this.patientPreparation = new ArrayList<CodeableConcept>();
        }
        this.patientPreparation.add(t);
        return this;
    }

    public CodeableConcept getPatientPreparationFirstRep() {
        if (this.getPatientPreparation().isEmpty()) {
            this.addPatientPreparation();
        }
        return this.getPatientPreparation().get(0);
    }

    public StringType getTimeAspectElement() {
        if (this.timeAspect == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SpecimenDefinition.timeAspect");
            }
            if (Configuration.doAutoCreate()) {
                this.timeAspect = new StringType();
            }
        }
        return this.timeAspect;
    }

    public boolean hasTimeAspectElement() {
        return this.timeAspect != null && !this.timeAspect.isEmpty();
    }

    public boolean hasTimeAspect() {
        return this.timeAspect != null && !this.timeAspect.isEmpty();
    }

    public SpecimenDefinition setTimeAspectElement(StringType value) {
        this.timeAspect = value;
        return this;
    }

    public String getTimeAspect() {
        return this.timeAspect == null ? null : (String)this.timeAspect.getValue();
    }

    public SpecimenDefinition setTimeAspect(String value) {
        if (Utilities.noString((String)value)) {
            this.timeAspect = null;
        } else {
            if (this.timeAspect == null) {
                this.timeAspect = new StringType();
            }
            this.timeAspect.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getCollection() {
        if (this.collection == null) {
            this.collection = new ArrayList<CodeableConcept>();
        }
        return this.collection;
    }

    public SpecimenDefinition setCollection(List<CodeableConcept> theCollection) {
        this.collection = theCollection;
        return this;
    }

    public boolean hasCollection() {
        if (this.collection == null) {
            return false;
        }
        for (CodeableConcept item : this.collection) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCollection() {
        CodeableConcept t = new CodeableConcept();
        if (this.collection == null) {
            this.collection = new ArrayList<CodeableConcept>();
        }
        this.collection.add(t);
        return t;
    }

    public SpecimenDefinition addCollection(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.collection == null) {
            this.collection = new ArrayList<CodeableConcept>();
        }
        this.collection.add(t);
        return this;
    }

    public CodeableConcept getCollectionFirstRep() {
        if (this.getCollection().isEmpty()) {
            this.addCollection();
        }
        return this.getCollection().get(0);
    }

    public List<SpecimenDefinitionTypeTestedComponent> getTypeTested() {
        if (this.typeTested == null) {
            this.typeTested = new ArrayList<SpecimenDefinitionTypeTestedComponent>();
        }
        return this.typeTested;
    }

    public SpecimenDefinition setTypeTested(List<SpecimenDefinitionTypeTestedComponent> theTypeTested) {
        this.typeTested = theTypeTested;
        return this;
    }

    public boolean hasTypeTested() {
        if (this.typeTested == null) {
            return false;
        }
        for (SpecimenDefinitionTypeTestedComponent item : this.typeTested) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SpecimenDefinitionTypeTestedComponent addTypeTested() {
        SpecimenDefinitionTypeTestedComponent t = new SpecimenDefinitionTypeTestedComponent();
        if (this.typeTested == null) {
            this.typeTested = new ArrayList<SpecimenDefinitionTypeTestedComponent>();
        }
        this.typeTested.add(t);
        return t;
    }

    public SpecimenDefinition addTypeTested(SpecimenDefinitionTypeTestedComponent t) {
        if (t == null) {
            return this;
        }
        if (this.typeTested == null) {
            this.typeTested = new ArrayList<SpecimenDefinitionTypeTestedComponent>();
        }
        this.typeTested.add(t);
        return this;
    }

    public SpecimenDefinitionTypeTestedComponent getTypeTestedFirstRep() {
        if (this.getTypeTested().isEmpty()) {
            this.addTypeTested();
        }
        return this.getTypeTested().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("url", "uri", "An absolute URL that is used to identify this SpecimenDefinition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this SpecimenDefinition is (or will be) published. The URL SHOULD include the major version of the SpecimenDefinition. For more information see Technical and Business Versions.", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A business identifier assigned to this SpecimenDefinition.", 0, 1, this.identifier));
        children.add(new Property("version", "string", "The identifier that is used to identify this version of the SpecimenDefinition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the SpecimenDefinition author and is not expected to be globally unique.", 0, 1, this.version));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the SpecimenDefinition.", 0, 1, this.title));
        children.add(new Property("derivedFromCanonical", "canonical(SpecimenDefinition)", "The canonical URL pointing to another FHIR-defined SpecimenDefinition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromCanonical));
        children.add(new Property("derivedFromUri", "uri", "The URL pointing to an externally-defined type of specimen, guideline or other definition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromUri));
        children.add(new Property(SP_STATUS, "code", "The current state of theSpecimenDefinition.", 0, 1, this.status));
        children.add(new Property(SP_EXPERIMENTAL, "boolean", "A flag to indicate that this SpecimenDefinition is not authored for  genuine usage.", 0, 1, this.experimental));
        children.add(new Property("subject[x]", "CodeableConcept|Reference(Group)", "A code or group definition that describes the intended subject  from which this kind of specimen is to be collected.", 0, 1, this.subject));
        children.add(new Property("date", "dateTime", "For draft definitions, indicates the date of initial creation. For active definitions, represents the date of activation. For withdrawn definitions, indicates the date of withdrawal.", 0, 1, this.date));
        children.add(new Property("publisher", "Reference(Practitioner|PractitionerRole|Organization)", "Helps establish the \"authority/credibility\" of the SpecimenDefinition. May also allow for contact.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("description", "markdown", "A free text natural language description of the SpecimenDefinition from the consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of specimen definitions.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property("jurisdiction", "CodeableConcept", "A jurisdiction in which the SpecimenDefinition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explains why this SpecimeDefinition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "Copyright statement relating to the SpecimenDefinition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the SpecimenDefinition.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", "date", "The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", "date", "The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the SpecimenDefinition content was or is planned to be effective.", 0, 1, this.effectivePeriod));
        children.add(new Property("typeCollected", "CodeableConcept", "The kind of material to be collected.", 0, 1, this.typeCollected));
        children.add(new Property("patientPreparation", "CodeableConcept", "Preparation of the patient for specimen collection.", 0, Integer.MAX_VALUE, this.patientPreparation));
        children.add(new Property("timeAspect", "string", "Time aspect of specimen collection (duration or offset).", 0, 1, this.timeAspect));
        children.add(new Property("collection", "CodeableConcept", "The action to be performed for collecting the specimen.", 0, Integer.MAX_VALUE, this.collection));
        children.add(new Property("typeTested", "", "Specimen conditioned in a container as expected by the testing laboratory.", 0, Integer.MAX_VALUE, this.typeTested));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property("url", "uri", "An absolute URL that is used to identify this SpecimenDefinition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this SpecimenDefinition is (or will be) published. The URL SHOULD include the major version of the SpecimenDefinition. For more information see Technical and Business Versions.", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A business identifier assigned to this SpecimenDefinition.", 0, 1, this.identifier);
            }
            case 351608024: {
                return new Property("version", "string", "The identifier that is used to identify this version of the SpecimenDefinition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the SpecimenDefinition author and is not expected to be globally unique.", 0, 1, this.version);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the SpecimenDefinition.", 0, 1, this.title);
            }
            case -978133683: {
                return new Property("derivedFromCanonical", "canonical(SpecimenDefinition)", "The canonical URL pointing to another FHIR-defined SpecimenDefinition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromCanonical);
            }
            case -1076333435: {
                return new Property("derivedFromUri", "uri", "The URL pointing to an externally-defined type of specimen, guideline or other definition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromUri);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of theSpecimenDefinition.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property(SP_EXPERIMENTAL, "boolean", "A flag to indicate that this SpecimenDefinition is not authored for  genuine usage.", 0, 1, this.experimental);
            }
            case -573640748: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "A code or group definition that describes the intended subject  from which this kind of specimen is to be collected.", 0, 1, this.subject);
            }
            case -1867885268: {
                return new Property("subject[x]", "CodeableConcept|Reference(Group)", "A code or group definition that describes the intended subject  from which this kind of specimen is to be collected.", 0, 1, this.subject);
            }
            case -1257122603: {
                return new Property("subject[x]", "CodeableConcept", "A code or group definition that describes the intended subject  from which this kind of specimen is to be collected.", 0, 1, this.subject);
            }
            case 772938623: {
                return new Property("subject[x]", "Reference(Group)", "A code or group definition that describes the intended subject  from which this kind of specimen is to be collected.", 0, 1, this.subject);
            }
            case 3076014: {
                return new Property("date", "dateTime", "For draft definitions, indicates the date of initial creation. For active definitions, represents the date of activation. For withdrawn definitions, indicates the date of withdrawal.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property("publisher", "Reference(Practitioner|PractitionerRole|Organization)", "Helps establish the \"authority/credibility\" of the SpecimenDefinition. May also allow for contact.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A free text natural language description of the SpecimenDefinition from the consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of specimen definitions.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property("jurisdiction", "CodeableConcept", "A jurisdiction in which the SpecimenDefinition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explains why this SpecimeDefinition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "Copyright statement relating to the SpecimenDefinition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the SpecimenDefinition.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", "date", "The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", "date", "The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the SpecimenDefinition content was or is planned to be effective.", 0, 1, this.effectivePeriod);
            }
            case 588504367: {
                return new Property("typeCollected", "CodeableConcept", "The kind of material to be collected.", 0, 1, this.typeCollected);
            }
            case -879411630: {
                return new Property("patientPreparation", "CodeableConcept", "Preparation of the patient for specimen collection.", 0, Integer.MAX_VALUE, this.patientPreparation);
            }
            case 276972933: {
                return new Property("timeAspect", "string", "Time aspect of specimen collection (duration or offset).", 0, 1, this.timeAspect);
            }
            case -1741312354: {
                return new Property("collection", "CodeableConcept", "The action to be performed for collecting the specimen.", 0, Integer.MAX_VALUE, this.collection);
            }
            case -1407902581: {
                return new Property("typeTested", "", "Specimen conditioned in a container as expected by the testing laboratory.", 0, Integer.MAX_VALUE, this.typeTested);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.identifier;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.version;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -978133683: {
                return this.derivedFromCanonical == null ? new Base[]{} : this.derivedFromCanonical.toArray(new Base[this.derivedFromCanonical.size()]);
            }
            case -1076333435: {
                return this.derivedFromUri == null ? new Base[]{} : this.derivedFromUri.toArray(new Base[this.derivedFromUri.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.subject;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case 588504367: {
                Base[] baseArray;
                if (this.typeCollected == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.typeCollected;
                }
                return baseArray;
            }
            case -879411630: {
                return this.patientPreparation == null ? new Base[]{} : this.patientPreparation.toArray(new Base[this.patientPreparation.size()]);
            }
            case 276972933: {
                Base[] baseArray;
                if (this.timeAspect == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.timeAspect;
                }
                return baseArray;
            }
            case -1741312354: {
                return this.collection == null ? new Base[]{} : this.collection.toArray(new Base[this.collection.size()]);
            }
            case -1407902581: {
                return this.typeTested == null ? new Base[]{} : this.typeTested.toArray(new Base[this.typeTested.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.identifier = TypeConvertor.castToIdentifier(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = TypeConvertor.castToString(value);
                return value;
            }
            case -978133683: {
                this.getDerivedFromCanonical().add(TypeConvertor.castToCanonical(value));
                return value;
            }
            case -1076333435: {
                this.getDerivedFromUri().add(TypeConvertor.castToUri(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToType(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 588504367: {
                this.typeCollected = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -879411630: {
                this.getPatientPreparation().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 276972933: {
                this.timeAspect = TypeConvertor.castToString(value);
                return value;
            }
            case -1741312354: {
                this.getCollection().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1407902581: {
                this.getTypeTested().add((SpecimenDefinitionTypeTestedComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("url")) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.identifier = TypeConvertor.castToIdentifier(value);
        } else if (name.equals("version")) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = TypeConvertor.castToString(value);
        } else if (name.equals("derivedFromCanonical")) {
            this.getDerivedFromCanonical().add(TypeConvertor.castToCanonical(value));
        } else if (name.equals("derivedFromUri")) {
            this.getDerivedFromUri().add(TypeConvertor.castToUri(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_EXPERIMENTAL)) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals("subject[x]")) {
            this.subject = TypeConvertor.castToType(value);
        } else if (name.equals("date")) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals("publisher")) {
            this.publisher = TypeConvertor.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals("jurisdiction")) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = TypeConvertor.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = TypeConvertor.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = TypeConvertor.castToPeriod(value);
        } else if (name.equals("typeCollected")) {
            this.typeCollected = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("patientPreparation")) {
            this.getPatientPreparation().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("timeAspect")) {
            this.timeAspect = TypeConvertor.castToString(value);
        } else if (name.equals("collection")) {
            this.getCollection().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("typeTested")) {
            this.getTypeTested().add((SpecimenDefinitionTypeTestedComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.getIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -978133683: {
                return this.addDerivedFromCanonicalElement();
            }
            case -1076333435: {
                return this.addDerivedFromUriElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case -573640748: {
                return this.getSubject();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisher();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case 588504367: {
                return this.getTypeCollected();
            }
            case -879411630: {
                return this.addPatientPreparation();
            }
            case 276972933: {
                return this.getTimeAspectElement();
            }
            case -1741312354: {
                return this.addCollection();
            }
            case -1407902581: {
                return this.addTypeTested();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -978133683: {
                return new String[]{"canonical"};
            }
            case -1076333435: {
                return new String[]{"uri"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case -1867885268: {
                return new String[]{"CodeableConcept", "Reference"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{"date"};
            }
            case -1687512484: {
                return new String[]{"date"};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case 588504367: {
                return new String[]{"CodeableConcept"};
            }
            case -879411630: {
                return new String[]{"CodeableConcept"};
            }
            case 276972933: {
                return new String[]{"string"};
            }
            case -1741312354: {
                return new String[]{"CodeableConcept"};
            }
            case -1407902581: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("url")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("version")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.version");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.title");
        }
        if (name.equals("derivedFromCanonical")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.derivedFromCanonical");
        }
        if (name.equals("derivedFromUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.derivedFromUri");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.status");
        }
        if (name.equals(SP_EXPERIMENTAL)) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.experimental");
        }
        if (name.equals("subjectCodeableConcept")) {
            this.subject = new CodeableConcept();
            return this.subject;
        }
        if (name.equals("subjectReference")) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("date")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.date");
        }
        if (name.equals("publisher")) {
            this.publisher = new Reference();
            return this.publisher;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("jurisdiction")) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("typeCollected")) {
            this.typeCollected = new CodeableConcept();
            return this.typeCollected;
        }
        if (name.equals("patientPreparation")) {
            return this.addPatientPreparation();
        }
        if (name.equals("timeAspect")) {
            throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.timeAspect");
        }
        if (name.equals("collection")) {
            return this.addCollection();
        }
        if (name.equals("typeTested")) {
            return this.addTypeTested();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SpecimenDefinition";
    }

    @Override
    public SpecimenDefinition copy() {
        SpecimenDefinition dst = new SpecimenDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SpecimenDefinition dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.version = this.version == null ? null : this.version.copy();
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.derivedFromCanonical != null) {
            dst.derivedFromCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.derivedFromCanonical) {
                dst.derivedFromCanonical.add(canonicalType.copy());
            }
        }
        if (this.derivedFromUri != null) {
            dst.derivedFromUri = new ArrayList<UriType>();
            for (UriType uriType : this.derivedFromUri) {
                dst.derivedFromUri.add(uriType.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.date = this.date == null ? null : this.date.copy();
        Reference reference = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        CodeableConcept codeableConcept = dst.typeCollected = this.typeCollected == null ? null : this.typeCollected.copy();
        if (this.patientPreparation != null) {
            dst.patientPreparation = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.patientPreparation) {
                dst.patientPreparation.add(codeableConcept2.copy());
            }
        }
        StringType stringType2 = dst.timeAspect = this.timeAspect == null ? null : this.timeAspect.copy();
        if (this.collection != null) {
            dst.collection = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.collection) {
                dst.collection.add(codeableConcept3.copy());
            }
        }
        if (this.typeTested != null) {
            dst.typeTested = new ArrayList<SpecimenDefinitionTypeTestedComponent>();
            for (SpecimenDefinitionTypeTestedComponent specimenDefinitionTypeTestedComponent : this.typeTested) {
                dst.typeTested.add(specimenDefinitionTypeTestedComponent.copy());
            }
        }
    }

    protected SpecimenDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SpecimenDefinition)) {
            return false;
        }
        SpecimenDefinition o = (SpecimenDefinition)other_;
        return SpecimenDefinition.compareDeep(this.url, o.url, true) && SpecimenDefinition.compareDeep(this.identifier, o.identifier, true) && SpecimenDefinition.compareDeep(this.version, o.version, true) && SpecimenDefinition.compareDeep(this.title, o.title, true) && SpecimenDefinition.compareDeep(this.derivedFromCanonical, o.derivedFromCanonical, true) && SpecimenDefinition.compareDeep(this.derivedFromUri, o.derivedFromUri, true) && SpecimenDefinition.compareDeep(this.status, o.status, true) && SpecimenDefinition.compareDeep(this.experimental, o.experimental, true) && SpecimenDefinition.compareDeep(this.subject, o.subject, true) && SpecimenDefinition.compareDeep(this.date, o.date, true) && SpecimenDefinition.compareDeep(this.publisher, o.publisher, true) && SpecimenDefinition.compareDeep(this.contact, o.contact, true) && SpecimenDefinition.compareDeep(this.description, o.description, true) && SpecimenDefinition.compareDeep(this.useContext, o.useContext, true) && SpecimenDefinition.compareDeep(this.jurisdiction, o.jurisdiction, true) && SpecimenDefinition.compareDeep(this.purpose, o.purpose, true) && SpecimenDefinition.compareDeep(this.copyright, o.copyright, true) && SpecimenDefinition.compareDeep(this.approvalDate, o.approvalDate, true) && SpecimenDefinition.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && SpecimenDefinition.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && SpecimenDefinition.compareDeep(this.typeCollected, o.typeCollected, true) && SpecimenDefinition.compareDeep(this.patientPreparation, o.patientPreparation, true) && SpecimenDefinition.compareDeep(this.timeAspect, o.timeAspect, true) && SpecimenDefinition.compareDeep(this.collection, o.collection, true) && SpecimenDefinition.compareDeep(this.typeTested, o.typeTested, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SpecimenDefinition)) {
            return false;
        }
        SpecimenDefinition o = (SpecimenDefinition)other_;
        return SpecimenDefinition.compareValues(this.url, o.url, true) && SpecimenDefinition.compareValues(this.version, o.version, true) && SpecimenDefinition.compareValues(this.title, o.title, true) && SpecimenDefinition.compareValues(this.derivedFromCanonical, o.derivedFromCanonical, true) && SpecimenDefinition.compareValues(this.derivedFromUri, o.derivedFromUri, true) && SpecimenDefinition.compareValues(this.status, o.status, true) && SpecimenDefinition.compareValues(this.experimental, o.experimental, true) && SpecimenDefinition.compareValues(this.date, o.date, true) && SpecimenDefinition.compareValues(this.description, o.description, true) && SpecimenDefinition.compareValues(this.purpose, o.purpose, true) && SpecimenDefinition.compareValues(this.copyright, o.copyright, true) && SpecimenDefinition.compareValues(this.approvalDate, o.approvalDate, true) && SpecimenDefinition.compareValues(this.lastReviewDate, o.lastReviewDate, true) && SpecimenDefinition.compareValues(this.timeAspect, o.timeAspect, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.title, this.derivedFromCanonical, this.derivedFromUri, this.status, this.experimental, this.subject, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.typeCollected, this.patientPreparation, this.timeAspect, this.collection, this.typeTested});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SpecimenDefinition;
    }

    @Block
    public static class SpecimenDefinitionTypeTestedHandlingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="temperatureQualifier", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Temperature qualifier", formalDefinition="It qualifies the interval of temperature, which characterizes an occurrence of handling. Conditions that are not related to temperature may be handled in the instruction element.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/handling-condition")
        protected CodeableConcept temperatureQualifier;
        @Child(name="temperatureRange", type={Range.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Temperature range", formalDefinition="The temperature interval for this set of handling instructions.")
        protected Range temperatureRange;
        @Child(name="maxDuration", type={Duration.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Maximum preservation time", formalDefinition="The maximum time interval of preservation of the specimen with these conditions.")
        protected Duration maxDuration;
        @Child(name="instruction", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Preservation instruction", formalDefinition="Additional textual instructions for the preservation or transport of the specimen. For instance, 'Protect from light exposure'.")
        protected StringType instruction;
        private static final long serialVersionUID = 2130906844L;

        public CodeableConcept getTemperatureQualifier() {
            if (this.temperatureQualifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedHandlingComponent.temperatureQualifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.temperatureQualifier = new CodeableConcept();
                }
            }
            return this.temperatureQualifier;
        }

        public boolean hasTemperatureQualifier() {
            return this.temperatureQualifier != null && !this.temperatureQualifier.isEmpty();
        }

        public SpecimenDefinitionTypeTestedHandlingComponent setTemperatureQualifier(CodeableConcept value) {
            this.temperatureQualifier = value;
            return this;
        }

        public Range getTemperatureRange() {
            if (this.temperatureRange == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedHandlingComponent.temperatureRange");
                }
                if (Configuration.doAutoCreate()) {
                    this.temperatureRange = new Range();
                }
            }
            return this.temperatureRange;
        }

        public boolean hasTemperatureRange() {
            return this.temperatureRange != null && !this.temperatureRange.isEmpty();
        }

        public SpecimenDefinitionTypeTestedHandlingComponent setTemperatureRange(Range value) {
            this.temperatureRange = value;
            return this;
        }

        public Duration getMaxDuration() {
            if (this.maxDuration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedHandlingComponent.maxDuration");
                }
                if (Configuration.doAutoCreate()) {
                    this.maxDuration = new Duration();
                }
            }
            return this.maxDuration;
        }

        public boolean hasMaxDuration() {
            return this.maxDuration != null && !this.maxDuration.isEmpty();
        }

        public SpecimenDefinitionTypeTestedHandlingComponent setMaxDuration(Duration value) {
            this.maxDuration = value;
            return this;
        }

        public StringType getInstructionElement() {
            if (this.instruction == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedHandlingComponent.instruction");
                }
                if (Configuration.doAutoCreate()) {
                    this.instruction = new StringType();
                }
            }
            return this.instruction;
        }

        public boolean hasInstructionElement() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public boolean hasInstruction() {
            return this.instruction != null && !this.instruction.isEmpty();
        }

        public SpecimenDefinitionTypeTestedHandlingComponent setInstructionElement(StringType value) {
            this.instruction = value;
            return this;
        }

        public String getInstruction() {
            return this.instruction == null ? null : (String)this.instruction.getValue();
        }

        public SpecimenDefinitionTypeTestedHandlingComponent setInstruction(String value) {
            if (Utilities.noString((String)value)) {
                this.instruction = null;
            } else {
                if (this.instruction == null) {
                    this.instruction = new StringType();
                }
                this.instruction.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("temperatureQualifier", "CodeableConcept", "It qualifies the interval of temperature, which characterizes an occurrence of handling. Conditions that are not related to temperature may be handled in the instruction element.", 0, 1, this.temperatureQualifier));
            children.add(new Property("temperatureRange", "Range", "The temperature interval for this set of handling instructions.", 0, 1, this.temperatureRange));
            children.add(new Property("maxDuration", "Duration", "The maximum time interval of preservation of the specimen with these conditions.", 0, 1, this.maxDuration));
            children.add(new Property("instruction", "string", "Additional textual instructions for the preservation or transport of the specimen. For instance, 'Protect from light exposure'.", 0, 1, this.instruction));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 548941206: {
                    return new Property("temperatureQualifier", "CodeableConcept", "It qualifies the interval of temperature, which characterizes an occurrence of handling. Conditions that are not related to temperature may be handled in the instruction element.", 0, 1, this.temperatureQualifier);
                }
                case -39203799: {
                    return new Property("temperatureRange", "Range", "The temperature interval for this set of handling instructions.", 0, 1, this.temperatureRange);
                }
                case 40284952: {
                    return new Property("maxDuration", "Duration", "The maximum time interval of preservation of the specimen with these conditions.", 0, 1, this.maxDuration);
                }
                case 301526158: {
                    return new Property("instruction", "string", "Additional textual instructions for the preservation or transport of the specimen. For instance, 'Protect from light exposure'.", 0, 1, this.instruction);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 548941206: {
                    Base[] baseArray;
                    if (this.temperatureQualifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.temperatureQualifier;
                    }
                    return baseArray;
                }
                case -39203799: {
                    Base[] baseArray;
                    if (this.temperatureRange == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.temperatureRange;
                    }
                    return baseArray;
                }
                case 40284952: {
                    Base[] baseArray;
                    if (this.maxDuration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.maxDuration;
                    }
                    return baseArray;
                }
                case 301526158: {
                    Base[] baseArray;
                    if (this.instruction == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.instruction;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 548941206: {
                    this.temperatureQualifier = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -39203799: {
                    this.temperatureRange = TypeConvertor.castToRange(value);
                    return value;
                }
                case 40284952: {
                    this.maxDuration = TypeConvertor.castToDuration(value);
                    return value;
                }
                case 301526158: {
                    this.instruction = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("temperatureQualifier")) {
                this.temperatureQualifier = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("temperatureRange")) {
                this.temperatureRange = TypeConvertor.castToRange(value);
            } else if (name.equals("maxDuration")) {
                this.maxDuration = TypeConvertor.castToDuration(value);
            } else if (name.equals("instruction")) {
                this.instruction = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 548941206: {
                    return this.getTemperatureQualifier();
                }
                case -39203799: {
                    return this.getTemperatureRange();
                }
                case 40284952: {
                    return this.getMaxDuration();
                }
                case 301526158: {
                    return this.getInstructionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 548941206: {
                    return new String[]{"CodeableConcept"};
                }
                case -39203799: {
                    return new String[]{"Range"};
                }
                case 40284952: {
                    return new String[]{"Duration"};
                }
                case 301526158: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("temperatureQualifier")) {
                this.temperatureQualifier = new CodeableConcept();
                return this.temperatureQualifier;
            }
            if (name.equals("temperatureRange")) {
                this.temperatureRange = new Range();
                return this.temperatureRange;
            }
            if (name.equals("maxDuration")) {
                this.maxDuration = new Duration();
                return this.maxDuration;
            }
            if (name.equals("instruction")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.typeTested.handling.instruction");
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenDefinitionTypeTestedHandlingComponent copy() {
            SpecimenDefinitionTypeTestedHandlingComponent dst = new SpecimenDefinitionTypeTestedHandlingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenDefinitionTypeTestedHandlingComponent dst) {
            super.copyValues(dst);
            dst.temperatureQualifier = this.temperatureQualifier == null ? null : this.temperatureQualifier.copy();
            dst.temperatureRange = this.temperatureRange == null ? null : this.temperatureRange.copy();
            dst.maxDuration = this.maxDuration == null ? null : this.maxDuration.copy();
            dst.instruction = this.instruction == null ? null : this.instruction.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedHandlingComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedHandlingComponent o = (SpecimenDefinitionTypeTestedHandlingComponent)other_;
            return SpecimenDefinitionTypeTestedHandlingComponent.compareDeep(this.temperatureQualifier, o.temperatureQualifier, true) && SpecimenDefinitionTypeTestedHandlingComponent.compareDeep(this.temperatureRange, o.temperatureRange, true) && SpecimenDefinitionTypeTestedHandlingComponent.compareDeep(this.maxDuration, o.maxDuration, true) && SpecimenDefinitionTypeTestedHandlingComponent.compareDeep(this.instruction, o.instruction, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedHandlingComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedHandlingComponent o = (SpecimenDefinitionTypeTestedHandlingComponent)other_;
            return SpecimenDefinitionTypeTestedHandlingComponent.compareValues(this.instruction, o.instruction, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.temperatureQualifier, this.temperatureRange, this.maxDuration, this.instruction});
        }

        @Override
        public String fhirType() {
            return "SpecimenDefinition.typeTested.handling";
        }
    }

    @Block
    public static class SpecimenDefinitionTypeTestedContainerAdditiveComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="additive", type={CodeableConcept.class, Substance.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additive associated with container", formalDefinition="Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0371")
        protected DataType additive;
        private static final long serialVersionUID = 201856258L;

        public SpecimenDefinitionTypeTestedContainerAdditiveComponent() {
        }

        public SpecimenDefinitionTypeTestedContainerAdditiveComponent(DataType additive) {
            this.setAdditive(additive);
        }

        public DataType getAdditive() {
            return this.additive;
        }

        public CodeableConcept getAdditiveCodeableConcept() throws FHIRException {
            if (this.additive == null) {
                this.additive = new CodeableConcept();
            }
            if (!(this.additive instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.additive.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.additive;
        }

        public boolean hasAdditiveCodeableConcept() {
            return this != null && this.additive instanceof CodeableConcept;
        }

        public Reference getAdditiveReference() throws FHIRException {
            if (this.additive == null) {
                this.additive = new Reference();
            }
            if (!(this.additive instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.additive.getClass().getName() + " was encountered");
            }
            return (Reference)this.additive;
        }

        public boolean hasAdditiveReference() {
            return this != null && this.additive instanceof Reference;
        }

        public boolean hasAdditive() {
            return this.additive != null && !this.additive.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerAdditiveComponent setAdditive(DataType value) {
            if (value != null && !(value instanceof CodeableConcept) && !(value instanceof Reference)) {
                throw new Error("Not the right type for SpecimenDefinition.typeTested.container.additive.additive[x]: " + value.fhirType());
            }
            this.additive = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 261915956: {
                    return new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
                case -1226589236: {
                    return new Property("additive[x]", "CodeableConcept|Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
                case 1330272821: {
                    return new Property("additive[x]", "CodeableConcept", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
                case -386783009: {
                    return new Property("additive[x]", "Reference(Substance)", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, 1, this.additive);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1226589236: {
                    Base[] baseArray;
                    if (this.additive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.additive;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1226589236: {
                    this.additive = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("additive[x]")) {
                return super.setProperty(name, value);
            }
            this.additive = TypeConvertor.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 261915956: {
                    return this.getAdditive();
                }
                case -1226589236: {
                    return this.getAdditive();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1226589236: {
                    return new String[]{"CodeableConcept", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("additiveCodeableConcept")) {
                this.additive = new CodeableConcept();
                return this.additive;
            }
            if (name.equals("additiveReference")) {
                this.additive = new Reference();
                return this.additive;
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenDefinitionTypeTestedContainerAdditiveComponent copy() {
            SpecimenDefinitionTypeTestedContainerAdditiveComponent dst = new SpecimenDefinitionTypeTestedContainerAdditiveComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenDefinitionTypeTestedContainerAdditiveComponent dst) {
            super.copyValues(dst);
            dst.additive = this.additive == null ? null : this.additive.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedContainerAdditiveComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedContainerAdditiveComponent o = (SpecimenDefinitionTypeTestedContainerAdditiveComponent)other_;
            return SpecimenDefinitionTypeTestedContainerAdditiveComponent.compareDeep(this.additive, o.additive, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedContainerAdditiveComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedContainerAdditiveComponent o = (SpecimenDefinitionTypeTestedContainerAdditiveComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.additive});
        }

        @Override
        public String fhirType() {
            return "SpecimenDefinition.typeTested.container.additive";
        }
    }

    @Block
    public static class SpecimenDefinitionTypeTestedContainerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="material", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Container material", formalDefinition="The type of material of the container.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/container-material")
        protected CodeableConcept material;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of container associated with the kind of specimen", formalDefinition="The type of container used to contain this kind of specimen.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-container-type")
        protected CodeableConcept type;
        @Child(name="cap", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Color of container cap", formalDefinition="Color of container cap.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/container-cap")
        protected CodeableConcept cap;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Container description", formalDefinition="The textual description of the kind of container.")
        protected StringType description;
        @Child(name="capacity", type={Quantity.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Container capacity", formalDefinition="The capacity (volume or other measure) of this kind of container.")
        protected Quantity capacity;
        @Child(name="minimumVolume", type={Quantity.class, StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Minimum volume", formalDefinition="The minimum volume to be conditioned in the container.")
        protected DataType minimumVolume;
        @Child(name="additive", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additive associated with container", formalDefinition="Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.")
        protected List<SpecimenDefinitionTypeTestedContainerAdditiveComponent> additive;
        @Child(name="preparation", type={StringType.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen container preparation", formalDefinition="Special processing that should be applied to the container for this kind of specimen.")
        protected StringType preparation;
        private static final long serialVersionUID = -1498817064L;

        public CodeableConcept getMaterial() {
            if (this.material == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedContainerComponent.material");
                }
                if (Configuration.doAutoCreate()) {
                    this.material = new CodeableConcept();
                }
            }
            return this.material;
        }

        public boolean hasMaterial() {
            return this.material != null && !this.material.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setMaterial(CodeableConcept value) {
            this.material = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedContainerComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getCap() {
            if (this.cap == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedContainerComponent.cap");
                }
                if (Configuration.doAutoCreate()) {
                    this.cap = new CodeableConcept();
                }
            }
            return this.cap;
        }

        public boolean hasCap() {
            return this.cap != null && !this.cap.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setCap(CodeableConcept value) {
            this.cap = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedContainerComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public Quantity getCapacity() {
            if (this.capacity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedContainerComponent.capacity");
                }
                if (Configuration.doAutoCreate()) {
                    this.capacity = new Quantity();
                }
            }
            return this.capacity;
        }

        public boolean hasCapacity() {
            return this.capacity != null && !this.capacity.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setCapacity(Quantity value) {
            this.capacity = value;
            return this;
        }

        public DataType getMinimumVolume() {
            return this.minimumVolume;
        }

        public Quantity getMinimumVolumeQuantity() throws FHIRException {
            if (this.minimumVolume == null) {
                this.minimumVolume = new Quantity();
            }
            if (!(this.minimumVolume instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.minimumVolume.getClass().getName() + " was encountered");
            }
            return (Quantity)this.minimumVolume;
        }

        public boolean hasMinimumVolumeQuantity() {
            return this != null && this.minimumVolume instanceof Quantity;
        }

        public StringType getMinimumVolumeStringType() throws FHIRException {
            if (this.minimumVolume == null) {
                this.minimumVolume = new StringType();
            }
            if (!(this.minimumVolume instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.minimumVolume.getClass().getName() + " was encountered");
            }
            return (StringType)this.minimumVolume;
        }

        public boolean hasMinimumVolumeStringType() {
            return this != null && this.minimumVolume instanceof StringType;
        }

        public boolean hasMinimumVolume() {
            return this.minimumVolume != null && !this.minimumVolume.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setMinimumVolume(DataType value) {
            if (value != null && !(value instanceof Quantity) && !(value instanceof StringType)) {
                throw new Error("Not the right type for SpecimenDefinition.typeTested.container.minimumVolume[x]: " + value.fhirType());
            }
            this.minimumVolume = value;
            return this;
        }

        public List<SpecimenDefinitionTypeTestedContainerAdditiveComponent> getAdditive() {
            if (this.additive == null) {
                this.additive = new ArrayList<SpecimenDefinitionTypeTestedContainerAdditiveComponent>();
            }
            return this.additive;
        }

        public SpecimenDefinitionTypeTestedContainerComponent setAdditive(List<SpecimenDefinitionTypeTestedContainerAdditiveComponent> theAdditive) {
            this.additive = theAdditive;
            return this;
        }

        public boolean hasAdditive() {
            if (this.additive == null) {
                return false;
            }
            for (SpecimenDefinitionTypeTestedContainerAdditiveComponent item : this.additive) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SpecimenDefinitionTypeTestedContainerAdditiveComponent addAdditive() {
            SpecimenDefinitionTypeTestedContainerAdditiveComponent t = new SpecimenDefinitionTypeTestedContainerAdditiveComponent();
            if (this.additive == null) {
                this.additive = new ArrayList<SpecimenDefinitionTypeTestedContainerAdditiveComponent>();
            }
            this.additive.add(t);
            return t;
        }

        public SpecimenDefinitionTypeTestedContainerComponent addAdditive(SpecimenDefinitionTypeTestedContainerAdditiveComponent t) {
            if (t == null) {
                return this;
            }
            if (this.additive == null) {
                this.additive = new ArrayList<SpecimenDefinitionTypeTestedContainerAdditiveComponent>();
            }
            this.additive.add(t);
            return this;
        }

        public SpecimenDefinitionTypeTestedContainerAdditiveComponent getAdditiveFirstRep() {
            if (this.getAdditive().isEmpty()) {
                this.addAdditive();
            }
            return this.getAdditive().get(0);
        }

        public StringType getPreparationElement() {
            if (this.preparation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedContainerComponent.preparation");
                }
                if (Configuration.doAutoCreate()) {
                    this.preparation = new StringType();
                }
            }
            return this.preparation;
        }

        public boolean hasPreparationElement() {
            return this.preparation != null && !this.preparation.isEmpty();
        }

        public boolean hasPreparation() {
            return this.preparation != null && !this.preparation.isEmpty();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setPreparationElement(StringType value) {
            this.preparation = value;
            return this;
        }

        public String getPreparation() {
            return this.preparation == null ? null : (String)this.preparation.getValue();
        }

        public SpecimenDefinitionTypeTestedContainerComponent setPreparation(String value) {
            if (Utilities.noString((String)value)) {
                this.preparation = null;
            } else {
                if (this.preparation == null) {
                    this.preparation = new StringType();
                }
                this.preparation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("material", "CodeableConcept", "The type of material of the container.", 0, 1, this.material));
            children.add(new Property(SpecimenDefinition.SP_TYPE, "CodeableConcept", "The type of container used to contain this kind of specimen.", 0, 1, this.type));
            children.add(new Property("cap", "CodeableConcept", "Color of container cap.", 0, 1, this.cap));
            children.add(new Property("description", "string", "The textual description of the kind of container.", 0, 1, this.description));
            children.add(new Property("capacity", "Quantity", "The capacity (volume or other measure) of this kind of container.", 0, 1, this.capacity));
            children.add(new Property("minimumVolume[x]", "Quantity|string", "The minimum volume to be conditioned in the container.", 0, 1, this.minimumVolume));
            children.add(new Property("additive", "", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, Integer.MAX_VALUE, this.additive));
            children.add(new Property("preparation", "string", "Special processing that should be applied to the container for this kind of specimen.", 0, 1, this.preparation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 299066663: {
                    return new Property("material", "CodeableConcept", "The type of material of the container.", 0, 1, this.material);
                }
                case 3575610: {
                    return new Property(SpecimenDefinition.SP_TYPE, "CodeableConcept", "The type of container used to contain this kind of specimen.", 0, 1, this.type);
                }
                case 98258: {
                    return new Property("cap", "CodeableConcept", "Color of container cap.", 0, 1, this.cap);
                }
                case -1724546052: {
                    return new Property("description", "string", "The textual description of the kind of container.", 0, 1, this.description);
                }
                case -67824454: {
                    return new Property("capacity", "Quantity", "The capacity (volume or other measure) of this kind of container.", 0, 1, this.capacity);
                }
                case 371830456: {
                    return new Property("minimumVolume[x]", "Quantity|string", "The minimum volume to be conditioned in the container.", 0, 1, this.minimumVolume);
                }
                case -1674665784: {
                    return new Property("minimumVolume[x]", "Quantity|string", "The minimum volume to be conditioned in the container.", 0, 1, this.minimumVolume);
                }
                case -532143757: {
                    return new Property("minimumVolume[x]", "Quantity", "The minimum volume to be conditioned in the container.", 0, 1, this.minimumVolume);
                }
                case 248461049: {
                    return new Property("minimumVolume[x]", "string", "The minimum volume to be conditioned in the container.", 0, 1, this.minimumVolume);
                }
                case -1226589236: {
                    return new Property("additive", "", "Substance introduced in the kind of container to preserve, maintain or enhance the specimen. Examples: Formalin, Citrate, EDTA.", 0, Integer.MAX_VALUE, this.additive);
                }
                case -1315428713: {
                    return new Property("preparation", "string", "Special processing that should be applied to the container for this kind of specimen.", 0, 1, this.preparation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 299066663: {
                    Base[] baseArray;
                    if (this.material == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.material;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case 98258: {
                    Base[] baseArray;
                    if (this.cap == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.cap;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case -67824454: {
                    Base[] baseArray;
                    if (this.capacity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.capacity;
                    }
                    return baseArray;
                }
                case -1674665784: {
                    Base[] baseArray;
                    if (this.minimumVolume == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.minimumVolume;
                    }
                    return baseArray;
                }
                case -1226589236: {
                    return this.additive == null ? new Base[]{} : this.additive.toArray(new Base[this.additive.size()]);
                }
                case -1315428713: {
                    Base[] baseArray;
                    if (this.preparation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.preparation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 299066663: {
                    this.material = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 98258: {
                    this.cap = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -67824454: {
                    this.capacity = TypeConvertor.castToQuantity(value);
                    return value;
                }
                case -1674665784: {
                    this.minimumVolume = TypeConvertor.castToType(value);
                    return value;
                }
                case -1226589236: {
                    this.getAdditive().add((SpecimenDefinitionTypeTestedContainerAdditiveComponent)value);
                    return value;
                }
                case -1315428713: {
                    this.preparation = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("material")) {
                this.material = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals(SpecimenDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("cap")) {
                this.cap = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("capacity")) {
                this.capacity = TypeConvertor.castToQuantity(value);
            } else if (name.equals("minimumVolume[x]")) {
                this.minimumVolume = TypeConvertor.castToType(value);
            } else if (name.equals("additive")) {
                this.getAdditive().add((SpecimenDefinitionTypeTestedContainerAdditiveComponent)value);
            } else if (name.equals("preparation")) {
                this.preparation = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 299066663: {
                    return this.getMaterial();
                }
                case 3575610: {
                    return this.getType();
                }
                case 98258: {
                    return this.getCap();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -67824454: {
                    return this.getCapacity();
                }
                case 371830456: {
                    return this.getMinimumVolume();
                }
                case -1674665784: {
                    return this.getMinimumVolume();
                }
                case -1226589236: {
                    return this.addAdditive();
                }
                case -1315428713: {
                    return this.getPreparationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 299066663: {
                    return new String[]{"CodeableConcept"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 98258: {
                    return new String[]{"CodeableConcept"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -67824454: {
                    return new String[]{"Quantity"};
                }
                case -1674665784: {
                    return new String[]{"Quantity", "string"};
                }
                case -1226589236: {
                    return new String[0];
                }
                case -1315428713: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("material")) {
                this.material = new CodeableConcept();
                return this.material;
            }
            if (name.equals(SpecimenDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("cap")) {
                this.cap = new CodeableConcept();
                return this.cap;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.typeTested.container.description");
            }
            if (name.equals("capacity")) {
                this.capacity = new Quantity();
                return this.capacity;
            }
            if (name.equals("minimumVolumeQuantity")) {
                this.minimumVolume = new Quantity();
                return this.minimumVolume;
            }
            if (name.equals("minimumVolumeString")) {
                this.minimumVolume = new StringType();
                return this.minimumVolume;
            }
            if (name.equals("additive")) {
                return this.addAdditive();
            }
            if (name.equals("preparation")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.typeTested.container.preparation");
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenDefinitionTypeTestedContainerComponent copy() {
            SpecimenDefinitionTypeTestedContainerComponent dst = new SpecimenDefinitionTypeTestedContainerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenDefinitionTypeTestedContainerComponent dst) {
            super.copyValues(dst);
            dst.material = this.material == null ? null : this.material.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.cap = this.cap == null ? null : this.cap.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.capacity = this.capacity == null ? null : this.capacity.copy();
            DataType dataType = dst.minimumVolume = this.minimumVolume == null ? null : this.minimumVolume.copy();
            if (this.additive != null) {
                dst.additive = new ArrayList<SpecimenDefinitionTypeTestedContainerAdditiveComponent>();
                for (SpecimenDefinitionTypeTestedContainerAdditiveComponent i : this.additive) {
                    dst.additive.add(i.copy());
                }
            }
            dst.preparation = this.preparation == null ? null : this.preparation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedContainerComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedContainerComponent o = (SpecimenDefinitionTypeTestedContainerComponent)other_;
            return SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.material, o.material, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.type, o.type, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.cap, o.cap, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.description, o.description, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.capacity, o.capacity, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.minimumVolume, o.minimumVolume, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.additive, o.additive, true) && SpecimenDefinitionTypeTestedContainerComponent.compareDeep(this.preparation, o.preparation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedContainerComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedContainerComponent o = (SpecimenDefinitionTypeTestedContainerComponent)other_;
            return SpecimenDefinitionTypeTestedContainerComponent.compareValues(this.description, o.description, true) && SpecimenDefinitionTypeTestedContainerComponent.compareValues(this.preparation, o.preparation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.material, this.type, this.cap, this.description, this.capacity, this.minimumVolume, this.additive, this.preparation});
        }

        @Override
        public String fhirType() {
            return "SpecimenDefinition.typeTested.container";
        }
    }

    @Block
    public static class SpecimenDefinitionTypeTestedComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="isDerived", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Primary or secondary specimen", formalDefinition="Primary of secondary specimen.")
        protected BooleanType isDerived;
        @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of intended specimen", formalDefinition="The kind of specimen conditioned for testing expected by lab.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0487")
        protected CodeableConcept type;
        @Child(name="preference", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="preferred | alternate", formalDefinition="The preference for this type of conditioned specimen.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/specimen-contained-preference")
        protected Enumeration<SpecimenContainedPreference> preference;
        @Child(name="container", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The specimen's container", formalDefinition="The specimen's container.")
        protected SpecimenDefinitionTypeTestedContainerComponent container;
        @Child(name="requirement", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen requirements", formalDefinition="Requirements for delivery and special handling of this kind of conditioned specimen.")
        protected StringType requirement;
        @Child(name="retentionTime", type={Duration.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen retention time", formalDefinition="The usual time that a specimen of this kind is retained after the ordered tests are completed, for the purpose of additional testing.")
        protected Duration retentionTime;
        @Child(name="singleUse", type={BooleanType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen for single use only", formalDefinition="Specimen can be used by only one test or panel if the value is \"true\".")
        protected BooleanType singleUse;
        @Child(name="rejectionCriterion", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Rejection criterion", formalDefinition="Criterion for rejection of the specimen in its container by the laboratory.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/rejection-criteria")
        protected List<CodeableConcept> rejectionCriterion;
        @Child(name="handling", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Specimen handling before testing", formalDefinition="Set of instructions for preservation/transport of the specimen at a defined temperature interval, prior the testing process.")
        protected List<SpecimenDefinitionTypeTestedHandlingComponent> handling;
        @Child(name="testingDestination", type={CodeableConcept.class}, order=10, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Where the specimen will be tested", formalDefinition="Where the specimen will be tested: e.g., lab, sector, device or any combination of these.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnostic-service-sections")
        protected List<CodeableConcept> testingDestination;
        private static final long serialVersionUID = 1859673754L;

        public SpecimenDefinitionTypeTestedComponent() {
        }

        public SpecimenDefinitionTypeTestedComponent(SpecimenContainedPreference preference) {
            this.setPreference(preference);
        }

        public BooleanType getIsDerivedElement() {
            if (this.isDerived == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.isDerived");
                }
                if (Configuration.doAutoCreate()) {
                    this.isDerived = new BooleanType();
                }
            }
            return this.isDerived;
        }

        public boolean hasIsDerivedElement() {
            return this.isDerived != null && !this.isDerived.isEmpty();
        }

        public boolean hasIsDerived() {
            return this.isDerived != null && !this.isDerived.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setIsDerivedElement(BooleanType value) {
            this.isDerived = value;
            return this;
        }

        public boolean getIsDerived() {
            return this.isDerived == null || this.isDerived.isEmpty() ? false : (Boolean)this.isDerived.getValue();
        }

        public SpecimenDefinitionTypeTestedComponent setIsDerived(boolean value) {
            if (this.isDerived == null) {
                this.isDerived = new BooleanType();
            }
            this.isDerived.setValue((Object)value);
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public Enumeration<SpecimenContainedPreference> getPreferenceElement() {
            if (this.preference == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.preference");
                }
                if (Configuration.doAutoCreate()) {
                    this.preference = new Enumeration<SpecimenContainedPreference>(new SpecimenContainedPreferenceEnumFactory());
                }
            }
            return this.preference;
        }

        public boolean hasPreferenceElement() {
            return this.preference != null && !this.preference.isEmpty();
        }

        public boolean hasPreference() {
            return this.preference != null && !this.preference.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setPreferenceElement(Enumeration<SpecimenContainedPreference> value) {
            this.preference = value;
            return this;
        }

        public SpecimenContainedPreference getPreference() {
            return this.preference == null ? null : (SpecimenContainedPreference)((Object)this.preference.getValue());
        }

        public SpecimenDefinitionTypeTestedComponent setPreference(SpecimenContainedPreference value) {
            if (this.preference == null) {
                this.preference = new Enumeration<SpecimenContainedPreference>(new SpecimenContainedPreferenceEnumFactory());
            }
            this.preference.setValue((Object)value);
            return this;
        }

        public SpecimenDefinitionTypeTestedContainerComponent getContainer() {
            if (this.container == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.container");
                }
                if (Configuration.doAutoCreate()) {
                    this.container = new SpecimenDefinitionTypeTestedContainerComponent();
                }
            }
            return this.container;
        }

        public boolean hasContainer() {
            return this.container != null && !this.container.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setContainer(SpecimenDefinitionTypeTestedContainerComponent value) {
            this.container = value;
            return this;
        }

        public StringType getRequirementElement() {
            if (this.requirement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.requirement");
                }
                if (Configuration.doAutoCreate()) {
                    this.requirement = new StringType();
                }
            }
            return this.requirement;
        }

        public boolean hasRequirementElement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public boolean hasRequirement() {
            return this.requirement != null && !this.requirement.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setRequirementElement(StringType value) {
            this.requirement = value;
            return this;
        }

        public String getRequirement() {
            return this.requirement == null ? null : (String)this.requirement.getValue();
        }

        public SpecimenDefinitionTypeTestedComponent setRequirement(String value) {
            if (Utilities.noString((String)value)) {
                this.requirement = null;
            } else {
                if (this.requirement == null) {
                    this.requirement = new StringType();
                }
                this.requirement.setValue(value);
            }
            return this;
        }

        public Duration getRetentionTime() {
            if (this.retentionTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.retentionTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.retentionTime = new Duration();
                }
            }
            return this.retentionTime;
        }

        public boolean hasRetentionTime() {
            return this.retentionTime != null && !this.retentionTime.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setRetentionTime(Duration value) {
            this.retentionTime = value;
            return this;
        }

        public BooleanType getSingleUseElement() {
            if (this.singleUse == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SpecimenDefinitionTypeTestedComponent.singleUse");
                }
                if (Configuration.doAutoCreate()) {
                    this.singleUse = new BooleanType();
                }
            }
            return this.singleUse;
        }

        public boolean hasSingleUseElement() {
            return this.singleUse != null && !this.singleUse.isEmpty();
        }

        public boolean hasSingleUse() {
            return this.singleUse != null && !this.singleUse.isEmpty();
        }

        public SpecimenDefinitionTypeTestedComponent setSingleUseElement(BooleanType value) {
            this.singleUse = value;
            return this;
        }

        public boolean getSingleUse() {
            return this.singleUse == null || this.singleUse.isEmpty() ? false : (Boolean)this.singleUse.getValue();
        }

        public SpecimenDefinitionTypeTestedComponent setSingleUse(boolean value) {
            if (this.singleUse == null) {
                this.singleUse = new BooleanType();
            }
            this.singleUse.setValue((Object)value);
            return this;
        }

        public List<CodeableConcept> getRejectionCriterion() {
            if (this.rejectionCriterion == null) {
                this.rejectionCriterion = new ArrayList<CodeableConcept>();
            }
            return this.rejectionCriterion;
        }

        public SpecimenDefinitionTypeTestedComponent setRejectionCriterion(List<CodeableConcept> theRejectionCriterion) {
            this.rejectionCriterion = theRejectionCriterion;
            return this;
        }

        public boolean hasRejectionCriterion() {
            if (this.rejectionCriterion == null) {
                return false;
            }
            for (CodeableConcept item : this.rejectionCriterion) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRejectionCriterion() {
            CodeableConcept t = new CodeableConcept();
            if (this.rejectionCriterion == null) {
                this.rejectionCriterion = new ArrayList<CodeableConcept>();
            }
            this.rejectionCriterion.add(t);
            return t;
        }

        public SpecimenDefinitionTypeTestedComponent addRejectionCriterion(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.rejectionCriterion == null) {
                this.rejectionCriterion = new ArrayList<CodeableConcept>();
            }
            this.rejectionCriterion.add(t);
            return this;
        }

        public CodeableConcept getRejectionCriterionFirstRep() {
            if (this.getRejectionCriterion().isEmpty()) {
                this.addRejectionCriterion();
            }
            return this.getRejectionCriterion().get(0);
        }

        public List<SpecimenDefinitionTypeTestedHandlingComponent> getHandling() {
            if (this.handling == null) {
                this.handling = new ArrayList<SpecimenDefinitionTypeTestedHandlingComponent>();
            }
            return this.handling;
        }

        public SpecimenDefinitionTypeTestedComponent setHandling(List<SpecimenDefinitionTypeTestedHandlingComponent> theHandling) {
            this.handling = theHandling;
            return this;
        }

        public boolean hasHandling() {
            if (this.handling == null) {
                return false;
            }
            for (SpecimenDefinitionTypeTestedHandlingComponent item : this.handling) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SpecimenDefinitionTypeTestedHandlingComponent addHandling() {
            SpecimenDefinitionTypeTestedHandlingComponent t = new SpecimenDefinitionTypeTestedHandlingComponent();
            if (this.handling == null) {
                this.handling = new ArrayList<SpecimenDefinitionTypeTestedHandlingComponent>();
            }
            this.handling.add(t);
            return t;
        }

        public SpecimenDefinitionTypeTestedComponent addHandling(SpecimenDefinitionTypeTestedHandlingComponent t) {
            if (t == null) {
                return this;
            }
            if (this.handling == null) {
                this.handling = new ArrayList<SpecimenDefinitionTypeTestedHandlingComponent>();
            }
            this.handling.add(t);
            return this;
        }

        public SpecimenDefinitionTypeTestedHandlingComponent getHandlingFirstRep() {
            if (this.getHandling().isEmpty()) {
                this.addHandling();
            }
            return this.getHandling().get(0);
        }

        public List<CodeableConcept> getTestingDestination() {
            if (this.testingDestination == null) {
                this.testingDestination = new ArrayList<CodeableConcept>();
            }
            return this.testingDestination;
        }

        public SpecimenDefinitionTypeTestedComponent setTestingDestination(List<CodeableConcept> theTestingDestination) {
            this.testingDestination = theTestingDestination;
            return this;
        }

        public boolean hasTestingDestination() {
            if (this.testingDestination == null) {
                return false;
            }
            for (CodeableConcept item : this.testingDestination) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addTestingDestination() {
            CodeableConcept t = new CodeableConcept();
            if (this.testingDestination == null) {
                this.testingDestination = new ArrayList<CodeableConcept>();
            }
            this.testingDestination.add(t);
            return t;
        }

        public SpecimenDefinitionTypeTestedComponent addTestingDestination(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.testingDestination == null) {
                this.testingDestination = new ArrayList<CodeableConcept>();
            }
            this.testingDestination.add(t);
            return this;
        }

        public CodeableConcept getTestingDestinationFirstRep() {
            if (this.getTestingDestination().isEmpty()) {
                this.addTestingDestination();
            }
            return this.getTestingDestination().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("isDerived", "boolean", "Primary of secondary specimen.", 0, 1, this.isDerived));
            children.add(new Property(SpecimenDefinition.SP_TYPE, "CodeableConcept", "The kind of specimen conditioned for testing expected by lab.", 0, 1, this.type));
            children.add(new Property("preference", "code", "The preference for this type of conditioned specimen.", 0, 1, this.preference));
            children.add(new Property(SpecimenDefinition.SP_CONTAINER, "", "The specimen's container.", 0, 1, this.container));
            children.add(new Property("requirement", "string", "Requirements for delivery and special handling of this kind of conditioned specimen.", 0, 1, this.requirement));
            children.add(new Property("retentionTime", "Duration", "The usual time that a specimen of this kind is retained after the ordered tests are completed, for the purpose of additional testing.", 0, 1, this.retentionTime));
            children.add(new Property("singleUse", "boolean", "Specimen can be used by only one test or panel if the value is \"true\".", 0, 1, this.singleUse));
            children.add(new Property("rejectionCriterion", "CodeableConcept", "Criterion for rejection of the specimen in its container by the laboratory.", 0, Integer.MAX_VALUE, this.rejectionCriterion));
            children.add(new Property("handling", "", "Set of instructions for preservation/transport of the specimen at a defined temperature interval, prior the testing process.", 0, Integer.MAX_VALUE, this.handling));
            children.add(new Property("testingDestination", "CodeableConcept", "Where the specimen will be tested: e.g., lab, sector, device or any combination of these.", 0, Integer.MAX_VALUE, this.testingDestination));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 976346515: {
                    return new Property("isDerived", "boolean", "Primary of secondary specimen.", 0, 1, this.isDerived);
                }
                case 3575610: {
                    return new Property(SpecimenDefinition.SP_TYPE, "CodeableConcept", "The kind of specimen conditioned for testing expected by lab.", 0, 1, this.type);
                }
                case -1459831589: {
                    return new Property("preference", "code", "The preference for this type of conditioned specimen.", 0, 1, this.preference);
                }
                case -410956671: {
                    return new Property(SpecimenDefinition.SP_CONTAINER, "", "The specimen's container.", 0, 1, this.container);
                }
                case 363387971: {
                    return new Property("requirement", "string", "Requirements for delivery and special handling of this kind of conditioned specimen.", 0, 1, this.requirement);
                }
                case 1434969867: {
                    return new Property("retentionTime", "Duration", "The usual time that a specimen of this kind is retained after the ordered tests are completed, for the purpose of additional testing.", 0, 1, this.retentionTime);
                }
                case -1494547425: {
                    return new Property("singleUse", "boolean", "Specimen can be used by only one test or panel if the value is \"true\".", 0, 1, this.singleUse);
                }
                case -553706344: {
                    return new Property("rejectionCriterion", "CodeableConcept", "Criterion for rejection of the specimen in its container by the laboratory.", 0, Integer.MAX_VALUE, this.rejectionCriterion);
                }
                case 2072805: {
                    return new Property("handling", "", "Set of instructions for preservation/transport of the specimen at a defined temperature interval, prior the testing process.", 0, Integer.MAX_VALUE, this.handling);
                }
                case 939511774: {
                    return new Property("testingDestination", "CodeableConcept", "Where the specimen will be tested: e.g., lab, sector, device or any combination of these.", 0, Integer.MAX_VALUE, this.testingDestination);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 976346515: {
                    Base[] baseArray;
                    if (this.isDerived == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.isDerived;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.type;
                    }
                    return baseArray;
                }
                case -1459831589: {
                    Base[] baseArray;
                    if (this.preference == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.preference;
                    }
                    return baseArray;
                }
                case -410956671: {
                    Base[] baseArray;
                    if (this.container == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.container;
                    }
                    return baseArray;
                }
                case 363387971: {
                    Base[] baseArray;
                    if (this.requirement == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.requirement;
                    }
                    return baseArray;
                }
                case 1434969867: {
                    Base[] baseArray;
                    if (this.retentionTime == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.retentionTime;
                    }
                    return baseArray;
                }
                case -1494547425: {
                    Base[] baseArray;
                    if (this.singleUse == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.singleUse;
                    }
                    return baseArray;
                }
                case -553706344: {
                    return this.rejectionCriterion == null ? new Base[]{} : this.rejectionCriterion.toArray(new Base[this.rejectionCriterion.size()]);
                }
                case 2072805: {
                    return this.handling == null ? new Base[]{} : this.handling.toArray(new Base[this.handling.size()]);
                }
                case 939511774: {
                    return this.testingDestination == null ? new Base[]{} : this.testingDestination.toArray(new Base[this.testingDestination.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 976346515: {
                    this.isDerived = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1459831589: {
                    value = new SpecimenContainedPreferenceEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.preference = value;
                    return value;
                }
                case -410956671: {
                    this.container = (SpecimenDefinitionTypeTestedContainerComponent)((Object)value);
                    return value;
                }
                case 363387971: {
                    this.requirement = TypeConvertor.castToString(value);
                    return value;
                }
                case 1434969867: {
                    this.retentionTime = TypeConvertor.castToDuration(value);
                    return value;
                }
                case -1494547425: {
                    this.singleUse = TypeConvertor.castToBoolean(value);
                    return value;
                }
                case -553706344: {
                    this.getRejectionCriterion().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 2072805: {
                    this.getHandling().add((SpecimenDefinitionTypeTestedHandlingComponent)((Object)value));
                    return value;
                }
                case 939511774: {
                    this.getTestingDestination().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("isDerived")) {
                this.isDerived = TypeConvertor.castToBoolean(value);
            } else if (name.equals(SpecimenDefinition.SP_TYPE)) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("preference")) {
                value = new SpecimenContainedPreferenceEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.preference = value;
            } else if (name.equals(SpecimenDefinition.SP_CONTAINER)) {
                this.container = (SpecimenDefinitionTypeTestedContainerComponent)((Object)value);
            } else if (name.equals("requirement")) {
                this.requirement = TypeConvertor.castToString(value);
            } else if (name.equals("retentionTime")) {
                this.retentionTime = TypeConvertor.castToDuration(value);
            } else if (name.equals("singleUse")) {
                this.singleUse = TypeConvertor.castToBoolean(value);
            } else if (name.equals("rejectionCriterion")) {
                this.getRejectionCriterion().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("handling")) {
                this.getHandling().add((SpecimenDefinitionTypeTestedHandlingComponent)((Object)value));
            } else if (name.equals("testingDestination")) {
                this.getTestingDestination().add(TypeConvertor.castToCodeableConcept(value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 976346515: {
                    return this.getIsDerivedElement();
                }
                case 3575610: {
                    return this.getType();
                }
                case -1459831589: {
                    return this.getPreferenceElement();
                }
                case -410956671: {
                    return this.getContainer();
                }
                case 363387971: {
                    return this.getRequirementElement();
                }
                case 1434969867: {
                    return this.getRetentionTime();
                }
                case -1494547425: {
                    return this.getSingleUseElement();
                }
                case -553706344: {
                    return this.addRejectionCriterion();
                }
                case 2072805: {
                    return this.addHandling();
                }
                case 939511774: {
                    return this.addTestingDestination();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 976346515: {
                    return new String[]{"boolean"};
                }
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -1459831589: {
                    return new String[]{"code"};
                }
                case -410956671: {
                    return new String[0];
                }
                case 363387971: {
                    return new String[]{"string"};
                }
                case 1434969867: {
                    return new String[]{"Duration"};
                }
                case -1494547425: {
                    return new String[]{"boolean"};
                }
                case -553706344: {
                    return new String[]{"CodeableConcept"};
                }
                case 2072805: {
                    return new String[0];
                }
                case 939511774: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("isDerived")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.typeTested.isDerived");
            }
            if (name.equals(SpecimenDefinition.SP_TYPE)) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("preference")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.typeTested.preference");
            }
            if (name.equals(SpecimenDefinition.SP_CONTAINER)) {
                this.container = new SpecimenDefinitionTypeTestedContainerComponent();
                return this.container;
            }
            if (name.equals("requirement")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.typeTested.requirement");
            }
            if (name.equals("retentionTime")) {
                this.retentionTime = new Duration();
                return this.retentionTime;
            }
            if (name.equals("singleUse")) {
                throw new FHIRException("Cannot call addChild on a primitive type SpecimenDefinition.typeTested.singleUse");
            }
            if (name.equals("rejectionCriterion")) {
                return this.addRejectionCriterion();
            }
            if (name.equals("handling")) {
                return this.addHandling();
            }
            if (name.equals("testingDestination")) {
                return this.addTestingDestination();
            }
            return super.addChild(name);
        }

        @Override
        public SpecimenDefinitionTypeTestedComponent copy() {
            SpecimenDefinitionTypeTestedComponent dst = new SpecimenDefinitionTypeTestedComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SpecimenDefinitionTypeTestedComponent dst) {
            super.copyValues(dst);
            dst.isDerived = this.isDerived == null ? null : this.isDerived.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.preference = this.preference == null ? null : this.preference.copy();
            dst.container = this.container == null ? null : this.container.copy();
            dst.requirement = this.requirement == null ? null : this.requirement.copy();
            dst.retentionTime = this.retentionTime == null ? null : this.retentionTime.copy();
            BooleanType booleanType = dst.singleUse = this.singleUse == null ? null : this.singleUse.copy();
            if (this.rejectionCriterion != null) {
                dst.rejectionCriterion = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.rejectionCriterion) {
                    dst.rejectionCriterion.add(codeableConcept.copy());
                }
            }
            if (this.handling != null) {
                dst.handling = new ArrayList<SpecimenDefinitionTypeTestedHandlingComponent>();
                for (SpecimenDefinitionTypeTestedHandlingComponent specimenDefinitionTypeTestedHandlingComponent : this.handling) {
                    dst.handling.add(specimenDefinitionTypeTestedHandlingComponent.copy());
                }
            }
            if (this.testingDestination != null) {
                dst.testingDestination = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.testingDestination) {
                    dst.testingDestination.add(codeableConcept.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedComponent o = (SpecimenDefinitionTypeTestedComponent)other_;
            return SpecimenDefinitionTypeTestedComponent.compareDeep(this.isDerived, o.isDerived, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.type, o.type, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.preference, o.preference, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.container, o.container, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.requirement, o.requirement, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.retentionTime, o.retentionTime, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.singleUse, o.singleUse, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.rejectionCriterion, o.rejectionCriterion, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.handling, o.handling, true) && SpecimenDefinitionTypeTestedComponent.compareDeep(this.testingDestination, o.testingDestination, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SpecimenDefinitionTypeTestedComponent)) {
                return false;
            }
            SpecimenDefinitionTypeTestedComponent o = (SpecimenDefinitionTypeTestedComponent)other_;
            return SpecimenDefinitionTypeTestedComponent.compareValues(this.isDerived, o.isDerived, true) && SpecimenDefinitionTypeTestedComponent.compareValues(this.preference, o.preference, true) && SpecimenDefinitionTypeTestedComponent.compareValues(this.requirement, o.requirement, true) && SpecimenDefinitionTypeTestedComponent.compareValues(this.singleUse, o.singleUse, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.isDerived, this.type, this.preference, this.container, this.requirement, this.retentionTime, this.singleUse, this.rejectionCriterion, this.handling, this.testingDestination});
        }

        @Override
        public String fhirType() {
            return "SpecimenDefinition.typeTested";
        }
    }

    public static class SpecimenContainedPreferenceEnumFactory
    implements EnumFactory<SpecimenContainedPreference> {
        @Override
        public SpecimenContainedPreference fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preferred".equals(codeString)) {
                return SpecimenContainedPreference.PREFERRED;
            }
            if ("alternate".equals(codeString)) {
                return SpecimenContainedPreference.ALTERNATE;
            }
            throw new IllegalArgumentException("Unknown SpecimenContainedPreference code '" + codeString + "'");
        }

        public Enumeration<SpecimenContainedPreference> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SpecimenContainedPreference>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preferred".equals(codeString)) {
                return new Enumeration<SpecimenContainedPreference>(this, SpecimenContainedPreference.PREFERRED);
            }
            if ("alternate".equals(codeString)) {
                return new Enumeration<SpecimenContainedPreference>(this, SpecimenContainedPreference.ALTERNATE);
            }
            throw new FHIRException("Unknown SpecimenContainedPreference code '" + codeString + "'");
        }

        @Override
        public String toCode(SpecimenContainedPreference code) {
            if (code == SpecimenContainedPreference.PREFERRED) {
                return "preferred";
            }
            if (code == SpecimenContainedPreference.ALTERNATE) {
                return "alternate";
            }
            return "?";
        }

        @Override
        public String toSystem(SpecimenContainedPreference code) {
            return code.getSystem();
        }
    }

    public static enum SpecimenContainedPreference {
        PREFERRED,
        ALTERNATE,
        NULL;


        public static SpecimenContainedPreference fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preferred".equals(codeString)) {
                return PREFERRED;
            }
            if ("alternate".equals(codeString)) {
                return ALTERNATE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SpecimenContainedPreference code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREFERRED: {
                    return "preferred";
                }
                case ALTERNATE: {
                    return "alternate";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREFERRED: {
                    return "http://hl7.org/fhir/specimen-contained-preference";
                }
                case ALTERNATE: {
                    return "http://hl7.org/fhir/specimen-contained-preference";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREFERRED: {
                    return "This type of contained specimen is preferred to collect this kind of specimen.";
                }
                case ALTERNATE: {
                    return "This type of conditioned specimen is an alternate.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREFERRED: {
                    return "Preferred";
                }
                case ALTERNATE: {
                    return "Alternate";
                }
            }
            return "?";
        }
    }
}

