/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="OrganizationAffiliation", profile="http://hl7.org/fhir/StructureDefinition/OrganizationAffiliation")
public class OrganizationAffiliation
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business identifiers that are specific to this role", formalDefinition="Business identifiers that are specific to this role.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether this organization affiliation record is in active use", formalDefinition="Whether this organization affiliation record is in active use.")
    protected BooleanType active;
    @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The period during which the participatingOrganization is affiliated with the primary organization", formalDefinition="The period during which the participatingOrganization is affiliated with the primary organization.")
    protected Period period;
    @Child(name="organization", type={Organization.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization where the role is available", formalDefinition="Organization where the role is available (primary organization/has members).")
    protected Reference organization;
    @Child(name="participatingOrganization", type={Organization.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that provides/performs the role (e.g. providing services or is a member of)", formalDefinition="The Participating Organization provides/performs the role(s) defined by the code to the Primary Organization (e.g. providing services or is a member of).")
    protected Reference participatingOrganization;
    @Child(name="network", type={Organization.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Health insurance provider network in which the participatingOrganization provides the role's services (if defined) at the indicated locations (if defined)", formalDefinition="Health insurance provider network in which the participatingOrganization provides the role's services (if defined) at the indicated locations (if defined).")
    protected List<Reference> network;
    @Child(name="code", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Definition of the role the participatingOrganization plays", formalDefinition="Definition of the role the participatingOrganization plays in the association.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/organization-role")
    protected List<CodeableConcept> code;
    @Child(name="specialty", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific specialty of the participatingOrganization in the context of the role", formalDefinition="Specific specialty of the participatingOrganization in the context of the role.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/c80-practice-codes")
    protected List<CodeableConcept> specialty;
    @Child(name="location", type={Location.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The location(s) at which the role occurs", formalDefinition="The location(s) at which the role occurs.")
    protected List<Reference> location;
    @Child(name="healthcareService", type={HealthcareService.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Healthcare services provided through the role", formalDefinition="Healthcare services provided through the role.")
    protected List<Reference> healthcareService;
    @Child(name="telecom", type={ContactPoint.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details at the participatingOrganization relevant to this Affiliation", formalDefinition="Contact details at the participatingOrganization relevant to this Affiliation.")
    protected List<ContactPoint> telecom;
    @Child(name="endpoint", type={Endpoint.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Technical endpoints providing access to services operated for this role", formalDefinition="Technical endpoints providing access to services operated for this role.")
    protected List<Reference> endpoint;
    private static final long serialVersionUID = 522401879L;
    @SearchParamDefinition(name="active", path="OrganizationAffiliation.active", description="Whether this organization affiliation record is in active use", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="date", path="OrganizationAffiliation.period", description="The period during which the participatingOrganization is affiliated with the primary organization", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="email", path="OrganizationAffiliation.telecom.where(system='email')", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";
    public static final TokenClientParam EMAIL = new TokenClientParam("email");
    @SearchParamDefinition(name="endpoint", path="OrganizationAffiliation.endpoint", description="Technical endpoints providing access to services operated for this role", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("OrganizationAffiliation:endpoint").toLocked();
    @SearchParamDefinition(name="identifier", path="OrganizationAffiliation.identifier", description="An organization affiliation's Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="location", path="OrganizationAffiliation.location", description="The location(s) at which the role occurs", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("OrganizationAffiliation:location").toLocked();
    @SearchParamDefinition(name="network", path="OrganizationAffiliation.network", description="Health insurance provider network in which the participatingOrganization provides the role's services (if defined) at the indicated locations (if defined)", type="reference", target={Organization.class})
    public static final String SP_NETWORK = "network";
    public static final ReferenceClientParam NETWORK = new ReferenceClientParam("network");
    public static final Include INCLUDE_NETWORK = new Include("OrganizationAffiliation:network").toLocked();
    @SearchParamDefinition(name="participating-organization", path="OrganizationAffiliation.participatingOrganization", description="The organization that provides services to the primary organization", type="reference", target={Organization.class})
    public static final String SP_PARTICIPATING_ORGANIZATION = "participating-organization";
    public static final ReferenceClientParam PARTICIPATING_ORGANIZATION = new ReferenceClientParam("participating-organization");
    public static final Include INCLUDE_PARTICIPATING_ORGANIZATION = new Include("OrganizationAffiliation:participating-organization").toLocked();
    @SearchParamDefinition(name="phone", path="OrganizationAffiliation.telecom.where(system='phone')", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    public static final TokenClientParam PHONE = new TokenClientParam("phone");
    @SearchParamDefinition(name="primary-organization", path="OrganizationAffiliation.organization", description="The organization that receives the services from the participating organization", type="reference", target={Organization.class})
    public static final String SP_PRIMARY_ORGANIZATION = "primary-organization";
    public static final ReferenceClientParam PRIMARY_ORGANIZATION = new ReferenceClientParam("primary-organization");
    public static final Include INCLUDE_PRIMARY_ORGANIZATION = new Include("OrganizationAffiliation:primary-organization").toLocked();
    @SearchParamDefinition(name="role", path="OrganizationAffiliation.code", description="Definition of the role the participatingOrganization plays", type="token")
    public static final String SP_ROLE = "role";
    public static final TokenClientParam ROLE = new TokenClientParam("role");
    @SearchParamDefinition(name="service", path="OrganizationAffiliation.healthcareService", description="Healthcare services provided through the role", type="reference", target={HealthcareService.class})
    public static final String SP_SERVICE = "service";
    public static final ReferenceClientParam SERVICE = new ReferenceClientParam("service");
    public static final Include INCLUDE_SERVICE = new Include("OrganizationAffiliation:service").toLocked();
    @SearchParamDefinition(name="specialty", path="OrganizationAffiliation.specialty", description="Specific specialty of the participatingOrganization in the context of the role", type="token")
    public static final String SP_SPECIALTY = "specialty";
    public static final TokenClientParam SPECIALTY = new TokenClientParam("specialty");
    @SearchParamDefinition(name="telecom", path="OrganizationAffiliation.telecom", description="The value in any kind of contact", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public OrganizationAffiliation setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public OrganizationAffiliation addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrganizationAffiliation.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public OrganizationAffiliation setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public OrganizationAffiliation setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrganizationAffiliation.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public OrganizationAffiliation setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrganizationAffiliation.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public OrganizationAffiliation setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Reference getParticipatingOrganization() {
        if (this.participatingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrganizationAffiliation.participatingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.participatingOrganization = new Reference();
            }
        }
        return this.participatingOrganization;
    }

    public boolean hasParticipatingOrganization() {
        return this.participatingOrganization != null && !this.participatingOrganization.isEmpty();
    }

    public OrganizationAffiliation setParticipatingOrganization(Reference value) {
        this.participatingOrganization = value;
        return this;
    }

    public List<Reference> getNetwork() {
        if (this.network == null) {
            this.network = new ArrayList<Reference>();
        }
        return this.network;
    }

    public OrganizationAffiliation setNetwork(List<Reference> theNetwork) {
        this.network = theNetwork;
        return this;
    }

    public boolean hasNetwork() {
        if (this.network == null) {
            return false;
        }
        for (Reference item : this.network) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addNetwork() {
        Reference t = new Reference();
        if (this.network == null) {
            this.network = new ArrayList<Reference>();
        }
        this.network.add(t);
        return t;
    }

    public OrganizationAffiliation addNetwork(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.network == null) {
            this.network = new ArrayList<Reference>();
        }
        this.network.add(t);
        return this;
    }

    public Reference getNetworkFirstRep() {
        if (this.getNetwork().isEmpty()) {
            this.addNetwork();
        }
        return this.getNetwork().get(0);
    }

    public List<CodeableConcept> getCode() {
        if (this.code == null) {
            this.code = new ArrayList<CodeableConcept>();
        }
        return this.code;
    }

    public OrganizationAffiliation setCode(List<CodeableConcept> theCode) {
        this.code = theCode;
        return this;
    }

    public boolean hasCode() {
        if (this.code == null) {
            return false;
        }
        for (CodeableConcept item : this.code) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.code == null) {
            this.code = new ArrayList<CodeableConcept>();
        }
        this.code.add(t);
        return t;
    }

    public OrganizationAffiliation addCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.code == null) {
            this.code = new ArrayList<CodeableConcept>();
        }
        this.code.add(t);
        return this;
    }

    public CodeableConcept getCodeFirstRep() {
        if (this.getCode().isEmpty()) {
            this.addCode();
        }
        return this.getCode().get(0);
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public OrganizationAffiliation setSpecialty(List<CodeableConcept> theSpecialty) {
        this.specialty = theSpecialty;
        return this;
    }

    public boolean hasSpecialty() {
        if (this.specialty == null) {
            return false;
        }
        for (CodeableConcept item : this.specialty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialty() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return t;
    }

    public OrganizationAffiliation addSpecialty(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return this;
    }

    public CodeableConcept getSpecialtyFirstRep() {
        if (this.getSpecialty().isEmpty()) {
            this.addSpecialty();
        }
        return this.getSpecialty().get(0);
    }

    public List<Reference> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        return this.location;
    }

    public OrganizationAffiliation setLocation(List<Reference> theLocation) {
        this.location = theLocation;
        return this;
    }

    public boolean hasLocation() {
        if (this.location == null) {
            return false;
        }
        for (Reference item : this.location) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addLocation() {
        Reference t = new Reference();
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        this.location.add(t);
        return t;
    }

    public OrganizationAffiliation addLocation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.location == null) {
            this.location = new ArrayList<Reference>();
        }
        this.location.add(t);
        return this;
    }

    public Reference getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            this.addLocation();
        }
        return this.getLocation().get(0);
    }

    public List<Reference> getHealthcareService() {
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        return this.healthcareService;
    }

    public OrganizationAffiliation setHealthcareService(List<Reference> theHealthcareService) {
        this.healthcareService = theHealthcareService;
        return this;
    }

    public boolean hasHealthcareService() {
        if (this.healthcareService == null) {
            return false;
        }
        for (Reference item : this.healthcareService) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addHealthcareService() {
        Reference t = new Reference();
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        this.healthcareService.add(t);
        return t;
    }

    public OrganizationAffiliation addHealthcareService(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.healthcareService == null) {
            this.healthcareService = new ArrayList<Reference>();
        }
        this.healthcareService.add(t);
        return this;
    }

    public Reference getHealthcareServiceFirstRep() {
        if (this.getHealthcareService().isEmpty()) {
            this.addHealthcareService();
        }
        return this.getHealthcareService().get(0);
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public OrganizationAffiliation setTelecom(List<ContactPoint> theTelecom) {
        this.telecom = theTelecom;
        return this;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public OrganizationAffiliation addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public ContactPoint getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public OrganizationAffiliation setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public OrganizationAffiliation addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers that are specific to this role.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_ACTIVE, "boolean", "Whether this organization affiliation record is in active use.", 0, 1, this.active));
        children.add(new Property("period", "Period", "The period during which the participatingOrganization is affiliated with the primary organization.", 0, 1, this.period));
        children.add(new Property("organization", "Reference(Organization)", "Organization where the role is available (primary organization/has members).", 0, 1, this.organization));
        children.add(new Property("participatingOrganization", "Reference(Organization)", "The Participating Organization provides/performs the role(s) defined by the code to the Primary Organization (e.g. providing services or is a member of).", 0, 1, this.participatingOrganization));
        children.add(new Property(SP_NETWORK, "Reference(Organization)", "Health insurance provider network in which the participatingOrganization provides the role's services (if defined) at the indicated locations (if defined).", 0, Integer.MAX_VALUE, this.network));
        children.add(new Property("code", "CodeableConcept", "Definition of the role the participatingOrganization plays in the association.", 0, Integer.MAX_VALUE, this.code));
        children.add(new Property(SP_SPECIALTY, "CodeableConcept", "Specific specialty of the participatingOrganization in the context of the role.", 0, Integer.MAX_VALUE, this.specialty));
        children.add(new Property(SP_LOCATION, "Reference(Location)", "The location(s) at which the role occurs.", 0, Integer.MAX_VALUE, this.location));
        children.add(new Property("healthcareService", "Reference(HealthcareService)", "Healthcare services provided through the role.", 0, Integer.MAX_VALUE, this.healthcareService));
        children.add(new Property(SP_TELECOM, "ContactPoint", "Contact details at the participatingOrganization relevant to this Affiliation.", 0, Integer.MAX_VALUE, this.telecom));
        children.add(new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for this role.", 0, Integer.MAX_VALUE, this.endpoint));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers that are specific to this role.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property(SP_ACTIVE, "boolean", "Whether this organization affiliation record is in active use.", 0, 1, this.active);
            }
            case -991726143: {
                return new Property("period", "Period", "The period during which the participatingOrganization is affiliated with the primary organization.", 0, 1, this.period);
            }
            case 1178922291: {
                return new Property("organization", "Reference(Organization)", "Organization where the role is available (primary organization/has members).", 0, 1, this.organization);
            }
            case 1593310702: {
                return new Property("participatingOrganization", "Reference(Organization)", "The Participating Organization provides/performs the role(s) defined by the code to the Primary Organization (e.g. providing services or is a member of).", 0, 1, this.participatingOrganization);
            }
            case 1843485230: {
                return new Property(SP_NETWORK, "Reference(Organization)", "Health insurance provider network in which the participatingOrganization provides the role's services (if defined) at the indicated locations (if defined).", 0, Integer.MAX_VALUE, this.network);
            }
            case 3059181: {
                return new Property("code", "CodeableConcept", "Definition of the role the participatingOrganization plays in the association.", 0, Integer.MAX_VALUE, this.code);
            }
            case -1694759682: {
                return new Property(SP_SPECIALTY, "CodeableConcept", "Specific specialty of the participatingOrganization in the context of the role.", 0, Integer.MAX_VALUE, this.specialty);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "Reference(Location)", "The location(s) at which the role occurs.", 0, Integer.MAX_VALUE, this.location);
            }
            case 1289661064: {
                return new Property("healthcareService", "Reference(HealthcareService)", "Healthcare services provided through the role.", 0, Integer.MAX_VALUE, this.healthcareService);
            }
            case -1429363305: {
                return new Property(SP_TELECOM, "ContactPoint", "Contact details at the participatingOrganization relevant to this Affiliation.", 0, Integer.MAX_VALUE, this.telecom);
            }
            case 1741102485: {
                return new Property(SP_ENDPOINT, "Reference(Endpoint)", "Technical endpoints providing access to services operated for this role.", 0, Integer.MAX_VALUE, this.endpoint);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.period;
                }
                return baseArray;
            }
            case 1178922291: {
                Base[] baseArray;
                if (this.organization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.organization;
                }
                return baseArray;
            }
            case 1593310702: {
                Base[] baseArray;
                if (this.participatingOrganization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.participatingOrganization;
                }
                return baseArray;
            }
            case 1843485230: {
                return this.network == null ? new Base[]{} : this.network.toArray(new Base[this.network.size()]);
            }
            case 3059181: {
                return this.code == null ? new Base[]{} : this.code.toArray(new Base[this.code.size()]);
            }
            case -1694759682: {
                return this.specialty == null ? new Base[]{} : this.specialty.toArray(new Base[this.specialty.size()]);
            }
            case 1901043637: {
                return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
            }
            case 1289661064: {
                return this.healthcareService == null ? new Base[]{} : this.healthcareService.toArray(new Base[this.healthcareService.size()]);
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case 1178922291: {
                this.organization = TypeConvertor.castToReference(value);
                return value;
            }
            case 1593310702: {
                this.participatingOrganization = TypeConvertor.castToReference(value);
                return value;
            }
            case 1843485230: {
                this.getNetwork().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 3059181: {
                this.getCode().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1694759682: {
                this.getSpecialty().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 1901043637: {
                this.getLocation().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1289661064: {
                this.getHealthcareService().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1429363305: {
                this.getTelecom().add(TypeConvertor.castToContactPoint(value));
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(TypeConvertor.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = TypeConvertor.castToBoolean(value);
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals("organization")) {
            this.organization = TypeConvertor.castToReference(value);
        } else if (name.equals("participatingOrganization")) {
            this.participatingOrganization = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_NETWORK)) {
            this.getNetwork().add(TypeConvertor.castToReference(value));
        } else if (name.equals("code")) {
            this.getCode().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_SPECIALTY)) {
            this.getSpecialty().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_LOCATION)) {
            this.getLocation().add(TypeConvertor.castToReference(value));
        } else if (name.equals("healthcareService")) {
            this.getHealthcareService().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_TELECOM)) {
            this.getTelecom().add(TypeConvertor.castToContactPoint(value));
        } else if (name.equals(SP_ENDPOINT)) {
            this.getEndpoint().add(TypeConvertor.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case 1178922291: {
                return this.getOrganization();
            }
            case 1593310702: {
                return this.getParticipatingOrganization();
            }
            case 1843485230: {
                return this.addNetwork();
            }
            case 3059181: {
                return this.addCode();
            }
            case -1694759682: {
                return this.addSpecialty();
            }
            case 1901043637: {
                return this.addLocation();
            }
            case 1289661064: {
                return this.addHealthcareService();
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case 1178922291: {
                return new String[]{"Reference"};
            }
            case 1593310702: {
                return new String[]{"Reference"};
            }
            case 1843485230: {
                return new String[]{"Reference"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1694759682: {
                return new String[]{"CodeableConcept"};
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case 1289661064: {
                return new String[]{"Reference"};
            }
            case -1429363305: {
                return new String[]{"ContactPoint"};
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OrganizationAffiliation.active");
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("organization")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("participatingOrganization")) {
            this.participatingOrganization = new Reference();
            return this.participatingOrganization;
        }
        if (name.equals(SP_NETWORK)) {
            return this.addNetwork();
        }
        if (name.equals("code")) {
            return this.addCode();
        }
        if (name.equals(SP_SPECIALTY)) {
            return this.addSpecialty();
        }
        if (name.equals(SP_LOCATION)) {
            return this.addLocation();
        }
        if (name.equals("healthcareService")) {
            return this.addHealthcareService();
        }
        if (name.equals(SP_TELECOM)) {
            return this.addTelecom();
        }
        if (name.equals(SP_ENDPOINT)) {
            return this.addEndpoint();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "OrganizationAffiliation";
    }

    @Override
    public OrganizationAffiliation copy() {
        OrganizationAffiliation dst = new OrganizationAffiliation();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(OrganizationAffiliation dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.active = this.active == null ? null : this.active.copy();
        dst.period = this.period == null ? null : this.period.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        Reference reference = dst.participatingOrganization = this.participatingOrganization == null ? null : this.participatingOrganization.copy();
        if (this.network != null) {
            dst.network = new ArrayList<Reference>();
            for (Reference reference2 : this.network) {
                dst.network.add(reference2.copy());
            }
        }
        if (this.code != null) {
            dst.code = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.code) {
                dst.code.add(codeableConcept.copy());
            }
        }
        if (this.specialty != null) {
            dst.specialty = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.specialty) {
                dst.specialty.add(codeableConcept.copy());
            }
        }
        if (this.location != null) {
            dst.location = new ArrayList<Reference>();
            for (Reference reference3 : this.location) {
                dst.location.add(reference3.copy());
            }
        }
        if (this.healthcareService != null) {
            dst.healthcareService = new ArrayList<Reference>();
            for (Reference reference4 : this.healthcareService) {
                dst.healthcareService.add(reference4.copy());
            }
        }
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference5 : this.endpoint) {
                dst.endpoint.add(reference5.copy());
            }
        }
    }

    protected OrganizationAffiliation typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof OrganizationAffiliation)) {
            return false;
        }
        OrganizationAffiliation o = (OrganizationAffiliation)other_;
        return OrganizationAffiliation.compareDeep(this.identifier, o.identifier, true) && OrganizationAffiliation.compareDeep(this.active, o.active, true) && OrganizationAffiliation.compareDeep(this.period, o.period, true) && OrganizationAffiliation.compareDeep(this.organization, o.organization, true) && OrganizationAffiliation.compareDeep(this.participatingOrganization, o.participatingOrganization, true) && OrganizationAffiliation.compareDeep(this.network, o.network, true) && OrganizationAffiliation.compareDeep(this.code, o.code, true) && OrganizationAffiliation.compareDeep(this.specialty, o.specialty, true) && OrganizationAffiliation.compareDeep(this.location, o.location, true) && OrganizationAffiliation.compareDeep(this.healthcareService, o.healthcareService, true) && OrganizationAffiliation.compareDeep(this.telecom, o.telecom, true) && OrganizationAffiliation.compareDeep(this.endpoint, o.endpoint, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof OrganizationAffiliation)) {
            return false;
        }
        OrganizationAffiliation o = (OrganizationAffiliation)other_;
        return OrganizationAffiliation.compareValues(this.active, o.active, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.active, this.period, this.organization, this.participatingOrganization, this.network, this.code, this.specialty, this.location, this.healthcareService, this.telecom, this.endpoint});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.OrganizationAffiliation;
    }
}

