/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Encounter;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImagingStudy", profile="http://hl7.org/fhir/StructureDefinition/ImagingStudy")
public class ImagingStudy
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifiers for the whole study", formalDefinition="Identifiers for the ImagingStudy such as DICOM Study Instance UID, and Accession Number.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="registered | available | cancelled | entered-in-error | unknown", formalDefinition="The current state of the ImagingStudy.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/imagingstudy-status")
    protected Enumeration<ImagingStudyStatus> status;
    @Child(name="modality", type={Coding.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="All of the distinct values for series' modalities", formalDefinition="A list of all the distinct values of series.modality. This may include both aquisition and non-aquisition modalities.")
    @Binding(valueSet="http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_33.html")
    protected List<Coding> modality;
    @Child(name="subject", type={Patient.class, Device.class, Group.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who or what is the subject of the study", formalDefinition="The subject, typically a patient, of the imaging study.")
    protected Reference subject;
    @Child(name="encounter", type={Encounter.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter with which this imaging study is associated", formalDefinition="The healthcare event (e.g. a patient and healthcare provider interaction) during which this ImagingStudy is made.")
    protected Reference encounter;
    @Child(name="started", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the study was started", formalDefinition="Date and time the study started.")
    protected DateTimeType started;
    @Child(name="basedOn", type={CarePlan.class, ServiceRequest.class, Appointment.class, AppointmentResponse.class, Task.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Request fulfilled", formalDefinition="A list of the diagnostic requests that resulted in this imaging study being performed.")
    protected List<Reference> basedOn;
    @Child(name="referrer", type={Practitioner.class, PractitionerRole.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Referring physician", formalDefinition="The requesting/referring physician.")
    protected Reference referrer;
    @Child(name="interpreter", type={Practitioner.class, PractitionerRole.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Who interpreted images", formalDefinition="Who read the study and interpreted the images or other content.")
    protected List<Reference> interpreter;
    @Child(name="endpoint", type={Endpoint.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Study access endpoint", formalDefinition="The network service providing access (e.g., query, view, or retrieval) for the study. See implementation notes for information about using DICOM endpoints. A study-level endpoint applies to each series in the study, unless overridden by a series-level endpoint with the same Endpoint.connectionType.")
    protected List<Reference> endpoint;
    @Child(name="numberOfSeries", type={UnsignedIntType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of Study Related Series", formalDefinition="Number of Series in the Study. This value given may be larger than the number of series elements this Resource contains due to resource availability, security, or other factors. This element should be present if any series elements are present.")
    protected UnsignedIntType numberOfSeries;
    @Child(name="numberOfInstances", type={UnsignedIntType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of Study Related Instances", formalDefinition="Number of SOP Instances in Study. This value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.")
    protected UnsignedIntType numberOfInstances;
    @Child(name="procedure", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The performed procedure or code", formalDefinition="The procedure or code from which this ImagingStudy was part of.")
    protected List<ImagingStudyProcedureComponent> procedure;
    @Child(name="location", type={Location.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where ImagingStudy occurred", formalDefinition="The principal physical location where the ImagingStudy was performed.")
    protected Reference location;
    @Child(name="reason", type={CodeableReference.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Why the study was requested / performed", formalDefinition="Description of clinical condition indicating why the ImagingStudy was requested, and/or Indicates another resource whose existence justifies this Study.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-reason")
    protected List<CodeableReference> reason;
    @Child(name="note", type={Annotation.class}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="User-defined comments", formalDefinition="Per the recommended DICOM mapping, this element is derived from the Study Description attribute (0008,1030). Observations or findings about the imaging study should be recorded in another resource, e.g. Observation, and not in this element.")
    protected List<Annotation> note;
    @Child(name="description", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Institution-generated description", formalDefinition="The Imaging Manager description of the study. Institution-generated description or classification of the Study (component) performed.")
    protected StringType description;
    @Child(name="series", type={}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Each study has one or more series of instances", formalDefinition="Each study has one or more series of images or other content.")
    protected List<ImagingStudySeriesComponent> series;
    private static final long serialVersionUID = -564369223L;
    @SearchParamDefinition(name="basedon", path="ImagingStudy.basedOn", description="The order for the image", type="reference", target={Appointment.class, AppointmentResponse.class, CarePlan.class, ServiceRequest.class, Task.class})
    public static final String SP_BASEDON = "basedon";
    public static final ReferenceClientParam BASEDON = new ReferenceClientParam("basedon");
    public static final Include INCLUDE_BASEDON = new Include("ImagingStudy:basedon").toLocked();
    @SearchParamDefinition(name="bodysite", path="ImagingStudy.series.bodySite", description="The body site studied", type="token")
    public static final String SP_BODYSITE = "bodysite";
    public static final TokenClientParam BODYSITE = new TokenClientParam("bodysite");
    @SearchParamDefinition(name="dicom-class", path="ImagingStudy.series.instance.sopClass", description="The type of the instance", type="token")
    public static final String SP_DICOM_CLASS = "dicom-class";
    public static final TokenClientParam DICOM_CLASS = new TokenClientParam("dicom-class");
    @SearchParamDefinition(name="encounter", path="ImagingStudy.encounter", description="The context of the study", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("ImagingStudy:encounter").toLocked();
    @SearchParamDefinition(name="endpoint", path="ImagingStudy.endpoint | ImagingStudy.series.endpoint", description="The endpoint for the study or series", type="reference", target={Endpoint.class})
    public static final String SP_ENDPOINT = "endpoint";
    public static final ReferenceClientParam ENDPOINT = new ReferenceClientParam("endpoint");
    public static final Include INCLUDE_ENDPOINT = new Include("ImagingStudy:endpoint").toLocked();
    @SearchParamDefinition(name="instance", path="ImagingStudy.series.instance.uid", description="SOP Instance UID for an instance", type="token")
    public static final String SP_INSTANCE = "instance";
    public static final TokenClientParam INSTANCE = new TokenClientParam("instance");
    @SearchParamDefinition(name="interpreter", path="ImagingStudy.interpreter", description="Who interpreted the images", type="reference", target={Practitioner.class, PractitionerRole.class})
    public static final String SP_INTERPRETER = "interpreter";
    public static final ReferenceClientParam INTERPRETER = new ReferenceClientParam("interpreter");
    public static final Include INCLUDE_INTERPRETER = new Include("ImagingStudy:interpreter").toLocked();
    @SearchParamDefinition(name="modality", path="ImagingStudy.series.modality", description="The modality of the series", type="token")
    public static final String SP_MODALITY = "modality";
    public static final TokenClientParam MODALITY = new TokenClientParam("modality");
    @SearchParamDefinition(name="performer", path="ImagingStudy.series.performer.actor", description="The person who performed the study", type="reference", target={CareTeam.class, Device.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("ImagingStudy:performer").toLocked();
    @SearchParamDefinition(name="reason", path="", description="The reason for the study", type="token")
    public static final String SP_REASON = "reason";
    public static final TokenClientParam REASON = new TokenClientParam("reason");
    @SearchParamDefinition(name="referrer", path="ImagingStudy.referrer", description="The referring physician", type="reference", target={Practitioner.class, PractitionerRole.class})
    public static final String SP_REFERRER = "referrer";
    public static final ReferenceClientParam REFERRER = new ReferenceClientParam("referrer");
    public static final Include INCLUDE_REFERRER = new Include("ImagingStudy:referrer").toLocked();
    @SearchParamDefinition(name="series", path="ImagingStudy.series.uid", description="DICOM Series Instance UID for a series", type="token")
    public static final String SP_SERIES = "series";
    public static final TokenClientParam SERIES = new TokenClientParam("series");
    @SearchParamDefinition(name="started", path="ImagingStudy.started", description="When the study was started", type="date")
    public static final String SP_STARTED = "started";
    public static final DateClientParam STARTED = new DateClientParam("started");
    @SearchParamDefinition(name="status", path="ImagingStudy.status", description="The status of the study", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="ImagingStudy.subject", description="Who the study is about", type="reference", target={Device.class, Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ImagingStudy:subject").toLocked();
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.masterIdentifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Master Version Specific Identifier\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID and Accession number\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.patient | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUseStatement.subject | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUseStatement](deviceusestatement.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Group.class, Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ImagingStudy:patient").toLocked();

    public ImagingStudy() {
    }

    public ImagingStudy(ImagingStudyStatus status, Reference subject) {
        this.setStatus(status);
        this.setSubject(subject);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ImagingStudy setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ImagingStudy addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<ImagingStudyStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ImagingStudyStatus>(new ImagingStudyStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ImagingStudy setStatusElement(Enumeration<ImagingStudyStatus> value) {
        this.status = value;
        return this;
    }

    public ImagingStudyStatus getStatus() {
        return this.status == null ? null : (ImagingStudyStatus)((Object)this.status.getValue());
    }

    public ImagingStudy setStatus(ImagingStudyStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ImagingStudyStatus>(new ImagingStudyStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<Coding> getModality() {
        if (this.modality == null) {
            this.modality = new ArrayList<Coding>();
        }
        return this.modality;
    }

    public ImagingStudy setModality(List<Coding> theModality) {
        this.modality = theModality;
        return this;
    }

    public boolean hasModality() {
        if (this.modality == null) {
            return false;
        }
        for (Coding item : this.modality) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addModality() {
        Coding t = new Coding();
        if (this.modality == null) {
            this.modality = new ArrayList<Coding>();
        }
        this.modality.add(t);
        return t;
    }

    public ImagingStudy addModality(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.modality == null) {
            this.modality = new ArrayList<Coding>();
        }
        this.modality.add(t);
        return this;
    }

    public Coding getModalityFirstRep() {
        if (this.getModality().isEmpty()) {
            this.addModality();
        }
        return this.getModality().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ImagingStudy setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public ImagingStudy setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public DateTimeType getStartedElement() {
        if (this.started == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.started");
            }
            if (Configuration.doAutoCreate()) {
                this.started = new DateTimeType();
            }
        }
        return this.started;
    }

    public boolean hasStartedElement() {
        return this.started != null && !this.started.isEmpty();
    }

    public boolean hasStarted() {
        return this.started != null && !this.started.isEmpty();
    }

    public ImagingStudy setStartedElement(DateTimeType value) {
        this.started = value;
        return this;
    }

    public Date getStarted() {
        return this.started == null ? null : (Date)this.started.getValue();
    }

    public ImagingStudy setStarted(Date value) {
        if (value == null) {
            this.started = null;
        } else {
            if (this.started == null) {
                this.started = new DateTimeType();
            }
            this.started.setValue(value);
        }
        return this;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public ImagingStudy setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public ImagingStudy addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public Reference getReferrer() {
        if (this.referrer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.referrer");
            }
            if (Configuration.doAutoCreate()) {
                this.referrer = new Reference();
            }
        }
        return this.referrer;
    }

    public boolean hasReferrer() {
        return this.referrer != null && !this.referrer.isEmpty();
    }

    public ImagingStudy setReferrer(Reference value) {
        this.referrer = value;
        return this;
    }

    public List<Reference> getInterpreter() {
        if (this.interpreter == null) {
            this.interpreter = new ArrayList<Reference>();
        }
        return this.interpreter;
    }

    public ImagingStudy setInterpreter(List<Reference> theInterpreter) {
        this.interpreter = theInterpreter;
        return this;
    }

    public boolean hasInterpreter() {
        if (this.interpreter == null) {
            return false;
        }
        for (Reference item : this.interpreter) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addInterpreter() {
        Reference t = new Reference();
        if (this.interpreter == null) {
            this.interpreter = new ArrayList<Reference>();
        }
        this.interpreter.add(t);
        return t;
    }

    public ImagingStudy addInterpreter(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.interpreter == null) {
            this.interpreter = new ArrayList<Reference>();
        }
        this.interpreter.add(t);
        return this;
    }

    public Reference getInterpreterFirstRep() {
        if (this.getInterpreter().isEmpty()) {
            this.addInterpreter();
        }
        return this.getInterpreter().get(0);
    }

    public List<Reference> getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        return this.endpoint;
    }

    public ImagingStudy setEndpoint(List<Reference> theEndpoint) {
        this.endpoint = theEndpoint;
        return this;
    }

    public boolean hasEndpoint() {
        if (this.endpoint == null) {
            return false;
        }
        for (Reference item : this.endpoint) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEndpoint() {
        Reference t = new Reference();
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return t;
    }

    public ImagingStudy addEndpoint(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.endpoint == null) {
            this.endpoint = new ArrayList<Reference>();
        }
        this.endpoint.add(t);
        return this;
    }

    public Reference getEndpointFirstRep() {
        if (this.getEndpoint().isEmpty()) {
            this.addEndpoint();
        }
        return this.getEndpoint().get(0);
    }

    public UnsignedIntType getNumberOfSeriesElement() {
        if (this.numberOfSeries == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.numberOfSeries");
            }
            if (Configuration.doAutoCreate()) {
                this.numberOfSeries = new UnsignedIntType();
            }
        }
        return this.numberOfSeries;
    }

    public boolean hasNumberOfSeriesElement() {
        return this.numberOfSeries != null && !this.numberOfSeries.isEmpty();
    }

    public boolean hasNumberOfSeries() {
        return this.numberOfSeries != null && !this.numberOfSeries.isEmpty();
    }

    public ImagingStudy setNumberOfSeriesElement(UnsignedIntType value) {
        this.numberOfSeries = value;
        return this;
    }

    public int getNumberOfSeries() {
        return this.numberOfSeries == null || this.numberOfSeries.isEmpty() ? 0 : (Integer)this.numberOfSeries.getValue();
    }

    public ImagingStudy setNumberOfSeries(int value) {
        if (this.numberOfSeries == null) {
            this.numberOfSeries = new UnsignedIntType();
        }
        this.numberOfSeries.setValue((Object)value);
        return this;
    }

    public UnsignedIntType getNumberOfInstancesElement() {
        if (this.numberOfInstances == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.numberOfInstances");
            }
            if (Configuration.doAutoCreate()) {
                this.numberOfInstances = new UnsignedIntType();
            }
        }
        return this.numberOfInstances;
    }

    public boolean hasNumberOfInstancesElement() {
        return this.numberOfInstances != null && !this.numberOfInstances.isEmpty();
    }

    public boolean hasNumberOfInstances() {
        return this.numberOfInstances != null && !this.numberOfInstances.isEmpty();
    }

    public ImagingStudy setNumberOfInstancesElement(UnsignedIntType value) {
        this.numberOfInstances = value;
        return this;
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances == null || this.numberOfInstances.isEmpty() ? 0 : (Integer)this.numberOfInstances.getValue();
    }

    public ImagingStudy setNumberOfInstances(int value) {
        if (this.numberOfInstances == null) {
            this.numberOfInstances = new UnsignedIntType();
        }
        this.numberOfInstances.setValue((Object)value);
        return this;
    }

    public List<ImagingStudyProcedureComponent> getProcedure() {
        if (this.procedure == null) {
            this.procedure = new ArrayList<ImagingStudyProcedureComponent>();
        }
        return this.procedure;
    }

    public ImagingStudy setProcedure(List<ImagingStudyProcedureComponent> theProcedure) {
        this.procedure = theProcedure;
        return this;
    }

    public boolean hasProcedure() {
        if (this.procedure == null) {
            return false;
        }
        for (ImagingStudyProcedureComponent item : this.procedure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImagingStudyProcedureComponent addProcedure() {
        ImagingStudyProcedureComponent t = new ImagingStudyProcedureComponent();
        if (this.procedure == null) {
            this.procedure = new ArrayList<ImagingStudyProcedureComponent>();
        }
        this.procedure.add(t);
        return t;
    }

    public ImagingStudy addProcedure(ImagingStudyProcedureComponent t) {
        if (t == null) {
            return this;
        }
        if (this.procedure == null) {
            this.procedure = new ArrayList<ImagingStudyProcedureComponent>();
        }
        this.procedure.add(t);
        return this;
    }

    public ImagingStudyProcedureComponent getProcedureFirstRep() {
        if (this.getProcedure().isEmpty()) {
            this.addProcedure();
        }
        return this.getProcedure().get(0);
    }

    public Reference getLocation() {
        if (this.location == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.location");
            }
            if (Configuration.doAutoCreate()) {
                this.location = new Reference();
            }
        }
        return this.location;
    }

    public boolean hasLocation() {
        return this.location != null && !this.location.isEmpty();
    }

    public ImagingStudy setLocation(Reference value) {
        this.location = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public ImagingStudy setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public ImagingStudy addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ImagingStudy setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public ImagingStudy addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ImagingStudy setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ImagingStudy setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<ImagingStudySeriesComponent> getSeries() {
        if (this.series == null) {
            this.series = new ArrayList<ImagingStudySeriesComponent>();
        }
        return this.series;
    }

    public ImagingStudy setSeries(List<ImagingStudySeriesComponent> theSeries) {
        this.series = theSeries;
        return this;
    }

    public boolean hasSeries() {
        if (this.series == null) {
            return false;
        }
        for (ImagingStudySeriesComponent item : this.series) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImagingStudySeriesComponent addSeries() {
        ImagingStudySeriesComponent t = new ImagingStudySeriesComponent();
        if (this.series == null) {
            this.series = new ArrayList<ImagingStudySeriesComponent>();
        }
        this.series.add(t);
        return t;
    }

    public ImagingStudy addSeries(ImagingStudySeriesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.series == null) {
            this.series = new ArrayList<ImagingStudySeriesComponent>();
        }
        this.series.add(t);
        return this;
    }

    public ImagingStudySeriesComponent getSeriesFirstRep() {
        if (this.getSeries().isEmpty()) {
            this.addSeries();
        }
        return this.getSeries().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers for the ImagingStudy such as DICOM Study Instance UID, and Accession Number.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "The current state of the ImagingStudy.", 0, 1, this.status));
        children.add(new Property(SP_MODALITY, "Coding", "A list of all the distinct values of series.modality. This may include both aquisition and non-aquisition modalities.", 0, Integer.MAX_VALUE, this.modality));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Device|Group)", "The subject, typically a patient, of the imaging study.", 0, 1, this.subject));
        children.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The healthcare event (e.g. a patient and healthcare provider interaction) during which this ImagingStudy is made.", 0, 1, this.encounter));
        children.add(new Property(SP_STARTED, "dateTime", "Date and time the study started.", 0, 1, this.started));
        children.add(new Property("basedOn", "Reference(CarePlan|ServiceRequest|Appointment|AppointmentResponse|Task)", "A list of the diagnostic requests that resulted in this imaging study being performed.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_REFERRER, "Reference(Practitioner|PractitionerRole)", "The requesting/referring physician.", 0, 1, this.referrer));
        children.add(new Property(SP_INTERPRETER, "Reference(Practitioner|PractitionerRole)", "Who read the study and interpreted the images or other content.", 0, Integer.MAX_VALUE, this.interpreter));
        children.add(new Property(SP_ENDPOINT, "Reference(Endpoint)", "The network service providing access (e.g., query, view, or retrieval) for the study. See implementation notes for information about using DICOM endpoints. A study-level endpoint applies to each series in the study, unless overridden by a series-level endpoint with the same Endpoint.connectionType.", 0, Integer.MAX_VALUE, this.endpoint));
        children.add(new Property("numberOfSeries", "unsignedInt", "Number of Series in the Study. This value given may be larger than the number of series elements this Resource contains due to resource availability, security, or other factors. This element should be present if any series elements are present.", 0, 1, this.numberOfSeries));
        children.add(new Property("numberOfInstances", "unsignedInt", "Number of SOP Instances in Study. This value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.", 0, 1, this.numberOfInstances));
        children.add(new Property("procedure", "", "The procedure or code from which this ImagingStudy was part of.", 0, Integer.MAX_VALUE, this.procedure));
        children.add(new Property("location", "Reference(Location)", "The principal physical location where the ImagingStudy was performed.", 0, 1, this.location));
        children.add(new Property(SP_REASON, "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "Description of clinical condition indicating why the ImagingStudy was requested, and/or Indicates another resource whose existence justifies this Study.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property("note", "Annotation", "Per the recommended DICOM mapping, this element is derived from the Study Description attribute (0008,1030). Observations or findings about the imaging study should be recorded in another resource, e.g. Observation, and not in this element.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("description", "string", "The Imaging Manager description of the study. Institution-generated description or classification of the Study (component) performed.", 0, 1, this.description));
        children.add(new Property(SP_SERIES, "", "Each study has one or more series of images or other content.", 0, Integer.MAX_VALUE, this.series));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers for the ImagingStudy such as DICOM Study Instance UID, and Accession Number.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the ImagingStudy.", 0, 1, this.status);
            }
            case -622722335: {
                return new Property(SP_MODALITY, "Coding", "A list of all the distinct values of series.modality. This may include both aquisition and non-aquisition modalities.", 0, Integer.MAX_VALUE, this.modality);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Device|Group)", "The subject, typically a patient, of the imaging study.", 0, 1, this.subject);
            }
            case 1524132147: {
                return new Property(SP_ENCOUNTER, "Reference(Encounter)", "The healthcare event (e.g. a patient and healthcare provider interaction) during which this ImagingStudy is made.", 0, 1, this.encounter);
            }
            case -1897185151: {
                return new Property(SP_STARTED, "dateTime", "Date and time the study started.", 0, 1, this.started);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(CarePlan|ServiceRequest|Appointment|AppointmentResponse|Task)", "A list of the diagnostic requests that resulted in this imaging study being performed.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -722568161: {
                return new Property(SP_REFERRER, "Reference(Practitioner|PractitionerRole)", "The requesting/referring physician.", 0, 1, this.referrer);
            }
            case -2008009094: {
                return new Property(SP_INTERPRETER, "Reference(Practitioner|PractitionerRole)", "Who read the study and interpreted the images or other content.", 0, Integer.MAX_VALUE, this.interpreter);
            }
            case 1741102485: {
                return new Property(SP_ENDPOINT, "Reference(Endpoint)", "The network service providing access (e.g., query, view, or retrieval) for the study. See implementation notes for information about using DICOM endpoints. A study-level endpoint applies to each series in the study, unless overridden by a series-level endpoint with the same Endpoint.connectionType.", 0, Integer.MAX_VALUE, this.endpoint);
            }
            case 1920000407: {
                return new Property("numberOfSeries", "unsignedInt", "Number of Series in the Study. This value given may be larger than the number of series elements this Resource contains due to resource availability, security, or other factors. This element should be present if any series elements are present.", 0, 1, this.numberOfSeries);
            }
            case -1043544226: {
                return new Property("numberOfInstances", "unsignedInt", "Number of SOP Instances in Study. This value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.", 0, 1, this.numberOfInstances);
            }
            case -1095204141: {
                return new Property("procedure", "", "The procedure or code from which this ImagingStudy was part of.", 0, Integer.MAX_VALUE, this.procedure);
            }
            case 1901043637: {
                return new Property("location", "Reference(Location)", "The principal physical location where the ImagingStudy was performed.", 0, 1, this.location);
            }
            case -934964668: {
                return new Property(SP_REASON, "CodeableReference(Condition|Observation|DiagnosticReport|DocumentReference)", "Description of clinical condition indicating why the ImagingStudy was requested, and/or Indicates another resource whose existence justifies this Study.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Per the recommended DICOM mapping, this element is derived from the Study Description attribute (0008,1030). Observations or findings about the imaging study should be recorded in another resource, e.g. Observation, and not in this element.", 0, Integer.MAX_VALUE, this.note);
            }
            case -1724546052: {
                return new Property("description", "string", "The Imaging Manager description of the study. Institution-generated description or classification of the Study (component) performed.", 0, 1, this.description);
            }
            case -905838985: {
                return new Property(SP_SERIES, "", "Each study has one or more series of images or other content.", 0, Integer.MAX_VALUE, this.series);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -622722335: {
                return this.modality == null ? new Base[]{} : this.modality.toArray(new Base[this.modality.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.subject;
                }
                return baseArray;
            }
            case 1524132147: {
                Base[] baseArray;
                if (this.encounter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.encounter;
                }
                return baseArray;
            }
            case -1897185151: {
                Base[] baseArray;
                if (this.started == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.started;
                }
                return baseArray;
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -722568161: {
                Base[] baseArray;
                if (this.referrer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.referrer;
                }
                return baseArray;
            }
            case -2008009094: {
                return this.interpreter == null ? new Base[]{} : this.interpreter.toArray(new Base[this.interpreter.size()]);
            }
            case 1741102485: {
                return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
            }
            case 1920000407: {
                Base[] baseArray;
                if (this.numberOfSeries == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.numberOfSeries;
                }
                return baseArray;
            }
            case -1043544226: {
                Base[] baseArray;
                if (this.numberOfInstances == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.numberOfInstances;
                }
                return baseArray;
            }
            case -1095204141: {
                return this.procedure == null ? new Base[]{} : this.procedure.toArray(new Base[this.procedure.size()]);
            }
            case 1901043637: {
                Base[] baseArray;
                if (this.location == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.location;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -905838985: {
                return this.series == null ? new Base[]{} : this.series.toArray(new Base[this.series.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new ImagingStudyStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -622722335: {
                this.getModality().add(TypeConvertor.castToCoding(value));
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 1524132147: {
                this.encounter = TypeConvertor.castToReference(value);
                return value;
            }
            case -1897185151: {
                this.started = TypeConvertor.castToDateTime(value);
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -722568161: {
                this.referrer = TypeConvertor.castToReference(value);
                return value;
            }
            case -2008009094: {
                this.getInterpreter().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1741102485: {
                this.getEndpoint().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1920000407: {
                this.numberOfSeries = TypeConvertor.castToUnsignedInt(value);
                return value;
            }
            case -1043544226: {
                this.numberOfInstances = TypeConvertor.castToUnsignedInt(value);
                return value;
            }
            case -1095204141: {
                this.getProcedure().add((ImagingStudyProcedureComponent)((Object)value));
                return value;
            }
            case 1901043637: {
                this.location = TypeConvertor.castToReference(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(TypeConvertor.castToAnnotation(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToString(value);
                return value;
            }
            case -905838985: {
                this.getSeries().add((ImagingStudySeriesComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new ImagingStudyStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_MODALITY)) {
            this.getModality().add(TypeConvertor.castToCoding(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_STARTED)) {
            this.started = TypeConvertor.castToDateTime(value);
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_REFERRER)) {
            this.referrer = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_INTERPRETER)) {
            this.getInterpreter().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_ENDPOINT)) {
            this.getEndpoint().add(TypeConvertor.castToReference(value));
        } else if (name.equals("numberOfSeries")) {
            this.numberOfSeries = TypeConvertor.castToUnsignedInt(value);
        } else if (name.equals("numberOfInstances")) {
            this.numberOfInstances = TypeConvertor.castToUnsignedInt(value);
        } else if (name.equals("procedure")) {
            this.getProcedure().add((ImagingStudyProcedureComponent)((Object)value));
        } else if (name.equals("location")) {
            this.location = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_REASON)) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("note")) {
            this.getNote().add(TypeConvertor.castToAnnotation(value));
        } else if (name.equals("description")) {
            this.description = TypeConvertor.castToString(value);
        } else if (name.equals(SP_SERIES)) {
            this.getSeries().add((ImagingStudySeriesComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -622722335: {
                return this.addModality();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 1524132147: {
                return this.getEncounter();
            }
            case -1897185151: {
                return this.getStartedElement();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -722568161: {
                return this.getReferrer();
            }
            case -2008009094: {
                return this.addInterpreter();
            }
            case 1741102485: {
                return this.addEndpoint();
            }
            case 1920000407: {
                return this.getNumberOfSeriesElement();
            }
            case -1043544226: {
                return this.getNumberOfInstancesElement();
            }
            case -1095204141: {
                return this.addProcedure();
            }
            case 1901043637: {
                return this.getLocation();
            }
            case -934964668: {
                return this.addReason();
            }
            case 3387378: {
                return this.addNote();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -905838985: {
                return this.addSeries();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -622722335: {
                return new String[]{"Coding"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 1524132147: {
                return new String[]{"Reference"};
            }
            case -1897185151: {
                return new String[]{"dateTime"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -722568161: {
                return new String[]{"Reference"};
            }
            case -2008009094: {
                return new String[]{"Reference"};
            }
            case 1741102485: {
                return new String[]{"Reference"};
            }
            case 1920000407: {
                return new String[]{"unsignedInt"};
            }
            case -1043544226: {
                return new String[]{"unsignedInt"};
            }
            case -1095204141: {
                return new String[0];
            }
            case 1901043637: {
                return new String[]{"Reference"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case -1724546052: {
                return new String[]{"string"};
            }
            case -905838985: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.status");
        }
        if (name.equals(SP_MODALITY)) {
            return this.addModality();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals(SP_STARTED)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.started");
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_REFERRER)) {
            this.referrer = new Reference();
            return this.referrer;
        }
        if (name.equals(SP_INTERPRETER)) {
            return this.addInterpreter();
        }
        if (name.equals(SP_ENDPOINT)) {
            return this.addEndpoint();
        }
        if (name.equals("numberOfSeries")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.numberOfSeries");
        }
        if (name.equals("numberOfInstances")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.numberOfInstances");
        }
        if (name.equals("procedure")) {
            return this.addProcedure();
        }
        if (name.equals("location")) {
            this.location = new Reference();
            return this.location;
        }
        if (name.equals(SP_REASON)) {
            return this.addReason();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.description");
        }
        if (name.equals(SP_SERIES)) {
            return this.addSeries();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImagingStudy";
    }

    @Override
    public ImagingStudy copy() {
        ImagingStudy dst = new ImagingStudy();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ImagingStudy dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<ImagingStudyStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.modality != null) {
            dst.modality = new ArrayList<Coding>();
            for (Coding coding : this.modality) {
                dst.modality.add(coding.copy());
            }
        }
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        DateTimeType dateTimeType = dst.started = this.started == null ? null : this.started.copy();
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        Reference reference = dst.referrer = this.referrer == null ? null : this.referrer.copy();
        if (this.interpreter != null) {
            dst.interpreter = new ArrayList<Reference>();
            for (Reference reference2 : this.interpreter) {
                dst.interpreter.add(reference2.copy());
            }
        }
        if (this.endpoint != null) {
            dst.endpoint = new ArrayList<Reference>();
            for (Reference reference3 : this.endpoint) {
                dst.endpoint.add(reference3.copy());
            }
        }
        dst.numberOfSeries = this.numberOfSeries == null ? null : this.numberOfSeries.copy();
        UnsignedIntType unsignedIntType = dst.numberOfInstances = this.numberOfInstances == null ? null : this.numberOfInstances.copy();
        if (this.procedure != null) {
            dst.procedure = new ArrayList<ImagingStudyProcedureComponent>();
            for (ImagingStudyProcedureComponent imagingStudyProcedureComponent : this.procedure) {
                dst.procedure.add(imagingStudyProcedureComponent.copy());
            }
        }
        Reference reference4 = dst.location = this.location == null ? null : this.location.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.series != null) {
            dst.series = new ArrayList<ImagingStudySeriesComponent>();
            for (ImagingStudySeriesComponent imagingStudySeriesComponent : this.series) {
                dst.series.add(imagingStudySeriesComponent.copy());
            }
        }
    }

    protected ImagingStudy typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ImagingStudy)) {
            return false;
        }
        ImagingStudy o = (ImagingStudy)other_;
        return ImagingStudy.compareDeep(this.identifier, o.identifier, true) && ImagingStudy.compareDeep(this.status, o.status, true) && ImagingStudy.compareDeep(this.modality, o.modality, true) && ImagingStudy.compareDeep(this.subject, o.subject, true) && ImagingStudy.compareDeep(this.encounter, o.encounter, true) && ImagingStudy.compareDeep(this.started, o.started, true) && ImagingStudy.compareDeep(this.basedOn, o.basedOn, true) && ImagingStudy.compareDeep(this.referrer, o.referrer, true) && ImagingStudy.compareDeep(this.interpreter, o.interpreter, true) && ImagingStudy.compareDeep(this.endpoint, o.endpoint, true) && ImagingStudy.compareDeep(this.numberOfSeries, o.numberOfSeries, true) && ImagingStudy.compareDeep(this.numberOfInstances, o.numberOfInstances, true) && ImagingStudy.compareDeep(this.procedure, o.procedure, true) && ImagingStudy.compareDeep(this.location, o.location, true) && ImagingStudy.compareDeep(this.reason, o.reason, true) && ImagingStudy.compareDeep(this.note, o.note, true) && ImagingStudy.compareDeep(this.description, o.description, true) && ImagingStudy.compareDeep(this.series, o.series, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ImagingStudy)) {
            return false;
        }
        ImagingStudy o = (ImagingStudy)other_;
        return ImagingStudy.compareValues(this.status, o.status, true) && ImagingStudy.compareValues(this.started, o.started, true) && ImagingStudy.compareValues(this.numberOfSeries, o.numberOfSeries, true) && ImagingStudy.compareValues(this.numberOfInstances, o.numberOfInstances, true) && ImagingStudy.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.status, this.modality, this.subject, this.encounter, this.started, this.basedOn, this.referrer, this.interpreter, this.endpoint, this.numberOfSeries, this.numberOfInstances, this.procedure, this.location, this.reason, this.note, this.description, this.series});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImagingStudy;
    }

    @Block
    public static class ImagingStudySeriesInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="DICOM SOP Instance UID", formalDefinition="The DICOM SOP Instance UID for this image or other DICOM content.")
        protected IdType uid;
        @Child(name="sopClass", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="DICOM class type", formalDefinition="DICOM instance  type.")
        @Binding(valueSet="http://dicom.nema.org/medical/dicom/current/output/chtml/part04/sect_B.5.html#table_B.5-1")
        protected Coding sopClass;
        @Child(name="number", type={UnsignedIntType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The number of this instance in the series", formalDefinition="The number of instance in the series.")
        protected UnsignedIntType number;
        @Child(name="title", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of instance", formalDefinition="The description of the instance.")
        protected StringType title;
        private static final long serialVersionUID = -888152445L;

        public ImagingStudySeriesInstanceComponent() {
        }

        public ImagingStudySeriesInstanceComponent(String uid, Coding sopClass) {
            this.setUid(uid);
            this.setSopClass(sopClass);
        }

        public IdType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new IdType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setUidElement(IdType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : this.uid.getValue();
        }

        public ImagingStudySeriesInstanceComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new IdType();
            }
            this.uid.setValue(value);
            return this;
        }

        public Coding getSopClass() {
            if (this.sopClass == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.sopClass");
                }
                if (Configuration.doAutoCreate()) {
                    this.sopClass = new Coding();
                }
            }
            return this.sopClass;
        }

        public boolean hasSopClass() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setSopClass(Coding value) {
            this.sopClass = value;
            return this;
        }

        public UnsignedIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new UnsignedIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setNumberElement(UnsignedIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public ImagingStudySeriesInstanceComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new UnsignedIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ImagingStudySeriesInstanceComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("uid", "id", "The DICOM SOP Instance UID for this image or other DICOM content.", 0, 1, this.uid));
            children.add(new Property("sopClass", "Coding", "DICOM instance  type.", 0, 1, this.sopClass));
            children.add(new Property("number", "unsignedInt", "The number of instance in the series.", 0, 1, this.number));
            children.add(new Property("title", "string", "The description of the instance.", 0, 1, this.title));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 115792: {
                    return new Property("uid", "id", "The DICOM SOP Instance UID for this image or other DICOM content.", 0, 1, this.uid);
                }
                case 1560041540: {
                    return new Property("sopClass", "Coding", "DICOM instance  type.", 0, 1, this.sopClass);
                }
                case -1034364087: {
                    return new Property("number", "unsignedInt", "The number of instance in the series.", 0, 1, this.number);
                }
                case 110371416: {
                    return new Property("title", "string", "The description of the instance.", 0, 1, this.title);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case 1560041540: {
                    Base[] baseArray;
                    if (this.sopClass == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.sopClass;
                    }
                    return baseArray;
                }
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.number;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.title;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = TypeConvertor.castToId(value);
                    return value;
                }
                case 1560041540: {
                    this.sopClass = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -1034364087: {
                    this.number = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case 110371416: {
                    this.title = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = TypeConvertor.castToId(value);
            } else if (name.equals("sopClass")) {
                this.sopClass = TypeConvertor.castToCoding(value);
            } else if (name.equals("number")) {
                this.number = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals("title")) {
                this.title = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return this.getUidElement();
                }
                case 1560041540: {
                    return this.getSopClass();
                }
                case -1034364087: {
                    return this.getNumberElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return new String[]{"id"};
                }
                case 1560041540: {
                    return new String[]{"Coding"};
                }
                case -1034364087: {
                    return new String[]{"unsignedInt"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.series.instance.uid");
            }
            if (name.equals("sopClass")) {
                this.sopClass = new Coding();
                return this.sopClass;
            }
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.series.instance.number");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.series.instance.title");
            }
            return super.addChild(name);
        }

        @Override
        public ImagingStudySeriesInstanceComponent copy() {
            ImagingStudySeriesInstanceComponent dst = new ImagingStudySeriesInstanceComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImagingStudySeriesInstanceComponent dst) {
            super.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            dst.sopClass = this.sopClass == null ? null : this.sopClass.copy();
            dst.number = this.number == null ? null : this.number.copy();
            dst.title = this.title == null ? null : this.title.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingStudySeriesInstanceComponent)) {
                return false;
            }
            ImagingStudySeriesInstanceComponent o = (ImagingStudySeriesInstanceComponent)other_;
            return ImagingStudySeriesInstanceComponent.compareDeep(this.uid, o.uid, true) && ImagingStudySeriesInstanceComponent.compareDeep(this.sopClass, o.sopClass, true) && ImagingStudySeriesInstanceComponent.compareDeep(this.number, o.number, true) && ImagingStudySeriesInstanceComponent.compareDeep(this.title, o.title, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingStudySeriesInstanceComponent)) {
                return false;
            }
            ImagingStudySeriesInstanceComponent o = (ImagingStudySeriesInstanceComponent)other_;
            return ImagingStudySeriesInstanceComponent.compareValues(this.uid, o.uid, true) && ImagingStudySeriesInstanceComponent.compareValues(this.number, o.number, true) && ImagingStudySeriesInstanceComponent.compareValues(this.title, o.title, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.uid, this.sopClass, this.number, this.title});
        }

        @Override
        public String fhirType() {
            return "ImagingStudy.series.instance";
        }
    }

    @Block
    public static class ImagingStudySeriesPerformerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="function", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of performance", formalDefinition="Distinguishes the type of involvement of the performer in the series.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/series-performer-function")
        protected CodeableConcept function;
        @Child(name="actor", type={Practitioner.class, PractitionerRole.class, Organization.class, CareTeam.class, Patient.class, Device.class, RelatedPerson.class, HealthcareService.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Who performed the series", formalDefinition="Indicates who or what performed the series.")
        protected Reference actor;
        private static final long serialVersionUID = -576943815L;

        public ImagingStudySeriesPerformerComponent() {
        }

        public ImagingStudySeriesPerformerComponent(Reference actor) {
            this.setActor(actor);
        }

        public CodeableConcept getFunction() {
            if (this.function == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesPerformerComponent.function");
                }
                if (Configuration.doAutoCreate()) {
                    this.function = new CodeableConcept();
                }
            }
            return this.function;
        }

        public boolean hasFunction() {
            return this.function != null && !this.function.isEmpty();
        }

        public ImagingStudySeriesPerformerComponent setFunction(CodeableConcept value) {
            this.function = value;
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesPerformerComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public ImagingStudySeriesPerformerComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the performer in the series.", 0, 1, this.function));
            children.add(new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson|HealthcareService)", "Indicates who or what performed the series.", 0, 1, this.actor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1380938712: {
                    return new Property("function", "CodeableConcept", "Distinguishes the type of involvement of the performer in the series.", 0, 1, this.function);
                }
                case 92645877: {
                    return new Property("actor", "Reference(Practitioner|PractitionerRole|Organization|CareTeam|Patient|Device|RelatedPerson|HealthcareService)", "Indicates who or what performed the series.", 0, 1, this.actor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    Base[] baseArray;
                    if (this.function == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.function;
                    }
                    return baseArray;
                }
                case 92645877: {
                    Base[] baseArray;
                    if (this.actor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.actor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    this.function = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 92645877: {
                    this.actor = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("function")) {
                this.function = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("actor")) {
                this.actor = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return this.getFunction();
                }
                case 92645877: {
                    return this.getActor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1380938712: {
                    return new String[]{"CodeableConcept"};
                }
                case 92645877: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("function")) {
                this.function = new CodeableConcept();
                return this.function;
            }
            if (name.equals("actor")) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public ImagingStudySeriesPerformerComponent copy() {
            ImagingStudySeriesPerformerComponent dst = new ImagingStudySeriesPerformerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImagingStudySeriesPerformerComponent dst) {
            super.copyValues(dst);
            dst.function = this.function == null ? null : this.function.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingStudySeriesPerformerComponent)) {
                return false;
            }
            ImagingStudySeriesPerformerComponent o = (ImagingStudySeriesPerformerComponent)other_;
            return ImagingStudySeriesPerformerComponent.compareDeep(this.function, o.function, true) && ImagingStudySeriesPerformerComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingStudySeriesPerformerComponent)) {
                return false;
            }
            ImagingStudySeriesPerformerComponent o = (ImagingStudySeriesPerformerComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.function, this.actor});
        }

        @Override
        public String fhirType() {
            return "ImagingStudy.series.performer";
        }
    }

    @Block
    public static class ImagingStudySeriesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="DICOM Series Instance UID for the series", formalDefinition="The DICOM Series Instance UID for the series.")
        protected IdType uid;
        @Child(name="number", type={UnsignedIntType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Numeric identifier of this series", formalDefinition="The numeric identifier of this series in the study.")
        protected UnsignedIntType number;
        @Child(name="modality", type={Coding.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The modality used for this series", formalDefinition="The distinct modality for this series. This may include both aquisition and non-aquisition modalities.")
        @Binding(valueSet="http://dicom.nema.org/medical/dicom/current/output/chtml/part16/sect_CID_33.html")
        protected Coding modality;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A short human readable summary of the series", formalDefinition="A description of the series.")
        protected StringType description;
        @Child(name="numberOfInstances", type={UnsignedIntType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of Series Related Instances", formalDefinition="Number of SOP Instances in the Study. The value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.")
        protected UnsignedIntType numberOfInstances;
        @Child(name="endpoint", type={Endpoint.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Series access endpoint", formalDefinition="The network service providing access (e.g., query, view, or retrieval) for this series. See implementation notes for information about using DICOM endpoints. A series-level endpoint, if present, has precedence over a study-level endpoint with the same Endpoint.connectionType.")
        protected List<Reference> endpoint;
        @Child(name="bodySite", type={Coding.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Body part examined", formalDefinition="The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings. The bodySite may indicate the laterality of body part imaged; if so, it shall be consistent with any content of ImagingStudy.series.laterality.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
        protected Coding bodySite;
        @Child(name="laterality", type={Coding.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Body part laterality", formalDefinition="The laterality of the (possibly paired) anatomic structures examined. E.g., the left knee, both lungs, or unpaired abdomen. If present, shall be consistent with any laterality information indicated in ImagingStudy.series.bodySite.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/bodysite-laterality")
        protected Coding laterality;
        @Child(name="specimen", type={Specimen.class}, order=9, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Specimen imaged", formalDefinition="The specimen imaged, e.g., for whole slide imaging of a biopsy.")
        protected List<Reference> specimen;
        @Child(name="started", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When the series started", formalDefinition="The date and time the series was started.")
        protected DateTimeType started;
        @Child(name="performer", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Who performed the series", formalDefinition="Indicates who or what performed the series and how they were involved.")
        protected List<ImagingStudySeriesPerformerComponent> performer;
        @Child(name="instance", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A single SOP instance from the series", formalDefinition="A single SOP instance within the series, e.g. an image, or presentation state.")
        protected List<ImagingStudySeriesInstanceComponent> instance;
        private static final long serialVersionUID = 198247349L;

        public ImagingStudySeriesComponent() {
        }

        public ImagingStudySeriesComponent(String uid, Coding modality) {
            this.setUid(uid);
            this.setModality(modality);
        }

        public IdType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new IdType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public ImagingStudySeriesComponent setUidElement(IdType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : this.uid.getValue();
        }

        public ImagingStudySeriesComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new IdType();
            }
            this.uid.setValue(value);
            return this;
        }

        public UnsignedIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new UnsignedIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public ImagingStudySeriesComponent setNumberElement(UnsignedIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public ImagingStudySeriesComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new UnsignedIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public Coding getModality() {
            if (this.modality == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.modality");
                }
                if (Configuration.doAutoCreate()) {
                    this.modality = new Coding();
                }
            }
            return this.modality;
        }

        public boolean hasModality() {
            return this.modality != null && !this.modality.isEmpty();
        }

        public ImagingStudySeriesComponent setModality(Coding value) {
            this.modality = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImagingStudySeriesComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImagingStudySeriesComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public UnsignedIntType getNumberOfInstancesElement() {
            if (this.numberOfInstances == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.numberOfInstances");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfInstances = new UnsignedIntType();
                }
            }
            return this.numberOfInstances;
        }

        public boolean hasNumberOfInstancesElement() {
            return this.numberOfInstances != null && !this.numberOfInstances.isEmpty();
        }

        public boolean hasNumberOfInstances() {
            return this.numberOfInstances != null && !this.numberOfInstances.isEmpty();
        }

        public ImagingStudySeriesComponent setNumberOfInstancesElement(UnsignedIntType value) {
            this.numberOfInstances = value;
            return this;
        }

        public int getNumberOfInstances() {
            return this.numberOfInstances == null || this.numberOfInstances.isEmpty() ? 0 : (Integer)this.numberOfInstances.getValue();
        }

        public ImagingStudySeriesComponent setNumberOfInstances(int value) {
            if (this.numberOfInstances == null) {
                this.numberOfInstances = new UnsignedIntType();
            }
            this.numberOfInstances.setValue((Object)value);
            return this;
        }

        public List<Reference> getEndpoint() {
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<Reference>();
            }
            return this.endpoint;
        }

        public ImagingStudySeriesComponent setEndpoint(List<Reference> theEndpoint) {
            this.endpoint = theEndpoint;
            return this;
        }

        public boolean hasEndpoint() {
            if (this.endpoint == null) {
                return false;
            }
            for (Reference item : this.endpoint) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addEndpoint() {
            Reference t = new Reference();
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<Reference>();
            }
            this.endpoint.add(t);
            return t;
        }

        public ImagingStudySeriesComponent addEndpoint(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.endpoint == null) {
                this.endpoint = new ArrayList<Reference>();
            }
            this.endpoint.add(t);
            return this;
        }

        public Reference getEndpointFirstRep() {
            if (this.getEndpoint().isEmpty()) {
                this.addEndpoint();
            }
            return this.getEndpoint().get(0);
        }

        public Coding getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new Coding();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public ImagingStudySeriesComponent setBodySite(Coding value) {
            this.bodySite = value;
            return this;
        }

        public Coding getLaterality() {
            if (this.laterality == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.laterality");
                }
                if (Configuration.doAutoCreate()) {
                    this.laterality = new Coding();
                }
            }
            return this.laterality;
        }

        public boolean hasLaterality() {
            return this.laterality != null && !this.laterality.isEmpty();
        }

        public ImagingStudySeriesComponent setLaterality(Coding value) {
            this.laterality = value;
            return this;
        }

        public List<Reference> getSpecimen() {
            if (this.specimen == null) {
                this.specimen = new ArrayList<Reference>();
            }
            return this.specimen;
        }

        public ImagingStudySeriesComponent setSpecimen(List<Reference> theSpecimen) {
            this.specimen = theSpecimen;
            return this;
        }

        public boolean hasSpecimen() {
            if (this.specimen == null) {
                return false;
            }
            for (Reference item : this.specimen) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSpecimen() {
            Reference t = new Reference();
            if (this.specimen == null) {
                this.specimen = new ArrayList<Reference>();
            }
            this.specimen.add(t);
            return t;
        }

        public ImagingStudySeriesComponent addSpecimen(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.specimen == null) {
                this.specimen = new ArrayList<Reference>();
            }
            this.specimen.add(t);
            return this;
        }

        public Reference getSpecimenFirstRep() {
            if (this.getSpecimen().isEmpty()) {
                this.addSpecimen();
            }
            return this.getSpecimen().get(0);
        }

        public DateTimeType getStartedElement() {
            if (this.started == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.started");
                }
                if (Configuration.doAutoCreate()) {
                    this.started = new DateTimeType();
                }
            }
            return this.started;
        }

        public boolean hasStartedElement() {
            return this.started != null && !this.started.isEmpty();
        }

        public boolean hasStarted() {
            return this.started != null && !this.started.isEmpty();
        }

        public ImagingStudySeriesComponent setStartedElement(DateTimeType value) {
            this.started = value;
            return this;
        }

        public Date getStarted() {
            return this.started == null ? null : (Date)this.started.getValue();
        }

        public ImagingStudySeriesComponent setStarted(Date value) {
            if (value == null) {
                this.started = null;
            } else {
                if (this.started == null) {
                    this.started = new DateTimeType();
                }
                this.started.setValue(value);
            }
            return this;
        }

        public List<ImagingStudySeriesPerformerComponent> getPerformer() {
            if (this.performer == null) {
                this.performer = new ArrayList<ImagingStudySeriesPerformerComponent>();
            }
            return this.performer;
        }

        public ImagingStudySeriesComponent setPerformer(List<ImagingStudySeriesPerformerComponent> thePerformer) {
            this.performer = thePerformer;
            return this;
        }

        public boolean hasPerformer() {
            if (this.performer == null) {
                return false;
            }
            for (ImagingStudySeriesPerformerComponent item : this.performer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImagingStudySeriesPerformerComponent addPerformer() {
            ImagingStudySeriesPerformerComponent t = new ImagingStudySeriesPerformerComponent();
            if (this.performer == null) {
                this.performer = new ArrayList<ImagingStudySeriesPerformerComponent>();
            }
            this.performer.add(t);
            return t;
        }

        public ImagingStudySeriesComponent addPerformer(ImagingStudySeriesPerformerComponent t) {
            if (t == null) {
                return this;
            }
            if (this.performer == null) {
                this.performer = new ArrayList<ImagingStudySeriesPerformerComponent>();
            }
            this.performer.add(t);
            return this;
        }

        public ImagingStudySeriesPerformerComponent getPerformerFirstRep() {
            if (this.getPerformer().isEmpty()) {
                this.addPerformer();
            }
            return this.getPerformer().get(0);
        }

        public List<ImagingStudySeriesInstanceComponent> getInstance() {
            if (this.instance == null) {
                this.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
            }
            return this.instance;
        }

        public ImagingStudySeriesComponent setInstance(List<ImagingStudySeriesInstanceComponent> theInstance) {
            this.instance = theInstance;
            return this;
        }

        public boolean hasInstance() {
            if (this.instance == null) {
                return false;
            }
            for (ImagingStudySeriesInstanceComponent item : this.instance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImagingStudySeriesInstanceComponent addInstance() {
            ImagingStudySeriesInstanceComponent t = new ImagingStudySeriesInstanceComponent();
            if (this.instance == null) {
                this.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
            }
            this.instance.add(t);
            return t;
        }

        public ImagingStudySeriesComponent addInstance(ImagingStudySeriesInstanceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.instance == null) {
                this.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
            }
            this.instance.add(t);
            return this;
        }

        public ImagingStudySeriesInstanceComponent getInstanceFirstRep() {
            if (this.getInstance().isEmpty()) {
                this.addInstance();
            }
            return this.getInstance().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("uid", "id", "The DICOM Series Instance UID for the series.", 0, 1, this.uid));
            children.add(new Property("number", "unsignedInt", "The numeric identifier of this series in the study.", 0, 1, this.number));
            children.add(new Property(ImagingStudy.SP_MODALITY, "Coding", "The distinct modality for this series. This may include both aquisition and non-aquisition modalities.", 0, 1, this.modality));
            children.add(new Property("description", "string", "A description of the series.", 0, 1, this.description));
            children.add(new Property("numberOfInstances", "unsignedInt", "Number of SOP Instances in the Study. The value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.", 0, 1, this.numberOfInstances));
            children.add(new Property(ImagingStudy.SP_ENDPOINT, "Reference(Endpoint)", "The network service providing access (e.g., query, view, or retrieval) for this series. See implementation notes for information about using DICOM endpoints. A series-level endpoint, if present, has precedence over a study-level endpoint with the same Endpoint.connectionType.", 0, Integer.MAX_VALUE, this.endpoint));
            children.add(new Property("bodySite", "Coding", "The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings. The bodySite may indicate the laterality of body part imaged; if so, it shall be consistent with any content of ImagingStudy.series.laterality.", 0, 1, this.bodySite));
            children.add(new Property("laterality", "Coding", "The laterality of the (possibly paired) anatomic structures examined. E.g., the left knee, both lungs, or unpaired abdomen. If present, shall be consistent with any laterality information indicated in ImagingStudy.series.bodySite.", 0, 1, this.laterality));
            children.add(new Property("specimen", "Reference(Specimen)", "The specimen imaged, e.g., for whole slide imaging of a biopsy.", 0, Integer.MAX_VALUE, this.specimen));
            children.add(new Property(ImagingStudy.SP_STARTED, "dateTime", "The date and time the series was started.", 0, 1, this.started));
            children.add(new Property(ImagingStudy.SP_PERFORMER, "", "Indicates who or what performed the series and how they were involved.", 0, Integer.MAX_VALUE, this.performer));
            children.add(new Property(ImagingStudy.SP_INSTANCE, "", "A single SOP instance within the series, e.g. an image, or presentation state.", 0, Integer.MAX_VALUE, this.instance));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 115792: {
                    return new Property("uid", "id", "The DICOM Series Instance UID for the series.", 0, 1, this.uid);
                }
                case -1034364087: {
                    return new Property("number", "unsignedInt", "The numeric identifier of this series in the study.", 0, 1, this.number);
                }
                case -622722335: {
                    return new Property(ImagingStudy.SP_MODALITY, "Coding", "The distinct modality for this series. This may include both aquisition and non-aquisition modalities.", 0, 1, this.modality);
                }
                case -1724546052: {
                    return new Property("description", "string", "A description of the series.", 0, 1, this.description);
                }
                case -1043544226: {
                    return new Property("numberOfInstances", "unsignedInt", "Number of SOP Instances in the Study. The value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.", 0, 1, this.numberOfInstances);
                }
                case 1741102485: {
                    return new Property(ImagingStudy.SP_ENDPOINT, "Reference(Endpoint)", "The network service providing access (e.g., query, view, or retrieval) for this series. See implementation notes for information about using DICOM endpoints. A series-level endpoint, if present, has precedence over a study-level endpoint with the same Endpoint.connectionType.", 0, Integer.MAX_VALUE, this.endpoint);
                }
                case 1702620169: {
                    return new Property("bodySite", "Coding", "The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings. The bodySite may indicate the laterality of body part imaged; if so, it shall be consistent with any content of ImagingStudy.series.laterality.", 0, 1, this.bodySite);
                }
                case -170291817: {
                    return new Property("laterality", "Coding", "The laterality of the (possibly paired) anatomic structures examined. E.g., the left knee, both lungs, or unpaired abdomen. If present, shall be consistent with any laterality information indicated in ImagingStudy.series.bodySite.", 0, 1, this.laterality);
                }
                case -2132868344: {
                    return new Property("specimen", "Reference(Specimen)", "The specimen imaged, e.g., for whole slide imaging of a biopsy.", 0, Integer.MAX_VALUE, this.specimen);
                }
                case -1897185151: {
                    return new Property(ImagingStudy.SP_STARTED, "dateTime", "The date and time the series was started.", 0, 1, this.started);
                }
                case 481140686: {
                    return new Property(ImagingStudy.SP_PERFORMER, "", "Indicates who or what performed the series and how they were involved.", 0, Integer.MAX_VALUE, this.performer);
                }
                case 555127957: {
                    return new Property(ImagingStudy.SP_INSTANCE, "", "A single SOP instance within the series, e.g. an image, or presentation state.", 0, Integer.MAX_VALUE, this.instance);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.number;
                    }
                    return baseArray;
                }
                case -622722335: {
                    Base[] baseArray;
                    if (this.modality == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.modality;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case -1043544226: {
                    Base[] baseArray;
                    if (this.numberOfInstances == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.numberOfInstances;
                    }
                    return baseArray;
                }
                case 1741102485: {
                    return this.endpoint == null ? new Base[]{} : this.endpoint.toArray(new Base[this.endpoint.size()]);
                }
                case 1702620169: {
                    Base[] baseArray;
                    if (this.bodySite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.bodySite;
                    }
                    return baseArray;
                }
                case -170291817: {
                    Base[] baseArray;
                    if (this.laterality == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.laterality;
                    }
                    return baseArray;
                }
                case -2132868344: {
                    return this.specimen == null ? new Base[]{} : this.specimen.toArray(new Base[this.specimen.size()]);
                }
                case -1897185151: {
                    Base[] baseArray;
                    if (this.started == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.started;
                    }
                    return baseArray;
                }
                case 481140686: {
                    return this.performer == null ? new Base[]{} : this.performer.toArray(new Base[this.performer.size()]);
                }
                case 555127957: {
                    return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = TypeConvertor.castToId(value);
                    return value;
                }
                case -1034364087: {
                    this.number = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case -622722335: {
                    this.modality = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -1043544226: {
                    this.numberOfInstances = TypeConvertor.castToUnsignedInt(value);
                    return value;
                }
                case 1741102485: {
                    this.getEndpoint().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case 1702620169: {
                    this.bodySite = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -170291817: {
                    this.laterality = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -2132868344: {
                    this.getSpecimen().add(TypeConvertor.castToReference(value));
                    return value;
                }
                case -1897185151: {
                    this.started = TypeConvertor.castToDateTime(value);
                    return value;
                }
                case 481140686: {
                    this.getPerformer().add((ImagingStudySeriesPerformerComponent)value);
                    return value;
                }
                case 555127957: {
                    this.getInstance().add((ImagingStudySeriesInstanceComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("uid")) {
                this.uid = TypeConvertor.castToId(value);
            } else if (name.equals("number")) {
                this.number = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals(ImagingStudy.SP_MODALITY)) {
                this.modality = TypeConvertor.castToCoding(value);
            } else if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("numberOfInstances")) {
                this.numberOfInstances = TypeConvertor.castToUnsignedInt(value);
            } else if (name.equals(ImagingStudy.SP_ENDPOINT)) {
                this.getEndpoint().add(TypeConvertor.castToReference(value));
            } else if (name.equals("bodySite")) {
                this.bodySite = TypeConvertor.castToCoding(value);
            } else if (name.equals("laterality")) {
                this.laterality = TypeConvertor.castToCoding(value);
            } else if (name.equals("specimen")) {
                this.getSpecimen().add(TypeConvertor.castToReference(value));
            } else if (name.equals(ImagingStudy.SP_STARTED)) {
                this.started = TypeConvertor.castToDateTime(value);
            } else if (name.equals(ImagingStudy.SP_PERFORMER)) {
                this.getPerformer().add((ImagingStudySeriesPerformerComponent)value);
            } else if (name.equals(ImagingStudy.SP_INSTANCE)) {
                this.getInstance().add((ImagingStudySeriesInstanceComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return this.getUidElement();
                }
                case -1034364087: {
                    return this.getNumberElement();
                }
                case -622722335: {
                    return this.getModality();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1043544226: {
                    return this.getNumberOfInstancesElement();
                }
                case 1741102485: {
                    return this.addEndpoint();
                }
                case 1702620169: {
                    return this.getBodySite();
                }
                case -170291817: {
                    return this.getLaterality();
                }
                case -2132868344: {
                    return this.addSpecimen();
                }
                case -1897185151: {
                    return this.getStartedElement();
                }
                case 481140686: {
                    return this.addPerformer();
                }
                case 555127957: {
                    return this.addInstance();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    return new String[]{"id"};
                }
                case -1034364087: {
                    return new String[]{"unsignedInt"};
                }
                case -622722335: {
                    return new String[]{"Coding"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1043544226: {
                    return new String[]{"unsignedInt"};
                }
                case 1741102485: {
                    return new String[]{"Reference"};
                }
                case 1702620169: {
                    return new String[]{"Coding"};
                }
                case -170291817: {
                    return new String[]{"Coding"};
                }
                case -2132868344: {
                    return new String[]{"Reference"};
                }
                case -1897185151: {
                    return new String[]{"dateTime"};
                }
                case 481140686: {
                    return new String[0];
                }
                case 555127957: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("uid")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.series.uid");
            }
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.series.number");
            }
            if (name.equals(ImagingStudy.SP_MODALITY)) {
                this.modality = new Coding();
                return this.modality;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.series.description");
            }
            if (name.equals("numberOfInstances")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.series.numberOfInstances");
            }
            if (name.equals(ImagingStudy.SP_ENDPOINT)) {
                return this.addEndpoint();
            }
            if (name.equals("bodySite")) {
                this.bodySite = new Coding();
                return this.bodySite;
            }
            if (name.equals("laterality")) {
                this.laterality = new Coding();
                return this.laterality;
            }
            if (name.equals("specimen")) {
                return this.addSpecimen();
            }
            if (name.equals(ImagingStudy.SP_STARTED)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.series.started");
            }
            if (name.equals(ImagingStudy.SP_PERFORMER)) {
                return this.addPerformer();
            }
            if (name.equals(ImagingStudy.SP_INSTANCE)) {
                return this.addInstance();
            }
            return super.addChild(name);
        }

        @Override
        public ImagingStudySeriesComponent copy() {
            ImagingStudySeriesComponent dst = new ImagingStudySeriesComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImagingStudySeriesComponent dst) {
            super.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            dst.number = this.number == null ? null : this.number.copy();
            dst.modality = this.modality == null ? null : this.modality.copy();
            dst.description = this.description == null ? null : this.description.copy();
            UnsignedIntType unsignedIntType = dst.numberOfInstances = this.numberOfInstances == null ? null : this.numberOfInstances.copy();
            if (this.endpoint != null) {
                dst.endpoint = new ArrayList<Reference>();
                for (Reference reference : this.endpoint) {
                    dst.endpoint.add(reference.copy());
                }
            }
            dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            Coding coding = dst.laterality = this.laterality == null ? null : this.laterality.copy();
            if (this.specimen != null) {
                dst.specimen = new ArrayList<Reference>();
                for (Reference reference : this.specimen) {
                    dst.specimen.add(reference.copy());
                }
            }
            DateTimeType dateTimeType = dst.started = this.started == null ? null : this.started.copy();
            if (this.performer != null) {
                dst.performer = new ArrayList<ImagingStudySeriesPerformerComponent>();
                for (ImagingStudySeriesPerformerComponent imagingStudySeriesPerformerComponent : this.performer) {
                    dst.performer.add(imagingStudySeriesPerformerComponent.copy());
                }
            }
            if (this.instance != null) {
                dst.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
                for (ImagingStudySeriesInstanceComponent imagingStudySeriesInstanceComponent : this.instance) {
                    dst.instance.add(imagingStudySeriesInstanceComponent.copy());
                }
            }
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingStudySeriesComponent)) {
                return false;
            }
            ImagingStudySeriesComponent o = (ImagingStudySeriesComponent)other_;
            return ImagingStudySeriesComponent.compareDeep(this.uid, o.uid, true) && ImagingStudySeriesComponent.compareDeep(this.number, o.number, true) && ImagingStudySeriesComponent.compareDeep(this.modality, o.modality, true) && ImagingStudySeriesComponent.compareDeep(this.description, o.description, true) && ImagingStudySeriesComponent.compareDeep(this.numberOfInstances, o.numberOfInstances, true) && ImagingStudySeriesComponent.compareDeep(this.endpoint, o.endpoint, true) && ImagingStudySeriesComponent.compareDeep(this.bodySite, o.bodySite, true) && ImagingStudySeriesComponent.compareDeep(this.laterality, o.laterality, true) && ImagingStudySeriesComponent.compareDeep(this.specimen, o.specimen, true) && ImagingStudySeriesComponent.compareDeep(this.started, o.started, true) && ImagingStudySeriesComponent.compareDeep(this.performer, o.performer, true) && ImagingStudySeriesComponent.compareDeep(this.instance, o.instance, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingStudySeriesComponent)) {
                return false;
            }
            ImagingStudySeriesComponent o = (ImagingStudySeriesComponent)other_;
            return ImagingStudySeriesComponent.compareValues(this.uid, o.uid, true) && ImagingStudySeriesComponent.compareValues(this.number, o.number, true) && ImagingStudySeriesComponent.compareValues(this.description, o.description, true) && ImagingStudySeriesComponent.compareValues(this.numberOfInstances, o.numberOfInstances, true) && ImagingStudySeriesComponent.compareValues(this.started, o.started, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.uid, this.number, this.modality, this.description, this.numberOfInstances, this.endpoint, this.bodySite, this.laterality, this.specimen, this.started, this.performer, this.instance});
        }

        @Override
        public String fhirType() {
            return "ImagingStudy.series";
        }
    }

    @Block
    public static class ImagingStudyProcedureComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={Procedure.class, CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The performed Procedure", formalDefinition="The procedure which this ImagingStudy was part of.")
        @Binding(valueSet="http://loinc.org/download/loincrsna-radiology-playbook-file/")
        protected DataType value;
        private static final long serialVersionUID = -1135414639L;

        public ImagingStudyProcedureComponent() {
        }

        public ImagingStudyProcedureComponent(DataType value) {
            this.setValue(value);
        }

        public DataType getValue() {
            return this.value;
        }

        public Reference getValueReference() throws FHIRException {
            if (this.value == null) {
                this.value = new Reference();
            }
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this != null && this.value instanceof Reference;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ImagingStudyProcedureComponent setValue(DataType value) {
            if (value != null && !(value instanceof Reference) && !(value instanceof CodeableConcept)) {
                throw new Error("Not the right type for ImagingStudy.procedure.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("value[x]", "Reference(Procedure)|CodeableConcept", "The procedure which this ImagingStudy was part of.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1410166417: {
                    return new Property("value[x]", "Reference(Procedure)|CodeableConcept", "The procedure which this ImagingStudy was part of.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "Reference(Procedure)|CodeableConcept", "The procedure which this ImagingStudy was part of.", 0, 1, this.value);
                }
                case 1755241690: {
                    return new Property("value[x]", "Reference(Procedure)", "The procedure which this ImagingStudy was part of.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "The procedure which this ImagingStudy was part of.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("value[x]")) {
                return super.setProperty(name, value);
            }
            this.value = TypeConvertor.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 111972721: {
                    return new String[]{"Reference", "CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ImagingStudyProcedureComponent copy() {
            ImagingStudyProcedureComponent dst = new ImagingStudyProcedureComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ImagingStudyProcedureComponent dst) {
            super.copyValues(dst);
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingStudyProcedureComponent)) {
                return false;
            }
            ImagingStudyProcedureComponent o = (ImagingStudyProcedureComponent)other_;
            return ImagingStudyProcedureComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImagingStudyProcedureComponent)) {
                return false;
            }
            ImagingStudyProcedureComponent o = (ImagingStudyProcedureComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.value});
        }

        @Override
        public String fhirType() {
            return "ImagingStudy.procedure";
        }
    }

    public static class ImagingStudyStatusEnumFactory
    implements EnumFactory<ImagingStudyStatus> {
        @Override
        public ImagingStudyStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return ImagingStudyStatus.REGISTERED;
            }
            if ("available".equals(codeString)) {
                return ImagingStudyStatus.AVAILABLE;
            }
            if ("cancelled".equals(codeString)) {
                return ImagingStudyStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ImagingStudyStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ImagingStudyStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ImagingStudyStatus code '" + codeString + "'");
        }

        public Enumeration<ImagingStudyStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ImagingStudyStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return new Enumeration<ImagingStudyStatus>(this, ImagingStudyStatus.REGISTERED);
            }
            if ("available".equals(codeString)) {
                return new Enumeration<ImagingStudyStatus>(this, ImagingStudyStatus.AVAILABLE);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ImagingStudyStatus>(this, ImagingStudyStatus.CANCELLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ImagingStudyStatus>(this, ImagingStudyStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ImagingStudyStatus>(this, ImagingStudyStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown ImagingStudyStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ImagingStudyStatus code) {
            if (code == ImagingStudyStatus.REGISTERED) {
                return "registered";
            }
            if (code == ImagingStudyStatus.AVAILABLE) {
                return "available";
            }
            if (code == ImagingStudyStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ImagingStudyStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ImagingStudyStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(ImagingStudyStatus code) {
            return code.getSystem();
        }
    }

    public static enum ImagingStudyStatus {
        REGISTERED,
        AVAILABLE,
        CANCELLED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ImagingStudyStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return REGISTERED;
            }
            if ("available".equals(codeString)) {
                return AVAILABLE;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ImagingStudyStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REGISTERED: {
                    return "registered";
                }
                case AVAILABLE: {
                    return "available";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REGISTERED: {
                    return "http://hl7.org/fhir/imagingstudy-status";
                }
                case AVAILABLE: {
                    return "http://hl7.org/fhir/imagingstudy-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/imagingstudy-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/imagingstudy-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/imagingstudy-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REGISTERED: {
                    return "The existence of the imaging study is registered, but there is nothing yet available.";
                }
                case AVAILABLE: {
                    return "At least one instance has been associated with this imaging study.";
                }
                case CANCELLED: {
                    return "The imaging study is unavailable because the imaging study was not started or not completed (also sometimes called \"aborted\").";
                }
                case ENTEREDINERROR: {
                    return "The imaging study has been withdrawn following a previous final release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
                }
                case UNKNOWN: {
                    return "The system does not know which of the status values currently applies for this request. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REGISTERED: {
                    return "Registered";
                }
                case AVAILABLE: {
                    return "Available";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }
}

