/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@DatatypeDef(name="Expression")
public class Expression
extends DataType
implements ICompositeType {
    @Child(name="description", type={StringType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Natural language description of the condition", formalDefinition="A brief, natural language description of the condition that effectively communicates the intended semantics.")
    protected StringType description;
    @Child(name="name", type={IdType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Short name assigned to expression for reuse", formalDefinition="A short name assigned to the expression to allow for multiple reuse of the expression in the context where it is defined.")
    protected IdType name;
    @Child(name="language", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="text/cql | text/fhirpath | application/x-fhir-query | etc.", formalDefinition="The media type of the language for the expression.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/expression-language")
    protected CodeType language;
    @Child(name="expression", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Expression in specified language", formalDefinition="An expression in the specified language that returns a value.")
    protected StringType expression;
    @Child(name="reference", type={UriType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Where the expression is found", formalDefinition="A URI that defines where the expression is found.")
    protected UriType reference;
    private static final long serialVersionUID = -465056222L;

    public Expression() {
    }

    public Expression(String language) {
        this.setLanguage(language);
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Expression.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Expression setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Expression setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public IdType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Expression.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new IdType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Expression setNameElement(IdType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : this.name.getValue();
    }

    public Expression setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new IdType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public CodeType getLanguageElement() {
        if (this.language == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Expression.language");
            }
            if (Configuration.doAutoCreate()) {
                this.language = new CodeType();
            }
        }
        return this.language;
    }

    public boolean hasLanguageElement() {
        return this.language != null && !this.language.isEmpty();
    }

    public boolean hasLanguage() {
        return this.language != null && !this.language.isEmpty();
    }

    public Expression setLanguageElement(CodeType value) {
        this.language = value;
        return this;
    }

    public String getLanguage() {
        return this.language == null ? null : (String)this.language.getValue();
    }

    public Expression setLanguage(String value) {
        if (this.language == null) {
            this.language = new CodeType();
        }
        this.language.setValue(value);
        return this;
    }

    public StringType getExpressionElement() {
        if (this.expression == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Expression.expression");
            }
            if (Configuration.doAutoCreate()) {
                this.expression = new StringType();
            }
        }
        return this.expression;
    }

    public boolean hasExpressionElement() {
        return this.expression != null && !this.expression.isEmpty();
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isEmpty();
    }

    public Expression setExpressionElement(StringType value) {
        this.expression = value;
        return this;
    }

    public String getExpression() {
        return this.expression == null ? null : (String)this.expression.getValue();
    }

    public Expression setExpression(String value) {
        if (Utilities.noString((String)value)) {
            this.expression = null;
        } else {
            if (this.expression == null) {
                this.expression = new StringType();
            }
            this.expression.setValue(value);
        }
        return this;
    }

    public UriType getReferenceElement() {
        if (this.reference == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Expression.reference");
            }
            if (Configuration.doAutoCreate()) {
                this.reference = new UriType();
            }
        }
        return this.reference;
    }

    public boolean hasReferenceElement() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public boolean hasReference() {
        return this.reference != null && !this.reference.isEmpty();
    }

    public Expression setReferenceElement(UriType value) {
        this.reference = value;
        return this;
    }

    public String getReference() {
        return this.reference == null ? null : (String)this.reference.getValue();
    }

    public Expression setReference(String value) {
        if (Utilities.noString((String)value)) {
            this.reference = null;
        } else {
            if (this.reference == null) {
                this.reference = new UriType();
            }
            this.reference.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("description", "string", "A brief, natural language description of the condition that effectively communicates the intended semantics.", 0, 1, this.description));
        children.add(new Property("name", "id", "A short name assigned to the expression to allow for multiple reuse of the expression in the context where it is defined.", 0, 1, this.name));
        children.add(new Property("language", "code", "The media type of the language for the expression.", 0, 1, this.language));
        children.add(new Property("expression", "string", "An expression in the specified language that returns a value.", 0, 1, this.expression));
        children.add(new Property("reference", "uri", "A URI that defines where the expression is found.", 0, 1, this.reference));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1724546052: {
                return new Property("description", "string", "A brief, natural language description of the condition that effectively communicates the intended semantics.", 0, 1, this.description);
            }
            case 3373707: {
                return new Property("name", "id", "A short name assigned to the expression to allow for multiple reuse of the expression in the context where it is defined.", 0, 1, this.name);
            }
            case -1613589672: {
                return new Property("language", "code", "The media type of the language for the expression.", 0, 1, this.language);
            }
            case -1795452264: {
                return new Property("expression", "string", "An expression in the specified language that returns a value.", 0, 1, this.expression);
            }
            case -925155509: {
                return new Property("reference", "uri", "A URI that defines where the expression is found.", 0, 1, this.reference);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.description;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.name;
                }
                return baseArray;
            }
            case -1613589672: {
                Base[] baseArray;
                if (this.language == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.language;
                }
                return baseArray;
            }
            case -1795452264: {
                Base[] baseArray;
                if (this.expression == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.expression;
                }
                return baseArray;
            }
            case -925155509: {
                Base[] baseArray;
                if (this.reference == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.reference;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                this.description = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToId(value);
                return value;
            }
            case -1613589672: {
                this.language = TypeConvertor.castToCode(value);
                return value;
            }
            case -1795452264: {
                this.expression = TypeConvertor.castToString(value);
                return value;
            }
            case -925155509: {
                this.reference = TypeConvertor.castToUri(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("description")) {
            this.description = TypeConvertor.castToString(value);
        } else if (name.equals("name")) {
            this.name = TypeConvertor.castToId(value);
        } else if (name.equals("language")) {
            this.language = TypeConvertor.castToCode(value);
        } else if (name.equals("expression")) {
            this.expression = TypeConvertor.castToString(value);
        } else if (name.equals("reference")) {
            this.reference = TypeConvertor.castToUri(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -1613589672: {
                return this.getLanguageElement();
            }
            case -1795452264: {
                return this.getExpressionElement();
            }
            case -925155509: {
                return this.getReferenceElement();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1724546052: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"id"};
            }
            case -1613589672: {
                return new String[]{"code"};
            }
            case -1795452264: {
                return new String[]{"string"};
            }
            case -925155509: {
                return new String[]{"uri"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Expression.description");
        }
        if (name.equals("name")) {
            throw new FHIRException("Cannot call addChild on a primitive type Expression.name");
        }
        if (name.equals("language")) {
            throw new FHIRException("Cannot call addChild on a primitive type Expression.language");
        }
        if (name.equals("expression")) {
            throw new FHIRException("Cannot call addChild on a primitive type Expression.expression");
        }
        if (name.equals("reference")) {
            throw new FHIRException("Cannot call addChild on a primitive type Expression.reference");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Expression";
    }

    @Override
    public Expression copy() {
        Expression dst = new Expression();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Expression dst) {
        super.copyValues(dst);
        dst.description = this.description == null ? null : this.description.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.language = this.language == null ? null : this.language.copy();
        dst.expression = this.expression == null ? null : this.expression.copy();
        dst.reference = this.reference == null ? null : this.reference.copy();
    }

    protected Expression typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Expression)) {
            return false;
        }
        Expression o = (Expression)other_;
        return Expression.compareDeep(this.description, o.description, true) && Expression.compareDeep(this.name, o.name, true) && Expression.compareDeep(this.language, o.language, true) && Expression.compareDeep(this.expression, o.expression, true) && Expression.compareDeep(this.reference, o.reference, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Expression)) {
            return false;
        }
        Expression o = (Expression)other_;
        return Expression.compareValues(this.description, o.description, true) && Expression.compareValues(this.name, o.name, true) && Expression.compareValues(this.language, o.language, true) && Expression.compareValues(this.expression, o.expression, true) && Expression.compareValues(this.reference, o.reference, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.name, this.language, this.expression, this.reference});
    }
}

