/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="BiologicallyDerivedProduct", profile="http://hl7.org/fhir/StructureDefinition/BiologicallyDerivedProduct")
public class BiologicallyDerivedProduct
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External ids for this item", formalDefinition="This records identifiers associated with this biologically derived product instance that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="productCategory", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="organ | tissue | fluid | cells | biologicalAgent", formalDefinition="Broad category of this product.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/product-category")
    protected Enumeration<BiologicallyDerivedProductCategory> productCategory;
    @Child(name="productCode", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="What this biologically derived product is", formalDefinition="A code that identifies the kind of this biologically derived product (SNOMED Ctcode).")
    protected CodeableConcept productCode;
    @Child(name="status", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="available | unavailable", formalDefinition="Whether the product is currently available.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/product-status")
    protected Enumeration<BiologicallyDerivedProductStatus> status;
    @Child(name="request", type={ServiceRequest.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Procedure request", formalDefinition="Procedure request to obtain this biologically derived product.")
    protected List<Reference> request;
    @Child(name="quantity", type={IntegerType.class}, order=5, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The amount of this biologically derived product", formalDefinition="Number of discrete units within this product.")
    protected IntegerType quantity;
    @Child(name="parent", type={BiologicallyDerivedProduct.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="BiologicallyDerivedProduct parent", formalDefinition="Parent product (if any).")
    protected List<Reference> parent;
    @Child(name="collection", type={}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="How this product was collected", formalDefinition="How this product was collected.")
    protected BiologicallyDerivedProductCollectionComponent collection;
    @Child(name="processing", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Any processing of the product during collection", formalDefinition="Any processing of the product during collection that does not change the fundamental nature of the product. For example adding anti-coagulants during the collection of Peripheral Blood Stem Cells.")
    protected List<BiologicallyDerivedProductProcessingComponent> processing;
    @Child(name="manipulation", type={}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Any manipulation of product post-collection", formalDefinition="Any manipulation of product post-collection that is intended to alter the product.  For example a buffy-coat enrichment or CD8 reduction of Peripheral Blood Stem Cells to make it more suitable for infusion.")
    protected BiologicallyDerivedProductManipulationComponent manipulation;
    @Child(name="storage", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Product storage", formalDefinition="Product storage.")
    protected List<BiologicallyDerivedProductStorageComponent> storage;
    private static final long serialVersionUID = 921278650L;

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public BiologicallyDerivedProduct setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public BiologicallyDerivedProduct addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<BiologicallyDerivedProductCategory> getProductCategoryElement() {
        if (this.productCategory == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.productCategory");
            }
            if (Configuration.doAutoCreate()) {
                this.productCategory = new Enumeration<BiologicallyDerivedProductCategory>(new BiologicallyDerivedProductCategoryEnumFactory());
            }
        }
        return this.productCategory;
    }

    public boolean hasProductCategoryElement() {
        return this.productCategory != null && !this.productCategory.isEmpty();
    }

    public boolean hasProductCategory() {
        return this.productCategory != null && !this.productCategory.isEmpty();
    }

    public BiologicallyDerivedProduct setProductCategoryElement(Enumeration<BiologicallyDerivedProductCategory> value) {
        this.productCategory = value;
        return this;
    }

    public BiologicallyDerivedProductCategory getProductCategory() {
        return this.productCategory == null ? null : (BiologicallyDerivedProductCategory)((Object)this.productCategory.getValue());
    }

    public BiologicallyDerivedProduct setProductCategory(BiologicallyDerivedProductCategory value) {
        if (value == null) {
            this.productCategory = null;
        } else {
            if (this.productCategory == null) {
                this.productCategory = new Enumeration<BiologicallyDerivedProductCategory>(new BiologicallyDerivedProductCategoryEnumFactory());
            }
            this.productCategory.setValue((Object)value);
        }
        return this;
    }

    public CodeableConcept getProductCode() {
        if (this.productCode == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.productCode");
            }
            if (Configuration.doAutoCreate()) {
                this.productCode = new CodeableConcept();
            }
        }
        return this.productCode;
    }

    public boolean hasProductCode() {
        return this.productCode != null && !this.productCode.isEmpty();
    }

    public BiologicallyDerivedProduct setProductCode(CodeableConcept value) {
        this.productCode = value;
        return this;
    }

    public Enumeration<BiologicallyDerivedProductStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<BiologicallyDerivedProductStatus>(new BiologicallyDerivedProductStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public BiologicallyDerivedProduct setStatusElement(Enumeration<BiologicallyDerivedProductStatus> value) {
        this.status = value;
        return this;
    }

    public BiologicallyDerivedProductStatus getStatus() {
        return this.status == null ? null : (BiologicallyDerivedProductStatus)((Object)this.status.getValue());
    }

    public BiologicallyDerivedProduct setStatus(BiologicallyDerivedProductStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<BiologicallyDerivedProductStatus>(new BiologicallyDerivedProductStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public List<Reference> getRequest() {
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        return this.request;
    }

    public BiologicallyDerivedProduct setRequest(List<Reference> theRequest) {
        this.request = theRequest;
        return this;
    }

    public boolean hasRequest() {
        if (this.request == null) {
            return false;
        }
        for (Reference item : this.request) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRequest() {
        Reference t = new Reference();
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        this.request.add(t);
        return t;
    }

    public BiologicallyDerivedProduct addRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        this.request.add(t);
        return this;
    }

    public Reference getRequestFirstRep() {
        if (this.getRequest().isEmpty()) {
            this.addRequest();
        }
        return this.getRequest().get(0);
    }

    public IntegerType getQuantityElement() {
        if (this.quantity == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.quantity");
            }
            if (Configuration.doAutoCreate()) {
                this.quantity = new IntegerType();
            }
        }
        return this.quantity;
    }

    public boolean hasQuantityElement() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public boolean hasQuantity() {
        return this.quantity != null && !this.quantity.isEmpty();
    }

    public BiologicallyDerivedProduct setQuantityElement(IntegerType value) {
        this.quantity = value;
        return this;
    }

    public int getQuantity() {
        return this.quantity == null || this.quantity.isEmpty() ? 0 : (Integer)this.quantity.getValue();
    }

    public BiologicallyDerivedProduct setQuantity(int value) {
        if (this.quantity == null) {
            this.quantity = new IntegerType();
        }
        this.quantity.setValue((Object)value);
        return this;
    }

    public List<Reference> getParent() {
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        return this.parent;
    }

    public BiologicallyDerivedProduct setParent(List<Reference> theParent) {
        this.parent = theParent;
        return this;
    }

    public boolean hasParent() {
        if (this.parent == null) {
            return false;
        }
        for (Reference item : this.parent) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addParent() {
        Reference t = new Reference();
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        this.parent.add(t);
        return t;
    }

    public BiologicallyDerivedProduct addParent(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.parent == null) {
            this.parent = new ArrayList<Reference>();
        }
        this.parent.add(t);
        return this;
    }

    public Reference getParentFirstRep() {
        if (this.getParent().isEmpty()) {
            this.addParent();
        }
        return this.getParent().get(0);
    }

    public BiologicallyDerivedProductCollectionComponent getCollection() {
        if (this.collection == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.collection");
            }
            if (Configuration.doAutoCreate()) {
                this.collection = new BiologicallyDerivedProductCollectionComponent();
            }
        }
        return this.collection;
    }

    public boolean hasCollection() {
        return this.collection != null && !this.collection.isEmpty();
    }

    public BiologicallyDerivedProduct setCollection(BiologicallyDerivedProductCollectionComponent value) {
        this.collection = value;
        return this;
    }

    public List<BiologicallyDerivedProductProcessingComponent> getProcessing() {
        if (this.processing == null) {
            this.processing = new ArrayList<BiologicallyDerivedProductProcessingComponent>();
        }
        return this.processing;
    }

    public BiologicallyDerivedProduct setProcessing(List<BiologicallyDerivedProductProcessingComponent> theProcessing) {
        this.processing = theProcessing;
        return this;
    }

    public boolean hasProcessing() {
        if (this.processing == null) {
            return false;
        }
        for (BiologicallyDerivedProductProcessingComponent item : this.processing) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BiologicallyDerivedProductProcessingComponent addProcessing() {
        BiologicallyDerivedProductProcessingComponent t = new BiologicallyDerivedProductProcessingComponent();
        if (this.processing == null) {
            this.processing = new ArrayList<BiologicallyDerivedProductProcessingComponent>();
        }
        this.processing.add(t);
        return t;
    }

    public BiologicallyDerivedProduct addProcessing(BiologicallyDerivedProductProcessingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.processing == null) {
            this.processing = new ArrayList<BiologicallyDerivedProductProcessingComponent>();
        }
        this.processing.add(t);
        return this;
    }

    public BiologicallyDerivedProductProcessingComponent getProcessingFirstRep() {
        if (this.getProcessing().isEmpty()) {
            this.addProcessing();
        }
        return this.getProcessing().get(0);
    }

    public BiologicallyDerivedProductManipulationComponent getManipulation() {
        if (this.manipulation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create BiologicallyDerivedProduct.manipulation");
            }
            if (Configuration.doAutoCreate()) {
                this.manipulation = new BiologicallyDerivedProductManipulationComponent();
            }
        }
        return this.manipulation;
    }

    public boolean hasManipulation() {
        return this.manipulation != null && !this.manipulation.isEmpty();
    }

    public BiologicallyDerivedProduct setManipulation(BiologicallyDerivedProductManipulationComponent value) {
        this.manipulation = value;
        return this;
    }

    public List<BiologicallyDerivedProductStorageComponent> getStorage() {
        if (this.storage == null) {
            this.storage = new ArrayList<BiologicallyDerivedProductStorageComponent>();
        }
        return this.storage;
    }

    public BiologicallyDerivedProduct setStorage(List<BiologicallyDerivedProductStorageComponent> theStorage) {
        this.storage = theStorage;
        return this;
    }

    public boolean hasStorage() {
        if (this.storage == null) {
            return false;
        }
        for (BiologicallyDerivedProductStorageComponent item : this.storage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BiologicallyDerivedProductStorageComponent addStorage() {
        BiologicallyDerivedProductStorageComponent t = new BiologicallyDerivedProductStorageComponent();
        if (this.storage == null) {
            this.storage = new ArrayList<BiologicallyDerivedProductStorageComponent>();
        }
        this.storage.add(t);
        return t;
    }

    public BiologicallyDerivedProduct addStorage(BiologicallyDerivedProductStorageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.storage == null) {
            this.storage = new ArrayList<BiologicallyDerivedProductStorageComponent>();
        }
        this.storage.add(t);
        return this;
    }

    public BiologicallyDerivedProductStorageComponent getStorageFirstRep() {
        if (this.getStorage().isEmpty()) {
            this.addStorage();
        }
        return this.getStorage().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "This records identifiers associated with this biologically derived product instance that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("productCategory", "code", "Broad category of this product.", 0, 1, this.productCategory));
        children.add(new Property("productCode", "CodeableConcept", "A code that identifies the kind of this biologically derived product (SNOMED Ctcode).", 0, 1, this.productCode));
        children.add(new Property("status", "code", "Whether the product is currently available.", 0, 1, this.status));
        children.add(new Property("request", "Reference(ServiceRequest)", "Procedure request to obtain this biologically derived product.", 0, Integer.MAX_VALUE, this.request));
        children.add(new Property("quantity", "integer", "Number of discrete units within this product.", 0, 1, this.quantity));
        children.add(new Property("parent", "Reference(BiologicallyDerivedProduct)", "Parent product (if any).", 0, Integer.MAX_VALUE, this.parent));
        children.add(new Property("collection", "", "How this product was collected.", 0, 1, this.collection));
        children.add(new Property("processing", "", "Any processing of the product during collection that does not change the fundamental nature of the product. For example adding anti-coagulants during the collection of Peripheral Blood Stem Cells.", 0, Integer.MAX_VALUE, this.processing));
        children.add(new Property("manipulation", "", "Any manipulation of product post-collection that is intended to alter the product.  For example a buffy-coat enrichment or CD8 reduction of Peripheral Blood Stem Cells to make it more suitable for infusion.", 0, 1, this.manipulation));
        children.add(new Property("storage", "", "Product storage.", 0, Integer.MAX_VALUE, this.storage));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "This records identifiers associated with this biologically derived product instance that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 197299981: {
                return new Property("productCategory", "code", "Broad category of this product.", 0, 1, this.productCategory);
            }
            case -1492131972: {
                return new Property("productCode", "CodeableConcept", "A code that identifies the kind of this biologically derived product (SNOMED Ctcode).", 0, 1, this.productCode);
            }
            case -892481550: {
                return new Property("status", "code", "Whether the product is currently available.", 0, 1, this.status);
            }
            case 1095692943: {
                return new Property("request", "Reference(ServiceRequest)", "Procedure request to obtain this biologically derived product.", 0, Integer.MAX_VALUE, this.request);
            }
            case -1285004149: {
                return new Property("quantity", "integer", "Number of discrete units within this product.", 0, 1, this.quantity);
            }
            case -995424086: {
                return new Property("parent", "Reference(BiologicallyDerivedProduct)", "Parent product (if any).", 0, Integer.MAX_VALUE, this.parent);
            }
            case -1741312354: {
                return new Property("collection", "", "How this product was collected.", 0, 1, this.collection);
            }
            case 422194963: {
                return new Property("processing", "", "Any processing of the product during collection that does not change the fundamental nature of the product. For example adding anti-coagulants during the collection of Peripheral Blood Stem Cells.", 0, Integer.MAX_VALUE, this.processing);
            }
            case -696214627: {
                return new Property("manipulation", "", "Any manipulation of product post-collection that is intended to alter the product.  For example a buffy-coat enrichment or CD8 reduction of Peripheral Blood Stem Cells to make it more suitable for infusion.", 0, 1, this.manipulation);
            }
            case -1884274053: {
                return new Property("storage", "", "Product storage.", 0, Integer.MAX_VALUE, this.storage);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 197299981: {
                Base[] baseArray;
                if (this.productCategory == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.productCategory;
                }
                return baseArray;
            }
            case -1492131972: {
                Base[] baseArray;
                if (this.productCode == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.productCode;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.status;
                }
                return baseArray;
            }
            case 1095692943: {
                return this.request == null ? new Base[]{} : this.request.toArray(new Base[this.request.size()]);
            }
            case -1285004149: {
                Base[] baseArray;
                if (this.quantity == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.quantity;
                }
                return baseArray;
            }
            case -995424086: {
                return this.parent == null ? new Base[]{} : this.parent.toArray(new Base[this.parent.size()]);
            }
            case -1741312354: {
                Base[] baseArray;
                if (this.collection == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.collection;
                }
                return baseArray;
            }
            case 422194963: {
                return this.processing == null ? new Base[]{} : this.processing.toArray(new Base[this.processing.size()]);
            }
            case -696214627: {
                Base[] baseArray;
                if (this.manipulation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.manipulation;
                }
                return baseArray;
            }
            case -1884274053: {
                return this.storage == null ? new Base[]{} : this.storage.toArray(new Base[this.storage.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case 197299981: {
                value = new BiologicallyDerivedProductCategoryEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.productCategory = value;
                return value;
            }
            case -1492131972: {
                this.productCode = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -892481550: {
                value = new BiologicallyDerivedProductStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case 1095692943: {
                this.getRequest().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1285004149: {
                this.quantity = TypeConvertor.castToInteger(value);
                return value;
            }
            case -995424086: {
                this.getParent().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -1741312354: {
                this.collection = (BiologicallyDerivedProductCollectionComponent)((Object)value);
                return value;
            }
            case 422194963: {
                this.getProcessing().add((BiologicallyDerivedProductProcessingComponent)((Object)value));
                return value;
            }
            case -696214627: {
                this.manipulation = (BiologicallyDerivedProductManipulationComponent)((Object)value);
                return value;
            }
            case -1884274053: {
                this.getStorage().add((BiologicallyDerivedProductStorageComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("productCategory")) {
            value = new BiologicallyDerivedProductCategoryEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.productCategory = value;
        } else if (name.equals("productCode")) {
            this.productCode = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("status")) {
            value = new BiologicallyDerivedProductStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("request")) {
            this.getRequest().add(TypeConvertor.castToReference(value));
        } else if (name.equals("quantity")) {
            this.quantity = TypeConvertor.castToInteger(value);
        } else if (name.equals("parent")) {
            this.getParent().add(TypeConvertor.castToReference(value));
        } else if (name.equals("collection")) {
            this.collection = (BiologicallyDerivedProductCollectionComponent)((Object)value);
        } else if (name.equals("processing")) {
            this.getProcessing().add((BiologicallyDerivedProductProcessingComponent)((Object)value));
        } else if (name.equals("manipulation")) {
            this.manipulation = (BiologicallyDerivedProductManipulationComponent)((Object)value);
        } else if (name.equals("storage")) {
            this.getStorage().add((BiologicallyDerivedProductStorageComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 197299981: {
                return this.getProductCategoryElement();
            }
            case -1492131972: {
                return this.getProductCode();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 1095692943: {
                return this.addRequest();
            }
            case -1285004149: {
                return this.getQuantityElement();
            }
            case -995424086: {
                return this.addParent();
            }
            case -1741312354: {
                return this.getCollection();
            }
            case 422194963: {
                return this.addProcessing();
            }
            case -696214627: {
                return this.getManipulation();
            }
            case -1884274053: {
                return this.addStorage();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 197299981: {
                return new String[]{"code"};
            }
            case -1492131972: {
                return new String[]{"CodeableConcept"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 1095692943: {
                return new String[]{"Reference"};
            }
            case -1285004149: {
                return new String[]{"integer"};
            }
            case -995424086: {
                return new String[]{"Reference"};
            }
            case -1741312354: {
                return new String[0];
            }
            case 422194963: {
                return new String[0];
            }
            case -696214627: {
                return new String[0];
            }
            case -1884274053: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("productCategory")) {
            throw new FHIRException("Cannot call addChild on a primitive type BiologicallyDerivedProduct.productCategory");
        }
        if (name.equals("productCode")) {
            this.productCode = new CodeableConcept();
            return this.productCode;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a primitive type BiologicallyDerivedProduct.status");
        }
        if (name.equals("request")) {
            return this.addRequest();
        }
        if (name.equals("quantity")) {
            throw new FHIRException("Cannot call addChild on a primitive type BiologicallyDerivedProduct.quantity");
        }
        if (name.equals("parent")) {
            return this.addParent();
        }
        if (name.equals("collection")) {
            this.collection = new BiologicallyDerivedProductCollectionComponent();
            return this.collection;
        }
        if (name.equals("processing")) {
            return this.addProcessing();
        }
        if (name.equals("manipulation")) {
            this.manipulation = new BiologicallyDerivedProductManipulationComponent();
            return this.manipulation;
        }
        if (name.equals("storage")) {
            return this.addStorage();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "BiologicallyDerivedProduct";
    }

    @Override
    public BiologicallyDerivedProduct copy() {
        BiologicallyDerivedProduct dst = new BiologicallyDerivedProduct();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(BiologicallyDerivedProduct dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.productCategory = this.productCategory == null ? null : this.productCategory.copy();
        dst.productCode = this.productCode == null ? null : this.productCode.copy();
        Enumeration<BiologicallyDerivedProductStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.request != null) {
            dst.request = new ArrayList<Reference>();
            for (Reference reference : this.request) {
                dst.request.add(reference.copy());
            }
        }
        IntegerType integerType = dst.quantity = this.quantity == null ? null : this.quantity.copy();
        if (this.parent != null) {
            dst.parent = new ArrayList<Reference>();
            for (Reference reference : this.parent) {
                dst.parent.add(reference.copy());
            }
        }
        BiologicallyDerivedProductCollectionComponent biologicallyDerivedProductCollectionComponent = dst.collection = this.collection == null ? null : this.collection.copy();
        if (this.processing != null) {
            dst.processing = new ArrayList<BiologicallyDerivedProductProcessingComponent>();
            for (BiologicallyDerivedProductProcessingComponent biologicallyDerivedProductProcessingComponent : this.processing) {
                dst.processing.add(biologicallyDerivedProductProcessingComponent.copy());
            }
        }
        BiologicallyDerivedProductManipulationComponent biologicallyDerivedProductManipulationComponent = dst.manipulation = this.manipulation == null ? null : this.manipulation.copy();
        if (this.storage != null) {
            dst.storage = new ArrayList<BiologicallyDerivedProductStorageComponent>();
            for (BiologicallyDerivedProductStorageComponent biologicallyDerivedProductStorageComponent : this.storage) {
                dst.storage.add(biologicallyDerivedProductStorageComponent.copy());
            }
        }
    }

    protected BiologicallyDerivedProduct typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof BiologicallyDerivedProduct)) {
            return false;
        }
        BiologicallyDerivedProduct o = (BiologicallyDerivedProduct)other_;
        return BiologicallyDerivedProduct.compareDeep(this.identifier, o.identifier, true) && BiologicallyDerivedProduct.compareDeep(this.productCategory, o.productCategory, true) && BiologicallyDerivedProduct.compareDeep(this.productCode, o.productCode, true) && BiologicallyDerivedProduct.compareDeep(this.status, o.status, true) && BiologicallyDerivedProduct.compareDeep(this.request, o.request, true) && BiologicallyDerivedProduct.compareDeep(this.quantity, o.quantity, true) && BiologicallyDerivedProduct.compareDeep(this.parent, o.parent, true) && BiologicallyDerivedProduct.compareDeep(this.collection, o.collection, true) && BiologicallyDerivedProduct.compareDeep(this.processing, o.processing, true) && BiologicallyDerivedProduct.compareDeep(this.manipulation, o.manipulation, true) && BiologicallyDerivedProduct.compareDeep(this.storage, o.storage, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof BiologicallyDerivedProduct)) {
            return false;
        }
        BiologicallyDerivedProduct o = (BiologicallyDerivedProduct)other_;
        return BiologicallyDerivedProduct.compareValues(this.productCategory, o.productCategory, true) && BiologicallyDerivedProduct.compareValues(this.status, o.status, true) && BiologicallyDerivedProduct.compareValues(this.quantity, o.quantity, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.productCategory, this.productCode, this.status, this.request, this.quantity, this.parent, this.collection, this.processing, this.manipulation, this.storage});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.BiologicallyDerivedProduct;
    }

    @Block
    public static class BiologicallyDerivedProductStorageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of storage", formalDefinition="Description of storage.")
        protected StringType description;
        @Child(name="temperature", type={DecimalType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Storage temperature", formalDefinition="Storage temperature.")
        protected DecimalType temperature;
        @Child(name="scale", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="farenheit | celsius | kelvin", formalDefinition="Temperature scale used.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/product-storage-scale")
        protected Enumeration<BiologicallyDerivedProductStorageScale> scale;
        @Child(name="duration", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Storage timeperiod", formalDefinition="Storage timeperiod.")
        protected Period duration;
        private static final long serialVersionUID = 1509141319L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductStorageComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public BiologicallyDerivedProductStorageComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public BiologicallyDerivedProductStorageComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public DecimalType getTemperatureElement() {
            if (this.temperature == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductStorageComponent.temperature");
                }
                if (Configuration.doAutoCreate()) {
                    this.temperature = new DecimalType();
                }
            }
            return this.temperature;
        }

        public boolean hasTemperatureElement() {
            return this.temperature != null && !this.temperature.isEmpty();
        }

        public boolean hasTemperature() {
            return this.temperature != null && !this.temperature.isEmpty();
        }

        public BiologicallyDerivedProductStorageComponent setTemperatureElement(DecimalType value) {
            this.temperature = value;
            return this;
        }

        public BigDecimal getTemperature() {
            return this.temperature == null ? null : (BigDecimal)this.temperature.getValue();
        }

        public BiologicallyDerivedProductStorageComponent setTemperature(BigDecimal value) {
            if (value == null) {
                this.temperature = null;
            } else {
                if (this.temperature == null) {
                    this.temperature = new DecimalType();
                }
                this.temperature.setValue(value);
            }
            return this;
        }

        public BiologicallyDerivedProductStorageComponent setTemperature(long value) {
            this.temperature = new DecimalType();
            this.temperature.setValue(value);
            return this;
        }

        public BiologicallyDerivedProductStorageComponent setTemperature(double value) {
            this.temperature = new DecimalType();
            this.temperature.setValue(value);
            return this;
        }

        public Enumeration<BiologicallyDerivedProductStorageScale> getScaleElement() {
            if (this.scale == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductStorageComponent.scale");
                }
                if (Configuration.doAutoCreate()) {
                    this.scale = new Enumeration<BiologicallyDerivedProductStorageScale>(new BiologicallyDerivedProductStorageScaleEnumFactory());
                }
            }
            return this.scale;
        }

        public boolean hasScaleElement() {
            return this.scale != null && !this.scale.isEmpty();
        }

        public boolean hasScale() {
            return this.scale != null && !this.scale.isEmpty();
        }

        public BiologicallyDerivedProductStorageComponent setScaleElement(Enumeration<BiologicallyDerivedProductStorageScale> value) {
            this.scale = value;
            return this;
        }

        public BiologicallyDerivedProductStorageScale getScale() {
            return this.scale == null ? null : (BiologicallyDerivedProductStorageScale)((Object)this.scale.getValue());
        }

        public BiologicallyDerivedProductStorageComponent setScale(BiologicallyDerivedProductStorageScale value) {
            if (value == null) {
                this.scale = null;
            } else {
                if (this.scale == null) {
                    this.scale = new Enumeration<BiologicallyDerivedProductStorageScale>(new BiologicallyDerivedProductStorageScaleEnumFactory());
                }
                this.scale.setValue((Object)value);
            }
            return this;
        }

        public Period getDuration() {
            if (this.duration == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductStorageComponent.duration");
                }
                if (Configuration.doAutoCreate()) {
                    this.duration = new Period();
                }
            }
            return this.duration;
        }

        public boolean hasDuration() {
            return this.duration != null && !this.duration.isEmpty();
        }

        public BiologicallyDerivedProductStorageComponent setDuration(Period value) {
            this.duration = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "Description of storage.", 0, 1, this.description));
            children.add(new Property("temperature", "decimal", "Storage temperature.", 0, 1, this.temperature));
            children.add(new Property("scale", "code", "Temperature scale used.", 0, 1, this.scale));
            children.add(new Property("duration", "Period", "Storage timeperiod.", 0, 1, this.duration));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "Description of storage.", 0, 1, this.description);
                }
                case 321701236: {
                    return new Property("temperature", "decimal", "Storage temperature.", 0, 1, this.temperature);
                }
                case 109250890: {
                    return new Property("scale", "code", "Temperature scale used.", 0, 1, this.scale);
                }
                case -1992012396: {
                    return new Property("duration", "Period", "Storage timeperiod.", 0, 1, this.duration);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 321701236: {
                    Base[] baseArray;
                    if (this.temperature == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.temperature;
                    }
                    return baseArray;
                }
                case 109250890: {
                    Base[] baseArray;
                    if (this.scale == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.scale;
                    }
                    return baseArray;
                }
                case -1992012396: {
                    Base[] baseArray;
                    if (this.duration == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.duration;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 321701236: {
                    this.temperature = TypeConvertor.castToDecimal(value);
                    return value;
                }
                case 109250890: {
                    value = new BiologicallyDerivedProductStorageScaleEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.scale = value;
                    return value;
                }
                case -1992012396: {
                    this.duration = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("temperature")) {
                this.temperature = TypeConvertor.castToDecimal(value);
            } else if (name.equals("scale")) {
                value = new BiologicallyDerivedProductStorageScaleEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.scale = value;
            } else if (name.equals("duration")) {
                this.duration = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case 321701236: {
                    return this.getTemperatureElement();
                }
                case 109250890: {
                    return this.getScaleElement();
                }
                case -1992012396: {
                    return this.getDuration();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 321701236: {
                    return new String[]{"decimal"};
                }
                case 109250890: {
                    return new String[]{"code"};
                }
                case -1992012396: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type BiologicallyDerivedProduct.storage.description");
            }
            if (name.equals("temperature")) {
                throw new FHIRException("Cannot call addChild on a primitive type BiologicallyDerivedProduct.storage.temperature");
            }
            if (name.equals("scale")) {
                throw new FHIRException("Cannot call addChild on a primitive type BiologicallyDerivedProduct.storage.scale");
            }
            if (name.equals("duration")) {
                this.duration = new Period();
                return this.duration;
            }
            return super.addChild(name);
        }

        @Override
        public BiologicallyDerivedProductStorageComponent copy() {
            BiologicallyDerivedProductStorageComponent dst = new BiologicallyDerivedProductStorageComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BiologicallyDerivedProductStorageComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.temperature = this.temperature == null ? null : this.temperature.copy();
            dst.scale = this.scale == null ? null : this.scale.copy();
            dst.duration = this.duration == null ? null : this.duration.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductStorageComponent)) {
                return false;
            }
            BiologicallyDerivedProductStorageComponent o = (BiologicallyDerivedProductStorageComponent)other_;
            return BiologicallyDerivedProductStorageComponent.compareDeep(this.description, o.description, true) && BiologicallyDerivedProductStorageComponent.compareDeep(this.temperature, o.temperature, true) && BiologicallyDerivedProductStorageComponent.compareDeep(this.scale, o.scale, true) && BiologicallyDerivedProductStorageComponent.compareDeep(this.duration, o.duration, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductStorageComponent)) {
                return false;
            }
            BiologicallyDerivedProductStorageComponent o = (BiologicallyDerivedProductStorageComponent)other_;
            return BiologicallyDerivedProductStorageComponent.compareValues(this.description, o.description, true) && BiologicallyDerivedProductStorageComponent.compareValues(this.temperature, o.temperature, true) && BiologicallyDerivedProductStorageComponent.compareValues(this.scale, o.scale, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.temperature, this.scale, this.duration});
        }

        @Override
        public String fhirType() {
            return "BiologicallyDerivedProduct.storage";
        }
    }

    @Block
    public static class BiologicallyDerivedProductManipulationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of manipulation", formalDefinition="Description of manipulation.")
        protected StringType description;
        @Child(name="time", type={DateTimeType.class, Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time of manipulation", formalDefinition="Time of manipulation.")
        protected DataType time;
        private static final long serialVersionUID = -1507978496L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductManipulationComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public BiologicallyDerivedProductManipulationComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public BiologicallyDerivedProductManipulationComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public DataType getTime() {
            return this.time;
        }

        public DateTimeType getTimeDateTimeType() throws FHIRException {
            if (this.time == null) {
                this.time = new DateTimeType();
            }
            if (!(this.time instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.time.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.time;
        }

        public boolean hasTimeDateTimeType() {
            return this != null && this.time instanceof DateTimeType;
        }

        public Period getTimePeriod() throws FHIRException {
            if (this.time == null) {
                this.time = new Period();
            }
            if (!(this.time instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.time.getClass().getName() + " was encountered");
            }
            return (Period)this.time;
        }

        public boolean hasTimePeriod() {
            return this != null && this.time instanceof Period;
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public BiologicallyDerivedProductManipulationComponent setTime(DataType value) {
            if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
                throw new Error("Not the right type for BiologicallyDerivedProduct.manipulation.time[x]: " + value.fhirType());
            }
            this.time = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "Description of manipulation.", 0, 1, this.description));
            children.add(new Property("time[x]", "dateTime|Period", "Time of manipulation.", 0, 1, this.time));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "Description of manipulation.", 0, 1, this.description);
                }
                case -1313930605: {
                    return new Property("time[x]", "dateTime|Period", "Time of manipulation.", 0, 1, this.time);
                }
                case 3560141: {
                    return new Property("time[x]", "dateTime|Period", "Time of manipulation.", 0, 1, this.time);
                }
                case 2135345544: {
                    return new Property("time[x]", "dateTime", "Time of manipulation.", 0, 1, this.time);
                }
                case 693544686: {
                    return new Property("time[x]", "Period", "Time of manipulation.", 0, 1, this.time);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case 3560141: {
                    Base[] baseArray;
                    if (this.time == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.time;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case 3560141: {
                    this.time = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("time[x]")) {
                this.time = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1313930605: {
                    return this.getTime();
                }
                case 3560141: {
                    return this.getTime();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case 3560141: {
                    return new String[]{"dateTime", "Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type BiologicallyDerivedProduct.manipulation.description");
            }
            if (name.equals("timeDateTime")) {
                this.time = new DateTimeType();
                return this.time;
            }
            if (name.equals("timePeriod")) {
                this.time = new Period();
                return this.time;
            }
            return super.addChild(name);
        }

        @Override
        public BiologicallyDerivedProductManipulationComponent copy() {
            BiologicallyDerivedProductManipulationComponent dst = new BiologicallyDerivedProductManipulationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BiologicallyDerivedProductManipulationComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.time = this.time == null ? null : this.time.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductManipulationComponent)) {
                return false;
            }
            BiologicallyDerivedProductManipulationComponent o = (BiologicallyDerivedProductManipulationComponent)other_;
            return BiologicallyDerivedProductManipulationComponent.compareDeep(this.description, o.description, true) && BiologicallyDerivedProductManipulationComponent.compareDeep(this.time, o.time, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductManipulationComponent)) {
                return false;
            }
            BiologicallyDerivedProductManipulationComponent o = (BiologicallyDerivedProductManipulationComponent)other_;
            return BiologicallyDerivedProductManipulationComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.time});
        }

        @Override
        public String fhirType() {
            return "BiologicallyDerivedProduct.manipulation";
        }
    }

    @Block
    public static class BiologicallyDerivedProductProcessingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Description of of processing", formalDefinition="Description of of processing.")
        protected StringType description;
        @Child(name="procedure", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Procesing code", formalDefinition="Procesing code.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
        protected CodeableConcept procedure;
        @Child(name="additive", type={Substance.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Substance added during processing", formalDefinition="Substance added during processing.")
        protected Reference additive;
        @Child(name="time", type={DateTimeType.class, Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time of processing", formalDefinition="Time of processing.")
        protected DataType time;
        private static final long serialVersionUID = 1871947569L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductProcessingComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public BiologicallyDerivedProductProcessingComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public BiologicallyDerivedProductProcessingComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public CodeableConcept getProcedure() {
            if (this.procedure == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductProcessingComponent.procedure");
                }
                if (Configuration.doAutoCreate()) {
                    this.procedure = new CodeableConcept();
                }
            }
            return this.procedure;
        }

        public boolean hasProcedure() {
            return this.procedure != null && !this.procedure.isEmpty();
        }

        public BiologicallyDerivedProductProcessingComponent setProcedure(CodeableConcept value) {
            this.procedure = value;
            return this;
        }

        public Reference getAdditive() {
            if (this.additive == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductProcessingComponent.additive");
                }
                if (Configuration.doAutoCreate()) {
                    this.additive = new Reference();
                }
            }
            return this.additive;
        }

        public boolean hasAdditive() {
            return this.additive != null && !this.additive.isEmpty();
        }

        public BiologicallyDerivedProductProcessingComponent setAdditive(Reference value) {
            this.additive = value;
            return this;
        }

        public DataType getTime() {
            return this.time;
        }

        public DateTimeType getTimeDateTimeType() throws FHIRException {
            if (this.time == null) {
                this.time = new DateTimeType();
            }
            if (!(this.time instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.time.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.time;
        }

        public boolean hasTimeDateTimeType() {
            return this != null && this.time instanceof DateTimeType;
        }

        public Period getTimePeriod() throws FHIRException {
            if (this.time == null) {
                this.time = new Period();
            }
            if (!(this.time instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.time.getClass().getName() + " was encountered");
            }
            return (Period)this.time;
        }

        public boolean hasTimePeriod() {
            return this != null && this.time instanceof Period;
        }

        public boolean hasTime() {
            return this.time != null && !this.time.isEmpty();
        }

        public BiologicallyDerivedProductProcessingComponent setTime(DataType value) {
            if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
                throw new Error("Not the right type for BiologicallyDerivedProduct.processing.time[x]: " + value.fhirType());
            }
            this.time = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "Description of of processing.", 0, 1, this.description));
            children.add(new Property("procedure", "CodeableConcept", "Procesing code.", 0, 1, this.procedure));
            children.add(new Property("additive", "Reference(Substance)", "Substance added during processing.", 0, 1, this.additive));
            children.add(new Property("time[x]", "dateTime|Period", "Time of processing.", 0, 1, this.time));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "Description of of processing.", 0, 1, this.description);
                }
                case -1095204141: {
                    return new Property("procedure", "CodeableConcept", "Procesing code.", 0, 1, this.procedure);
                }
                case -1226589236: {
                    return new Property("additive", "Reference(Substance)", "Substance added during processing.", 0, 1, this.additive);
                }
                case -1313930605: {
                    return new Property("time[x]", "dateTime|Period", "Time of processing.", 0, 1, this.time);
                }
                case 3560141: {
                    return new Property("time[x]", "dateTime|Period", "Time of processing.", 0, 1, this.time);
                }
                case 2135345544: {
                    return new Property("time[x]", "dateTime", "Time of processing.", 0, 1, this.time);
                }
                case 693544686: {
                    return new Property("time[x]", "Period", "Time of processing.", 0, 1, this.time);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -1095204141: {
                    Base[] baseArray;
                    if (this.procedure == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.procedure;
                    }
                    return baseArray;
                }
                case -1226589236: {
                    Base[] baseArray;
                    if (this.additive == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.additive;
                    }
                    return baseArray;
                }
                case 3560141: {
                    Base[] baseArray;
                    if (this.time == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.time;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = TypeConvertor.castToString(value);
                    return value;
                }
                case -1095204141: {
                    this.procedure = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1226589236: {
                    this.additive = TypeConvertor.castToReference(value);
                    return value;
                }
                case 3560141: {
                    this.time = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = TypeConvertor.castToString(value);
            } else if (name.equals("procedure")) {
                this.procedure = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("additive")) {
                this.additive = TypeConvertor.castToReference(value);
            } else if (name.equals("time[x]")) {
                this.time = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1095204141: {
                    return this.getProcedure();
                }
                case -1226589236: {
                    return this.getAdditive();
                }
                case -1313930605: {
                    return this.getTime();
                }
                case 3560141: {
                    return this.getTime();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1095204141: {
                    return new String[]{"CodeableConcept"};
                }
                case -1226589236: {
                    return new String[]{"Reference"};
                }
                case 3560141: {
                    return new String[]{"dateTime", "Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type BiologicallyDerivedProduct.processing.description");
            }
            if (name.equals("procedure")) {
                this.procedure = new CodeableConcept();
                return this.procedure;
            }
            if (name.equals("additive")) {
                this.additive = new Reference();
                return this.additive;
            }
            if (name.equals("timeDateTime")) {
                this.time = new DateTimeType();
                return this.time;
            }
            if (name.equals("timePeriod")) {
                this.time = new Period();
                return this.time;
            }
            return super.addChild(name);
        }

        @Override
        public BiologicallyDerivedProductProcessingComponent copy() {
            BiologicallyDerivedProductProcessingComponent dst = new BiologicallyDerivedProductProcessingComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BiologicallyDerivedProductProcessingComponent dst) {
            super.copyValues(dst);
            dst.description = this.description == null ? null : this.description.copy();
            dst.procedure = this.procedure == null ? null : this.procedure.copy();
            dst.additive = this.additive == null ? null : this.additive.copy();
            dst.time = this.time == null ? null : this.time.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductProcessingComponent)) {
                return false;
            }
            BiologicallyDerivedProductProcessingComponent o = (BiologicallyDerivedProductProcessingComponent)other_;
            return BiologicallyDerivedProductProcessingComponent.compareDeep(this.description, o.description, true) && BiologicallyDerivedProductProcessingComponent.compareDeep(this.procedure, o.procedure, true) && BiologicallyDerivedProductProcessingComponent.compareDeep(this.additive, o.additive, true) && BiologicallyDerivedProductProcessingComponent.compareDeep(this.time, o.time, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductProcessingComponent)) {
                return false;
            }
            BiologicallyDerivedProductProcessingComponent o = (BiologicallyDerivedProductProcessingComponent)other_;
            return BiologicallyDerivedProductProcessingComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.description, this.procedure, this.additive, this.time});
        }

        @Override
        public String fhirType() {
            return "BiologicallyDerivedProduct.processing";
        }
    }

    @Block
    public static class BiologicallyDerivedProductCollectionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="collector", type={Practitioner.class, PractitionerRole.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Individual performing collection", formalDefinition="Healthcare professional who is performing the collection.")
        protected Reference collector;
        @Child(name="source", type={Patient.class, Organization.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who is product from", formalDefinition="The patient or entity, such as a hospital or vendor in the case of a processed/manipulated/manufactured product, providing the product.")
        protected Reference source;
        @Child(name="collected", type={DateTimeType.class, Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time of product collection", formalDefinition="Time of product collection.")
        protected DataType collected;
        private static final long serialVersionUID = 626956533L;

        public Reference getCollector() {
            if (this.collector == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductCollectionComponent.collector");
                }
                if (Configuration.doAutoCreate()) {
                    this.collector = new Reference();
                }
            }
            return this.collector;
        }

        public boolean hasCollector() {
            return this.collector != null && !this.collector.isEmpty();
        }

        public BiologicallyDerivedProductCollectionComponent setCollector(Reference value) {
            this.collector = value;
            return this;
        }

        public Reference getSource() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BiologicallyDerivedProductCollectionComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new Reference();
                }
            }
            return this.source;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public BiologicallyDerivedProductCollectionComponent setSource(Reference value) {
            this.source = value;
            return this;
        }

        public DataType getCollected() {
            return this.collected;
        }

        public DateTimeType getCollectedDateTimeType() throws FHIRException {
            if (this.collected == null) {
                this.collected = new DateTimeType();
            }
            if (!(this.collected instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.collected.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.collected;
        }

        public boolean hasCollectedDateTimeType() {
            return this != null && this.collected instanceof DateTimeType;
        }

        public Period getCollectedPeriod() throws FHIRException {
            if (this.collected == null) {
                this.collected = new Period();
            }
            if (!(this.collected instanceof Period)) {
                throw new FHIRException("Type mismatch: the type Period was expected, but " + this.collected.getClass().getName() + " was encountered");
            }
            return (Period)this.collected;
        }

        public boolean hasCollectedPeriod() {
            return this != null && this.collected instanceof Period;
        }

        public boolean hasCollected() {
            return this.collected != null && !this.collected.isEmpty();
        }

        public BiologicallyDerivedProductCollectionComponent setCollected(DataType value) {
            if (value != null && !(value instanceof DateTimeType) && !(value instanceof Period)) {
                throw new Error("Not the right type for BiologicallyDerivedProduct.collection.collected[x]: " + value.fhirType());
            }
            this.collected = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("collector", "Reference(Practitioner|PractitionerRole)", "Healthcare professional who is performing the collection.", 0, 1, this.collector));
            children.add(new Property("source", "Reference(Patient|Organization)", "The patient or entity, such as a hospital or vendor in the case of a processed/manipulated/manufactured product, providing the product.", 0, 1, this.source));
            children.add(new Property("collected[x]", "dateTime|Period", "Time of product collection.", 0, 1, this.collected));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1883491469: {
                    return new Property("collector", "Reference(Practitioner|PractitionerRole)", "Healthcare professional who is performing the collection.", 0, 1, this.collector);
                }
                case -896505829: {
                    return new Property("source", "Reference(Patient|Organization)", "The patient or entity, such as a hospital or vendor in the case of a processed/manipulated/manufactured product, providing the product.", 0, 1, this.source);
                }
                case 1632037015: {
                    return new Property("collected[x]", "dateTime|Period", "Time of product collection.", 0, 1, this.collected);
                }
                case 1883491145: {
                    return new Property("collected[x]", "dateTime|Period", "Time of product collection.", 0, 1, this.collected);
                }
                case 2005009924: {
                    return new Property("collected[x]", "dateTime", "Time of product collection.", 0, 1, this.collected);
                }
                case 653185642: {
                    return new Property("collected[x]", "Period", "Time of product collection.", 0, 1, this.collected);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    Base[] baseArray;
                    if (this.collector == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.collector;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.source;
                    }
                    return baseArray;
                }
                case 1883491145: {
                    Base[] baseArray;
                    if (this.collected == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.collected;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    this.collector = TypeConvertor.castToReference(value);
                    return value;
                }
                case -896505829: {
                    this.source = TypeConvertor.castToReference(value);
                    return value;
                }
                case 1883491145: {
                    this.collected = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("collector")) {
                this.collector = TypeConvertor.castToReference(value);
            } else if (name.equals("source")) {
                this.source = TypeConvertor.castToReference(value);
            } else if (name.equals("collected[x]")) {
                this.collected = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    return this.getCollector();
                }
                case -896505829: {
                    return this.getSource();
                }
                case 1632037015: {
                    return this.getCollected();
                }
                case 1883491145: {
                    return this.getCollected();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1883491469: {
                    return new String[]{"Reference"};
                }
                case -896505829: {
                    return new String[]{"Reference"};
                }
                case 1883491145: {
                    return new String[]{"dateTime", "Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("collector")) {
                this.collector = new Reference();
                return this.collector;
            }
            if (name.equals("source")) {
                this.source = new Reference();
                return this.source;
            }
            if (name.equals("collectedDateTime")) {
                this.collected = new DateTimeType();
                return this.collected;
            }
            if (name.equals("collectedPeriod")) {
                this.collected = new Period();
                return this.collected;
            }
            return super.addChild(name);
        }

        @Override
        public BiologicallyDerivedProductCollectionComponent copy() {
            BiologicallyDerivedProductCollectionComponent dst = new BiologicallyDerivedProductCollectionComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BiologicallyDerivedProductCollectionComponent dst) {
            super.copyValues(dst);
            dst.collector = this.collector == null ? null : this.collector.copy();
            dst.source = this.source == null ? null : this.source.copy();
            dst.collected = this.collected == null ? null : this.collected.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductCollectionComponent)) {
                return false;
            }
            BiologicallyDerivedProductCollectionComponent o = (BiologicallyDerivedProductCollectionComponent)other_;
            return BiologicallyDerivedProductCollectionComponent.compareDeep(this.collector, o.collector, true) && BiologicallyDerivedProductCollectionComponent.compareDeep(this.source, o.source, true) && BiologicallyDerivedProductCollectionComponent.compareDeep(this.collected, o.collected, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BiologicallyDerivedProductCollectionComponent)) {
                return false;
            }
            BiologicallyDerivedProductCollectionComponent o = (BiologicallyDerivedProductCollectionComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.collector, this.source, this.collected});
        }

        @Override
        public String fhirType() {
            return "BiologicallyDerivedProduct.collection";
        }
    }

    public static class BiologicallyDerivedProductStorageScaleEnumFactory
    implements EnumFactory<BiologicallyDerivedProductStorageScale> {
        @Override
        public BiologicallyDerivedProductStorageScale fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("farenheit".equals(codeString)) {
                return BiologicallyDerivedProductStorageScale.FARENHEIT;
            }
            if ("celsius".equals(codeString)) {
                return BiologicallyDerivedProductStorageScale.CELSIUS;
            }
            if ("kelvin".equals(codeString)) {
                return BiologicallyDerivedProductStorageScale.KELVIN;
            }
            throw new IllegalArgumentException("Unknown BiologicallyDerivedProductStorageScale code '" + codeString + "'");
        }

        public Enumeration<BiologicallyDerivedProductStorageScale> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<BiologicallyDerivedProductStorageScale>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("farenheit".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductStorageScale>(this, BiologicallyDerivedProductStorageScale.FARENHEIT);
            }
            if ("celsius".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductStorageScale>(this, BiologicallyDerivedProductStorageScale.CELSIUS);
            }
            if ("kelvin".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductStorageScale>(this, BiologicallyDerivedProductStorageScale.KELVIN);
            }
            throw new FHIRException("Unknown BiologicallyDerivedProductStorageScale code '" + codeString + "'");
        }

        @Override
        public String toCode(BiologicallyDerivedProductStorageScale code) {
            if (code == BiologicallyDerivedProductStorageScale.FARENHEIT) {
                return "farenheit";
            }
            if (code == BiologicallyDerivedProductStorageScale.CELSIUS) {
                return "celsius";
            }
            if (code == BiologicallyDerivedProductStorageScale.KELVIN) {
                return "kelvin";
            }
            return "?";
        }

        @Override
        public String toSystem(BiologicallyDerivedProductStorageScale code) {
            return code.getSystem();
        }
    }

    public static enum BiologicallyDerivedProductStorageScale {
        FARENHEIT,
        CELSIUS,
        KELVIN,
        NULL;


        public static BiologicallyDerivedProductStorageScale fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("farenheit".equals(codeString)) {
                return FARENHEIT;
            }
            if ("celsius".equals(codeString)) {
                return CELSIUS;
            }
            if ("kelvin".equals(codeString)) {
                return KELVIN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown BiologicallyDerivedProductStorageScale code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case FARENHEIT: {
                    return "farenheit";
                }
                case CELSIUS: {
                    return "celsius";
                }
                case KELVIN: {
                    return "kelvin";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case FARENHEIT: {
                    return "http://hl7.org/fhir/product-storage-scale";
                }
                case CELSIUS: {
                    return "http://hl7.org/fhir/product-storage-scale";
                }
                case KELVIN: {
                    return "http://hl7.org/fhir/product-storage-scale";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case FARENHEIT: {
                    return "Fahrenheit temperature scale.";
                }
                case CELSIUS: {
                    return "Celsius or centigrade temperature scale.";
                }
                case KELVIN: {
                    return "Kelvin absolute thermodynamic temperature scale.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case FARENHEIT: {
                    return "Fahrenheit";
                }
                case CELSIUS: {
                    return "Celsius";
                }
                case KELVIN: {
                    return "Kelvin";
                }
            }
            return "?";
        }
    }

    public static class BiologicallyDerivedProductStatusEnumFactory
    implements EnumFactory<BiologicallyDerivedProductStatus> {
        @Override
        public BiologicallyDerivedProductStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("available".equals(codeString)) {
                return BiologicallyDerivedProductStatus.AVAILABLE;
            }
            if ("unavailable".equals(codeString)) {
                return BiologicallyDerivedProductStatus.UNAVAILABLE;
            }
            throw new IllegalArgumentException("Unknown BiologicallyDerivedProductStatus code '" + codeString + "'");
        }

        public Enumeration<BiologicallyDerivedProductStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<BiologicallyDerivedProductStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("available".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductStatus>(this, BiologicallyDerivedProductStatus.AVAILABLE);
            }
            if ("unavailable".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductStatus>(this, BiologicallyDerivedProductStatus.UNAVAILABLE);
            }
            throw new FHIRException("Unknown BiologicallyDerivedProductStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(BiologicallyDerivedProductStatus code) {
            if (code == BiologicallyDerivedProductStatus.AVAILABLE) {
                return "available";
            }
            if (code == BiologicallyDerivedProductStatus.UNAVAILABLE) {
                return "unavailable";
            }
            return "?";
        }

        @Override
        public String toSystem(BiologicallyDerivedProductStatus code) {
            return code.getSystem();
        }
    }

    public static enum BiologicallyDerivedProductStatus {
        AVAILABLE,
        UNAVAILABLE,
        NULL;


        public static BiologicallyDerivedProductStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("available".equals(codeString)) {
                return AVAILABLE;
            }
            if ("unavailable".equals(codeString)) {
                return UNAVAILABLE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown BiologicallyDerivedProductStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case AVAILABLE: {
                    return "available";
                }
                case UNAVAILABLE: {
                    return "unavailable";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case AVAILABLE: {
                    return "http://hl7.org/fhir/product-status";
                }
                case UNAVAILABLE: {
                    return "http://hl7.org/fhir/product-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case AVAILABLE: {
                    return "";
                }
                case UNAVAILABLE: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case AVAILABLE: {
                    return "Available";
                }
                case UNAVAILABLE: {
                    return "Unavailable";
                }
            }
            return "?";
        }
    }

    public static class BiologicallyDerivedProductCategoryEnumFactory
    implements EnumFactory<BiologicallyDerivedProductCategory> {
        @Override
        public BiologicallyDerivedProductCategory fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("organ".equals(codeString)) {
                return BiologicallyDerivedProductCategory.ORGAN;
            }
            if ("tissue".equals(codeString)) {
                return BiologicallyDerivedProductCategory.TISSUE;
            }
            if ("fluid".equals(codeString)) {
                return BiologicallyDerivedProductCategory.FLUID;
            }
            if ("cells".equals(codeString)) {
                return BiologicallyDerivedProductCategory.CELLS;
            }
            if ("biologicalAgent".equals(codeString)) {
                return BiologicallyDerivedProductCategory.BIOLOGICALAGENT;
            }
            throw new IllegalArgumentException("Unknown BiologicallyDerivedProductCategory code '" + codeString + "'");
        }

        public Enumeration<BiologicallyDerivedProductCategory> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<BiologicallyDerivedProductCategory>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("organ".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductCategory>(this, BiologicallyDerivedProductCategory.ORGAN);
            }
            if ("tissue".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductCategory>(this, BiologicallyDerivedProductCategory.TISSUE);
            }
            if ("fluid".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductCategory>(this, BiologicallyDerivedProductCategory.FLUID);
            }
            if ("cells".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductCategory>(this, BiologicallyDerivedProductCategory.CELLS);
            }
            if ("biologicalAgent".equals(codeString)) {
                return new Enumeration<BiologicallyDerivedProductCategory>(this, BiologicallyDerivedProductCategory.BIOLOGICALAGENT);
            }
            throw new FHIRException("Unknown BiologicallyDerivedProductCategory code '" + codeString + "'");
        }

        @Override
        public String toCode(BiologicallyDerivedProductCategory code) {
            if (code == BiologicallyDerivedProductCategory.ORGAN) {
                return "organ";
            }
            if (code == BiologicallyDerivedProductCategory.TISSUE) {
                return "tissue";
            }
            if (code == BiologicallyDerivedProductCategory.FLUID) {
                return "fluid";
            }
            if (code == BiologicallyDerivedProductCategory.CELLS) {
                return "cells";
            }
            if (code == BiologicallyDerivedProductCategory.BIOLOGICALAGENT) {
                return "biologicalAgent";
            }
            return "?";
        }

        @Override
        public String toSystem(BiologicallyDerivedProductCategory code) {
            return code.getSystem();
        }
    }

    public static enum BiologicallyDerivedProductCategory {
        ORGAN,
        TISSUE,
        FLUID,
        CELLS,
        BIOLOGICALAGENT,
        NULL;


        public static BiologicallyDerivedProductCategory fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("organ".equals(codeString)) {
                return ORGAN;
            }
            if ("tissue".equals(codeString)) {
                return TISSUE;
            }
            if ("fluid".equals(codeString)) {
                return FLUID;
            }
            if ("cells".equals(codeString)) {
                return CELLS;
            }
            if ("biologicalAgent".equals(codeString)) {
                return BIOLOGICALAGENT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown BiologicallyDerivedProductCategory code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ORGAN: {
                    return "organ";
                }
                case TISSUE: {
                    return "tissue";
                }
                case FLUID: {
                    return "fluid";
                }
                case CELLS: {
                    return "cells";
                }
                case BIOLOGICALAGENT: {
                    return "biologicalAgent";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ORGAN: {
                    return "http://hl7.org/fhir/product-category";
                }
                case TISSUE: {
                    return "http://hl7.org/fhir/product-category";
                }
                case FLUID: {
                    return "http://hl7.org/fhir/product-category";
                }
                case CELLS: {
                    return "http://hl7.org/fhir/product-category";
                }
                case BIOLOGICALAGENT: {
                    return "http://hl7.org/fhir/product-category";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ORGAN: {
                    return "A collection of tissues joined in a structural unit to serve a common function.";
                }
                case TISSUE: {
                    return "An ensemble of similar cells and their extracellular matrix from the same origin that together carry out a specific function.";
                }
                case FLUID: {
                    return "Body fluid.";
                }
                case CELLS: {
                    return "Collection of cells.";
                }
                case BIOLOGICALAGENT: {
                    return "Biological agent of unspecified type.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ORGAN: {
                    return "Organ";
                }
                case TISSUE: {
                    return "Tissue";
                }
                case FLUID: {
                    return "Fluid";
                }
                case CELLS: {
                    return "Cells";
                }
                case BIOLOGICALAGENT: {
                    return "BiologicalAgent";
                }
            }
            return "?";
        }
    }
}

