/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.formats;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.ParserBase;
import org.hl7.fhir.r5.formats.ParserType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.utils.formats.Turtle;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public abstract class RdfParserBase
extends ParserBase
implements IParser {
    private String url;

    protected abstract void composeResource(Turtle.Complex var1, Resource var2) throws IOException;

    @Override
    public ParserType getType() {
        return ParserType.RDF_TURTLE;
    }

    @Override
    public Resource parse(InputStream input) throws IOException, FHIRFormatError {
        throw new Error("Parsing not implemented yet");
    }

    @Override
    public DataType parseType(InputStream input, String knownType) throws IOException, FHIRFormatError {
        throw new Error("Parsing not implemented yet");
    }

    @Override
    public DataType parseAnyType(InputStream input, String knownType) throws IOException, FHIRFormatError {
        throw new Error("Parsing not implemented yet");
    }

    @Override
    public void compose(OutputStream stream, Resource resource) throws IOException {
        Turtle ttl = new Turtle();
        ttl.prefix("fhir", "http://hl7.org/fhir/");
        ttl.prefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        Turtle.Section section = ttl.section("resource");
        Turtle.Subject subject = this.url != null ? section.triple("<" + this.url + ">", "a", "fhir:" + resource.getResourceType().toString()) : section.triple("[]", "a", "fhir:" + resource.getResourceType().toString());
        this.composeResource(subject, resource);
        try {
            ttl.commit(stream, false);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void composeBase(Turtle.Complex t, String parentType, String name, Base element, int index) {
    }

    @Override
    public void compose(OutputStream stream, DataType type, String rootName) throws IOException {
        throw new Error("Not supported in RDF");
    }

    protected String ttlLiteral(String value) {
        return "\"" + Turtle.escape(value, true) + "\"";
    }

    protected void composeXhtmlNode(Turtle.Complex t, String string, String string2, XhtmlNode div, int i) {
    }

    protected void decorateCode(Turtle.Complex t, Enumeration<? extends Enum> value) {
    }

    protected void decorateCode(Turtle.Complex t, CodeType value) {
    }

    protected void decorateCoding(Turtle.Complex t, Coding element) {
        if (!element.hasSystem()) {
            return;
        }
        if ("http://snomed.info/sct".equals(element.getSystem())) {
            t.prefix("sct", "http://snomed.info/sct/");
            t.predicate("a", "sct:" + element.getCode());
        } else if ("http://snomed.info/sct".equals(element.getSystem())) {
            t.prefix("loinc", "http://loinc.org/rdf#");
            t.predicate("a", "loinc:" + element.getCode());
        }
    }

    protected void decorateCodeableConcept(Turtle.Complex t, CodeableConcept element) {
        for (Coding c : element.getCoding()) {
            this.decorateCoding(t, c);
        }
    }
}

