/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils.formats;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FontFormatting;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.PatternFormatting;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.formats.XmlParser;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.Type;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TextStreamWriter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAutoFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCustomFilter;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCustomFilters;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilterColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFilters;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STFilterOperator;

public class XLSXWriter
extends TextStreamWriter {
    private StructureDefinition def;
    private List<StructureDefinition.StructureDefinitionMappingComponent> mapKeys = new ArrayList<StructureDefinition.StructureDefinitionMappingComponent>();
    private Map<String, CellStyle> styles;
    private OutputStream outStream;
    private XSSFWorkbook wb = new XSSFWorkbook();
    private Sheet sheet;
    private XmlParser xml = new XmlParser();
    private JsonParser json = new JsonParser();
    private boolean asXml;
    private boolean hideMustSupportFalse;
    private static String[] titles = new String[]{"Path", "Slice Name", "Alias(s)", "Label", "Min", "Max", "Must Support?", "Is Modifier?", "Is Summary?", "Type(s)", "Short", "Definition", "Comments", "Requirements", "Default Value", "Meaning When Missing", "Fixed Value", "Pattern", "Example", "Minimum Value", "Maximum Value", "Maximum Length", "Binding Strength", "Binding Description", "Binding Value Set", "Code", "Slicing Discriminator", "Slicing Description", "Slicing Ordered", "Slicing Rules", "Base Path", "Base Min", "Base Max", "Condition(s)", "Constraint(s)"};

    public XLSXWriter(OutputStream out, StructureDefinition def, boolean asXml, boolean hideMustSupportFalse) throws UnsupportedEncodingException {
        super(out);
        int i;
        this.outStream = out;
        this.asXml = asXml;
        this.def = def;
        this.hideMustSupportFalse = hideMustSupportFalse;
        this.sheet = this.wb.createSheet("Elements");
        this.styles = XLSXWriter.createStyles((Workbook)this.wb);
        Row headerRow = this.sheet.createRow(0);
        for (i = 0; i < titles.length; ++i) {
            this.addCell(headerRow, i, titles[i], this.styles.get("header"));
        }
        i = titles.length - 1;
        for (StructureDefinition.StructureDefinitionMappingComponent map : def.getMapping()) {
            this.addCell(headerRow, ++i, "Mapping: " + map.getName(), this.styles.get("header"));
        }
    }

    private void addCell(Row row, int pos, String content) {
        this.addCell(row, pos, content, this.styles.get("body"));
    }

    public void addCell(Row row, int pos, boolean b) {
        this.addCell(row, pos, b ? "Y" : "");
    }

    public void addCell(Row row, int pos, int content) {
        this.addCell(row, pos, Integer.toString(content));
    }

    private void addCell(Row row, int pos, String content, CellStyle style) {
        Cell cell = row.createCell(pos);
        cell.setCellValue(content);
        cell.setCellStyle(style);
    }

    private static Map<String, CellStyle> createStyles(Workbook wb) {
        HashMap<String, CellStyle> styles = new HashMap<String, CellStyle>();
        Font headerFont = wb.createFont();
        headerFont.setBold(true);
        CellStyle style = XLSXWriter.createBorderedStyle(wb);
        style.setFillForegroundColor(IndexedColors.LIGHT_CORNFLOWER_BLUE.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setWrapText(true);
        style.setFont(headerFont);
        styles.put("header", style);
        style = XLSXWriter.createBorderedStyle(wb);
        style.setVerticalAlignment(VerticalAlignment.TOP);
        style.setWrapText(true);
        styles.put("body", style);
        return styles;
    }

    private static CellStyle createBorderedStyle(Workbook wb) {
        BorderStyle thin = BorderStyle.THIN;
        short black = IndexedColors.GREY_50_PERCENT.getIndex();
        CellStyle style = wb.createCellStyle();
        style.setBorderRight(thin);
        style.setRightBorderColor(black);
        style.setBorderBottom(thin);
        style.setBottomBorderColor(black);
        style.setBorderLeft(thin);
        style.setLeftBorderColor(black);
        style.setBorderTop(thin);
        style.setTopBorderColor(black);
        return style;
    }

    public void processElement(ElementDefinition ed) throws Exception {
        Row row = this.sheet.createRow(this.sheet.getLastRowNum() + 1);
        int i = 0;
        this.addCell(row, i++, ed.getPath(), this.styles.get("body"));
        this.addCell(row, i++, ed.getSliceName());
        this.addCell(row, i++, this.itemList(ed.getAlias()));
        this.addCell(row, i++, ed.getLabel());
        this.addCell(row, i++, ed.getMin());
        this.addCell(row, i++, ed.getMax());
        this.addCell(row, i++, ed.getMustSupport() ? "Y" : "");
        this.addCell(row, i++, ed.getIsModifier() ? "Y" : "");
        this.addCell(row, i++, ed.getIsSummary() ? "Y" : "");
        this.addCell(row, i++, this.itemList(ed.getType()));
        this.addCell(row, i++, ed.getShort());
        this.addCell(row, i++, ed.getDefinition());
        this.addCell(row, i++, ed.getComment());
        this.addCell(row, i++, ed.getRequirements());
        this.addCell(row, i++, ed.getDefaultValue() != null ? this.renderType(ed.getDefaultValue()) : "");
        this.addCell(row, i++, ed.getMeaningWhenMissing());
        this.addCell(row, i++, ed.hasFixed() ? this.renderType(ed.getFixed()) : "");
        this.addCell(row, i++, ed.hasPattern() ? this.renderType(ed.getPattern()) : "");
        this.addCell(row, i++, ed.hasExample() ? this.renderType(ed.getExample().get(0).getValue()) : "");
        this.addCell(row, i++, ed.hasMinValue() ? this.renderType(ed.getMinValue()) : "");
        this.addCell(row, i++, ed.hasMaxValue() ? this.renderType(ed.getMaxValue()) : "");
        this.addCell(row, i++, ed.hasMaxLength() ? Integer.toString(ed.getMaxLength()) : "");
        if (ed.hasBinding()) {
            this.addCell(row, i++, ed.getBinding().getStrength() != null ? ed.getBinding().getStrength().toCode() : "");
            this.addCell(row, i++, ed.getBinding().getDescription());
            if (ed.getBinding().getValueSet() == null) {
                this.addCell(row, i++, "");
            } else {
                this.addCell(row, i++, ed.getBinding().getValueSet());
            }
        } else {
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
        }
        this.addCell(row, i++, this.itemList(ed.getCode()));
        if (ed.hasSlicing()) {
            this.addCell(row, i++, this.itemList(ed.getSlicing().getDiscriminator()));
            this.addCell(row, i++, ed.getSlicing().getDescription());
            this.addCell(row, i++, ed.getSlicing().getOrdered());
            this.addCell(row, i++, ed.getSlicing().getRules() != null ? ed.getSlicing().getRules().toCode() : "");
        } else {
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
        }
        if (ed.getBase() != null) {
            this.addCell(row, i++, ed.getBase().getPath());
            this.addCell(row, i++, ed.getBase().getMin());
            this.addCell(row, i++, ed.getBase().getMax());
        } else {
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
            this.addCell(row, i++, "");
        }
        this.addCell(row, i++, this.itemList(ed.getCondition()));
        this.addCell(row, i++, this.itemList(ed.getConstraint()));
        for (StructureDefinition.StructureDefinitionMappingComponent mapKey : this.def.getMapping()) {
            String mapString = "";
            for (ElementDefinition.ElementDefinitionMappingComponent map : ed.getMapping()) {
                if (!map.getIdentity().equals(mapKey.getIdentity())) continue;
                mapString = map.getMap();
            }
            this.addCell(row, i++, mapString);
        }
    }

    private String itemList(List l) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < l.size(); ++i) {
            Element c;
            Element t;
            Object o = l.get(i);
            String val = "";
            if (o instanceof StringType) {
                val = (String)((StringType)o).getValue();
            } else if (o instanceof UriType) {
                val = (String)((UriType)o).getValue();
            } else if (o instanceof IdType) {
                val = ((IdType)o).getValue();
            } else if (o instanceof java.util.Enumeration) {
                val = o.toString();
            } else if (o instanceof ElementDefinition.TypeRefComponent) {
                t = (ElementDefinition.TypeRefComponent)o;
                val = ((ElementDefinition.TypeRefComponent)t).getWorkingCode();
                if (val == null) {
                    val = "";
                }
                if (val.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                    val = val.substring(40);
                }
                if (((ElementDefinition.TypeRefComponent)t).hasTargetProfile()) {
                    val = val + "(" + this.canonicalList(((ElementDefinition.TypeRefComponent)t).getTargetProfile()) + ")";
                }
                if (((ElementDefinition.TypeRefComponent)t).hasProfile()) {
                    val = val + " {" + this.canonicalList(((ElementDefinition.TypeRefComponent)t).getProfile()) + "}";
                }
                if (((ElementDefinition.TypeRefComponent)t).hasAggregation()) {
                    val = val + " <<" + this.aggList(((ElementDefinition.TypeRefComponent)t).getAggregation()) + ">>";
                }
            } else if (o instanceof Coding) {
                t = (Coding)o;
                val = (((Coding)t).getSystem() == null ? "" : ((Coding)t).getSystem()) + (((Coding)t).getCode() == null ? "" : "#" + ((Coding)t).getCode()) + (((Coding)t).getDisplay() == null ? "" : " (" + ((Coding)t).getDisplay() + ")");
            } else if (o instanceof ElementDefinition.ElementDefinitionConstraintComponent) {
                c = (ElementDefinition.ElementDefinitionConstraintComponent)o;
                val = ((ElementDefinition.ElementDefinitionConstraintComponent)c).getKey() + ":" + ((ElementDefinition.ElementDefinitionConstraintComponent)c).getHuman() + " {" + ((ElementDefinition.ElementDefinitionConstraintComponent)c).getExpression() + "}";
            } else if (o instanceof ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent) {
                c = (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)o;
                val = ((ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)c).getType().toCode() + ":" + ((ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)c).getPath() + "}";
            } else {
                val = o.toString();
                val = val.substring(val.indexOf("[") + 1);
                val = val.substring(0, val.indexOf("]"));
            }
            s = s.append(val);
            if (i != 0) continue;
            s.append("\n");
        }
        return s.toString();
    }

    private String aggList(List<Enumeration<ElementDefinition.AggregationMode>> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Enumeration<ElementDefinition.AggregationMode> c : list) {
            b.append(((ElementDefinition.AggregationMode)((Object)c.getValue())).toCode());
        }
        return b.toString();
    }

    private String canonicalList(List<CanonicalType> list) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder("|");
        for (CanonicalType c : list) {
            String v = (String)c.getValue();
            if (v.startsWith("http://hl7.org/fhir/StructureDefinition/")) {
                v = v.substring(40);
            }
            b.append(v);
        }
        return b.toString();
    }

    private String renderType(Type value) throws Exception {
        if (value == null) {
            return "";
        }
        if (value.isPrimitive()) {
            return value.primitiveValue();
        }
        String s = null;
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        if (this.asXml) {
            this.xml.setOutputStyle(IParser.OutputStyle.PRETTY);
            this.xml.compose((OutputStream)bs, "", value);
            bs.close();
            s = bs.toString();
            s = s.substring(s.indexOf("\n") + 2);
        } else {
            this.json.setOutputStyle(IParser.OutputStyle.PRETTY);
            this.json.compose(bs, value, "");
            bs.close();
            s = bs.toString();
        }
        return s;
    }

    private int columnPixels(double columns) {
        double WIDTH_FACTOR = 256.0;
        double PADDING = 180.0;
        return (int)Math.floor(columns * WIDTH_FACTOR + PADDING);
    }

    public void dump() throws IOException {
        int i;
        for (i = 0; i < 34; ++i) {
            this.sheet.autoSizeColumn(i);
        }
        this.sheet.setColumnHidden(2, true);
        this.sheet.setColumnHidden(3, true);
        this.sheet.setColumnHidden(30, true);
        this.sheet.setColumnHidden(31, true);
        this.sheet.setColumnHidden(32, true);
        this.sheet.setColumnWidth(9, this.columnPixels(20.0));
        this.sheet.setColumnWidth(11, this.columnPixels(100.0));
        this.sheet.setColumnWidth(12, this.columnPixels(100.0));
        this.sheet.setColumnWidth(13, this.columnPixels(100.0));
        this.sheet.setColumnWidth(15, this.columnPixels(20.0));
        this.sheet.setColumnWidth(16, this.columnPixels(20.0));
        this.sheet.setColumnWidth(17, this.columnPixels(20.0));
        this.sheet.setColumnWidth(18, this.columnPixels(20.0));
        this.sheet.setColumnWidth(34, this.columnPixels(100.0));
        i = titles.length - 1;
        for (StructureDefinition.StructureDefinitionMappingComponent map : this.def.getMapping()) {
            this.sheet.setColumnWidth(++i, this.columnPixels(50.0));
            this.sheet.autoSizeColumn(i);
        }
        this.sheet.createFreezePane(2, 1);
        if (this.hideMustSupportFalse) {
            SheetConditionalFormatting sheetCF = this.sheet.getSheetConditionalFormatting();
            String address = "A2:AI" + Math.max(this.sheet.getLastRowNum(), 2);
            CellRangeAddress[] regions = new CellRangeAddress[]{CellRangeAddress.valueOf((String)address)};
            ConditionalFormattingRule rule1 = sheetCF.createConditionalFormattingRule("$G2<>\"Y\"");
            PatternFormatting fill1 = rule1.createPatternFormatting();
            fill1.setFillBackgroundColor(IndexedColors.GREY_25_PERCENT.index);
            fill1.setFillPattern((short)1);
            ConditionalFormattingRule rule2 = sheetCF.createConditionalFormattingRule("$Q2<>\"\"");
            FontFormatting font = rule2.createFontFormatting();
            font.setFontColorIndex(IndexedColors.GREY_25_PERCENT.index);
            font.setFontStyle(true, false);
            sheetCF.addConditionalFormatting(regions, rule1, rule2);
            this.sheet.setAutoFilter(new CellRangeAddress(0, this.sheet.getLastRowNum(), 0, titles.length + this.def.getMapping().size() - 1));
            XSSFSheet xSheet = (XSSFSheet)this.sheet;
            CTAutoFilter sheetFilter = xSheet.getCTWorksheet().getAutoFilter();
            CTFilterColumn filterColumn1 = sheetFilter.addNewFilterColumn();
            filterColumn1.setColId(6L);
            CTCustomFilters filters = filterColumn1.addNewCustomFilters();
            CTCustomFilter filter1 = filters.addNewCustomFilter();
            filter1.setOperator(STFilterOperator.NOT_EQUAL);
            filter1.setVal(" ");
            CTFilterColumn filterColumn2 = sheetFilter.addNewFilterColumn();
            filterColumn2.setColId(26L);
            CTFilters filters2 = filterColumn2.addNewFilters();
            filters2.setBlank(true);
            for (Row row : this.sheet) {
                if (row.getRowNum() <= 0 || row.getCell(6).getStringCellValue().equals("Y") && row.getCell(26).getStringCellValue().isEmpty()) continue;
                ((XSSFRow)row).getCTRow().setHidden(true);
            }
        }
        this.sheet.setActiveCell(new CellAddress(this.sheet.getRow(1).getCell(0)));
        this.wb.write(this.outStream);
        this.flush();
        this.close();
    }
}

