/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3QueryPriority {
    D,
    I,
    NULL;


    public static V3QueryPriority fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("D".equals(codeString)) {
            return D;
        }
        if ("I".equals(codeString)) {
            return I;
        }
        throw new FHIRException("Unknown V3QueryPriority code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case D: {
                return "D";
            }
            case I: {
                return "I";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-QueryPriority";
    }

    public String getDefinition() {
        switch (this) {
            case D: {
                return "Query response is deferred.";
            }
            case I: {
                return "Query response is immediate.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case D: {
                return "Deferred";
            }
            case I: {
                return "Immediate";
            }
        }
        return "?";
    }
}

