/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum V3GenderStatus {
    I,
    N,
    NULL;


    public static V3GenderStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("I".equals(codeString)) {
            return I;
        }
        if ("N".equals(codeString)) {
            return N;
        }
        throw new FHIRException("Unknown V3GenderStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case I: {
                return "I";
            }
            case N: {
                return "N";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/v3-GenderStatus";
    }

    public String getDefinition() {
        switch (this) {
            case I: {
                return "Reproductively intact";
            }
            case N: {
                return "Reproductively neutered";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case I: {
                return "Intact";
            }
            case N: {
                return "Neutered";
            }
        }
        return "?";
    }
}

