/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SubscriptionTag {
    QUEUED,
    DELIVERED,
    NULL;


    public static SubscriptionTag fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("queued".equals(codeString)) {
            return QUEUED;
        }
        if ("delivered".equals(codeString)) {
            return DELIVERED;
        }
        throw new FHIRException("Unknown SubscriptionTag code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case QUEUED: {
                return "queued";
            }
            case DELIVERED: {
                return "delivered";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/subscription-tag";
    }

    public String getDefinition() {
        switch (this) {
            case QUEUED: {
                return "The message has been queued for processing on a destination systems.";
            }
            case DELIVERED: {
                return "The message has been delivered to its intended recipient.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case QUEUED: {
                return "Queued";
            }
            case DELIVERED: {
                return "Delivered";
            }
        }
        return "?";
    }
}

