/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum SubscriberRelationship {
    CHILD,
    PARENT,
    SPOUSE,
    COMMON,
    OTHER,
    SELF,
    INJURED,
    NULL;


    public static SubscriberRelationship fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("child".equals(codeString)) {
            return CHILD;
        }
        if ("parent".equals(codeString)) {
            return PARENT;
        }
        if ("spouse".equals(codeString)) {
            return SPOUSE;
        }
        if ("common".equals(codeString)) {
            return COMMON;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        if ("self".equals(codeString)) {
            return SELF;
        }
        if ("injured".equals(codeString)) {
            return INJURED;
        }
        throw new FHIRException("Unknown SubscriberRelationship code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CHILD: {
                return "child";
            }
            case PARENT: {
                return "parent";
            }
            case SPOUSE: {
                return "spouse";
            }
            case COMMON: {
                return "common";
            }
            case OTHER: {
                return "other";
            }
            case SELF: {
                return "self";
            }
            case INJURED: {
                return "injured";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/subscriber-relationship";
    }

    public String getDefinition() {
        switch (this) {
            case CHILD: {
                return "The Beneficiary is a child of the Subscriber";
            }
            case PARENT: {
                return "The Beneficiary is a parent of the Subscriber";
            }
            case SPOUSE: {
                return "The Beneficiary is a spouse or equivalent of the Subscriber";
            }
            case COMMON: {
                return "The Beneficiary is a common law spouse or equivalent of the Subscriber";
            }
            case OTHER: {
                return "The Beneficiary has some other relationship the Subscriber";
            }
            case SELF: {
                return "The Beneficiary is the Subscriber";
            }
            case INJURED: {
                return "The Beneficiary is covered under insurance of the subscriber due to an injury.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CHILD: {
                return "Child";
            }
            case PARENT: {
                return "Parent";
            }
            case SPOUSE: {
                return "Spouse";
            }
            case COMMON: {
                return "Common Law Spouse";
            }
            case OTHER: {
                return "Other";
            }
            case SELF: {
                return "Self";
            }
            case INJURED: {
                return "Injured Party";
            }
        }
        return "?";
    }
}

