/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.StandardsStatus;

public class StandardsStatusEnumFactory
implements EnumFactory<StandardsStatus> {
    @Override
    public StandardsStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return StandardsStatus.DRAFT;
        }
        if ("normative".equals(codeString)) {
            return StandardsStatus.NORMATIVE;
        }
        if ("trial-use".equals(codeString)) {
            return StandardsStatus.TRIALUSE;
        }
        if ("informative".equals(codeString)) {
            return StandardsStatus.INFORMATIVE;
        }
        if ("deprecated".equals(codeString)) {
            return StandardsStatus.DEPRECATED;
        }
        if ("external".equals(codeString)) {
            return StandardsStatus.EXTERNAL;
        }
        throw new IllegalArgumentException("Unknown StandardsStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(StandardsStatus code) {
        if (code == StandardsStatus.DRAFT) {
            return "draft";
        }
        if (code == StandardsStatus.NORMATIVE) {
            return "normative";
        }
        if (code == StandardsStatus.TRIALUSE) {
            return "trial-use";
        }
        if (code == StandardsStatus.INFORMATIVE) {
            return "informative";
        }
        if (code == StandardsStatus.DEPRECATED) {
            return "deprecated";
        }
        if (code == StandardsStatus.EXTERNAL) {
            return "external";
        }
        return "?";
    }

    @Override
    public String toSystem(StandardsStatus code) {
        return code.getSystem();
    }
}

