/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ResearchStudyObjectiveType {
    PRIMARY,
    SECONDARY,
    EXPLORATORY,
    NULL;


    public static ResearchStudyObjectiveType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("primary".equals(codeString)) {
            return PRIMARY;
        }
        if ("secondary".equals(codeString)) {
            return SECONDARY;
        }
        if ("exploratory".equals(codeString)) {
            return EXPLORATORY;
        }
        throw new FHIRException("Unknown ResearchStudyObjectiveType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRIMARY: {
                return "primary";
            }
            case SECONDARY: {
                return "secondary";
            }
            case EXPLORATORY: {
                return "exploratory";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/research-study-objective-type";
    }

    public String getDefinition() {
        switch (this) {
            case PRIMARY: {
                return "The main question to be answered, and the one that drives any statistical planning for the study\u2014e.g., calculation of the sample size to provide the appropriate power for statistical testing.";
            }
            case SECONDARY: {
                return "Question to be answered in the study that is of lesser importance than the primary objective.";
            }
            case EXPLORATORY: {
                return "Exploratory questions to be answered in the study.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRIMARY: {
                return "Primary";
            }
            case SECONDARY: {
                return "Secondary";
            }
            case EXPLORATORY: {
                return "Exploratory";
            }
        }
        return "?";
    }
}

