/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.PlanDefinitionType;

public class PlanDefinitionTypeEnumFactory
implements EnumFactory<PlanDefinitionType> {
    @Override
    public PlanDefinitionType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("order-set".equals(codeString)) {
            return PlanDefinitionType.ORDERSET;
        }
        if ("clinical-protocol".equals(codeString)) {
            return PlanDefinitionType.CLINICALPROTOCOL;
        }
        if ("eca-rule".equals(codeString)) {
            return PlanDefinitionType.ECARULE;
        }
        if ("workflow-definition".equals(codeString)) {
            return PlanDefinitionType.WORKFLOWDEFINITION;
        }
        throw new IllegalArgumentException("Unknown PlanDefinitionType code '" + codeString + "'");
    }

    @Override
    public String toCode(PlanDefinitionType code) {
        if (code == PlanDefinitionType.ORDERSET) {
            return "order-set";
        }
        if (code == PlanDefinitionType.CLINICALPROTOCOL) {
            return "clinical-protocol";
        }
        if (code == PlanDefinitionType.ECARULE) {
            return "eca-rule";
        }
        if (code == PlanDefinitionType.WORKFLOWDEFINITION) {
            return "workflow-definition";
        }
        return "?";
    }

    @Override
    public String toSystem(PlanDefinitionType code) {
        return code.getSystem();
    }
}

