/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MessageTransport {
    HTTP,
    FTP,
    MLLP,
    NULL;


    public static MessageTransport fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("http".equals(codeString)) {
            return HTTP;
        }
        if ("ftp".equals(codeString)) {
            return FTP;
        }
        if ("mllp".equals(codeString)) {
            return MLLP;
        }
        throw new FHIRException("Unknown MessageTransport code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case HTTP: {
                return "http";
            }
            case FTP: {
                return "ftp";
            }
            case MLLP: {
                return "mllp";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/message-transport";
    }

    public String getDefinition() {
        switch (this) {
            case HTTP: {
                return "The application sends or receives messages using HTTP POST (may be over http: or https:).";
            }
            case FTP: {
                return "The application sends or receives messages using File Transfer Protocol.";
            }
            case MLLP: {
                return "The application sends or receives messages using HL7's Minimal Lower Level Protocol.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case HTTP: {
                return "HTTP";
            }
            case FTP: {
                return "FTP";
            }
            case MLLP: {
                return "MLLP";
            }
        }
        return "?";
    }
}

