/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MeasureReportStatus {
    COMPLETE,
    PENDING,
    ERROR,
    NULL;


    public static MeasureReportStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("complete".equals(codeString)) {
            return COMPLETE;
        }
        if ("pending".equals(codeString)) {
            return PENDING;
        }
        if ("error".equals(codeString)) {
            return ERROR;
        }
        throw new FHIRException("Unknown MeasureReportStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case COMPLETE: {
                return "complete";
            }
            case PENDING: {
                return "pending";
            }
            case ERROR: {
                return "error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/measure-report-status";
    }

    public String getDefinition() {
        switch (this) {
            case COMPLETE: {
                return "The report is complete and ready for use.";
            }
            case PENDING: {
                return "The report is currently being generated.";
            }
            case ERROR: {
                return "An error occurred attempting to generate the report.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case COMPLETE: {
                return "Complete";
            }
            case PENDING: {
                return "Pending";
            }
            case ERROR: {
                return "Error";
            }
        }
        return "?";
    }
}

