/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.MapSourceListMode;

public class MapSourceListModeEnumFactory
implements EnumFactory<MapSourceListMode> {
    @Override
    public MapSourceListMode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("first".equals(codeString)) {
            return MapSourceListMode.FIRST;
        }
        if ("not_first".equals(codeString)) {
            return MapSourceListMode.NOTFIRST;
        }
        if ("last".equals(codeString)) {
            return MapSourceListMode.LAST;
        }
        if ("not_last".equals(codeString)) {
            return MapSourceListMode.NOTLAST;
        }
        if ("only_one".equals(codeString)) {
            return MapSourceListMode.ONLYONE;
        }
        throw new IllegalArgumentException("Unknown MapSourceListMode code '" + codeString + "'");
    }

    @Override
    public String toCode(MapSourceListMode code) {
        if (code == MapSourceListMode.FIRST) {
            return "first";
        }
        if (code == MapSourceListMode.NOTFIRST) {
            return "not_first";
        }
        if (code == MapSourceListMode.LAST) {
            return "last";
        }
        if (code == MapSourceListMode.NOTLAST) {
            return "not_last";
        }
        if (code == MapSourceListMode.ONLYONE) {
            return "only_one";
        }
        return "?";
    }

    @Override
    public String toSystem(MapSourceListMode code) {
        return code.getSystem();
    }
}

