/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.LibraryType;

public class LibraryTypeEnumFactory
implements EnumFactory<LibraryType> {
    @Override
    public LibraryType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("logic-library".equals(codeString)) {
            return LibraryType.LOGICLIBRARY;
        }
        if ("model-definition".equals(codeString)) {
            return LibraryType.MODELDEFINITION;
        }
        if ("asset-collection".equals(codeString)) {
            return LibraryType.ASSETCOLLECTION;
        }
        if ("module-definition".equals(codeString)) {
            return LibraryType.MODULEDEFINITION;
        }
        throw new IllegalArgumentException("Unknown LibraryType code '" + codeString + "'");
    }

    @Override
    public String toCode(LibraryType code) {
        if (code == LibraryType.LOGICLIBRARY) {
            return "logic-library";
        }
        if (code == LibraryType.MODELDEFINITION) {
            return "model-definition";
        }
        if (code == LibraryType.ASSETCOLLECTION) {
            return "asset-collection";
        }
        if (code == LibraryType.MODULEDEFINITION) {
            return "module-definition";
        }
        return "?";
    }

    @Override
    public String toSystem(LibraryType code) {
        return code.getSystem();
    }
}

