/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum LanguagePreferenceType {
    VERBAL,
    WRITTEN,
    NULL;


    public static LanguagePreferenceType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("verbal".equals(codeString)) {
            return VERBAL;
        }
        if ("written".equals(codeString)) {
            return WRITTEN;
        }
        throw new FHIRException("Unknown LanguagePreferenceType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case VERBAL: {
                return "verbal";
            }
            case WRITTEN: {
                return "written";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/language-preference-type";
    }

    public String getDefinition() {
        switch (this) {
            case VERBAL: {
                return "The patient prefers to verbally communicate with the associated language.";
            }
            case WRITTEN: {
                return "The patient prefers to communicate in writing with the associated language.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case VERBAL: {
                return "verbal";
            }
            case WRITTEN: {
                return "written";
            }
        }
        return "?";
    }
}

