/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExtensionContextType {
    FHIRPATH,
    ELEMENT,
    EXTENSION,
    NULL;


    public static ExtensionContextType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("fhirpath".equals(codeString)) {
            return FHIRPATH;
        }
        if ("element".equals(codeString)) {
            return ELEMENT;
        }
        if ("extension".equals(codeString)) {
            return EXTENSION;
        }
        throw new FHIRException("Unknown ExtensionContextType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FHIRPATH: {
                return "fhirpath";
            }
            case ELEMENT: {
                return "element";
            }
            case EXTENSION: {
                return "extension";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/extension-context-type";
    }

    public String getDefinition() {
        switch (this) {
            case FHIRPATH: {
                return "The context is all elements that match the FHIRPath query found in the expression.";
            }
            case ELEMENT: {
                return "The context is any element that has an ElementDefinition.id that matches that found in the expression. This includes ElementDefinition Ids that have slicing identifiers. The full path for the element is [url]#[elementid]. If there is no #, the Element id is one defined in the base specification.";
            }
            case EXTENSION: {
                return "The context is a particular extension from a particular StructureDefinition, and the expression is just a uri that identifies the extension.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FHIRPATH: {
                return "FHIRPath";
            }
            case ELEMENT: {
                return "Element ID";
            }
            case EXTENSION: {
                return "Extension URL";
            }
        }
        return "?";
    }
}

