/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ExRevenueCenter {
    _0010,
    _0011,
    _1001,
    NULL;


    public static ExRevenueCenter fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("0010".equals(codeString)) {
            return _0010;
        }
        if ("0011".equals(codeString)) {
            return _0011;
        }
        if ("1001".equals(codeString)) {
            return _1001;
        }
        throw new FHIRException("Unknown ExRevenueCenter code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _0010: {
                return "0010";
            }
            case _0011: {
                return "0011";
            }
            case _1001: {
                return "1001";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/ex-revenue-center";
    }

    public String getDefinition() {
        switch (this) {
            case _0010: {
                return "Vision Office or Clinic.";
            }
            case _0011: {
                return "Dental Office or Clinic.";
            }
            case _1001: {
                return "Emergency Department.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _0010: {
                return "Vision Clinic";
            }
            case _0011: {
                return "Dental Clinic";
            }
            case _1001: {
                return "Emergency";
            }
        }
        return "?";
    }
}

