/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.DeviceNametype;

public class DeviceNametypeEnumFactory
implements EnumFactory<DeviceNametype> {
    @Override
    public DeviceNametype fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("udi-label-name".equals(codeString)) {
            return DeviceNametype.UDILABELNAME;
        }
        if ("user-friendly-name".equals(codeString)) {
            return DeviceNametype.USERFRIENDLYNAME;
        }
        if ("patient-reported-name".equals(codeString)) {
            return DeviceNametype.PATIENTREPORTEDNAME;
        }
        if ("manufacturer-name".equals(codeString)) {
            return DeviceNametype.MANUFACTURERNAME;
        }
        if ("model-name".equals(codeString)) {
            return DeviceNametype.MODELNAME;
        }
        if ("other".equals(codeString)) {
            return DeviceNametype.OTHER;
        }
        throw new IllegalArgumentException("Unknown DeviceNametype code '" + codeString + "'");
    }

    @Override
    public String toCode(DeviceNametype code) {
        if (code == DeviceNametype.UDILABELNAME) {
            return "udi-label-name";
        }
        if (code == DeviceNametype.USERFRIENDLYNAME) {
            return "user-friendly-name";
        }
        if (code == DeviceNametype.PATIENTREPORTEDNAME) {
            return "patient-reported-name";
        }
        if (code == DeviceNametype.MANUFACTURERNAME) {
            return "manufacturer-name";
        }
        if (code == DeviceNametype.MODELNAME) {
            return "model-name";
        }
        if (code == DeviceNametype.OTHER) {
            return "other";
        }
        return "?";
    }

    @Override
    public String toSystem(DeviceNametype code) {
        return code.getSystem();
    }
}

