/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContactPointUse {
    HOME,
    WORK,
    TEMP,
    OLD,
    MOBILE,
    NULL;


    public static ContactPointUse fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("home".equals(codeString)) {
            return HOME;
        }
        if ("work".equals(codeString)) {
            return WORK;
        }
        if ("temp".equals(codeString)) {
            return TEMP;
        }
        if ("old".equals(codeString)) {
            return OLD;
        }
        if ("mobile".equals(codeString)) {
            return MOBILE;
        }
        throw new FHIRException("Unknown ContactPointUse code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case HOME: {
                return "home";
            }
            case WORK: {
                return "work";
            }
            case TEMP: {
                return "temp";
            }
            case OLD: {
                return "old";
            }
            case MOBILE: {
                return "mobile";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contact-point-use";
    }

    public String getDefinition() {
        switch (this) {
            case HOME: {
                return "A communication contact point at a home; attempted contacts for business purposes might intrude privacy and chances are one will contact family or other household members instead of the person one wishes to call. Typically used with urgent cases, or if no other contacts are available.";
            }
            case WORK: {
                return "An office contact point. First choice for business related contacts during business hours.";
            }
            case TEMP: {
                return "A temporary contact point. The period can provide more detailed information.";
            }
            case OLD: {
                return "This contact point is no longer in use (or was never correct, but retained for records).";
            }
            case MOBILE: {
                return "A telecommunication device that moves and stays with its owner. May have characteristics of all other use codes, suitable for urgent matters, not the first choice for routine business.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case HOME: {
                return "Home";
            }
            case WORK: {
                return "Work";
            }
            case TEMP: {
                return "Temp";
            }
            case OLD: {
                return "Old";
            }
            case MOBILE: {
                return "Mobile";
            }
        }
        return "?";
    }
}

