/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CatalogentryRelationType {
    TRIGGERS,
    ISREPLACEDBY,
    EXCLUDES,
    INCLUDES,
    NULL;


    public static CatalogentryRelationType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("triggers".equals(codeString)) {
            return TRIGGERS;
        }
        if ("is-replaced-by".equals(codeString)) {
            return ISREPLACEDBY;
        }
        if ("excludes".equals(codeString)) {
            return EXCLUDES;
        }
        if ("includes".equals(codeString)) {
            return INCLUDES;
        }
        throw new FHIRException("Unknown CatalogentryRelationType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case TRIGGERS: {
                return "triggers";
            }
            case ISREPLACEDBY: {
                return "is-replaced-by";
            }
            case EXCLUDES: {
                return "excludes";
            }
            case INCLUDES: {
                return "includes";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/catalogentry-relation-type";
    }

    public String getDefinition() {
        switch (this) {
            case TRIGGERS: {
                return "Depending on the context, the item of the related catalog entry may be added by the performer.";
            }
            case ISREPLACEDBY: {
                return "the related catalog entry supersedes this one when it is not active.";
            }
            case EXCLUDES: {
                return "The related catalog entry is excluded by this one.";
            }
            case INCLUDES: {
                return "The item of the related catalog entry  will be part of the orders containing the current item.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case TRIGGERS: {
                return "Triggers";
            }
            case ISREPLACEDBY: {
                return "Is replaced by";
            }
            case EXCLUDES: {
                return "Excludes";
            }
            case INCLUDES: {
                return "Includes";
            }
        }
        return "?";
    }
}

