/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Topic", profile="http://hl7.org/fhir/StructureDefinition/Topic")
public class Topic
extends DomainResource {
    @Child(name="url", type={UriType.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical canonical URL to reference this Topic (globally unique)", formalDefinition="An absolute URL that is used to identify this Topic when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this Topic is (or will be) published. The URL SHOULD include the major version of the Topic. For more information see [Technical and Business Versions](resource.html#versions).")
    protected UriType url;
    @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Business Identifier for Topic", formalDefinition="Business identifiers assigned to this Topic by the performer and/or other systems.  These identifiers remain constant as the resource is updated and propagates from server to server.")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the Topic", formalDefinition="The identifier that is used to identify this version of the Topic when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Topic author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.")
    protected StringType version;
    @Child(name="title", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this Topic (Human friendly)", formalDefinition="A short, descriptive, user-friendly title for the Topic, for example, \"admission\".")
    protected StringType title;
    @Child(name="derivedFromCanonical", type={CanonicalType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Based on FHIR protocol or definition", formalDefinition="The canonical URL pointing to another FHIR-defined Topic that is adhered to in whole or in part by this Topic.")
    protected List<CanonicalType> derivedFromCanonical;
    @Child(name="derivedFromUri", type={UriType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Based on external protocol or definition", formalDefinition="The URL pointing to an externally-defined subscription topic or other definition that is adhered to in whole or in part by this definition.")
    protected List<UriType> derivedFromUri;
    @Child(name="status", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The current state of the Topic.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=7, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="A flag to indicate that this Topic is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date status first applied", formalDefinition="For draft definitions, indicates the date of initial creation.  For active definitions, represents the date of activation.  For withdrawn definitions, indicates the date of withdrawal.")
    protected DateTimeType date;
    @Child(name="publisher", type={Practitioner.class, PractitionerRole.class, Organization.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The name of the individual or organization that published the Topic", formalDefinition="Helps establish the \"authority/credibility\" of the Topic.  May also allow for contact.")
    protected Reference publisher;
    @Child(name="contact", type={ContactDetail.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=11, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Natural language description of the Topic", formalDefinition="A free text natural language description of the Topic from the consumer's perspective.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Content intends to support these contexts", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for Topic (if applicable)", formalDefinition="A jurisdiction in which the Topic is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this Topic is defined", formalDefinition="Explains why this Topic is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the Topic and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the Topic.")
    protected MarkdownType copyright;
    @Child(name="approvalDate", type={DateType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When Topic approved by publisher", formalDefinition="The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.")
    protected DateType approvalDate;
    @Child(name="lastReviewDate", type={DateType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Last review date for the Topic", formalDefinition="The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.")
    protected DateType lastReviewDate;
    @Child(name="effectivePeriod", type={Period.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The effective date range for the Topic", formalDefinition="The period during which the Topic content was or is planned to be effective.")
    protected Period effectivePeriod;
    @Child(name="resourceTrigger", type={}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Criteria for including a resource update in the topic", formalDefinition="The criteria for including updates to a nominated resource in the topic.  Thie criteria may be just a human readable description and/or a full FHIR search string or FHIRPath expression.")
    protected TopicResourceTriggerComponent resourceTrigger;
    @Child(name="canFilterBy", type={}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Properties by which the topic can be filtered", formalDefinition="List of properties by which messages on the topic can be filtered.")
    protected List<TopicCanFilterByComponent> canFilterBy;
    private static final long serialVersionUID = -1683916811L;
    @SearchParamDefinition(name="date", path="Topic.date", description="Date status first applied", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Topic.identifier", description="Business Identifier for Topic", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="publisher", path="Topic.publisher", description="The name of the individual or organization that published the Topic", type="reference", target={Organization.class, Practitioner.class, PractitionerRole.class})
    public static final String SP_PUBLISHER = "publisher";
    public static final ReferenceClientParam PUBLISHER = new ReferenceClientParam("publisher");
    public static final Include INCLUDE_PUBLISHER = new Include("Topic:publisher").toLocked();
    @SearchParamDefinition(name="resource-type", path="Topic.resourceTrigger.resourceType", description="Candidate types for this topic", type="token")
    public static final String SP_RESOURCE_TYPE = "resource-type";
    public static final TokenClientParam RESOURCE_TYPE = new TokenClientParam("resource-type");
    @SearchParamDefinition(name="title", path="Topic.title", description="Name for this Topic (Human friendly)", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="version", path="Topic.version", description="Business version of the Topic", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="Topic.url", description="Logical canonical URL to reference this Topic (globally unique)", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="status", path="Topic.status", description="draft | active | retired | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="trigger-description", path="Topic.resourceTrigger.description", description="Text representation of the trigger", type="string")
    public static final String SP_TRIGGER_DESCRIPTION = "trigger-description";
    public static final StringClientParam TRIGGER_DESCRIPTION = new StringClientParam("trigger-description");

    public Topic() {
    }

    public Topic(Enumeration<Enumerations.PublicationStatus> status) {
        this.status = status;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public Topic setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public Topic setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Topic setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Topic addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public Topic setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public Topic setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    public Topic setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    public Topic setTitle(String value) {
        if (Utilities.noString((String)value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    public List<CanonicalType> getDerivedFromCanonical() {
        if (this.derivedFromCanonical == null) {
            this.derivedFromCanonical = new ArrayList<CanonicalType>();
        }
        return this.derivedFromCanonical;
    }

    public Topic setDerivedFromCanonical(List<CanonicalType> theDerivedFromCanonical) {
        this.derivedFromCanonical = theDerivedFromCanonical;
        return this;
    }

    public boolean hasDerivedFromCanonical() {
        if (this.derivedFromCanonical == null) {
            return false;
        }
        for (CanonicalType item : this.derivedFromCanonical) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CanonicalType addDerivedFromCanonicalElement() {
        CanonicalType t = new CanonicalType();
        if (this.derivedFromCanonical == null) {
            this.derivedFromCanonical = new ArrayList<CanonicalType>();
        }
        this.derivedFromCanonical.add(t);
        return t;
    }

    public Topic addDerivedFromCanonical(String value) {
        CanonicalType t = new CanonicalType();
        t.setValue(value);
        if (this.derivedFromCanonical == null) {
            this.derivedFromCanonical = new ArrayList<CanonicalType>();
        }
        this.derivedFromCanonical.add(t);
        return this;
    }

    public boolean hasDerivedFromCanonical(String value) {
        if (this.derivedFromCanonical == null) {
            return false;
        }
        for (CanonicalType v : this.derivedFromCanonical) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<UriType> getDerivedFromUri() {
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        return this.derivedFromUri;
    }

    public Topic setDerivedFromUri(List<UriType> theDerivedFromUri) {
        this.derivedFromUri = theDerivedFromUri;
        return this;
    }

    public boolean hasDerivedFromUri() {
        if (this.derivedFromUri == null) {
            return false;
        }
        for (UriType item : this.derivedFromUri) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addDerivedFromUriElement() {
        UriType t = new UriType();
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        this.derivedFromUri.add(t);
        return t;
    }

    public Topic addDerivedFromUri(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.derivedFromUri == null) {
            this.derivedFromUri = new ArrayList<UriType>();
        }
        this.derivedFromUri.add(t);
        return this;
    }

    public boolean hasDerivedFromUri(String value) {
        if (this.derivedFromUri == null) {
            return false;
        }
        for (UriType v : this.derivedFromUri) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Topic setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    public Topic setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    public Topic setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    public Topic setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public Topic setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public Topic setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getPublisher() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new Reference();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public Topic setPublisher(Reference value) {
        this.publisher = value;
        return this;
    }

    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    public Topic setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    public Topic addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Topic setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Topic setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    public Topic setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    public Topic addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    public Topic setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    public Topic addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public Topic setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public Topic setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public Topic setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public Topic setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public DateType getApprovalDateElement() {
        if (this.approvalDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.approvalDate");
            }
            if (Configuration.doAutoCreate()) {
                this.approvalDate = new DateType();
            }
        }
        return this.approvalDate;
    }

    public boolean hasApprovalDateElement() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public boolean hasApprovalDate() {
        return this.approvalDate != null && !this.approvalDate.isEmpty();
    }

    public Topic setApprovalDateElement(DateType value) {
        this.approvalDate = value;
        return this;
    }

    public Date getApprovalDate() {
        return this.approvalDate == null ? null : (Date)this.approvalDate.getValue();
    }

    public Topic setApprovalDate(Date value) {
        if (value == null) {
            this.approvalDate = null;
        } else {
            if (this.approvalDate == null) {
                this.approvalDate = new DateType();
            }
            this.approvalDate.setValue(value);
        }
        return this;
    }

    public DateType getLastReviewDateElement() {
        if (this.lastReviewDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.lastReviewDate");
            }
            if (Configuration.doAutoCreate()) {
                this.lastReviewDate = new DateType();
            }
        }
        return this.lastReviewDate;
    }

    public boolean hasLastReviewDateElement() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public boolean hasLastReviewDate() {
        return this.lastReviewDate != null && !this.lastReviewDate.isEmpty();
    }

    public Topic setLastReviewDateElement(DateType value) {
        this.lastReviewDate = value;
        return this;
    }

    public Date getLastReviewDate() {
        return this.lastReviewDate == null ? null : (Date)this.lastReviewDate.getValue();
    }

    public Topic setLastReviewDate(Date value) {
        if (value == null) {
            this.lastReviewDate = null;
        } else {
            if (this.lastReviewDate == null) {
                this.lastReviewDate = new DateType();
            }
            this.lastReviewDate.setValue(value);
        }
        return this;
    }

    public Period getEffectivePeriod() {
        if (this.effectivePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.effectivePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.effectivePeriod = new Period();
            }
        }
        return this.effectivePeriod;
    }

    public boolean hasEffectivePeriod() {
        return this.effectivePeriod != null && !this.effectivePeriod.isEmpty();
    }

    public Topic setEffectivePeriod(Period value) {
        this.effectivePeriod = value;
        return this;
    }

    public TopicResourceTriggerComponent getResourceTrigger() {
        if (this.resourceTrigger == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Topic.resourceTrigger");
            }
            if (Configuration.doAutoCreate()) {
                this.resourceTrigger = new TopicResourceTriggerComponent();
            }
        }
        return this.resourceTrigger;
    }

    public boolean hasResourceTrigger() {
        return this.resourceTrigger != null && !this.resourceTrigger.isEmpty();
    }

    public Topic setResourceTrigger(TopicResourceTriggerComponent value) {
        this.resourceTrigger = value;
        return this;
    }

    public List<TopicCanFilterByComponent> getCanFilterBy() {
        if (this.canFilterBy == null) {
            this.canFilterBy = new ArrayList<TopicCanFilterByComponent>();
        }
        return this.canFilterBy;
    }

    public Topic setCanFilterBy(List<TopicCanFilterByComponent> theCanFilterBy) {
        this.canFilterBy = theCanFilterBy;
        return this;
    }

    public boolean hasCanFilterBy() {
        if (this.canFilterBy == null) {
            return false;
        }
        for (TopicCanFilterByComponent item : this.canFilterBy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TopicCanFilterByComponent addCanFilterBy() {
        TopicCanFilterByComponent t = new TopicCanFilterByComponent();
        if (this.canFilterBy == null) {
            this.canFilterBy = new ArrayList<TopicCanFilterByComponent>();
        }
        this.canFilterBy.add(t);
        return t;
    }

    public Topic addCanFilterBy(TopicCanFilterByComponent t) {
        if (t == null) {
            return this;
        }
        if (this.canFilterBy == null) {
            this.canFilterBy = new ArrayList<TopicCanFilterByComponent>();
        }
        this.canFilterBy.add(t);
        return this;
    }

    public TopicCanFilterByComponent getCanFilterByFirstRep() {
        if (this.getCanFilterBy().isEmpty()) {
            this.addCanFilterBy();
        }
        return this.getCanFilterBy().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URL that is used to identify this Topic when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this Topic is (or will be) published. The URL SHOULD include the major version of the Topic. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this Topic by the performer and/or other systems.  These identifiers remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the Topic when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Topic author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.", 0, 1, this.version));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the Topic, for example, \"admission\".", 0, 1, this.title));
        children.add(new Property("derivedFromCanonical", "canonical(Topic)", "The canonical URL pointing to another FHIR-defined Topic that is adhered to in whole or in part by this Topic.", 0, Integer.MAX_VALUE, this.derivedFromCanonical));
        children.add(new Property("derivedFromUri", "uri", "The URL pointing to an externally-defined subscription topic or other definition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromUri));
        children.add(new Property(SP_STATUS, "code", "The current state of the Topic.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A flag to indicate that this Topic is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "For draft definitions, indicates the date of initial creation.  For active definitions, represents the date of activation.  For withdrawn definitions, indicates the date of withdrawal.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "Reference(Practitioner|PractitionerRole|Organization)", "Helps establish the \"authority/credibility\" of the Topic.  May also allow for contact.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property("description", "markdown", "A free text natural language description of the Topic from the consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property("jurisdiction", "CodeableConcept", "A jurisdiction in which the Topic is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explains why this Topic is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the Topic and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the Topic.", 0, 1, this.copyright));
        children.add(new Property("approvalDate", SP_DATE, "The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate));
        children.add(new Property("lastReviewDate", SP_DATE, "The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.", 0, 1, this.lastReviewDate));
        children.add(new Property("effectivePeriod", "Period", "The period during which the Topic content was or is planned to be effective.", 0, 1, this.effectivePeriod));
        children.add(new Property("resourceTrigger", "", "The criteria for including updates to a nominated resource in the topic.  Thie criteria may be just a human readable description and/or a full FHIR search string or FHIRPath expression.", 0, 1, this.resourceTrigger));
        children.add(new Property("canFilterBy", "", "List of properties by which messages on the topic can be filtered.", 0, Integer.MAX_VALUE, this.canFilterBy));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URL that is used to identify this Topic when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this Topic is (or will be) published. The URL SHOULD include the major version of the Topic. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Business identifiers assigned to this Topic by the performer and/or other systems.  These identifiers remain constant as the resource is updated and propagates from server to server.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the Topic when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the Topic author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions are orderable.", 0, 1, this.version);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the Topic, for example, \"admission\".", 0, 1, this.title);
            }
            case -978133683: {
                return new Property("derivedFromCanonical", "canonical(Topic)", "The canonical URL pointing to another FHIR-defined Topic that is adhered to in whole or in part by this Topic.", 0, Integer.MAX_VALUE, this.derivedFromCanonical);
            }
            case -1076333435: {
                return new Property("derivedFromUri", "uri", "The URL pointing to an externally-defined subscription topic or other definition that is adhered to in whole or in part by this definition.", 0, Integer.MAX_VALUE, this.derivedFromUri);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The current state of the Topic.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A flag to indicate that this Topic is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "For draft definitions, indicates the date of initial creation.  For active definitions, represents the date of activation.  For withdrawn definitions, indicates the date of withdrawal.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "Reference(Practitioner|PractitionerRole|Organization)", "Helps establish the \"authority/credibility\" of the Topic.  May also allow for contact.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property("description", "markdown", "A free text natural language description of the Topic from the consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching of code system definitions.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property("jurisdiction", "CodeableConcept", "A jurisdiction in which the Topic is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explains why this Topic is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the Topic and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the Topic.", 0, 1, this.copyright);
            }
            case 223539345: {
                return new Property("approvalDate", SP_DATE, "The date on which the asset content was approved by the publisher. Approval happens once when the content is officially approved for usage.", 0, 1, this.approvalDate);
            }
            case -1687512484: {
                return new Property("lastReviewDate", SP_DATE, "The date on which the asset content was last reviewed. Review happens periodically after that, but doesn't change the original approval date.", 0, 1, this.lastReviewDate);
            }
            case -403934648: {
                return new Property("effectivePeriod", "Period", "The period during which the Topic content was or is planned to be effective.", 0, 1, this.effectivePeriod);
            }
            case -424927798: {
                return new Property("resourceTrigger", "", "The criteria for including updates to a nominated resource in the topic.  Thie criteria may be just a human readable description and/or a full FHIR search string or FHIRPath expression.", 0, 1, this.resourceTrigger);
            }
            case -1299519009: {
                return new Property("canFilterBy", "", "List of properties by which messages on the topic can be filtered.", 0, Integer.MAX_VALUE, this.canFilterBy);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.title;
                }
                return baseArray;
            }
            case -978133683: {
                return this.derivedFromCanonical == null ? new Base[]{} : this.derivedFromCanonical.toArray(new Base[this.derivedFromCanonical.size()]);
            }
            case -1076333435: {
                return this.derivedFromUri == null ? new Base[]{} : this.derivedFromUri.toArray(new Base[this.derivedFromUri.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.copyright;
                }
                return baseArray;
            }
            case 223539345: {
                Base[] baseArray;
                if (this.approvalDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.approvalDate;
                }
                return baseArray;
            }
            case -1687512484: {
                Base[] baseArray;
                if (this.lastReviewDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.lastReviewDate;
                }
                return baseArray;
            }
            case -403934648: {
                Base[] baseArray;
                if (this.effectivePeriod == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.effectivePeriod;
                }
                return baseArray;
            }
            case -424927798: {
                Base[] baseArray;
                if (this.resourceTrigger == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.resourceTrigger;
                }
                return baseArray;
            }
            case -1299519009: {
                return this.canFilterBy == null ? new Base[]{} : this.canFilterBy.toArray(new Base[this.canFilterBy.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -978133683: {
                this.getDerivedFromCanonical().add(this.castToCanonical(value));
                return value;
            }
            case -1076333435: {
                this.getDerivedFromUri().add(this.castToUri(value));
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToReference(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 223539345: {
                this.approvalDate = this.castToDate(value);
                return value;
            }
            case -1687512484: {
                this.lastReviewDate = this.castToDate(value);
                return value;
            }
            case -403934648: {
                this.effectivePeriod = this.castToPeriod(value);
                return value;
            }
            case -424927798: {
                this.resourceTrigger = (TopicResourceTriggerComponent)((Object)value);
                return value;
            }
            case -1299519009: {
                this.getCanFilterBy().add((TopicCanFilterByComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals("derivedFromCanonical")) {
            this.getDerivedFromCanonical().add(this.castToCanonical(value));
        } else if (name.equals("derivedFromUri")) {
            this.getDerivedFromUri().add(this.castToUri(value));
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals("description")) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals("jurisdiction")) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("approvalDate")) {
            this.approvalDate = this.castToDate(value);
        } else if (name.equals("lastReviewDate")) {
            this.lastReviewDate = this.castToDate(value);
        } else if (name.equals("effectivePeriod")) {
            this.effectivePeriod = this.castToPeriod(value);
        } else if (name.equals("resourceTrigger")) {
            this.resourceTrigger = (TopicResourceTriggerComponent)((Object)value);
        } else if (name.equals("canFilterBy")) {
            this.getCanFilterBy().add((TopicCanFilterByComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -978133683: {
                return this.addDerivedFromCanonicalElement();
            }
            case -1076333435: {
                return this.addDerivedFromUriElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisher();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 223539345: {
                return this.getApprovalDateElement();
            }
            case -1687512484: {
                return this.getLastReviewDateElement();
            }
            case -403934648: {
                return this.getEffectivePeriod();
            }
            case -424927798: {
                return this.getResourceTrigger();
            }
            case -1299519009: {
                return this.addCanFilterBy();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -978133683: {
                return new String[]{"canonical"};
            }
            case -1076333435: {
                return new String[]{"uri"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"Reference"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 223539345: {
                return new String[]{SP_DATE};
            }
            case -1687512484: {
                return new String[]{SP_DATE};
            }
            case -403934648: {
                return new String[]{"Period"};
            }
            case -424927798: {
                return new String[0];
            }
            case -1299519009: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.version");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.title");
        }
        if (name.equals("derivedFromCanonical")) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.derivedFromCanonical");
        }
        if (name.equals("derivedFromUri")) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.derivedFromUri");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            this.publisher = new Reference();
            return this.publisher;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals("jurisdiction")) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.copyright");
        }
        if (name.equals("approvalDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.approvalDate");
        }
        if (name.equals("lastReviewDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type Topic.lastReviewDate");
        }
        if (name.equals("effectivePeriod")) {
            this.effectivePeriod = new Period();
            return this.effectivePeriod;
        }
        if (name.equals("resourceTrigger")) {
            this.resourceTrigger = new TopicResourceTriggerComponent();
            return this.resourceTrigger;
        }
        if (name.equals("canFilterBy")) {
            return this.addCanFilterBy();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Topic";
    }

    @Override
    public Topic copy() {
        Topic dst = new Topic();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Topic dst) {
        super.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        StringType stringType = dst.title = this.title == null ? null : this.title.copy();
        if (this.derivedFromCanonical != null) {
            dst.derivedFromCanonical = new ArrayList<CanonicalType>();
            for (CanonicalType canonicalType : this.derivedFromCanonical) {
                dst.derivedFromCanonical.add(canonicalType.copy());
            }
        }
        if (this.derivedFromUri != null) {
            dst.derivedFromUri = new ArrayList<UriType>();
            for (UriType uriType2 : this.derivedFromUri) {
                dst.derivedFromUri.add(uriType2.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        Reference reference = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        dst.approvalDate = this.approvalDate == null ? null : this.approvalDate.copy();
        dst.lastReviewDate = this.lastReviewDate == null ? null : this.lastReviewDate.copy();
        dst.effectivePeriod = this.effectivePeriod == null ? null : this.effectivePeriod.copy();
        TopicResourceTriggerComponent topicResourceTriggerComponent = dst.resourceTrigger = this.resourceTrigger == null ? null : this.resourceTrigger.copy();
        if (this.canFilterBy != null) {
            dst.canFilterBy = new ArrayList<TopicCanFilterByComponent>();
            for (TopicCanFilterByComponent topicCanFilterByComponent : this.canFilterBy) {
                dst.canFilterBy.add(topicCanFilterByComponent.copy());
            }
        }
    }

    protected Topic typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Topic)) {
            return false;
        }
        Topic o = (Topic)other_;
        return Topic.compareDeep(this.url, o.url, true) && Topic.compareDeep(this.identifier, o.identifier, true) && Topic.compareDeep(this.version, o.version, true) && Topic.compareDeep(this.title, o.title, true) && Topic.compareDeep(this.derivedFromCanonical, o.derivedFromCanonical, true) && Topic.compareDeep(this.derivedFromUri, o.derivedFromUri, true) && Topic.compareDeep(this.status, o.status, true) && Topic.compareDeep(this.experimental, o.experimental, true) && Topic.compareDeep(this.date, o.date, true) && Topic.compareDeep(this.publisher, o.publisher, true) && Topic.compareDeep(this.contact, o.contact, true) && Topic.compareDeep(this.description, o.description, true) && Topic.compareDeep(this.useContext, o.useContext, true) && Topic.compareDeep(this.jurisdiction, o.jurisdiction, true) && Topic.compareDeep(this.purpose, o.purpose, true) && Topic.compareDeep(this.copyright, o.copyright, true) && Topic.compareDeep(this.approvalDate, o.approvalDate, true) && Topic.compareDeep(this.lastReviewDate, o.lastReviewDate, true) && Topic.compareDeep(this.effectivePeriod, o.effectivePeriod, true) && Topic.compareDeep(this.resourceTrigger, o.resourceTrigger, true) && Topic.compareDeep(this.canFilterBy, o.canFilterBy, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Topic)) {
            return false;
        }
        Topic o = (Topic)other_;
        return Topic.compareValues(this.url, o.url, true) && Topic.compareValues(this.version, o.version, true) && Topic.compareValues(this.title, o.title, true) && Topic.compareValues(this.derivedFromUri, o.derivedFromUri, true) && Topic.compareValues(this.status, o.status, true) && Topic.compareValues(this.experimental, o.experimental, true) && Topic.compareValues(this.date, o.date, true) && Topic.compareValues(this.description, o.description, true) && Topic.compareValues(this.purpose, o.purpose, true) && Topic.compareValues(this.copyright, o.copyright, true) && Topic.compareValues(this.approvalDate, o.approvalDate, true) && Topic.compareValues(this.lastReviewDate, o.lastReviewDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.url, this.identifier, this.version, this.title, this.derivedFromCanonical, this.derivedFromUri, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.copyright, this.approvalDate, this.lastReviewDate, this.effectivePeriod, this.resourceTrigger, this.canFilterBy});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Topic;
    }

    @Block
    public static class TopicCanFilterByComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Search parameter that serves as filter key", formalDefinition="A search parameter (like \"patient\") which is a label for the filter.")
        protected StringType name;
        @Child(name="matchType", type={CodeType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="= | in | not-in | above | below", formalDefinition="Allowable operators to apply when determining matches (Search Modifiers).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/topic-match-operator")
        protected List<Enumeration<TopicFilterByMatchType>> matchType;
        @Child(name="documentation", type={MarkdownType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Description of this filter parameter", formalDefinition="Description of how this filter parameter is intended to be used.")
        protected MarkdownType documentation;
        private static final long serialVersionUID = -9356414L;

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TopicCanFilterByComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public TopicCanFilterByComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public TopicCanFilterByComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public List<Enumeration<TopicFilterByMatchType>> getMatchType() {
            if (this.matchType == null) {
                this.matchType = new ArrayList<Enumeration<TopicFilterByMatchType>>();
            }
            return this.matchType;
        }

        public TopicCanFilterByComponent setMatchType(List<Enumeration<TopicFilterByMatchType>> theMatchType) {
            this.matchType = theMatchType;
            return this;
        }

        public boolean hasMatchType() {
            if (this.matchType == null) {
                return false;
            }
            for (Enumeration<TopicFilterByMatchType> item : this.matchType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<TopicFilterByMatchType> addMatchTypeElement() {
            Enumeration<TopicFilterByMatchType> t = new Enumeration<TopicFilterByMatchType>(new TopicFilterByMatchTypeEnumFactory());
            if (this.matchType == null) {
                this.matchType = new ArrayList<Enumeration<TopicFilterByMatchType>>();
            }
            this.matchType.add(t);
            return t;
        }

        public TopicCanFilterByComponent addMatchType(TopicFilterByMatchType value) {
            Enumeration<TopicFilterByMatchType> t = new Enumeration<TopicFilterByMatchType>(new TopicFilterByMatchTypeEnumFactory());
            t.setValue((Object)value);
            if (this.matchType == null) {
                this.matchType = new ArrayList<Enumeration<TopicFilterByMatchType>>();
            }
            this.matchType.add(t);
            return this;
        }

        public boolean hasMatchType(TopicFilterByMatchType value) {
            if (this.matchType == null) {
                return false;
            }
            for (Enumeration<TopicFilterByMatchType> v : this.matchType) {
                if (!((TopicFilterByMatchType)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public MarkdownType getDocumentationElement() {
            if (this.documentation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TopicCanFilterByComponent.documentation");
                }
                if (Configuration.doAutoCreate()) {
                    this.documentation = new MarkdownType();
                }
            }
            return this.documentation;
        }

        public boolean hasDocumentationElement() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public boolean hasDocumentation() {
            return this.documentation != null && !this.documentation.isEmpty();
        }

        public TopicCanFilterByComponent setDocumentationElement(MarkdownType value) {
            this.documentation = value;
            return this;
        }

        public String getDocumentation() {
            return this.documentation == null ? null : (String)this.documentation.getValue();
        }

        public TopicCanFilterByComponent setDocumentation(String value) {
            if (value == null) {
                this.documentation = null;
            } else {
                if (this.documentation == null) {
                    this.documentation = new MarkdownType();
                }
                this.documentation.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("name", "string", "A search parameter (like \"patient\") which is a label for the filter.", 0, 1, this.name));
            children.add(new Property("matchType", "code", "Allowable operators to apply when determining matches (Search Modifiers).", 0, Integer.MAX_VALUE, this.matchType));
            children.add(new Property("documentation", "markdown", "Description of how this filter parameter is intended to be used.", 0, 1, this.documentation));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property("name", "string", "A search parameter (like \"patient\") which is a label for the filter.", 0, 1, this.name);
                }
                case 614036127: {
                    return new Property("matchType", "code", "Allowable operators to apply when determining matches (Search Modifiers).", 0, Integer.MAX_VALUE, this.matchType);
                }
                case 1587405498: {
                    return new Property("documentation", "markdown", "Description of how this filter parameter is intended to be used.", 0, 1, this.documentation);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case 614036127: {
                    return this.matchType == null ? new Base[]{} : this.matchType.toArray(new Base[this.matchType.size()]);
                }
                case 1587405498: {
                    Base[] baseArray;
                    if (this.documentation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.documentation;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 614036127: {
                    value = new TopicFilterByMatchTypeEnumFactory().fromType(this.castToCode(value));
                    this.getMatchType().add(value);
                    return value;
                }
                case 1587405498: {
                    this.documentation = this.castToMarkdown(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("matchType")) {
                value = new TopicFilterByMatchTypeEnumFactory().fromType(this.castToCode(value));
                this.getMatchType().add(value);
            } else if (name.equals("documentation")) {
                this.documentation = this.castToMarkdown(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case 614036127: {
                    return this.addMatchTypeElement();
                }
                case 1587405498: {
                    return this.getDocumentationElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case 614036127: {
                    return new String[]{"code"};
                }
                case 1587405498: {
                    return new String[]{"markdown"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a primitive type Topic.name");
            }
            if (name.equals("matchType")) {
                throw new FHIRException("Cannot call addChild on a primitive type Topic.matchType");
            }
            if (name.equals("documentation")) {
                throw new FHIRException("Cannot call addChild on a primitive type Topic.documentation");
            }
            return super.addChild(name);
        }

        @Override
        public TopicCanFilterByComponent copy() {
            TopicCanFilterByComponent dst = new TopicCanFilterByComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TopicCanFilterByComponent dst) {
            super.copyValues(dst);
            StringType stringType = dst.name = this.name == null ? null : this.name.copy();
            if (this.matchType != null) {
                dst.matchType = new ArrayList<Enumeration<TopicFilterByMatchType>>();
                for (Enumeration<TopicFilterByMatchType> i : this.matchType) {
                    dst.matchType.add((Enumeration<TopicFilterByMatchType>)i.copy());
                }
            }
            dst.documentation = this.documentation == null ? null : this.documentation.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TopicCanFilterByComponent)) {
                return false;
            }
            TopicCanFilterByComponent o = (TopicCanFilterByComponent)other_;
            return TopicCanFilterByComponent.compareDeep(this.name, o.name, true) && TopicCanFilterByComponent.compareDeep(this.matchType, o.matchType, true) && TopicCanFilterByComponent.compareDeep(this.documentation, o.documentation, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TopicCanFilterByComponent)) {
                return false;
            }
            TopicCanFilterByComponent o = (TopicCanFilterByComponent)other_;
            return TopicCanFilterByComponent.compareValues(this.name, o.name, true) && TopicCanFilterByComponent.compareValues(this.matchType, o.matchType, true) && TopicCanFilterByComponent.compareValues(this.documentation, o.documentation, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.name, this.matchType, this.documentation});
        }

        @Override
        public String fhirType() {
            return "Topic.canFilterBy";
        }
    }

    @Block
    public static class TopicResourceTriggerQueryCriteriaComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="previous", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Rule applied to previous resource state", formalDefinition="The FHIR query based rules are applied to the previous resource state.")
        protected StringType previous;
        @Child(name="current", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Rule applied to current resource state", formalDefinition="The FHIR query based rules are applied to the current resource state.")
        protected StringType current;
        @Child(name="requireBoth", type={BooleanType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Both must be true flag", formalDefinition="If set to true, both current and previous criteria must evaluate true to  trigger a notification for this topic.  Otherwise a notification for this topic will be triggered if either one evaluates to true.")
        protected BooleanType requireBoth;
        private static final long serialVersionUID = -1611265114L;

        public StringType getPreviousElement() {
            if (this.previous == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TopicResourceTriggerQueryCriteriaComponent.previous");
                }
                if (Configuration.doAutoCreate()) {
                    this.previous = new StringType();
                }
            }
            return this.previous;
        }

        public boolean hasPreviousElement() {
            return this.previous != null && !this.previous.isEmpty();
        }

        public boolean hasPrevious() {
            return this.previous != null && !this.previous.isEmpty();
        }

        public TopicResourceTriggerQueryCriteriaComponent setPreviousElement(StringType value) {
            this.previous = value;
            return this;
        }

        public String getPrevious() {
            return this.previous == null ? null : (String)this.previous.getValue();
        }

        public TopicResourceTriggerQueryCriteriaComponent setPrevious(String value) {
            if (Utilities.noString((String)value)) {
                this.previous = null;
            } else {
                if (this.previous == null) {
                    this.previous = new StringType();
                }
                this.previous.setValue(value);
            }
            return this;
        }

        public StringType getCurrentElement() {
            if (this.current == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TopicResourceTriggerQueryCriteriaComponent.current");
                }
                if (Configuration.doAutoCreate()) {
                    this.current = new StringType();
                }
            }
            return this.current;
        }

        public boolean hasCurrentElement() {
            return this.current != null && !this.current.isEmpty();
        }

        public boolean hasCurrent() {
            return this.current != null && !this.current.isEmpty();
        }

        public TopicResourceTriggerQueryCriteriaComponent setCurrentElement(StringType value) {
            this.current = value;
            return this;
        }

        public String getCurrent() {
            return this.current == null ? null : (String)this.current.getValue();
        }

        public TopicResourceTriggerQueryCriteriaComponent setCurrent(String value) {
            if (Utilities.noString((String)value)) {
                this.current = null;
            } else {
                if (this.current == null) {
                    this.current = new StringType();
                }
                this.current.setValue(value);
            }
            return this;
        }

        public BooleanType getRequireBothElement() {
            if (this.requireBoth == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TopicResourceTriggerQueryCriteriaComponent.requireBoth");
                }
                if (Configuration.doAutoCreate()) {
                    this.requireBoth = new BooleanType();
                }
            }
            return this.requireBoth;
        }

        public boolean hasRequireBothElement() {
            return this.requireBoth != null && !this.requireBoth.isEmpty();
        }

        public boolean hasRequireBoth() {
            return this.requireBoth != null && !this.requireBoth.isEmpty();
        }

        public TopicResourceTriggerQueryCriteriaComponent setRequireBothElement(BooleanType value) {
            this.requireBoth = value;
            return this;
        }

        public boolean getRequireBoth() {
            return this.requireBoth == null || this.requireBoth.isEmpty() ? false : (Boolean)this.requireBoth.getValue();
        }

        public TopicResourceTriggerQueryCriteriaComponent setRequireBoth(boolean value) {
            if (this.requireBoth == null) {
                this.requireBoth = new BooleanType();
            }
            this.requireBoth.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("previous", "string", "The FHIR query based rules are applied to the previous resource state.", 0, 1, this.previous));
            children.add(new Property("current", "string", "The FHIR query based rules are applied to the current resource state.", 0, 1, this.current));
            children.add(new Property("requireBoth", "boolean", "If set to true, both current and previous criteria must evaluate true to  trigger a notification for this topic.  Otherwise a notification for this topic will be triggered if either one evaluates to true.", 0, 1, this.requireBoth));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1273775369: {
                    return new Property("previous", "string", "The FHIR query based rules are applied to the previous resource state.", 0, 1, this.previous);
                }
                case 1126940025: {
                    return new Property("current", "string", "The FHIR query based rules are applied to the current resource state.", 0, 1, this.current);
                }
                case 362116742: {
                    return new Property("requireBoth", "boolean", "If set to true, both current and previous criteria must evaluate true to  trigger a notification for this topic.  Otherwise a notification for this topic will be triggered if either one evaluates to true.", 0, 1, this.requireBoth);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    Base[] baseArray;
                    if (this.previous == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.previous;
                    }
                    return baseArray;
                }
                case 1126940025: {
                    Base[] baseArray;
                    if (this.current == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.current;
                    }
                    return baseArray;
                }
                case 362116742: {
                    Base[] baseArray;
                    if (this.requireBoth == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.requireBoth;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    this.previous = this.castToString(value);
                    return value;
                }
                case 1126940025: {
                    this.current = this.castToString(value);
                    return value;
                }
                case 362116742: {
                    this.requireBoth = this.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("previous")) {
                this.previous = this.castToString(value);
            } else if (name.equals("current")) {
                this.current = this.castToString(value);
            } else if (name.equals("requireBoth")) {
                this.requireBoth = this.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    return this.getPreviousElement();
                }
                case 1126940025: {
                    return this.getCurrentElement();
                }
                case 362116742: {
                    return this.getRequireBothElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1273775369: {
                    return new String[]{"string"};
                }
                case 1126940025: {
                    return new String[]{"string"};
                }
                case 362116742: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("previous")) {
                throw new FHIRException("Cannot call addChild on a primitive type Topic.previous");
            }
            if (name.equals("current")) {
                throw new FHIRException("Cannot call addChild on a primitive type Topic.current");
            }
            if (name.equals("requireBoth")) {
                throw new FHIRException("Cannot call addChild on a primitive type Topic.requireBoth");
            }
            return super.addChild(name);
        }

        @Override
        public TopicResourceTriggerQueryCriteriaComponent copy() {
            TopicResourceTriggerQueryCriteriaComponent dst = new TopicResourceTriggerQueryCriteriaComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TopicResourceTriggerQueryCriteriaComponent dst) {
            super.copyValues(dst);
            dst.previous = this.previous == null ? null : this.previous.copy();
            dst.current = this.current == null ? null : this.current.copy();
            dst.requireBoth = this.requireBoth == null ? null : this.requireBoth.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TopicResourceTriggerQueryCriteriaComponent)) {
                return false;
            }
            TopicResourceTriggerQueryCriteriaComponent o = (TopicResourceTriggerQueryCriteriaComponent)other_;
            return TopicResourceTriggerQueryCriteriaComponent.compareDeep(this.previous, o.previous, true) && TopicResourceTriggerQueryCriteriaComponent.compareDeep(this.current, o.current, true) && TopicResourceTriggerQueryCriteriaComponent.compareDeep(this.requireBoth, o.requireBoth, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TopicResourceTriggerQueryCriteriaComponent)) {
                return false;
            }
            TopicResourceTriggerQueryCriteriaComponent o = (TopicResourceTriggerQueryCriteriaComponent)other_;
            return TopicResourceTriggerQueryCriteriaComponent.compareValues(this.previous, o.previous, true) && TopicResourceTriggerQueryCriteriaComponent.compareValues(this.current, o.current, true) && TopicResourceTriggerQueryCriteriaComponent.compareValues(this.requireBoth, o.requireBoth, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.previous, this.current, this.requireBoth});
        }

        @Override
        public String fhirType() {
            return "Topic.resourceTrigger.queryCriteria";
        }
    }

    @Block
    public static class TopicResourceTriggerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="description", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Text representation of the trigger", formalDefinition="The human readable description of what triggers inclusion into this topic -  for example, \"Beginning of a clinical encounter\".")
        protected StringType description;
        @Child(name="resourceType", type={CodeType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Candidate types for this topic", formalDefinition="The list of resource types that are candidates for this topic.  For example, the Encounter resource is updated in an 'admission' topic.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
        protected List<Enumeration<FHIRType>> resourceType;
        @Child(name="methodCriteria", type={CodeType.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="create | update | delete", formalDefinition="The REST interaction based rules that the server should use to determine when to trigger a notification for this topic.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/interaction-trigger")
        protected List<Enumeration<MethodCode>> methodCriteria;
        @Child(name="queryCriteria", type={}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Query based trigger rule", formalDefinition="The FHIR query based rules that the server should use to determine when to trigger a notification for this topic.")
        protected TopicResourceTriggerQueryCriteriaComponent queryCriteria;
        @Child(name="fhirPathCriteria", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="FHIRPath based trigger rule", formalDefinition="The FHIRPath based rules that the server should use to determine when to trigger a notification for this topic.")
        protected StringType fhirPathCriteria;
        private static final long serialVersionUID = 191150436L;

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TopicResourceTriggerComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public TopicResourceTriggerComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public TopicResourceTriggerComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<Enumeration<FHIRType>> getResourceType() {
            if (this.resourceType == null) {
                this.resourceType = new ArrayList<Enumeration<FHIRType>>();
            }
            return this.resourceType;
        }

        public TopicResourceTriggerComponent setResourceType(List<Enumeration<FHIRType>> theResourceType) {
            this.resourceType = theResourceType;
            return this;
        }

        public boolean hasResourceType() {
            if (this.resourceType == null) {
                return false;
            }
            for (Enumeration<FHIRType> item : this.resourceType) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<FHIRType> addResourceTypeElement() {
            Enumeration<FHIRType> t = new Enumeration<FHIRType>(new FHIRTypeEnumFactory());
            if (this.resourceType == null) {
                this.resourceType = new ArrayList<Enumeration<FHIRType>>();
            }
            this.resourceType.add(t);
            return t;
        }

        public TopicResourceTriggerComponent addResourceType(FHIRType value) {
            Enumeration<FHIRType> t = new Enumeration<FHIRType>(new FHIRTypeEnumFactory());
            t.setValue((Object)value);
            if (this.resourceType == null) {
                this.resourceType = new ArrayList<Enumeration<FHIRType>>();
            }
            this.resourceType.add(t);
            return this;
        }

        public boolean hasResourceType(FHIRType value) {
            if (this.resourceType == null) {
                return false;
            }
            for (Enumeration<FHIRType> v : this.resourceType) {
                if (!((FHIRType)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public List<Enumeration<MethodCode>> getMethodCriteria() {
            if (this.methodCriteria == null) {
                this.methodCriteria = new ArrayList<Enumeration<MethodCode>>();
            }
            return this.methodCriteria;
        }

        public TopicResourceTriggerComponent setMethodCriteria(List<Enumeration<MethodCode>> theMethodCriteria) {
            this.methodCriteria = theMethodCriteria;
            return this;
        }

        public boolean hasMethodCriteria() {
            if (this.methodCriteria == null) {
                return false;
            }
            for (Enumeration<MethodCode> item : this.methodCriteria) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Enumeration<MethodCode> addMethodCriteriaElement() {
            Enumeration<MethodCode> t = new Enumeration<MethodCode>(new MethodCodeEnumFactory());
            if (this.methodCriteria == null) {
                this.methodCriteria = new ArrayList<Enumeration<MethodCode>>();
            }
            this.methodCriteria.add(t);
            return t;
        }

        public TopicResourceTriggerComponent addMethodCriteria(MethodCode value) {
            Enumeration<MethodCode> t = new Enumeration<MethodCode>(new MethodCodeEnumFactory());
            t.setValue((Object)value);
            if (this.methodCriteria == null) {
                this.methodCriteria = new ArrayList<Enumeration<MethodCode>>();
            }
            this.methodCriteria.add(t);
            return this;
        }

        public boolean hasMethodCriteria(MethodCode value) {
            if (this.methodCriteria == null) {
                return false;
            }
            for (Enumeration<MethodCode> v : this.methodCriteria) {
                if (!((MethodCode)((Object)v.getValue())).equals((Object)value)) continue;
                return true;
            }
            return false;
        }

        public TopicResourceTriggerQueryCriteriaComponent getQueryCriteria() {
            if (this.queryCriteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TopicResourceTriggerComponent.queryCriteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.queryCriteria = new TopicResourceTriggerQueryCriteriaComponent();
                }
            }
            return this.queryCriteria;
        }

        public boolean hasQueryCriteria() {
            return this.queryCriteria != null && !this.queryCriteria.isEmpty();
        }

        public TopicResourceTriggerComponent setQueryCriteria(TopicResourceTriggerQueryCriteriaComponent value) {
            this.queryCriteria = value;
            return this;
        }

        public StringType getFhirPathCriteriaElement() {
            if (this.fhirPathCriteria == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TopicResourceTriggerComponent.fhirPathCriteria");
                }
                if (Configuration.doAutoCreate()) {
                    this.fhirPathCriteria = new StringType();
                }
            }
            return this.fhirPathCriteria;
        }

        public boolean hasFhirPathCriteriaElement() {
            return this.fhirPathCriteria != null && !this.fhirPathCriteria.isEmpty();
        }

        public boolean hasFhirPathCriteria() {
            return this.fhirPathCriteria != null && !this.fhirPathCriteria.isEmpty();
        }

        public TopicResourceTriggerComponent setFhirPathCriteriaElement(StringType value) {
            this.fhirPathCriteria = value;
            return this;
        }

        public String getFhirPathCriteria() {
            return this.fhirPathCriteria == null ? null : (String)this.fhirPathCriteria.getValue();
        }

        public TopicResourceTriggerComponent setFhirPathCriteria(String value) {
            if (Utilities.noString((String)value)) {
                this.fhirPathCriteria = null;
            } else {
                if (this.fhirPathCriteria == null) {
                    this.fhirPathCriteria = new StringType();
                }
                this.fhirPathCriteria.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("description", "string", "The human readable description of what triggers inclusion into this topic -  for example, \"Beginning of a clinical encounter\".", 0, 1, this.description));
            children.add(new Property("resourceType", "code", "The list of resource types that are candidates for this topic.  For example, the Encounter resource is updated in an 'admission' topic.", 0, Integer.MAX_VALUE, this.resourceType));
            children.add(new Property("methodCriteria", "code", "The REST interaction based rules that the server should use to determine when to trigger a notification for this topic.", 0, Integer.MAX_VALUE, this.methodCriteria));
            children.add(new Property("queryCriteria", "", "The FHIR query based rules that the server should use to determine when to trigger a notification for this topic.", 0, 1, this.queryCriteria));
            children.add(new Property("fhirPathCriteria", "string", "The FHIRPath based rules that the server should use to determine when to trigger a notification for this topic.", 0, 1, this.fhirPathCriteria));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1724546052: {
                    return new Property("description", "string", "The human readable description of what triggers inclusion into this topic -  for example, \"Beginning of a clinical encounter\".", 0, 1, this.description);
                }
                case -384364440: {
                    return new Property("resourceType", "code", "The list of resource types that are candidates for this topic.  For example, the Encounter resource is updated in an 'admission' topic.", 0, Integer.MAX_VALUE, this.resourceType);
                }
                case -1924160672: {
                    return new Property("methodCriteria", "code", "The REST interaction based rules that the server should use to determine when to trigger a notification for this topic.", 0, Integer.MAX_VALUE, this.methodCriteria);
                }
                case -545123257: {
                    return new Property("queryCriteria", "", "The FHIR query based rules that the server should use to determine when to trigger a notification for this topic.", 0, 1, this.queryCriteria);
                }
                case 1929785263: {
                    return new Property("fhirPathCriteria", "string", "The FHIRPath based rules that the server should use to determine when to trigger a notification for this topic.", 0, 1, this.fhirPathCriteria);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.description;
                    }
                    return baseArray;
                }
                case -384364440: {
                    return this.resourceType == null ? new Base[]{} : this.resourceType.toArray(new Base[this.resourceType.size()]);
                }
                case -1924160672: {
                    return this.methodCriteria == null ? new Base[]{} : this.methodCriteria.toArray(new Base[this.methodCriteria.size()]);
                }
                case -545123257: {
                    Base[] baseArray;
                    if (this.queryCriteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.queryCriteria;
                    }
                    return baseArray;
                }
                case 1929785263: {
                    Base[] baseArray;
                    if (this.fhirPathCriteria == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.fhirPathCriteria;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -384364440: {
                    value = new FHIRTypeEnumFactory().fromType(this.castToCode(value));
                    this.getResourceType().add(value);
                    return value;
                }
                case -1924160672: {
                    value = new MethodCodeEnumFactory().fromType(this.castToCode(value));
                    this.getMethodCriteria().add(value);
                    return value;
                }
                case -545123257: {
                    this.queryCriteria = (TopicResourceTriggerQueryCriteriaComponent)((Object)value);
                    return value;
                }
                case 1929785263: {
                    this.fhirPathCriteria = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("resourceType")) {
                value = new FHIRTypeEnumFactory().fromType(this.castToCode(value));
                this.getResourceType().add(value);
            } else if (name.equals("methodCriteria")) {
                value = new MethodCodeEnumFactory().fromType(this.castToCode(value));
                this.getMethodCriteria().add(value);
            } else if (name.equals("queryCriteria")) {
                this.queryCriteria = (TopicResourceTriggerQueryCriteriaComponent)((Object)value);
            } else if (name.equals("fhirPathCriteria")) {
                this.fhirPathCriteria = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -384364440: {
                    return this.addResourceTypeElement();
                }
                case -1924160672: {
                    return this.addMethodCriteriaElement();
                }
                case -545123257: {
                    return this.getQueryCriteria();
                }
                case 1929785263: {
                    return this.getFhirPathCriteriaElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -384364440: {
                    return new String[]{"code"};
                }
                case -1924160672: {
                    return new String[]{"code"};
                }
                case -545123257: {
                    return new String[0];
                }
                case 1929785263: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type Topic.description");
            }
            if (name.equals("resourceType")) {
                throw new FHIRException("Cannot call addChild on a primitive type Topic.resourceType");
            }
            if (name.equals("methodCriteria")) {
                throw new FHIRException("Cannot call addChild on a primitive type Topic.methodCriteria");
            }
            if (name.equals("queryCriteria")) {
                this.queryCriteria = new TopicResourceTriggerQueryCriteriaComponent();
                return this.queryCriteria;
            }
            if (name.equals("fhirPathCriteria")) {
                throw new FHIRException("Cannot call addChild on a primitive type Topic.fhirPathCriteria");
            }
            return super.addChild(name);
        }

        @Override
        public TopicResourceTriggerComponent copy() {
            TopicResourceTriggerComponent dst = new TopicResourceTriggerComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(TopicResourceTriggerComponent dst) {
            super.copyValues(dst);
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.resourceType != null) {
                dst.resourceType = new ArrayList<Enumeration<FHIRType>>();
                for (Enumeration<Enum> enumeration : this.resourceType) {
                    dst.resourceType.add((Enumeration<FHIRType>)enumeration.copy());
                }
            }
            if (this.methodCriteria != null) {
                dst.methodCriteria = new ArrayList<Enumeration<MethodCode>>();
                for (Enumeration<Enum> enumeration : this.methodCriteria) {
                    dst.methodCriteria.add((Enumeration<MethodCode>)enumeration.copy());
                }
            }
            dst.queryCriteria = this.queryCriteria == null ? null : this.queryCriteria.copy();
            dst.fhirPathCriteria = this.fhirPathCriteria == null ? null : this.fhirPathCriteria.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof TopicResourceTriggerComponent)) {
                return false;
            }
            TopicResourceTriggerComponent o = (TopicResourceTriggerComponent)other_;
            return TopicResourceTriggerComponent.compareDeep(this.description, o.description, true) && TopicResourceTriggerComponent.compareDeep(this.resourceType, o.resourceType, true) && TopicResourceTriggerComponent.compareDeep(this.methodCriteria, o.methodCriteria, true) && TopicResourceTriggerComponent.compareDeep(this.queryCriteria, o.queryCriteria, true) && TopicResourceTriggerComponent.compareDeep(this.fhirPathCriteria, o.fhirPathCriteria, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof TopicResourceTriggerComponent)) {
                return false;
            }
            TopicResourceTriggerComponent o = (TopicResourceTriggerComponent)other_;
            return TopicResourceTriggerComponent.compareValues(this.description, o.description, true) && TopicResourceTriggerComponent.compareValues(this.resourceType, o.resourceType, true) && TopicResourceTriggerComponent.compareValues(this.methodCriteria, o.methodCriteria, true) && TopicResourceTriggerComponent.compareValues(this.fhirPathCriteria, o.fhirPathCriteria, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.description, this.resourceType, this.methodCriteria, this.queryCriteria, this.fhirPathCriteria});
        }

        @Override
        public String fhirType() {
            return "Topic.resourceTrigger";
        }
    }

    public static class TopicFilterByMatchTypeEnumFactory
    implements EnumFactory<TopicFilterByMatchType> {
        @Override
        public TopicFilterByMatchType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("=".equals(codeString)) {
                return TopicFilterByMatchType.EQUAL;
            }
            if ("in".equals(codeString)) {
                return TopicFilterByMatchType.IN;
            }
            if ("not-in".equals(codeString)) {
                return TopicFilterByMatchType.NOTIN;
            }
            if ("above".equals(codeString)) {
                return TopicFilterByMatchType.ABOVE;
            }
            if ("below".equals(codeString)) {
                return TopicFilterByMatchType.BELOW;
            }
            throw new IllegalArgumentException("Unknown TopicFilterByMatchType code '" + codeString + "'");
        }

        public Enumeration<TopicFilterByMatchType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TopicFilterByMatchType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("=".equals(codeString)) {
                return new Enumeration<TopicFilterByMatchType>(this, TopicFilterByMatchType.EQUAL);
            }
            if ("in".equals(codeString)) {
                return new Enumeration<TopicFilterByMatchType>(this, TopicFilterByMatchType.IN);
            }
            if ("not-in".equals(codeString)) {
                return new Enumeration<TopicFilterByMatchType>(this, TopicFilterByMatchType.NOTIN);
            }
            if ("above".equals(codeString)) {
                return new Enumeration<TopicFilterByMatchType>(this, TopicFilterByMatchType.ABOVE);
            }
            if ("below".equals(codeString)) {
                return new Enumeration<TopicFilterByMatchType>(this, TopicFilterByMatchType.BELOW);
            }
            throw new FHIRException("Unknown TopicFilterByMatchType code '" + codeString + "'");
        }

        @Override
        public String toCode(TopicFilterByMatchType code) {
            if (code == TopicFilterByMatchType.EQUAL) {
                return "=";
            }
            if (code == TopicFilterByMatchType.IN) {
                return "in";
            }
            if (code == TopicFilterByMatchType.NOTIN) {
                return "not-in";
            }
            if (code == TopicFilterByMatchType.ABOVE) {
                return "above";
            }
            if (code == TopicFilterByMatchType.BELOW) {
                return "below";
            }
            return "?";
        }

        @Override
        public String toSystem(TopicFilterByMatchType code) {
            return code.getSystem();
        }
    }

    public static enum TopicFilterByMatchType {
        EQUAL,
        IN,
        NOTIN,
        ABOVE,
        BELOW,
        NULL;


        public static TopicFilterByMatchType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("=".equals(codeString)) {
                return EQUAL;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("not-in".equals(codeString)) {
                return NOTIN;
            }
            if ("above".equals(codeString)) {
                return ABOVE;
            }
            if ("below".equals(codeString)) {
                return BELOW;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TopicFilterByMatchType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EQUAL: {
                    return "=";
                }
                case IN: {
                    return "in";
                }
                case NOTIN: {
                    return "not-in";
                }
                case ABOVE: {
                    return "above";
                }
                case BELOW: {
                    return "below";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EQUAL: {
                    return "http://hl7.org/fhir/topic-match-operator";
                }
                case IN: {
                    return "http://hl7.org/fhir/topic-match-operator";
                }
                case NOTIN: {
                    return "http://hl7.org/fhir/topic-match-operator";
                }
                case ABOVE: {
                    return "http://hl7.org/fhir/topic-match-operator";
                }
                case BELOW: {
                    return "http://hl7.org/fhir/topic-match-operator";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EQUAL: {
                    return "Used to match a value according to FHIR Search rules (e.g., Patient/123, Encounter/2002).";
                }
                case IN: {
                    return "The key value in the topic stream is an active members of the reference set identified by the concept provided as the filter value.";
                }
                case NOTIN: {
                    return "The key value in the topic stream is NOT an active members of the reference set identified by the concept provided as the filter value.";
                }
                case ABOVE: {
                    return "The key value is subsumes the value in the filter value.";
                }
                case BELOW: {
                    return "The key value is subsumed by the value in the filter value.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EQUAL: {
                    return "=";
                }
                case IN: {
                    return "in";
                }
                case NOTIN: {
                    return "not-in";
                }
                case ABOVE: {
                    return "above";
                }
                case BELOW: {
                    return "below";
                }
            }
            return "?";
        }
    }

    public static class MethodCodeEnumFactory
    implements EnumFactory<MethodCode> {
        @Override
        public MethodCode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("create".equals(codeString)) {
                return MethodCode.CREATE;
            }
            if ("update".equals(codeString)) {
                return MethodCode.UPDATE;
            }
            if ("delete".equals(codeString)) {
                return MethodCode.DELETE;
            }
            throw new IllegalArgumentException("Unknown MethodCode code '" + codeString + "'");
        }

        public Enumeration<MethodCode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<MethodCode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return new Enumeration<MethodCode>(this, MethodCode.CREATE);
            }
            if ("update".equals(codeString)) {
                return new Enumeration<MethodCode>(this, MethodCode.UPDATE);
            }
            if ("delete".equals(codeString)) {
                return new Enumeration<MethodCode>(this, MethodCode.DELETE);
            }
            throw new FHIRException("Unknown MethodCode code '" + codeString + "'");
        }

        @Override
        public String toCode(MethodCode code) {
            if (code == MethodCode.CREATE) {
                return "create";
            }
            if (code == MethodCode.UPDATE) {
                return "update";
            }
            if (code == MethodCode.DELETE) {
                return "delete";
            }
            return "?";
        }

        @Override
        public String toSystem(MethodCode code) {
            return code.getSystem();
        }
    }

    public static enum MethodCode {
        CREATE,
        UPDATE,
        DELETE,
        NULL;


        public static MethodCode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("create".equals(codeString)) {
                return CREATE;
            }
            if ("update".equals(codeString)) {
                return UPDATE;
            }
            if ("delete".equals(codeString)) {
                return DELETE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown MethodCode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case UPDATE: {
                    return "update";
                }
                case DELETE: {
                    return "delete";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case CREATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case UPDATE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
                case DELETE: {
                    return "http://hl7.org/fhir/restful-interaction";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case CREATE: {
                    return "";
                }
                case UPDATE: {
                    return "";
                }
                case DELETE: {
                    return "";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case CREATE: {
                    return "create";
                }
                case UPDATE: {
                    return "update";
                }
                case DELETE: {
                    return "delete";
                }
            }
            return "?";
        }
    }

    public static class FHIRTypeEnumFactory
    implements EnumFactory<FHIRType> {
        @Override
        public FHIRType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("Account".equals(codeString)) {
                return FHIRType.ACCOUNT;
            }
            if ("ActivityDefinition".equals(codeString)) {
                return FHIRType.ACTIVITYDEFINITION;
            }
            if ("AdministrableProductDefinition".equals(codeString)) {
                return FHIRType.ADMINISTRABLEPRODUCTDEFINITION;
            }
            if ("AdverseEvent".equals(codeString)) {
                return FHIRType.ADVERSEEVENT;
            }
            if ("AllergyIntolerance".equals(codeString)) {
                return FHIRType.ALLERGYINTOLERANCE;
            }
            if ("Appointment".equals(codeString)) {
                return FHIRType.APPOINTMENT;
            }
            if ("AppointmentResponse".equals(codeString)) {
                return FHIRType.APPOINTMENTRESPONSE;
            }
            if ("AuditEvent".equals(codeString)) {
                return FHIRType.AUDITEVENT;
            }
            if ("Basic".equals(codeString)) {
                return FHIRType.BASIC;
            }
            if ("Binary".equals(codeString)) {
                return FHIRType.BINARY;
            }
            if ("BiologicallyDerivedProduct".equals(codeString)) {
                return FHIRType.BIOLOGICALLYDERIVEDPRODUCT;
            }
            if ("BodyStructure".equals(codeString)) {
                return FHIRType.BODYSTRUCTURE;
            }
            if ("Bundle".equals(codeString)) {
                return FHIRType.BUNDLE;
            }
            if ("CapabilityStatement".equals(codeString)) {
                return FHIRType.CAPABILITYSTATEMENT;
            }
            if ("CapabilityStatement2".equals(codeString)) {
                return FHIRType.CAPABILITYSTATEMENT2;
            }
            if ("CarePlan".equals(codeString)) {
                return FHIRType.CAREPLAN;
            }
            if ("CareTeam".equals(codeString)) {
                return FHIRType.CARETEAM;
            }
            if ("CatalogEntry".equals(codeString)) {
                return FHIRType.CATALOGENTRY;
            }
            if ("ChargeItem".equals(codeString)) {
                return FHIRType.CHARGEITEM;
            }
            if ("ChargeItemDefinition".equals(codeString)) {
                return FHIRType.CHARGEITEMDEFINITION;
            }
            if ("Claim".equals(codeString)) {
                return FHIRType.CLAIM;
            }
            if ("ClaimResponse".equals(codeString)) {
                return FHIRType.CLAIMRESPONSE;
            }
            if ("ClinicalImpression".equals(codeString)) {
                return FHIRType.CLINICALIMPRESSION;
            }
            if ("ClinicalUseIssue".equals(codeString)) {
                return FHIRType.CLINICALUSEISSUE;
            }
            if ("CodeSystem".equals(codeString)) {
                return FHIRType.CODESYSTEM;
            }
            if ("Communication".equals(codeString)) {
                return FHIRType.COMMUNICATION;
            }
            if ("CommunicationRequest".equals(codeString)) {
                return FHIRType.COMMUNICATIONREQUEST;
            }
            if ("CompartmentDefinition".equals(codeString)) {
                return FHIRType.COMPARTMENTDEFINITION;
            }
            if ("Composition".equals(codeString)) {
                return FHIRType.COMPOSITION;
            }
            if ("ConceptMap".equals(codeString)) {
                return FHIRType.CONCEPTMAP;
            }
            if ("Condition".equals(codeString)) {
                return FHIRType.CONDITION;
            }
            if ("ConditionDefinition".equals(codeString)) {
                return FHIRType.CONDITIONDEFINITION;
            }
            if ("Consent".equals(codeString)) {
                return FHIRType.CONSENT;
            }
            if ("Contract".equals(codeString)) {
                return FHIRType.CONTRACT;
            }
            if ("Coverage".equals(codeString)) {
                return FHIRType.COVERAGE;
            }
            if ("CoverageEligibilityRequest".equals(codeString)) {
                return FHIRType.COVERAGEELIGIBILITYREQUEST;
            }
            if ("CoverageEligibilityResponse".equals(codeString)) {
                return FHIRType.COVERAGEELIGIBILITYRESPONSE;
            }
            if ("DetectedIssue".equals(codeString)) {
                return FHIRType.DETECTEDISSUE;
            }
            if ("Device".equals(codeString)) {
                return FHIRType.DEVICE;
            }
            if ("DeviceDefinition".equals(codeString)) {
                return FHIRType.DEVICEDEFINITION;
            }
            if ("DeviceMetric".equals(codeString)) {
                return FHIRType.DEVICEMETRIC;
            }
            if ("DeviceRequest".equals(codeString)) {
                return FHIRType.DEVICEREQUEST;
            }
            if ("DeviceUseStatement".equals(codeString)) {
                return FHIRType.DEVICEUSESTATEMENT;
            }
            if ("DiagnosticReport".equals(codeString)) {
                return FHIRType.DIAGNOSTICREPORT;
            }
            if ("DocumentManifest".equals(codeString)) {
                return FHIRType.DOCUMENTMANIFEST;
            }
            if ("DocumentReference".equals(codeString)) {
                return FHIRType.DOCUMENTREFERENCE;
            }
            if ("DomainResource".equals(codeString)) {
                return FHIRType.DOMAINRESOURCE;
            }
            if ("Encounter".equals(codeString)) {
                return FHIRType.ENCOUNTER;
            }
            if ("Endpoint".equals(codeString)) {
                return FHIRType.ENDPOINT;
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return FHIRType.ENROLLMENTREQUEST;
            }
            if ("EnrollmentResponse".equals(codeString)) {
                return FHIRType.ENROLLMENTRESPONSE;
            }
            if ("EpisodeOfCare".equals(codeString)) {
                return FHIRType.EPISODEOFCARE;
            }
            if ("EventDefinition".equals(codeString)) {
                return FHIRType.EVENTDEFINITION;
            }
            if ("Evidence".equals(codeString)) {
                return FHIRType.EVIDENCE;
            }
            if ("EvidenceVariable".equals(codeString)) {
                return FHIRType.EVIDENCEVARIABLE;
            }
            if ("ExampleScenario".equals(codeString)) {
                return FHIRType.EXAMPLESCENARIO;
            }
            if ("ExplanationOfBenefit".equals(codeString)) {
                return FHIRType.EXPLANATIONOFBENEFIT;
            }
            if ("FamilyMemberHistory".equals(codeString)) {
                return FHIRType.FAMILYMEMBERHISTORY;
            }
            if ("Flag".equals(codeString)) {
                return FHIRType.FLAG;
            }
            if ("Goal".equals(codeString)) {
                return FHIRType.GOAL;
            }
            if ("GraphDefinition".equals(codeString)) {
                return FHIRType.GRAPHDEFINITION;
            }
            if ("Group".equals(codeString)) {
                return FHIRType.GROUP;
            }
            if ("GuidanceResponse".equals(codeString)) {
                return FHIRType.GUIDANCERESPONSE;
            }
            if ("HealthcareService".equals(codeString)) {
                return FHIRType.HEALTHCARESERVICE;
            }
            if ("ImagingStudy".equals(codeString)) {
                return FHIRType.IMAGINGSTUDY;
            }
            if ("Immunization".equals(codeString)) {
                return FHIRType.IMMUNIZATION;
            }
            if ("ImmunizationEvaluation".equals(codeString)) {
                return FHIRType.IMMUNIZATIONEVALUATION;
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return FHIRType.IMMUNIZATIONRECOMMENDATION;
            }
            if ("ImplementationGuide".equals(codeString)) {
                return FHIRType.IMPLEMENTATIONGUIDE;
            }
            if ("Ingredient".equals(codeString)) {
                return FHIRType.INGREDIENT;
            }
            if ("InsurancePlan".equals(codeString)) {
                return FHIRType.INSURANCEPLAN;
            }
            if ("Invoice".equals(codeString)) {
                return FHIRType.INVOICE;
            }
            if ("Library".equals(codeString)) {
                return FHIRType.LIBRARY;
            }
            if ("Linkage".equals(codeString)) {
                return FHIRType.LINKAGE;
            }
            if ("List".equals(codeString)) {
                return FHIRType.LIST;
            }
            if ("Location".equals(codeString)) {
                return FHIRType.LOCATION;
            }
            if ("ManufacturedItemDefinition".equals(codeString)) {
                return FHIRType.MANUFACTUREDITEMDEFINITION;
            }
            if ("Measure".equals(codeString)) {
                return FHIRType.MEASURE;
            }
            if ("MeasureReport".equals(codeString)) {
                return FHIRType.MEASUREREPORT;
            }
            if ("Medication".equals(codeString)) {
                return FHIRType.MEDICATION;
            }
            if ("MedicationAdministration".equals(codeString)) {
                return FHIRType.MEDICATIONADMINISTRATION;
            }
            if ("MedicationDispense".equals(codeString)) {
                return FHIRType.MEDICATIONDISPENSE;
            }
            if ("MedicationKnowledge".equals(codeString)) {
                return FHIRType.MEDICATIONKNOWLEDGE;
            }
            if ("MedicationRequest".equals(codeString)) {
                return FHIRType.MEDICATIONREQUEST;
            }
            if ("MedicationUsage".equals(codeString)) {
                return FHIRType.MEDICATIONUSAGE;
            }
            if ("MedicinalProductDefinition".equals(codeString)) {
                return FHIRType.MEDICINALPRODUCTDEFINITION;
            }
            if ("MessageDefinition".equals(codeString)) {
                return FHIRType.MESSAGEDEFINITION;
            }
            if ("MessageHeader".equals(codeString)) {
                return FHIRType.MESSAGEHEADER;
            }
            if ("MolecularSequence".equals(codeString)) {
                return FHIRType.MOLECULARSEQUENCE;
            }
            if ("NamingSystem".equals(codeString)) {
                return FHIRType.NAMINGSYSTEM;
            }
            if ("NutritionIntake".equals(codeString)) {
                return FHIRType.NUTRITIONINTAKE;
            }
            if ("NutritionOrder".equals(codeString)) {
                return FHIRType.NUTRITIONORDER;
            }
            if ("Observation".equals(codeString)) {
                return FHIRType.OBSERVATION;
            }
            if ("ObservationDefinition".equals(codeString)) {
                return FHIRType.OBSERVATIONDEFINITION;
            }
            if ("OperationDefinition".equals(codeString)) {
                return FHIRType.OPERATIONDEFINITION;
            }
            if ("OperationOutcome".equals(codeString)) {
                return FHIRType.OPERATIONOUTCOME;
            }
            if ("Organization".equals(codeString)) {
                return FHIRType.ORGANIZATION;
            }
            if ("OrganizationAffiliation".equals(codeString)) {
                return FHIRType.ORGANIZATIONAFFILIATION;
            }
            if ("PackagedProductDefinition".equals(codeString)) {
                return FHIRType.PACKAGEDPRODUCTDEFINITION;
            }
            if ("Parameters".equals(codeString)) {
                return FHIRType.PARAMETERS;
            }
            if ("Patient".equals(codeString)) {
                return FHIRType.PATIENT;
            }
            if ("PaymentNotice".equals(codeString)) {
                return FHIRType.PAYMENTNOTICE;
            }
            if ("PaymentReconciliation".equals(codeString)) {
                return FHIRType.PAYMENTRECONCILIATION;
            }
            if ("Person".equals(codeString)) {
                return FHIRType.PERSON;
            }
            if ("PlanDefinition".equals(codeString)) {
                return FHIRType.PLANDEFINITION;
            }
            if ("Practitioner".equals(codeString)) {
                return FHIRType.PRACTITIONER;
            }
            if ("PractitionerRole".equals(codeString)) {
                return FHIRType.PRACTITIONERROLE;
            }
            if ("Procedure".equals(codeString)) {
                return FHIRType.PROCEDURE;
            }
            if ("Provenance".equals(codeString)) {
                return FHIRType.PROVENANCE;
            }
            if ("Questionnaire".equals(codeString)) {
                return FHIRType.QUESTIONNAIRE;
            }
            if ("QuestionnaireResponse".equals(codeString)) {
                return FHIRType.QUESTIONNAIRERESPONSE;
            }
            if ("RegulatedAuthorization".equals(codeString)) {
                return FHIRType.REGULATEDAUTHORIZATION;
            }
            if ("RelatedPerson".equals(codeString)) {
                return FHIRType.RELATEDPERSON;
            }
            if ("RequestGroup".equals(codeString)) {
                return FHIRType.REQUESTGROUP;
            }
            if ("ResearchStudy".equals(codeString)) {
                return FHIRType.RESEARCHSTUDY;
            }
            if ("ResearchSubject".equals(codeString)) {
                return FHIRType.RESEARCHSUBJECT;
            }
            if ("Resource".equals(codeString)) {
                return FHIRType.RESOURCE;
            }
            if ("RiskAssessment".equals(codeString)) {
                return FHIRType.RISKASSESSMENT;
            }
            if ("Schedule".equals(codeString)) {
                return FHIRType.SCHEDULE;
            }
            if ("SearchParameter".equals(codeString)) {
                return FHIRType.SEARCHPARAMETER;
            }
            if ("ServiceRequest".equals(codeString)) {
                return FHIRType.SERVICEREQUEST;
            }
            if ("Slot".equals(codeString)) {
                return FHIRType.SLOT;
            }
            if ("Specimen".equals(codeString)) {
                return FHIRType.SPECIMEN;
            }
            if ("SpecimenDefinition".equals(codeString)) {
                return FHIRType.SPECIMENDEFINITION;
            }
            if ("StructureDefinition".equals(codeString)) {
                return FHIRType.STRUCTUREDEFINITION;
            }
            if ("StructureMap".equals(codeString)) {
                return FHIRType.STRUCTUREMAP;
            }
            if ("Subscription".equals(codeString)) {
                return FHIRType.SUBSCRIPTION;
            }
            if ("Substance".equals(codeString)) {
                return FHIRType.SUBSTANCE;
            }
            if ("SubstanceDefinition".equals(codeString)) {
                return FHIRType.SUBSTANCEDEFINITION;
            }
            if ("SubstanceNucleicAcid".equals(codeString)) {
                return FHIRType.SUBSTANCENUCLEICACID;
            }
            if ("SubstancePolymer".equals(codeString)) {
                return FHIRType.SUBSTANCEPOLYMER;
            }
            if ("SubstanceProtein".equals(codeString)) {
                return FHIRType.SUBSTANCEPROTEIN;
            }
            if ("SubstanceReferenceInformation".equals(codeString)) {
                return FHIRType.SUBSTANCEREFERENCEINFORMATION;
            }
            if ("SubstanceSourceMaterial".equals(codeString)) {
                return FHIRType.SUBSTANCESOURCEMATERIAL;
            }
            if ("SupplyDelivery".equals(codeString)) {
                return FHIRType.SUPPLYDELIVERY;
            }
            if ("SupplyRequest".equals(codeString)) {
                return FHIRType.SUPPLYREQUEST;
            }
            if ("Task".equals(codeString)) {
                return FHIRType.TASK;
            }
            if ("TerminologyCapabilities".equals(codeString)) {
                return FHIRType.TERMINOLOGYCAPABILITIES;
            }
            if ("TestReport".equals(codeString)) {
                return FHIRType.TESTREPORT;
            }
            if ("TestScript".equals(codeString)) {
                return FHIRType.TESTSCRIPT;
            }
            if ("Topic".equals(codeString)) {
                return FHIRType.TOPIC;
            }
            if ("ValueSet".equals(codeString)) {
                return FHIRType.VALUESET;
            }
            if ("VerificationResult".equals(codeString)) {
                return FHIRType.VERIFICATIONRESULT;
            }
            if ("VisionPrescription".equals(codeString)) {
                return FHIRType.VISIONPRESCRIPTION;
            }
            throw new IllegalArgumentException("Unknown FHIRType code '" + codeString + "'");
        }

        public Enumeration<FHIRType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<FHIRType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Account".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.ACCOUNT);
            }
            if ("ActivityDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.ACTIVITYDEFINITION);
            }
            if ("AdministrableProductDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.ADMINISTRABLEPRODUCTDEFINITION);
            }
            if ("AdverseEvent".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.ADVERSEEVENT);
            }
            if ("AllergyIntolerance".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.ALLERGYINTOLERANCE);
            }
            if ("Appointment".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.APPOINTMENT);
            }
            if ("AppointmentResponse".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.APPOINTMENTRESPONSE);
            }
            if ("AuditEvent".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.AUDITEVENT);
            }
            if ("Basic".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.BASIC);
            }
            if ("Binary".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.BINARY);
            }
            if ("BiologicallyDerivedProduct".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.BIOLOGICALLYDERIVEDPRODUCT);
            }
            if ("BodyStructure".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.BODYSTRUCTURE);
            }
            if ("Bundle".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.BUNDLE);
            }
            if ("CapabilityStatement".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CAPABILITYSTATEMENT);
            }
            if ("CapabilityStatement2".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CAPABILITYSTATEMENT2);
            }
            if ("CarePlan".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CAREPLAN);
            }
            if ("CareTeam".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CARETEAM);
            }
            if ("CatalogEntry".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CATALOGENTRY);
            }
            if ("ChargeItem".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CHARGEITEM);
            }
            if ("ChargeItemDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CHARGEITEMDEFINITION);
            }
            if ("Claim".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CLAIM);
            }
            if ("ClaimResponse".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CLAIMRESPONSE);
            }
            if ("ClinicalImpression".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CLINICALIMPRESSION);
            }
            if ("ClinicalUseIssue".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CLINICALUSEISSUE);
            }
            if ("CodeSystem".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CODESYSTEM);
            }
            if ("Communication".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.COMMUNICATION);
            }
            if ("CommunicationRequest".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.COMMUNICATIONREQUEST);
            }
            if ("CompartmentDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.COMPARTMENTDEFINITION);
            }
            if ("Composition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.COMPOSITION);
            }
            if ("ConceptMap".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CONCEPTMAP);
            }
            if ("Condition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CONDITION);
            }
            if ("ConditionDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CONDITIONDEFINITION);
            }
            if ("Consent".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CONSENT);
            }
            if ("Contract".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.CONTRACT);
            }
            if ("Coverage".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.COVERAGE);
            }
            if ("CoverageEligibilityRequest".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.COVERAGEELIGIBILITYREQUEST);
            }
            if ("CoverageEligibilityResponse".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.COVERAGEELIGIBILITYRESPONSE);
            }
            if ("DetectedIssue".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.DETECTEDISSUE);
            }
            if ("Device".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.DEVICE);
            }
            if ("DeviceDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.DEVICEDEFINITION);
            }
            if ("DeviceMetric".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.DEVICEMETRIC);
            }
            if ("DeviceRequest".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.DEVICEREQUEST);
            }
            if ("DeviceUseStatement".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.DEVICEUSESTATEMENT);
            }
            if ("DiagnosticReport".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.DIAGNOSTICREPORT);
            }
            if ("DocumentManifest".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.DOCUMENTMANIFEST);
            }
            if ("DocumentReference".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.DOCUMENTREFERENCE);
            }
            if ("DomainResource".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.DOMAINRESOURCE);
            }
            if ("Encounter".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.ENCOUNTER);
            }
            if ("Endpoint".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.ENDPOINT);
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.ENROLLMENTREQUEST);
            }
            if ("EnrollmentResponse".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.ENROLLMENTRESPONSE);
            }
            if ("EpisodeOfCare".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.EPISODEOFCARE);
            }
            if ("EventDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.EVENTDEFINITION);
            }
            if ("Evidence".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.EVIDENCE);
            }
            if ("EvidenceVariable".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.EVIDENCEVARIABLE);
            }
            if ("ExampleScenario".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.EXAMPLESCENARIO);
            }
            if ("ExplanationOfBenefit".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.EXPLANATIONOFBENEFIT);
            }
            if ("FamilyMemberHistory".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.FAMILYMEMBERHISTORY);
            }
            if ("Flag".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.FLAG);
            }
            if ("Goal".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.GOAL);
            }
            if ("GraphDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.GRAPHDEFINITION);
            }
            if ("Group".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.GROUP);
            }
            if ("GuidanceResponse".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.GUIDANCERESPONSE);
            }
            if ("HealthcareService".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.HEALTHCARESERVICE);
            }
            if ("ImagingStudy".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.IMAGINGSTUDY);
            }
            if ("Immunization".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.IMMUNIZATION);
            }
            if ("ImmunizationEvaluation".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.IMMUNIZATIONEVALUATION);
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.IMMUNIZATIONRECOMMENDATION);
            }
            if ("ImplementationGuide".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.IMPLEMENTATIONGUIDE);
            }
            if ("Ingredient".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.INGREDIENT);
            }
            if ("InsurancePlan".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.INSURANCEPLAN);
            }
            if ("Invoice".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.INVOICE);
            }
            if ("Library".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.LIBRARY);
            }
            if ("Linkage".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.LINKAGE);
            }
            if ("List".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.LIST);
            }
            if ("Location".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.LOCATION);
            }
            if ("ManufacturedItemDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MANUFACTUREDITEMDEFINITION);
            }
            if ("Measure".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MEASURE);
            }
            if ("MeasureReport".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MEASUREREPORT);
            }
            if ("Medication".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MEDICATION);
            }
            if ("MedicationAdministration".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MEDICATIONADMINISTRATION);
            }
            if ("MedicationDispense".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MEDICATIONDISPENSE);
            }
            if ("MedicationKnowledge".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MEDICATIONKNOWLEDGE);
            }
            if ("MedicationRequest".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MEDICATIONREQUEST);
            }
            if ("MedicationUsage".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MEDICATIONUSAGE);
            }
            if ("MedicinalProductDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MEDICINALPRODUCTDEFINITION);
            }
            if ("MessageDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MESSAGEDEFINITION);
            }
            if ("MessageHeader".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MESSAGEHEADER);
            }
            if ("MolecularSequence".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.MOLECULARSEQUENCE);
            }
            if ("NamingSystem".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.NAMINGSYSTEM);
            }
            if ("NutritionIntake".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.NUTRITIONINTAKE);
            }
            if ("NutritionOrder".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.NUTRITIONORDER);
            }
            if ("Observation".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.OBSERVATION);
            }
            if ("ObservationDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.OBSERVATIONDEFINITION);
            }
            if ("OperationDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.OPERATIONDEFINITION);
            }
            if ("OperationOutcome".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.OPERATIONOUTCOME);
            }
            if ("Organization".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.ORGANIZATION);
            }
            if ("OrganizationAffiliation".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.ORGANIZATIONAFFILIATION);
            }
            if ("PackagedProductDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.PACKAGEDPRODUCTDEFINITION);
            }
            if ("Parameters".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.PARAMETERS);
            }
            if ("Patient".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.PATIENT);
            }
            if ("PaymentNotice".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.PAYMENTNOTICE);
            }
            if ("PaymentReconciliation".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.PAYMENTRECONCILIATION);
            }
            if ("Person".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.PERSON);
            }
            if ("PlanDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.PLANDEFINITION);
            }
            if ("Practitioner".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.PRACTITIONER);
            }
            if ("PractitionerRole".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.PRACTITIONERROLE);
            }
            if ("Procedure".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.PROCEDURE);
            }
            if ("Provenance".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.PROVENANCE);
            }
            if ("Questionnaire".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.QUESTIONNAIRE);
            }
            if ("QuestionnaireResponse".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.QUESTIONNAIRERESPONSE);
            }
            if ("RegulatedAuthorization".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.REGULATEDAUTHORIZATION);
            }
            if ("RelatedPerson".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.RELATEDPERSON);
            }
            if ("RequestGroup".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.REQUESTGROUP);
            }
            if ("ResearchStudy".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.RESEARCHSTUDY);
            }
            if ("ResearchSubject".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.RESEARCHSUBJECT);
            }
            if ("Resource".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.RESOURCE);
            }
            if ("RiskAssessment".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.RISKASSESSMENT);
            }
            if ("Schedule".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SCHEDULE);
            }
            if ("SearchParameter".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SEARCHPARAMETER);
            }
            if ("ServiceRequest".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SERVICEREQUEST);
            }
            if ("Slot".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SLOT);
            }
            if ("Specimen".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SPECIMEN);
            }
            if ("SpecimenDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SPECIMENDEFINITION);
            }
            if ("StructureDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.STRUCTUREDEFINITION);
            }
            if ("StructureMap".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.STRUCTUREMAP);
            }
            if ("Subscription".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SUBSCRIPTION);
            }
            if ("Substance".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SUBSTANCE);
            }
            if ("SubstanceDefinition".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SUBSTANCEDEFINITION);
            }
            if ("SubstanceNucleicAcid".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SUBSTANCENUCLEICACID);
            }
            if ("SubstancePolymer".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SUBSTANCEPOLYMER);
            }
            if ("SubstanceProtein".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SUBSTANCEPROTEIN);
            }
            if ("SubstanceReferenceInformation".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SUBSTANCEREFERENCEINFORMATION);
            }
            if ("SubstanceSourceMaterial".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SUBSTANCESOURCEMATERIAL);
            }
            if ("SupplyDelivery".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SUPPLYDELIVERY);
            }
            if ("SupplyRequest".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.SUPPLYREQUEST);
            }
            if ("Task".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.TASK);
            }
            if ("TerminologyCapabilities".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.TERMINOLOGYCAPABILITIES);
            }
            if ("TestReport".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.TESTREPORT);
            }
            if ("TestScript".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.TESTSCRIPT);
            }
            if ("Topic".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.TOPIC);
            }
            if ("ValueSet".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.VALUESET);
            }
            if ("VerificationResult".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.VERIFICATIONRESULT);
            }
            if ("VisionPrescription".equals(codeString)) {
                return new Enumeration<FHIRType>(this, FHIRType.VISIONPRESCRIPTION);
            }
            throw new FHIRException("Unknown FHIRType code '" + codeString + "'");
        }

        @Override
        public String toCode(FHIRType code) {
            if (code == FHIRType.ACCOUNT) {
                return "Account";
            }
            if (code == FHIRType.ACTIVITYDEFINITION) {
                return "ActivityDefinition";
            }
            if (code == FHIRType.ADMINISTRABLEPRODUCTDEFINITION) {
                return "AdministrableProductDefinition";
            }
            if (code == FHIRType.ADVERSEEVENT) {
                return "AdverseEvent";
            }
            if (code == FHIRType.ALLERGYINTOLERANCE) {
                return "AllergyIntolerance";
            }
            if (code == FHIRType.APPOINTMENT) {
                return "Appointment";
            }
            if (code == FHIRType.APPOINTMENTRESPONSE) {
                return "AppointmentResponse";
            }
            if (code == FHIRType.AUDITEVENT) {
                return "AuditEvent";
            }
            if (code == FHIRType.BASIC) {
                return "Basic";
            }
            if (code == FHIRType.BINARY) {
                return "Binary";
            }
            if (code == FHIRType.BIOLOGICALLYDERIVEDPRODUCT) {
                return "BiologicallyDerivedProduct";
            }
            if (code == FHIRType.BODYSTRUCTURE) {
                return "BodyStructure";
            }
            if (code == FHIRType.BUNDLE) {
                return "Bundle";
            }
            if (code == FHIRType.CAPABILITYSTATEMENT) {
                return "CapabilityStatement";
            }
            if (code == FHIRType.CAPABILITYSTATEMENT2) {
                return "CapabilityStatement2";
            }
            if (code == FHIRType.CAREPLAN) {
                return "CarePlan";
            }
            if (code == FHIRType.CARETEAM) {
                return "CareTeam";
            }
            if (code == FHIRType.CATALOGENTRY) {
                return "CatalogEntry";
            }
            if (code == FHIRType.CHARGEITEM) {
                return "ChargeItem";
            }
            if (code == FHIRType.CHARGEITEMDEFINITION) {
                return "ChargeItemDefinition";
            }
            if (code == FHIRType.CLAIM) {
                return "Claim";
            }
            if (code == FHIRType.CLAIMRESPONSE) {
                return "ClaimResponse";
            }
            if (code == FHIRType.CLINICALIMPRESSION) {
                return "ClinicalImpression";
            }
            if (code == FHIRType.CLINICALUSEISSUE) {
                return "ClinicalUseIssue";
            }
            if (code == FHIRType.CODESYSTEM) {
                return "CodeSystem";
            }
            if (code == FHIRType.COMMUNICATION) {
                return "Communication";
            }
            if (code == FHIRType.COMMUNICATIONREQUEST) {
                return "CommunicationRequest";
            }
            if (code == FHIRType.COMPARTMENTDEFINITION) {
                return "CompartmentDefinition";
            }
            if (code == FHIRType.COMPOSITION) {
                return "Composition";
            }
            if (code == FHIRType.CONCEPTMAP) {
                return "ConceptMap";
            }
            if (code == FHIRType.CONDITION) {
                return "Condition";
            }
            if (code == FHIRType.CONDITIONDEFINITION) {
                return "ConditionDefinition";
            }
            if (code == FHIRType.CONSENT) {
                return "Consent";
            }
            if (code == FHIRType.CONTRACT) {
                return "Contract";
            }
            if (code == FHIRType.COVERAGE) {
                return "Coverage";
            }
            if (code == FHIRType.COVERAGEELIGIBILITYREQUEST) {
                return "CoverageEligibilityRequest";
            }
            if (code == FHIRType.COVERAGEELIGIBILITYRESPONSE) {
                return "CoverageEligibilityResponse";
            }
            if (code == FHIRType.DETECTEDISSUE) {
                return "DetectedIssue";
            }
            if (code == FHIRType.DEVICE) {
                return "Device";
            }
            if (code == FHIRType.DEVICEDEFINITION) {
                return "DeviceDefinition";
            }
            if (code == FHIRType.DEVICEMETRIC) {
                return "DeviceMetric";
            }
            if (code == FHIRType.DEVICEREQUEST) {
                return "DeviceRequest";
            }
            if (code == FHIRType.DEVICEUSESTATEMENT) {
                return "DeviceUseStatement";
            }
            if (code == FHIRType.DIAGNOSTICREPORT) {
                return "DiagnosticReport";
            }
            if (code == FHIRType.DOCUMENTMANIFEST) {
                return "DocumentManifest";
            }
            if (code == FHIRType.DOCUMENTREFERENCE) {
                return "DocumentReference";
            }
            if (code == FHIRType.DOMAINRESOURCE) {
                return "DomainResource";
            }
            if (code == FHIRType.ENCOUNTER) {
                return "Encounter";
            }
            if (code == FHIRType.ENDPOINT) {
                return "Endpoint";
            }
            if (code == FHIRType.ENROLLMENTREQUEST) {
                return "EnrollmentRequest";
            }
            if (code == FHIRType.ENROLLMENTRESPONSE) {
                return "EnrollmentResponse";
            }
            if (code == FHIRType.EPISODEOFCARE) {
                return "EpisodeOfCare";
            }
            if (code == FHIRType.EVENTDEFINITION) {
                return "EventDefinition";
            }
            if (code == FHIRType.EVIDENCE) {
                return "Evidence";
            }
            if (code == FHIRType.EVIDENCEVARIABLE) {
                return "EvidenceVariable";
            }
            if (code == FHIRType.EXAMPLESCENARIO) {
                return "ExampleScenario";
            }
            if (code == FHIRType.EXPLANATIONOFBENEFIT) {
                return "ExplanationOfBenefit";
            }
            if (code == FHIRType.FAMILYMEMBERHISTORY) {
                return "FamilyMemberHistory";
            }
            if (code == FHIRType.FLAG) {
                return "Flag";
            }
            if (code == FHIRType.GOAL) {
                return "Goal";
            }
            if (code == FHIRType.GRAPHDEFINITION) {
                return "GraphDefinition";
            }
            if (code == FHIRType.GROUP) {
                return "Group";
            }
            if (code == FHIRType.GUIDANCERESPONSE) {
                return "GuidanceResponse";
            }
            if (code == FHIRType.HEALTHCARESERVICE) {
                return "HealthcareService";
            }
            if (code == FHIRType.IMAGINGSTUDY) {
                return "ImagingStudy";
            }
            if (code == FHIRType.IMMUNIZATION) {
                return "Immunization";
            }
            if (code == FHIRType.IMMUNIZATIONEVALUATION) {
                return "ImmunizationEvaluation";
            }
            if (code == FHIRType.IMMUNIZATIONRECOMMENDATION) {
                return "ImmunizationRecommendation";
            }
            if (code == FHIRType.IMPLEMENTATIONGUIDE) {
                return "ImplementationGuide";
            }
            if (code == FHIRType.INGREDIENT) {
                return "Ingredient";
            }
            if (code == FHIRType.INSURANCEPLAN) {
                return "InsurancePlan";
            }
            if (code == FHIRType.INVOICE) {
                return "Invoice";
            }
            if (code == FHIRType.LIBRARY) {
                return "Library";
            }
            if (code == FHIRType.LINKAGE) {
                return "Linkage";
            }
            if (code == FHIRType.LIST) {
                return "List";
            }
            if (code == FHIRType.LOCATION) {
                return "Location";
            }
            if (code == FHIRType.MANUFACTUREDITEMDEFINITION) {
                return "ManufacturedItemDefinition";
            }
            if (code == FHIRType.MEASURE) {
                return "Measure";
            }
            if (code == FHIRType.MEASUREREPORT) {
                return "MeasureReport";
            }
            if (code == FHIRType.MEDICATION) {
                return "Medication";
            }
            if (code == FHIRType.MEDICATIONADMINISTRATION) {
                return "MedicationAdministration";
            }
            if (code == FHIRType.MEDICATIONDISPENSE) {
                return "MedicationDispense";
            }
            if (code == FHIRType.MEDICATIONKNOWLEDGE) {
                return "MedicationKnowledge";
            }
            if (code == FHIRType.MEDICATIONREQUEST) {
                return "MedicationRequest";
            }
            if (code == FHIRType.MEDICATIONUSAGE) {
                return "MedicationUsage";
            }
            if (code == FHIRType.MEDICINALPRODUCTDEFINITION) {
                return "MedicinalProductDefinition";
            }
            if (code == FHIRType.MESSAGEDEFINITION) {
                return "MessageDefinition";
            }
            if (code == FHIRType.MESSAGEHEADER) {
                return "MessageHeader";
            }
            if (code == FHIRType.MOLECULARSEQUENCE) {
                return "MolecularSequence";
            }
            if (code == FHIRType.NAMINGSYSTEM) {
                return "NamingSystem";
            }
            if (code == FHIRType.NUTRITIONINTAKE) {
                return "NutritionIntake";
            }
            if (code == FHIRType.NUTRITIONORDER) {
                return "NutritionOrder";
            }
            if (code == FHIRType.OBSERVATION) {
                return "Observation";
            }
            if (code == FHIRType.OBSERVATIONDEFINITION) {
                return "ObservationDefinition";
            }
            if (code == FHIRType.OPERATIONDEFINITION) {
                return "OperationDefinition";
            }
            if (code == FHIRType.OPERATIONOUTCOME) {
                return "OperationOutcome";
            }
            if (code == FHIRType.ORGANIZATION) {
                return "Organization";
            }
            if (code == FHIRType.ORGANIZATIONAFFILIATION) {
                return "OrganizationAffiliation";
            }
            if (code == FHIRType.PACKAGEDPRODUCTDEFINITION) {
                return "PackagedProductDefinition";
            }
            if (code == FHIRType.PARAMETERS) {
                return "Parameters";
            }
            if (code == FHIRType.PATIENT) {
                return "Patient";
            }
            if (code == FHIRType.PAYMENTNOTICE) {
                return "PaymentNotice";
            }
            if (code == FHIRType.PAYMENTRECONCILIATION) {
                return "PaymentReconciliation";
            }
            if (code == FHIRType.PERSON) {
                return "Person";
            }
            if (code == FHIRType.PLANDEFINITION) {
                return "PlanDefinition";
            }
            if (code == FHIRType.PRACTITIONER) {
                return "Practitioner";
            }
            if (code == FHIRType.PRACTITIONERROLE) {
                return "PractitionerRole";
            }
            if (code == FHIRType.PROCEDURE) {
                return "Procedure";
            }
            if (code == FHIRType.PROVENANCE) {
                return "Provenance";
            }
            if (code == FHIRType.QUESTIONNAIRE) {
                return "Questionnaire";
            }
            if (code == FHIRType.QUESTIONNAIRERESPONSE) {
                return "QuestionnaireResponse";
            }
            if (code == FHIRType.REGULATEDAUTHORIZATION) {
                return "RegulatedAuthorization";
            }
            if (code == FHIRType.RELATEDPERSON) {
                return "RelatedPerson";
            }
            if (code == FHIRType.REQUESTGROUP) {
                return "RequestGroup";
            }
            if (code == FHIRType.RESEARCHSTUDY) {
                return "ResearchStudy";
            }
            if (code == FHIRType.RESEARCHSUBJECT) {
                return "ResearchSubject";
            }
            if (code == FHIRType.RESOURCE) {
                return "Resource";
            }
            if (code == FHIRType.RISKASSESSMENT) {
                return "RiskAssessment";
            }
            if (code == FHIRType.SCHEDULE) {
                return "Schedule";
            }
            if (code == FHIRType.SEARCHPARAMETER) {
                return "SearchParameter";
            }
            if (code == FHIRType.SERVICEREQUEST) {
                return "ServiceRequest";
            }
            if (code == FHIRType.SLOT) {
                return "Slot";
            }
            if (code == FHIRType.SPECIMEN) {
                return "Specimen";
            }
            if (code == FHIRType.SPECIMENDEFINITION) {
                return "SpecimenDefinition";
            }
            if (code == FHIRType.STRUCTUREDEFINITION) {
                return "StructureDefinition";
            }
            if (code == FHIRType.STRUCTUREMAP) {
                return "StructureMap";
            }
            if (code == FHIRType.SUBSCRIPTION) {
                return "Subscription";
            }
            if (code == FHIRType.SUBSTANCE) {
                return "Substance";
            }
            if (code == FHIRType.SUBSTANCEDEFINITION) {
                return "SubstanceDefinition";
            }
            if (code == FHIRType.SUBSTANCENUCLEICACID) {
                return "SubstanceNucleicAcid";
            }
            if (code == FHIRType.SUBSTANCEPOLYMER) {
                return "SubstancePolymer";
            }
            if (code == FHIRType.SUBSTANCEPROTEIN) {
                return "SubstanceProtein";
            }
            if (code == FHIRType.SUBSTANCEREFERENCEINFORMATION) {
                return "SubstanceReferenceInformation";
            }
            if (code == FHIRType.SUBSTANCESOURCEMATERIAL) {
                return "SubstanceSourceMaterial";
            }
            if (code == FHIRType.SUPPLYDELIVERY) {
                return "SupplyDelivery";
            }
            if (code == FHIRType.SUPPLYREQUEST) {
                return "SupplyRequest";
            }
            if (code == FHIRType.TASK) {
                return "Task";
            }
            if (code == FHIRType.TERMINOLOGYCAPABILITIES) {
                return "TerminologyCapabilities";
            }
            if (code == FHIRType.TESTREPORT) {
                return "TestReport";
            }
            if (code == FHIRType.TESTSCRIPT) {
                return "TestScript";
            }
            if (code == FHIRType.TOPIC) {
                return "Topic";
            }
            if (code == FHIRType.VALUESET) {
                return "ValueSet";
            }
            if (code == FHIRType.VERIFICATIONRESULT) {
                return "VerificationResult";
            }
            if (code == FHIRType.VISIONPRESCRIPTION) {
                return "VisionPrescription";
            }
            return "?";
        }

        @Override
        public String toSystem(FHIRType code) {
            return code.getSystem();
        }
    }

    public static enum FHIRType {
        ACCOUNT,
        ACTIVITYDEFINITION,
        ADMINISTRABLEPRODUCTDEFINITION,
        ADVERSEEVENT,
        ALLERGYINTOLERANCE,
        APPOINTMENT,
        APPOINTMENTRESPONSE,
        AUDITEVENT,
        BASIC,
        BINARY,
        BIOLOGICALLYDERIVEDPRODUCT,
        BODYSTRUCTURE,
        BUNDLE,
        CAPABILITYSTATEMENT,
        CAPABILITYSTATEMENT2,
        CAREPLAN,
        CARETEAM,
        CATALOGENTRY,
        CHARGEITEM,
        CHARGEITEMDEFINITION,
        CLAIM,
        CLAIMRESPONSE,
        CLINICALIMPRESSION,
        CLINICALUSEISSUE,
        CODESYSTEM,
        COMMUNICATION,
        COMMUNICATIONREQUEST,
        COMPARTMENTDEFINITION,
        COMPOSITION,
        CONCEPTMAP,
        CONDITION,
        CONDITIONDEFINITION,
        CONSENT,
        CONTRACT,
        COVERAGE,
        COVERAGEELIGIBILITYREQUEST,
        COVERAGEELIGIBILITYRESPONSE,
        DETECTEDISSUE,
        DEVICE,
        DEVICEDEFINITION,
        DEVICEMETRIC,
        DEVICEREQUEST,
        DEVICEUSESTATEMENT,
        DIAGNOSTICREPORT,
        DOCUMENTMANIFEST,
        DOCUMENTREFERENCE,
        DOMAINRESOURCE,
        ENCOUNTER,
        ENDPOINT,
        ENROLLMENTREQUEST,
        ENROLLMENTRESPONSE,
        EPISODEOFCARE,
        EVENTDEFINITION,
        EVIDENCE,
        EVIDENCEVARIABLE,
        EXAMPLESCENARIO,
        EXPLANATIONOFBENEFIT,
        FAMILYMEMBERHISTORY,
        FLAG,
        GOAL,
        GRAPHDEFINITION,
        GROUP,
        GUIDANCERESPONSE,
        HEALTHCARESERVICE,
        IMAGINGSTUDY,
        IMMUNIZATION,
        IMMUNIZATIONEVALUATION,
        IMMUNIZATIONRECOMMENDATION,
        IMPLEMENTATIONGUIDE,
        INGREDIENT,
        INSURANCEPLAN,
        INVOICE,
        LIBRARY,
        LINKAGE,
        LIST,
        LOCATION,
        MANUFACTUREDITEMDEFINITION,
        MEASURE,
        MEASUREREPORT,
        MEDICATION,
        MEDICATIONADMINISTRATION,
        MEDICATIONDISPENSE,
        MEDICATIONKNOWLEDGE,
        MEDICATIONREQUEST,
        MEDICATIONUSAGE,
        MEDICINALPRODUCTDEFINITION,
        MESSAGEDEFINITION,
        MESSAGEHEADER,
        MOLECULARSEQUENCE,
        NAMINGSYSTEM,
        NUTRITIONINTAKE,
        NUTRITIONORDER,
        OBSERVATION,
        OBSERVATIONDEFINITION,
        OPERATIONDEFINITION,
        OPERATIONOUTCOME,
        ORGANIZATION,
        ORGANIZATIONAFFILIATION,
        PACKAGEDPRODUCTDEFINITION,
        PARAMETERS,
        PATIENT,
        PAYMENTNOTICE,
        PAYMENTRECONCILIATION,
        PERSON,
        PLANDEFINITION,
        PRACTITIONER,
        PRACTITIONERROLE,
        PROCEDURE,
        PROVENANCE,
        QUESTIONNAIRE,
        QUESTIONNAIRERESPONSE,
        REGULATEDAUTHORIZATION,
        RELATEDPERSON,
        REQUESTGROUP,
        RESEARCHSTUDY,
        RESEARCHSUBJECT,
        RESOURCE,
        RISKASSESSMENT,
        SCHEDULE,
        SEARCHPARAMETER,
        SERVICEREQUEST,
        SLOT,
        SPECIMEN,
        SPECIMENDEFINITION,
        STRUCTUREDEFINITION,
        STRUCTUREMAP,
        SUBSCRIPTION,
        SUBSTANCE,
        SUBSTANCEDEFINITION,
        SUBSTANCENUCLEICACID,
        SUBSTANCEPOLYMER,
        SUBSTANCEPROTEIN,
        SUBSTANCEREFERENCEINFORMATION,
        SUBSTANCESOURCEMATERIAL,
        SUPPLYDELIVERY,
        SUPPLYREQUEST,
        TASK,
        TERMINOLOGYCAPABILITIES,
        TESTREPORT,
        TESTSCRIPT,
        TOPIC,
        VALUESET,
        VERIFICATIONRESULT,
        VISIONPRESCRIPTION,
        NULL;


        public static FHIRType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Account".equals(codeString)) {
                return ACCOUNT;
            }
            if ("ActivityDefinition".equals(codeString)) {
                return ACTIVITYDEFINITION;
            }
            if ("AdministrableProductDefinition".equals(codeString)) {
                return ADMINISTRABLEPRODUCTDEFINITION;
            }
            if ("AdverseEvent".equals(codeString)) {
                return ADVERSEEVENT;
            }
            if ("AllergyIntolerance".equals(codeString)) {
                return ALLERGYINTOLERANCE;
            }
            if ("Appointment".equals(codeString)) {
                return APPOINTMENT;
            }
            if ("AppointmentResponse".equals(codeString)) {
                return APPOINTMENTRESPONSE;
            }
            if ("AuditEvent".equals(codeString)) {
                return AUDITEVENT;
            }
            if ("Basic".equals(codeString)) {
                return BASIC;
            }
            if ("Binary".equals(codeString)) {
                return BINARY;
            }
            if ("BiologicallyDerivedProduct".equals(codeString)) {
                return BIOLOGICALLYDERIVEDPRODUCT;
            }
            if ("BodyStructure".equals(codeString)) {
                return BODYSTRUCTURE;
            }
            if ("Bundle".equals(codeString)) {
                return BUNDLE;
            }
            if ("CapabilityStatement".equals(codeString)) {
                return CAPABILITYSTATEMENT;
            }
            if ("CapabilityStatement2".equals(codeString)) {
                return CAPABILITYSTATEMENT2;
            }
            if ("CarePlan".equals(codeString)) {
                return CAREPLAN;
            }
            if ("CareTeam".equals(codeString)) {
                return CARETEAM;
            }
            if ("CatalogEntry".equals(codeString)) {
                return CATALOGENTRY;
            }
            if ("ChargeItem".equals(codeString)) {
                return CHARGEITEM;
            }
            if ("ChargeItemDefinition".equals(codeString)) {
                return CHARGEITEMDEFINITION;
            }
            if ("Claim".equals(codeString)) {
                return CLAIM;
            }
            if ("ClaimResponse".equals(codeString)) {
                return CLAIMRESPONSE;
            }
            if ("ClinicalImpression".equals(codeString)) {
                return CLINICALIMPRESSION;
            }
            if ("ClinicalUseIssue".equals(codeString)) {
                return CLINICALUSEISSUE;
            }
            if ("CodeSystem".equals(codeString)) {
                return CODESYSTEM;
            }
            if ("Communication".equals(codeString)) {
                return COMMUNICATION;
            }
            if ("CommunicationRequest".equals(codeString)) {
                return COMMUNICATIONREQUEST;
            }
            if ("CompartmentDefinition".equals(codeString)) {
                return COMPARTMENTDEFINITION;
            }
            if ("Composition".equals(codeString)) {
                return COMPOSITION;
            }
            if ("ConceptMap".equals(codeString)) {
                return CONCEPTMAP;
            }
            if ("Condition".equals(codeString)) {
                return CONDITION;
            }
            if ("ConditionDefinition".equals(codeString)) {
                return CONDITIONDEFINITION;
            }
            if ("Consent".equals(codeString)) {
                return CONSENT;
            }
            if ("Contract".equals(codeString)) {
                return CONTRACT;
            }
            if ("Coverage".equals(codeString)) {
                return COVERAGE;
            }
            if ("CoverageEligibilityRequest".equals(codeString)) {
                return COVERAGEELIGIBILITYREQUEST;
            }
            if ("CoverageEligibilityResponse".equals(codeString)) {
                return COVERAGEELIGIBILITYRESPONSE;
            }
            if ("DetectedIssue".equals(codeString)) {
                return DETECTEDISSUE;
            }
            if ("Device".equals(codeString)) {
                return DEVICE;
            }
            if ("DeviceDefinition".equals(codeString)) {
                return DEVICEDEFINITION;
            }
            if ("DeviceMetric".equals(codeString)) {
                return DEVICEMETRIC;
            }
            if ("DeviceRequest".equals(codeString)) {
                return DEVICEREQUEST;
            }
            if ("DeviceUseStatement".equals(codeString)) {
                return DEVICEUSESTATEMENT;
            }
            if ("DiagnosticReport".equals(codeString)) {
                return DIAGNOSTICREPORT;
            }
            if ("DocumentManifest".equals(codeString)) {
                return DOCUMENTMANIFEST;
            }
            if ("DocumentReference".equals(codeString)) {
                return DOCUMENTREFERENCE;
            }
            if ("DomainResource".equals(codeString)) {
                return DOMAINRESOURCE;
            }
            if ("Encounter".equals(codeString)) {
                return ENCOUNTER;
            }
            if ("Endpoint".equals(codeString)) {
                return ENDPOINT;
            }
            if ("EnrollmentRequest".equals(codeString)) {
                return ENROLLMENTREQUEST;
            }
            if ("EnrollmentResponse".equals(codeString)) {
                return ENROLLMENTRESPONSE;
            }
            if ("EpisodeOfCare".equals(codeString)) {
                return EPISODEOFCARE;
            }
            if ("EventDefinition".equals(codeString)) {
                return EVENTDEFINITION;
            }
            if ("Evidence".equals(codeString)) {
                return EVIDENCE;
            }
            if ("EvidenceVariable".equals(codeString)) {
                return EVIDENCEVARIABLE;
            }
            if ("ExampleScenario".equals(codeString)) {
                return EXAMPLESCENARIO;
            }
            if ("ExplanationOfBenefit".equals(codeString)) {
                return EXPLANATIONOFBENEFIT;
            }
            if ("FamilyMemberHistory".equals(codeString)) {
                return FAMILYMEMBERHISTORY;
            }
            if ("Flag".equals(codeString)) {
                return FLAG;
            }
            if ("Goal".equals(codeString)) {
                return GOAL;
            }
            if ("GraphDefinition".equals(codeString)) {
                return GRAPHDEFINITION;
            }
            if ("Group".equals(codeString)) {
                return GROUP;
            }
            if ("GuidanceResponse".equals(codeString)) {
                return GUIDANCERESPONSE;
            }
            if ("HealthcareService".equals(codeString)) {
                return HEALTHCARESERVICE;
            }
            if ("ImagingStudy".equals(codeString)) {
                return IMAGINGSTUDY;
            }
            if ("Immunization".equals(codeString)) {
                return IMMUNIZATION;
            }
            if ("ImmunizationEvaluation".equals(codeString)) {
                return IMMUNIZATIONEVALUATION;
            }
            if ("ImmunizationRecommendation".equals(codeString)) {
                return IMMUNIZATIONRECOMMENDATION;
            }
            if ("ImplementationGuide".equals(codeString)) {
                return IMPLEMENTATIONGUIDE;
            }
            if ("Ingredient".equals(codeString)) {
                return INGREDIENT;
            }
            if ("InsurancePlan".equals(codeString)) {
                return INSURANCEPLAN;
            }
            if ("Invoice".equals(codeString)) {
                return INVOICE;
            }
            if ("Library".equals(codeString)) {
                return LIBRARY;
            }
            if ("Linkage".equals(codeString)) {
                return LINKAGE;
            }
            if ("List".equals(codeString)) {
                return LIST;
            }
            if ("Location".equals(codeString)) {
                return LOCATION;
            }
            if ("ManufacturedItemDefinition".equals(codeString)) {
                return MANUFACTUREDITEMDEFINITION;
            }
            if ("Measure".equals(codeString)) {
                return MEASURE;
            }
            if ("MeasureReport".equals(codeString)) {
                return MEASUREREPORT;
            }
            if ("Medication".equals(codeString)) {
                return MEDICATION;
            }
            if ("MedicationAdministration".equals(codeString)) {
                return MEDICATIONADMINISTRATION;
            }
            if ("MedicationDispense".equals(codeString)) {
                return MEDICATIONDISPENSE;
            }
            if ("MedicationKnowledge".equals(codeString)) {
                return MEDICATIONKNOWLEDGE;
            }
            if ("MedicationRequest".equals(codeString)) {
                return MEDICATIONREQUEST;
            }
            if ("MedicationUsage".equals(codeString)) {
                return MEDICATIONUSAGE;
            }
            if ("MedicinalProductDefinition".equals(codeString)) {
                return MEDICINALPRODUCTDEFINITION;
            }
            if ("MessageDefinition".equals(codeString)) {
                return MESSAGEDEFINITION;
            }
            if ("MessageHeader".equals(codeString)) {
                return MESSAGEHEADER;
            }
            if ("MolecularSequence".equals(codeString)) {
                return MOLECULARSEQUENCE;
            }
            if ("NamingSystem".equals(codeString)) {
                return NAMINGSYSTEM;
            }
            if ("NutritionIntake".equals(codeString)) {
                return NUTRITIONINTAKE;
            }
            if ("NutritionOrder".equals(codeString)) {
                return NUTRITIONORDER;
            }
            if ("Observation".equals(codeString)) {
                return OBSERVATION;
            }
            if ("ObservationDefinition".equals(codeString)) {
                return OBSERVATIONDEFINITION;
            }
            if ("OperationDefinition".equals(codeString)) {
                return OPERATIONDEFINITION;
            }
            if ("OperationOutcome".equals(codeString)) {
                return OPERATIONOUTCOME;
            }
            if ("Organization".equals(codeString)) {
                return ORGANIZATION;
            }
            if ("OrganizationAffiliation".equals(codeString)) {
                return ORGANIZATIONAFFILIATION;
            }
            if ("PackagedProductDefinition".equals(codeString)) {
                return PACKAGEDPRODUCTDEFINITION;
            }
            if ("Parameters".equals(codeString)) {
                return PARAMETERS;
            }
            if ("Patient".equals(codeString)) {
                return PATIENT;
            }
            if ("PaymentNotice".equals(codeString)) {
                return PAYMENTNOTICE;
            }
            if ("PaymentReconciliation".equals(codeString)) {
                return PAYMENTRECONCILIATION;
            }
            if ("Person".equals(codeString)) {
                return PERSON;
            }
            if ("PlanDefinition".equals(codeString)) {
                return PLANDEFINITION;
            }
            if ("Practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("PractitionerRole".equals(codeString)) {
                return PRACTITIONERROLE;
            }
            if ("Procedure".equals(codeString)) {
                return PROCEDURE;
            }
            if ("Provenance".equals(codeString)) {
                return PROVENANCE;
            }
            if ("Questionnaire".equals(codeString)) {
                return QUESTIONNAIRE;
            }
            if ("QuestionnaireResponse".equals(codeString)) {
                return QUESTIONNAIRERESPONSE;
            }
            if ("RegulatedAuthorization".equals(codeString)) {
                return REGULATEDAUTHORIZATION;
            }
            if ("RelatedPerson".equals(codeString)) {
                return RELATEDPERSON;
            }
            if ("RequestGroup".equals(codeString)) {
                return REQUESTGROUP;
            }
            if ("ResearchStudy".equals(codeString)) {
                return RESEARCHSTUDY;
            }
            if ("ResearchSubject".equals(codeString)) {
                return RESEARCHSUBJECT;
            }
            if ("Resource".equals(codeString)) {
                return RESOURCE;
            }
            if ("RiskAssessment".equals(codeString)) {
                return RISKASSESSMENT;
            }
            if ("Schedule".equals(codeString)) {
                return SCHEDULE;
            }
            if ("SearchParameter".equals(codeString)) {
                return SEARCHPARAMETER;
            }
            if ("ServiceRequest".equals(codeString)) {
                return SERVICEREQUEST;
            }
            if ("Slot".equals(codeString)) {
                return SLOT;
            }
            if ("Specimen".equals(codeString)) {
                return SPECIMEN;
            }
            if ("SpecimenDefinition".equals(codeString)) {
                return SPECIMENDEFINITION;
            }
            if ("StructureDefinition".equals(codeString)) {
                return STRUCTUREDEFINITION;
            }
            if ("StructureMap".equals(codeString)) {
                return STRUCTUREMAP;
            }
            if ("Subscription".equals(codeString)) {
                return SUBSCRIPTION;
            }
            if ("Substance".equals(codeString)) {
                return SUBSTANCE;
            }
            if ("SubstanceDefinition".equals(codeString)) {
                return SUBSTANCEDEFINITION;
            }
            if ("SubstanceNucleicAcid".equals(codeString)) {
                return SUBSTANCENUCLEICACID;
            }
            if ("SubstancePolymer".equals(codeString)) {
                return SUBSTANCEPOLYMER;
            }
            if ("SubstanceProtein".equals(codeString)) {
                return SUBSTANCEPROTEIN;
            }
            if ("SubstanceReferenceInformation".equals(codeString)) {
                return SUBSTANCEREFERENCEINFORMATION;
            }
            if ("SubstanceSourceMaterial".equals(codeString)) {
                return SUBSTANCESOURCEMATERIAL;
            }
            if ("SupplyDelivery".equals(codeString)) {
                return SUPPLYDELIVERY;
            }
            if ("SupplyRequest".equals(codeString)) {
                return SUPPLYREQUEST;
            }
            if ("Task".equals(codeString)) {
                return TASK;
            }
            if ("TerminologyCapabilities".equals(codeString)) {
                return TERMINOLOGYCAPABILITIES;
            }
            if ("TestReport".equals(codeString)) {
                return TESTREPORT;
            }
            if ("TestScript".equals(codeString)) {
                return TESTSCRIPT;
            }
            if ("Topic".equals(codeString)) {
                return TOPIC;
            }
            if ("ValueSet".equals(codeString)) {
                return VALUESET;
            }
            if ("VerificationResult".equals(codeString)) {
                return VERIFICATIONRESULT;
            }
            if ("VisionPrescription".equals(codeString)) {
                return VISIONPRESCRIPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown FHIRType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACCOUNT: {
                    return "Account";
                }
                case ACTIVITYDEFINITION: {
                    return "ActivityDefinition";
                }
                case ADMINISTRABLEPRODUCTDEFINITION: {
                    return "AdministrableProductDefinition";
                }
                case ADVERSEEVENT: {
                    return "AdverseEvent";
                }
                case ALLERGYINTOLERANCE: {
                    return "AllergyIntolerance";
                }
                case APPOINTMENT: {
                    return "Appointment";
                }
                case APPOINTMENTRESPONSE: {
                    return "AppointmentResponse";
                }
                case AUDITEVENT: {
                    return "AuditEvent";
                }
                case BASIC: {
                    return "Basic";
                }
                case BINARY: {
                    return "Binary";
                }
                case BIOLOGICALLYDERIVEDPRODUCT: {
                    return "BiologicallyDerivedProduct";
                }
                case BODYSTRUCTURE: {
                    return "BodyStructure";
                }
                case BUNDLE: {
                    return "Bundle";
                }
                case CAPABILITYSTATEMENT: {
                    return "CapabilityStatement";
                }
                case CAPABILITYSTATEMENT2: {
                    return "CapabilityStatement2";
                }
                case CAREPLAN: {
                    return "CarePlan";
                }
                case CARETEAM: {
                    return "CareTeam";
                }
                case CATALOGENTRY: {
                    return "CatalogEntry";
                }
                case CHARGEITEM: {
                    return "ChargeItem";
                }
                case CHARGEITEMDEFINITION: {
                    return "ChargeItemDefinition";
                }
                case CLAIM: {
                    return "Claim";
                }
                case CLAIMRESPONSE: {
                    return "ClaimResponse";
                }
                case CLINICALIMPRESSION: {
                    return "ClinicalImpression";
                }
                case CLINICALUSEISSUE: {
                    return "ClinicalUseIssue";
                }
                case CODESYSTEM: {
                    return "CodeSystem";
                }
                case COMMUNICATION: {
                    return "Communication";
                }
                case COMMUNICATIONREQUEST: {
                    return "CommunicationRequest";
                }
                case COMPARTMENTDEFINITION: {
                    return "CompartmentDefinition";
                }
                case COMPOSITION: {
                    return "Composition";
                }
                case CONCEPTMAP: {
                    return "ConceptMap";
                }
                case CONDITION: {
                    return "Condition";
                }
                case CONDITIONDEFINITION: {
                    return "ConditionDefinition";
                }
                case CONSENT: {
                    return "Consent";
                }
                case CONTRACT: {
                    return "Contract";
                }
                case COVERAGE: {
                    return "Coverage";
                }
                case COVERAGEELIGIBILITYREQUEST: {
                    return "CoverageEligibilityRequest";
                }
                case COVERAGEELIGIBILITYRESPONSE: {
                    return "CoverageEligibilityResponse";
                }
                case DETECTEDISSUE: {
                    return "DetectedIssue";
                }
                case DEVICE: {
                    return "Device";
                }
                case DEVICEDEFINITION: {
                    return "DeviceDefinition";
                }
                case DEVICEMETRIC: {
                    return "DeviceMetric";
                }
                case DEVICEREQUEST: {
                    return "DeviceRequest";
                }
                case DEVICEUSESTATEMENT: {
                    return "DeviceUseStatement";
                }
                case DIAGNOSTICREPORT: {
                    return "DiagnosticReport";
                }
                case DOCUMENTMANIFEST: {
                    return "DocumentManifest";
                }
                case DOCUMENTREFERENCE: {
                    return "DocumentReference";
                }
                case DOMAINRESOURCE: {
                    return "DomainResource";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case ENDPOINT: {
                    return "Endpoint";
                }
                case ENROLLMENTREQUEST: {
                    return "EnrollmentRequest";
                }
                case ENROLLMENTRESPONSE: {
                    return "EnrollmentResponse";
                }
                case EPISODEOFCARE: {
                    return "EpisodeOfCare";
                }
                case EVENTDEFINITION: {
                    return "EventDefinition";
                }
                case EVIDENCE: {
                    return "Evidence";
                }
                case EVIDENCEVARIABLE: {
                    return "EvidenceVariable";
                }
                case EXAMPLESCENARIO: {
                    return "ExampleScenario";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "ExplanationOfBenefit";
                }
                case FAMILYMEMBERHISTORY: {
                    return "FamilyMemberHistory";
                }
                case FLAG: {
                    return "Flag";
                }
                case GOAL: {
                    return "Goal";
                }
                case GRAPHDEFINITION: {
                    return "GraphDefinition";
                }
                case GROUP: {
                    return "Group";
                }
                case GUIDANCERESPONSE: {
                    return "GuidanceResponse";
                }
                case HEALTHCARESERVICE: {
                    return "HealthcareService";
                }
                case IMAGINGSTUDY: {
                    return "ImagingStudy";
                }
                case IMMUNIZATION: {
                    return "Immunization";
                }
                case IMMUNIZATIONEVALUATION: {
                    return "ImmunizationEvaluation";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "ImmunizationRecommendation";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "ImplementationGuide";
                }
                case INGREDIENT: {
                    return "Ingredient";
                }
                case INSURANCEPLAN: {
                    return "InsurancePlan";
                }
                case INVOICE: {
                    return "Invoice";
                }
                case LIBRARY: {
                    return "Library";
                }
                case LINKAGE: {
                    return "Linkage";
                }
                case LIST: {
                    return "List";
                }
                case LOCATION: {
                    return "Location";
                }
                case MANUFACTUREDITEMDEFINITION: {
                    return "ManufacturedItemDefinition";
                }
                case MEASURE: {
                    return "Measure";
                }
                case MEASUREREPORT: {
                    return "MeasureReport";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case MEDICATIONADMINISTRATION: {
                    return "MedicationAdministration";
                }
                case MEDICATIONDISPENSE: {
                    return "MedicationDispense";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "MedicationKnowledge";
                }
                case MEDICATIONREQUEST: {
                    return "MedicationRequest";
                }
                case MEDICATIONUSAGE: {
                    return "MedicationUsage";
                }
                case MEDICINALPRODUCTDEFINITION: {
                    return "MedicinalProductDefinition";
                }
                case MESSAGEDEFINITION: {
                    return "MessageDefinition";
                }
                case MESSAGEHEADER: {
                    return "MessageHeader";
                }
                case MOLECULARSEQUENCE: {
                    return "MolecularSequence";
                }
                case NAMINGSYSTEM: {
                    return "NamingSystem";
                }
                case NUTRITIONINTAKE: {
                    return "NutritionIntake";
                }
                case NUTRITIONORDER: {
                    return "NutritionOrder";
                }
                case OBSERVATION: {
                    return "Observation";
                }
                case OBSERVATIONDEFINITION: {
                    return "ObservationDefinition";
                }
                case OPERATIONDEFINITION: {
                    return "OperationDefinition";
                }
                case OPERATIONOUTCOME: {
                    return "OperationOutcome";
                }
                case ORGANIZATION: {
                    return "Organization";
                }
                case ORGANIZATIONAFFILIATION: {
                    return "OrganizationAffiliation";
                }
                case PACKAGEDPRODUCTDEFINITION: {
                    return "PackagedProductDefinition";
                }
                case PARAMETERS: {
                    return "Parameters";
                }
                case PATIENT: {
                    return "Patient";
                }
                case PAYMENTNOTICE: {
                    return "PaymentNotice";
                }
                case PAYMENTRECONCILIATION: {
                    return "PaymentReconciliation";
                }
                case PERSON: {
                    return "Person";
                }
                case PLANDEFINITION: {
                    return "PlanDefinition";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case PRACTITIONERROLE: {
                    return "PractitionerRole";
                }
                case PROCEDURE: {
                    return "Procedure";
                }
                case PROVENANCE: {
                    return "Provenance";
                }
                case QUESTIONNAIRE: {
                    return "Questionnaire";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "QuestionnaireResponse";
                }
                case REGULATEDAUTHORIZATION: {
                    return "RegulatedAuthorization";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case REQUESTGROUP: {
                    return "RequestGroup";
                }
                case RESEARCHSTUDY: {
                    return "ResearchStudy";
                }
                case RESEARCHSUBJECT: {
                    return "ResearchSubject";
                }
                case RESOURCE: {
                    return "Resource";
                }
                case RISKASSESSMENT: {
                    return "RiskAssessment";
                }
                case SCHEDULE: {
                    return "Schedule";
                }
                case SEARCHPARAMETER: {
                    return "SearchParameter";
                }
                case SERVICEREQUEST: {
                    return "ServiceRequest";
                }
                case SLOT: {
                    return "Slot";
                }
                case SPECIMEN: {
                    return "Specimen";
                }
                case SPECIMENDEFINITION: {
                    return "SpecimenDefinition";
                }
                case STRUCTUREDEFINITION: {
                    return "StructureDefinition";
                }
                case STRUCTUREMAP: {
                    return "StructureMap";
                }
                case SUBSCRIPTION: {
                    return "Subscription";
                }
                case SUBSTANCE: {
                    return "Substance";
                }
                case SUBSTANCEDEFINITION: {
                    return "SubstanceDefinition";
                }
                case SUBSTANCENUCLEICACID: {
                    return "SubstanceNucleicAcid";
                }
                case SUBSTANCEPOLYMER: {
                    return "SubstancePolymer";
                }
                case SUBSTANCEPROTEIN: {
                    return "SubstanceProtein";
                }
                case SUBSTANCEREFERENCEINFORMATION: {
                    return "SubstanceReferenceInformation";
                }
                case SUBSTANCESOURCEMATERIAL: {
                    return "SubstanceSourceMaterial";
                }
                case SUPPLYDELIVERY: {
                    return "SupplyDelivery";
                }
                case SUPPLYREQUEST: {
                    return "SupplyRequest";
                }
                case TASK: {
                    return "Task";
                }
                case TERMINOLOGYCAPABILITIES: {
                    return "TerminologyCapabilities";
                }
                case TESTREPORT: {
                    return "TestReport";
                }
                case TESTSCRIPT: {
                    return "TestScript";
                }
                case TOPIC: {
                    return "Topic";
                }
                case VALUESET: {
                    return "ValueSet";
                }
                case VERIFICATIONRESULT: {
                    return "VerificationResult";
                }
                case VISIONPRESCRIPTION: {
                    return "VisionPrescription";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACCOUNT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ACTIVITYDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ADMINISTRABLEPRODUCTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ADVERSEEVENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ALLERGYINTOLERANCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case APPOINTMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case APPOINTMENTRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case AUDITEVENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BASIC: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BINARY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BIOLOGICALLYDERIVEDPRODUCT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BODYSTRUCTURE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case BUNDLE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CAPABILITYSTATEMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CAPABILITYSTATEMENT2: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CAREPLAN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CARETEAM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CATALOGENTRY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CHARGEITEM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CHARGEITEMDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLAIM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLAIMRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLINICALIMPRESSION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CLINICALUSEISSUE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CODESYSTEM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMMUNICATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMMUNICATIONREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMPARTMENTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COMPOSITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONCEPTMAP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONDITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONDITIONDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONSENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case CONTRACT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COVERAGE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COVERAGEELIGIBILITYREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case COVERAGEELIGIBILITYRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DETECTEDISSUE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEMETRIC: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DEVICEUSESTATEMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DIAGNOSTICREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DOCUMENTMANIFEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DOCUMENTREFERENCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case DOMAINRESOURCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENCOUNTER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENDPOINT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENROLLMENTREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ENROLLMENTRESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EPISODEOFCARE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EVENTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EVIDENCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EVIDENCEVARIABLE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EXAMPLESCENARIO: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case FAMILYMEMBERHISTORY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case FLAG: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GOAL: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GRAPHDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GROUP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case GUIDANCERESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case HEALTHCARESERVICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMAGINGSTUDY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMMUNIZATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMMUNIZATIONEVALUATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case INGREDIENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case INSURANCEPLAN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case INVOICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LIBRARY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LINKAGE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LIST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case LOCATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MANUFACTUREDITEMDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEASURE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEASUREREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONADMINISTRATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONDISPENSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICATIONUSAGE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MEDICINALPRODUCTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MESSAGEDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MESSAGEHEADER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case MOLECULARSEQUENCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NAMINGSYSTEM: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NUTRITIONINTAKE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case NUTRITIONORDER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OBSERVATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OBSERVATIONDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OPERATIONDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case OPERATIONOUTCOME: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ORGANIZATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case ORGANIZATIONAFFILIATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PACKAGEDPRODUCTDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PARAMETERS: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PATIENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PAYMENTNOTICE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PAYMENTRECONCILIATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PERSON: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PLANDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PRACTITIONERROLE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PROCEDURE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case PROVENANCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case QUESTIONNAIRE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case REGULATEDAUTHORIZATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RELATEDPERSON: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case REQUESTGROUP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESEARCHSTUDY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESEARCHSUBJECT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RESOURCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case RISKASSESSMENT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SCHEDULE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SEARCHPARAMETER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SERVICEREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SLOT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SPECIMEN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SPECIMENDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case STRUCTUREDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case STRUCTUREMAP: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSCRIPTION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCE: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCEDEFINITION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCENUCLEICACID: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCEPOLYMER: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCEPROTEIN: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCEREFERENCEINFORMATION: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUBSTANCESOURCEMATERIAL: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUPPLYDELIVERY: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case SUPPLYREQUEST: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TASK: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TERMINOLOGYCAPABILITIES: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TESTREPORT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TESTSCRIPT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case TOPIC: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case VALUESET: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case VERIFICATIONRESULT: {
                    return "http://hl7.org/fhir/resource-types";
                }
                case VISIONPRESCRIPTION: {
                    return "http://hl7.org/fhir/resource-types";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACCOUNT: {
                    return "A financial tool for tracking value accrued for a particular purpose.  In the healthcare field, used to track charges for a patient, cost centers, etc.";
                }
                case ACTIVITYDEFINITION: {
                    return "This resource allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.";
                }
                case ADMINISTRABLEPRODUCTDEFINITION: {
                    return "A pharmaceutical product described in terms of its composition and dose form.";
                }
                case ADVERSEEVENT: {
                    return "An event (i.e. any change to current patient status) that may be related to unintended effects on a patient or research subject.  The unintended effects may require additional monitoring, treatment or hospitalization or may result in death.  The AdverseEvent resource also extends to potential or avoided events that could have had such effects.";
                }
                case ALLERGYINTOLERANCE: {
                    return "Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.";
                }
                case APPOINTMENT: {
                    return "A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).";
                }
                case APPOINTMENTRESPONSE: {
                    return "A reply to an appointment request for a patient and/or practitioner(s), such as a confirmation or rejection.";
                }
                case AUDITEVENT: {
                    return "A record of an event relevant for purposes such as operations, privacy, security, maintenance, and performance analysis.";
                }
                case BASIC: {
                    return "Basic is used for handling concepts not yet defined in FHIR, narrative-only resources that don't map to an existing resource, and custom resources not appropriate for inclusion in the FHIR specification.";
                }
                case BINARY: {
                    return "A resource that represents the data of a single raw artifact as digital content accessible in its native format.  A Binary resource can contain any content, whether text, image, pdf, zip archive, etc.";
                }
                case BIOLOGICALLYDERIVEDPRODUCT: {
                    return "A material substance originating from a biological entity intended to be transplanted or infused\ninto another (possibly the same) biological entity.";
                }
                case BODYSTRUCTURE: {
                    return "Record details about an anatomical structure.  This resource may be used when a coded concept does not provide the necessary detail needed for the use case.";
                }
                case BUNDLE: {
                    return "A container for a collection of resources.";
                }
                case CAPABILITYSTATEMENT: {
                    return "A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server for a particular version of FHIR that may be used as a statement of actual server functionality or a statement of required or desired server implementation.";
                }
                case CAPABILITYSTATEMENT2: {
                    return "A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server for a particular version of FHIR that may be used as a statement of actual server functionality or a statement of required or desired server implementation.";
                }
                case CAREPLAN: {
                    return "Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.";
                }
                case CARETEAM: {
                    return "The Care Team includes all the people and organizations who plan to participate in the coordination and delivery of care.";
                }
                case CATALOGENTRY: {
                    return "Catalog entries are wrappers that contextualize items included in a catalog.";
                }
                case CHARGEITEM: {
                    return "The resource ChargeItem describes the provision of healthcare provider products for a certain patient, therefore referring not only to the product, but containing in addition details of the provision, like date, time, amounts and participating organizations and persons. Main Usage of the ChargeItem is to enable the billing process and internal cost allocation.";
                }
                case CHARGEITEMDEFINITION: {
                    return "The ChargeItemDefinition resource provides the properties that apply to the (billing) codes necessary to calculate costs and prices. The properties may differ largely depending on type and realm, therefore this resource gives only a rough structure and requires profiling for each type of billing code system.";
                }
                case CLAIM: {
                    return "A provider issued list of professional services and products which have been provided, or are to be provided, to a patient which is sent to an insurer for reimbursement.";
                }
                case CLAIMRESPONSE: {
                    return "This resource provides the adjudication details from the processing of a Claim resource.";
                }
                case CLINICALIMPRESSION: {
                    return "A record of a clinical assessment performed to determine what problem(s) may affect the patient and before planning the treatments or management strategies that are best to manage a patient's condition. Assessments are often 1:1 with a clinical consultation / encounter,  but this varies greatly depending on the clinical workflow. This resource is called \"ClinicalImpression\" rather than \"ClinicalAssessment\" to avoid confusion with the recording of assessment tools such as Apgar score.";
                }
                case CLINICALUSEISSUE: {
                    return "A single item of clinical particulars - an indication, contraindication, interaction etc. for a medicinal product.";
                }
                case CODESYSTEM: {
                    return "The CodeSystem resource is used to declare the existence of and describe a code system or code system supplement and its key properties, and optionally define a part or all of its content.";
                }
                case COMMUNICATION: {
                    return "An occurrence of information being transmitted; e.g. an alert that was sent to a responsible provider, a public health agency communication to a provider/reporter in response to a case report for a reportable condition.";
                }
                case COMMUNICATIONREQUEST: {
                    return "A request to convey information; e.g. the CDS system proposes that an alert be sent to a responsible provider, the CDS system proposes that the public health agency be notified about a reportable condition.";
                }
                case COMPARTMENTDEFINITION: {
                    return "A compartment definition that defines how resources are accessed on a server.";
                }
                case COMPOSITION: {
                    return "A set of healthcare-related information that is assembled together into a single logical package that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. A Composition defines the structure and narrative content necessary for a document. However, a Composition alone does not constitute a document. Rather, the Composition must be the first entry in a Bundle where Bundle.type=document, and any other resources referenced from Composition must be included as subsequent entries in the Bundle (for example Patient, Practitioner, Encounter, etc.).";
                }
                case CONCEPTMAP: {
                    return "A statement of relationships from one set of concepts to one or more other concepts - either concepts in code systems, or data element/data element concepts, or classes in class models.";
                }
                case CONDITION: {
                    return "A clinical condition, problem, diagnosis, or other event, situation, issue, or clinical concept that has risen to a level of concern.";
                }
                case CONDITIONDEFINITION: {
                    return "A definition of a condition and information relevant to managing it.";
                }
                case CONSENT: {
                    return "A record of a healthcare consumer\u2019s  choices  or choices made on their behalf by a third party, which permits or denies identified recipient(s) or recipient role(s) to perform one or more actions within a given policy context, for specific purposes and periods of time.";
                }
                case CONTRACT: {
                    return "Legally enforceable, formally recorded unilateral or bilateral directive i.e., a policy or agreement.";
                }
                case COVERAGE: {
                    return "Financial instrument which may be used to reimburse or pay for health care products and services. Includes both insurance and self-payment.";
                }
                case COVERAGEELIGIBILITYREQUEST: {
                    return "The CoverageEligibilityRequest provides patient and insurance coverage information to an insurer for them to respond, in the form of an CoverageEligibilityResponse, with information regarding whether the stated coverage is valid and in-force and optionally to provide the insurance details of the policy.";
                }
                case COVERAGEELIGIBILITYRESPONSE: {
                    return "This resource provides eligibility and plan details from the processing of an CoverageEligibilityRequest resource.";
                }
                case DETECTEDISSUE: {
                    return "Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.";
                }
                case DEVICE: {
                    return "A type of a manufactured item that is used in the provision of healthcare without being substantially changed through that activity. The device may be a medical or non-medical device.";
                }
                case DEVICEDEFINITION: {
                    return "The characteristics, operational status and capabilities of a medical-related component of a medical device.";
                }
                case DEVICEMETRIC: {
                    return "Describes a measurement, calculation or setting capability of a medical device.";
                }
                case DEVICEREQUEST: {
                    return "Represents a request for a patient to employ a medical device. The device may be an implantable device, or an external assistive device, such as a walker.";
                }
                case DEVICEUSESTATEMENT: {
                    return "A record of a device being used by a patient where the record is the result of a report from the patient or another clinician.";
                }
                case DIAGNOSTICREPORT: {
                    return "The findings and interpretation of diagnostic  tests performed on patients, groups of patients, devices, and locations, and/or specimens derived from these. The report includes clinical context such as requesting and provider information, and some mix of atomic results, images, textual and coded interpretations, and formatted representation of diagnostic reports.";
                }
                case DOCUMENTMANIFEST: {
                    return "A collection of documents compiled for a purpose together with metadata that applies to the collection.";
                }
                case DOCUMENTREFERENCE: {
                    return "A reference to a document of any kind for any purpose. While the term \u201cdocument\u201d implies a more narrow focus, for this resource this \"document\" encompasses *any* seralized object with a mime-type, so includes formal patient centric documents (CDA), clniical notes, scanned paper, non-patient specific documents like policy text, as well as a photo, video, or audio recording acquired or used in healthcare.  The DocumentReference resource provides metadata about the document so that the document can be discovered and managed.  The actual content may be inline base64 encoded data or provided by direct reference.";
                }
                case DOMAINRESOURCE: {
                    return "A resource that includes narrative, extensions, and contained resources.";
                }
                case ENCOUNTER: {
                    return "An interaction between a patient and healthcare provider(s) for the purpose of providing healthcare service(s) or assessing the health status of a patient.";
                }
                case ENDPOINT: {
                    return "The technical details of an endpoint that can be used for electronic services, such as for web services providing XDS.b or a REST endpoint for another FHIR server. This may include any security context information.";
                }
                case ENROLLMENTREQUEST: {
                    return "This resource provides the insurance enrollment details to the insurer regarding a specified coverage.";
                }
                case ENROLLMENTRESPONSE: {
                    return "This resource provides enrollment and plan details from the processing of an EnrollmentRequest resource.";
                }
                case EPISODEOFCARE: {
                    return "An association between a patient and an organization / healthcare provider(s) during which time encounters may occur. The managing organization assumes a level of responsibility for the patient during this time.";
                }
                case EVENTDEFINITION: {
                    return "The EventDefinition resource provides a reusable description of when a particular event can occur.";
                }
                case EVIDENCE: {
                    return "This represents statistics, certainty, both the intended and actual population, and evidence variables.";
                }
                case EVIDENCEVARIABLE: {
                    return "The EvidenceVariable resource describes a \"PICO\" element that knowledge (evidence, assertion, recommendation) is about.";
                }
                case EXAMPLESCENARIO: {
                    return "Example of workflow instance.";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "This resource provides: the claim details; adjudication details from the processing of a Claim; and optionally account balance information, for informing the subscriber of the benefits provided.";
                }
                case FAMILYMEMBERHISTORY: {
                    return "Significant health conditions for a person related to the patient relevant in the context of care for the patient.";
                }
                case FLAG: {
                    return "Prospective warnings of potential issues when providing care to the patient.";
                }
                case GOAL: {
                    return "Describes the intended objective(s) for a patient, group or organization care, for example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, etc.";
                }
                case GRAPHDEFINITION: {
                    return "A formal computable definition of a graph of resources - that is, a coherent set of resources that form a graph by following references. The Graph Definition resource defines a set and makes rules about the set.";
                }
                case GROUP: {
                    return "Represents a defined collection of entities that may be discussed or acted upon collectively but which are not expected to act collectively, and are not formally or legally recognized; i.e. a collection of entities that isn't an Organization.";
                }
                case GUIDANCERESPONSE: {
                    return "A guidance response is the formal response to a guidance request, including any output parameters returned by the evaluation, as well as the description of any proposed actions to be taken.";
                }
                case HEALTHCARESERVICE: {
                    return "The details of a healthcare service available at a location.";
                }
                case IMAGINGSTUDY: {
                    return "Representation of the content produced in a DICOM imaging study. A study comprises a set of series, each of which includes a set of Service-Object Pair Instances (SOP Instances - images or other data) acquired or produced in a common context.  A series is of only one modality (e.g. X-ray, CT, MR, ultrasound), but a study may have multiple series of different modalities.";
                }
                case IMMUNIZATION: {
                    return "Describes the event of a patient being administered a vaccine or a record of an immunization as reported by a patient, a clinician or another party.";
                }
                case IMMUNIZATIONEVALUATION: {
                    return "Describes a comparison of an immunization event against published recommendations to determine if the administration is \"valid\" in relation to those  recommendations.";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "A patient's point-in-time set of recommendations (i.e. forecasting) according to a published schedule with optional supporting justification.";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "A set of rules of how a particular interoperability or standards problem is solved - typically through the use of FHIR resources. This resource is used to gather all the parts of an implementation guide into a logical whole and to publish a computable definition of all the parts.";
                }
                case INGREDIENT: {
                    return "An ingredient of a manufactured item or pharmaceutical product.";
                }
                case INSURANCEPLAN: {
                    return "Details of a Health Insurance product/plan provided by an organization.";
                }
                case INVOICE: {
                    return "Invoice containing collected ChargeItems from an Account with calculated individual and total price for Billing purpose.";
                }
                case LIBRARY: {
                    return "The Library resource is a general-purpose container for knowledge asset definitions. It can be used to describe and expose existing knowledge assets such as logic libraries and information model descriptions, as well as to describe a collection of knowledge assets.";
                }
                case LINKAGE: {
                    return "Identifies two or more records (resource instances) that refer to the same real-world \"occurrence\".";
                }
                case LIST: {
                    return "A list is a curated collection of resources.";
                }
                case LOCATION: {
                    return "Details and position information for a physical place where services are provided and resources and participants may be stored, found, contained, or accommodated.";
                }
                case MANUFACTUREDITEMDEFINITION: {
                    return "The manufactured item as contained in the packaged medicinal product.";
                }
                case MEASURE: {
                    return "The Measure resource provides the definition of a quality measure.";
                }
                case MEASUREREPORT: {
                    return "The MeasureReport resource contains the results of the calculation of a measure; and optionally a reference to the resources involved in that calculation.";
                }
                case MEDICATION: {
                    return "This resource is primarily used for the identification and definition of a medication for the purposes of prescribing, dispensing, and administering a medication as well as for making statements about medication use.";
                }
                case MEDICATIONADMINISTRATION: {
                    return "Describes the event of a patient consuming or otherwise being administered a medication.  This may be as simple as swallowing a tablet or it may be a long running infusion.  Related resources tie this event to the authorizing prescription, and the specific encounter between patient and health care practitioner.";
                }
                case MEDICATIONDISPENSE: {
                    return "Indicates that a medication product is to be or has been dispensed for a named person/patient.  This includes a description of the medication product (supply) provided and the instructions for administering the medication.  The medication dispense is the result of a pharmacy system responding to a medication order.";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "Information about a medication that is used to support knowledge.";
                }
                case MEDICATIONREQUEST: {
                    return "An order or request for both supply of the medication and the instructions for administration of the medication to a patient. The resource is called \"MedicationRequest\" rather than \"MedicationPrescription\" or \"MedicationOrder\" to generalize the use across inpatient and outpatient settings, including care plans, etc., and to harmonize with workflow patterns.";
                }
                case MEDICATIONUSAGE: {
                    return "A record of a medication that is being consumed by a patient.   A MedicationUsage may indicate that the patient may be taking the medication now or has taken the medication in the past or will be taking the medication in the future.  The source of this information can be the patient, significant other (such as a family member or spouse), or a clinician.  A common scenario where this information is captured is during the history taking process during a patient visit or stay.   The medication information may come from sources such as the patient's memory, from a prescription bottle,  or from a list of medications the patient, clinician or other party maintains. \n\nThe primary difference between a medicationusage and a medicationadministration is that the medication administration has complete administration information and is based on actual administration information from the person who administered the medication.  A medicationusage is often, if not always, less specific.  There is no required date/time when the medication was administered, in fact we only know that a source has reported the patient is taking this medication, where details such as time, quantity, or rate or even medication product may be incomplete or missing or less precise.  As stated earlier, the Medication Usage information may come from the patient's memory, from a prescription bottle or from a list of medications the patient, clinician or other party maintains.  Medication administration is more formal and is not missing detailed information.";
                }
                case MEDICINALPRODUCTDEFINITION: {
                    return "Detailed definition of a medicinal product, typically for uses other than direct patient care (e.g. regulatory use).";
                }
                case MESSAGEDEFINITION: {
                    return "Defines the characteristics of a message that can be shared between systems, including the type of event that initiates the message, the content to be transmitted and what response(s), if any, are permitted.";
                }
                case MESSAGEHEADER: {
                    return "The header for a message exchange that is either requesting or responding to an action.  The reference(s) that are the subject of the action as well as other information related to the action are typically transmitted in a bundle in which the MessageHeader resource instance is the first resource in the bundle.";
                }
                case MOLECULARSEQUENCE: {
                    return "Raw data describing a biological sequence.";
                }
                case NAMINGSYSTEM: {
                    return "A curated namespace that issues unique symbols within that namespace for the identification of concepts, people, devices, etc.  Represents a \"System\" used within the Identifier and Coding data types.";
                }
                case NUTRITIONINTAKE: {
                    return "A record of food or fluid that is being consumed by a patient.   A NutritionIntake may indicate that the patient may be consuming the food or fluid now or has consumed the food or fluid in the past.  The source of this information can be the patient, significant other (such as a family member or spouse), or a clinician.  A common scenario where this information is captured is during the history taking process during a patient visit or stay or through an app that tracks food or fluids consumed.   The consumption information may come from sources such as the patient's memory, from a nutrition label,  or from a clinician documenting observed intake.";
                }
                case NUTRITIONORDER: {
                    return "A request to supply a diet, formula feeding (enteral) or oral nutritional supplement to a patient/resident.";
                }
                case OBSERVATION: {
                    return "Measurements and simple assertions made about a patient, device or other subject.";
                }
                case OBSERVATIONDEFINITION: {
                    return "Set of definitional characteristics for a kind of observation or measurement produced or consumed by an orderable health care service.";
                }
                case OPERATIONDEFINITION: {
                    return "A formal computable definition of an operation (on the RESTful interface) or a named query (using the search interaction).";
                }
                case OPERATIONOUTCOME: {
                    return "A collection of error, warning, or information messages that result from a system action.";
                }
                case ORGANIZATION: {
                    return "A formally or informally recognized grouping of people or organizations formed for the purpose of achieving some form of collective action.  Includes companies, institutions, corporations, departments, community groups, healthcare practice groups, payer/insurer, etc.";
                }
                case ORGANIZATIONAFFILIATION: {
                    return "Defines an affiliation/assotiation/relationship between 2 distinct oganizations, that is not a part-of relationship/sub-division relationship.";
                }
                case PACKAGEDPRODUCTDEFINITION: {
                    return "A medicinal product in a container or package.";
                }
                case PARAMETERS: {
                    return "This resource is a non-persisted resource used to pass information into and back from an [operation](operations.html). It has no other use, and there is no RESTful endpoint associated with it.";
                }
                case PATIENT: {
                    return "Demographics and other administrative information about an individual or animal receiving care or other health-related services.";
                }
                case PAYMENTNOTICE: {
                    return "This resource provides the status of the payment for goods and services rendered, and the request and response resource references.";
                }
                case PAYMENTRECONCILIATION: {
                    return "This resource provides the details including amount of a payment and allocates the payment items being paid.";
                }
                case PERSON: {
                    return "Demographics and administrative information about a person independent of a specific health-related context.";
                }
                case PLANDEFINITION: {
                    return "This resource allows for the definition of various types of plans as a sharable, consumable, and executable artifact. The resource is general enough to support the description of a broad range of clinical artifacts such as clinical decision support rules, order sets and protocols.";
                }
                case PRACTITIONER: {
                    return "A person who is directly or indirectly involved in the provisioning of healthcare.";
                }
                case PRACTITIONERROLE: {
                    return "A specific set of Roles/Locations/specialties/services that a practitioner may perform at an organization for a period of time.";
                }
                case PROCEDURE: {
                    return "An action that is or was performed on or for a patient. This can be a physical intervention like an operation, or less invasive like long term services, counseling, or hypnotherapy.";
                }
                case PROVENANCE: {
                    return "Provenance of a resource is a record that describes entities and processes involved in producing and delivering or otherwise influencing that resource. Provenance provides a critical foundation for assessing authenticity, enabling trust, and allowing reproducibility. Provenance assertions are a form of contextual metadata and can themselves become important records with their own provenance. Provenance statement indicates clinical significance in terms of confidence in authenticity, reliability, and trustworthiness, integrity, and stage in lifecycle (e.g. Document Completion - has the artifact been legally authenticated), all of which may impact security, privacy, and trust policies.";
                }
                case QUESTIONNAIRE: {
                    return "A structured set of questions intended to guide the collection of answers from end-users. Questionnaires provide detailed control over order, presentation, phraseology and grouping to allow coherent, consistent data collection.";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "A structured set of questions and their answers. The questions are ordered and grouped into coherent subsets, corresponding to the structure of the grouping of the questionnaire being responded to.";
                }
                case REGULATEDAUTHORIZATION: {
                    return "The regulatory authorization of a medicinal product.";
                }
                case RELATEDPERSON: {
                    return "Information about a person that is involved in the care for a patient, but who is not the target of healthcare, nor has a formal responsibility in the care process.";
                }
                case REQUESTGROUP: {
                    return "A group of related requests that can be used to capture intended activities that have inter-dependencies such as \"give this medication after that one\".";
                }
                case RESEARCHSTUDY: {
                    return "A process where a researcher or organization plans and then executes a series of steps intended to increase the field of healthcare-related knowledge.  This includes studies of safety, efficacy, comparative effectiveness and other information about medications, devices, therapies and other interventional and investigative techniques.  A ResearchStudy involves the gathering of information about human or animal subjects.";
                }
                case RESEARCHSUBJECT: {
                    return "A physical entity which is the primary unit of operational and/or administrative interest in a study.";
                }
                case RESOURCE: {
                    return "This is the base resource type for everything.";
                }
                case RISKASSESSMENT: {
                    return "An assessment of the likely outcome(s) for a patient or other subject as well as the likelihood of each outcome.";
                }
                case SCHEDULE: {
                    return "A container for slots of time that may be available for booking appointments.";
                }
                case SEARCHPARAMETER: {
                    return "A search parameter that defines a named search item that can be used to search/filter on a resource.";
                }
                case SERVICEREQUEST: {
                    return "A record of a request for service such as diagnostic investigations, treatments, or operations to be performed.";
                }
                case SLOT: {
                    return "A slot of time on a schedule that may be available for booking appointments.";
                }
                case SPECIMEN: {
                    return "A sample to be used for analysis.";
                }
                case SPECIMENDEFINITION: {
                    return "A kind of specimen with associated set of requirements.";
                }
                case STRUCTUREDEFINITION: {
                    return "A definition of a FHIR structure. This resource is used to describe the underlying resources, data types defined in FHIR, and also for describing extensions and constraints on resources and data types.";
                }
                case STRUCTUREMAP: {
                    return "A Map of relationships between 2 structures that can be used to transform data.";
                }
                case SUBSCRIPTION: {
                    return "The subscription resource describes a particular client's request to be notified about a Topic.";
                }
                case SUBSTANCE: {
                    return "A homogeneous material with a definite composition.";
                }
                case SUBSTANCEDEFINITION: {
                    return "The detailed description of a substance, typically at a level beyond what is used for prescribing.";
                }
                case SUBSTANCENUCLEICACID: {
                    return "Nucleic acids are defined by three distinct elements: the base, sugar and linkage. Individual substance/moiety IDs will be created for each of these elements. The nucleotide sequence will be always entered in the 5\u2019-3\u2019 direction.";
                }
                case SUBSTANCEPOLYMER: {
                    return "Todo.";
                }
                case SUBSTANCEPROTEIN: {
                    return "A SubstanceProtein is defined as a single unit of a linear amino acid sequence, or a combination of subunits that are either covalently linked or have a defined invariant stoichiometric relationship. This includes all synthetic, recombinant and purified SubstanceProteins of defined sequence, whether the use is therapeutic or prophylactic. This set of elements will be used to describe albumins, coagulation factors, cytokines, growth factors, peptide/SubstanceProtein hormones, enzymes, toxins, toxoids, recombinant vaccines, and immunomodulators.";
                }
                case SUBSTANCEREFERENCEINFORMATION: {
                    return "Todo.";
                }
                case SUBSTANCESOURCEMATERIAL: {
                    return "Source material shall capture information on the taxonomic and anatomical origins as well as the fraction of a material that can result in or can be modified to form a substance. This set of data elements shall be used to define polymer substances isolated from biological matrices. Taxonomic and anatomical origins shall be described using a controlled vocabulary as required. This information is captured for naturally derived polymers ( . starch) and structurally diverse substances. For Organisms belonging to the Kingdom Plantae the Substance level defines the fresh material of a single species or infraspecies, the Herbal Drug and the Herbal preparation. For Herbal preparations, the fraction information will be captured at the Substance information level and additional information for herbal extracts will be captured at the Specified Substance Group 1 information level. See for further explanation the Substance Class: Structurally Diverse and the herbal annex.";
                }
                case SUPPLYDELIVERY: {
                    return "Record of delivery of what is supplied.";
                }
                case SUPPLYREQUEST: {
                    return "A record of a request for a medication, substance or device used in the healthcare setting.";
                }
                case TASK: {
                    return "A task to be performed.";
                }
                case TERMINOLOGYCAPABILITIES: {
                    return "A TerminologyCapabilities resource documents a set of capabilities (behaviors) of a FHIR Terminology Server that may be used as a statement of actual server functionality or a statement of required or desired server implementation.";
                }
                case TESTREPORT: {
                    return "A summary of information based on the results of executing a TestScript.";
                }
                case TESTSCRIPT: {
                    return "A structured set of tests against a FHIR server or client implementation to determine compliance against the FHIR specification.";
                }
                case TOPIC: {
                    return "Describes a stream of resource state changes identified by trigger criteria and annotated with labels useful to filter projections from this topic.";
                }
                case VALUESET: {
                    return "A ValueSet resource instance specifies a set of codes drawn from one or more code systems, intended for use in a particular context. Value sets link between [[[CodeSystem]]] definitions and their use in [coded elements](terminologies.html).";
                }
                case VERIFICATIONRESULT: {
                    return "Describes validation requirements, source(s), status and dates for one or more elements.";
                }
                case VISIONPRESCRIPTION: {
                    return "An authorization for the provision of glasses and/or contact lenses to a patient.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACCOUNT: {
                    return "Account";
                }
                case ACTIVITYDEFINITION: {
                    return "ActivityDefinition";
                }
                case ADMINISTRABLEPRODUCTDEFINITION: {
                    return "AdministrableProductDefinition";
                }
                case ADVERSEEVENT: {
                    return "AdverseEvent";
                }
                case ALLERGYINTOLERANCE: {
                    return "AllergyIntolerance";
                }
                case APPOINTMENT: {
                    return "Appointment";
                }
                case APPOINTMENTRESPONSE: {
                    return "AppointmentResponse";
                }
                case AUDITEVENT: {
                    return "AuditEvent";
                }
                case BASIC: {
                    return "Basic";
                }
                case BINARY: {
                    return "Binary";
                }
                case BIOLOGICALLYDERIVEDPRODUCT: {
                    return "BiologicallyDerivedProduct";
                }
                case BODYSTRUCTURE: {
                    return "BodyStructure";
                }
                case BUNDLE: {
                    return "Bundle";
                }
                case CAPABILITYSTATEMENT: {
                    return "CapabilityStatement";
                }
                case CAPABILITYSTATEMENT2: {
                    return "CapabilityStatement2";
                }
                case CAREPLAN: {
                    return "CarePlan";
                }
                case CARETEAM: {
                    return "CareTeam";
                }
                case CATALOGENTRY: {
                    return "CatalogEntry";
                }
                case CHARGEITEM: {
                    return "ChargeItem";
                }
                case CHARGEITEMDEFINITION: {
                    return "ChargeItemDefinition";
                }
                case CLAIM: {
                    return "Claim";
                }
                case CLAIMRESPONSE: {
                    return "ClaimResponse";
                }
                case CLINICALIMPRESSION: {
                    return "ClinicalImpression";
                }
                case CLINICALUSEISSUE: {
                    return "ClinicalUseIssue";
                }
                case CODESYSTEM: {
                    return "CodeSystem";
                }
                case COMMUNICATION: {
                    return "Communication";
                }
                case COMMUNICATIONREQUEST: {
                    return "CommunicationRequest";
                }
                case COMPARTMENTDEFINITION: {
                    return "CompartmentDefinition";
                }
                case COMPOSITION: {
                    return "Composition";
                }
                case CONCEPTMAP: {
                    return "ConceptMap";
                }
                case CONDITION: {
                    return "Condition";
                }
                case CONDITIONDEFINITION: {
                    return "ConditionDefinition";
                }
                case CONSENT: {
                    return "Consent";
                }
                case CONTRACT: {
                    return "Contract";
                }
                case COVERAGE: {
                    return "Coverage";
                }
                case COVERAGEELIGIBILITYREQUEST: {
                    return "CoverageEligibilityRequest";
                }
                case COVERAGEELIGIBILITYRESPONSE: {
                    return "CoverageEligibilityResponse";
                }
                case DETECTEDISSUE: {
                    return "DetectedIssue";
                }
                case DEVICE: {
                    return "Device";
                }
                case DEVICEDEFINITION: {
                    return "DeviceDefinition";
                }
                case DEVICEMETRIC: {
                    return "DeviceMetric";
                }
                case DEVICEREQUEST: {
                    return "DeviceRequest";
                }
                case DEVICEUSESTATEMENT: {
                    return "DeviceUseStatement";
                }
                case DIAGNOSTICREPORT: {
                    return "DiagnosticReport";
                }
                case DOCUMENTMANIFEST: {
                    return "DocumentManifest";
                }
                case DOCUMENTREFERENCE: {
                    return "DocumentReference";
                }
                case DOMAINRESOURCE: {
                    return "DomainResource";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case ENDPOINT: {
                    return "Endpoint";
                }
                case ENROLLMENTREQUEST: {
                    return "EnrollmentRequest";
                }
                case ENROLLMENTRESPONSE: {
                    return "EnrollmentResponse";
                }
                case EPISODEOFCARE: {
                    return "EpisodeOfCare";
                }
                case EVENTDEFINITION: {
                    return "EventDefinition";
                }
                case EVIDENCE: {
                    return "Evidence";
                }
                case EVIDENCEVARIABLE: {
                    return "EvidenceVariable";
                }
                case EXAMPLESCENARIO: {
                    return "ExampleScenario";
                }
                case EXPLANATIONOFBENEFIT: {
                    return "ExplanationOfBenefit";
                }
                case FAMILYMEMBERHISTORY: {
                    return "FamilyMemberHistory";
                }
                case FLAG: {
                    return "Flag";
                }
                case GOAL: {
                    return "Goal";
                }
                case GRAPHDEFINITION: {
                    return "GraphDefinition";
                }
                case GROUP: {
                    return "Group";
                }
                case GUIDANCERESPONSE: {
                    return "GuidanceResponse";
                }
                case HEALTHCARESERVICE: {
                    return "HealthcareService";
                }
                case IMAGINGSTUDY: {
                    return "ImagingStudy";
                }
                case IMMUNIZATION: {
                    return "Immunization";
                }
                case IMMUNIZATIONEVALUATION: {
                    return "ImmunizationEvaluation";
                }
                case IMMUNIZATIONRECOMMENDATION: {
                    return "ImmunizationRecommendation";
                }
                case IMPLEMENTATIONGUIDE: {
                    return "ImplementationGuide";
                }
                case INGREDIENT: {
                    return "Ingredient";
                }
                case INSURANCEPLAN: {
                    return "InsurancePlan";
                }
                case INVOICE: {
                    return "Invoice";
                }
                case LIBRARY: {
                    return "Library";
                }
                case LINKAGE: {
                    return "Linkage";
                }
                case LIST: {
                    return "List";
                }
                case LOCATION: {
                    return "Location";
                }
                case MANUFACTUREDITEMDEFINITION: {
                    return "ManufacturedItemDefinition";
                }
                case MEASURE: {
                    return "Measure";
                }
                case MEASUREREPORT: {
                    return "MeasureReport";
                }
                case MEDICATION: {
                    return "Medication";
                }
                case MEDICATIONADMINISTRATION: {
                    return "MedicationAdministration";
                }
                case MEDICATIONDISPENSE: {
                    return "MedicationDispense";
                }
                case MEDICATIONKNOWLEDGE: {
                    return "MedicationKnowledge";
                }
                case MEDICATIONREQUEST: {
                    return "MedicationRequest";
                }
                case MEDICATIONUSAGE: {
                    return "MedicationUsage";
                }
                case MEDICINALPRODUCTDEFINITION: {
                    return "MedicinalProductDefinition";
                }
                case MESSAGEDEFINITION: {
                    return "MessageDefinition";
                }
                case MESSAGEHEADER: {
                    return "MessageHeader";
                }
                case MOLECULARSEQUENCE: {
                    return "MolecularSequence";
                }
                case NAMINGSYSTEM: {
                    return "NamingSystem";
                }
                case NUTRITIONINTAKE: {
                    return "NutritionIntake";
                }
                case NUTRITIONORDER: {
                    return "NutritionOrder";
                }
                case OBSERVATION: {
                    return "Observation";
                }
                case OBSERVATIONDEFINITION: {
                    return "ObservationDefinition";
                }
                case OPERATIONDEFINITION: {
                    return "OperationDefinition";
                }
                case OPERATIONOUTCOME: {
                    return "OperationOutcome";
                }
                case ORGANIZATION: {
                    return "Organization";
                }
                case ORGANIZATIONAFFILIATION: {
                    return "OrganizationAffiliation";
                }
                case PACKAGEDPRODUCTDEFINITION: {
                    return "PackagedProductDefinition";
                }
                case PARAMETERS: {
                    return "Parameters";
                }
                case PATIENT: {
                    return "Patient";
                }
                case PAYMENTNOTICE: {
                    return "PaymentNotice";
                }
                case PAYMENTRECONCILIATION: {
                    return "PaymentReconciliation";
                }
                case PERSON: {
                    return "Person";
                }
                case PLANDEFINITION: {
                    return "PlanDefinition";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case PRACTITIONERROLE: {
                    return "PractitionerRole";
                }
                case PROCEDURE: {
                    return "Procedure";
                }
                case PROVENANCE: {
                    return "Provenance";
                }
                case QUESTIONNAIRE: {
                    return "Questionnaire";
                }
                case QUESTIONNAIRERESPONSE: {
                    return "QuestionnaireResponse";
                }
                case REGULATEDAUTHORIZATION: {
                    return "RegulatedAuthorization";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case REQUESTGROUP: {
                    return "RequestGroup";
                }
                case RESEARCHSTUDY: {
                    return "ResearchStudy";
                }
                case RESEARCHSUBJECT: {
                    return "ResearchSubject";
                }
                case RESOURCE: {
                    return "Resource";
                }
                case RISKASSESSMENT: {
                    return "RiskAssessment";
                }
                case SCHEDULE: {
                    return "Schedule";
                }
                case SEARCHPARAMETER: {
                    return "SearchParameter";
                }
                case SERVICEREQUEST: {
                    return "ServiceRequest";
                }
                case SLOT: {
                    return "Slot";
                }
                case SPECIMEN: {
                    return "Specimen";
                }
                case SPECIMENDEFINITION: {
                    return "SpecimenDefinition";
                }
                case STRUCTUREDEFINITION: {
                    return "StructureDefinition";
                }
                case STRUCTUREMAP: {
                    return "StructureMap";
                }
                case SUBSCRIPTION: {
                    return "Subscription";
                }
                case SUBSTANCE: {
                    return "Substance";
                }
                case SUBSTANCEDEFINITION: {
                    return "SubstanceDefinition";
                }
                case SUBSTANCENUCLEICACID: {
                    return "SubstanceNucleicAcid";
                }
                case SUBSTANCEPOLYMER: {
                    return "SubstancePolymer";
                }
                case SUBSTANCEPROTEIN: {
                    return "SubstanceProtein";
                }
                case SUBSTANCEREFERENCEINFORMATION: {
                    return "SubstanceReferenceInformation";
                }
                case SUBSTANCESOURCEMATERIAL: {
                    return "SubstanceSourceMaterial";
                }
                case SUPPLYDELIVERY: {
                    return "SupplyDelivery";
                }
                case SUPPLYREQUEST: {
                    return "SupplyRequest";
                }
                case TASK: {
                    return "Task";
                }
                case TERMINOLOGYCAPABILITIES: {
                    return "TerminologyCapabilities";
                }
                case TESTREPORT: {
                    return "TestReport";
                }
                case TESTSCRIPT: {
                    return "TestScript";
                }
                case TOPIC: {
                    return "Topic";
                }
                case VALUESET: {
                    return "ValueSet";
                }
                case VERIFICATIONRESULT: {
                    return "VerificationResult";
                }
                case VISIONPRESCRIPTION: {
                    return "VisionPrescription";
                }
            }
            return "?";
        }
    }
}

