/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Range;
import org.hl7.fhir.r5.model.Type;

@DatatypeDef(name="Population")
public class Population
extends BackboneType
implements ICompositeType {
    @Child(name="age", type={Range.class, CodeableConcept.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The age of the specific population", formalDefinition="The age of the specific population.")
    protected Type age;
    @Child(name="gender", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The gender of the specific population", formalDefinition="The gender of the specific population.")
    protected CodeableConcept gender;
    @Child(name="race", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Race of the specific population", formalDefinition="Race of the specific population.")
    protected CodeableConcept race;
    @Child(name="physiologicalCondition", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The existing physiological conditions of the specific population to which this applies", formalDefinition="The existing physiological conditions of the specific population to which this applies.")
    protected CodeableConcept physiologicalCondition;
    private static final long serialVersionUID = 495777760L;

    public Type getAge() {
        return this.age;
    }

    public Range getAgeRange() throws FHIRException {
        if (this.age == null) {
            this.age = new Range();
        }
        if (!(this.age instanceof Range)) {
            throw new FHIRException("Type mismatch: the type Range was expected, but " + this.age.getClass().getName() + " was encountered");
        }
        return (Range)this.age;
    }

    public boolean hasAgeRange() {
        return this != null && this.age instanceof Range;
    }

    public CodeableConcept getAgeCodeableConcept() throws FHIRException {
        if (this.age == null) {
            this.age = new CodeableConcept();
        }
        if (!(this.age instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.age.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.age;
    }

    public boolean hasAgeCodeableConcept() {
        return this != null && this.age instanceof CodeableConcept;
    }

    public boolean hasAge() {
        return this.age != null && !this.age.isEmpty();
    }

    public Population setAge(Type value) {
        if (value != null && !(value instanceof Range) && !(value instanceof CodeableConcept)) {
            throw new Error("Not the right type for Population.age[x]: " + value.fhirType());
        }
        this.age = value;
        return this;
    }

    public CodeableConcept getGender() {
        if (this.gender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Population.gender");
            }
            if (Configuration.doAutoCreate()) {
                this.gender = new CodeableConcept();
            }
        }
        return this.gender;
    }

    public boolean hasGender() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public Population setGender(CodeableConcept value) {
        this.gender = value;
        return this;
    }

    public CodeableConcept getRace() {
        if (this.race == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Population.race");
            }
            if (Configuration.doAutoCreate()) {
                this.race = new CodeableConcept();
            }
        }
        return this.race;
    }

    public boolean hasRace() {
        return this.race != null && !this.race.isEmpty();
    }

    public Population setRace(CodeableConcept value) {
        this.race = value;
        return this;
    }

    public CodeableConcept getPhysiologicalCondition() {
        if (this.physiologicalCondition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Population.physiologicalCondition");
            }
            if (Configuration.doAutoCreate()) {
                this.physiologicalCondition = new CodeableConcept();
            }
        }
        return this.physiologicalCondition;
    }

    public boolean hasPhysiologicalCondition() {
        return this.physiologicalCondition != null && !this.physiologicalCondition.isEmpty();
    }

    public Population setPhysiologicalCondition(CodeableConcept value) {
        this.physiologicalCondition = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age));
        children.add(new Property("gender", "CodeableConcept", "The gender of the specific population.", 0, 1, this.gender));
        children.add(new Property("race", "CodeableConcept", "Race of the specific population.", 0, 1, this.race));
        children.add(new Property("physiologicalCondition", "CodeableConcept", "The existing physiological conditions of the specific population to which this applies.", 0, 1, this.physiologicalCondition));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1419716831: {
                return new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age);
            }
            case 96511: {
                return new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age);
            }
            case 1442748286: {
                return new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age);
            }
            case -1452658526: {
                return new Property("age[x]", "Range|CodeableConcept", "The age of the specific population.", 0, 1, this.age);
            }
            case -1249512767: {
                return new Property("gender", "CodeableConcept", "The gender of the specific population.", 0, 1, this.gender);
            }
            case 3492561: {
                return new Property("race", "CodeableConcept", "Race of the specific population.", 0, 1, this.race);
            }
            case -62715190: {
                return new Property("physiologicalCondition", "CodeableConcept", "The existing physiological conditions of the specific population to which this applies.", 0, 1, this.physiologicalCondition);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 96511: {
                Base[] baseArray;
                if (this.age == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.age;
                }
                return baseArray;
            }
            case -1249512767: {
                Base[] baseArray;
                if (this.gender == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.gender;
                }
                return baseArray;
            }
            case 3492561: {
                Base[] baseArray;
                if (this.race == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.race;
                }
                return baseArray;
            }
            case -62715190: {
                Base[] baseArray;
                if (this.physiologicalCondition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.physiologicalCondition;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 96511: {
                this.age = this.castToType(value);
                return value;
            }
            case -1249512767: {
                this.gender = this.castToCodeableConcept(value);
                return value;
            }
            case 3492561: {
                this.race = this.castToCodeableConcept(value);
                return value;
            }
            case -62715190: {
                this.physiologicalCondition = this.castToCodeableConcept(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("age[x]")) {
            this.age = this.castToType(value);
        } else if (name.equals("gender")) {
            this.gender = this.castToCodeableConcept(value);
        } else if (name.equals("race")) {
            this.race = this.castToCodeableConcept(value);
        } else if (name.equals("physiologicalCondition")) {
            this.physiologicalCondition = this.castToCodeableConcept(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1419716831: {
                return this.getAge();
            }
            case 96511: {
                return this.getAge();
            }
            case -1249512767: {
                return this.getGender();
            }
            case 3492561: {
                return this.getRace();
            }
            case -62715190: {
                return this.getPhysiologicalCondition();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 96511: {
                return new String[]{"Range", "CodeableConcept"};
            }
            case -1249512767: {
                return new String[]{"CodeableConcept"};
            }
            case 3492561: {
                return new String[]{"CodeableConcept"};
            }
            case -62715190: {
                return new String[]{"CodeableConcept"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("ageRange")) {
            this.age = new Range();
            return this.age;
        }
        if (name.equals("ageCodeableConcept")) {
            this.age = new CodeableConcept();
            return this.age;
        }
        if (name.equals("gender")) {
            this.gender = new CodeableConcept();
            return this.gender;
        }
        if (name.equals("race")) {
            this.race = new CodeableConcept();
            return this.race;
        }
        if (name.equals("physiologicalCondition")) {
            this.physiologicalCondition = new CodeableConcept();
            return this.physiologicalCondition;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Population";
    }

    @Override
    public Population copy() {
        Population dst = new Population();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Population dst) {
        super.copyValues(dst);
        dst.age = this.age == null ? null : this.age.copy();
        dst.gender = this.gender == null ? null : this.gender.copy();
        dst.race = this.race == null ? null : this.race.copy();
        dst.physiologicalCondition = this.physiologicalCondition == null ? null : this.physiologicalCondition.copy();
    }

    @Override
    protected Population typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Population)) {
            return false;
        }
        Population o = (Population)other_;
        return Population.compareDeep(this.age, o.age, true) && Population.compareDeep(this.gender, o.gender, true) && Population.compareDeep(this.race, o.race, true) && Population.compareDeep(this.physiologicalCondition, o.physiologicalCondition, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Population)) {
            return false;
        }
        Population o = (Population)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.age, this.gender, this.race, this.physiologicalCondition});
    }
}

